/*
 *	lib.cxx
 *
 *	Standard Smaky Library interface
 *
 *	(C)	1994 Daniel MARMIER
 */

#include "lib.h"


void
Lib::WAsskey (WAsskeyRecord& rec, NtrSync& sem)
{
	asm ( "movel %0,a4\n\t"
		  "movel %1,d5\n\t"
		  "exg   d5,a5\n\t"
		  ".long 0x4E4600AE\n\t"
		  "exg   d5,a5"
		:
		: "g" (&rec), "g" (sem.GetSem ())
		: "d5", "d7", "a4" );
}


void
Lib::WMenu (WMenuRecord& rec, NtrSync& sem)
{
	asm ( "movel %0,a4\n\t"
		  "movel %1,d5\n\t"
		  "exg   d5,a5\n\t"
		  ".long 0x4E4600AF\n\t"
		  "exg   d5,a5"
		:
		: "g" (&rec), "g" (sem.GetSem ())
		: "d5", "d7", "a4" );
}

DisDesc*
Lib::GetPDis ()
{
	DisDesc* dd;
	asm (	".long	0x4e460092\n\t"
			"movel	a4,%0\n\t"
			: "=g" (dd)
			:
			: "d7", "a4" );
	return dd;
}

Card16
Lib::GChKey (void)
{
	Card16 chkey;
	asm (	".long	0x4e460023\n\t"
			"movew	d6,%0\n\t"
			: "=g" (chkey)
			:
			: "d6", "d7" );
	return chkey;
}

Card16
Lib::AssBitmap (const void* desc, Card8 pixmap)
{
	Card16 err;
	asm (	"moveb	%1,d3\n\t"
			"movel	%2,a2\n\t"
			".long	0x4e46006c\n\t"
			"movew	d7,%0\n\t"
			: "=g" (err)
			: "g" (pixmap), "g" (desc)
			: "d3", "d7", "a2" );
	return err;
}

Card16
Lib::AssKey (Card16 keynum)
{
	Card16 err;
	asm (	"movew	%1,d3\n\t"
			".long	0x4e460032\n\t"
			"movew	d7,%0\n\t"
			: "=g" (err)
			: "g" (keynum)
			: "d3", "d7" );
	return err;
}

Card16
Lib::VAssKey (Card16& kbd_num)
{
	Card16 err;
	asm (	".long	0x4e460046	\n\t"
			"movew	d3,%0		\n\t"
			"movew	d7,%1		\n\t"
			: "=g" (kbd_num), "=g" (err)
			:
			: "d3", "d7" );
	return err;
}

Card16
Lib::SrcKNP (Card16 kbd_num, Card16& proc_num, const char*& proc_name)
{
	Card16 err;
	asm (	"movew	%3,d3		\n\t"
			".long	0x4e460070	\n\t"
			"movew	d4,%0		\n\t"
			"movel	a4,%1		\n\t"
			"movew	d7,%2		\n\t"
			: "=g" (proc_num), "=g" (proc_name), "=g" (err)
			: "g" (kbd_num)
			: "d3", "d4", "d7", "a4" );
	return err;
}

Card16
Lib::SrcCHK (Card16 kbd_num, Card16& kbd_chan)
{
	Card16 err;
	asm (	"movew	%2,d3		\n\t"
			".long	0x4e460068	\n\t"
			"movew	d6,%0		\n\t"
			"movel	d7,%1		\n\t"
			: "=g" (kbd_chan), "=g" (err)
			: "g" (kbd_num)
			: "d3", "d4", "d6", "d7", "a4" );
	return err;
}

Card16
Lib::WrAKey (Card32 key)
{
	Card16 err;
	asm (	"movel	%1,d3\n\t"
			".long	0x4e46006E\n\t"
			"movew	d7,%0\n\t"
		: "=g" (err)
		: "g" (key)
		: "d3", "d7" );
	return err;
}

void
Lib::Mouse (Card8 mode)
{
	asm (	"moveb	%0,d3\n\t"
			".long	0x4e460047\n\t"
		:
		: "g" (mode)
		: "d3", "d7" );
}

void
Lib::WaitMouse (Card16 mode)
{
	asm (	"movew	%0,d4\n\t"
			".long	0x4e460069\n\t"
		:
		: "g" (mode)
		: "d4", "d7" );
}

Card16
Lib::RdMouse (Card32* pos, Card8* state)
{
	Card16 err;
	asm (	".long	0x4e460036\n\t"
			"movel	d4,%1\n\t"
			"moveb	d3,%2\n\t"
			"movew	d7,%0\n\t"
		: "=g" (err), "=g" (*pos), "=g" (*state)
		:
		: "d3", "d4", "d7" );
	return err;
}

Card16
Lib::SpyMouse (Card32* pos, Card8* buttons)
{
	Card16 err;
	asm (	".long	0x4e4600b0\n\t"
			"movel	d4,%1\n\t"
			"moveb	d3,%2\n\t"
			"movew	d7,%0\n\t"
		: "=g" (err), "=g" (*pos), "=g" (*buttons)
		:
		: "d3", "d4", "d7" );
	return err;
}

void
Lib::Beep (Card8 bip)
{
	asm (	"moveb	%0,d3\n\t"
		".long	0x4e460016\n\t"
		:
		: "g" (bip)
		: "d3", "d7" );
}


Card16
Lib::GetUPh (const char* uname, const char** physname)
{
	Card16 err;
	asm (	"movel	%2,a3\n\t"
		".long	0x4e460027\n\t"
		"movel	a4,%0\n\t"
		"movew	d7,%1\n\t"
		: "=g" (*physname), "=g" (err)
		: "g" (uname)
		: "d7", "a3", "a4" );
	return err;
}

Card16
Lib::PFDump (const char* file, Card8 display)
{
	Card16 err;
	asm (	"movel	%1,a3\n\t"
			"moveb	%2,d3\n\t"
			".long	0x4e460066\n\t"		// @PA
			"movew	d7,%0\n\t"
		: "=g" (err)
		: "g" (file), "g" (display)
		: "d3", "d7", "a3" );
	return err;
}

Card16
Lib::SetCurs (Pos pos)
{
	Card16 err;
	asm (	"movew	%1,d3		\n\t"
			"swap   d3			\n\t"
			"movew	%2,d3		\n\t"
			".long	0x4e46001c	\n\t"
			"movew	d7,%0\n\t"
		: "=g" (err)
		: "g" (pos.y), "g" (pos.x)
		: "d3", "d7" );
	return err;
}

Card16
Lib::AfText (const char *text)
{
	Card16 err;
	asm (	"movel	%1,a3		\n\t"
			".long	0x4e460008	\n\t"
			"movew	d7,%0\n\t"
		: "=g" (err)
		: "g" (text)
		: "a3", "d7" );
	return err;
}

