/*
 *	lib.h
 *
 *	Standard Smaky Library interface
 *
 *	(C)	1994 Daniel MARMIER
 */

/*
 *	Erik BRUCHEZ	january  1995 :	added VAssKey
 *									added SrcKNP
 */

#ifndef _LIB_H_
#define	_LIB_H_

#include "ntrel.h"
#include "gra.h"


/*
 *	Lib::Beep ()
 */

#define	BIPLIT	(1)
#define	BIPEND	(2)
#define	BIPYES	(3)
#define	BIPBIG	(4)
#define	BIPERR	(5)
#define	BIPFAT	(6)
#define	BIPDON	(7)

/*
 *	Key codes
 */

#define BS			0x08
#define CR			0x0D
#define SCR			0x0C
#define CCR			0x0A
#define TAB			0x09
#define STAB		0x0B
#define CTAB		0x03
#define LF			0x0A
#define SPACE		0x20
#define CSPACE		0x02
#define DEL			0x7F

#define BSHIFT		5
#define BCTRL		6

#define SHIFT		(1L<<BSHIFT)
#define CTRL		(1L<<BCTRL)

#define F0		0x80
#define F1		0x81
#define F2		0x82
#define F3		0x83
#define F4		0x84
#define F5		0x85
#define F6		0x86
#define F7		0x87
#define F8		0x88
#define F9		0x89
#define F10		0x8A
#define F11		0x8B
#define F12		0x8C
#define F13		0x8D
#define F14		0x8E
#define F15		0x8F
#define	UNDO		0x90
#define	HELP		0x91
#define	END			0x92
#define	MACRO		0x93
#define	FNCT		0x94
#define	DEFINE		0x95
#define POINT		0x97
#define	ENTER		0x98
#define	TRIZERO		0x99
#define	DELETE		0x9E
#define	CLEAR		0x9F

/*
 *	Mouse-generated codes when mouse in modes 2 and 3
 */

#define KEYMGP		0x7f01
#define KEYMMP		0x7f02
#define	KEYMDP		0x7f04
#define KEYMGR		0x7f11
#define	KEYMMR		0x7f12
#define KEYMDR		0x7f14
#define	KEYMPO		0x7f00

/*
 *	Super-shift keys
 */

#define	KCURSOR		(1L<<6)
#define	KCOPY		(1L<<5)
#define	KKILL		(1L<<4)
#define	KPROGRA		(1L<<3)
#define	KSHOW		(1L<<2)
#define	KSEARCH		(1L<<1)
#define	KCHANGE		(1L<<0)

/*
 *	Mouse buttons
 */

#define BUTTON_LEFT		(1<<4)
#define BUTTON_MIDDLE	(1<<6)
#define BUTTON_RIGHT	(1<<5)

/*
 *	Structure for WAsskey
 */

struct WAsskeyRecord
{
	Card16		display_num;		//	$DIS driver number
	Card16		keyboard_num;		//	$KEY driver number
	Card16		display_chan;		//	$DIS driver channel
	Card16		keyboard_chan;		//	$KEY driver channel
	void*		display_desc;		//	^ $DIS descriptor
	Bool		use_mouse;			//	TRUE => use mouse
	Bool		key_mouse;			//	TRUE => mouse from keyboard
	Card8		r1, r2;				//	reserve
};

/*
 *	Structure for WMenu
 */

struct WMenuRecord
{
	const char*	text;				//	^ 12 x .ASCIZ
	Card16		bar_bitset;			//	bars bitset
	Card16		access_num;			//	number of accesses
};


/*
 *	Standard Smaky Library static class interface
 */

struct DisDesc;

class Lib
{

public:
	static void		WAsskey (WAsskeyRecord& rec, NtrSync& sem);
	static void		WMenu (WMenuRecord& rec, NtrSync& sem);
	
	static DisDesc	*GetPDis ();
	static Card16	GChKey (void);
	static Card16	AssBitmap (const void* desc, Card8 pixmap);
	static Card16	AssKey (Card16 keynum);
	static Card16	VAssKey (Card16& kbd_num);
	static Card16	SrcKNP (Card16 kbd_num, Card16& proc_num, const char*& proc_name);
	static Card16	SrcCHK (Card16 kbd_num, Card16& kbd_chan);
	static Card16	WrAKey (Card32 key);

	static void		Mouse (Card8 mode);
	static void		WaitMouse (Card16 mode);
	static Card16	RdMouse (Card32* pos, Card8* state);
	static Card16	SpyMouse (Card32* pos, Card8* state);

	static void		Beep (Card8 bip);
	
	static Card16	GetUPh (const char* uname, const char** physname);
	static Card16	PFDump (const char* file, Card8 display);
	
	static Card16	SetCurs (Pos pos);
	static Card16	AfText (const char *text);
};


#endif /* _LIB_H_ */

