/*
 *	lookman.h
 *
 *	Little look manager for SMA_SMAKY
 *
 *	(C)	1995 Erik BRUCHEZ
 */

#ifndef _LOOK_MAN_H_
#define _LOOK_MAN_H_

#include "gra.h"
#include "tcolor.h"
#include "iconsbar.h"

enum SSColor
{
	SSWHITE 	= 0,	//	white
	SSLGRAY		= 1,	//	light gray
	SSMGRAY		= 2,	//	middle gray
	SSDGRAY		= 3,	//	dark gray
	SSBLACK		= 4,	//	black
	
	SSBGMENU	= 5,	//	menu background
	SSBGSK		= 6,	//	softkeys background
	SSINSK		= 7,	//	softkeys interior
	SSMEM		= 8,	//	memory jauge
	SSCPU		= 9,	//	cpu jauge
	SSRED		= 10,	//	adornment 1 (red)
	SSGREEN		= 11,	//	adornment 2 (green)
	SSBLUE		= 12,	//	adornment 3 (blue)
	SSCLTXT		= 13,	//	clock text
	SSCAPSTXT	= 14,	//	"caps" text
	SSSKTXT		= 15,	//	softkeys text
	SSMSGTXT	= 16,	//	messages text
	SSSKBARS	= 17,	//	softkeys bars
	SSNET		= 18,	//	network arrows
	SSBGMEM		= 19,	//	memory jauge background
	SSBGCPU		= 20,	//	cpu jauge background
	
	SSGRAY1		= 21,
	SSGRAY2		= 22,
	SSGRAY3		= 23,
	SSGRAY4		= 24,
	SSGRAY5		= 25
};

#define SS_COL_NUM 		(SSGRAY5 + 1)
#define	SS_COL_AUTO_NUM	(SS_COL_NUM-5)

struct ImageDescr
{
	Box		box;			// image box
	void	*data;			// image data
	Card16	bwidth;			// image width in bytes
	Card32	datalen;		// data length
};

struct CIconInfo
{
	Bool	is_free;
	Bool	has_mono;
	Bool	has_color;
	Card8	size_num;
	Card8	location[2];
};

class LookMan {
	
	Gra		*gra;
	TColor	tcolor;
	
	void	*cdata;
	void	*ccdata;
	Card8	depth;
	Bool	use_color;
	
	Card32	colors[SS_COL_NUM];
	
	TCClut	*clut16;
	Card8	ctable[16];
	
	//	Static members
		
	static Gra			*ggra;		// any valid gra for Init
	
	static ImageDescr	mimage;		// monochrome image
	static ImageDescr	cimage;		// color image
	static ImageDescr	himage;		// high color image
	
	static void*		clut;		// color image clut
	static void*		hclut;		// high color image clut
	static Bool			force_mono;	// force monochrome drawing
	
	//	Static members for custom icons management
	
	static ImageDescr	cmimage;	// bitmap for custom monochrome icons
	static ImageDescr	ccimage;	// color pixmap for custom 4 bit-pixel icons
	
	static Card8	sizesnum;		// number of icons sizes
	static Card8	*sizes;			// icons sizes
	static Card8	maxicons;		// maximal number of square icons
	
	static Box		coord[MAX_ICONS_SIZES][MAX_ICONS];		// pos. and dim. of icons in pixmap
	static Bool		occ[MAX_ICONS_SIZES][MAX_ICONS];		// occupated zones in the pixmap
	static CIconInfo	imap[MAX_ICONS_SIZES * MAX_ICONS];	// icon number / size vs pixmap zone
	
	//	Private methods
	
	static void LoadMonoImage ();
	static void LoadColorImage ();
	static void LoadHiColorImage ();
	static void OpenIColor ();
	
	static void InitCustomIcons ();
	
	void ConvC (const ImageDescr *src, void *dest, const Card8 *tbl);
	Bool FindColor (const GColor& color, Card32& index);
	
public:
	
	LookMan (Gra *gra);
	~ LookMan ();
	
	//	Init must be called once in the beginning of the program,
	//	after SetIconsSizes and SetMaxIconsNum.
	
	static void SetIconsSizes (Card8 number, const Card8 *list);
	static void SetMaxIconsNum (Card8 num);
	
	static void Init ();
	
	//	Mode
	
	static void SetColorMode (Bool force_mono) { LookMan::force_mono = force_mono; }
	static Bool GetColorMode () { return LookMan::force_mono; }
	
	//	Update must be called when a pixmap is shown
	
	void Update ();
	
	//	Drawing methods
	
	void DrawIcon (Card16 num, Pos pos);
	void DrawRectDown (Box box);
	void DrawRectUp (Box box);
	
	void SetColorBack (SSColor color);
	void SetColorFore (SSColor color);
	
	void SetColorsMenuText ();
	void SetColorSKText ();
	
	void RestoreColors ();
	
	//	Inquiry method
	
	Bool UseColor () const { return this->use_color; }
	void GetIconSize (Card16 num, Dim& dim) const;
	
	//	Custom icons management methods
	
	Card8 AllocateCIcon (Card8 size_num, Dim dim);
	void SetIcon (Card8 num, Card8 depth, Dim dim, const void *data);
	void KillCIcon (Card8 num);
	void DrawCIcon (Card8 num, Pos pos);
};

#endif /* _LOOK_MAN_H_ */

