/*
 *	main.cxx
 *
 *	Main function and initialization for SMA_SMAKY
 *
 *	(C)	1994 Pierre ARNAUD, Daniel MARMIER
 *			 for the original version
 *
 *			 Erik BRUCHEZ
 *			 for improvements & cleaning
 */

extern "C" {
#include <stddef.h>
void free	(void *block);
void *malloc (size_t size);
}

#include "smevents.h"
#include "res.h"
#include "resources.h"
#include "gra.h"
#include "softkeys.h"
#include "menu.h"
#include "lib.h"
#include "fos.h"
#include "pixmapman.h"
#include "clock.h"
#include "activityspy.h"
#include "str.h"
#include "lookman.h"
#include "iconsbar.h"
#include "config.h"

#include "mon.h"

#define WAIT_FOREVER Ntr::Dels (0xffff)

/********************************************************************/

unsigned long _stksize = 30*1024;
unsigned char _SMAPRIO = 6;
unsigned char _SMAREV = 3;
unsigned char _SMAVER = 0;
unsigned long _SMAUNIT = 0x00000006;			// keyboard & synthesizer (no display)
unsigned short _SMADIS[] = {10, 2000, 10, 100};	// not useful now !

/********************************************************************/

//	Processes

extern void WaitSpecialKey (Card32 param);
extern void UnitDo (Card32 param);
extern void IconLoop (Card32 param);
extern void SpyMouse (Card32 param);

//	Global event box

EventBox*	global_event_box = 0;
BarEvent*	global_event_pixswap = 0;
BarEvent*	global_event_displaysync = 0;

//	Resource initialisation

static const Card32 res_rv = (_SMAREV << 16) | _SMAVER;
const Card32 res_key = 0xACE0FBAE;

ResFile	res_file ("(,#):SMA_Smaky(_%L,).RS", RSOPCACHE|RSOPDEFAULT, res_rv);
ResType rtyp_image (res_file, RtypImageCod);
ResType rtyp_raster (res_file, RtypRaster);
ResType rtyp_fontrec (res_file, RtypFontRec);

//	Pixmaps, softkeys, menu and clock initialisation (some need resources)

PixmapMan		pman;

Menu			*menu[4];
SoftKeys		*softkeys[4];

Clock			clock;
ActivitySpy		activity_spy;
Configurator	configurator;

/********************************************************************/

/*
 *	This  function is  called  by the display  driver
 *	(and the  PixmapMan class)  in order to determine
 *	the sizes of the menu bar and softkeys, depending
 *	on the screen size.
 */

static Card32
GetDisGeometry (Card32 dim)
{
	Card16 dy = dim >> 16;
	Card16 dx = dim & 0xffff;
	Card16 menu_dy, soft_dy;
	
	if (dy <= dx) {
		
		//	Horizontal or square screen
		
		if (dx < 800) {
			menu_dy = 20;// or 19
			soft_dy = 40;
		} else if (dx < 832) {
			menu_dy = 24;
			soft_dy = 50;
		} else if (dx < 864) {
			menu_dy = 24;
			soft_dy = 52;
		} else if (dx < 1024) {
			menu_dy = 24;
			soft_dy = 54;
		} else {
			menu_dy = 24;
			soft_dy = 57;
		}
	} else {
		
		//	Vertical screen
		
		if (dx < 864) {
			menu_dy = 24;
			soft_dy = 52;
		} else {
			menu_dy = 24;
			soft_dy = 54;
		}
	}
	
	menu_dy--;	// in case we don't have extra white space
	soft_dy++;	// for color border
	
	return (menu_dy << 16) + soft_dy;
}


/*
 *	Set the communication with the display driver.
 */

static void
SetDisplayHooks ()
{
	Card16 channel;
	
	Card32 address = (Card32)(GetDisGeometry);
	void*  the_bar = 0;
	char* ptr = (char*)(&address);
	char* bar = (char*)(&the_bar);
	
	//	Set BAR communication : when the display
	
	static EvDisplaySync event_dis;
	static EvPixSwapSync event_dm;
	
	global_event_box->RegisterBarEvent ("#:DisplayEvents", &event_dis, TRUE);
	global_event_box->RegisterBarEvent ("PixSwapEvents", &event_dm, TRUE);
	
	global_event_pixswap     = & event_dm;
	global_event_displaysync = & event_dis;
	
	the_bar = event_dm.GetBar ()->GetBar ();
		
	//	Set `GetDisGeometry' function and start DIS BAR system. Also
	//	ask display to subscribe our bar to the display manager's spy
	//	service "pixmap swap".
	
	const char cmd[] = { 'G' + (1 << 7), ptr[0], ptr[1], ptr[2], ptr[3],
						 'P' + (1 << 7), bar[0], bar[1], bar[2], bar[3],
						 'A' + (1 << 7), 0 };
	
	Fos::Open ("$DIS_0", FOS_OPWR, &channel);
	Fos::Command (channel, cmd);
	Fos::Close (channel);
}


/*
 *	Find if a net driver is still installed
 */

static Bool
FindNetDriver (const char*& net_driver_name)
{
	Card16 num = 0;
	Card16 err;
	
	//	List of valid network drivers names
	//	(for bootstrap ; any name can be used
	//	for later registry)
	
	static const char *net_names[] = {
		"Z",
		"EZ",
		"FZ",
		""
	};
	
	//	Look if one of them is still installed
	
	do {
		const char *name;
		const Card8 *flags;
		const Card8 *type;
		
		if (err = Fos::VisuInst (num, name, flags, type)) break;
		
		Card8 i = 0;
		
		while (net_names[i][0]) {
			if (Str::Comp (name, net_names[i])) {
				net_driver_name = net_names[i];
				
				/*
				net_driver_name = complete_name;
				
				char *c = net_names[i];
				char *d = complete_name;
				while (*d++ = *c++) ;
				*/
				
				return TRUE;
			}
			i++;
		}
		
		/*
		 *	For VisuInst test...
		 *
		AfText ("Inst : ");
		AfText (name);
		AfSpace ();
		AfX2 (*flags);
		AfSpace ();
		AfX2 (*type);
		AfCR ();
		 */
		
		num++;
	} while (1);
	
	return FALSE;
}


/*
 *	Register for miscellaneous "bar events"
 */

void
RegisterBarEvents ()
{
	static EvNetworkSync	net_event;
	static EvServicesSync	services_event;
	static EvSmConfigSync	sm_config_event;
	
	global_event_box->RegisterBarEvent ("#:NetworkEvents", &net_event);
	global_event_box->RegisterBarEvent ("#:SmServices", &services_event);
	global_event_box->RegisterBarEvent ("#:SmConfig", &sm_config_event);
}


/*
 *	Shortcut for launching a process from main...
 */

static void
LaunchProcess (void (*func)(Card32), const char* name)
{
	Card32 pid  = 0;
	Card16 pino = 0;
	Ntr::CreTask (func, 1000, 3, name, 0, 0, & pid, & pino);
}


/*
 *	This process send a command to the net driver.
 *	It is a separate process in order to avoid
 *	interblocking problems.
 */

static void
SendRegisterCommand (Card32 param)
{
	char *name = (char *)(param);
	
	Card16 channel;
	
	const char command[] = { 'R' + (1 << 7), '\0' };
	
	Fos::Open (name, FOS_OPWR, &channel);
	Fos::Command (channel, command);
	Fos::Close (channel);
}


/*
 *	Main function :
 *	Init classes and processes
 *	Manage event loop
 */

int
main ()
{
	//	Test if resource file is ok
	
	Card16 err;
	
	if (err = res_file.GetError ()) {
		AfText ("SMA_SMAKY : error with resource file 0x");
		AfX4 (err);
		AfCR ();
		AfText ("Suspending...");
		AfCR ();
		WAIT_FOREVER;
	}
	
	//	Create event box
	
	EventBox event_box;
	global_event_box = & event_box;
	
	//	Global instances initialization
	
	pman.SetGeometryFunction (GetDisGeometry);
	
	for (int i = 0; i < pman.GetDMNumber (); i++) {
		
		Box box = {{0, 0}, {480, 640}};
		LookMan *lm = new LookMan (pman.GetGra (i));
		
		menu[i] = new Menu (pman.GetGra (i), lm);
		softkeys[i] = new SoftKeys (pman.GetGra (i), lm);
		
		menu[i]->SizeChanged (box);
		softkeys[i]->SizeChanged (box);
	}
	
	activity_spy.SetEventBox (global_event_box);
	clock.SetEventBox (global_event_box);
	
	//	Init icons bar (before look manager !)
	/*
	IconsBar::SetIconsSizes (Card8 number, const Card8 *list);
	IconsBar::SetMaxIconsNum (Card8 num);
	IconsBar::SetSpaceBetweenIcons (Card8 space);
	
	IconsBar::Init ();
	*/
	//	Init look manager
	
	LookMan::Init ();
	
	//	Set global communication with the display driver
	
	SetDisplayHooks ();
	
	//	Set global bar communication
	
	RegisterBarEvents ();
	
	//	Set configuration
	
	configurator.SetConfiguration ();
	
	//	Launch processes
	//	WaitSpecialKey must be launched before SpyMouse

	LaunchProcess (WaitSpecialKey, "SpecKeysLoop");
	LaunchProcess (UnitDo, "UnitMounter");
	LaunchProcess (IconLoop, "IconLoop");
	LaunchProcess (SpyMouse, "SpyMouse");
	LaunchProcess (LibEventLoop, "LibEventLoop");
	
	//	Allow memory / processor time spy messages sending
	
	activity_spy.MuteOff ();
	
	/*
	AfText ("Processes launched");
	AfCR ();
	*/
	
	//	Find if net driver installed
	
	static const char *net_driver_name;
	
	if (FindNetDriver (net_driver_name)) {
		
		//	Build a name such as "$Z_0:"
		
		static char name[18];
		char *d = name + 1;
		const char *s = net_driver_name;
		
		name[0] = '$';
		while (*d++ = *s++) ;
		d--;
		*d++ = '_';
		*d++ = '0';
		*d++ = ':';
		*d = '\0';
		
		/*
		 *	Test
		 *
		AfText ("Net driver found during init. : ");
		AfSpace ();
		AfText (name);
		AfCR ();
		 */
		
		//	Send a command to the installed driver in order
		//	to tell it to register now. This is done by
		//	another process, in order to avoid interblocking
		//	problems.
		
		Card32 pid  = 0;
		Card16 pino = 0;
		const char *pname = "SendRCommand";
		
		Ntr::CreTask (SendRegisterCommand, 1000, 7, pname, (Card32)(name), 0, & pid, & pino);
	}
	
	//	Main loop
	
	for (;;) {
		event_box.GetEvent ()->HandleEvent ();
	}
	
	return 0;
}

void *operator new (size_t size)
{
	return malloc (size);
}

void operator delete (void *mem)
{
	free (mem);
}

extern "C" void abort ();
void abort () {}

