/*
 *	menu.h
 *
 *	Menu bar class for SMA_SMAKY
 *
 *	There are as many instances of menu bars
 *	as the number of DMs (Display Managers)
 *	installed.
 *
 *	(C)	1994	Daniel MARMIER, Pierre ARNAUD
 *				for the original version
 *
 *		1994, 1995
 *				Erik BRUCHEZ
 *				for improvements and cleaning
 */

#ifndef _SMA_MENU_H_
#define _SMA_MENU_H_

#include "gra.h"
#include "lookman.h"
#include "clock.h"

struct MenuData;
class LookMan;

class Menu {
	Gra*	gra;					// drawing interface
	LookMan	*lookman;				// look manager (associated with drawing interface)
	
	const MenuData*	data;
	
	//	Boxes (see SetBoxes)
	
	Box		box;					// menu box in the screen
	Box		css_box;				// clock subsystem box in the screen
	Box		clock_box;				// clock itself
	Box		mem_box;				// mem. stats
	Box		cpu_box;				// CPU stats
	Pos		net_in_pos;				// net-in icon position
	Pos		net_out_pos;			// net-out icon position
	Box		msg_box;				// complete message box
	
	Box		logo_box;				// just the machine logo box
	Box		disp_box;				// first display box
	Box		unit_box;				// first mass memory unit box
	Box		caps_box;				// caps logo box
	
	//	Fonts resources
	
	Res 	*fontres;				// clock font resource
	Gencar	*clockfont;				// pointer to font data
	
	Res 	*dirfontres;			// directory font resource
	Gencar	*dirfont;				// pointer to font data
	
	Res		*bigfontres;			// big font resource
	Gencar	*bigfont;				// pointer to font data
	
	void	*tbuffer;				// text graphics buffer
	Card16	tbuffer_width;			// and its width in bytes
	
	//	Misc
	
	Card16	caps_icon;
	Bool	caps_on;
	
	//	Displays (see SetDisplays)
	
	Card16	disp_icon[10];
	Card16	disp_installed;			// bitset of installed displays
	Card16	disp_visible;			// bitset of visible displays
	
	//	Units (see SetUnits)
	
	Card16	unit_icon[6];
	Card16	unit_installed;			// bitset of installed units
	Card16	unit_entered;			// bitset of entered units
	
	//	Network activity (see SetNet)
	
	Card16	net_in_icon[3];
	Card16	net_out_icon[3];
	Card8	net_state_in;
	Card8	net_state_out;
	
	char		clock_text[100];
	ClockMode	clock_mode;
	
	//	Messages management
	
	Bool		message;
	char		msg_text[MSG_BUFFER_SIZE];
	Card16		msg_len;
	Card8		msg_icon;
	Int16		msg_pos;
	Card16		msg_icon_num;
	
	Card16		msg_buf_width;
	Box			msg_buf_box;
	Card8		*msg_buf;
	
	//	Private methods
	
	void DrawBar (Box box, Card32 max, Card32 value, SSColor fgcol, SSColor bgcol);
	void DrawHistograms (Box box, Card16 max, Card16 *values, SSColor fgcol, SSColor bgcol);
	Bool UpdateLogo (Pos pos);
	void DrawLogo (Bool down = FALSE);
	
	Bool PosInBox (Pos pos, Box box) const;
	void SetNet ();
	
	Bool ComputeTruncatedString (const char *text, char *dest, Card32 wmax);
	
public:
	Menu (Gra *gra, LookMan	*lookman);
	~Menu ();
	
	Gra* GetGra () const { return this->gra; }
	Box GetBox () const { return this->box; }
	
	//	State setting
	
	void SetBox (Box box);
	void SizeChanged (Box box);

	void SetCaps (Bool status);
	void SetDisplays (Card16 inst, Card16 visible);
	void SetUnits (Card16 inst, Card16 enter);
	void SetNetIn (Bool active);
	void SetNetOut (Bool active);
	
	Bool ReadClock ();
	
	//	Drawing
	
	void UpdateLookMan ();
	void DrawAll ();
	void DrawCaps ();
	void DrawDisplays ();
	void DrawUnits ();
	void DrawAdornments ();
	void DrawClock (Bool clean_up = FALSE);
	void DrawMemProc (Bool mem_changed, Bool cpu_changed,
					  Bool clean_up_mem = FALSE, Bool clean_up_cpu = FALSE);
	void DrawNet ();
	
	//	Mouse click
	
	Bool Click (Pos pos, Card8 click);
	Bool LogoAction ();
	void CenterMouse (Card16 dis_number, Pos rel_pos, Pos start_pos, Card16 space, Dim icon_dim);
	
	//	Messages management
	
	void BeginMessage ();
	void SetMsgText (const char *text, Bool copy = TRUE);
	void SetMsgIcon (Card8 icon_number);
	Card16 GetMsgMaxLen (const char *text);
	Card16 GetMsgMaxScr () const;
	void DrawMsgIcon ();
	void SetMsgPos (Int16 position);
	void DrawMsgText ();
	void SetEndMessage ();
	void DrawEndMessage ();
};

#endif /* _SMA_MENU_H_ */

