/*
 *	pulldown.cxx
 *
 *	Pull-down menu for SMA_SMAKY
 *
 *	(C)	Copyright 1994,  Erik BRUCHEZ
 */

#include "pulldown.h"

#include <string.h>

/****************************************************************/

MenuItem::MenuItem ()
{
	this->style = MENU_ITEM_ROMAN_STYLE;
	this->text = NULL;
	this->max_length = 0;
}


MenuItem::~MenuItem ()
{
	if (this->text) delete this->text;
}


void
MenuItem::SetText (const char *text)
{
	if (text == 0) return;
	
	int l = strlen (text);
	
	if (l > this->max_length) {
		
		if (this->text) delete this->text;
		this->text = new char[l + 1];
		strcpy (this->text, text);
		this->max_length = l;
	}
	
	strcpy (this->text, text);
}


void
MenuItem::SetTextStyle (MenuItemTextStyle style)
{
	this->style = style;
}


void
MenuItem::SetIcon ()
{
}


void
MenuItem::Draw (Box box)
{
	
}

/****************************************************************/

PullDownMenu::PullDownMenu ()
{
	this->first = NULL;
	this->last = NULL;
	
	this->item_number = 0;
}


PullDownMenu::~PullDownMenu ()
{
	//	Delete the chain
	
	ItemChain *tmp;
	
	while (this->first) {
		
		tmp = this->first->next;
		delete this->first;
		this->first = tmp;
	}
}


PullDownMenu *
PullDownMenu::AddItem (MenuItem *item)
{
	if (this->last) {
		
		//	Chain not empty -> add to the end
		
		this->last->next = new ItemChain;
		this->last->next->prev = this->last;
		this->last = this->last->next;
		this->item_number++;
		
	} else {
		
		//	Chain empty
		
		this->first = new ItemChain;
		this->last = this->first;
		this->item_number = 1;
		
		this->last->prev = NULL;
	}
	
	this->last->next = NULL;
	this->last->item = item;
	
	return this;
}


void
PullDownMenu::Draw (Box box)
{
	
}


Bool
PullDownMenu::Do (Card16& item_number, MenuItem*& item)
{
	
}



