|*************************************************************************
|*									 *
|*	CRT0.S	Smaky startup module for GNU C/C++ programs using libc.a *
|*									 *
|*************************************************************************

|	PF, October/November 1990, January 1991, output file: crt0.o.
|	This file allows also profiling (gcrt0.o). See `profiling'.

|	PF, June 1991: stackchecklink
|	BB, Jan  1992: correction for multiple tasks	look for BBPROC
|	MW, Nov 1992: corrections for stackcheck (look for MW)
|		      stack check gives signal 11 instead of 4
|	MW, Dec 1992: `BIGCRT' for SCRT0.S, useful for small programs without
|		      debugging, timezone and coredump.
|	PA, Jul 1994: `MICROCRT' with very minimal CRT0 (no XFOS, nothing...)

|
| entry points
|
	.globl	__commandline

|
| external references
|
	.globl	_main		| C program main() function, calls ___main
	.globl	___exit		| cleanup function

|
| uninitialized data space (init to 0 by startup code)
|
	.comm	__saved_sp,4	| do not use L_! (bad code generated)
	.comm	__commandline,4
	.comm	__exec_mode,4
|
| useful constants
|
LFOS_VERSION	=	0x4E450025
LFOS_ERRSTOP	=	0x4E45003D
LIB_NOBUCAR	=	0x4E46002F
LIB_OPELIB	=	0x4E460000
LIB_CLOLIB	=	0x4E460001
LIB_AFCR	=	0x4E460004
LIB_AFSPACE	=	0x4E460005
LIB_AFTEXT	=	0x4E460008
LIB_AFTIM	=	0x4E460009
LIB_AFX8	=	0x4E46000E
LIB_GETCAR	=	0x4E460011
LIB_GCHDIS	=	0x4E460022
LIB_GCHKEY	=	0x4E460023
LNTREL_GETSTACK	=	0x4E440054
LNTREL_MODTIM	=	0x4E44005A
LNTREL_SETTIM	=	0x4E440005
|LNTREL_IEPBAIP	=	0x4E440049
LNTREL_GETPROCESSOR =	0x4E440060
LNTREL_GETFPU	=	0x4E440061
LNTREL_CLEARCACHE =	0x4E440065
LNTREL_GTPNUM	=	0x4E44001B						| BBPROC
LNTREL_WFABDESC	=	0X4E440040
LGESMEM_GETMEM	=	0x4E440028
LGESMEM_COPYMEM =	0x4E440083
LGESMEM_GIVMEM	=	0x4E44002B
LGESMEM_CLEARMEM =	0x4E44005C
L_ERMFUL	=	0x8340
L_ERILOP	=	0x8510
L_ERBINA	=	0x8540
L_ERILAD	=	0x8542
L_ERBNRE	=	0x8545
L_NOCURS	=	0x9D
L_AUTOCR	=	0x97
L_NOEFLI	=	0x99
L_GCURS		=	0x9A
L_CURS		=	0x9C
L_MTYPCP	=	0
|L_EXCBUS	=	1
|L_EXCADR	=	2
LIB_OPEN	=	0xA102
LIB_CLOSE	=	0xA103
LXFOS_FIRST	=	0xA300
LXFOS_EXTEND	=	0xA30F
LXFOS__RESET	=	2

|
| header offsets
|
L_obxunit	=	0x40	| used units
L_obx_info	=	0x60	| machine + magic
L_obx_text	=	0x64	| text length
L_obx_data	=	0x68	| data length
L_obx_bss	=	0x6C	| bss length
L_obx_syms	=	0x70	| symbol table length
L_obx_entry	=	0x74	| start address
L_obx_trsize	=	0x78	| text relocation table size
L_obx_drsize	=	0x7C	| data relocation table size
L_OMAGIC	=	0x107
L_BBXGNU	=	7	| bit in L_obxunit
L_FOSVER	=	0x619	| needed: >= FOS 6.25

|
| STARTUP ROUTINE (must be first object in link)
|
	.text
__start:
|
| input:	a6	^program (-256: ^header)
|		a3	^command line (terminated by <cr><0>)
|		d7	2 x procid.16 of father process
|
| program is loaded in memory; however, the program has to be relocated first;
| this starting up code copies the code in a free memory area, relocates it
| there and jumps there; original program code remains untouched.
|
	moveql	#1,d3			| normal entry
	bras	L_first_here
	bra	L_go_relocated		| +4: relocated entry
__ovrentry:
	moveql	#0,d3			| overlay entry
	bras	L_first_here

| This entry point is used when freeing memory associated to the
| code, just before returning... It is +12 !!!

| +12:
| input:	d0	error
|		d3	(0) overlay, (1) normal
|		a6	^program (copy)

	moveql	#L_MTYPCP,d1
	lea	a6@(-256),a4
	.long	LGESMEM_GIVMEM		| free memory
	beq	L_ok_free
	
	trap	#1
	
L_ok_free:
	movew	d0,d7
	tstl	d3
	bne	L_stop
	rts

L_stop:
	.long	LFOS_ERRSTOP		| and return to Psos


L_first_here:
	movel	d7,d2			| save d7
	movel	#256,d6			| d6 = 256 (always)
	subl	d6,a6			| a6 = header address
	movew	#L_ERBINA,d0
	cmpl	#L_OMAGIC,a6@(L_obx_info)
	bne	L_specialerror		| bad magic number ?
	movew	#L_ERILAD,d0
	moveql	#-2,d1
	andl	a6@(L_obx_entry),d1
	bne	L_specialerror		| start address <> 0/1 ?
	movel	d6,d4
	addl	a6@(L_obx_text),d4
	addl	a6@(L_obx_data),d4
	movel	d4,a2			| a2 = header + text + data
L_noGNU:
	addl	a6@(L_obx_bss),d4	| d4 = memory needed
	addql	#8,d4			| some room for movel (copy/clear)
	andib	#0xfe,d4		| align 2
	moveql	#L_MTYPCP,d1
	.long	LGESMEM_GETMEM
	movew	d7,d0
	bne	L_specialerror		| something already wrong ?
	
	.long	LGESMEM_CLEARMEM	| clear memory, first...

	movel	a3,a1			| a1 <-- ^command line
	movel	a6,a3			| a3 <-- ^program header
	movel	a2,d4			| d4 <-- size to copy (header + text + data)
	.long	LGESMEM_COPYMEM		| copy code to memory

	movel	a1,a3			| a3 <-- ^command line

	movel	a6,a5			| a5 <-- ^header
	movel	a4,a6			| a6 <-- ^memory (copy of code)
	addl	d6,a6			| a6 <-- ^text

| a6 : ^text start
| a5 : ^header
| a3 : ^command line
| a2 :  header + text + data

	movel	a6,d7			| ^text start
	movel	a5,a4			| ^original
	addl	a2,a4			| + header + text + data = ^reloc table
	tstl	a5@(L_obx_entry)
	beq	L_reloc8		| 8 bytes / reloc info ?
	moveql	#1,d5			| d5.32 = 1
	movel	a4@+,d0			| first address
	beq	L_end1reloc
	addl	d7,d0
	movel	d0,a0			| absolute address
	moveql	#0,d0
L_1relocit:
	addl	d7,a0@
L_1reloc:
	moveb	a4@+,d0
	beq	L_end1reloc
	cmpb	d5,d0
	beq	L_add254
	addl	d0,a0
	bra	L_1relocit
L_add254:
	lea	a0@(254),a0
	bra	L_1reloc
L_reloc8:
	moveql	#0,d5			| offset to text
	movel	a5@(L_obx_trsize),d0	| reloc length for text
	bsr	L_relocall
	movel	a5@(L_obx_text),d5	| offset to data
	movel	a5@(L_obx_drsize),d0	| reloc length for data
	bsr	L_relocall
L_end1reloc:
	addl	a6,a2			| ^bss+256, d0 = 0
	subl	d6,a2			| -256
	movel	a5@(L_obx_bss),d1	| bss length
	beq	L_noclr
	movel	a2,d4
	lsrb	#1,d4
	bcc	L_evenadd
	moveb	d0,a2@+
L_evenadd:
	addql	#3,d1			| adjust to long
	lsrl	#2,d1			| /4
L_clrl:
	movel	d0,a2@+			| clear bss area
	subql	#1,d1
	bne	L_clrl
L_noclr:
	.long	LNTREL_CLEARCACHE	| for 68020, 68030, ...
L_nocache:
	movel	d2,d7			| restore d7 (procid)
	jmp	a6@(4)	 		| and go, use actual stack

L_relocall:				| in: a4^ reloc, d7^ start, d0 length
	lsrl	#3,d0			| div 8
	beq	L_endreloc		| none ?
L_reloc:
	movel	a4@+,d4			| r_address
	movel	a4@+,d1			| r_symbolnum+r_pcrel+r_length+r_extern
	cmpl	#0x00000840,d1
	bhi	L_relerror
	beq	L_relok
	cmpw	#0x0640,d1
	beq	L_relok
	cmpw	#0x0440,d1
	bne	L_relerror
L_relok:
	addl	d5,d4			| offset in text or data
	addl	d7,a6@(0,d4:l)		| correct address
	subql	#1,d0
	bne	L_reloc
L_endreloc:
	rts
L_relerror:
	movew	#L_ERBNRE,d0
	bra	L_specialerror

| input:	a6	^program (-256: ^header)
|		a5	^header of original code
|		a3	^command line (terminated by <cr><0>)
|		d3	0 (overlay) 1 (normal)
L_go_relocated:
	movel	d3,__exec_mode		| overlay if 0, normal if 1
	bras	L_overlay

L_d0stop:
	movel	__exec_mode,d3		| d3 = 1, d0 = error, a6 = program
	jmp	a5@(256+12)

L_specialerror:
	trap	#0
	bras	L_specialerror

L_overlay:				| d7 = 0 (overlay) 1 = normal
	movel	sp,__saved_sp
	movel	a3,__commandline

|
| call C entry point function main()
|
	.long	LIB_OPELIB
	jsr	_main			| will call ___main, then execute code
	movel	d0,d2
	jsr	___exit			| cleans up what ___main did
	movel	d2,d0
	bra	L_d0stop

