/*
 *	ntrel.cxx
 *
 *	Implmentation de l'interface avec le noyau temps
 *	rel.
 *
 *	(C) 1994,  Pierre ARNAUD, CH-1437 SUSCEVAZ
 */

#include "ntrel.h"
#include "mon.h"

/****************************************************************/

NtrBar::NtrBar (const char* name)
{
    asm (	"moveq #0,d4\n\t"
    		"movel %2,a3\n\t"
    		"movel a5,d1\n\t"
    		".long 0x4E44007A\n\t"
    		"exg   a5,d1\n\t"
    		"movel d1,%0\n\t"
    		"movew d7,%1\n\t"
    	: "=g" (this->bar), "=g" (this->error)
    	: "g" (name)
    	: "d1", "d4", "d7", "a3");
	
	this->must_kill = this->error ? FALSE : TRUE;
}


NtrBar::~NtrBar ()
{
	if (this->must_kill) {
		asm (	"movel %1,d1\n\t"
				"exg   a5,d1\n\t"
				".long 0x4E44007B\n\t"
				"exg   a5,d1\n\t"
				"movew d7,%0\n\t"
			: "=g" (this->error)
			: "g" (this->bar)
			: "d1", "d7");
 	}
}


void
NtrBar::Accept (void*& ptr)
{
    asm ( "movel %2,d1\n\t"
    	  "exg   a5,d1\n\t"
    	  ".long 0x4E44007D\n\t"
    	  "exg   a5,d1\n\t"
    	  "movel a4,%0\n\t"
    	  "movew d7,%1\n\t"
    	: "=g" (ptr), "=g" (this->error)
    	: "g" (this->bar)
    	: "d1", "d7", "a4");
}


void
NtrBar::EndAccept (void* ptr)
{
    asm ( "movel %1,d1\n\t"
    	  "movel %2,a4\n\t"
    	  "exg   a5,d1\n\t"
    	  ".long 0x4E44007F\n\t"
    	  "exg   a5,d1\n\t"
    	  "movew d7,%0\n\t"
    	: "=g" (this->error)
    	: "g" (this->bar), "g" (ptr)
    	: "d1", "d7", "a4");
}


void
NtrBar::Offer ()
{
    asm ( "movel %1,d1\n\t"
    	  "exg   a5,d1\n\t"
    	  ".long 0x4E44007C\n\t"
    	  "exg   a5,d1\n\t"
    	  "movew d7,%0\n\t"
    	: "=g" (this->error)
    	: "g" (this->bar)
    	: "d1", "d7");
}


void
NtrBar::EndOffer (void* in_ptr, void*& out_ptr)
{
    asm ( "movel %2,d1\n\t"
    	  "movel %3,a4\n\t"
    	  "exg   a5,d1\n\t"
    	  ".long 0x4E44007E\n\t"
    	  "exg   a5,d1\n\t"
    	  "movel a4,%0\n\t"
    	  "movew d7,%1\n\t"
    	: "=g" (out_ptr), "=g" (this->error)
    	: "g" (this->bar), "g" (in_ptr)
    	: "d1", "d7", "a4");
}


/****************************************************************/

NtrBAL::NtrBAL (Card16 limit)
{
	asm (	"movew	%2,d4		\n\t"
			"exg	a5,d0		\n\t"
			".long	0x4e440014	\n\t"
			"exg	a5,d0		\n\t"
			"movel	d0,%0		\n\t"
			"movew	d7,%1		\n\t"
		: "=g" (this->bal), "=g" (this->error)
		: "g" (limit)
		: "d0", "d4", "d7" );
	
	this->kill = this->error ? FALSE : TRUE;
}


NtrBAL::NtrBAL (void *bal)
{
	this->kill = FALSE;
	
	if (bal) {
		this->bal = bal;
		this->error = 0;
	} else {
		this->error = 1;
	}
}


NtrBAL::~NtrBAL ()
{
	if (!this->kill) return;
	
	asm (	"movel	%0,d0		\n\t"
			"exg	a5,d0		\n\t"
			".long	0x4e440017	\n\t"
			"exg	a5,d0		\n\t"
		:
		: "g" (this->bal)
		: "d0", "d7" );
}


void
NtrBAL::GiveMessage (Card32 message)
{
	asm (	"movel	%1,d0		\n\t"
			"movel	%2,a4		\n\t"
			"moveql	#1,d3		\n\t"	// MSNBR
			"exg	a5,d0		\n\t"
			".long	0x4e440037	\n\t"
			"exg	a5,d0		\n\t"
			"movew	d7,%0		\n\t"
		: "=g" (this->error)
		: "g" (this->bal), "g" (message)
		: "d0", "d3", "d7", "a4" );
}


void
NtrBAL::GetMessage (void **message, Card32* length, Card8 *mode)
{
//-	AfText ("[B:"); AfX8 (this->bal); AfText ("]");
	
	asm (	"movel	%4,d0		\n\t"
			"moveql	#0,d3		\n\t"
			"exg	a5,d0		\n\t"
			".long	0x4e440045	\n\t"
			"exg	a5,d0		\n\t"
			"movel	a4,%0		\n\t"
			"movel	d4,%1		\n\t"
			"moveb	d3,%2		\n\t"
			"movew	d7,%3		\n\t"
		: "=g" (*message), "=g" (*length), "=g" (*mode), "=g" (this->error)
		: "g" (this->bal)
		: "d0", "d3", "d4", "d7", "a4" );
}


void
NtrBAL::GetNumMessage (Card32& number, Card8& mode)
{
	Card32 result;
	
	asm (	"movel	%3,d0		\n\t"
			"moveql	#0,d3		\n\t"
			"exg	a5,d0		\n\t"
			".long	0x4e440045	\n\t"
			"exg	a5,d0		\n\t"
			"movel	a4,%0		\n\t"
			"moveb	d3,%1		\n\t"
			"movew	d7,%2		\n\t"
		: "=g" (result), "=g" (mode), "=g" (this->error)
		: "g" (this->bal)
		: "d0", "d3", "d4", "d7", "a2", "a4" );
	
	if (mode == 1) number = result;
}


void
NtrBAL::GetMessage (void *message, Card32& length, Card32& number, Card8& mode)
{
	Card32 result;
	
	asm (	"movel	%3,d0		\n\t"
			"moveql	#2,d3		\n\t"
			"movel	%4,a4		\n\t"
			"movel	%5,a2		\n\t"
			"movel	a2@,d4		\n\t"
			"exg	a5,d0		\n\t"
			".long	0x4e440045	\n\t"
			"exg	a5,d0		\n\t"
			"movel	a4,%0		\n\t"
			"movel	d4,a2@		\n\t"
			"moveb	d3,%1		\n\t"
			"movew	d7,%2		\n\t"
		: "=g" (result), "=g" (mode), "=g" (this->error)
		: "g" (this->bal), "g" (message), "g" (&length)
		: "d0", "d3", "d4", "d7", "a2", "a4" );
	
	if (mode == 1) number = result;
}


/****************************************************************/

NtrLock::NtrLock ()
{
	asm ( "moveql #1,d4\n\t"
		  "exg    a5,d1\n\t"
		  ".long  0x4E44000A\n\t"
		  "exg    a5,d1\n\t"
		  "movel  d1,%0\n\t"
		  "movew  d7,%1\n\t"
    	: "=g" (this->sem), "=g" (this->error)
    	:
    	: "d1", "d4", "d7" );
}

NtrLock::~NtrLock ()
{
	asm ( "movel %1,d1\n\t"
	      "exg   a5,d1\n\t"
		  ".long 0x4E44000D\n\t"
		  "exg   a5,d1\n\t"
		  "movew d7,%0\n\t"
		: "=g" (this->error)
		: "g" (this->sem)
		: "d1", "d7" );
}

	
void
NtrLock::Enter ()
{
	asm ( "movel %1,d1\n\t"
	      "exg   a5,d1\n\t"
		  ".long 0x4E440043\n\t"
		  "exg   a5,d1\n\t"
		  "movew d7,%0\n\t"
		: "=g" (this->error)
		: "g" (this->sem)
		: "d1", "d7" );
}


void
NtrLock::Release ()
{
	asm ( "movel %1,d1\n\t"
	      "exg   a5,d1\n\t"
		  ".long 0x4E440044\n\t"
		  "exg   a5,d1\n\t"
		  "movew d7,%0\n\t"
		: "=g" (this->error)
		: "g" (this->sem)
		: "d1", "d7" );
}


/****************************************************************/

NtrSync::NtrSync ()
{
	asm ( "moveql #0,d4\n\t"
		  "exg    a5,d1\n\t"
		  ".long  0x4E44000A\n\t"
		  "exg    a5,d1\n\t"
		  "movel  d1,%0\n\t"
		  "movew  d7,%1\n\t"
    	: "=g" (this->sem), "=g" (this->error)
    	:
    	: "d1", "d4", "d7" );
}

NtrSync::~NtrSync ()
{
	asm ( "movel %1,d1\n\t"
	      "exg   a5,d1\n\t"
		  ".long 0x4E44000D\n\t"
		  "exg   a5,d1\n\t"
		  "movew d7,%0\n\t"
		: "=g" (this->error)
		: "g" (this->sem)
		: "d1", "d7" );
}

	
void
NtrSync::Wait (Card16 timeout)
{
	asm ( "movel %1,d1\n\t"
		  "movew %2,d4\n\t"
		  ".long 0x4E44005A\n\t"	//	NTREL ?MODTIM
	      "exg   a5,d1\n\t"
		  ".long 0x4E440041\n\t"	//	NTREL ?WAITEV
		  "exg   a5,d1\n\t"
		  "movew d7,%0\n\t"
		  ".long 0x4E440005"		//	NTREL ?SETTIM
		: "=g" (this->error)
		: "g" (this->sem), "g" (timeout)
		: "d1", "d4", "d7" );
}

void
NtrSync::Signal ()
{
	asm ( "movel %1,d1\n\t"
	      "exg   a5,d1\n\t"
		  ".long 0x4E440042\n\t"
		  "exg   a5,d1\n\t"
		  "movew d7,%0\n\t"
		: "=g" (this->error)
		: "g" (this->sem)
		: "d1", "d7" );
}

void
NtrSync::SingleSignal ()
{
	asm ( "movel %1,d1\n\t"
	      "exg   a5,d1\n\t"
		  ".long 0x4E440059\n\t"
		  "exg   a5,d1\n\t"
		  "movew d7,%0\n\t"
		: "=g" (this->error)
		: "g" (this->sem)
		: "d1", "d7" );
}


/****************************************************************/

/*
 *	Implementation de la classe NtrSync.
 */

NtrSel::NtrSel ()
{
	this->local_sync_rec.sel_num = 0;
	this->local_sync_rec.reserve1 = 0;
	this->local_sync_rec.timeout = 0xffffffff;
	this->local_sync_rec.reserve2 = 0;
	
	for (int i = 0; i < NTR_NB_SELS; i++) {
		SyncItem *item = & this->local_sync_rec.item[i];
		
		item->index = 0;
		item->type = 0;
		item->reserve1 = 0;
		item->id = 0;
		item->aux1 = 0;
		item->aux2 = 0;
	}
	
	this->sel_num = 0;
	
	this->ReadSyncRecord ();
}


NtrSel::~NtrSel ()
{
}


void
NtrSel::ReadSyncRecord ()
{
	SyncRecord	*rec;
	Card16		error;
	
	asm ( ".long 0x4e440081	\n\t"		// NTREL ?GETPSELR
		  "movel a3,%0		\n\t"
		  "movew d7,%1"
		: "=g" (rec), "=g" (error)
		:
		: "a3", "d7" );
	
	if (error)
		this->sync_rec = 0;
	else
		this->sync_rec = rec;
}


void
NtrSel::AddAcceptBar (NtrBar *bar, Card32 ident)
{
	if (this->sel_num >= NTR_NB_SELS) return;
	
	SyncItem *item = & this->local_sync_rec.item[this->sel_num];
	
	item->index = ident;
	item->type = SYNC_TYPE_ACCEPT;
	item->reserve1 = 0;
	item->id = bar->GetBar ();
	item->aux1 = 0;
	item->aux2 = 0;
	
	this->sel_num++;
}


void
NtrSel::AddSync (NtrSync *sync, Card32 ident)
{
	if (this->sel_num >= NTR_NB_SELS) return;
	
	SyncItem *item = & this->local_sync_rec.item[this->sel_num];
	
	item->index = ident;
	item->type = SYNC_TYPE_SYNC;
	item->reserve1 = 0;
	item->id = sync->GetSem ();
	item->aux1 = 0;
	item->aux2 = 0;
	
	this->sel_num++;
}


Card16
NtrSel::Sync (Card32& ident, void*& accept_result)
{
	if ( (this->sync_rec == 0) || (this->sel_num == 0) ) return -1;
	
	memcpy (this->sync_rec, &this->local_sync_rec, sizeof (SyncRecord));
	
	this->sync_rec->sel_num = this->sel_num;
	
	Card32 index;
	void *accept;
	Card16 error;
	
	asm ( ".long 0x4e440082	\n\t"		// NTREL ?SELECTSYNC
		  "movel d3,%0		\n\t"
		  "movel a4,%1		\n\t"
		  "movew d7,%2"
		: "=g" (index), "=g" (accept), "=g" (error)
		:
		: "d3", "a4", "d7" );
	
	ident = index;
	accept_result = accept;
	
	return error;
}


/****************************************************************/

/*
 *	Implmentation des services globaux du ntr.
 */

void
Ntr::GetTimeMS (Card32& time)
{
	asm ( ".long 0x4E440080\n\t"
		  "movel d4,%0"
		: "=g" (time)
		:
		: "d4", "d5", "d7" );
}


void
Ntr::GetCPTime (Card32& time)
{
	asm ( ".long 0x4E440055\n\t"
		  "movel d4,%0"
		: "=g" (time)
		:
		: "d4", "d5", "d7" );
}


void
Ntr::GetPrTime (Card32& time)
{
	asm ( ".long 0x4E440056\n\t"
		  "movel d4,%0"
		: "=g" (time)
		:
		: "d4", "d5", "d7" );
}


void
Ntr::GetSyTime (Card32& proctime, Card32& idletime)
{
	asm ( ".long 0x4E440057	\n\t"
		  "movel d4,%0		\n\t"
		  "movel d2,%1"
		: "=g" (proctime), "=g" (idletime)
		:
		: "d2", "d3", "d4", "d5", "d7" );
}


void
Ntr::SetTim (Card16 timeout)
{
	asm ( "movew %0,d4		\n\t"
		  ".long 0x4E440005	\n\t"
		: 
		: "g" (timeout)
		: "d4", "d7" );
}


Card16
Ntr::GetTim ()
{
	Card16 timeout;
	
	asm ( ".long 0x4E44001A	\n\t"
		  "movew d4,%0		\n\t"
		: "=g" (timeout)
		: 
		: "d4", "d7" );
	
	return timeout;
}


Card16
Ntr::ModTim (Card16 timeout)
{
	Card16 oldtimeout;
	
	asm ( "movew %1,d4		\n\t"
		  ".long 0x4E44005A	\n\t"
		  "movew d4,%0		\n\t"
		: "=g" (oldtimeout)
		: "g" (timeout)
		: "d4", "d7" );
	
	return oldtimeout;
}


void
Ntr::Dels (Card16 n)
{
	asm ( "movew %0,d4		\n\t"
		  ".long 0x4E440009"
		:
		: "g" (n)
		: "d4", "d7" );
}


void
Ntr::Delms (Card16 n)
{
	asm ( "movew %0,d4		\n\t"
		  ".long 0x4E440008"
		:
		: "g" (n)
		: "d4", "d7" );
}


void
Ntr::GetTaskPtr (void*& tpt)
{
	asm ( ".long 0x4E440006\n\t"	//	NTREL ?GETTPT
		  "movel a4,%0"
		: "=g" (tpt)
		:
		: "a4", "d7" );
}


void
Ntr::GetFatherTaskPtr (void *ptr, void*& father)
{
	asm ( "movel %1,a4		\n\t"
		  ".long 0x4e440035	\n\t"	// NTREL ?GTFATP
		  "movel a4,%0"
		: "=g" (father)
		: "g" (ptr)
		:  "d4", "a4");
}


void
Ntr::CreTask (void (*startaddr)(Card32), long stacklength, int prioattr, const char *name, Card32 param, Card32 sema, Card32* pid, Card16* pino)
{
	Card16 err;

	asm (	"movel	%3,a1				| startaddr -> a1 -> child's a3  \n\t"
			"movel	%4,d5				| stacklength				\n\t"
			"movel	%5,d4				| prioattr					\n\t"
			"movel	%6,a3				| name						\n\t"
			"movel	%7,d1				| param						\n\t"
			"movel	%8,a2				| sema						\n\t"

			"movel	a6,d6				| save a6					\n\t"
			"movel	a5,a6				| futur ^variables			\n\t"
			"lea	1f,a5				| real start address		\n\t"
			".long	0x4E440000			| NTREL ?CRETASK			\n\t"
			"movel	a6,a5				| restore a5				\n\t"
			"movel	d6,a6				| restore a6				\n\t"

			"movew	d7,%0				| err						\n\t"
			"movel	a4,%1				| pid						\n\t"
			"movew	d4,%2				| pino						\n\t"

			"bra	2f												\n\t"

		"1:															\n\t"
			"movel	a6,a5											\n\t"
			"movel	#-1000000,a6		| something illegal...		\n\t"
			"movel	d7,sp@-				| in case the param is of a procedure form myproc(int param)  \n\t"
			"clrl	d7												\n\t"
			"jsr	a3@					| start the user's procedure  \n\t"
			"addl	#4,sp											\n\t"
			".long	0x4e440001			| NTREL ?ABORT				\n\t"
		"2:															\n\t"

		:	"=g" (err), "=g" (*pid), "=g" (*pino)
		:	"g" (startaddr), "g" (stacklength), "g" (prioattr), "g" (name), "g" (param), "g" (sema)
		:	"d1", "d4", "d5", "d6", "d7", "a1", "a2", "a3", "a4" );
}


void
Ntr::WFAbDesc ()
{
	asm ( ".long 0x4e440040"	// NTREL ?WFABDESC
		:
		:
		:  "d7" );

}

/****************************************************************/

