/*
 *	pulldown.h
 *
 *	Pull-down menu for SMA_SMAKY
 *
 *	(C)	Copyright 1994,  Erik BRUCHEZ
 */


#ifndef _SMA_PULL_DOWN_H_
#define _SMA_PULL_DOWN_H_

#include "system.h"
#include "gra.h"

/****************************************************************/

enum MenuItemTextStyle
{
	MENU_ITEM_ROMAN_STYLE,
	MENU_ITEM_ITALIC_STYLE
};

class MenuItem {

private:
	char				*text;
	MenuItemTextStyle	style;
	
	int					max_length;
	
public:
	MenuItem ();
	~ MenuItem ();
	
	void SetText (const char *text);
	void SetTextStyle (MenuItemTextStyle style);
	
	void SetIcon ();
	
	void Draw (Box box);
};

/****************************************************************/

class PullDownMenu {

private:
	
	//	Item list
	
	struct ItemChain
	{
		ItemChain	*prev;
		ItemChain	*next;
		MenuItem	*item;
	};
	
	ItemChain	*first;
	ItemChain	*last;
	
	Card16		item_number;
	
	//
	
	void Draw (Box box);

public:
	PullDownMenu ();
	~ PullDownMenu ();
	
	PullDownMenu *AddItem (MenuItem *item);
	
	Bool Do (Card16& item_number, MenuItem*& item);
};

#endif /* _SMA_PULL_DOWN_H_ */



