/*
 *	res.cxx
 *
 *	Resources management for SMA_SMAKY
 *
 *	(C)	1994	Daniel MARMIER
 */

#include "res.h"

//#include "mon.h"

#define GSM_MTYPCP (0)

#define RSGETSIZE (1<<2)
#define RSGETAUX  (1<<4)


ResFile::ResFile (const char* name, Card32 mode, Card32 revver, Card32 key,
		  void* ptr, Card16 mtyp, void* mdesc)
{
	close_mode = 0;
	asm (	"movel	%2,a3\n\t"
			"movel	%3,d2\n\t"
			"movel	%4,d4\n\t"
			"movel	%5,d3\n\t"
			"movel	%6,a4\n\t"
			"movew	%7,d1\n\t"
			"movel	%8,a1\n\t"
			".word	0xa7a0\n\t"		// RES_OPEN
			"movel	a2,%0\n\t"
			"movew	d7,%1\n\t"
		: "=g" (channel), "=g" (err)
		: "g" (name), "g" (mode), "g" (revver), "g" (key), "g" (ptr),
		  "g" (mtyp), "g" (mdesc)
		: "d1", "d2", "d3", "d4", "d7", "a1", "a2", "a3", "a4" );
	/*
	if (err != 0) {
		AfText ("ResFile::ResFile (...) : err = 0x");
		AfX4 (err); AfCR (); GetCar ();
		channel = 0;
	}
	*/
	if (err)
		this->must_close = FALSE;
	else
		this->must_close = TRUE;
}

void
ResFile::DefClose (Card32 mode, void* saver, Card32 savech)
{
	close_mode = mode;
	close_saver = saver;
	save_channel = savech;
}

void
ResFile::DefProgVar (void* ptr)
{
	if (this->must_close)
		asm (	"movel	%0,a2\n\t"
				"clrw	d0\n\t"		// D0 <- RSDEFPROGVAR
				"movel	%1,a4\n\t"
				".word	0xa7a4\n\t"	// RES_DEF
			:
			: "g" (channel), "g" (ptr)
			: "d0", "d7", "a2", "a4" );
}

ResFile::~ResFile ()
{
	if (this->must_close)
		asm (	"movel	%0,a2\n\t"
				"movel	%1,d2\n\t"
				"movel	%2,a0\n\t"
				"movel	%3,d6\n\t"
				".word	0xa7a3\n\t"		// RES_CLOSE
			:
			: "g" (channel), "g" (close_mode), "g" (close_saver), "g" (save_channel)
			: "d2", "d6", "d7", "a0", "a2" );
}


ResType::ResType (ResFile& file, Card32 type, Card32 key)
	: file(file),
	  key(key)
{
	if (!file.must_close) {
		this->err = file.err;
		this->is_ok = FALSE;
		return;
	}
	
	this->is_ok = TRUE;
	
	asm (	"movel	%3,a2\n\t"
			"movel	%4,d0\n\t"
			".word	0xa7a1\n\t"		// RES_GETTYPE
			"movel	a0,%0\n\t"
			"movel	d1,%1\n\t"
			"movew	d7,%2\n\t"
		: "=g" (handle), "=g" (resnum), "=g" (err)
		: "g" (file.channel), "g" (type)
		: "d0", "d1", "d7", "a0", "a2" );
	/*
	if (err != 0) {
		AfText ("ResType::ResType (...) : err = 0x");
		AfX4 (err); AfCR (); GetCar ();
		handle = resnum = 0;
	}
	*/
	
	if (err) {
		this->handle = 0;
		this->resnum = 0;
		this->is_ok = FALSE;
	}
}


Res::Res (ResType& type, Card32 num, Bool copy)
	: type(type),
	  num(num),
	  copy(copy)
{
	if (!type.is_ok) {
		this->err = type.err;
		return;
	}
	
	Card32 mode = (copy) ? RSGETCOPY : RSGETPOINTER;
	mode |= (type.key) ? RSGETSUBRES : 0;
	mode |= RSGETAUX|RSGETSIZE;
	
	register Card32 channel asm ("a2") = type.file.channel;
	asm (	"movel	%5,d2\n\t"
			"movel	%6,a0\n\t"
			"movel	%7,d1\n\t"
			"movel	%8,d3\n\t"
			".word	0xa7a2\n\t"		// RES_GET
			"movel	a3,%0\n\t"
			"movel	a4,%1\n\t"
			"movel	d4,%2\n\t"
			"movew	d7,%3\n\t"
		: "=g" (aux), "=g" (data), "=g" (k_size), "=g" (err)
		: "g" (channel), "g" (mode), "g" (type.handle), "g" (num), "g" (type.key)
		: "d1", "d2", "d3", "d4", "d7", "a0", "a3", "a4" );
	/*
	if (err != 0) {
		AfText ("Res::Res (...) : err = 0x");
		AfX4(err); AfCR (); GetCar ();
		aux = (Card32*)(0);
		data = 0;
		k_size = 0;
	}
	*/
	
	if (err) {
		aux = (Card32*)(0);
		data = 0;
		k_size = 0;
	}
}

Res::~Res ()
{
	if ((data == 0) || (k_size = 0)) return;

	if (copy)
		asm ( "movel %0,d1\n\t"
			  "movel %1,a4\n\t"
			  ".long 0x4E44002B"	// GESMEM ?GIVMEM
			:
			: "g" (GSM_MTYPCP), "g" (data)
			: "d1", "d7", "a4" );

	Card32 givmode = (type.key) ? RSGIVSUBRES : 0;
	asm (	"movel	%0,a2\n\t"
			"movel	%1,d2\n\t"
			"movel	%2,a0\n\t"
			"movel	%3,d1\n\t"
			"movel	%4,d3\n\t"
			".word	0xa7a8\n\t"		// RES_GIVE
		:
		: "g" (type.file.channel), "g" (givmode), "g" (type.handle), "g" (num), "g" (type.key)
		: "d1", "d2", "d3", "d7", "a0", "a2" );
}

