/*
 *	smicons.cxx
 *
 *	Waits for messages about icons from the display
 *	driver and sends events to the main program.
 *
 *	(C)	1994 Pierre ARNAUD, Daniel MARMIER
 */

#include "smevents.h"
#include "fos.h"

#include "mon.h"

extern EventBox* global_event_box;


struct IconMsg {
	Card8	type;
	Card8	subtype;
	Card8	num;
	Card8	state;
};

/*
static inline void
IconDisplay (IconMsg msg)
{
	static EvDispChanged ev;

	switch (msg.state) {
		case 0 :
			ev.inst &= ~(1 << msg.num);
			break;
			
		case 1 :
			ev.inst |= 1 << msg.num;
			break;
			
		case  2 :
			ev.inst	 |=	1 << msg.num;
			ev.active = 1 << msg.num;

			break;
		
		default :
			return;
	}
	
	global_event_box->PostEvent (ev);
}
*/

static inline void
IconKeyboard (IconMsg msg)
{
	EvCapsChanged ev;

	switch (msg.state) {
		case 'P' :
			ev.status = TRUE;
			break;
		case 'R' :
			ev.status = FALSE;
			break;
		default :
			return;
	}

	global_event_box->PostEvent (ev);
}


static inline void
IconMassMem (IconMsg msg)
{
	static EvUnitChanged ev;
	
	switch (msg.state) {
		case 0 :
			ev.inst		&= ~(1<<msg.num);
			ev.entered	&= ~(1<<msg.num);
			break;
			
		case 1 :
			ev.inst		|= 1<<msg.num;
			ev.entered	&= ~(1<<msg.num);
			break;
			
		case 2 :
			ev.inst		|= 1<<msg.num;
			ev.entered	|= 1<<msg.num;
			break;
			
		default :
			return;
	}
	
	global_event_box->PostEvent (ev);
}


/*
 *		the IconLoop process waits messages about icons from the
 *		display driver and sends events to the main program 
 *		using the IconXXX functions above.
 */

void IconLoop (Card32 param)
{
	NtrBAL bal (10);

//-	AfText ("IconLoop: BAL id is "); AfX8 (bal.GetBAL ()); AfCR ();

	char cmd[1+4+1];
	cmd[0] = 'B'|0x80;
	*(void**)(& cmd[1]) = bal.GetBAL ();
	cmd[5] = 0;

	Card16 ch;
	Fos::ArgsOpen ("$DIS_0", FOS_OPOPEN, 0, 0, 0, 0, 0, & ch);
	Fos::Command (ch, cmd);
	Fos::Close (ch);

	for (;;) {
		IconMsg msg;
		Card32 len;
		Card8 mode = 0;
		bal.GetMessage ((void**) & msg, & len, & mode);
		switch (msg.type) {
			/*
			case 'D' :			// display icon
				IconDisplay (msg);
				break;
			*/

			case 'K' :			// keyboard icon
				IconKeyboard (msg);
				break;

			case 'M' :			// mass memory icon
				IconMassMem (msg);
				break;
			
			default :
				
				break;
		}
	}
}
