/*
 *	smlib.cxx
 *
 *	Collects events from the system library
 *	and dispatches them to the main program.
 *
 *	(C)	1994 Pierre ARNAUD, Daniel MARMIER
 */

#include "lib.h"
#include "smevents.h"
#include "mon.h"

/********************************************************************/

static void
SoftKeyMenuChanged (const char* text, int bitset)
{
	static int  old_bitset = 0;
	
	EvSoftKeyChanged ev;
// this didn't redraw the text when text & bars changed
//	ev.text_changed = (bitset == old_bitset);
	ev.text_changed = TRUE;
	ev.bars_changed = (bitset != old_bitset);
	ev.bars = old_bitset = bitset;
	
	/*
	if (ev.bars_changed) {
		AfText ("In SKMenuChanged : changed bitset ");
		AfX8 ((Card32)(bitset));
		AfCR ();
	}
	*/
	
	char* ptr = & ev.text[0];
	for (int i = 0; i < 12; i++)
		while ((*ptr++ = *text++))
			/* nothing */ ;
	
	global_event_box->PostEvent (ev);
}

/********************************************************************/

static void
ClockTickOneSecond ()
{
	EvSecondElapsed ev;
	ev.seconds = 1;
	global_event_box->PostEvent (ev);
}

/********************************************************************/

/*
 *	The Lib Event Loop collects events from the system library
 *	and dispatches them to the main program.
 */

void
LibEventLoop (Card32 param)
{
	NtrSync synchronisation;
	
	Card32  wait_until_time = 0;
	Card32  current_time    = 0;
	Card16  relative_wait   = 0;
	
	//Card16  display_num     = 0;
	Card16  menu_access_num = 0;
	
	WAsskeyRecord wait_asskey = { 0 /* ... */ };
	WMenuRecord   wait_menu   = { 0 /* ... */ };
	
	Ntr::GetTimeMS (wait_until_time);
	Lib::WAsskey (wait_asskey, synchronisation);
	Lib::WMenu (wait_menu, synchronisation);
	
	for (;;) {
		
		Ntr::GetTimeMS (current_time);
		
		if (current_time >= wait_until_time) {
			
			//	The waiting time has been reached, so just tell the
			//	clock to tick one more second and update the waiting
			//	time to some new value.
			
			ClockTickOneSecond ();
			wait_until_time += 50;
		}
		
		relative_wait = (wait_until_time > current_time)
						? (Card16)(wait_until_time - current_time)
						: (Card16)(0);
		
		synchronisation.Wait (relative_wait);
		
		/*
		 *	This event sending is now done by $DIS itself
		 *
		if (wait_asskey.display_num != display_num) {

			//	The current display has changed. This might need some
			//	redrawing if the active pixmap changed.

			display_num = wait_asskey.display_num;
			DisplaySelected (display_num);
		}
		*/

		if (wait_menu.access_num != menu_access_num) {

			//	The soft-key menu has changed. The program will have
			//	to update the lower part of the screen to reflect the
			//	changes.

			menu_access_num = wait_menu.access_num;
			SoftKeyMenuChanged (wait_menu.text, wait_menu.bar_bitset);
		}
	}
}


