/*
 *	softkeys.h
 *
 *	Softkeys class for SMA_SMAKY
 *
 *	There are as many instances of softkeys
 *	as the number of DMs (Display Managers)
 *	installed.
 *
 *	(C)	1994	Daniel MARMIER
 *				for the original version
 *
 *		1994, 1995
 *				Erik BRUCHEZ
 *				for improvements, cleaning and
 *				maintainance
 */

#ifndef _SMA_SOFTKEYS_H_
#define _SMA_SOFTKEYS_H_


#define	POPUP_NO		0
#define	POPUP_YES		1
#define	POPUP_SLOW_ON	2
#define	POPUP_SLOW_OFF	4
#define	POPUP_CLICK_OFF	8

extern Card8 g_popup_mode;
extern Bool  g_popup_active;

struct SKData;
class LookMan;

class SoftKeys {
	Gra		*gra;					// drawing interface
	LookMan	*lookman;				// look manager
	
	//	Internals
	
	const SKData* data;
	
	Box	icons_boxes[6];
	Box	bars_boxes[16];
	Box	textes_boxes[12];
	
	Box	box;						// softkeys box in the screen
	
	void	*tbuffer;				// text graphics buffer
	Card16	tbuffer_width;			// and its width in bytes
	
	//	Softkeys state
	
	Card32	bars_bitset;
	char	text[500];
	Bool	is_empty;
	
	//	Keyboard management
	
	Card16	kbd_chan;
	
	Gencar*	nef07;
	Gencar*	nef11;
	
	//	Private methods
	
	Bool PosInBox (Pos pos, Box box);

public:
	SoftKeys (Gra *gra, LookMan	*lookman);
	~SoftKeys ();
	
	void SetBox (Box bos);
	void SizeChanged (Box box);
	void SetText (const char* text);
	void SetBars (Card32 bars);

	Gra* GetGra () { return this->gra; }
	Box GetBox () { return this->box; }
	
	void DrawAll ();
	void DrawText ();
	void DrawBars ();
	void DrawFrame ();
	
	Bool IsEmpty () const { return this->is_empty; }
	
	Bool Click (Pos pos, Card8 buttons_changed, Card8 buttons_pressed);
};

#endif /* _SMA_SOFTKEYS_H_ */

