/*
 *	spymouse.cxx
 *
 *	Mouse spying process for SMA_SMAKY
 *
 *	(C)	1994 Daniel MARMIER, Pierre ARNAUD
 *			 for the original version
 *
 *			 Erik BRUCHEZ
 *			 for improvements and cleaning
 */

#include "lib.h"
#include "gra.h"
#include "res.h"
#include "menu.h"
#include "softkeys.h"
#include "pixmapman.h"

extern PixmapMan pman;
extern Menu *menu[4];
extern SoftKeys *softkeys[4];

#define Process void


Process
SpyMouse (Card32 param)
{
	Pos pos;
	Card8 new_buttons = 0, current_buttons = 0, clicked;
	
	Bool is_valid, is_active, has_menu, has_softkeys;
	Box menu_box, sofkeys_box;
	
	for (;;) {
		Lib::SpyMouse ((Card32*) & pos, & new_buttons);
		
		//	See if any button changed
		
		if ( (new_buttons == 0)
		  || (current_buttons == new_buttons) ) {
			current_buttons = new_buttons;
			softkeys[pman.GetActiveDM ()]->Click (pos, 0, new_buttons);
			continue;
		}

		//	See if our windows are active
		
		for (int j = 0; j < pman.GetDMNumber (); j++) {
			is_valid = pman.GetInfo (j, is_active, has_menu, has_softkeys,
									 menu_box, sofkeys_box);
			
			if (is_valid && is_active) {
				
				//	We got the active screen
				//	Buttons have changed. Is it a click ?
				
				clicked = ~current_buttons & new_buttons;
				if (clicked & BUTTON_MIDDLE) break;
				
				//	It's a click. Is it in our windows ?
				//	The menu & softkeys make the test themselves.
				
				Bool acc = FALSE;
				
				if (has_menu) acc = menu[j]->Click (pos, clicked);
				if ((!acc)) softkeys[j]->Click (pos, clicked, new_buttons);
				
				current_buttons = new_buttons;
				break;
			}
		}
	}
}


