/*
 *	str.cxx
 *
 *	Strings utilities.
 *
 *	(C)	1995 Erik BRUCHEZ
 */

#include "str.h"


/*
 *	Compare two strings
 */

Bool
Str::Comp (const char *s1, const char *s2)
{
	if (s1 && s2) {
		do {
			if (*s1 != *s2++) return FALSE;
			if (*s1++ == 0) return TRUE;
		} while (1);
	}
	
	return FALSE;
}


/*
 *	Copy a string
 */

void
Str::Copy (char *d, const char *s)
{
	while (*d++ = *s++) ;
}


/*
 *	Copy a string, with limited size
 */

void
Str::NCopy (char *d, const char *s, Card32 n)
{
	while ( (*d++ = *s++) && (n--)) ;
}

/*
 *	Compute the len of a null-terminated string
 */

Card32
Str::Len (const char *s)
{
	Card32 len = 0;
	
	while (*s++) len++;
	
	return len;
}

