/*
 *	usericons.h
 *
 *	User icons interface for SMA_SMAKY
 *
 *	(C)	1995 Erik BRUCHEZ
 */

#ifndef _USER_ICONS_H_
#define _USER_ICONS_H_

#include "services.h"

#define USER_ICONS_SERVICE_ID (0x00000010)

enum IconRequestId
{
	OPEN_ICON_RID			= 0x00000010,
	CLOSE_ICON_RID			= 0x00000011,
	GET_ICONS_SIZES_NUM_RID = 0x00000012,
	GET_ICONS_SIZES_RID		= 0x00000013,
	SET_ICON_RID 			= 0x00000014,
	SHOW_ICON_RID 			= 0x00000015,
	HIDE_ICON_RID 			= 0x00000016
};

struct OpenIconRequest : ServiceRequest {
	
	//	Input
	
	Card8	width;
	Card8	position;
	
	Card16	res1;
	Card32	res2;
	
	//	Output
	
	Card32	icon_id;
	Card32	res3;
};


struct CloseIconRequest : ServiceRequest {
	
	//	Input
	
	Card32	icon_id;
	
	Card32	reserve;
};

struct GetIconsSizesNumRequest : ServiceRequest {
	
	//	Input
	
	Card32	res1;
	
	//	Output
	
	Card16	number;
	Card16	res2;
};

struct GetIconsSizesRequest : ServiceRequest {
	
	//	Input
	
	Card8	*buffer;
	Card32	reserve;
};

struct SetIconRequest : ServiceRequest {
	
	//	Input
	
	Card32	icon_id;
	Card16	icon_format;
	Card16	icon_size_num;
	void*	icon_data;
	Card32	res1;
	Card32	res2;
};

struct ShowIconRequest : ServiceRequest {
	
	//	Input
	
	Card32	icon_id;
};

struct HideIconRequest : ServiceRequest {
	
	//	Input
	
	Card32	icon_id;
};

#endif /* _USER_ICONS_H_ */

