/*
 *	waitkeys.cxx
 *
 *	Special keys interceptor for SMA_SMAKY
 *
 *	(C)	1994 Daniel MARMIER for the main code
 *
 *		1995 Erik BRUCHEZ for little modifications
 *
 */

/*
 *				  _
 *				 /-\			CAUTION : This file contains
 *				// \\			extremely awful code
 *			   //   \\			
 *			  // ___ \\			Sensitive people are STRONGLY
 *			 // /   \ \\		advised against reading this stuff
 *			//  |o o|  \\		
 *		   //   \ " /   \\		Misuse may cause permanent damage
 *		  //     |_|     \\
 *		 //               \\
 *		 ===================
 *
 */

#include "lib.h"
#include "fos.h"
#include "waitkeys.h"
#include "str.h"

#include "mon.h"

#define M0	(0x9a)
#define M1	(0x9b)
#define M3	(0x9d)

#define F16	(0xe0)
#define F17 (0xe1)
#define F18 (0xe2)
#define F19 (0xe3)

#define KRELEAS	(1<<0x17)

#define	CURSOR	(KCURSOR<<8)
#define COPY	(KCOPY	<<8)
#define KILL	(KKILL	<<8)
#define PROGRA	(KPROGRA<<8)
#define SHOW	(KSHOW	<<8)

#define KEYSIP (0x05)


#define Process void

static Card16	WFSKey (Card16 keychan, Card32* key);
static void		HandleSpecialKey(Card32 key);

static void		DumpScreen (const char* printer);
static Process	DumpBackground (Card32 param);
static void		StopPrinting ();

static void		Abort (const char* unit);
static Bool		ShowPixmap (Card8 pixmap);
static Card16	Install (const char* physname);
static void		UnitKeyOp (Card8 unit, Card32 key);


static NtrBAL bal_unit (2);
static const void* desc;			// points to display description for AssBitmap
static Bool dumping;				// screen dump in progress
static const char* printer;			// device accepting dump

Bool g_beep_m3 = TRUE;				// true if "big" beep when cle is shown
Bool g_beep_dump = TRUE;			// true if "done" beep when dumping done

Process
WaitSpecialKey (Card32 param)
{
	/*
	 *	We don't have any window anymore !
	 *
	desc = Lib::GetPDis ();
	 */
	
	//	Find a window descriptor for AssBitmap
	
	Card16 channel;
	
	Fos::Open ("$DIS_0:", FOS_OPRD, &channel);
	Fos::RStatus (channel, 4, &desc);
	Fos::Close (channel);
	
	//	Tell something to the keyboard...
	
	static Card8 init_keys[] = {
		KEYSIP, M0 & 0x7f,
		KEYSIP, M1 & 0x7f,
		KEYSIP, M3 & 0x7f,
	
		KEYSIP, F16 & 0x7f,
		KEYSIP, F17 & 0x7f,
		KEYSIP, F18 & 0x7f,
		KEYSIP, F19 & 0x7f,
		0, 0
	};

	Card16 kbd_chan = Lib::GChKey ();
	
	if (kbd_chan) {
		Fos::Command (kbd_chan, init_keys);
	} else {
		AfText ("SMA_SMAKY : FIRST keyboard channel not found in WaitKeys...");
		AfCR ();
	}
	
	//	Main loop
	
	for (;;) {
		Card32 key;
		if (WFSKey (kbd_chan, &key) == 0)
			HandleSpecialKey (key);
	}
}


void
HandleSpecialKey (Card32 key)
{
	if (key & KRELEAS) return;
	
	Card8 code = key & 0xff;

	switch (key & 0xffff) {
		case M3 :
			if (Lib::AssKey(1) == 0) {
				if (g_beep_m3) Lib::Beep (BIPBIG);
			} else {
				Lib::Beep (BIPLIT);
			}
			break;

		case M3+COPY :
			DumpScreen (NULL);
			break;

		case M3+SHIFT :
			DumpScreen ("#PRINTER:");
			break;

		case M3+CTRL :
			StopPrinting ();
			break;

		case F16 :
		case F17 :
		case F18 :
		case F19 :
			ShowPixmap (code - F16);
			break;

		case PROGRA+F16 :
		case PROGRA+F17 :
		case PROGRA+F18 :
		case PROGRA+F19 :
		case CURSOR+F16 :
		case CURSOR+F17 :
		case CURSOR+F18 :
		case CURSOR+F19 :
			ShowPixmap (code - F16 + 4);
			break;

		case SHOW+F16 :
		case SHOW+F17 :
//		case SHOW+F18 :
//		case SHOW+F19 :
		case COPY+F16 :
		case COPY+F17 :
//		case COPY+F18 :
//		case COPY+F19 :
			ShowPixmap (code - F16 + 8);
			break;

		case M0 :
		case M1 :
		case M0+SHIFT :
		case M1+SHIFT :
		case M0+CTRL :			//PA
		case M1+CTRL :			//PA
			UnitKeyOp (UNIT_TOGGLE, key);
			break;

		case CURSOR+M0 :
		case CURSOR+M1 :
		case CURSOR+SHIFT+M0 :
		case CURSOR+SHIFT+M1 :
		case CURSOR+M0+CTRL :	//PA
		case CURSOR+M1+CTRL :	//PA
			UnitKeyOp (UNIT_INST, key);
			break;
		
		case KILL+M0 :
		case KILL+M1 :
		case KILL+SHIFT+M0 :
		case KILL+SHIFT+M1 :
		case KILL+M0+CTRL :		//PA
		case KILL+M1+CTRL :		//PA
			UnitKeyOp (UNIT_KILL, key);
			break;
		
		default :
			Lib::Beep (BIPERR);
	}
}


void
DumpScreen (const char* printer_name)
{
	if (!dumping) {
		Card32 pid;
		Card16 pino;

		dumping = TRUE;
		printer = printer_name;
		Ntr::CreTask (DumpBackground, 1000, 4, "SmakyDump",
				   0, 0, &pid, &pino);
	}
	else
		Lib::Beep (BIPLIT);
}


Process
DumpBackground (Card32 param)
{
	if (printer)
		Fos::Create (printer, FOS_DEFATT, FOS_TYPRAND, 0);

	Card16 err = Lib::PFDump (printer, -1);
	if ( err == 0 || err == ERTRAV) {
		if (g_beep_dump) Lib::Beep(BIPDON);
	} else
		Lib::Beep(BIPERR);

	dumping = FALSE;
}


void
StopPrinting (void)
{
	char* phys_name;

	if ( Lib::GetUPh ("#PRINTER", &phys_name) == 0
	  || Lib::GetUPh ("#PRINT_OUT", &phys_name) == 0 )
		Abort (phys_name);
	else
		Lib::Beep (BIPERR);
}


void
Abort (const char* unit)
{
	unsigned short channel;
	if (Fos::ArgsOpen (unit, FOS_OPEXTEND|FOS_OPRSTATUS, 0, 0, 0, 0, 0, &channel) == 0) {
		Fos::Avort (channel);
		Fos::Close (channel);
	}
}


Bool
ShowPixmap (Card8 pixmap)
{
	if (Lib::AssBitmap (desc, pixmap) == 0) {
		return TRUE;
	} else {
		Lib::Beep (BIPERR);
		return FALSE;
	}
}

void
UnitKeyOp (Card8 op, Card32 key)
{
	Card8 unit = 0;

	switch (key & 0xff) {
		case M0 :
			unit = 0;
			break;
		case M1 :
			unit = 1;
			break;
		case SHIFT+M0 :
			unit = 2;
			break;
		case SHIFT+M1 :
			unit = 3;
			break;
		case CTRL+M0 :
			unit = 4;
			break;
		case CTRL+M1 :
			unit = 5;
			break;
		default :
			unit = 0xff;
			break;
	}
	
	UnitOp (op, unit);
}

void
UnitOp (Card8 op, Card8 unit)
{	
	bal_unit.GiveMessage ( (op << 8) | unit);
}


Process
UnitDo (Card32 param)
{
	for (;;) {
		Card32 msg;
		Card32 length;
		Card8 mode = 0;
		bal_unit.GetMessage ((void**)(& msg), & length, & mode);
	
		Card8 op = msg >> 8;
		Card8 unit = msg & 0xff;

		char *physname;
		Card16 icon;

		Card16 err = Fos::MmVAssign (unit, &physname, &icon);
		if ( (err == 0) && (physname[0]) ) switch (op) {
			case UNIT_TOGGLE :
				if (Fos::Release (physname, 0) == ERUNNI)
					Fos::Enter (physname, 0);
				break;

			case UNIT_INST :
//PA-begin
				if (Install (physname) != ERNDEV)
					break;
				
				//	We could not install the unit because it was already
				//	installed ! Therefore, we de-install it :
				
//PA-end
			case UNIT_KILL :
//PA			Install (physname);
				Fos::Release (physname, 0);
				char buf_vlogic[200];
				char* buf = & buf_vlogic[0];
				if (Fos::VLogic (physname, 0, -1, buf, 200) != 0)
					break;
				while (*buf) {
					Fos::Deassign (buf, 0);
					while (*buf++)
						/* skip to next logical name */ ;
				}
				Fos::Deinstall (physname, 0);
				break;
		}
	}
}

Card16
Install (const char* physname)
{
	Card16 err;
	char params[] = "";
	static char mmname[] = "#MMx:";
	const char* logname = & mmname[0];

	for (char c = '0'; c <= '9'; c++) {
		mmname[3] = c;
		Card8 subdriv;
		err = Fos::Install (logname, physname, params, 0, &subdriv);
//PA-begin		
		if (err == ERNDEV) return err;
		if (err == 0) return err;
		
		//	Try again. Some units (like $SCSI) need two attempts.
		
		err = Fos::Install (logname, physname, params, 0, &subdriv);
		if (err == 0) return err;
//PA-end
	}
	
	return 0xffff;
}


Card16
WFSKey (Card16 keychan, Card32* key)
{
	Card16 err;
	asm(	"movew	%2,d6\n\t"
			"subl	a3,a3\n\t"
			"clrl	d5\n\t"
			"subl	a4,a4\n\t"
			"clrl	d4\n\t"
			".long	0x4e450068\n\t"
			"movel	d3,%0\n\t"
			"movew	d7,%1\n\t"
		: "=g" (*key), "=g" (err)
		: "g" (keychan)
		: "d3", "d4", "d5", "d6", "d7", "a3", "a4" );
	
	return err;
}


//		If you enjoy PsOS, you should try M?-D*S ...

