/*
 *	start_ins.cc
 *
 *	Installateur de fichiers comprims utilis par START.
 *
 *	(C) Copyright 1995,  Pierre ARNAUD, OPaC bright ideas
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <c++/portable.h>

struct BootBlock
{
	char		sys[44];
	char		nlo[16];
	Card32		chk;
	char		mes[172];
	char		change;
	char		bonchk;
	char		filler[18];
};

extern "C" int F_infodisk (const char *name, BootBlock* bootblk);

#include "install.h"

Card32 _stksize  = 10*1024;				// pile
Card32 _SMASOVER = 1;					// entre OVERLAY de prfrence
Card8  _SMAPRIO  = 16;					// priorit leve
Card8  _SMAREV   = 0;					// rvision
Card8  _SMAVER   = 3;					// version
Card32 _SMAUNIT  = 0x00000027;			// force overlay
Card16 _SMADIS[] = {20,2000,20,2000};	// petite fentre
char   _SMAIDE[] = "(C) Copyright 1995-1996, Pierre ARNAUD, OPaC bright ideas";

static char s_unit[100];
static char d_unit[100];
static char s_unit_sys[100];
static char d_unit_sys[100];
static Bool debug = FALSE;


/*
 *	Ajoute un terminateur aprs le dernier nom de dossier.
 */

static void
make_dir_only (char* name)
{
	char* end = name;
	
	while (name[0]) {
		if (*name++ == ':') end = name;
	}
	
	end[0] = 0;
}


/*
 *	Extrait l'information sur l'unit de destination et le
 *	dossier systme de celle-ci.
 */

static void
make_unit (char* name, char* unit, char* unit_sys)
{
	BootBlock block;
	char*     punit = unit;
	
	while (*name) {
		*punit++ = *name;
		if (*name++ == ':') {
			if (name[0] == '#') continue;
			if (name[0] == '@') continue;
			if (name[0] == '$') continue;
			break;
		}
	}
	
	punit[0] = 0;
	
	//	Maintenant que l'unit de destination a t dtermine, cherche 
	//	connatre le dossier systme de celle-ci.
	
	F_infodisk (unit, & block);
	
	strcpy (unit_sys, unit);
	strcat (unit_sys, block.sys);
}


/*
 *	Lit une ligne depuis le fichier spcifi.
 */

Bool
get_line (char* buffer, FILE* file)
{
	char* org = buffer;
	int   c   = fgetc (file);
	
	while (c != EOF) {
		if ((c == '\r') || (c == '\n')) break;
		*buffer++ = c;
		c = fgetc (file);
	}
	
	buffer[0] = 0;
	
	if (debug) printf (">> %s\n", org);
	
	return (c == EOF) ? FALSE : TRUE;
}


/*
 *	Excute une commande en remplaant les "%.." par leurs
 *	valeurs respectives.
 */

void
execute_cmd (const char* cmd, const char* arg[])
{
	char buffer[1000];
	char mini[4];
	
	buffer[0] = 0;
	
	while (cmd[0]) {
		
		if (cmd[0] == '%') {
			switch (cmd[1]) {
				case 's':
				case 'S':
					strcat (buffer, arg[ARG_SOURCE]);
					break;
				
				case 'd':
				case 'D':
					strcat (buffer, arg[ARG_DESTINATION]);
					break;
				
				case 'x':
				case 'X':
					strcat (buffer, arg[ARG_SCRIPT]);
					break;
				
				case 'u':
				case 'U':
					strcat (buffer, d_unit);
					break;
				
				case '>':
					strcat (buffer, d_unit_sys);
					break;
				
				case 'v':
				case 'V':
					strcat (buffer, s_unit);
					break;
				
				case '<':
					strcat (buffer, s_unit_sys);
					break;
				
				case 0:
					cmd--;
					break;
				
				default:
					strcat (buffer, "%?");
					break;
			}
			
			cmd += 2;
			continue;
		}
		
		mini[0] = *cmd++;
		mini[1] = 0;
		
		strcat (buffer, mini);
	}
	
	if (debug) printf ("-- %s\n", buffer);
	
	system (buffer);
}


int
main (int argc, char* argv[])
{
	debug = getenv ("DEBUG_INS") ? TRUE : FALSE;
	
	const char* opt = argv[0];
	while (*opt++ != '/');
	
	char* arg_1 = argv[1];
	char* arg_2 = argv[2];
	
	if (argc < 3) return 1;
	
	switch (opt[0]) {
		
		case '1':
			make_dir_only (arg_1);
			make_unit (arg_1, d_unit, d_unit_sys);
			make_unit (arg_1, s_unit, s_unit_sys);
			do_delete (arg_1, argc-2, argv+2);
			break;
		
		case '2':
			make_dir_only (arg_1);
			make_dir_only (arg_2);
			make_unit (arg_2, d_unit, d_unit_sys);
			make_unit (arg_1, s_unit, s_unit_sys);
			do_move (arg_1, arg_2, argc-3, argv+3);
			break;
		
		case '3':
			make_dir_only (arg_1);
			make_dir_only (arg_2);
			make_unit (arg_2, d_unit, d_unit_sys);
			make_unit (arg_1, s_unit, s_unit_sys);
			do_copy (arg_1, arg_2, argc-3, argv+3);
			break;
		
		default:
			break;
	}
	
	if (debug) getchar ();
	
	return 0;
}


