{$V-}
PROGRAM arbre ;

{ Affiche l'arbre des dossiers d'un disque. Une pression  }
{ sur (END) stoppe le programme.                          }
{ L'algorithme est rcursif donc particulirement simple. }


{$I PAS_FOSLIST.BIB}
{$I PAS_LIBMISC.BIB}
{$I PAS_FOS.BIB}


TYPE
  string200 = String [200] ;
  
VAR
  niveau : Integer ;
  dossier : string200 ;
  pargs : fosargsptr ;
  fin : Boolean ;
  ch : Char ;




VAR
  lcrit : string200 ;
  unixpath : string200 ;


FUNCTION isdir (VAR s:string) : BOOLEAN ;
BEGIN
  if (length(s) > 4) then begin
    if (copy (s, length(s) - 3, 4) = '.DIR') then begin
      isdir := TRUE ;
      exit ;
    end ;
  end ;
  isdir := false ;
END ;


PROCEDURE transdir (VAR s:string) ;
var
  dir : string200 ;
BEGIN
  if (isdir(s)) then begin
    dir := copy (s, 1, length(s) - 4) ;
    dir := concat (dir, ':') ;
    s := dir ;
  end ;
END;


PROCEDURE chdir (s:string) ;
VAR
  d : string200 ;
  err : integer ;
begin
  d := s ;
  if (isdir (s)) then 
    transdir (d) ;
   fos_dir (d, err) ;
end ;


PROCEDURE add_dir (VAR s:string200; VAR d:string200) ;
VAR
  dir : string200 ;
  
BEGIN
  dir := d ;
  transdir (dir) ;
  s := concat (s, dir) ;
END ;


PROCEDURE sub_dir (VAR s:string) ;
VAR
  i : integer ;
  ch : char ;
  
BEGIN
  ch := ':' ;
  i := length (s) - 1 ;
  while ((i > 0) AND (copy (s,i,1) <> ch)) DO BEGIN
    dec (i) ;
  END ;
  s := copy (s, 1, i) ;
END ;


PROCEDURE subst_colon (var dossier:string; var unixpath:string) ;
VAR
  i,len : Integer ;
  
BEGIN
  len := length(dossier) ;
  unixpath := dossier ;
  if (len > 0) then
  for i := 1 to len do begin
    if (unixpath[i] = ':') then
      unixpath[i] := '/'
  end ;
END;


PROCEDURE liste (VAR out:text) ;
VAR nb : Integer ;
    i,can,err : Integer ;
    fich : string200 ;
    ext : string[20] ;
    
BEGIN
  fos_listopen (dossier,lcrit,licnom,nb,can,err) ;

  if err<>0 THEN BEGIN
    Write (dossier,' : ') ;
    lib_aferror (err) ;
    Writeln ;
  END ELSE
    REPEAT
      ch := 'a' ;
      IF KeyPressed THEN Read (Kbd,ch) ; 
      IF ch=Chr($92) THEN fin:=True       
      ELSE BEGIN
        fos_listnxt (can,fich,pargs,err) ;
        IF err=0 THEN BEGIN 
          subst_colon (dossier, unixpath) ;
          WriteLn (out,unixpath,fich) ;
          if (isdir (fich)) then begin
            Inc (niveau) ;
            add_dir (dossier, fich) ;
            liste (out) ;
            sub_dir (dossier) ;
          end ;
          Dec (niveau) ;
        END ;
      END ;
    UNTIL (err<>0) OR fin;
    fos_listclose(can,err) ;
END ;


PROCEDURE makelist (crit:string200; VAR out:text) ;
begin
  dossier := '' ;
  lcrit := concat ('*.DIR|', crit) ;
  liste (out) ;
end ;



PROCEDURE zip_multiple_files (crit:string200; filename:string200) ;
VAR
  out:text ;
begin
  rewrite (out, '__TMP__') ;
  makelist ('*.c', out) ;
  close (out) ;
end;

var s,x : string ;

BEGIN
  fin := False ;
  Writeln ('Arbre des dossiers. (END) arrte.') ;
  makelist ('*.c', output) ;
  zip_multiple_files ('*.c', 'zipfile') ;
  readln ; 
END.
