{$V-}
PROGRAM test ;

{ procdures utilitaires pour zipper }


{$I PAS_FOSLIST.BIB}
{$I PAS_LIBMISC.BIB}
{$I PAS_FOS.BIB}


TYPE
  string200 = String [200] ;
  

{ teste si un fichier est un rpertoire }

FUNCTION isdir (VAR s:string) : BOOLEAN ;
BEGIN
  if (length(s) > 4) then begin
    if (copy (s, length(s) - 3, 4) = '.DIR') then begin
      isdir := TRUE ;
      exit ;
    end ;
  end ;
  isdir := false ;
END ;


{ transforme un nom de rpertoire 'XX.DIR' en 'XX:' }

PROCEDURE transdir (VAR s:string) ;
var
  dir : string200 ;
BEGIN
  if (isdir(s)) then begin
    dir := copy (s, 1, length(s) - 4) ;
    dir := concat (dir, ':') ;
    s := dir ;
  end ;
END;


{ ajoute un rpertoire  la fin d'une chane de de rpertoires }

PROCEDURE add_dir (VAR s:string200; VAR d:string200) ;
VAR
  dir : string200 ;
  
BEGIN
  dir := d ;
  transdir (dir) ;
  s := concat (s, dir) ;
END ;


{ supprime le dernier rpertoire dans une chane de rpertoires }

PROCEDURE sub_dir (VAR s:string) ;
VAR
  i : integer ;
  ch : char ;
  
BEGIN
  ch := ':' ;
  i := length (s) - 1 ;
  while ((i > 0) AND (copy (s,i,1) <> ch)) DO BEGIN
    dec (i) ;
  END ;
  s := copy (s, 1, i) ;
END ;


{ substitue tous les ':' dans une chane par '/' }

PROCEDURE subst_colon (var dossier:string; var unixpath:string) ;
VAR
  i,len : Integer ;
  
BEGIN
  len := length(dossier) ;
  unixpath := dossier ;
  if (len > 0) then
  for i := 1 to len do begin
    if (unixpath[i] = ':') then
      unixpath[i] := '/'
  end ;
END;



{ variables globales pour la procdure liste }

VAR
  dossier : string200 ;
  pargs : fosargsptr ;
  lcrit : string200 ;
  unixpath : string200 ;
  ch : char ;
  fin : boolean ;


{ fait la liste de tous les fichiers du rpertoire courant et crit
  le rsultat dans le fichier out }

PROCEDURE liste (VAR out:text) ;
VAR nb : Integer ;
    i,can,err : Integer ;
    fich : string200 ;
    ext : string[20] ;
    
BEGIN
  fos_listopen (dossier,lcrit,licnom,nb,can,err) ;

  if err<>0 THEN BEGIN
    Write (dossier,' : ') ;
    lib_aferror (err) ;
    Writeln ;
  END ELSE
    REPEAT
      { teste si l'utilisateur presse sur END }
      ch := 'a' ;
      IF KeyPressed THEN Read (Kbd,ch) ; 
      IF ch=Chr($92) THEN fin:=True       
      ELSE BEGIN
        fos_listnxt (can,fich,pargs,err) ;
        IF err=0 THEN BEGIN 
          subst_colon (dossier, unixpath) ;
          WriteLn (out,unixpath,fich) ;
          if (isdir (fich)) then begin
            add_dir (dossier, fich) ;
            liste (out) ;
            sub_dir (dossier) ;
          end ;
        END ;
      END ;
    UNTIL (err<>0) OR fin;
    fos_listclose(can,err) ;
END ;


PROCEDURE makelist (crit:string200; VAR out:text) ;
begin
  dossier := '' ;
  lcrit := concat ('*.DIR|', crit) ;
  liste (out) ;
end ;


{ zippe de fichiers et des sous-dossiers du dossier courant }

PROCEDURE zip_multiple_files (crit:string200; filename:string200; VAR err:integer) ;
{
  crit : critre de recherche, p.ex: '*.c|*.h'
  filename : nom du .zip de dstination
  err : erreur
}

VAR
  out:text ;
  newproc : integer ;
  execstring : string200 ;
  
begin
  rewrite (out, '___TMP___') ;
  makelist (crit, out) ;
  close (out) ;

  execstring := concat ('zip -@ ', filename) ;
  execstring := concat (execstring, ' <___TMP___') ;

  fos_execute (execstring,newproc, err) ;
  
  erase (out) ;
end;




{ programme de test }

var err:integer ;

BEGIN
  fin := False ;
  zip_multiple_files ('*.c', 'zipfile', err) ;
  readln ;
END.
