
#ifdef smaky
#include <filer.h>
#endif

#include <time.h>
#include <stdio.h>

main()
{ 
  unsigned ddate, dtime ;

  scanf ("%d", &ddate) ;
  scanf ("%d", &dtime) ;
  
  printf ("%d %d\n", ddate, dtime) ;
  
  printf ("%d\n", dos_to_unix_time(ddate, dtime)) ;
  exit (0) ;
}


/*********************************/
/*  Function dos_to_unix_time()  */
/*********************************/

time_t dos_to_unix_time(ddate, dtime)
    unsigned ddate, dtime;
{
    static short yday[]={0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    int yr, mo, dy, hh, mm, ss, leap;
    long m_time, days=0;
#if (!defined(MACOS) && !defined(MSC) && !defined(__GO32__))
#if (defined(BSD) || defined(MTS))
#ifndef __386BSD__
    static struct timeb tbp;
#endif /* __386BSD__ */
#else /* !(BSD || MTS) */
    extern long timezone;    /* declared in <time.h> for MSC (& Borland?) */
#endif /* ?(BSD || MTS) */
#endif /* !MACOS && !MSC && !__GO32__ */

#   define YRBASE  1970

    /* dissect date */
    yr = ((ddate >> 9) & 0x7f) + (1980 - YRBASE);
    mo = ((ddate >> 5) & 0x0f) - 1;
    dy = (ddate & 0x1f) - 1;

    /* dissect time */
    hh = (dtime >> 11) & 0x1f;
    mm = (dtime >> 5) & 0x3f;
    ss = (dtime & 0x1f) * 2;

    /* leap = # of leap years from BASE up to but not including current year */
    leap = ((yr + YRBASE - 1) / 4);   /* leap year base factor */

    /* How many days from BASE to this year? (& add expired days this year) */
    days = (yr * 365) + (leap - 492) + yday[mo];

    /* if year is a leap year and month is after February, add another day */
    if ((mo > 1) && ((yr+YRBASE)%4 == 0) && ((yr+YRBASE) != 2100))
        ++days;                 /* OK through 2199 */

    /* convert date & time to seconds relative to 00:00:00, 01/01/YRBASE */
    m_time = ((long)(days + dy) * 86400L) + ((long)hh * 3600) + (mm * 60) + ss;
      /* - 1;   MS-DOS times always rounded up to nearest even second */

#if (!defined(MACOS) && !defined(__GO32__))
#if (defined(BSD) || defined(MTS))
#ifndef __386BSD__
    ftime(&tbp);
    m_time += tbp.timezone * 60L;
#endif
#else /* !(BSD || MTS) */
#ifdef WIN32
    /* later... */
#else /* !WIN32 */
    tzset();                    /* set `timezone' */
#endif /* ?WIN32 */
    m_time += timezone;         /* account for timezone differences */
#endif /* ?(BSD || MTS) */
#endif /* !MACOS && !__GO32__ */

#ifdef __386BSD__
    m_time += localtime((time_t *) &m_time))->tm_gmtoff;
#else
    if (localtime((time_t *)&m_time)->tm_isdst)
        m_time -= 60L * 60L;    /* adjust for daylight savings time */
#endif /* __386BSD__ */

    return m_time;

} /* end function dos_to_unix_time() */
