
	.TITLE	DEMO.ASM

; Met en vidence l'utilisation de la carte couleur. Alloue un pixmap
; en 16 bit/pixel (en fait [5:5:5]) et permet de commuter de fentre
; tout en retombant sur ses pieds !

	.PROC	M68020
	.LOC	0
	.START	0

	.REF	SMAKY
	.REF	HWDIS
	.REF	DISPLAYMAN

PCCODE		= 0
PCVAR		= 1

	.LOC	0

; Simule du 3-3-2 en 16 bit/pixel

MASK		= 2'1100011100111000

START:	MOVE.32	#R16^NMLOG$,A3
	MOVE.32	#2**BOPOPEN,D3
	FOS	?ARGSOPEN		; ouvre $HWDIS
	JUMP,NE	ERR$

	LIB	?GETPDIS
	MOVE.32	{A4}+ODFVAR+4,A2	; A2 <-- canal display manager

	CLR.32	D2
	MOVE.32	#15,D3
	MOVE.32	#16'10000*480+640,D4
	CALL	DM_Open			; ouvre un pixel map (=> D5/D4/A4)
	JUMP,NE	ERR$

; D5.32	canal du pixmap
; A4.32	^sur dbut du pixmap
; D4.32	largeur en bytes
; A3.32	^descripteur (permet de savoir o sont R:G:B)

	CLR.32	D2
	CALL	DM_Show			; montre mon pixel map

	PUSHM.32 D2|D5|A4
	LIB	?GETPDIS
	MOVE.32	{A4}+ODFVAR+8,D0	; D0 <-- canal normal
	MOVE.32	D5,{A4}+ODFVAR+8	; notre canal  la place
	POPM.32	D2|D5|A4

	CALL	LinearCLUT
	CALL	Draw16Bit

	LIB	?GETCAR

	PUSHM.32 D2|D5|A4
	LIB	?GETPDIS
	MOVE.32	D0,{A4}+ODFVAR+8
	MOVE.32	D0,D5			; D5 <-- canal normal
	CALL	DM_Show			; montre le pixmap normal
	POPM.32	D2|D5|A4

	CLR.32	D2
	CALL	DM_Close		; libre le pixel map

	FOS	?CLOSE
	EXIT

ERR$:	LIB	?AFERROR
	EXIT


NMPHY$:		.ASCIZ	"$HWDIS:"
NMLOG$:		.ASCIZ	"#HWDIS:"


	.INS	DMINTERFACE.ASI

Draw16Bit:
	PUSHM.32 D0|D1|D3|A0..A3

	MOVE.32	A4,A3
	MOVE.32	D4,D3
	MUL.32	#240,D3
	ADD.32	D3,A3
	SR.32	#.LOG2.4,D3

Clr$:	MOVE.32	#2'11111111111111101111111111111110,{A3+}
	DEC.32	D3
	JUMP,NE	Clr$

	MOVE.32	A4,A3
	MOVE.32	#480-1,D3

Loop$:	MOVE.32	#{A3}+2**7,A0
	MOVE.32	#{A0}+2**7,A1
	MOVE.32	#{A1}+2**7,A2
	MOVE.32	#0,D0

Fill$:	SL.32	#1,D0
	MOVE.16	D0,{A0+}	; [00000:00000:rrrrr:0]
	AND.16	#MASK,{A0}-2
	SL.32	#5,D0
	MOVE.16	D0,{A1+}	; [00000:ggggg:00000:0]
	AND.16	#MASK,{A1}-2
	SL.32	#5,D0
	MOVE.16	D0,{A2+}	; [bbbbb:00000:00000:0]
	AND.16	#MASK,{A2}-2
	SR.32	#5,D0
	SR.32	#5,D0
	SR.32	#1,D0

	MOVE.32	D0,D1
	SL.32	#5,D1
	OR.32	D0,D1
	SL.32	#5,D1
	OR.32	#2'11111,D1
	SL.32	#1,D1
	MOVE.16	D1,{A2}+2**7	; rouge -> rose -> blanc
	AND.16	#MASK,{A2}+2**7

	MOVE.32	#2'11111,D1
	SL.32	#5,D1
	OR.32	#2'11111,D1
	SL.32	#5,D1
	OR.32	D0,D1
	SL.32	#1,D1
	MOVE.16	D1,{A2}+2**8	; cyan -> blanc
	AND.16	#MASK,{A2}+2**8

	INC.16	D0
	COMP.32	#2**5,D0
	JUMP,NE	Fill$

	ADD.32	D4,A3
	DJ.16,NMO D3,Loop$

	POPM.32	D0|D1|D3|A0..A3
	RET


LinearCLUT:
	PUSHM.32 D0|D1|D2|D3|D4|A4

	MOVE.8	#0,D0

LOOP$:	MOVE.8	D0,D3
	MOVE.8	D3,D2
	SL.32	#8,D2

	SR.8	#3,D3
	MOVE.8	D3,D1
	AND.16	#16'0F,D1
	MOVE.8	R8^T$+A16^{D1},D1
	AND.16	#16'F0,D3
	OR.16	D1,D3
	SWAP.8	D3
	MOVE.8	D3,D1
	AND.16	#16'0F,D1
	MOVE.8	R8^T$+A16^{D1},D1
	AND.16	#16'F0,D3
	OR.16	D1,D3

move.8 d0,d3
sl.8 #3,d3

	MOVE.8	D3,D2
	SL.32	#8,D2
	MOVE.8	D3,D2
	SL.32	#8,D2
	MOVE.8	D3,D2
	PUSH.32	D2
	MOVE.32	SP,A4
	MOVE.32	#0,D2
	MOVE.32	#1,D4
	CALL	DM_Color
	POP.32	D2
	INC.8	D0
	JUMP,NE	LOOP$

	POPM.32	D0|D1|D2|D3|D4|A4
	CLR.16	D7
	RET

T$:	.8	2'0000
	.8	2'1000
	.8	2'0100
	.8	2'1100
	.8	2'0010
	.8	2'1010
	.8	2'0110
	.8	2'1110
	.8	2'0001
	.8	2'1001
	.8	2'0101
	.8	2'1101
	.8	2'0011
	.8	2'1011
	.8	2'0111
	.8	2'1111


	.END

