; $CALM;

		.TITLE	HWDIS.ASD

;	--------------------------------------------
;		(C) 1994-1997  Pierre ARNAUD
;	--------------------------------------------

;	Source du pilote cran hardware portable.

		.PROC	M68020
		.BASE	10'10

REVMAJ	= 1
REVMIN	= 2

; Date     Rv	Remarques
; ------------------------------------------------------------------------
; 20/07/97 1.2  Autorise l'absence de oDMCMode.
; 06/06/97 1.1  Ajout paramtres pour cHWPixmapOpen.
; 04/03/97 1.0	Dcharge rellement le .DIS en cas d'erreur.
; 30/05/96 0.9	Appel pour accder aux fonctions de dessin.
;		Points d'entre facultatifs dans les DMs.
; 16/03/95 0.8  Nouvel appel de consultation.
; 23/02/95 0.7  Nouveaux points d'entre pour display managers.
;		Meilleure gestion intercrans de la souris.
; 07/10/94 0.6	Ajout support pour DynInfo.
; 13/08/94 0.5	Correction concernant MonInfo.
; 12/08/94 0.4	Version complte, supporte RSTATUS. Attention, il y a un
;		changement pour "cHWPixmapOpen" !
; 11/08/94 0.3	Version provisoire, RSTATUS incomplet !
; 20/07/94 0.2	Version de test, premire dition.
; 14/07/94 0.1	Premire version base sur les anciens sources du projet
;		"sys_9".
; ------------------------------------------------------------------------

		.REF	SMAKY
		.REF	BIOSDRIV
		.REF	BIOS
		.REF	DISPLAYMAN
		.REF	HWDIS
		.REF	MON

		.REV	REVMAJ, REVMIN
		.CODE	800,11,2'000111,600,2000,300,2000,2,"N","E","F",11
		.IDENT	"(C) 1994-1997  Pierre ARNAUD et EPSITEC SA"
		.START	-1

PCCODE		= 0
PCVAR		= 1


;	Macros
;	------

.MACRO	DISPLAY ; reg, offset
.LOCALMACRO Err
.IF 1
	PUSHM.32 A0|A2
	PUSH.32	{%1}+oDMChannel
	MOVE.32	{%1}+oDMHeader,A0	; A0 <-- ^en-tte
	POP.32	A2			; A2 <--  canal
	MOVE.16	#-1,D7
	TEST.16	{A0}+%2			; fonction prsente ?
	JUMP,EQ	R8^Err
	ADD.A16	{A0}+%2,A0		; A0 <-- ^routine
	CALL	{A0}			; appelle la routine
Err:
	TEST.16	D7
	POPM.32	A0|A2
.ELSE
	PUSHM.32 A0|A2
	PUSH.32	{%1}+oDMChannel
	MOVE.32	{%1}+oDMHeader,A0	; A0 <-- ^en-tte
	ADD.A16	{A0}+%2,A0		; A0 <-- ^routine
	POP.32	A2			; A2 <--  canal
	CALL	{A0}			; appelle la routine
	POPM.32	A0|A2
.ENDIF
.ENDMACRO

.MACRO	CHECK_DM_ID ; reg
	.LOCALMACRO OK
	COMP.32	{%1}+oDMSelfCheck,%1	; check ok ?
	JUMP,EQ	R8^OK
	MON	?AFTIM
	.ASCIZE	"HWDIS: Chk<CR>"
	TRAP	#1
OK:
.ENDMACRO


;	Constantes
;	----------

cMaxDM		= cHWMaxDisplay		; au maximum 4 display managers


;	Dfinition d'un display manager
;	-------------------------------

		.LOC	0

oDMIsOk:	.BLK.8	1		; TRUE => disponible
		.BLK.8	3		; rserve
oDMChannel:	.BLK.32	1		; canal du display manager (@DM 26/2/95 : NE PAS DEPLACER !)
oDMHeader:	.BLK.32	1		; ^en-tte du display manager
oDMSelfCheck:	.BLK.32	1		; check pour vrification
oDMMonInfo:	.BLK.32	1		; ^infos oHWMon.. (ou 0)
oDMDynInfo:	.BLK.32	1		; ^infos oDMI.. (ou 0)
oDMCursFuncs:	.BLK.32	1		; ^table de fonctions d'accs au curseur
lgDMRec:


;	Variables globales
;	------------------

		.LOC	0

oVARBasePtr:	.BLK.32	1		; ^base du driver (pour GESMEM)
oVARDMTable:	.BLK.8	cMaxDM*lgDMRec	; table des displays disponibles
lgVARRec:


;	Dbut du code du driver
;	-----------------------

		.APC	PCCODE
		.LOC	0

		.16	0,D0BASE
		.16	2**7



; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $HWDIS_0		No 16'39
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

D0ID:
		.16	-1			; D0OPEN-D0BASE
		.16	-1			; D0COMMAND-D0BASE
		.16	D0RSTATUS-D0BASE
		.16	-1			; D0READ-D0BASE
		.16	-1			; D0WRITE-D0BASE
		.16	-1			; D0CLOSE-D0BASE
		.16	-1			; STOPTR
		.16	-1			; STARTR
		.16	-1			; AVORTTR
		.16	D0AUX1-D0BASE
		.16	-1			; D0AUX2-D0BASE
		.16	D0RESET-D0BASE
		.16	D0KILL-D0BASE
		.16	-1			; D0STRT-D0BASE
		.16	-1			; D0TSTRT-D0BASE
		.16	-1			; D0START-D0BASE

D0NAB:		.ASCII	"HWDIS_0"		; nom du driver
		.FILL.8 LGDNAM-(APC-D0NAB),0

		.8	16'39			; numro du driver
		.8	TYPDIS			; type pixmap complet

		.8	REVMAJ,REVMIN		; rvision et version
		.16	0			; variante

		.8	0
		.8	(.BIT.BDRDOK).OR.(.BIT.BDWROK)

		.FILL.8 LGDDESC-(APC-D0ID),0	; le reste.
D0BASE:



;----------\\
;  D0RESET  >
;==========/

; Initialise le pilote cran physique.

; in	A0.32	^base du driver
;	A2.32	^paramtres (ignor pour l'instant)
; out	A6.32	^variables du pilote
;	D7.16	erreur
; mod	A6.32, D7.16, D0,D1,A0,A1

D0RESET:
	PUSHM.32 D4|A4

	MOVE.32	A0,A1			; A1 <-- ^base du driver
	MOVE.32	#MTYPBD,D1		; D1 <-- compte mmoire
	MOVE.32	#lgVARRec,D4
	GESMEM	?GETMEM			; A4 <-- ^variables
	JUMP,NE	ERR$

	GESMEM	?CLEARMEM
	MOVE.32	A4,A6			; A6 <-- ^variables mises  zro

	MOVE.32	A1,{A6}+oVARBasePtr	; prend note du ^base du driver

ERR$:	POPM.32	D4|A4
	TEST.16	D7
	RET



;---------\\
;  D0KILL  >
;=========/

; Libre les ressources utilises par le pilote.

; in	-
; out	D7.16	erreur
; mod	D7.16, D0,D1,A0,A1

D0KILL:
	PUSHM.32 D4|A3|A4

	MOVE.32	#{A6}+oVARDMTable,A0
	MOVE.32	#cMaxDM-1,D0

Free$:	TEST.8	{A0}+oDMIsOk		; ok ?
	JUMP,F	R8^Next$		; non => suite

	DISPLAY	A0,oHDMKill		; tue le display manager

	MOVE.32	{A0}+oDMHeader,A1
	MOVE.32	#{A1}+oHDMName,A3
	FOS	?CUNLOAD		; dcharge le fichier

Next$:	ADD.A16	#lgDMRec,A0
	DJ.16,NMO D0,Free$

	MOVE.32	{A6}+oVARBasePtr,A1	; A1 <-- ^base du driver
	MOVE.32	#MTYPBD,D1		; D1 <-- compte mmoire
	MOVE.32	A6,A4			; A4 <-- ^mmoire
	GESMEM	?GIVMEM			; libre les variables

ERR$:	POPM.32	D4|A3|A4
	TEST.16	D7
	RET


;------------\\
;  D0RSTATUS  >
;============/

; Lit les statuts du pilote.

; in	A4.32	^buffer
;	D4.32	longueur (#lgHWStatDisRec)
; out	{A4}++	mis  jour
;	D7.16	ok/erreur
; mod	D7.16, D0,D1,A0,A1

D0RSTATUS:
	MOVE.16	#ERIRLG,D7		; "longueur illgale"

	COMP.32	#lgHWStatDisRec,D4
	JUMP,NE	R8^Err$

	GESMEM	?CLEARMEM		; efface les statuts

	MOVE.32	#{A6}+oVARDMTable,A0	; A0 <-- table
	MOVE.32	A4,A1			; A1 <-- statuts
	MOVE.32	#cMaxDM-1,D0

Copy$:	TEST.8	{A0}+oDMIsOk		; ok ?
	JUMP,F	R8^Next$

	MOVE.32	A0,{A1}+oHWDisChannel
	MOVE.32	{A0}+oDMHeader,{A1}+oHWDisHeader
	MOVE.32	{A0}+oDMMonInfo,{A1}+oHWDisMonInfo
	MOVE.32	{A0}+oDMDynInfo,{A1}+oHWDisDynInfo

Next$:	ADD.A16	#lgDMRec,A0
	ADD.A16	#lgHWDisRec,A1
	DJ.16,NMO D0,Copy$

	CLR.16	D7

Err$:	TEST.16	D7
	RET



;---------\\
;  D0AUX1  >
;=========/

; Interface pour accder aux dfinitions du pilote $HWDIS et
; aux displays grs par celui-ci.
;
; Documentation complte dans fichier HWDIS.ASS.

; in	A3.32	^ligne de commande
;	A4.32	^tampon pour la rponse (lg D4.32)
;	D4.32	longueur du buffer  disposition (lecture)
;	A5.32	^donnes  crire si D5<>0
;	D5.32	longueur donnes  crire
; out	{A4}++	tampon actualis
;	D4.32	longueur lue si D7=0, longueur ncessaire si D7=erreur
;	D5.32	longueur donnes crites
;	D7.16	erreur
; mod	D4.32, D5.32, D7.16, D0,D1,A0,A1

D0AUX1:
	PUSHM.32 D3|A3
.if	0
	pushm.32 d0..d7
	mon	?aftim
	.ascize	"HWDIS: Auxil1 "
	MOVE.32	{A3},D4
	mon	?afx8
	popm.32	d0..d7
.endif
	CLR.16	D7
	MOVE.32	{A3+},D3		; D3 <-- opration requise

	MOVE.32	#R16^Table$,A0
	MOVE.32	A0,A1

Loop$:	MOVE.32	{A0+},D0		; D0 <-- commande
	MOVE.16	{A0+},D1		; D1 <-- offset
	JUMP,EQ	R8^Err$

	COMP.32	D0,D3			; commande trouve ?
	JUMP,NE	Loop$			; non => suivante

	MOVE.32	#{A1}+A16^{D1},A1
	CALL	{A1}			; excute la requte
	JUMP	R8^Exit$		; termine sans autre

Err$:
	MOVE.16	#ERILLO,D7
	MOVE.32	#0,D4
	MOVE.32	#0,D5

Exit$:	POPM.32	D3|A3
	TEST.16	D7
	RET


Table$:
	.32.16	cHWInitDisplay,		InitDisplay-Table$
	.32.16	cHWPower,		Power-Table$
	.32.16	cHWMonSetup,		MonSetup-Table$
	.32.16	cHWPixmapOpen,		PixmapOpen-Table$
	.32.16	cHWPixmapClose,		PixmapClose-Table$
	.32.16	cHWPixmapShow,		PixmapShow-Table$
	.32.16	cHWPixmapColor,		PixmapColor-Table$
	.32.16	cHWCursorDef,		CursorDef-Table$
	.32.16	cHWCursorColor,		CursorColor-Table$
	.32.16	cHWCursorMove,		CursorMove-Table$
	.32.16	cHWCursorFuncs,		CursorFuncs-Table$
	.32.16	cHWSubscribe,		Subscribe-Table$
	.32.16  cHWQuery,		Query-Table$
	.32.16	cHWDrawFuncs,		DrawFuncs-Table$
	.32.16	cHWPatch,		Patch-Table$
	.32.16	0,			0

; Paramtres des routines ci-dessous :

; in	{A3}++	paramtres
;	A4.32	^tampon pour la rponse (lg D4.32)
;	D4.32	longueur du buffer  disposition (lecture)
;	A5.32	^donnes  crire si D5<>0
;	D5.32	longueur donnes  crire
; out	{A4}++	tampon actualis
;	D4.32	longueur lue si D7=0, longueur ncessaire si D7=erreur
;	D5.32	longueur donnes crites
;	D7.16	erreur
; mod	D4.32, D5.32, D7.16, D0,D1,A0,A1


; Initialise un display manager et enregistre celui-ci dans la table
; interne au pilote. Retourne l'id du manager.

InitDisplay:
	PUSHM.32 D2|D3|D5|D6|A2|A3|A5

	MOVE.16	#ERIRLG,D7		; "longueur illgale"

	MOVE.32	#4,D5			; minimum 4 bytes !
	COMP.32	D5,D4			; au moins 4 bytes ?
	JUMP,LT	Err$			; non => erreur

	MOVE.32	D4,D5			; D5 <-- taille du buffer
	MOVE.32	A4,A5			; A5 <-- ^buffer

	MOVE.32	A3,D6			; conserve ^nom
	MOVE.32	#2**BEXNHEAD,D3
	FOS	?CLOAD			; essaie de charger...
	JUMP,NE	Err$			; pas possible => erreur

	MOVE.32	#{A6}+oVARDMTable,A0	; A0 <-- ^lment DM
	MOVE.32	#0,D0			; D0 <-- aucun lment DM libre
	MOVE.32	#cMaxDM-1,D1		; D1 <-- nb.  tester
	MOVE.16	#ERNDEV,D7		; "dj install"

Seek$:	TEST.8	{A0}+oDMIsOk		; dj initialis ?
	JUMP,F	R8^Free$		; non => libre

	COMP.32	{A0}+oDMHeader,A4	; mme en-tte ?
	JUMP,EQ	R8^Er1$			; oui => erreur
	JUMP	R8^Next$

Free$:	TEST.32	D0			; encore point trouv ?
	JUMP,NE	R8^Next$		; si => ok

	MOVE.32	A0,D0			; prend note

Next$:	ADD.A16	#lgDMRec,A0		; suivant
	DJ.16,NMO D1,Seek$

	MOVE.16	#EROPMX,D7		; "trop de pilotes ouverts"
	TEST.32	D0			; un de libre ?
	JUMP,EQ	R8^Er1$			; non => erreur

	MOVE.32	D0,A0
	MOVE.32	A4,A3
	ADD.A16	{A3}+oHDMInit,A3	; A3 <-- ^routine d'initialisation

	MOVE.32	#MTYPBD,D1		; D1 <-- type du compte
	MOVE.32	{A6}+oVARBasePtr,A1	; A1 <-- pointeur au compte
	CALL	{A3}			; initialise
	JUMP,NE	R8^Er1$			; erreur => termine...

; Ok, chargement & initialisation se sont bien drouls.

	SET.8	{A0}+oDMIsOk
	MOVE.32	A2,{A0}+oDMChannel
	MOVE.32	A4,{A0}+oDMHeader
	MOVE.32	A0,{A0}+oDMSelfCheck
	MOVE.32	A3,{A0}+oDMMonInfo
	MOVE.32	A1,{A0}+oDMDynInfo

	MOVE.32	#0,D2			; D2 <- mode
	DISPLAY	A0,oHDMCursorFuncs	; demande les fonctions d'accs
	JUMP,NE	R8^Er1$
	MOVE.32	A4,{A0}+oDMCursFuncs

	MOVE.32	A0,{A5}			; descripteur du display
	MOVE.32	#4,D5			; taille du descripteur
	CLR.16	D7			; pas d'erreur
	JUMP	R8^Err$

Er1$:	MOVE.16	D7,D0
	MOVE.32	D6,A3			; reprend le vrai nom du fichier
	FOS	?CUNLOAD		; libre le fichier charg par mgarde
	MOVE.16	D0,D7

Err$:	MOVE.32	D5,D4
	MOVE.32	A5,A4

	POPM.32	D2|D3|D5|D6|A2|A3|A5
	RET


; Gestion de la consommation

Power:
	PUSHM.32 D2|D3

OK$:	MOVE.32	{A3+},A0		; A0 <-- id display manager
	MOVE.32	{A3+},D3		; D3 <-- mode "power"
	MOVE.32	#0,D2			; D2 <-- mode

	CHECK_DM_ID A0
	DISPLAY	A0,oHDMPower		; initialise mode vido cran

	POPM.32	D2|D3
	RET


; Initialise le moniteur d'aprs un mode vido.

MonSetup:
	PUSHM.32 D2|D3|D5|A2|A3|A4|A5

	COMP.32	#0,D5
	JUMP,NE	R8^OK$

	MOVE.32	D5,A5

OK$:	MOVE.32	{A3+},A0		; A0 <-- id display manager
	MOVE.32	#0,D2			; D2 <-- mode
	MOVE.32	A5,A4			; A4 <-- ^tables

	CHECK_DM_ID A0
	DISPLAY	A0,oHDMMonSetup		; initialise mode vido cran

	MOVE.32	A4,{A0}+oDMMonInfo	; prend note du ^infos moniteur

Err$:	POPM.32	D2|D3|D5|A2|A3|A4|A5
	RET


; Ouvre un pixmap sur le display manager spcifi. Retourne l'id
; du pixmap, son adresse et sa largeur en bytes.

PixmapOpen:
	PUSHM.32 D2|D3|D5|A2|A3|A5

	MOVE.16	#ERIRLG,D7		; "longueur illgale"

	MOVE.32	#16,D5			; minimum 16 bytes !
	COMP.32	D5,D4			; au moins 16 bytes ?
	JUMP,LT	R8^Err$			; non => erreur

	MOVE.32	D4,D5			; D5 <-- taille du buffer
	MOVE.32	A4,A5			; A5 <-- ^buffer

	MOVE.32	{A3+},A0		; A0 <-- id display manager

	MOVE.32	#0,D2
	MOVE.32	#0,D3

	MOVE.16	{A3+},D2		; D2 <-- mode
	MOVE.16	{A3+},D3		; D3 <-- profondeur
	MOVE.32	{A3+},D4		; D4 <-- [dy;dx]
	CHECK_DM_ID A0
	DISPLAY	A0,oHDMOpen		; ouvre un pixmap
	JUMP,NE	R8^Err$

	MOVE.32	D5,{A5}+0		; id. du pixmap
	MOVE.32	A4,{A5}+4		; adresse de base du pixmap
	MOVE.32	D4,{A5}+8		; largeur en bytes du pixmap
	MOVE.32	A3,{A5}+12		; descripteur du pixmap

	MOVE.32	#16,D5

Err$:	MOVE.32	D5,D4
	MOVE.32	A5,A4

	POPM.32	D2|D3|D5|A2|A3|A5
	RET


; Ferme un pixmap donn par son identificateur.

PixmapClose:
	PUSHM.32 D2|D3|D5|A2|A3|A5

	MOVE.32	#0,D2			; D2 <-- mode
	MOVE.32	{A3+},A0		; A0 <-- id display manager
	MOVE.32	{A3+},D5		; D5 <-- id pixmap
	CHECK_DM_ID A0
	DISPLAY	A0,oHDMClose		; ferme le pixmap

	MOVE.32	#0,D4

	POPM.32	D2|D3|D5|A2|A3|A5
	RET


; Montre un pixmap.

PixmapShow:
	PUSHM.32 D2|D3|D5|A2|A3|A5

	MOVE.32	#0,D2			; D2 <-- mode
	MOVE.32	{A3+},A0		; A0 <-- id display manager
	MOVE.32	{A3+},D5		; D5 <-- id pixmap
	CHECK_DM_ID A0

	MOVE.32	#cMaxDM-1,D0
	MOVE.32	#{A6}+oVARDMTable,A1

Loop$:	TEST.8	{A1}+oDMIsOK
	JUMP,F	R8^Next$

	MOVE.32	{A1}+oDMChannel,A2
	MOVE.32	#CursHide,D2
	MOVE.32	{A1}+oDMCursFuncs,A5
	MOVE.32	{A5}+oDMCMode,D1
	JUMP,F	R8^Next$
	MOVE.32	D1,A5
	CALL	{A5}

Next$:	ADD.A16	#lgDMRec,A1
	DJ.16,NMO D0,Loop$

	DISPLAY	A0,oHDMShow		; montre le pixmap

	MOVE.32	{A0}+oDMChannel,A2
	MOVE.32	#CursShow,D2
	MOVE.32	{A0}+oDMCursFuncs,A5
	MOVE.32	{A5}+oDMCMode,D1
	JUMP,F	R8^End$

	MOVE.32	D1,A5
	CALL	{A5}

End$:	MOVE.32	#0,D4

	POPM.32	D2|D3|D5|A2|A3|A5
	RET


; Change les couleurs du pixmap.

PixmapColor:
	PUSHM.32 D2|D3|D4|D5|A2|A3|A4|A5

	MOVE.32	D5,D4
	SR.32	#.LOG2.4,D4		; D4 <-- nombre de couleurs
	MOVE.32	A5,A4			; A4 <-- ^table [i;r;g;b]
	MOVE.32	#0,D2			; D2 <-- mode
	MOVE.32	{A3+},A0		; A0 <-- id display manager
	MOVE.32	{A3+},D5		; D5 <-- id pixmap
	CHECK_DM_ID A0
	DISPLAY	A0,oHDMColor		; colorie le pixmap

	MOVE.32	#0,D4

	POPM.32	D2|D3|D4|D5|A2|A3|A4|A5
	RET


; Dfinit l'aspect du curseur.

CursorDef:
	PUSHM.32 D2|D3|D5|A2|A3|A5

	MOVE.32	#0,D2			; D2 <-- mode
	MOVE.32	{A3+},A0		; A0 <-- id display manager
	MOVE.32	{A3+},D4		; D4 <-- [dy;dx]

	MOVE.16	D4,D3
	ADD.16	#7,D3
	SR.16	#.LOG2.8,D3		; D3 <-- largeur en bytes
	MUL.16	{A3}-4,D3		; D3 <-- taille en bytes

	MOVE.32	A5,A3			; A3 <-- ^chair
	MOVE.32	#{A3}+32^{D3},A4	; A4 <-- ^fond

	CHECK_DM_ID A0
	DISPLAY	A0,oHDMCursorDef	; dfinit le curseur

	MOVE.32	#0,D4

	POPM.32	D2|D3|D5|A2|A3|A5
	RET


; Colorie le curseur.

CursorColor:
	PUSHM.32 D2|D3|D5|A2|A3|A5

	MOVE.32	#0,D2			; D2 <-- mode
	MOVE.32	{A3+},A0		; A0 <-- id display manager
	MOVE.32	{A3+},D3		; D3 <-- [-;r;g;b] chair
	MOVE.32	{A3+},D4		; D4 <-- [-;r;g;b] fond
	CHECK_DM_ID A0
	DISPLAY	A0,oHDMCursorCol	; colorie le curseur

	MOVE.32	#0,D4

	POPM.32	D2|D3|D5|A2|A3|A5
	RET


; Dplace le curseur.

CursorMove:
	PUSHM.32 D2|D3|D5|A2|A3|A5

	MOVE.32	#0,D2			; D2 <-- mode
	MOVE.32	{A3+},A0		; A0 <-- id display manager
	MOVE.32	{A3+},D4		; D4 <-- [y;x]
	CHECK_DM_ID A0
	DISPLAY	A0,oHDMCursorPos	; dplace le curseur

	MOVE.32	#0,D4

	POPM.32	D2|D3|D5|A2|A3|A5
	RET


; Retourne les fonctions d'accs rapide au curseur

CursorFuncs:
	PUSHM.32 D2|D3|D5|A2|A3|A5

	MOVE.16	#ERIRLG,D7		; "longueur illgale"

	MOVE.32	#4,D5			; minimum 4 bytes !
	COMP.32	D5,D4			; au moins 4 bytes ?
	JUMP,LT	R8^Err$			; non => erreur

	MOVE.32	D4,D5			; D5 <-- taille du buffer
	MOVE.32	A4,A5			; A5 <-- ^buffer

	MOVE.32	#0,D2			; D2 <-- mode
	MOVE.32	{A3+},A0		; A0 <-- id display manager
	CHECK_DM_ID A0
	DISPLAY	A0,oHDMCursorFuncs	; demande les fonctions d'accs

	MOVE.32	A4,{A5}+0		; ^table de fonctions
	MOVE.32	A5,A4

	MOVE.32	#4,D5

Err$:	MOVE.32	D5,D4

	POPM.32	D2|D3|D5|A2|A3|A5
	RET


; Souscription aux messages du DM

Subscribe:
	PUSHM.32 D2|D3|A3|A4|A5

OK$:	MOVE.32	{A3+},A0		; A0 <-- id display manager
	MOVE.32	{A3+},D3		; D3 <-- type de message
	MOVE.32	{A3+},A5		; A5 <-- ID de BAR

	MOVE.32	#0,D2			; D2 <-- mode

	CHECK_DM_ID A0
	DISPLAY	A0,oHDMSubscribe	; initialise mode vido cran

	POPM.32	D2|D3|A3|A4|A5
	RET


; Interroge le DM 

Query:
	PUSHM.32 D2..D5|A2|A3|A5

	MOVE.32	{A3+},A0		; A0 <-- id display manager
	MOVE.32	{A3+},D3		; D3 <-- item
	MOVE.32	{A3+},D4		; D4 <-- longueur
	MOVE.32	{A3+},A4		; A4 <-- ^buffer pour rsultat
	MOVE.32	#0,D2			; D2 <-- mode

	CHECK_DM_ID A0
	DISPLAY	A0,oHDMQuery		; interroge le DM

	POPM.32	D2..D5|A2|A3|A5
	RET


; Retourne un pointeur vers la structure dcrivant les fonctions de dessin

DrawFuncs:
	PUSHM.32 D2|D3|D4|D5|A2|A3|A4|A5

	MOVE.16	#ERIRLG,D7		; "longueur illgale"

	MOVE.32	A4,A5			; A5 <- ^ buffer
	MOVE.32	#4,D3			; minimum 4 bytes !
	COMP.32	D3,D4			; au moins 4 bytes ?
	JUMP,LT	R8^Err$			; non => erreur

	MOVE.32	#0,D2			; D2 <-- mode
	MOVE.32	{A3+},A0		; A0 <-- id display manager
	MOVE.32	{A3+},D5		; D5 <-- id pixmap
	SUB.32	A4,A4
	CHECK_DM_ID A0
	DISPLAY	A0,oHDMDrawFuncs	; demande ^fonctions de dessin
	MOVE.32	A4,{A5}

Err$:
	POPM.32	D2|D3|D4|D5|A2|A3|A4|A5
	RET


; Patche une routine du display manager

Patch:
	PUSHM.32 D2|D3|D5|D6|A2|A3|A5

	MON	?AFTIM
	.ASCIZE	"HWDIS: Patch<cr>"		

	MOVE.32	{A3+},A0		; A0 <-- id display manager
	MOVE.32	{A3+},D3		; D3 <-- commande
	MOVE.32	{A3+},D4		; D4 <-- ^nouvelle routine

	CHECK_DM_ID A0
	DISPLAY	A0,oHDMPatch		; patche le DM

	POPM.32	D2|D3|D5|D6|A2|A3|A5
	RET

	.END


