
		.TITLE	MONSEL.ASL

;	-------------------------------------------
;	  (C) Copyright 1994-1999.  Pierre ARNAUD
;	-------------------------------------------

; Ce module permet de slectionner le mode d'installation des
; fentres $DIS.

		.PROC	M68020

		.REF	SMAKY
		.REF	MONSEL
		.REF	DOLIB
		.REF	HWDIS
		.REF	DISPLAYMAN
		.REF	SYSTEM

REVMAJ		= 1
REVMIN		= 1

		.START	-1
		.REV	REVMAJ,REVMIN
		.IDENT	"(C) 1994-1999  Pierre ARNAUD et EPSITEC SA"


; Date      Rev  Aut.	Commentaire
; -------------------------------------------------------------------------
; 21/09/99  1.1  PA	Ajout les modes supplmentaires.
; 13/03/98  1.0  PA	Verrouillage des informations lors des accs.
; 14/01/98  0.5  PA	Supporte de nouvelles profondeurs.
; 04/03/97  0.4  PA	Version mise  jour.
; 25/01/97  0.3  PA	Nouvel appel MONSEL_SPY.
;			Modifi MONSEL_INFO pour pouvoir consulter un mode.
; 19/10/94  0.2  PA	Modifi la signification des bits MAXX/MAXY.
; 07/10/94  0.1	 PA	Premier jet de MONSEL.
; -------------------------------------------------------------------------



;	Description d'un canal MONSEL
;	-----------------------------

		.LOC	0

oChVar:		.BLK.32	1		; ^variables globales
oChNext:	.BLK.32	1		; ^canal suivant
oChPrev:	.BLK.32	1		; ^canal prcdent

;---ne pas sparer---
oChBMType:	.BLK.32	1		; BalMess: type de message
oChBMRes:	.BLK.32	1		; BalMess: rserve
oChBMData:				; BalMess: donnes (mode)
oChTmpMode:	.BLK.8	lgMonSelRec	; mode temporaire
;---ne pas sparer---

oChPID:		.BLK.16	1		; numro du processus
lgChRec:


;	Variables globales de MONSEL
;	----------------------------

		.LOC	0

oGSemGlob:	.BLK.32	1		; smaphore global
oGMemType:	.BLK.32	1		; type du compte mmoire
oGMemDesc:	.BLK.32	1		; descripteur du compte mmoire
oGCountCh:	.BLK.32	1		; compteur de canaux
oGPFirstCh:	.BLK.32	1		; pointeur au premier canal
oGFirstCh:	.BLK.8	lgChRec		; canal "0" jamais supprim
oGDefMode:	.BLK.8	lgMonSelRec	; mode par dfaut
oGStatus:	.BLK.8	lgHWStatDisRec	; statut retourn par $HWDIS
oGSpyNum:	.BLK.32	1		; nombre d'espions enregistrs
oGArbAccess:	.BLK.32	1		; arbitre pour les accs
lgGRec:


		.LOC	0


BASE:		.16	MONSEL_FIRST	; code du premier appel
		.16	MONSEL_LAST	; code du dernier appel
		.FILL.8	(OHLREV-APC),0

		.8	REVMAJ,REVMIN	; rvision & version
		.16	0,END_MONSEL	; longueur
		.32	PATHLIB		; pattern de dbut
		.FILL.8	(OHLNAM-APC),0
		.ASCII	"MONSEL"	; nom du module
		.FILL.8	(LGHLIB-APC),0

		.16	_MONSEL_OPEN	; initialise le module
		.16	_MONSEL_CLOSE	; libre le module
		.16	_MONSEL_SETMODE	; dfinit le mode
		.16	_MONSEL_INFO	; appel rserv  $DIS
		.16	_MONSEL_SPY	; dfinit un espion
		.16	_MONSEL_LOCK	; verrouille l'accs
		.16	_MONSEL_UNLOCK	; dverrouille l'accs


;--------------\\
;  MONSEL_OPEN  >
;==============/

; Ouvre le module et retourne le canal qui doit tre transmis
; lors des autres appels.

; in	D2.32	mode (0)
; out	A2.32	canal
;	D7.16	ok/erreur
; mod	A2.32, D7.16

_MONSEL_OPEN:
	PUSHM.32 D1|D3|D4|D6|A1|A3|A4|A5|A6

	MOVE.32	#R16^BASE,A4
	MOVE.32	#lgGRec+2**31,D4
	FOS	?GETcomMEM		; accde aux variables globales
	JUMP,NE	ERR$

;	MOVE.32	A5,A5			; A5 <-- ^smaphore d'exclusion
	MOVE.32	A4,A6			; A6 <-- ^variables globales

	NTREL	?LOCK			; verrouille l'accs
	JUMP,NE	ERR$			; erreur => laisse tomber

	TEST.32	{A6}+oGSemGlob		; dj initialis ?
	JUMP,T	OK$			; oui => suite

	MOVE.32	A5,{A6}+oGSemGlob	; prend note

	MOVE.32	#MTYPSYS,D1		; D1 <-- type systme
	SUB.32	A1,A1			; A1 <-- 0
	MOVE.32	#R16^NmAccount,A3	; A3 <-- nom du compte mmoire
	GESMEM	?CREMCPT		; compte cr --> A2
	JUMP,NE	END$			; erreur => laisse tomber

	MOVE.32	#MTYPUSER,D1
	MOVE.32	D1,{A6}+oGMemType	; prend note type mmoire
	MOVE.32	A2,{A6}+oGMemDesc	; prend note descripteur mmoire

	MOVE.32	#{A6}+oGFirstCh,A1	; A1 <-- ^premier canal
	MOVE.32	A1,{A6}+oGPFirstCh	; prend note du ^premier canal

	MOVE.32	A6,{A1}+oChVar		; <-- ^variables
	MOVE.32	A1,{A1}+oChNext		; <-- ^soi-mme (dernier)
	MOVE.32	A1,{A1}+oChPrev		; <-- ^soi-mme (premier)
	MOVE.8	#.BIT.bMonSelInvalid,{A1}+oChTmpMode+oMonSelMode

	MOVE.32	#{A6}+oGDefMode,A1	; A1 <-- ^mode par dfaut

;	MOVE.16	#0,{A1}+oMonSelNum	; <-- cran de base = 0
	MOVE.8	#.BIT.bMonSelStop,{A1}+oMonSelMode
	MOVE.16	#640,{A1}+oMonSelDX	; <-- largeur par dfaut (VGA)
	MOVE.16	#480,{A1}+oMonSelDY	; <-- hauteur par dfaut (VGA)
	MOVE.16	#1,{A1}+oMonSelDepth	; <-- monochrome par dfaut

	MOVE.32	#R16^NmHWDis,A3		; A3 <-- ^nom de #HWDIS
	MOVE.32	#2**BOPRD,D3		; D3 <-- ReadStatus uniquement
	FOS	?OPEN			; tente d'ouvrir le canal
	JUMP,NE	R8^NoHWDis$		; erreur => saute RSTATUS

	MOVE.32	#{A6}+oGStatus,A4
	MOVE.32	#lgHWStatDisRec,D4
	FOS	?RSTATUS		; cherche les infos sur HWDIS
	FOS	?CLOSE

NoHWDis$:
	MOVE.32	{A6}+oGPFirstCh,A2	; ^canal "0" (de base)
	INC.32	{A6}+oGCountCh		; un canal de plus...

	PUSH.32	A5
	NTREL	?CREARB
	MOVE.32	A5,{A6}+oGArbAccess	; prend note de l'arbitre
	POP.32	A5

	CLR.16	D7
	JUMP	R8^END$			; ok => termin

; Initialisation ok... Il faut initialiser un nouveau canal !

OK$:	MOVE.32	{A6}+oGMemType,D1	; D1 <-- type mmoire
	MOVE.32	{A6}+oGMemDesc,A1	; A1 <-- descripteur mmoire
	MOVE.32	#lgChRec,D4		; D4 <-- taille
	GESMEM	?GETMEM			; alloue la mmoire
	JUMP,NE	R8^END$			; pas possible => erreur

	GESMEM	?CLEARMEM		; efface les variables
	NTREL	?GTPNUM			; cherche le numro du processus

	MOVE.16	D4,{A4}+oChPID		; <-- numro du processus
	MOVE.32	A6,{A4}+oChVar		; <-- ^variables globales
	MOVE.8	#.BIT.bMonSelInvalid,{A4}+oChTmpMode+oMonSelMode

	MOVE.32	{A6}+oGPFirstCh,A1	; A1 <-- ^premier
	MOVE.32	{A1}+oChPrev,A2		; A2 <-- ^dernier

	MOVE.32	A2,{A4}+oChPrev		; dernier devient avant-dernier
	MOVE.32	A1,{A4}+oChNext		; premier aprs dernier
	MOVE.32	A4,{A1}+oChPrev		; dernier avant premier
	MOVE.32	A4,{A2}+oChNext		; dernier aprs avant-dernier

	INC.32	{A6}+oGCountCh		; un canal de plus
	MOVE.32	A4,A2			; A2 <-- canal allou

END$:	MOVE.16	D7,D1
	NTREL	?UNLOCK
	MOVE.16	D1,D7			; reprend l'erreur

ERR$:	POPM.32	D1|D3|D4|D6|A1|A3|A4|A5|A6
	TEST.16	D7
	RET


;---------------\\
;  MONSEL_CLOSE  >
;===============/

; Ferme un canal ouvert au moyen de l'appel OPEN. Si le module
; n'est plus utilis, il est ferm  son tour.

; in	D2.32	mode (0)
;	A2.32	canal
; out	D7.16	ok/erreur
; mod	D7.16

_MONSEL_CLOSE:
	PUSHM.32 D1|A0|A1|A4|A5|A6

	CLR.16	D7

	MOVE.32	{A2}+oChVar,A6		; A6 <-- ^variables
	MOVE.32	{A6}+oGSemGlob,A5	; A5 <-- smaphore global

	COMP.32	{A6}+oGPFirstCh,A2	; essaie de librer le premier ?
	JUMP,EQ	R8^ERR$			; oui => ne fait rien !

	NTREL	?LOCK			; verrouille l'accs
	JUMP,NE	ERR$			; erreur => abandonne

	MOVE.32	{A2}+oChNext,A0		; A0 <-- ^suivant
	MOVE.32	{A2}+oChPrev,A1		; A1 <-- ^prcdent

	MOVE.32	A0,{A1}+oChNext
	MOVE.32	A1,{A0}+oChPrev

	MOVE.32	A2,A4
	MOVE.32	{A6}+oGMemType,D1
	MOVE.32	{A6}+oGMemDesc,A1
	GESMEM	?GIVMEM			; libre la mmoire

	DEC.32	{A6}+oGCountCh		; un canal de moins...

	NTREL	?UNLOCK			; fin de l'accs exclusif

ERR$:	POPM.32	D1|A0|A1|A4|A5|A6
	TEST.16	D7
	RET



;-----------------\\
;  MONSEL_SETMODE  >
;=================/

; Dfinit le mode  utiliser lors de la prochaine installation
; d'une fentre par le logiciel appelant. Ce mode est local.
; On peut l'annuler en passant un pointeur 0 en entre.

; in	D2.32	mode
;		 #mMSModeLocal, mode local.
;		 #mMSModeCheck, vrifie simplement le mode.
;	A2.32	canal
;	A4.32	^mode oMonSel.. souhait (ou 0)
; out	D7.16	ok/erreur
; mod	D7.16

_MONSEL_SETMODE:
	PUSHM.32 D4|A2|A4|A5|A6

	CALL	CheckChannel		; A2 <-- canal valide
	MOVE.32	{A2}+oChVar,A6		; A6 <-- ^variables
	MOVE.32	{A6}+oGArbAccess,A5	; A5 <-- arbitre d'accs
	NTREL	?WFOREA			; accs exclusif

	MOVE.32	A4,D4			; mode existe-t-il ?
	JUMP,EQ	R8^ModeOk$		; non => suite

	CALL	CheckMode		; vrifie le mode
	JUMP,NE	ERR$			; pas valide => erreur

ModeOk$:
	COMP.16	#mMSModeCheck,D2	; mode "vrification seulement"
	JUMP,EQ	ERR$			; oui => termin

	MOVE.16	#1,D7			; erreur par dfaut

	MOVE.32	{A2}+oChVar,A6		; A6 <-- ^variables
	MOVE.32	{A6}+oGSemGlob,A5	; A5 <-- smaphore global

	COMP.16	#mMSModeLocal,D2	; mode reconnu ?
	JUMP,NE	R8^ERR$			; non => erreur

	MOVE.32	A4,D4			; mode existe ?
	JUMP,F	R8^NoMode$		; non => supprime mode actuel

; Copie le mode vido dans le record appropri. Ce mode vido, temporaire,
; est pris en considration avant les autres modes...

	MOVE.32	{A4}+oMonSelNum,{A2}+oChTmpMode+oMonSelNum
	MOVE.32	{A4}+oMonSelDX,{A2}+oChTmpMode+oMonSelDX
	MOVE.32	{A4}+oMonSelDepth,{A2}+oChTmpMode+oMonSelDepth
	MOVE.32	{A4}+oMonSelDepth+4,{A2}+oChTmpMode+oMonSelDepth+4

	TEST.32	{A6}+oGSpyNum		; y a-t-il des espions ?
	JUMP,F	R8^NoSpy$		; non => suite

	MOVE.32	#{A2}+oChBMType,A4
	MOVE.32	#BMTypeMonSelChange,{A4}
	FOS	?GIVMESS

NoSpy$:	CLR.16	D7
	JUMP	R8^ERR$

NoMode$:
	MOVE.8	#.BIT.bMonSelInvalid,{A2}+oChTmpMode+oMonSelMode
	CLR.16	D7

ERR$:	PUSH.16	D7
	MOVE.32	{A6}+oGArbAccess,A5
	NTREL	?SIEOEA			; fin de l'accs exclusif
	POP.16	D7

	POPM.32	D4|A2|A4|A5|A6
;	TEST.16	D7
	RET



;--------------\\
;  MONSEL_INFO  >
;==============/

; Retourne le mode slectionn par l'utilisateur, lequel doit tre
; utilis pour installer correctement la fentre. Cet appel est en
; principe rserv  $DIS. Prire de ne pas l'utiliser autrement !

; in	D2.32	mode (0)
;	A2.32	canal (celui de $DIS_0)
;	D3.32	compteur de tentative (0..n)
;	A3.32	^extrait de l'en-tte .CODE (MINX/MAXX/MINY/MAXY) ou 0
;	A4.32	^buffer pour oMonSel..
; out	D7.16	ok/erreur
;	{A4}++	buffer rempli
; mod	D7.16

_MONSEL_INFO:
	PUSHM.32 D0|D3|D4|A0..A6

	CALL	CheckChannel		; A2 <-- canal correct
	MOVE.32	{A2}+oChVar,A6		; A6 <-- ^variables
	MOVE.32	{A6}+oGArbAccess,A5	; A5 <-- arbitre d'accs
	NTREL	?WFORNEA		; accs non-exclusif

	MOVE.32	{A6}+oGSemGlob,A5	; A5 <-- smaphore global

	NTREL	?LOCK			; verrouille l'accs
	JUMP,NE	ERR$			; erreur => abandonne

	NTREL	?GTPNUM			; D4 <-- PID de l'appelant
	MOVE.32	A2,A1			; A1 <-- canal pour la recherche

FindPID$:
	COMP.16	{A1}+oChPID,D4		; canal correspondant trouv ?
	JUMP,EQ	R8^Found$		; oui => ok
	MOVE.32	{A1}+oChNext,A1		; A1 <-- canal suivant
	COMP.32	A1,A2			; fait le tour ?
	JUMP,NE	FindPID$		; non => cherche encore

Use0$:	MOVE.32	{A6}+oGPFirstCh,A1	; A1 <-- canal "0"  utiliser

Found$:	MOVE.32	#{A1}+oChTmpMode,A0	; A0 <-- mode temporaire
	TEST.8	{A0}+oMonSelMode:#bMonSelInvalid
	JUMP,BS	R8^Default$		; invalide => mode par dfaut !

	TEST.32	D3			; tentative 0 ?
	JUMP,EQ	R8^OkMode$		; oui => prend le mode actuel
	MOVE.16	#1,D7			; non => peut-tre rien d'autre
	TEST.8	{A0}+oMonSelMode:#bMonSelStop
	JUMP,BS	R8^Exit$		; plus d'autre solution !

	DEC.32	D3			; dcrmente numro de tentative

; On peut atterrir ici avec 3 "canaux" dans A1 :
;
; - un canal valide trouv dans la boucle de recherche du PID.
; - le canal "0".
; - pas de canal -- dans ce cas, on a dj pass par l et il
;   faut s'interrompre.

Default$:
	COMP.32	A6,A1			; canal impossible ?
	JUMP,EQ	R8^Bad$			; oui => fini !

	COMP.32	{A6}+oGPFirstCh,A1	; canal 0 ?
	JUMP,NE	Use0$			; non => essaie avec celui-l

	MOVE.32	A6,A1			; plus de canal / canal impossible
	MOVE.32	#{A6}+oGDefMode,A0	; mode par dfaut...

	TEST.32	D3			; tentative 0 ?
	JUMP,EQ	R8^OkMode$		; oui => prend le mode actuel

Bad$:	MOVE.16	#1,D7			; non => erreur, plus de modes
	JUMP	R8^Exit$		; termine avec une erreur

; Un mode a t trouv : soit le mode local, soit le mode global, soit
; le mode par dfaut... Il est point par A0.

OkMode$:
	MOVE.16	{A0}+oMonSelNum,{A4}+oMonSelNum
	MOVE.8	{A0}+oMonSelMode,D0
	AND.8	#.BIT.bMonSelNoBar.OR..BIT.bMonSelNoSKey,D0
	MOVE.8	D0,{A4}+oMonSelMode
	CLR.8	{A4}+oMonSelMode+1
	MOVE.32	{A0}+oMonSelDX,{A4}+oMonSelDX
	MOVE.32	{A0}+oMonSelDepth,{A4}+oMonSelDepth
	CLR.32	{A4}+oMonSelDepth+4

	CALL	UpdateMonSel		; corrige en fonction de A3...
	JUMP,NE	Default$		; erreur => tente autrement

Exit$:	MOVE.16	D7,D0
	NTREL	?UNLOCK
	MOVE.16	D0,D7

ERR$:	MOVE.16	D7,D0
	MOVE.32	{A6}+oGArbAccess,A5	; A5 <-- arbitre d'accs
	NTREL	?SIEONEA		; fin de l'accs non exclusif
	MOVE.16	D0,D7

	POPM.32	D0|D3|D4|A0..A6
;	TEST.16	D7
	RET


;-------------\\
;  MONSEL_SPY  >
;=============/

; Enregistre ou retire un espion qui dsire recevoir des informations
; quand les choix rgls par MONSEL changent.

; in	D2.32	mode (1 => enregistre, -1 => retire)
; out	D7.16	ok/erreur
; mod	D7.16

_MONSEL_SPY:
	PUSHM.32 D0|D1|D4|A4|A5

	MOVE.32	#1,D0
	MOVE.32	#-1,D1
	COMP.32	D0,D2
	JUMP,EQ	R8^OKMODE$
	COMP.32	D1,D2
	JUMP,EQ	R8^OKMODE$

	MOVE.16	#1,D7
	JUMP	R8^EXIT$

OKMODE$:
	MOVE.32	#R16^BASE,A4
	MOVE.32	#lgGRec+2**31,D4
	FOS	?GETcomMEM		; accde aux variables globales
	JUMP,NE	EXIT$

	ADD.32	D2,{A4}+oGSpyNum

EXIT$:	POPM.32	D0|D1|D4|A4|A5
	TEST.16	D7
	RET



;--------------\\
;  MONSEL_LOCK  >
;==============/

; Verrouille pour ne permettre que des lectures...

; in	A2.32	canal
; out	D7.16	ok/erreur
; mod	D7.16

_MONSEL_LOCK:
	PUSHM.32 A2|A5|A6

	CALL	CheckChannel		; A2 <-- canal valide

	MOVE.32	{A2}+oChVar,A6		; A6 <-- ^variables
	MOVE.32	{A6}+oGArbAccess,A5
	NTREL	?WFORNEA		; accs exclusif

	POPM.32	A2|A5|A6
;	TEST.16	D7
	RET



;----------------\\
;  MONSEL_UNLOCK  >
;================/

; Dverrouille.

; in	A2.32	canal
; out	D7.16	ok/erreur
; mod	D7.16

_MONSEL_UNLOCK:
	PUSHM.32 A2|A5|A6

	CALL	CheckChannel		; A2 <-- canal valide

	MOVE.32	{A2}+oChVar,A6		; A6 <-- ^variables
	MOVE.32	{A6}+oGArbAccess,A5
	NTREL	?SIEONEA		; fin de l'accs exclusif

	POPM.32	A2|A5|A6
;	TEST.16	D7
	RET




;---------------\\
;  CheckChannel  >
;---------------/

; Vrifie que le canal A2 soit valide. S'il est nul, on utilise
; le canal par dfaut : le canal "0".

; in	A2.32	canal ou 0
; out	A2.32	canal
; mod	A2.32

CheckChannel:
	PUSHM.32 D4|D7|A4|A5

	MOVE.32	A2,D4			; canal ok ?
	JUMP,T	R8^OK$			; oui => suite

	MOVE.32	#R16^BASE,A4
	MOVE.32	#lgGRec+2**31,D4
	FOS	?GETcomMEM		; accde aux variables globales

	MOVE.32	{A4}+oGPFirstCh,A2	; A2 <-- canal "0"

OK$:	POPM.32	D4|D7|A4|A5
	RET


;------------\\
;  CheckMode  >
;------------/

; Vrifie que le mode pass en entre soit conforme.

; in	A2.32	canal
;	A4.32	^mode oMonSel.. souhait
; out	D7.16	ok/erreur
; mod	D7.16

CheckMode:
	PUSHM.32 D0..D6|A0..A6

	MOVE.32	{A2}+oChVar,A6
	MOVE.32	#{A6}+oGStatus,A0	; A0 <-- ^statuts de HWDIS

	MOVE.16	{A4}+oMonSelNum,D0	; D0 <-- numro du moniteur
	COMP.16	#cHWMaxDisplay,D0	; dans les limites ?
	JUMP,GE	R8^NotFound$		; non => erreur

	TEST.8	{A4}+oMonSelMode:#bMonSelInvalid
	JUMP,BS	R8^NotFound$		; invalide => erreur

	MUL.16	#lgHWDisRec,D0
	MOVE.32	#{A0}+A16^{D0},A0	; A0 <-- ^description du moniteur
	MOVE.32	{A0}+oHWDisDynInfo,A0	; A0 <-- ^description dynamique

	MOVE.16	{A4}+oMonSelDepth,D3	; D3 <-- [depth]
	MOVE.32	{A4}+oMonSelDX,D4	; D4 <-- [dy;dx]

	MOVE.32	#R16^DepthTable$,A3
	MOVE.32	#R16^SizeTable$,A4

Seek1$:	MOVE.16	{A3+},D0		; profondeur trouve
	JUMP,EQ	R8^NotFound$		; plus rien => pas trouv

	MOVE.16	{A3+},D1		; offset pour cette profondeur
	COMP.16	D0,D3			; profondeur correspond ?
	JUMP,NE	Seek1$			; non => cherche encore

; Trouv la bonne profondeur... Cherche maintenant la taille.

	MOVE.32	#{A0}+A16^{D1},A0	; A0 <-- ^bitset des tailles

Seek2$:	MOVE.32	{A4+},D0		; taille trouve
	JUMP,EQ	R8^NotFound$		; plus rien => pas trouv

	MOVE.32	{A4+},D1		; bit correspondant
	COMP.32	D0,D4			; taille correspond ?
	JUMP,NE	Seek2$			; non => cherche encore

	AND.32	{A0},D1			; bit trouv dans le bitset ?
	JUMP,BC	R8^NotFound$		; non => pas trouv

	CLR.16	D7
	JUMP	R8^ERR$

NotFound$:
	MOVE.16	#1,D7

ERR$:	POPM.32	D0..D6|A0..A6
	TEST.16	D7
	RET


DepthTable$:
	.16		 1, oDMISizDep1
	.16		 2, oDMISizDep2
	.16		 4, oDMISizDep4
	.16		 8, oDMISizDep8
	.16		15, oDMISizDep15
	.16		16, oDMISizDep16
	.16		24, oDMISizDep24
	.16		32, oDMISizDep32
	.16		 0, 0

SizeTable$:
	.16.16.32	 640, 400, .BIT.bHDM_640x400
	.16.16.32	 640, 480, .BIT.bHDM_640x480
	.16.16.32	 800, 600, .BIT.bHDM_800x600
	.16.16.32	 832, 624, .BIT.bHDM_832x624
	.16.16.32	 960, 720, .BIT.bHDM_960x720
	.16.16.32	1024, 768, .BIT.bHDM_1024x768
	.16.16.32	 768,1024, .BIT.bHDM_768x1024
	.16.16.32	1120, 832, .BIT.bHDM_1120x832
	.16.16.32	1152, 872, .BIT.bHDM_1152x872
	.16.16.32	1280,1024, .BIT.bHDM_1280x1024
	.16.16.32	1024,1280, .BIT.bHDM_1024x1280
	.16.16.32	1408,1056, .BIT.bHDM_1408x1056
	.16.16.32	1504,1128, .BIT.bHDM_1504x1128
	.16.16.32	1600,1200, .BIT.bHDM_1600x1200
	.16.16.32	1600,1280, .BIT.bHDM_1600x1280
	.16.16.32	 864,1024, .BIT.bHDM_864x1024
	.16.16.32	 832,1024, .BIT.bHDM_832x1024
	.16.16.32	 512, 384, .BIT.bHDM_512x384
	.16.16.32	 736, 960, .BIT.bHDM_736x960
	.16.16.32	 736, 736, .BIT.bHDM_736x736
	.16.16.32	 960, 960, .BIT.bHDM_960x960
	.16.16.32	   0,   0, 0





;---------------\\
;  UpdateMonSel  >
;---------------/

; Met  jour le contenu du record oMonSel.. en fonction des
; requtes spcifies dans l'en-tte du programme.

; in	A3.32	^en-tte MIN/MAX
;	A4.32	^record  corriger
; out	{A4}++	record mis  jour
;	D7.16	erreur en cas de conflit
; mod	D7.16

UpdateMonSel:
	PUSHM.32 D0|D1|D4

	CLR.16	D7

	MOVE.32	A3,D0			; y a-t-il un en-tte spcifi ?
	JUMP,F	R8^Exit$		; non => laisse bton

	MOVE.32	#0,D0
	MOVE.32	#0,D1

	MOVE.8	{A3}+2,D0		; D0 <-- high bits de MAXX
	MOVE.16	{A3}+6,D1		; D1 <-- tous les bits de MAXY

	SR.32	#4,D0			; D0 <-- 0..15 (info profondeur)

; Traite les touches de fonction et la barre du haut. Si le programme
; requiert leur absence, c'est cela qui est prioritaire !

	TEST.32	D1:#bMSyNoSKey		; pas de soft keys ?
	JUMP,BC	R8^SkOk$		; non => ok

	TSET.8	{A4}+oMonSelMode:#bMonSelNoSKey

SkOk$:	TEST.32	D1:#bMSyNoBar		; pas de barre du haut ?
	JUMP,BC	R8^BarOk$		; non => ok

	TSET.8	{A4}+oMonSelMode:#bMonSelNoBar

; Traite la profondeur dsire. Actuellement. On peut forcer les
; profondeurs 1/2/4/8/15/16/24 :

BarOk$:	TEST.8	D0			; profondeur impose ?
	JUMP,EQ	R8^DefaultDepth$	; non => 1 ou 4
	COMP.8	#mMSxDepthAny,D0	; n'importe quelle profondeur ?
	JUMP,EQ	R8^DepthOk$		; oui => ok de toute manire

	MOVE.8	R8^TABLE$+A16^{D0},D0	; D0 <-- profondeur dsire
	MOVE.16	D0,{A4}+oMonSelDepth
	JUMP	R8^DepthOk$

DefaultDepth$:
	COMP.16	#1,{A4}+oMonSelDepth	; 1 bit/pixel ?
	JUMP,EQ	R8^DepthOk$		; oui => ok pour vieux soft
	COMP.16	#4,{A4}+oMonSelDepth	; 4 bit/pixel ?
	JUMP,EQ	R8^DepthOk$		; oui => ok pour vieux soft

	MOVE.16	#4,{A4}+oMonSelDepth	; non => force 4 bit/pixel !

; Traite encore les dimensions...

DepthOk$:
	MOVE.16	{A4}+oMonSelDX,D4	; taille [dx] demande
	COMP.16	{A3}+0,D4		; trop petit ?
	JUMP,LT	R8^Bad$			; oui => erreur

	MOVE.16	{A3}+2,D3
	AND.16	#16'07FF,D3
	COMP.16	D3,D4			; trop grand ?
	JUMP,GT	R8^Bad$			; oui => erreur

	MOVE.16	{A4}+oMonSelDY,D4	; taille [dy] demande
	COMP.16	{A3}+4,D4		; trop petit ?
	JUMP,LT	R8^Bad$			; oui => erreur

	MOVE.16	{A3}+6,D3
	AND.16	#16'07FF,D3
	COMP.16	D3,D4			; trop grand ?
	JUMP,LE	R8^Exit$		; non => ok

Bad$:	MOVE.16	#1,D7

Exit$:	POPM.32	D0|D1|D4
	TEST.16	D7
	RET

TABLE$:	.8	0,1,2,4,8,15,16,24,4,4,4,4,4,4,4,4

NmHWDis:	.ASCIZ	"#HWDIS:"
NmAccount:	.ASCIZ	"MON-SEL-RAM"

END_MONSEL:

		.END


