
	.TITLE	TEST.ASM

; Ce petit programme ( excuter depuis SMILE) met en vidence comment
; on peut connatre les profondeurs disponibles, les dimensions associes
; et les moniteurs actifs.

; (C) Copyright 1994,  Pierre ARNAUD pour EPSITEC-system SA

	.PROC	M68020
	.REF	SMAKY

	.REF	MONSEL			; librairie MONSEL
	.REF	HWDIS			; driver $HWDIS
	.REF	DISPLAYMAN		; display manager *.DIS

	.LOC	0
	.START	START

START:
	MOVE.32	A4,A6			; A6 <-- ^variables (> 1000 bytes)

	MOVE.32	#R16^NMHWDIS,A3
	MOVE.32	#2**BOPRD,D3
	FOS	?OPEN			; ouvre #HWDIS:
	JUMP,NE	NOHWDIS$		; erreur => pas de $DIS "moderne"

	MOVE.32	#{A6}+0,A4
	MOVE.32	#lgHWStatDisRec,D4
	FOS	?RSTATUS		; cherche infos sur les 4 moniteurs
	JUMP,NE	ERR$

; -------------------------------------------------------------------------

MON0$:	LIB	?AFTIM
	.ASCIZE	"Moniteur 0 : "

	TEST.32	{A4}+oHWStatDis0+oHWDisChannel
	JUMP,EQ	R8^ABS0$

	MOVE.32	{A4}+oHWStatDis0+oHWDisHeader,A0
	MOVE.32	{A4}+oHWStatDis0+oHWDisDynInfo,A1
	MOVE.32	{A4}+oHWStatDis0+oHWDisMonInfo,A2
	CALL	AffModes
	JUMP	R8^MON1$

ABS0$:	LIB	?AFTIM
	.ASCIZE	"absent !<CR>"

; -------------------------------------------------------------------------

MON1$:	LIB	?AFTIM
	.ASCIZE	"Moniteur 1 : "

	TEST.32	{A4}+oHWStatDis1+oHWDisChannel
	JUMP,EQ	R8^ABS1$

	MOVE.32	{A4}+oHWStatDis1+oHWDisHeader,A0
	MOVE.32	{A4}+oHWStatDis1+oHWDisDynInfo,A1
	MOVE.32	{A4}+oHWStatDis0+oHWDisMonInfo,A2
	CALL	AffModes
	JUMP	R8^MON2$

ABS1$:	LIB	?AFTIM
	.ASCIZE	"absent !<CR>"

; -------------------------------------------------------------------------

MON2$:	LIB	?AFTIM
	.ASCIZE	"Moniteur 2 : "

	TEST.32	{A4}+oHWStatDis2+oHWDisChannel
	JUMP,EQ	R8^ABS2$

	MOVE.32	{A4}+oHWStatDis2+oHWDisHeader,A0
	MOVE.32	{A4}+oHWStatDis2+oHWDisDynInfo,A1
	MOVE.32	{A4}+oHWStatDis0+oHWDisMonInfo,A2
	CALL	AffModes
	JUMP	R8^MON3$

ABS2$:	LIB	?AFTIM
	.ASCIZE	"absent !<CR>"

; -------------------------------------------------------------------------

MON3$:	LIB	?AFTIM
	.ASCIZE	"Moniteur 3 : "

	TEST.32	{A4}+oHWStatDis3+oHWDisChannel
	JUMP,EQ	R8^ABS3$

	MOVE.32	{A4}+oHWStatDis3+oHWDisHeader,A0
	MOVE.32	{A4}+oHWStatDis3+oHWDisDynInfo,A1
	MOVE.32	{A4}+oHWStatDis0+oHWDisMonInfo,A2
	CALL	AffModes
	JUMP	R8^MON4$

ABS3$:	LIB	?AFTIM
	.ASCIZE	"absent !<CR>"

; -------------------------------------------------------------------------

MON4$:	FOS	?CLOSE
	LIB	?AFCR

; -------------------------------------------------------------------------

; Au dbut du programme, une fois que l'on sait que #HWDIS: existe et
; que le RSTATUS a fonctionn, on doit ouvrir MONSEL :

	MOVE.32	#0,D2			; mode normal
	MONSEL_	OPEN			; A2 <-- canal MONSEL
	JUMP,NE	ERR$

; Vrifie si un mode propos peut tre accept par le hardware. Le
; record pass en entre correspond  oMonSel.. (MONSEL.ASS) !

	MOVE.32	#mMSModeCheck,D2	; vrifie juste, ne change rien
	MOVE.32	#R16^MODE$,A4		; description du mode
	MONSEL_	SETMODE			; vrifie le mode
	JUMP,EQ	R8^OkMode$		; ok => suite

	LIB	?AFTIM
	.ASCIZE	"Le mode n'a pas t reconnu !<CR>"
	JUMP	End$

OkMode$:
	LIB	?AFTIM
	.ASCIZE	"Le mode propos a t accept par MONSEL.<CR>"

	MOVE.32	#mMSModeLocal,D2	; dfinit le mode local
	MOVE.32	#R16^MODE$,A4		; description du mode
	MONSEL_	SETMODE			; active le mode

; -------------------------------------------------------------------------

; Le bout de code qui suit doit tre excut par le pilote $DIS, quand
; il dsire installer une instance du driver. Il peut faire plusieurs
; tentatives en incrmentant D3  chaque tentative si les premires
; chouent pour des questions de manque de V-RAM :

	LIB	?AFTIM
	.ASCIZE	"<CR>Simule ce que $DIS fait lors de l'install :<CR>"

;	MOVE.32	A2,A2			; A2 <-- canal rendu  $DIS_0
	MOVE.32	#R16^HEAD$,A3		; A3 <-- ^min/max
	MOVE.32	#{A6}+600,A4		; A4 <-- ^buffer oMonSel..
	MOVE.32	#0,D3			; D3 <-- numro du test
	MONSEL_	INFO			; appel pour $DIS
	JUMP,NE	EndDIS$

	LIB	?AFTIM
	.ASCIZE	" Mode 0: "
	MOVE.32	{A4}+0,D4
	LIB	?AFX8, ?AFSPACE
	MOVE.32	{A4}+4,D4
	LIB	?AFX8, ?AFSPACE
	MOVE.16	{A4}+8,D4
	LIB	?AFX4, ?AFCR

	MOVE.32	#1,D3			; D3 <-- numro du test
	MONSEL_	INFO			; appel pour $DIS
	JUMP,NE	EndDIS$

	LIB	?AFTIM
	.ASCIZE	" Mode 1: "
	MOVE.32	{A4}+0,D4
	LIB	?AFX8, ?AFSPACE
	MOVE.32	{A4}+4,D4
	LIB	?AFX8, ?AFSPACE
	MOVE.16	{A4}+8,D4
	LIB	?AFX4, ?AFCR

	MOVE.32	#2,D3			; D3 <-- numro du test
	MONSEL_	INFO			; appel pour $DIS
	JUMP,NE	EndDIS$

	LIB	?AFTIM
	.ASCIZE	" Mode 2: "
	MOVE.32	{A4}+0,D4
	LIB	?AFX8, ?AFSPACE
	MOVE.32	{A4}+4,D4
	LIB	?AFX8, ?AFSPACE
	MOVE.16	{A4}+8,D4
	LIB	?AFX4, ?AFCR

EndDIS$:
	LIB	?AFTIM
	.ASCIZE	"Termin avec la simulation de $DIS.<CR><CR>"

; -----------------------------------------------------------------------

; Le code excut ci-aprs (dans START par exemple) montre comment
; remettre le mode par dfaut aprs le FOS ?nEXECUTE :

	MOVE.32	#R16^NMPICASSO,A3
	MOVE.32	#0,D4
	SUB.32	A5,A5
;	FOS	?nEXECUTE		; lance PICASSO en 4 bit/pixel

	MOVE.32	#mMSModeLocal,D2	; dfinit le mode local
	SUB.32	A4,A4			; plus de mode local
	MONSEL_	SETMODE			; dsactive le mode
	JUMP,NE	ERR$

End$:	MONSEL_	CLOSE
	EXIT

ERR$:	LIB	?AFERROR, ?AFCR
	EXIT

NOHWDIS$:
	LIB	?AFTIM
	.ASCIZE	"Pas de pilote cran `moderne'.<CR>"
	EXIT


; Mode pour le moniteur oMonSel.. (MONSEL.ASS)
; --------------------------------------------

MODE$:
	.16	0			; numro du moniteur
	.8	0			; 2**bMonSelNoBar, 2**bMonSelNoSKey
	.8	0			; toujours 0
	.16	640, 480		; dimension pixmap (dx, dy)
	.16	4			; profondeur (bit/pixel)
	.16	0, 0, 0			; toujours 0

HEAD$:	.16	20,2000,20,2000

; -------------------------------------------------------------------------

; Affiche des informations sur un moniteur et sur les
; profondeurs disponibles.

; in	A0.32	^en-tte du display manager (oHDM.. de DISPLAYMAN.ASS)
;	A1.32	^description dynamique (oDMI.. de DISPLAYMAN.ASS)
;	A2.32	^description des param. vido hardware
; out	-
; mod	D7.16

AffModes:
	PUSHM.32 D0..D4|A0|A1|A3

	MOVE.32	#{A0}+oHDMIdent,A3
	LIB	?AFTEXT
	LIB	?AFTIM
	.ASCIZE	" ("
	MOVE.32	#{A0}+oHDMSerial,A3
	LIB	?AFTEXT
	LIB	?AFTIM
	.ASCIZE	").<CR>"

	MOVE.32	#R16^TABLE$,A0
	
Loop$:	MOVE.32	{A1+},D1		; bitset des tailles
	MOVE.16	{A0+},D0		; profondeur courante
	JUMP,EQ	R8^Exit$

	TEST.32	D1			; y a-t-il des tailles ?
	JUMP,EQ	Loop$			; non => suite

	LIB	?AFTIM
	.ASCIZE	" Bit/pixel = "
	MOVE.16	D0,D4
	LIB	?AFX2
	LIB	?AFTIM
	.ASCIZE	" en"

	MOVE.32	#R16^Taille$,A3

Size$:	MOVE.32	{A3+},D0		; taille dans table
	JUMP,EQ	R8^Next$		; fini => suite

	AND.32	D1,D0			; taille correspond ?
	JUMP,BS	Ok$			; oui => trouv

Skip$:	TEST.8	{A3+}
	JUMP,NE	R8^Skip$
	JUMP	Size$

Ok$:	LIB	?AFSPACE, ?AFTEXT	; affiche la taille
	JUMP	Size$

Next$:	LIB	?AFTIM
	.ASCIZE	".<CR>"
	JUMP	Loop$

; Affiche encore des infos sur les modes vido courants :

Exit$:	LIB	?AFTIM
	.ASCII	"+--------------------------------------------------------------<CR>"
	.ASCIZE	"| Modes vido dfinis par "
	MOVE.32	#{A2}+oHWMonFileName,A3
	LIB	?AFTEXT
	LIB	?AFTIM
	.ASCIZE	"...<CR>"
	LIB	?AFTIM
	.ASCIZE	"| Dimensions physiques de l'cran : "

	MOVE.32	#0,D4
	MOVE.32	#8,D3
	MOVE.32	#2**BAFDCM,D2
	MOVE.16	{A2}+oHWMonPhysDxMM,D4
	LIB	?AFDEC
	LIB	?AFTIM
	.ASCIZE	"x"
	MOVE.16	{A2}+oHWMonPhysDyMM,D4
	LIB	?AFDEC
	LIB	?AFTIM
	.ASCIZE	" [mm]<CR>"

	MOVE.16	{A2}+oHWMonNumRec,D0	; D0 <-- nombre de records vido
	ADD.A16	{A2}+oHWMonGammaLen,A2
	ADD.A16	#lgHWMonRec,A2		; A2 <-- ^premier record vido
	MOVE.32	#0,D1

VidRec$:
	COMP.32	{A2}+oHWMRDx,D1		; mme taille ?
	JUMP,EQ	VidNx$			; oui => saute pour ne pas afficher trop

	MOVE.32	{A2}+oHWMRDx,D1

	LIB	?AFTIM
	.ASCIZE	"| Mode `"
	MOVE.32	#{A2}+oHWMRName,A3
	LIB	?AFTEXT
	LIB	?AFTIM
	.ASCIZE	"', h.freq = "
	MOVE.32	{A2}+oHWMRHFreq,D4
	LIB	?AFDEC
	LIB	?AFTIM
	.ASCIZE	" Hz, v.freq = "
	MOVE.32	{A2}+oHWMRVFreq,D4
	LIB	?AFDEC
	LIB	?AFTIM
	.ASCIZE	" mHz.<CR>"

VidNx$:	ADD.A16	{A2}+oHWMRSize,A2
	DEC.16	D0
	JUMP,NE	VidRec$

	LIB	?AFTIM
	.ASCIZE	"+---------------------------------------------------------------<CR>"

	POPM.32	D0..D4|A0|A1|A3
	RET

Table$:	.16	16'01, 16'02, 16'04, 16'08
	.16	16'15, 16'16, 16'24, 16'32
	.16	0

Taille$:
	.32	 2**bHDM_640x400
	.ASCIZ	"640x400"
	.32	2**bHDM_640x480
	.ASCIZ	"640x480"
	.32	2**bHDM_800x600
	.ASCIZ	"800x600"
	.32	2**bHDM_832x624
	.ASCIZ	"832x624"
	.32	2**bHDM_960x720
	.ASCIZ	"960x720"
	.32	2**bHDM_1024x768
	.ASCIZ	"1024x768"
	.32	2**bHDM_1120x832
	.ASCIZ	"1120x832"
	.32	2**bHDM_1152x872
	.ASCIZ	"1152x872"
	.32	2**bHDM_1280x1024
	.ASCIZ	"1280x1024"

; Il y a encore d'autres modes documents dans le fichier de symboles
; nomm DISPLAYMAN.ASS !!!

	.32	2**bHDM_864x1024
	.ASCIZ	"864x1024"
	.32	0

; -------------------------------------------------------------------------


NMHWDIS:	.ASCIZ	"#HWDIS:"
NMPICASSO:	.ASCIZ	"PICASSO"

	.END

