	.TITLE	TEST.ASM
	.PROC	M68020

	.REF	SMAKY
	.REF	GD5446

; [AUTEUR]	14/6/96
;

; Dfinitions
; -----------

PCCODE		= 0
PCVAR		= 1

USE_MMIO	= FALSE


AlpMMIO		= AlpMem+4*1024*1024-256
;AlpMMIO		= AdIOAlpine+16'B8000

MMIO_BgColor	= AlpMMIO+16'00+oS8_32
MMIO_FgColor	= AlpMMIO+16'04+oS8_32
MMIO_BLTWidth	= AlpMMIO+16'08+oS8_16
MMIO_BltHeight	= AlpMMIO+16'0A+oS8_16
MMIO_BltDstPitch= AlpMMIO+16'0C+oS8_16
MMIO_BltSrcPitch= AlpMMIO+16'0E+oS8_16
MMIO_BltDstAddr	= AlpMMIO+16'10+oS8_32
MMIO_BltSrcAddr	= AlpMMIO+16'14+oS8_32
MMIO_BltMode	= AlpMMIO+16'18+oS8_32
MMIO_BltRasterOp= AlpMMIO+16'1A+oS8_32
MMIO_BltModeExt	= AlpMMIO+16'1B+oS8_32
MMIO_TrColor	= AlpMMIO+16'1C+oS8_16
MMIO_BltControl	= AlpMMIO+16'40+oS8_32

.MACRO	WrSR ;index, data
	MOVE.8	%1,AlpSRX
	MOVE.8	%2,AlpSRData
.ENDMACRO

.MACRO	RdSR ;index, data
	MOVE.8	%1,AlpSRX
	MOVE.8	AlpSRData,%2
.ENDMACRO

.MACRO	WrCR ;index, data
	MOVE.8	%1,AlpCRX_Col
	MOVE.8	%2,AlpCRData_Col
.ENDMACRO

.MACRO	RdCR ;index, data
	MOVE.8	%1,AlpCRX_Col
	MOVE.8	AlpCRData_Col,%2
.ENDMACRO

.MACRO	WrAR ;index, data
	TEST.8	AlpStat_Col		; force l'attente d'un index
	MOVE.8	%1,AlpARX_Wr
	MOVE.8	%2,AlpARX_Wr
	MOVE.8	#16'20,AlpARX_Wr
.ENDMACRO

.MACRO	RdAR ;index, data
	TEST.8	AlpStat_Col		; force l'attente d'un index
	MOVE.8	%1,AlpARX_Wr
	MOVE.8	AlpARX_Rd,%2
.ENDMACRO

.MACRO ARDisplay
	TEST.8	AlpStat_Col		; force l'attente d'un index
	MOVE.8	#16'20,AlpARX_Wr
.ENDMACRO

.MACRO	WrGR ;index, data
	MOVE.8	%1,AlpGRX
	MOVE.8	%2,AlpGRData
.ENDMACRO

.MACRO	RdGR ;index, data
	MOVE.8	%1,AlpGRX
	MOVE.8	AlpGRData,%2
.ENDMACRO


; Variables
; ---------

	.LOC	0

	.LOC	0

	.START	START

START:
	move.32	a4,d0
	add.32	#255,d0
	and.32	#.NOT.255,d0
	move.32	d0,a6
.if 0
MOVE.32	AlpMMIO+16'40,D0
MOVE.32	AlpMMIO+16'40+oS8_32,D1
MOVE.32	AlpMMIO+16'40+oS8_16,D2
MOVE.8	AlpMMIO+16'43,D3
MOVE.8	AlpMMIO+16'40+oS8_32,D4
MOVE.8	AlpMMIO+16'42+oS8_16,D5
exit
.endif
MOVE.32	a6,a4
CALL	ReadRegs
exit
.if 1
	MOVE.8	AlpHDR,D0
	MOVE.8	AlpHDR,D0
	MOVE.8	AlpHDR,D0
	MOVE.8	AlpHDR,D0
	MOVE.8	#16'c9,AlpHDR
.else
	CALL	InitCLUT
.endif
;	MOVE.32	#0,A4
;	CALL	SetAddr
	CALL	InitMem
exit
	WrGR #16'31,#2**2		; reset BLT
	CALL	TestFill
exit
	CALL	BenchWrite
exit
	CALL	BenchRead
exit
	CALL	TestBitBLT
exit

MOVE.32	a6,a4
CALL	ReadRegs
exit

WrSR #16'16,#16'01
WrGR #16'31,#2**2		; reset BLT
	CALL	InitCLUT
	move.32	#640,d4
	call	SetPitch
	MOVE.32	#8,D4
	CALL	SetDepth
	CALL	InitMem
	move.32	a6,a4
	CALL	ReadRegs
exit
	CALL	TestFill
exit
	MOVE.32	#4,D4
	CALL	SetPitch
exit
	move.32	#320,d4
	call	SetPitch
	CALL	InitCLUT4
	MOVE.32	#4,D4
	CALL	SetDepth
	CALL	InitMem4

	move.32	a6,a4
	CALL	ReadRegs

	EXIT



;-----------\\
;  ReadRegs  >
;===========/

; Lit tous les registres.

; in	A4.32	^buffer
; out	-
; mod	-

ReadRegs:
	pushm.32 a4|a6
	move.32	a4,a6

;	move.8	AlpPos102,{A4+}
;	move.8	AlpVSSM,{A4+}
	move.8	AlpMiscRd,{A4+}
	move.8	AlpFCRd,{A4+}
	move.8	AlpFEAT,{A4+}
	move.8	AlpSTAT_Col,{A4+}
	move.8	AlpPixMask,{A4+}
	test.8	AlpHDR
	test.8	AlpHDR
	test.8	AlpHDR
	move.8	AlpHDR,{A4+}

	move.32	#{A6}+16,A4
	move.32	#0,D0
LoopSR$:
	RdSR	D0,	{A4+}
	inc.8	D0
	comp.8	#16'1f,d0
	jump,ls	LoopSR$

	move.32	#0,D0
LoopCR$:
	RdCR	D0,	{A4+}
	inc.8	D0
	comp.8	#16'27,d0
	jump,ls	LoopCR$

	move.32	#{A6}+16+32+48,A4
	move.32	#0,D0
LoopAR$:
	RdAR	D0,	{A4+}
	inc.8	D0
	comp.8	#16'14,d0
	jump,ls	LoopAR$

	ARDisplay

	move.32	#{A6}+16+32+48+32,A4
	move.32	#0,D0
LoopGR$:
	RdGR	D0,	{A4+}
	inc.8	D0
	comp.8	#16'1b,d0
	jump,ls	LoopGR$

	MOVE.32	#{A6}+256,A4
	MOVE.32	#3*256-1,D0
	MOVE.8	#0,AlpPixAdrR

LoopC$:	MOVE.8	AlpPixData,{A4+}
	DJ.16,NMO D0,LoopC$

	popm.32	a4|a6
	ret


;-----------\\
;  CheckMem  >
;===========/

; Test (primitif) de la mmoire cran.

; in	-
; out	D7.32	nombre d'erreurs
; mod	-

CheckMem:
	PUSHM.32 d0|d1|a0|a1
	move.32	#AlpMem,a0
	MOVE.32	#(4*1024*1024-16*1024)/4,d0
lw$:	move.32	#16'ffffffff,{a0+}
	dec.32	d0
	jump,ne lw$

	move.32	#AlpMem,a0
	MOVE.32	#(4*1024*1024-16*1024)/4,d0
	move.32	#0,d7
lr$:	move.32	{a0+},D1
	dec.32	d0
	jump,eq	done$
	comp.32	#16'ffffffff,d1
	jump,eq lr$
	inc.32	d7
	jump	lr$
done$:
	POPM.32	d0|d1|a0|a1
	test.32	d7
	ret


;----------\\
;  InitMem  >
;==========/

; Initalise la mmoire avec un motif de contrle.

; in	-
; out	-
; mod	-

InitMem:
	PUSHM.32 d0|d1|d6|d7|a0|a1
	move.32	#MemEcr8,A0
	move.32	#255,D7
	move.32	#0,d1

ly$:	move.32	#640/2,D6
	move.32	#0,d0

lx$:	move.8	d0,{a0+}
	move.8	d1,{a0+}
	inc.8	d0
	dec.16	d6
	jump,ne	lx$

	inc.8	d1
	dec.16	d7
	jump,ne	ly$

	POPM.32	d0|d1|d6|d7|a0|a1
	ret

InitMem4:
	PUSHM.32 d0|d1|d6|d7|a0|a1
	move.32	#MemEcr8,A0
	move.32	#255,D7
	move.32	#0,d1

ly$:	move.32	#320/8,D6
	move.32	#0,d0

lx$:	move.32	d0,{a0+}
	move.32	d1,{a0+}
	add.32	#16'11111111,d0
	dec.16	d6
	jump,ne	lx$

	add.32	#16'11111111,d1
	dec.16	d7
	jump,ne	ly$

	POPM.32	d0|d1|d6|d7|a0|a1
	ret


;-----------\\
;  InitCLUT  >
;===========/

; Initialise la palette avec 
; - 64 tons de rouge
; - 64 tons de vert
; - 64 tons de bleu
; - 64 tons de gris

; in	-
; out	-
; mod	-

InitCLUT:
	PUSHM.32 d0|d1|a0|a1|a4
	move.32	#{A6}+256,a4
	move.8	#0,AlpPixAdrR
	move.32	#256*3-1,d0

lp$:	move.8	AlpPixData,{a4+}
	dj.16,nmo d0,lp$

	move.8	#0,AlpPixAdrW
	move.32	#256/4-1,d0
	move.8	#0,D1

lpw$:	move.8	D1,AlpPixData
	move.8	#0,AlpPixData
	move.8	#0,AlpPixData
	move.8	#0,AlpPixData
	move.8	D1,AlpPixData
	move.8	#0,AlpPixData
	move.8	#0,AlpPixData
	move.8	#0,AlpPixData
	move.8	D1,AlpPixData
	move.8	D1,AlpPixData
	move.8	D1,AlpPixData
	move.8	D1,AlpPixData
	inc.8	d1
	dj.16,nmo d0,lpw$

	POPM.32	d0|d1|a0|a1|a4
	ret


;------------\\
;  InitCLUT4  >
;============/

; Initialise la CLUT pour 1/2/4 bits/pixel

; in	-
; out	-
; mod	-

InitCLUT4:
	PUSHM.32 d0|a0

	move.8	#0,AlpPixAdrW
	move.32	#16*3-1,d0
	move.32	#R16^clut$,a0

l$:	move.8	{A0+},AlpPixData
	DJ.16,NMO d0,l$

	POPM.32	d0|a0
	RET

CLUT$:	.8	16'3f, 16'3f, 16'3f
	.8	0, 0, 0
	.8	16'15, 16'15, 16'15
	.8	16'2a, 16'2a, 16'2a
	.8	16'10, 0, 0
	.8	16'20, 0, 0
	.8	16'30, 0, 0
	.8	16'3f, 0, 0
	.8	0, 16'10, 0
	.8	0, 16'20, 0
	.8	0, 16'30, 0
	.8	0, 16'3f, 0
	.8	0, 0, 16'10
	.8	0, 0, 16'20
	.8	0, 0, 16'30
	.8	0, 0, 16'3f


;-------------\\
;  TestBitBLT  >
;=============/

;

; in	-
; out	-
; mod	-

TestBitBLT:
.if 0
  .if 1
WrGR #16'20,#16'7f
WrGR #16'21,#16'02
WrGR #16'22,#16'ff
WrGR #16'23,#16'00
WrGR #16'24,#16'80
WrGR #16'25,#16'02
WrGR #16'26,#16'80
WrGR #16'27,#16'02

WrGR #16'28,#16'00
WrGR #16'29,#16'00
WrGR #16'2a,#16'00

WrGR #16'2c,#16'80
WrGR #16'2d,#16'02
WrGR #16'2e,#16'00
WrGR #16'2f,#0

WrGR #16'30,#0
WrGR #16'32,#16'0d
WrGR #16'33,#0
WrGR #16'31,#2
  .else ;use MMIO
	MOVE.32	#16'027f00ff,MMIO_BLTWidth
	MOVE.32	#16'02800280,MMIO_BltDstPitch
	MOVE.32	#0,MMIO_BLTDstAddr
	MOVE.32	#640,MMIO_BLTSrcAddr
	MOVE.32	#16'00000d00,MMIO_BLTMode
	MOVE.8	#2**1,MMIO_BLTControl
  .endif
.else
	PUSH.32	d7
	MOVE.32	#100-1,d7
loop$:
	PUSH.32	#2048		; dy
	PUSH.32	#640		; dx
	PUSH.32	#0		; y dst
	PUSH.32	#0		; x dst
	PUSH.32	#1		; y src
	PUSH.32	#0		; x src
	PUSH.32	#0		; pixmap ID
	CALL	BlockMove8
	ADD.32	#7*4,SP
	DJ.16,NMO d7,loop$
	POP.32	d7
.endif
	RET


;-----------\
;  SetDepth  >
;===========/

; Initialise la profondeur.

; in	D4.32	profondeur [bits/pixel]
; out	-
; mod	-

SetDepth:
	PUSHM.32 D0|D1|A0

	COMP.16	#4,D4			; mode planaire ?
	SET.8,HI D7
	INC.8	D7			; D7 <- planaire ? 1 : 0

	MOVE.32	#16'0e,D0
	TEST.8	D7
	JUMP,F	R8^OK1$
	MOVE.32	#16'06,D0
OK1$:	WrSR	#4,	D0		; memory mode

	MOVE.32	#R16^TSR7$,A0
	MOVE.8	{A0}+A16^{D4},D0
.if 1
	move.8	d7,d1
	tnot.32	d1:#0
	or.8	d1,d0
or.8	#1,d0
.else
	OR.8	D7,D0
.endif
	WrSR	#7,	D0		; extended sequencer mode

	MOVE.32	#R16^THDR$,A0
;	WrHDR	{A0}+A16^{D4}		; HDR KO !!!

;CR17[5] = (depth == 1) ?

; aussi en 15/16 bpp ?
	MOVE.32	#0,D0
	COMP.8	#8,D4
	JUMP,NE	R8^OK2$
	MOVE.32	#2**6,D0		; [6] <- 256 color mode
OK2$:	RdGR	#5,	D1
	AND.8	#.NOT.(2**6),D1
	OR.8	D0,D1
	WrGR	#5,	D1		; GR mode

.if 1
	MOVE.32	#0,D0
	TEST.8	D7
	JUMP,T	R8^OK3$
	MOVE.32	#1,D0
OK3$:	WrGR	#6, D0
.endif

; GR7: color don't care ?

.if 1
	MOVE.32	#16'01,D0
	TEST.8	D7
	JUMP,T	R8^OK4$
	MOVE.32	#16'41,D0
OK4$:
	WrAR	#16'10, D0
.else
	MOVE.8	D7,D0
	SL.8	#6,D0
	RdAR	#16'10, D1
	AND.8	#.NOT.(2**6),D1
	OR.8	D0,D1
	WrAR	#16'10, D1		; attribute controller mode
.endif

	POPM.32	D0|D1|A0
	RET


; valeur de SR7 en fonction de la profondeur

TSR7$:
	.8	16'00, 16'f0, 16'f0, 16'00, 16'f0, 16'00, 16'00, 16'00
	.8	16'f0, 16'00, 16'00, 16'00, 16'00, 16'00, 16'00, 16'f2
	.8	16'f6, 16'00, 16'00, 16'00, 16'00, 16'00, 16'00, 16'00
	.8	16'f4, 16'00, 16'00, 16'00, 16'00, 16'00, 16'00, 16'00
	.8	16'f8

; valeur de HDR en fonction de la profondeur

THDR$:
	.8	16'00, 16'00, 16'00, 16'00, 16'00, 16'00, 16'00, 16'00
	.8	16'00, 16'00, 16'00, 16'00, 16'00, 16'00, 16'00, 16'f0
	.8	16'e1, 16'00, 16'00, 16'00, 16'00, 16'00, 16'00, 16'00
	.8	16'e5, 16'00, 16'00, 16'00, 16'00, 16'00, 16'00, 16'00
	.8	16'e5


;-----------\\
;  SetPitch  >
;===========/

; Initialise le "pitch".

; in	D4.32	pitch [bytes/ligne]
; out	-
; mod	-

SetPitch:
	PUSHM.32 D0|D1

	MOVE.32	D4,D0			; pitch
	SR.32	#3,D0			; "offset"
	WrCR	#16'13,	D0		; offset[7..0]

	AND.16	#2**8,D0
	SR.16	#8-4,D0			; [4] <- offset[8]
	RdCR	#16'1B,	D1
	AND.8	#.NOT.(2**4),D1
	OR.8	D0,D1
	WrCR	#16'1B, D1		; extended display controls

	POPM.32	D0|D1
	RET


;----------\\
;  SetAddr  >
;==========/

; initialise l'adresse du pixmap

; in	-
; out	-
; mod	-

SetAddr:
	PUSHM.32 D0..D3

	MOVE.32	A4,D3
	SR.32	#2,D3
	MOVE.32	D3,D2
	SWAP.32	D2
	MOVE.8	D2,D1
	AND.8	#2**(19-16),D1
	SL.8	#7-(19-16),D1

	RdCR	#16'1D,	D0
	AND.8	#16'7F,D0
	OR.8	D1,D0
	WrCR	#16'1D, D0		; bit 19
	MOVE.8	D2,D1
	AND.8	#16'06,D1
	SL.8	#1,D1
	AND.8	#16'01,D2
	OR.8	D2,D1
	RdCR	#16'1B,D0
	AND.8	#16'f2,D0
	OR.8	D1,D0
	WrCR	#16'1B,D0		; bits 18..17 et 16
	MOVE.16	D3,D0
	SWAP.16	D0
	WrCR	#16'0C,D0		; bits 15..8
	SWAP.16	D0
	WrCR	#16'0D,D0		; bits 7..0

	POPM.32	D0..D3
	RET


TestFill:
	PUSHM.32 D6|D7
	MOVE.32	#0,D6
	MOVE.32	#200-1,d7
loop$:
	PUSH.32	D6
	PUSH.32	#2048		; dy
	PUSH.32	#640		; dx
	PUSH.32	#16		; y
	PUSH.32	#0		; x
	PUSH.32	#0		; pixmap ID
	CALL	BlockFill8
	ADD.32	#6*4,SP
	INC.8	D6
	DJ.16,NMO d7,loop$
	POPM.32	D6|D7
	RET


;------------\\
;  BenchRead  >
;============/

;

; in	-
; out	-
; mod	-

BenchRead:
	PUSHM.32 D0..D7|A0..A6

	MOVE.32	#AlpMem,A0
	MOVE.32	#1000000,D0

Loop$:	MOVEM.32 {A0},D2..D7|A1..A6	; 12 accs 32 bits aligns
	DEC.32	D0
	JUMP,NE	Loop$

	POPM.32	D0..D7|A0..A6
	RET


;-------------\\
;  BenchWrite  >
;=============/

;

; in	-
; out	-
; mod	-

BenchWrite:
	PUSHM.32 D0..D7|A0..A6

	MOVE.32	#AlpMem,A0
	MOVE.32	#1000000,D0

Loop$:	MOVEM.32 D0..D7|A0..A7,{A0}	; 16 accs 32 bits aligns
	DEC.32	D0
	JUMP,NE	Loop$

	POPM.32	D0..D7|A0..A6
	RET


;-------------\\
;  BlockMove8  >
;=============/

; Dplacement de bloc en 8 bits/pixel

; in	{SP}	adresse de retour
;	{SP}+4	ID de pixmap
;	{SP}+8	src x
;	{SP}+12	src y
;	{SP}+16	dst x
;	{SP}+20 dst y
;	{SP}+24	dx
;	{SP}+28 dy
; out	-
; mod	-

BlockMove8:

	.APC	PCVAR
	.LOC	4
PmID$:	.BLK.32	1
SrcX$:	.BLK.32	1
SrcY$:	.BLK.32	1
DstX$:	.BLK.32	1
DstY$:	.BLK.32	1
DX$:	.BLK.32	1
DY$:	.BLK.32	1
	.APC	PCCODE

	MOVE.32	SP,A1
	PUSHM.32 D2|A2|A5

	MOVE.32	{A1}+PmID$,A5
	MOVE.32	#640,D2

	MOVE.32	{A1}+DX$,D0
	DEC.16	D0
	SWAP.32	D0
	MOVE.16	{A1}+DY$+2,D0
	DEC.16	D0
.IF USE_MMIO
	MOVE.32	D0,MMIO_BLTWidth
.ELSE
	WrGR	#16'22,D0
	SR.32	#8,D0
	WrGR	#16'23,D0
	SR.32	#8,D0
	WrGR	#16'20,D0
	SR.32	#8,D0
	WrGR	#16'21,D0
.ENDIF

	MOVE.16	D2,D0
	SWAP.32	D0
	MOVE.16	D2,D0
.IF USE_MMIO
	MOVE.32	D0,MMIO_BLTDstPitch
.ELSE
	WrGR	#16'26,D0
	SR.32	#8,D0
	WrGR	#16'27,D0
	SR.32	#8,D0
	WrGR	#16'24,D0
	SR.32	#8,D0
	WrGR	#16'25,D0
.ENDIF

	MOVE.32	{A1}+DstY$,D0
	MUL.16	D2,D0
	ADD.32	{A1}+DstX$,D0
	ADD.32	#0,D0
	AND.32	#16'ffffff,D0
.IF USE_MMIO
	MOVE.32	D0,MMIO_BLTDstAddr
.ELSE
	WrGR	#16'28,D0
	SR.32	#8,D0
	WrGR	#16'29,D0
	SR.32	#8,D0
	WrGR	#16'2A,D0
.ENDIF

	MOVE.32	{A1}+SrcY$,D0
	MUL.16	D2,D0
	ADD.32	{A1}+SrcX$,D0
	ADD.32	#0,D0
	AND.32	#16'ffffff,D0
.IF USE_MMIO
	MOVE.32	D0,MMIO_BLTSrcAddr
.ELSE
	WrGR	#16'2C,D0
	SR.32	#8,D0
	WrGR	#16'2D,D0
	SR.32	#8,D0
	WrGR	#16'2E,D0
	SR.32	#8,D0
	WrGR	#16'2F,D0
.ENDIF

.IF USE_MMIO
	MOVE.32	#16'00000D00,MMIO_BLTMode
	MOVE.8	#2**1,MMIO_BltControl		; start

Wait$:	TEST.8	MMIO_BltControl:#1
	JUMP,T	Wait$				; attend la fin
.ELSE
	WrGR	#16'30,#0
	WrGR	#16'32,#16'0d
	WrGR	#16'33,#0

	WrGR	#16'31,#2**1			; start

Wait$:	RdGR	#16'31,D0
	TEST.32	D0:#1
	JUMP,T	Wait$
.ENDIF

	POPM.32	D2|A2|A5
	RET



;-------------\\
;  BlockFill8  >
;=============/

; Remplissage uniforme de bloc en 8 bits/pixel.

; in	{SP}	adresse de retour
;	{SP}+4	ID de pixmap
;	{SP}+8	x
;	{SP}+12	y
;	{SP}+16	dx
;	{SP}+20 dy
;	{SP}+24	couleur
; out	-
; mod	-

BlockFill8:

	.APC	PCVAR
	.LOC	4
PmID$:	.BLK.32	1
X$:	.BLK.32	1
Y$:	.BLK.32	1
DX$:	.BLK.32	1
DY$:	.BLK.32	1
Col$:	.BLK.32	1
	.APC	PCCODE

	MOVE.32	SP,A1
	PUSHM.32 D2|A2|A5

	MOVE.32	{A1}+PmID$,A5
	MOVE.32	#640,D2
.if 1
	MOVE.32	A1,A5
	PUSH.32	D3
	MOVE.32	{A5}+Y$,D0
	MUL.16	D2,D0
	ADD.32	{A5}+X$,D0
	ADD.32	#0,D0
	AND.32	#16'ffffff,D0
	MOVE.32	D0,A0

	MOVE.32	{A5}+Col$,D0
	MOVE.32	D0,D1

	MOVE.32	D2,D3

	MOVE.32	{A5}+DY$,D2
	DEC.16	D2
	SWAP.32	D2
	MOVE.16	{A5}+DX$+2,D2
	DEC.16	D2

	MOVE.32	#16'040D00C0,A2

	CALL	WriteBLT
	POP.32	D3
.else
	MOVE.32	{A1}+DX$,D0
	DEC.16	D0
	SWAP.32	D0
	MOVE.16	{A1}+DY$+2,D0
	DEC.16	D0
.IF USE_MMIO
	MOVE.32	D0,MMIO_BLTWidth
.ELSE
	WrGR	#16'22,D0
	SR.32	#8,D0
	WrGR	#16'23,D0
	SR.32	#8,D0
	WrGR	#16'20,D0
	SR.32	#8,D0
	WrGR	#16'21,D0
.ENDIF

.IF USE_MMIO
	MOVE.16	D2,MMIO_BLTDstPitch
.ELSE
	MOVE.16	D2,D0
	WrGR	#16'24,D0
	SR.32	#8,D0
	WrGR	#16'25,D0
.ENDIF

	MOVE.32	{A1}+Y$,D0
	MUL.16	D2,D0
	ADD.32	{A1}+X$,D0
	ADD.32	#0,D0
	AND.32	#16'ffffff,D0
.IF USE_MMIO
	MOVE.32	D0,MMIO_BLTDstAddr
.ELSE
	WrGR	#16'28,D0
	SR.32	#8,D0
	WrGR	#16'29,D0
	SR.32	#8,D0
	WrGR	#16'2A,D0
.ENDIF

	MOVE.32	{A1}+Col$,D0
.IF USE_MMIO
	MOVE.8	D0,MMIO_FgColor+3
.ELSE
	WrGR	#16'01,D0
	WrGR	#0,D0
.ENDIF

.IF USE_MMIO
	MOVE.32	#16'C0000D04,MMIO_BLTMode
.ELSE
	WrGR	#16'30,#2**7+2**6	; color expansion, pattern copy
	WrGR	#16'32,#16'0d
	WrGR	#16'33,#2**2		; solid color fill
.ENDIF
.endif

.IF 1;USE_MMIO
	MOVE.8	#2**1,MMIO_BltControl		; start

Wait$:
MOVE.8	MMIO_BltControl,D0
MOVE.16	MMIO_BltControl,D1
MOVE.32	MMIO_BltControl,D2
exit
PUSH.32	d4
MOVE.32	#1,D4
;ntrel	?delms
POP.32	d4
	TEST.8	MMIO_BltControl:#1
	JUMP,T	Wait$				; attend la fin
.ELSE
	WrGR	#16'31,#2**1			; start

Wait$:
PUSH.32	d4
MOVE.32	#1,D4
;ntrel	?delms
POP.32	d4
	RdGR	#16'31,D0
	TEST.32	D0:#1
	JUMP,T	Wait$
.ENDIF

	POPM.32	D2|A2|A5
	RET


;-----------\\
;  WriteBLT  >
;===========/

;

; in	D0.32	couleur fond
;	D1.32	couleur chair
;	D2.32	[dy-1 ; dx-1]
;	D3.32	[pitch source ; pitch destination]
;	A0.32	adresse destination
;	A1.32	adresse source
;	A2.32	[extensions mode ; raster OP ; - ; mode]
; out	-
; mod	-

WriteBLT:
	MOVEM.32 D0..D3|A0..A2,AlpMMIO ;+oS8_32
	RET


;-------------\\
;  WaitVBlank  >
;=============/

; Attend le retour de trace vertical

; in	-
; out	-
; mod	-

WaitVBlank:
	PUSH.32	A0
	MOVE.32	#AlpStat_Col,A0
W0$:	TEST.8	{A0}:#3
	JUMP,T	W0$
W1$:	TEST.8	{A0}:#3
	JUMP,F	W1$
	POP.32	A0
	RET


	.END
