	.TITLE	TEST5446.ASM
	.PROC	M68020

	.REF	SMAKY
	.REF	GD5446

; Dfinitions
; -----------

.MACRO	WrSR ;index, data
	MOVE.8	%1,AlpSRX
	MOVE.8	%2,AlpSRData
.ENDMACRO


; Variables
; ---------

	.LOC	0

	.LOC	0

	.START	START

START:
;	CALL	Reset5446
;	CALL	ConfigPCI
	CALL	Init5446
	CALL	TestMem
	EXIT


Reset5446:
	PUSHM.32 D4|D7
	Move.8	#0,RzAlp
	move.32	#1,d4
	ntrel	?delms
	Move.8	#0,ClrRzAlp
	POPM.32	D4|D7
	RET


ConfigPCI:
	Move.32	#-1,PCI10
	Move.32	#-1,PCI14
MOVE.32	pci10,d1
MOVE.32	pci14,d2
	Move.32	#AlpMem.AND.16'01000000,PCI10
	Move.32	#AlpIO.AND.16'01FFF000+2**0,PCI14
	Move.32	#2**0+2**1,PCI04
MOVE.32	pci04,d0
MOVE.32	pci10,d1
MOVE.32	pci14,d2
	RET


TestMem:
	MOVE.32	#AlpMem,A0
	MOVE.32	#(4*1024*1024-256)/4,D0

Loop$:	MOVE.32	A0,{A0+}
	DEC.32	D0
	JUMP,NE	Loop$

	MOVE.32	#AlpMem,A0
	MOVE.32	#(4*1024*1024-256)/4,D0

Loop2$:	COMP.32	{A0},A0
	JUMP,NE	R8^Err2$
	ADD.32	#4,A0
	DEC.32	D0
	JUMP,NE	Loop2$
	JUMP	R8^T3$

Err2$:	EXIT

T3$:	MOVE.32	#AlpMem,A0
	MOVE.32	#(4*1024*1024-256)/4,D0

Loop3$:	MOVE.16	{A0},D1
	SWAP.32	D1
	MOVE.16	{A0}+2,D1
	COMP.32	D1,A0
	JUMP,NE	R8^Err3$
	ADD.32	#4,A0
	DEC.32	D0
	JUMP,NE	Loop3$
	JUMP	T4$

Err3$:	EXIT

T4$:	MOVE.32	#AlpMem,A0
	MOVE.32	#(4*1024*1024-256)/4,D0

Loop4$:	MOVE.8	{A0},D1
	SWAP.16	D1
	MOVE.8	{A0}+1,D1
	SWAP.32	D1
	MOVE.8	{A0}+2,D1
	SWAP.16	D1
	MOVE.8	{A0}+3,D1
	COMP.32	D1,A0
	JUMP,NE	R8^Err4$
	ADD.32	#4,A0
	DEC.32	D0
	JUMP,NE	Loop4$

MOVE.32	#AlpMem+1,A0
MOVE.16	{A0+},D0
MOVE.16	{A0+},D1
MOVE.32	{A0},D2
MOVE.32	{A0}+1,D3
MOVE.32	{A0}+2,D4
MOVE.32	{A0}+3,D5
exit
	JUMP	Done$

Err4$:	EXIT

Done$:	RET


Init5446:
	WrSR	#16'f, #16'98
	ret
MOVE.8	AlpMiscRd,D0
	WrSR	#0, #16'01
	WrSR	#1, #16'01
	WrSR	#0, #16'03
	WrSR	#2, #16'0f
	WrSR	#3, #16'00
	WrSR	#4, #16'0e
	RET


	.END
