	.TITLE	TMONO.ASM

	.PROC	M68020

	.REF	GD5446
	.REF	HWDIS
	.REF	DISPLAYMAN
	
	.INS	ALPDEF.ASI

VGAMem	= AlpIO+16'A0000

	.APC	PCCODE
	.LOC	0
	.START	START

START:
	RdSR	#16'B, D0
	RdSR	#16'1B, D1
exit

	WrGR	#16'5E, #16'ff
	RdGR	#16'5e,D0
exit
	WrSR	#7, #16'81
	WrSR	#0, #16'01
	WrSR	#4, #16'0e
	WrSR	#0, #16'03
	WrGR	#5, #16'40

	MOVE.32	#AlpMem,A0
	MOVE.32	#(2*1024*1024-16*1024)/4,D0
L$:	MOVE.32	#16'00000000,{A0+}
	DEC.32	D0
	JUMP,NE	L$
exit


	WrSR	#7, #16'80
	WrSR	#0, #16'01
	WrSR	#4, #16'06
	WrSR	#0, #16'03
	WrGR	#5, #16'00


	MOVE.32	#0,A4
	CALL	SetAddr
	MOVE.32	#640/2,D4
	CALL	SetPitch

	MOVE.32	#AlpMem+320/8-4,A0
	MOVE.32	#480/2-1,D0

LV$:	MOVE.32	#16'01234567,{A0}
	MOVE.32	#16'89abcdef,{A0}+4
	ADD.32	#640/8,A0
	DJ.16,NMO D0,LV$

	MOVE.32	#AlpMem+(640/8*480/2),A0
	MOVE.32	#640/64-1,D0

LH$:	MOVE.32	#16'01234567,{A0+}
	MOVE.32	#16'89abcdef,{A0+}
	DJ.16,NMO D0,LH$

	exit


;----------\
;  SetAddr  >
;==========/

;

; in	A4.32	adresse
; out	-
; mod	-

SetAddr:
	PUSHM.32 D0..D3

	MOVE.32	A4,D3
	SR.32	#2,D3
	MOVE.32	D3,D2
	SWAP.32	D2
	MOVE.8	D2,D1
	AND.8	#2**(19-16),D1
	SL.8	#7-(19-16),D1
	RdCR	#16'1D,	D0
	AND.8	#16'7F,D0
	OR.8	D1,D0
	WrCR	#16'1D, D0		; bit 19
	MOVE.8	D2,D1
	AND.8	#16'06,D1
	SL.8	#1,D1
	AND.8	#16'01,D2
	OR.8	D2,D1
	RdCR	#16'1B,D0
	AND.8	#16'f2,D0
	OR.8	D1,D0
	WrCR	#16'1B,D0		; bits 18..17 et 16
	MOVE.16	D3,D0
	SWAP.16	D0
	WrCR	#16'0C,D0		; bits 15..8
	SWAP.16	D0
	WrCR	#16'0D,D0		; bits 7..0

	POPM.32	D0..D3
	RET


;-----------\\
;  SetPitch  >
;===========/

; Initialise le "pitch" (nombre de bytes par ligne).

; in	D4.32	pitch [bytes/ligne]
; out	-
; mod	-

SetPitch:
	PUSHM.32 D0|D1

	MOVE.32	D4,D0			; pitch
	SR.32	#3,D0			; "offset"
	WrCR	#16'13,	D0		; offset[7..0]

	AND.16	#2**8,D0
	SR.16	#8-4,D0			; [4] <- offset[8]
	RdCR	#16'1B,	D1
	AND.8	#.NOT.(2**4),D1
	OR.8	D0,D1
	WrCR	#16'1B, D1		; extended display controls

	POPM.32	D0|D1
	RET

.END
