	.TITLE	130_AUDIO.ASD

;	--------------------------------------
;		(C) 1992 - Daniel Roux
;	--------------------------------------

;	Source du pilote 130_AUDIO.DRIV


	.PROC	M68000

	.REF	SMAKY
	.REF	BIOSDRIV
;	.REF	SM130HARD
;	.REF	SHIDRIV130
	.REF	AUDIO
	.REF	ASYNC

	.BASE	10'10
	.LAYOUT HEX



;	Date		Amliorations
; --------------------------------------------------------------------------
; 0.4	07.03.95  PA	traduction en CALM, petites optimisations
; 0.3	30.06.93	n'utilise plus INITINTER dans l'interrupt 256Hz
; 0.2	15.01.93	mode asynchrone entirement repens !
; 0.1	25.03.92	premire version
; --------------------------------------------------------------------------



MAJREV	=	0		; rvision
MINREV	=	4		; version

	.REV	MAJREV,MINREV



; Constantes
; ----------

MAXBUF	=	5		; nb de buffers tampons
LBUF	=	2000		; lg buffer tampon [2000 => 57ms  35KHz]

WAITBUF	=	2		; attente pour librer un buffer LBUF [2*20ms = 40ms]
WAITSTOP=	25		; attente pour stopper l'interruption [25*4ms = 100ms]



; Dfinitions du hardware SMAKY130
; --------------------------------

_SETFREQSON	= 16'28
_INITINTSON	= 16'24
_INITINT256HZ	= 16'54
_GETCONFIGHARD	= 16'50

ClaK1		= 1		; clavier avec K1
ClaBal		= 0		; calvier balay par Smaky

ADMODESONMOYEN	= 16'FFFF9FE0
ADMODESONFORT	= 16'FFFF9FE8
ADRZNMI		= 16'FFFF9FD8
BITON		= 16'80
BITOFF		= 16'00
ADSON		= 16'FFFF8380
ADCIOPORTB	= 16'FFFFB584
ADRET500	= 16'FFFFBF80

ADVECTNMI	= 16'7C



; Variables absolues
; ------------------

SoundPList =	16'10A6		; ^bloc courant de la liste (tte)
SoundPData =	16'10AA		; ^data
SoundLData =	16'10AE		; lg data restante
SoundPSem  =	16'10B2		; ^smaphore
SoundPVar  =	16'10B6		; ^variables



; Interface pour l'acquisition
; ----------------------------

SM130ADMUBUS =	16'FFFF8000

MADSTART =	16'08		; dbut conversion
MADREAD	=	16'08		; lecture data



; Dfinition d'un bloc de list
; ----------------------------

	.LOC	0
OLBFREE:.BLK.8	1		; 1 -> bloc occup
	.BLK.8	1		; rserve
OLBPREV:.BLK.8	4		; ^bloc prcdent
OLBPSEM:.BLK.8	4		; ^smaphore
OLBFREQ:.BLK.8	2		; frquence du data
OLBPDAT:.BLK.8	4		; ^data
OLBLDAT:.BLK.8	4		; longueur du data
LLB:


;			|-------|
;	     SoundPList	|   x-----------------------|
;			|-------|		    |
;						    |
;	|-------|	|-------|	|-------|   |
;	|   0	|<----------x	|<----------x	|<--|
;	|-------|	|-------|	|-------|
;	|  lg	|	|  lg	|	|  lg	|
;	|-------|	|-------|	|-------|
;	|   x-------|	|   x-------|	|   x-------|
;	|-------|   |	|-------|   |	|-------|   |
;		    |		    |		    |
;	|-------|   |	|-------|   |	|-------|   |
;	|	|<--|	|	|<--|	|	|<--|
;	| data	|	| data	|	| data	|<------ SoundPData
;	|	|	|	|	|	|
;	|-------|	|-------|	|-------|
;
;	   blocs en attente ...		bloc en cours
;					d'audition par
;					la routine 35 KHz



; Variables
; ---------

	.LOC	0
OLEVEL:	.BLK.8	1		; niveau (0..255)
	.EVEN
OLRSTH:	.BLK.8	2		; lg restant  lire pour l'en-tte
OLRSTB:	.BLK.8	4		; lg restant  lire pour le buffer
OHEAD:	.BLK.8	LADH		; buffer pour en-tte

ORDNIV:	.BLK.8	2		; read: niveau  atteindre avant dpart
ORDTIM:	.BLK.8	4		; read: timeout
ORDPT:	.BLK.8	4		; read: ^buffer
ORDLG:	.BLK.8	4		; read: lg  lire
ORDNBR:	.BLK.8	4		; read: nb de bytes lus
ORDTIC:	.BLK.8	4		; read: dcompteur timeout
ORDNIH:	.BLK.8	1		; read: niveau haut
ORDNIL:	.BLK.8	1		; read: niveau bas
ORDTRI:	.BLK.8	1		; read: flag trigger
ORDSTO:	.BLK.8	1		; read: stoppe la lecture
	.EVEN

OSTART:	.BLK.8	1		; 1 => dbute l'interruption
OREC:	.BLK.8	1		; 1 => enregistrement en cours
ORUN:	.BLK.8	1		; 0 => stopp, 1 => enclench
	.EVEN
OFREQ:	.BLK.8	2		; dernire frquence
ODCNT:	.BLK.8	2		; dcompteur
OPNUM:	.BLK.8	2		; numro du processus qui crit
OPSEX:	.BLK.8	4		; ^smaphore d'exclusion
OPSEL:	.BLK.8	4		; ^smaphore d'exclusion
OPSEM:	.BLK.8	4		; ^smaphore
OBUF:	.BLK.8	MAXBUF*(LLB+LBUF) ; blocs OLB* et buffers

LGVAR:





	.LOC	0
DEBUT:
	.16	0,S0BASE
	.16	2**7


; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $AUDIO_0		No H'4F
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

S0ID:
	.16	S0OPEN-S0BASE
	.16	S0COMMAND-S0BASE
	.16	-1			; S0RSTATUS-S0BASE
	.16	S0READ-S0BASE
	.16	S0WRITE-S0BASE
	.16	S0CLOSE-S0BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; S0AUX1-S0BASE
	.16	-1			; S0AUX2-S0BASE
	.16	S0RESET-S0BASE
	.16	S0KILL-S0BASE
	.16	-1			; S0STRT-S0BASE
	.16	-1			; S0TSTRT-S0BASE
	.16	-1			; S0START-S0BASE

S0NAB:	.ASCII	"AUDIO_0"		; nom driver
S0NAF:	.FILL.8	LGDNAM-(S0NAF-S0NAB),0

	.8	16'4F			; numro driver
	.8	TYPIO			; type streamer

	.8	MAJREV,MINREV		; rvision - version
	.8	0			; priorit
	.8	0			; rserve
	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK	; attribut 0

	.FILL.8	LGDDESC-(APC-S0ID),0	; le reste
S0BASE:





;--------\\
; S0RESET >
;========/

; Initialisation du pilote.

; in	-
; out	A6.L	^variables globales
;	D7.16	erreur
; mod	D7.W, A6.L

S0RESET:
	PUSHM.32 D1|D4|A1|A4|A5

	MOVE.32	#R16^DEBUT,A4
	MOVE.32	#LGVAR,D4
	FOS	?GETCOMMEM
	JUMP,NE	 R8^EXIT$
	GESMEM	?CLEARMEM
	MOVE.32	A4,A6		; A6 <-- ^variables globales

	MOVE.32	A6,SoundPVar

	MOVE.8	#255,{A6}+OLEVEL

	MOVE.32	#16'1000000*"C"+16'10000*"L"+16'100*"A"+16'1*SPACE,D4
	MOVE.32	_INDSHI,A4
	CALL	{A4}+_GETCONFIGHARD
	MOVE.16	#1,D7		; D7 <-- erreur
	COMP.32	#CLAK1,D4	; clavier gr par le processeur "K1" ?
	JUMP,NE	 R8^EXIT$	; non => EXIT$

	CLR.32	SoundPList	; la liste est vide
	CLR.32	SoundLData	; y'a pas de data  crire
	CLR.32	SoundPSem	; y'a pas de smaphore

	MOVE.16	#-1,{A6}+OPNUM	; aucun processus n'crit

	MOVE.32	#1,D4
	NTREL	?CRESEM		; A5 <-- cration du smaphore d'exclusion
	JUMP,NE	 R8^EXIT$
	MOVE.32	A5,{A6}+OPSEX

	MOVE.32	#1,D4
	NTREL	?CRESEM		; A5 <-- cration du smaphore d'exclusion
	JUMP,NE	 R8^EXIT$
	MOVE.32	A5,{A6}+OPSEL

	MOVE.16	#ADFREQ/2,D1	; D1 <-- frquence
	CALL	INITFREQ	; change la frquence

	MOVE.16	#WAITSTOP,{A6}+ODCNT ; faut pas stopper tout de suite !

	MOVE.32	#R16^INT256HZ,A1
	MOVE.32	_INDSHI,A4
	CALL	{A4}+_INITINT256HZ

	CLR.16	D7		; D7 <-- ok
EXIT$:
	POPM.32	D1|D4|A1|A4|A5
	TEST.16	D7		; retour EQ/NE
	RET


;--------\\
; S0OPEN  >
;========/

; Ouverture d'un son.

; in	A6.32	^variables globales
; out	D7.16	erreur
; mod	D7.16

S0OPEN:
	MOVE.16	#LADH,{A6}+OLRSTH	; il faudra lire un en-tte
	CLR.16	D7			; retour EQ
	RET



;--------\\
; S0WRITE >
;========/

; Ecrit un son.

; in	A6.32	^variables globales
;	A4.32	^data
;	D5.32	lg data
; out	D7.16	erreur
; mod	D7.16

S0WRITE:
	PUSHM.32 D0..D6|A1..A4

	TEST.8	{A6}+OLEVEL	; niveau zro ?
	JUMP,EQ OK$		; oui => OK$ (silence total)

	SET.8	{A6}+OSTART	; ordre d'enclencher l'interruption
	SET.8	ADRZNMI		; enable NMI
BEGIN$:
	TEST.32	D5		; reste qq chose  crire ?
	JUMP,EQ OK$		; non => OK$

	CALL	DATALOCK

	CLR.32	{A6}+OPSEM
	COMP.32	#-2,D5		; mode asynchrone ?
	JUMP,NE	 R8^SYNC$	; non => SYNC$

	MOVE.32	{A4}+OASYPSEM,{A6}+OPSEM
		     ^ valeur du symbole indefinie
	MOVE.32	{A4}+OASYLDATA,D5 ; D5 <-- lg data
		     ^ valeur du symbole indefinie
	MOVE.32	{A4}+OASYPDATA,A4 ; A4 <-- ^data
		     ^ valeur du symbole indefinie
SYNC$:
	MOVE.16	{A6}+OLRSTH,D4	; D4 <-- lg en-tte restant  lire
	JUMP,EQ	 R8^DATA$

	MOVE.32	#{A6}+OHEAD,A3	; A3 <-- ^buffer pour en-tte
	MOVE.16	#LADH,D3
	SUB.16	D4,D3
	ADD.A16	D3,A3
HLOOP$:
	MOVE.8	{A4+},{A3+}	; OHEAD <-- un byte
	DEC.32	D5
	DEC.16	D4
	JUMP,EQ	 R8^HEND$
	TEST.32	D5		; encore un byte ?
	JUMP,NE HLOOP$		; oui => HLOOP$

	MOVE.16	D4,{A6}+OLRSTH
	JUMP	OK$

HEND$:
	CLR.16	{A6}+OLRSTH	; en-tte entirement lue

	COMP.8	#ADHTYPE,{A6}+OHEAD+OADHTYP
	JUMP,NE ERROR$
	MOVE.32	{A6}+OHEAD+OADHLG,{A6}+OLRSTB
DATA$:
	MOVE.32	{A6}+OLRSTB,D4	; D4 <-- lg data restant  lire
	JUMP,NE	 R8^DGO$

	MOVE.16	#LADH,{A6}+OLRSTH ; il faudra lire une en-tte

	CALL	DATAUNLOCK
	JUMP	BEGIN$

DGO$:
	TEST.32	D5		; reste qq chose  crire ?
	JUMP,EQ OK$		; non => OK$

	COMP.32	D5,D4
	JUMP,LS	 R8^MIN$
	MOVE.32	D5,D4		; D4 <-- MIN(D4,D5)
MIN$:
	SUB.32	D4,{A6}+OLRSTB	; OLRSTB <-- reste
	SUB.32	D4,D5		; D5 <-- reste

.IF 0
	CALL	LISTWAIT	; A2/A3 <-- ^bloc/^buffer

	MOVE.16	{A6}+OHEAD+OADHFREQ,{A2}+OLBFREQ
	MOVE.32	A4,{A2}+OLBPDAT
	MOVE.32	D4,{A2}+OLBLDAT
	ADD.32	D4,A4		; A4 <-- ^plus loin

	CALL	LISTPUT		; liste <-- bloc et buffer
.ENDIF

	MOVE.32	D4,D3		; D3 <-- lg  crire
	DIV.16	#LBUF/1,D3
	INC.16	D3
	CONV.A16.32 D3		; D3 <-- nb de paquets ncessaires

	MOVE.32	D4,D2
	ADD.32	D3,D2
	DEC.32	D2
	DIV.16	D3,D2
	CONV.A16.32 D2		; D2 <-- lg d'un paquet
F1LOOP$:
	CALL	LISTWAIT	; A2/A3 <-- ^bloc/^buffer
	MOVE.16	{A6}+OHEAD+OADHFREQ,{A2}+OLBFREQ

	COMP.32	D4,D2
	JUMP,LS	 R8^F1MIN$
	MOVE.32	D4,D2
F1MIN$:
	SUB.32	D2,D4		; D4 <-- reste

	MOVE.32	D2,D3
;	SL.32	#0,D3		; D3 <-- *1
	MOVE.32	D3,{A2}+OLBLDAT

	MOVE.32	D2,D3
	DEC.16	D3		; D3 <-- -1  cause NMO
F1XFER$:
	MOVE.8	{A4+},{A3+}
	DJ.16,NMO  D3,F1XFER$

	TEST.32	D4		; dernire tranche ?
	JUMP,EQ	 R8^F1LIST$	; oui => F1LIST$
	CLR.32	{A2}+OLBPSEM	; non => pas de signal !
F1LIST$:
	CALL	LISTPUT		; liste <-- bloc et buffer

	TEST.32	D4		; reste qq chose ?
	JUMP,NE F1LOOP$		; oui => F1LOOP$
	JUMP	DATA$

ERROR$:
	MOVE.16	#ERADFREQ,D7	; D7 <-- frquence incorrecte
	JUMP	R8^EXIT$
OK$:
	CLR.16	D7		; D7 <-- ok
EXIT$:
	POPM.32	D0..D6|A1..A4
	TEST.16	D7		; retour EQ/NE
	RET

;---------\\
; DATALOCK >
;---------/

; Dbut de la zone d'exclusion qui englobe l'en-tte d'un
; son et le data correspondant.

; in	-
; out	-
; mod	D7.W

DATALOCK:
	PUSHM.32 D4|A5

	NTREL	?GTPNUM		; D4 <-- numro du processus

	COMP.16	{A6}+OPNUM,D4	; est-ce le processus en train d'crire ?
	JUMP,EQ	 R8^EXIT$	; oui => EXIT$

	MOVE.32	{A6}+OPSEL,A5
	NTREL	?LOCK		;  stoppe si dj un autre processus ...

	MOVE.16	D4,{A6}+OPNUM	; OPNUM <-- numro du processus dans la zone
EXIT$:
	POPM.32	D4|A5
	RET

;-----------\\
; DATAUNLOCK >
;-----------/

; Fin de la zone d'exclusion qui englobe l'en-tte d'un
; son et le data correspondant.

; in	-
; out	-
; mod	D7.W

DATAUNLOCK:
	PUSH.32	A5

	MOVE.16	#-1,{A6}+OPNUM	; OPNUM <-- y'a plus personne qui crit

	MOVE.32	{A6}+OPSEL,A5
	NTREL	?UNLOCK		; dbloque si y'a quelqu'un qui attend

	POP.32	A5
	RET



;-------\\
; S0READ >
;=======/

; Lecture d'un son.

; in	A6.L	^variables globales
;	A4.32	^buffer
;	D5.32	lg buffer
; out	D5.L	lg lue
;	D7.16	erreur
; mod	D5.L, D7.W

S0READ:
	PUSHM.32 D1..D4|A1..A4

	MOVE.16	#ERADRDLG,D7
	COMP.32	#LADH,D5	; demande moins que l'en-tte ?
	JUMP,LS EXIT$		; oui => EXIT$

	MOVE.32	A4,A3		; A3 <-- ^en-tte
	MOVE.16	#(LADH/2)-1,D4
HCLR$:
	CLR.16	{A4+}		; data <-- efface en-tte
	DJ.16,NMO  D4,HCLR$

	MOVE.32	D5,D4
	SUB.32	#LADH,D4	; D4 <-- lg du data  lire

	MOVE.8	#ADHTYPE,{A4}-LADH+OADHTYP
	MOVE.16	#ADFREQ,{A4}-LADH+OADHFREQ

	MOVE.32	A4,{A6}+ORDPT
	MOVE.32	D4,{A6}+ORDLG
	CLR.32	{A6}+ORDNBR
	MOVE.32	D4,D3

	MOVE.16	#ADNIVZERO,D4
	ADD.16	{A6}+ORDNIV,D4
	MOVE.8	D4,{A6}+ORDNIH

	MOVE.16	#ADNIVZERO,D4
	SUB.16	{A6}+ORDNIV,D4
	MOVE.8	D4,{A6}+ORDNIL

	MOVE.32	{A6}+ORDTIM,{A6}+ORDTIC

	CLR.8	{A6}+ORDTRI	; attend la condition de trig
	CLR.8	{A6}+ORDSTO	; pas encore termin

	SET.8	{A6}+OREC	; enregistrement en cours

	MOVE.16	#ADFREQ,D1	; D1 <-- frquence
	CALL	INITFREQ	; change la frquence

	MOVE.32	#R16^INTNMIR,A1
	CALL	INITINTER	; dpart de l'interruption NMI

	MOVE.16	#1,D4
	NTREL	?DELMS		; attend juste le dbut (~700 bytes lus)

	MOVE.32	{A6}+ORDNBR,D4
	JUMP,EQ	 R8^WAIT$
	COMP.32	#100,D4
	JUMP,LS	 R8^CTEST$
	MOVE.16	#100,D4
CTEST$:
	MOVE.32	#{A3}+LADH,A4	; A4 <-- ^data lu
	DEC.16	D4		; D4 <-- -1  cause NMO
	MOVE.8	#16'FF,D2	; D2 <-- valeur lue si rien n'est connect
CLOOP$:
	COMP.8	{A4+},D2	; interface connect ?
	JUMP,NE	 R8^WAIT$	; oui => WAIT$
	DJ.16,NMO  D4,CLOOP$

	MOVE.16	#ERADRDIN,D7	; D7 <-- interface pas connect
	JUMP	R8^END$

WAIT$:
	MOVE.32	{A6}+ORDNBR,{A3}+OADHLG

	MOVE.16	#1,D4
	NTREL	?DELMS		; attend 20ms ...

	TEST.8	{A6}+ORDSTO	; lecture termine ?
	JUMP,F WAIT$		; non => WAIT$

	MOVE.16	#ERTIMO,D7
	TEST.32	{A6}+ORDTIC	; timeout survenu ?
	JUMP,NS	 R8^END$	; oui => END$

	CLR.16	D7		; D7 <-- ok
END$:
	PUSH.16	D7
	MOVE.32	#0,A1
	CALL	INITINTER	; stoppe l'interruption 35000 Hz
	CLR.8	{A6}+ORUN
	CLR.8	{A6}+OREC

	MOVE.16	#1,D4
	NTREL	?DELMS
	POP.16	D7
EXIT$:
	MOVE.32	{A6}+ORDNBR,{A3}+OADHLG
	CLR.32	{A6}+ORDNBR

	SUB.32	{A6}+ORDLG,D5	; D5 <-- lg effectuvement lue

	POPM.32	D1..D4|A1..A4
	TEST.16	D7		; retour EQ/NE
	RET


;	*************************
;	*                       *
;	*   Interruption NMI    *
;	*                       *
;	*************************

; in	-
; out	-
; mod	-

INTNMIR:
	PUSHM.32 D1|A0|A1

	MOVE.32	SoundPVar,A0	; A0 <-- ^variables globales

	MOVE.8	D1,SM130ADMUBUS+MADSTART ; dbut conversion

	MOVE.32	{A0}+ORDLG,D1	; D1 <-- lg restant  lire
	JUMP,EQ	 R8^STOP$

	TEST.8	{A0}+ORDTRI	; condition de trig remplie ?
	JUMP,T	R8^READ$	; oui => READ$

	MOVE.8	SM130ADMUBUS+MADREAD,D1	; D1 <-- lecture data
	COMP.8	{A0}+ORDNIH,D1
	JUMP,HI	 R8^TRIG$
	COMP.8	{A0}+ORDNIL,D1
	JUMP,LO	 R8^TRIG$

	DEC.32	{A0}+ORDTIC	; dcrmente compteur timeout
	JUMP,NC	 R8^EXIT$
STOP$:
	SET.8	{A0}+ORDSTO	; indique que la lecture est termine
	JUMP	R8^EXIT$

TRIG$:
	SET.8	{A0}+ORDTRI	; indique que la condition de trig est remplie
	JUMP	R8^EXIT$

READ$:
	MOVE.32	{A0}+ORDPT,A1
	MOVE.8	SM130ADMUBUS+MADREAD,{A1+} ; lecture data
	MOVE.32	A1,{A0}+ORDPT

	DEC.32	D1
	MOVE.32	D1,{A0}+ORDLG
	INC.32	{A0}+ORDNBR
EXIT$:
	POPM.32	D1|A0|A1
	MOVE.16	#16'00FF,ADRZNMI; pulse le reset de la bascule NMI
	NOP
	RETSF





;--------\\
; S0CLOSE >
;========/

; Termine le son, attend sa fin et ferme tout.

; in	A6.L	^variables globales
; out	D7.W	erreur
; mod	D7.W

S0CLOSE:
	CLR.16	D7		; D7 <-- ok
	RET




;----------\\
; S0COMMAND >
;==========/

; Excute une liste de commandes.
; Les commandes disponibles sont :
;	"L<niveau.B>"	niveau gnral
;	"RL<bruit.W>"	lecture: niveau du bruit
;	"RT<timeout.L>"	lecture: timeout (ADFREQ=1s)

; in	A6.L	^variables globales
;	A4.32	^table des commandes termine par zro
; out	D7.W	erreur
; mod	D7.W

S0COMMAND:
	PUSHM.32 A4

	CLR.16	D7		; D7 <-- ok
LOOP$:
	TEST.8	{A4}		; fin de la table ?
	JUMP,EQ	 R8^EXIT$	; oui => EXIT$

	CALL	WRONEC		; excute une commande
	JUMP,EQ LOOP$
EXIT$:
	POPM.32	A4
	TEST.16	D7		; retour EQ/NE
	RET

;--------\\
; WRONEC  >
;========/

; Excute une commande.

; in	A4.L	^commande
; out	A4.L	^commande suivante
;	D7.16	erreur
; mod	D7.W, A4.L

WRONEC:
	PUSHM.32 D4

	MOVE.8	{A4+},D4	; D4 <-- commande
	COMP.8	#"L",D4
	JUMP,EQ	 R8^LEVEL$
	COMP.8	#"R",D4
	JUMP,EQ	 R8^READ$
ERROR$:
	MOVE.16	#ERADILCO,D7	; D7 <-- commande illgale
	JUMP	R8^EXIT$

LEVEL$:
	MOVE.8	{A4+},{A6}+OLEVEL ; D4 <-- volume (0..255)
	JUMP	R8^OK$

READ$:
	MOVE.8	{A4+},D4	; D4 <-- sous-commande
	COMP.8	#"L",D4
	JUMP,EQ	 R8^RL$
	COMP.8	#"T",D4
	JUMP,EQ	 R8^RT$
	JUMP	ERROR$

RL$:				; "RL" (read-level)
	MOVE.16	{A4+},{A6}+ORDNIV
	JUMP	R8^OK$

RT$:				; "RT" (read-timeout)
	MOVE.32	{A4+},{A6}+ORDTIM
;	JUMP	R8^OK$

OK$:
	CLR.16	D7		; D7 <-- ok
EXIT$:
	POPM.32	D4
	TEST.16	D7		; retour EQ/NE
	RET



;--------\\
; S0KILL  >
;========/

; Libration du pilote.

; in	A6.L	^variables globales
; out	D7.W	erreur
; mod	D7.W, A6.L

S0KILL:
	PUSHM.32 A1|A4|A5

	MOVE.32	#0,A1
	CALL	INITINTER	; stoppe l'interruption 35000 Hz
	CLR.8	{A6}+ORUN

;	MOVE.32	#0,A1
	MOVE.32	_INDSHI,A4	; stoppe l'interruption 256 Hz
	CALL	{A4}+_INITINT256HZ

	MOVE.32	{A6}+OPSEX,A5
	NTREL	?KILLSEM	; dtruit le smaphore d'exclusion

	MOVE.32	{A6}+OPSEL,A5
	NTREL	?KILLSEM	; dtruit le smaphore d'exclusion

	POPM.32	A1|A4|A5
	CLR.16	D7		; retour EQ
	RET






;	*************************
;	*                       *
;	*  Interruption 256 Hz  *
;	*                       *
;	*************************

; in	A0.L	^variables globales
; out	-
; mod	D0.L, D1.L, A0.L, A1.L

INT256HZ:
	PUSHM.32 D7|A2|A5|A6

	MOVE.32	A0,A6		; A6 <-- ^variables

	TEST.8	{A6}+OREC	; enregistrement en cours ?
	JUMP,T	R8^SEMA$	; oui => SEMA$

	MOVE.32	SoundPList,D1
	JUMP,EQ	 R8^SEMA$
	MOVE.32	D1,A2		; A2 <-- ^bloc de tte

	MOVE.16	{A2}+OLBFREQ,D1	; D1 <-- frquence
	COMP.16	{A6}+OFREQ,D1	; changement de la frquence ?
	JUMP,EQ	 R8^SEMA$	; non => SEMA$
	CALL	INITFREQ	; change la frquence
SEMA$:
	TEST.32	SoundPSem	; faut-il faire un SIGNAL ?
	JUMP,EQ	 R8^NSEMA$	; non => NSEMA$

	MOVE.32	SoundPSem,A5	; A5 <-- ^smaphore
	CLR.32	SoundPSem	; devrait tre indivisible avec l'instruction prcdente !!!
	NTREL	?SIGNEV		; signal si mode synchrone
NSEMA$:
	TEST.8	{A6}+OSTART	; ordre d'enclencher l'interruption ?
	JUMP,T	R8^START$	; oui => START$

	TEST.32	SoundLData	; encore du data dans le bloc courant ?
	JUMP,NE	 R8^DATA$	; oui => DATA$
	TEST.32	SoundPList	; encore un bloc dans la liste ?
	JUMP,NE	 R8^DATA$	; oui => DATA$

	TEST.16	{A6}+ODCNT
	JUMP,EQ	 R8^STOP$
	DEC.16	{A6}+ODCNT
	JUMP	R8^END$
STOP$:
	TEST.8	{A6}+ORUN	; dj stopp ?
	JUMP,F	R8^DATA$	; oui => DATA$

	SUB.32	A1,A1
	CALL	INITINTER	; fin de l'interruption 35000 Hz
	CLR.8	{A6}+ORUN
	JUMP	R8^DATA$

START$:
	CLR.8	{A6}+OSTART
	TEST.8	{A6}+ORUN	; dj en fonction ?
	JUMP,T	R8^DATA$	; oui => DATA$

	MOVE.32	#R16^INTNMI,A1
	CALL	INITINTER	; dpart de l'interruption NMI
	SET.8	{A6}+ORUN
DATA$:
	MOVE.16	#WAITSTOP,{A6}+ODCNT ; faut pas stopper tout de suite !
END$:
	POPM.32	D7|A2|A5|A6
	RET



;	*************************
;	*                       *
;	*   Interruption NMI    *
;	*                       *
;	*************************

; in	-
; out	-
; mod	-

INTNMI:
	TEST.32	SoundLData		; encore du data dans le bloc courant ?
	JUMP,NE	 R8^WRITE$		; oui => WRITE$

	TEST.32	SoundPList		; encore un bloc dans la liste ?
	JUMP,EQ	 R8^EXIT$		; non => EXIT$
					; oui =>
	PUSH.32	A1
	MOVE.32	SoundPList,A1		; A1 <-- ^bloc de tte
	MOVE.32	{A1}+OLBLDAT,SoundLData	; SoundLData <-- longueur du data
	MOVE.32	{A1}+OLBPDAT,SoundPData	; SoundPData <-- ^data
	POP.32	A1
WRITE$:
;	MOVE.8	(SoundPData),ADSON	; convertisseur D/A <-- un byte
	.16	16'13F0,16'01F1		; instruction du 68030 !
	.32	SoundPData,ADSON
	INC.32	SoundPData		; SoundPData <-- avance ^data

	DEC.32	SoundLData		; SoundLData <-- diminue lg data
	JUMP,NE	 R8^EXIT$

	PUSH.32	A1
	MOVE.32	SoundPList,A1		; A1 <-- ^bloc de tte (termin)
	TEST.32	{A1}+OLBPSEM		; y a-t-il un smaphore ?
	JUMP,EQ	 R8^PREV$		; non => PREV$
	MOVE.32	{A1}+OLBPSEM,SoundPSem	; SoundPSem <-- ^smaphore pour SIGNAL
PREV$:
	MOVE.32	{A1}+OLBPREV,SoundPList	; SoundPList <-- ^bloc de tte prcdent/nil
	CLR.8	{A1}+OLBFREE		; libre le buffer
	POP.32	A1
EXIT$:
	MOVE.16	#16'00FF,ADRZNMI	; pulse le reset de la bascule NMI
	NOP
	RETSF

DISAB$:
	MOVE.8	#16'00,ADRZNMI		; disable NMI
	NOP
	RETSF






; Routines de bas niveau
; ----------------------



;----------\\
; INITINTER >
;==========/

; Initialise l'adresse de la routine d'interruption.

; in	A1.L	^routine d'interruption
;	A6.32	^variables (rendues dans A0  la routine)
; out	-
; mod	D7.W

INITINTER:
	PUSH.32	A4

	CLR.8	ADRZNMI		; disable NMI

	MOVE.32	_INDSHI,A4
	CALL	{A4}+_INITINTSON

	SET.8	ADRZNMI		; enable NMI

	POP.32	A4
	RET


;---------\\
; INITFREQ >
;=========/

; Spcifie la frquence d'chantillonage.

; in	D1.W	frquence
; out	-
; mod	D7.W

INITFREQ:
	PUSHM.32 D4|A4

	MOVE.16	D1,{A6}+OFREQ	; OFREQ <-- dernire frquence spcifie

	MOVE.32	#2000000,D4
	DIV.16	D1,D4		; D4 <-- priode [0.5us]

	MOVE.32	_INDSHI,A4
	CALL	{A4}+_SETFREQSON

	POPM.32	D4|A4
	RET

;-----------\\
; INITVOLUME >
;===========/

; Met le niveau gnral (0..3).

; in	D4.8	niveau (0..255)
; out	-
; mod	D7.16

INITVOLUME:
	MOVE.8	D4,{A6}+OLEVEL

	COMP.8	#64*1,D4
	JUMP,HS	R8^V1$
	MOVE.8	#BITOFF,ADMODESONFORT
	MOVE.8	#BITOFF,ADMODESONMOYEN
	JUMP	R8^EXIT$

V1$:
	COMP.8	#64*2,D4
	JUMP,HS	R8^V2$
	MOVE.8	#BITOFF,ADMODESONFORT
	MOVE.8	#BITON,ADMODESONMOYEN
	JUMP	R8^EXIT$

V2$:
	COMP.8	#64*3,D4
	JUMP,HS	R8^V3$
	MOVE.8	#BITON,ADMODESONFORT
	MOVE.8	#BITOFF,ADMODESONMOYEN
	JUMP	R8^EXIT$

V3$:
;	COMP.8	#64*4,D4
;	JUMP,HS	R8^EXIT$
	MOVE.8	#BITON,ADMODESONFORT
	MOVE.8	#BITON,ADMODESONMOYEN
;	JUMP	R8^EXIT$

EXIT$:
	RET





; Gestion de la liste
; -------------------


;---------\\
; LISTWAIT >
;=========/

; Cherche un bloc et un buffer libre. Attend s'il n'y en a plus !

; in	-
; out	A2.L	^bloc OLB*
;	A3.32	^buffer
; mod	D7.W, A2.L, A3.L

LISTWAIT:
	PUSHM.32 D4|A5

	MOVE.32	{A6}+OPSEX,A5
	NTREL	?LOCK
RETRY$:
	MOVE.32	#{A6}+OBUF,A2	; A2 <-- ^premier
	MOVE.16	#MAXBUF-1,D4
LOOP$:
	TEST.8	{A2}+OLBFREE	; buffer libre ?
	JUMP,EQ	 R8^TAKE$	; oui => TAKE$

	MOVE.32	#{A2}+(LLB+LBUF),A2 ; A2 <-- ^suivant
	DJ.16,NMO  D4,LOOP$

	MOVE.16	#WAITBUF,D4
	NTREL	?DELMS		; attend la libration d'un buffer ...

	TEST.8	{A6}+ORUN	; dj en fonction ?
	JUMP,T RETRY$		; oui => RETRY$

	PUSH.32	A1
	MOVE.32	#R16^INTNMI,A1
	CALL	INITINTER	; dpart de l'interruption NMI
	POP.32	A1
	SET.8	{A6}+ORUN
	JUMP	RETRY$

TAKE$:
	MOVE.32	#{A2}+LLB,A3	; A3 <-- ^buffer pour le data
	MOVE.32	A3,{A2}+OLBPDAT

	SET.8	{A2}+OLBFREE	; signal que le buffer est occup

	MOVE.32	{A6}+OPSEX,A5
	NTREL	?UNLOCK

	POPM.32	D4|A5
	RET

; (*)	Il peut arriver que le smaky soit tellement occup (par exemple
;	pendant une commutation de fentre) que le processus fils stoppe
;	l'interruption !


;--------\\
; LISTPUT >
;========/

; Ajoute un bloc  la fin de la liste.

; in	A2.L	^bloc OLB*
; out	-
; mod	D7.W

LISTPUT:
	PUSHM.32 D3|A3|A5

	MOVE.32	{A6}+OPSEX,A5
	NTREL	?LOCK

	CLR.32	{A2}+OLBPREV	; ce sera le dernier bloc de la liste
	MOVE.32	{A6}+OPSEM,{A2}+OLBPSEM

	MOVE.32	SoundPList,D3	; liste entirement vide ?
	JUMP,NE	 R8^ADD$	; non => ADD$

	MOVE.32	A2,SoundPList	; liste <-- premier (et seul) bloc
	JUMP	R8^EXIT$

ADD$:
	MOVE.32	D3,A3		; A3 <-- ^bloc de tte
LOOP$:
	MOVE.32	{A3}+OLBPREV,D3	; y a-t-il un bloc prcdent ?
	JUMP,EQ	 R8^LAST$	; non => LAST$

	MOVE.32	D3,A3		; A3 <-- ^bloc prcdent
	JUMP	LOOP$

LAST$:
	MOVE.32	A2,{A3}+OLBPREV	; dernier bloc <-- ^nouveau bloc
EXIT$:
	MOVE.32	{A6}+OPSEX,A5
	NTREL	?UNLOCK

	POPM.32	D3|A3|A5
	RET






	.END

