	.TITLE	300_AUDIO.ASD

;	--------------------------------------
;		(C) 1990 - Daniel Roux
;	--------------------------------------

;	Source du pilote 300_AUDIO.DRIV


	.PROC	M68000

	.REF	SMAKY
	.REF	BIOSDRIV
	.REF	AUDIO
	.REF	ASYNC

	.BASE	10'10
	.LAYOUT HEX



;	Date		Amliorations
; --------------------------------------------------------------------------
; 0.7	26.01.93	
; 0.6	13.01.93	mode asynchrone entirement repens !
; 0.5	07.04.92	mode asynchrone (A4 ^bloc ASY si D5=-2)
; 0.4	03.07.91	lecture avec l'interface DIGISON ...
; 0.3	27.06.91	compatible avec OADHFREQ = 22 KHz
; 0.2	09.11.90	correction bug
; 0.1	01.11.90	premire version


; Assemblage conditionnel
; -----------------------

FILS	=	1		; 1 => processus fils pour stopper l'interruption


MAJREV	=	0		; rvision
MINREV	=	7		; version

	.REV	MAJREV,MINREV



; Constantes
; ----------

MACFREQ	=	22000		; 22 KHz (*)

; (*)	A cette frquence, la longueur d'un son ne peut pas
;	dpasser 2^16*5 = 327k, c'est--dire 14.8s !

;	Pour convertir de 22KHz --> 35KHz, on utilise un rapport
;	de 5/8, soit une erreur de 0.6%.


MAXBUF	=	5		; nb de buffers tampons
LBUF	=	2000		; lg buffer tampon [2000 => 57ms]

WAITBUF	=	2		; attente pour librer un buffer LBUF [2*20ms = 40ms]
WAITSTOP=	5		; attente pour stopper l'interruption [5*20ms = 100ms]


_INITINTSON =	16'24
_INITINTHRETRAC	 = 16'28
VIDEOSOUND =	16'2001014
ADSON	=	16'1003C00
ADMODESONFORT=	16'1000C18
ADMODESONMOY=	16'1000C10




; Interface pour l'acquisition
; ----------------------------

SM300ADMUBUS =	16'01000000

MADSTART =	16'08		; dbut conversion
MADREAD	=	16'08		; lecture data



; Dfinition d'un bloc de list
; ----------------------------

	.LOC	0
OLBFREE:.BLK.8	1		; 1 -> bloc occup
	.BLK.8	1		; rserve
OLBPREV:.BLK.8	4		; ^bloc prcdent
OLBPSEM:.BLK.8	4		; ^smaphore
OLBPDAT:.BLK.8	4		; ^data
OLBLDAT:.BLK.8	4		; longueur du data
LLB:


;			|-------|
;	     SoundPList	|   x-----------------------|
;			|-------|		    |
;						    |
;	|-------|	|-------|	|-------|   |
;	|   0	|<----------x	|<----------x	|<--|
;	|-------|	|-------|	|-------|
;	|  lg	|	|  lg	|	|  lg	|
;	|-------|	|-------|	|-------|
;	|   x-------|	|   x-------|	|   x-------|
;	|-------|   |	|-------|   |	|-------|   |
;		    |		    |		    |
;	|-------|   |	|-------|   |	|-------|   |
;	|	|<--|	|	|<--|	|	|<--|
;	| data	|	| data	|	| data	|<------ SoundPData
;	|	|	|	|	|	|
;	|-------|	|-------|	|-------|
;
;	   blocs en attente ...		bloc en cours
;					d'audition par
;					la routine 35 KHz



; Variables absolues
; ------------------

	.LOC	16'1000-(4*10)
SoundPList:	.BLK.8	4	; ^bloc courant de la liste (tte)
SoundPData:	.BLK.8	4	; ^data
SoundLData:	.BLK.8	4	; lg data restante
SoundPSem:	.BLK.8	4	; ^smaphore


; Variables
; ---------

	.LOC	0
OPBUF:	.BLK.8	4		; pointeur d'criture
OLEVEL:	.BLK.8	1		; niveau (0..255)
ONPLAY:	.BLK.8	1		; nb de sons en cours
	.EVEN
ORDNIV:	.BLK.8	2		; read: niveau  atteindre avant dpart
ORDTIM:	.BLK.8	4		; read: timeout
ORDPT:	.BLK.8	4		; read: ^buffer
ORDLG:	.BLK.8	4		; read: lg  lire
ORDNBR:	.BLK.8	4		; read: nb de bytes lus
ORDTIC:	.BLK.8	4		; read: dcompteur timeout
ORDNIH:	.BLK.8	1		; read: niveau haut
ORDNIL:	.BLK.8	1		; read: niveau bas
ORDTRI:	.BLK.8	1		; read: flag trigger
ORDSTO:	.BLK.8	1		; read: stoppe la lecture
	.EVEN
OLRSTH:	.BLK.8	2		; lg restant  lire pour l'en-tte
OLRSTB:	.BLK.8	4		; lg restant  lire pour le buffer
OHEAD:	.BLK.8	LADH		; buffer pour en-tte
OSTART:	.BLK.8	1		; 1 => dbute l'interruption
OREC:	.BLK.8	1		; 1 => enregistrement en cours
ORUN:	.BLK.8	1		; 0 => stopp, 1 => enclench
OABORT:	.BLK.8	1		; 1 => abort le fils
	.EVEN
OLDATA:	.BLK.8	2		; dernier data utilis
OPNUM:	.BLK.8	2		; numro du processus qui crit
OPSEX:	.BLK.8	4		; ^smaphore d'exclusion
OPSEL:	.BLK.8	4		; ^smaphore d'exclusion
OPSEM:	.BLK.8	4		; ^smaphore
OBUF:	.BLK.8	MAXBUF*(LLB+LBUF) ; blocs OLB* et buffers

LGVAR:






	.LOC	0
DEBUT:
	.16	0,S0BASE
	.16	2**7


; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $AUDIO_0		No H'4F
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

S0ID:
	.16	S0OPEN-S0BASE
	.16	S0COMMAND-S0BASE
	.16	S0RSTATUS-S0BASE
	.16	S0READ-S0BASE
	.16	S0WRITE-S0BASE
	.16	S0CLOSE-S0BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; S0AUX1-S0BASE
	.16	-1			; S0AUX2-S0BASE
	.16	S0RESET-S0BASE
	.16	S0KILL-S0BASE
	.16	-1			; S0STRT-S0BASE
	.16	-1			; S0TSTRT-S0BASE
	.16	-1			; S0START-S0BASE

S0NAB:	.ASCII	"AUDIO_0"		; nom driver
S0NAF:	.FILL.8	LGDNAM-(S0NAF-S0NAB),0

	.8	16'4F			; numro driver
	.8	TYPIO			; type streamer

	.8	MAJREV,MINREV		; rvision - version
	.8	0			; priorit
	.8	0			; rserve
	.8	0			; attribut 1
;;?	.B	2^BDWROK!2^BDRDOK!2^BDNORT ; attribut 0
	.8	2**BDWROK.OR.2**BDRDOK	; attribut 0

	.FILL.8	LGDDESC-(APC-S0ID),0	; le reste
S0BASE:





;--------\\
; S0RESET >
;========/

; Initialisation du pilote.

; in	-
; out	A6.L	^variables globales
;	D7.16	erreur
; mod	D7.W, A6.L

S0RESET:
	PUSHM.32 D4|D5|A1|A3..A5

	MOVE.32	#R16^DEBUT,A4
	MOVE.32	#LGVAR,D4
	FOS	?GETCOMMEM
	JUMP,NE	 R8^EXIT$
	GESMEM	?CLEARMEM
	MOVE.32	A4,A6		; A6 <-- ^variables globales

;	CLR.8	{A6}+ONPLAY	; dbut
	MOVE.8	#128,{A6}+OLEVEL

	CLR.32	SoundPList	; la liste est vide
	CLR.32	SoundLData	; y'a pas de data  crire
	CLR.32	SoundPSem	; y'a pas de smaphore

	MOVE.16	#-1,{A6}+OPNUM	; aucun processus n'crit

	MOVE.16	#1,D4
	NTREL	?CRESEM		; A5 <-- cration du smaphore d'exclusion
	JUMP,NE	 R8^EXIT$
	MOVE.32	A5,{A6}+OPSEX

	MOVE.16	#1,D4
	NTREL	?CRESEM		; A5 <-- cration du smaphore d'exclusion
	JUMP,NE	 R8^EXIT$
	MOVE.32	A5,{A6}+OPSEL

	CLR.8	{A6}+OABORT
	MOVE.32	#R16^PROCFILS,A5
	MOVE.32	#R16^NAMEFILS,A3
	MOVE.16	#3.OR.2**BTDRIV,D4; D4 <-- priorit
	MOVE.32	#100,D5		; D5 <-- lg stack
	NTREL	?CRETASK	; cre le processus fils
	.IF	~FILS
	MOVE.32	#R16^INT35KHZ,A1
	CALL	RDINIINT	; dpart de l'interruption 35000 Hz
	.START IF
	.END
EXIT$:
	POPM.32	D4|D5|A1|A3..A5
	TEST.16	D7		; retour EQ/NE
	RET


;	*********************************
;	*				*
;	*	 PROCESSUS FILS 	*
;	*				*
;	*********************************

NAMEFILS:
	.ASCIZ	"AUDIO_CONTROL"
	.EVEN

PROCFILS:
	MOVE.16	#WAITSTOP,D3	; D3 <-- faut pas stopper tout de suite !
LOOP$:
	TEST.8	{A6}+OABORT	; est-ce la fin ?
	JUMP,T ABORT$

	TEST.32	SoundPSem	; faut-il faire un SIGNAL ?
	JUMP,EQ	 R8^NSEMA$	; non => NSEMA$

	MOVE.32	SoundPSem,A5	; A5 <-- ^smaphore
	CLR.32	SoundPSem	; devrait tre indivisible avec l'instruction prcdente !!!
	NTREL	?SIGNEV		; signal si mode synchrone
NSEMA$:
	TEST.8	{A6}+OSTART	; ordre d'enclencher l'interruption ?
	JUMP,T	R8^START$	; oui => START$

	TEST.32	SoundLData	; encore du data dans le bloc courant ?
	JUMP,NE	 R8^DATA$	; oui => DATA$
	TEST.32	SoundPList	; encore un bloc dans la liste ?
	JUMP,NE	 R8^DATA$	; oui => DATA$

	TEST.16	D3
	JUMP,EQ	 R8^STOP$
	DEC.16	D3
	JUMP	R8^WAIT$
STOP$:
	.IF	FILS
	TEST.8	{A6}+ORUN	; dj stopp ?
	JUMP,F	R8^DATA$	; oui => DATA$

	MOVE.32	#0,A1
	CALL	RDINIINT	; fin de l'interruption 35000 Hz
	CLR.8	{A6}+ORUN
	JUMP	R8^DATA$
	.START IF
	.END

START$:
	.IF	FILS
	CLR.8	{A6}+OSTART
	TEST.8	{A6}+ORUN	; dj en fonction ?
	JUMP,T	R8^DATA$	; oui => DATA$

	MOVE.32	#R16^INT35KHZ,A1
	CALL	RDINIINT	; dpart de l'interruption 35000 Hz
	SET.8	{A6}+ORUN
	.START IF
	.END
DATA$:
	MOVE.16	#WAITSTOP,D3	; D3 <-- faut pas stopper tout de suite !
WAIT$:
	MOVE.16	#1,D4
	NTREL	?DELMS		; attend un poil ...
	JUMP	LOOP$

ABORT$:
	NTREL	?ABORT


;---------\\
; INT35KHZ >
;=========/

; Routine d'interruption 35000 Hz.

; in	A0.L	^variables
; out	-
; mod	-

INT35KHZ:
	TEST.32	SoundLData		; encore du data dans le bloc courant ?
	JUMP,NE	 R8^WRITE$		; oui => WRITE$

	TEST.32	SoundPList		; encore un bloc dans la liste ?
	JUMP,EQ	 R8^EXIT$		; non => EXIT$

	PUSH.32	A1
	MOVE.32	SoundPList,A1		; A1 <-- ^bloc de tte
	MOVE.32	{A1}+OLBLDAT,SoundLData	; SoundLData <-- longueur du data
	MOVE.32	{A1}+OLBPDAT,SoundPData	; SoundPData <-- ^data
	POP.32	A1
WRITE$:
;	MOVE.8	(SoundPData),ADSON	; convertisseur D/A <-- un byte
	.16	16'13F0,16'01F1		; instruction du 68030 !
	.32	SoundPData,ADSON
	INC.32	SoundPData		; SoundPData <-- avance ^data

	DEC.32	SoundLData		; SoundLData <-- diminue lg data
	JUMP,NE	 R8^EXIT$

	PUSH.32	A1
	MOVE.32	SoundPList,A1		; A1 <-- ^bloc de tte (termin)
	TEST.32	{A1}+OLBPSEM		; y a-t-il un smaphore ?
	JUMP,EQ	 R8^PREV$		; non => PREV$
	MOVE.32	{A1}+OLBPSEM,SoundPSem	; SoundPSem <-- ^smaphore pour SIGNAL
PREV$:
	MOVE.32	{A1}+OLBPREV,SoundPList	; SoundPList <-- ^bloc de tte prcdent/nil
	CLR.8	{A1}+OLBFREE		; libre le buffer
	POP.32	A1
EXIT$:
	RET




;--------\\
; S0OPEN  >
;========/

; Ouverture d'un son.

; in	A6.L	^variables globales
; out	D7.W	erreur
; mod	D7.W

S0OPEN:
	MOVE.16	#LADH,{A6}+OLRSTH ; il faudra lire une en-tte
	CLR.16	D7		; retour EQ
	RET



;-------\\
; S0READ >
;=======/

; Lecture d'un son.

; in	A6.L	^variables globales
;	A4.32	^buffer
;	D5.32	lg buffer
; out	D5.L	lg lue
;	D7.16	erreur
; mod	D5.L, D7.W

S0READ:
	PUSHM.32 D2..D4|A1..A4

	MOVE.16	#ERADRDLG,D7
	COMP.32	#LADH,D5	; demande moins que l'en-tte ?
	JUMP,LS EXIT$		; oui => EXIT$

	MOVE.32	A4,A3		; A3 <-- ^en-tte
	MOVE.16	#(LADH/2)-1,D4
HCLR$:
	CLR.16	{A4+}		; data <-- efface en-tte
	DJ.16,NMO  D4,HCLR$

	MOVE.32	D5,D4
	SUB.32	#LADH,D4	; D4 <-- lg du data  lire

	MOVE.8	#ADHTYPE,{A4}-LADH+OADHTYP
	MOVE.16	#ADFREQ,{A4}-LADH+OADHFREQ

	MOVE.32	A4,{A6}+ORDPT
	MOVE.32	D4,{A6}+ORDLG
	CLR.32	{A6}+ORDNBR
	MOVE.32	D4,D3

	MOVE.16	#ADNIVZERO,D4
	ADD.16	{A6}+ORDNIV,D4
	MOVE.8	D4,{A6}+ORDNIH

	MOVE.16	#ADNIVZERO,D4
	SUB.16	{A6}+ORDNIV,D4
	MOVE.8	D4,{A6}+ORDNIL

	MOVE.32	{A6}+ORDTIM,{A6}+ORDTIC

	CLR.8	{A6}+ORDTRI	; attend la condition de trig
	CLR.8	{A6}+ORDSTO	; pas encore termin

	SET.8	{A6}+OREC
	MOVE.32	#R16^INTRET,A1	; A1 <-- ^routine d'interruption
	CALL	RDINIINT	; dpart de l'interruption

	MOVE.16	#1,D4
	NTREL	?DELMS		; attend juste le dbut (~700 bytes lus)

	MOVE.32	{A6}+ORDNBR,D4
	JUMP,EQ	 R8^WAIT$
	COMP.32	#100,D4
	JUMP,LS	 R8^CTEST$
	MOVE.16	#100,D4
CTEST$:
	MOVE.32	#{A3}+LADH,A4	; A4 <-- ^data lu
	DEC.16	D4		; D4 <-- -1  cause NMO
	MOVE.8	#16'FF,D2	; D2 <-- valeur lue si rien n'est connect
CLOOP$:
	COMP.8	{A4+},D2	; interface connect ?
	JUMP,NE	 R8^WAIT$	; oui => WAIT$
	DJ.16,NMO  D4,CLOOP$

	MOVE.16	#ERADRDIN,D7	; D7 <-- interface pas connect
	JUMP	R8^END$

WAIT$:
	MOVE.32	{A6}+ORDNBR,{A3}+OADHLG

	MOVE.16	#1,D4
	NTREL	?DELMS		; attend 20ms ...

	TEST.8	{A6}+ORDSTO	; lecture termine ?
	JUMP,F WAIT$		; non => WAIT$

	MOVE.16	#ERTIMO,D7
	TEST.32	{A6}+ORDTIC	; timeout survenu ?
	JUMP,NS	 R8^END$	; oui => END$

	CLR.16	D7		; D7 <-- ok
END$:
	PUSH.16	D7
	MOVE.32	#R16^INT35KHZ,A1
	CALL	RDINIINT	; dpart de l'interruption 35000 Hz
	CLR.8	{A6}+OREC

	MOVE.16	#1,D4
	NTREL	?DELMS
	POP.16	D7
EXIT$:
	MOVE.32	{A6}+ORDNBR,{A3}+OADHLG
	CLR.32	{A6}+ORDNBR

	SUB.32	{A6}+ORDLG,D5	; D5 <-- lg effectuvement lue

	POPM.32	D2..D4|A1..A4
	TEST.16	D7		; retour EQ/NE
	RET

;---------\\
; RDINIINT >
;---------/

; Indique la routine d'interruption  excuter 35000 fois par seconde.

; in	A1.L	^routine d'interruption/nil
; out	-
; mod	D7.W, A1.L

RDINIINT:
	PUSH.32	A4

	PUSH.16	SF
	OR.16	#16'2600,SF	; IOF niveau #6

	MOVE.32	_INDSHI,A4
	CALL	{A4}+_INITINTHRETRAC

	POP.16	SF

	POP.32	A4
	RET

;--------\\
; INTRET  >
;========/

; Routine d'interruption excute 35000 fois par seconde.
; Cette routine devra tre super-optimise !

; in	A0.L	^variables globales
; out	-
; mod	-

INTRET:
	PUSHM.32 D1|A1

	MOVE.8	D1,SM300ADMUBUS+MADSTART ; dbut conversion

	MOVE.32	{A0}+ORDLG,D1	; D1 <-- lg restant  lire
	JUMP,EQ	 R8^STOP$

	TEST.8	{A0}+ORDTRI	; condition de trig remplie ?
	JUMP,T	R8^READ$	; oui => READ$

	MOVE.8	SM300ADMUBUS+MADREAD,D1	; D1 <-- lecture data
	COMP.8	{A0}+ORDNIH,D1
	JUMP,HI	 R8^TRIG$
	COMP.8	{A0}+ORDNIL,D1
	JUMP,LO	 R8^TRIG$

	DEC.32	{A0}+ORDTIC	; dcrmente compteur timeout
	JUMP,NC	 R8^EXIT$
STOP$:
	SET.8	{A0}+ORDSTO	; indique que la lecture est termine
	JUMP	R8^EXIT$

TRIG$:
	SET.8	{A0}+ORDTRI	; indique que la condition de trig est remplie
	JUMP	R8^EXIT$

READ$:
	MOVE.32	{A0}+ORDPT,A1
	MOVE.8	SM300ADMUBUS+MADREAD,{A1+} ; lecture data
	MOVE.32	A1,{A0}+ORDPT

	DEC.32	D1
	MOVE.32	D1,{A0}+ORDLG
	INC.32	{A0}+ORDNBR
EXIT$:
	POPM.32	D1|A1
	RET



;--------\\
; S0WRITE >
;========/

; Ecrit un son.

; in	A6.L	^variables globales
;	A4.32	^data/^ASY
;	D5.32	lg data (-2 => PB)
; out	D7.W	erreur
; mod	D7.W

S0WRITE:
	PUSHM.32 D0..D5|A2..A4

	TEST.8	{A6}+OLEVEL	; niveau zro ?
	JUMP,EQ OK$		; oui => OK$ (silence total)

	SET.8	{A6}+OSTART	; ordre d'enclencher l'interruption
BEGIN$:
	TEST.32	D5		; reste qq chose  crire ?
	JUMP,EQ OK$		; non => OK$

	CALL	DATALOCK

	CLR.32	{A6}+OPSEM
	COMP.32	#-2,D5		; mode asynchrone ?
	JUMP,NE	 R8^SYNC$	; non => SYNC$

	MOVE.32	{A4}+OASYPSEM,{A6}+OPSEM
	MOVE.32	{A4}+OASYLDATA,D5 ; D5 <-- lg data
	MOVE.32	{A4}+OASYPDATA,A4 ; A4 <-- ^data
SYNC$:
	MOVE.16	{A6}+OLRSTH,D4	; D4 <-- lg en-tte restant  lire
	JUMP,EQ	 R8^DATA$

	MOVE.32	#{A6}+OHEAD,A3	; A3 <-- ^buffer pour en-tte
	MOVE.16	#LADH,D3
	SUB.16	D4,D3
	ADD.A16	D3,A3
HLOOP$:
	MOVE.8	{A4+},{A3+}	; OHEAD <-- un byte
	DEC.32	D5
	DEC.16	D4
	JUMP,EQ	 R8^HEND$
	TEST.32	D5		; encore un byte ?
	JUMP,NE HLOOP$		; oui => HLOOP$

	MOVE.16	D4,{A6}+OLRSTH
	JUMP	OK$

HEND$:
	CLR.16	{A6}+OLRSTH	; en-tte entirement lue

	COMP.8	#ADHTYPE,{A6}+OHEAD+OADHTYP
	JUMP,NE	 R8^ERROR$
	MOVE.32	{A6}+OHEAD+OADHLG,{A6}+OLRSTB
DATA$:
	MOVE.32	{A6}+OLRSTB,D3	; D3 <-- lg data restant  lire
	JUMP,NE	 R8^DGO$

	MOVE.16	#LADH,{A6}+OLRSTH ; il faudra lire une en-tte

	CALL	DATAUNLOCK
	JUMP	BEGIN$

DGO$:
	TEST.32	D5		; reste qq chose  crire ?
	JUMP,EQ OK$		; non => OK$

	MOVE.32	D3,D4
	COMP.32	D5,D4
	JUMP,LS	 R8^MIN$
	MOVE.32	D5,D4		; D4 <-- MIN(D3,D5)
MIN$:
	SUB.32	D4,{A6}+OLRSTB	; OLRSTB <-- reste
	SUB.32	D4,D5		; D5 <-- reste

	MOVE.16	{A6}+OHEAD+OADHFREQ,D1 ; D1 <-- frquence d'chantillonage
	COMP.16	#ADFREQ,D1
	JUMP,EQ	 R8^F1$
	COMP.16	#ADFREQ/2,D1
	JUMP,EQ F2$
	COMP.16	#ADFREQ/4,D1
	JUMP,EQ F4$
	COMP.16	#ADFREQ/8,D1
	JUMP,EQ F8$
	COMP.16	#MACFREQ,D1
	JUMP,EQ FM$
ERROR$:
	MOVE.16	#ERADFREQ,D7	; D7 <-- frquence incorrecte
	JUMP	EXIT$

; Transfert le data avec une frquence de 35000 KHz.

F1$:
.IF 0
; La version qui suit n'est pas possible, car on n'a pas le droit de
; ressortir d'un write tout en ayant encore besoin du buffer !

	CALL	LISTWAIT	; A2/A3 <-- ^bloc/^buffer

	MOVE.32	A4,{A2}+OLBPDAT
	MOVE.32	D4,{A2}+OLBLDAT
	ADD.32	D4,A4		; A4 <-- ^plus loin

	CALL	LISTPUT		; liste <-- bloc et buffer
	JUMP	DATA$
.START IF
.END

	MOVE.32	D4,D3		; D3 <-- lg  crire
	DIV.16	#LBUF/1,D3
	INC.16	D3
	CONV.A16.32 D3		; D3 <-- nb de paquets ncessaires

	MOVE.32	D4,D2
	ADD.32	D3,D2
	DEC.32	D2
	DIV.16	D3,D2
	CONV.A16.32 D2		; D2 <-- lg d'un paquet
F1LOOP$:
	CALL	LISTWAIT	; A2/A3 <-- ^bloc/^buffer

	COMP.32	D4,D2
	JUMP,LS	 R8^F1MIN$
	MOVE.32	D4,D2
F1MIN$:
	SUB.32	D2,D4		; D4 <-- reste

	MOVE.32	D2,D3
;	SL.32	#0,D3		; D3 <-- *1
	MOVE.32	D3,{A2}+OLBLDAT

	MOVE.32	D2,D3
	DEC.16	D3		; D3 <-- -1  cause NMO
F1XFER$:
	MOVE.8	{A4+},{A3+}
	DJ.16,NMO  D3,F1XFER$

	TEST.32	D4		; dernire tranche ?
	JUMP,EQ	 R8^F1LIST$	; oui => F1LIST$
	CLR.32	{A2}+OLBPSEM	; non => pas de signal !
F1LIST$:
	CALL	LISTPUT		; liste <-- bloc et buffer

	TEST.32	D4		; reste qq chose ?
	JUMP,NE F1LOOP$		; oui => F1LOOP$
	JUMP	DATA$

; Transfert le data avec une frquence de 17500 KHz.

F2$:
	MOVE.16	{A6}+OLDATA,D0	; D0 <-- dernier data crit

	MOVE.32	D4,D3		; D3 <-- lg  crire
	DIV.16	#LBUF/2,D3
	INC.16	D3
	CONV.A16.32 D3		; D3 <-- nb de paquets ncessaires

	MOVE.32	D4,D2
	ADD.32	D3,D2
	DEC.32	D2
	DIV.16	D3,D2
	CONV.A16.32 D2		; D2 <-- lg d'un paquet
F2LOOP$:
	CALL	LISTWAIT	; A2/A3 <-- ^bloc/^buffer

	COMP.32	D4,D2
	JUMP,LS	 R8^F2MIN$
	MOVE.32	D4,D2
F2MIN$:
	SUB.32	D2,D4		; D4 <-- reste

	MOVE.32	D2,D3
	SL.32	#1,D3		; D3 <-- *2
	MOVE.32	D3,{A2}+OLBLDAT

	PUSH.32	D2
	MOVE.32	D2,D3
	DEC.16	D3		; D3 <-- -1  cause NMO
F2XFER$:
	CLR.16	D1
	MOVE.8	{A4+},D1

	MOVE.16	D0,D2
	ADD.16	D1,D2
	SR.16	#1,D2		; D2 <-- 0.5
	MOVE.8	D2,{A3+}

	MOVE.8	D1,{A3+}

	MOVE.16	D1,D0		; D0 <-- data prcdent

	DJ.16,NMO  D3,F2XFER$
	POP.32	D2

	TEST.32	D4		; dernire tranche ?
	JUMP,EQ	 R8^F2LIST$	; oui => F2LIST$
	CLR.32	{A2}+OLBPSEM	; non => pas de signal !
F2LIST$:
	CALL	LISTPUT		; liste <-- bloc et buffer

	TEST.32	D4		; reste qq chose ?
	JUMP,NE F2LOOP$		; oui => F2LOOP$

	MOVE.16	D0,{A6}+OLDATA	; OLDATA <-- dernier data crit
	JUMP	DATA$

; Transfert le data avec une frquence de 8750 KHz.

F4$:
	MOVE.16	{A6}+OLDATA,D0	; D0 <-- dernier data crit

	MOVE.32	D4,D3		; D3 <-- lg  crire
	DIV.16	#LBUF/4,D3
	INC.16	D3
	CONV.A16.32 D3		; D3 <-- nb de paquets ncessaires

	MOVE.32	D4,D2
	ADD.32	D3,D2
	DEC.32	D2
	DIV.16	D3,D2
	CONV.A16.32 D2		; D2 <-- lg d'un paquet
F4LOOP$:
	CALL	LISTWAIT	; A2/A3 <-- ^bloc/^buffer

	COMP.32	D4,D2
	JUMP,LS	 R8^F4MIN$
	MOVE.32	D4,D2
F4MIN$:
	SUB.32	D2,D4		; D4 <-- reste

	MOVE.32	D2,D3
	SL.32	#2,D3		; D3 <-- *4
	MOVE.32	D3,{A2}+OLBLDAT

	PUSH.32	D2
	MOVE.32	D2,D3
	DEC.16	D3		; D3 <-- -1  cause NMO
F4XFER$:
	CLR.16	D1
	MOVE.8	{A4+},D1

	MOVE.16	D1,D2
	SUB.16	D0,D2
	ASR.16	#2,D2
	ADD.16	D0,D2		; D2 <-- 0.25
	MOVE.8	D2,{A3+}

	MOVE.16	D0,D2
	ADD.16	D1,D2
	SR.16	#1,D2		; D2 <-- 0.5
	MOVE.8	D2,{A3+}

	MOVE.16	D1,D2
	SUB.16	D0,D2
	MUL.A16	#3,D2
	ASR.16	#2,D2
	ADD.16	D0,D2		; D2 <-- 0.75
	MOVE.8	D2,{A3+}

	MOVE.8	D1,{A3+}

	MOVE.16	D1,D0		; D0 <-- data prcdent

	DJ.16,NMO  D3,F4XFER$
	POP.32	D2

	TEST.32	D4		; dernire tranche ?
	JUMP,EQ	 R8^F4LIST$	; oui => F4LIST$
	CLR.32	{A2}+OLBPSEM	; non => pas de signal !
F4LIST$:
	CALL	LISTPUT		; liste <-- bloc et buffer

	TEST.32	D4		; reste qq chose ?
	JUMP,NE F4LOOP$		; oui => F4LOOP$

	MOVE.16	D0,{A6}+OLDATA	; OLDATA <-- dernier data crit
	JUMP	DATA$

; Transfert le data avec une frquence de 4375 KHz.

F8$:
	MOVE.16	{A6}+OLDATA,D0	; D0 <-- dernier data crit

	MOVE.32	D4,D3		; D3 <-- lg  crire
	DIV.16	#LBUF/8,D3
	INC.16	D3
	CONV.A16.32 D3		; D3 <-- nb de paquets ncessaires

	MOVE.32	D4,D2
	ADD.32	D3,D2
	DEC.32	D2
	DIV.16	D3,D2
	CONV.A16.32 D2		; D2 <-- lg d'un paquet
F8LOOP$:
	CALL	LISTWAIT	; A2/A3 <-- ^bloc/^buffer

	COMP.32	D4,D2
	JUMP,LS	 R8^F8MIN$
	MOVE.32	D4,D2
F8MIN$:
	SUB.32	D2,D4		; D4 <-- reste

	MOVE.32	D2,D3
	SL.32	#3,D3		; D3 <-- *8
	MOVE.32	D3,{A2}+OLBLDAT

	PUSH.32	D2
	MOVE.32	D2,D3
	DEC.16	D3		; D3 <-- -1  cause NMO
F8XFER$:
	CLR.16	D1
	MOVE.8	{A4+},D1

	MOVE.16	D1,D2
	SUB.16	D0,D2
	ASR.16	#3,D2
	ADD.16	D0,D2		; D2 <-- 0.125
	MOVE.8	D2,{A3+}

	MOVE.16	D1,D2
	SUB.16	D0,D2
	ASR.16	#2,D2
	ADD.16	D0,D2		; D2 <-- 0.25
	MOVE.8	D2,{A3+}

	MOVE.16	D1,D2
	SUB.16	D0,D2
	MUL.A16	#3,D2
	ASR.16	#3,D2
	ADD.16	D0,D2		; D2 <-- 0.375
	MOVE.8	D2,{A3+}

	MOVE.16	D0,D2
	ADD.16	D1,D2
	SR.16	#1,D2		; D2 <-- 0.5
	MOVE.8	D2,{A3+}

	MOVE.16	D1,D2
	SUB.16	D0,D2
	MUL.A16	#5,D2
	ASR.16	#3,D2
	ADD.16	D0,D2		; D2 <-- 0.625
	MOVE.8	D2,{A3+}

	MOVE.16	D1,D2
	SUB.16	D0,D2
	MUL.A16	#3,D2
	ASR.16	#2,D2
	ADD.16	D0,D2		; D2 <-- 0.75
	MOVE.8	D2,{A3+}

	MOVE.16	D1,D2
	SUB.16	D0,D2
	MUL.A16	#7,D2
	ASR.16	#3,D2
	ADD.16	D0,D2		; D2 <-- 0.875
	MOVE.8	D2,{A3+}

	MOVE.8	D1,{A3+}

	MOVE.16	D1,D0		; D0 <-- data prcdent

	DJ.16,NMO  D3,F8XFER$
	POP.32	D2

	TEST.32	D4		; dernire tranche ?
	JUMP,EQ	 R8^F8LIST$	; oui => F8LIST$
	CLR.32	{A2}+OLBPSEM	; non => pas de signal !
F8LIST$:
	CALL	LISTPUT		; liste <-- bloc et buffer

	TEST.32	D4		; reste qq chose ?
	JUMP,NE F8LOOP$		; oui => F8LOOP$

	MOVE.16	D0,{A6}+OLDATA	; OLDATA <-- dernier data crit
	JUMP	DATA$

; Transfert le data avec une frquence de 22000 KHz.

FM$:
	CALL	LISTWAIT	; A2/A3 <-- ^bloc/^buffer

	MOVE.32	D4,D3		; D3 <-- lg  crire
	COMP.32	#LBUF*8/5,D3
	JUMP,LS	 R8^FMGO$
	MOVE.32	#LBUF*8/5,D3	; D3 <-- max possible d'un coup
FMGO$:
	SUB.32	D3,D4		; D4 <-- reste

	MOVE.32	D3,D2
	MUL.16	#8,D2		; D2 <-- *8
	DIV.16	#5,D2		; D2 <-- /5
	CONV.A16.32 D2
	MOVE.32	D2,{A2}+OLBLDAT

	DIV.16	#8,D2
	MOVE.32	D2,D1
	SWAP.32	D1		; D1 <-- reste (0,1,3,4,6)

	DEC.16	D2		; D2 <-- -1  cause NMO

	TEST.16	D1		; reste qq chose ?
	JUMP,EQ	 R8^FMXFER$	; non => FMXFER$

	INC.16	D2		; D2 <-- une boucle de plus
	COMP.16	#1,D1
	JUMP,EQ	 R8^FM1$
	COMP.16	#3,D1
	JUMP,EQ	 R8^FM3$
	COMP.16	#4,D1
	JUMP,EQ	 R8^FM4$
	JUMP	 R8^FM6$

FMXFER$:
	MOVE.8	{A4},{A3+}
	MOVE.8	{A4+},{A3+}
FM6$:
	MOVE.8	{A4},{A3+}
	MOVE.8	{A4+},{A3+}
FM4$:
	MOVE.8	{A4+},{A3+}
FM3$:
	MOVE.8	{A4},{A3+}
	MOVE.8	{A4+},{A3+}
FM1$:
	MOVE.8	{A4+},{A3+}

	DJ.16,NMO  D2,FMXFER$

	TEST.32	D4		; dernire tranche ?
	JUMP,EQ	 R8^FMLIST$	; oui => FMLIST$
	CLR.32	{A2}+OLBPSEM	; non => pas de signal !
FMLIST$:
	CALL	LISTPUT		; liste <-- bloc et buffer

	TEST.32	D4		; reste qq chose ?
	JUMP,NE FM$		; oui => FM$
	JUMP	DATA$

OK$:
	CLR.16	D7		; D7 <-- ok
EXIT$:
	POPM.32	D0..D5|A2..A4
	TEST.16	D7		; retour EQ/NE
	RET

;---------\\
; DATALOCK >
;---------/

; Dbut de la zone d'exclusion qui englobe l'en-tte d'un
; son et le data correspondant.

; in	-
; out	-
; mod	D7.W

DATALOCK:
	PUSHM.32 D4|A5

	NTREL	?GTPNUM		; D4 <-- numro du processus

	COMP.16	{A6}+OPNUM,D4	; est-ce le processus en train d'crire ?
	JUMP,EQ	 R8^EXIT$	; oui => EXIT$

	MOVE.32	{A6}+OPSEL,A5
	NTREL	?LOCK		;  stoppe si dj un autre processus ...

	MOVE.16	D4,{A6}+OPNUM	; OPNUM <-- numro du processus dans la zone
EXIT$:
	POPM.32	D4|A5
	RET

;-----------\\
; DATAUNLOCK >
;-----------/

; Fin de la zone d'exclusion qui englobe l'en-tte d'un
; son et le data correspondant.

; in	-
; out	-
; mod	D7.W

DATAUNLOCK:
	PUSH.32	A5

	MOVE.16	#-1,{A6}+OPNUM	; OPNUM <-- y'a plus personne qui crit

	MOVE.32	{A6}+OPSEL,A5
	NTREL	?UNLOCK		; dbloque si y'a quelqu'un qui attend

	POP.32	A5
	RET




;--------\\
; S0CLOSE >
;========/

; Termine le son, attend sa fin et ferme tout.

; in	A6.L	^variables globales
; out	D7.W	erreur
; mod	D7.W

S0CLOSE:
	CLR.16	D7		; D7 <-- ok
	RET




;----------\\
; S0COMMAND >
;==========/

; Excute une liste de commandes.
; Les commandes disponibles sont :
;	"L<niveau.B>"	niveau gnral
;	"RL<bruit.W>"	lecture: niveau du bruit
;	"RT<timeout.L>"	lecture: timeout (ADFREQ=1s)

; in	A6.L	^variables globales
;	A4.32	^table des commandes termine par zro
; out	D7.W	erreur
; mod	D7.W

S0COMMAND:
	PUSHM.32 A4

	CLR.16	D7		; D7 <-- ok
LOOP$:
	TEST.8	{A4}		; fin de la table ?
	JUMP,EQ	 R8^EXIT$	; oui => EXIT$

	CALL	WRONEC		; excute une commande
	JUMP,EQ LOOP$
EXIT$:
	POPM.32	A4
	TEST.16	D7		; retour EQ/NE
	RET

;--------\\
; WRONEC  >
;========/

; Excute une commande.

; in	A4.L	^commande
; out	A4.L	^commande suivante
;	D7.16	erreur
; mod	D7.W, A4.L

WRONEC:
	PUSHM.32 D4

	MOVE.8	{A4+},D4	; D4 <-- commande
	COMP.8	#"L",D4
	JUMP,EQ	 R8^LEVEL$
	COMP.8	#"R",D4
	JUMP,EQ	 R8^READ$
ERROR$:
	MOVE.16	#ERADILCO,D7	; D7 <-- commande illgale
	JUMP	R8^EXIT$

LEVEL$:
	MOVE.8	{A4+},D4	; D4 <-- volume (0..255)
	CALL	COMVOLUME	; choix du volume
	JUMP	R8^OK$

READ$:
	MOVE.8	{A4+},D4	; D4 <-- sous-commande
	COMP.8	#"L",D4
	JUMP,EQ	 R8^RL$
	COMP.8	#"T",D4
	JUMP,EQ	 R8^RT$
	JUMP	ERROR$

RL$:				; "RL" (read-level)
	MOVE.16	{A4+},{A6}+ORDNIV
	JUMP	R8^OK$

RT$:				; "RT" (read-timeout)
	MOVE.32	{A4+},{A6}+ORDTIM
;	JUMP	R8^OK$

OK$:
	CLR.16	D7		; D7 <-- ok
EXIT$:
	POPM.32	D4
	TEST.16	D7		; retour EQ/NE
	RET

;----------\\
; COMVOLUME >
;----------/

; Met le niveau gnral (0..3).

; in	D4.B	niveau (0..255)
; out	-
; mod	D7.W

COMVOLUME:
	MOVE.8	D4,{A6}+OLEVEL

	COMP.8	#64*1,D4
	JUMP,HS	 R8^V1$
	MOVE.8	#0,ADMODESONFORT
	MOVE.8	#0,ADMODESONMOY
	JUMP	R8^EXIT$

V1$:
	COMP.8	#64*2,D4
	JUMP,HS	 R8^V2$
	MOVE.8	#0,ADMODESONFORT
	MOVE.8	#1,ADMODESONMOY
	JUMP	R8^EXIT$

V2$:
	COMP.8	#64*3,D4
	JUMP,HS	 R8^V3$
	MOVE.8	#1,ADMODESONFORT
	MOVE.8	#0,ADMODESONMOY
	JUMP	R8^EXIT$

V3$:
;	COMP.8	#64*4,D4
;	JUMP,HS	 R8^EXIT$
	MOVE.8	#1,ADMODESONFORT
	MOVE.8	#1,ADMODESONMOY
;	JUMP	R8^EXIT$

EXIT$:
	RET




;----------\\
; S0RSTATUS >
;==========/

; Lecture du status.

; in	A6.L	^variables
;	A4.32	^buffer
;	D4.32	longueur buffer
; out	D4.L	longueur rendue effectivement
;	D7.16	erreur
; mod	D4.L, D7.W

S0RSTATUS:
	PUSHM.32 D4|A4

	MOVE.16	#ERIRLG,D7	; D7 <-- longueur illgale
	COMP.32	#4,D4
	JUMP,NE	 R8^EXIT$

	MOVE.32	{A6}+ORDNBR,{A4}

	CLR.16	D7		; D7 <-- ok
EXIT$:
	POPM.32	D4|A4
	TEST.16	D7		; retour EQ/NE
	RET



;--------\\
; S0KILL  >
;========/

; Libration du pilote.

; in	A6.L	^variables globales
; out	D7.W	erreur
; mod	D7.W, A6.L

S0KILL:
	PUSHM.32 D4|A1|A5

	SET.8	{A6}+OABORT
	MOVE.16	#5,D4
	NTREL	?DELMS		; attend la fin du fils ...
	MOVE.32	#0,A1
	CALL	RDINIINT	; stoppe l'interruption

	MOVE.32	{A6}+OPSEX,A5
	NTREL	?KILLSEM	; dtruit le smaphore d'exclusion

	MOVE.32	{A6}+OPSEL,A5
	NTREL	?KILLSEM	; dtruit le smaphore d'exclusion

	POPM.32	D4|A1|A5
	CLR.16	D7		; retour EQ
	RET





; Gestion de la liste
; -------------------


;---------\\
; LISTWAIT >
;=========/

; Cherche un bloc et un buffer libre. Attend s'il n'y en a plus !

; in	-
; out	A2.L	^bloc OLB*
;	A3.32	^buffer
; mod	D7.W, A2.L, A3.L

LISTWAIT:
	PUSHM.32 D4|A5

	MOVE.32	{A6}+OPSEX,A5
	NTREL	?LOCK
RETRY$:
	MOVE.32	#{A6}+OBUF,A2	; A2 <-- ^premier
	MOVE.16	#MAXBUF-1,D4
LOOP$:
	TEST.8	{A2}+OLBFREE	; buffer libre ?
	JUMP,EQ	 R8^TAKE$	; oui => TAKE$

	MOVE.32	#{A2}+(LLB+LBUF),A2 ; A2 <-- ^suivant
	DJ.16,NMO  D4,LOOP$

	MOVE.16	#WAITBUF,D4
	NTREL	?DELMS		; attend la libration d'un buffer ...

	TEST.8	{A6}+ORUN	; dj en fonction ?
	JUMP,T RETRY$		; oui => RETRY$

	PUSH.32	A1
	MOVE.32	#R16^INT35KHZ,A1
	CALL	RDINIINT	; dpart de l'interruption 35000 Hz (*)
	POP.32	A1
	SET.8	{A6}+ORUN
	JUMP	RETRY$

TAKE$:
	MOVE.32	#{A2}+LLB,A3	; A3 <-- ^buffer pour le data
	MOVE.32	A3,{A2}+OLBPDAT

	SET.8	{A2}+OLBFREE	; signal que le buffer est occup

	MOVE.32	{A6}+OPSEX,A5
	NTREL	?UNLOCK

	POPM.32	D4|A5
	RET

; (*)	Il peut arriver que le smaky soit tellement occup (par exemple
;	pendant une commutation de fentre) que le processus fils stoppe
;	l'interruption !


;--------\\
; LISTPUT >
;========/

; Ajoute un bloc  la fin de la liste.

; in	A2.L	^bloc OLB*
; out	-
; mod	D7.W

LISTPUT:
	PUSHM.32 D3|A3|A5

	MOVE.32	{A6}+OPSEX,A5
	NTREL	?LOCK

	CLR.32	{A2}+OLBPREV	; ce sera le dernier bloc de la liste
	MOVE.32	{A6}+OPSEM,{A2}+OLBPSEM

	MOVE.32	SoundPList,D3	; liste entirement vide ?
	JUMP,NE	 R8^ADD$	; non => ADD$

	MOVE.32	A2,SoundPList	; liste <-- premier (et seul) bloc
	JUMP	R8^EXIT$

ADD$:
	MOVE.32	D3,A3		; A3 <-- ^bloc de tte
LOOP$:
	MOVE.32	{A3}+OLBPREV,D3	; y a-t-il un bloc prcdent ?
	JUMP,EQ	 R8^LAST$	; non => LAST$

	MOVE.32	D3,A3		; A3 <-- ^bloc prcdent
	JUMP	LOOP$

LAST$:
	MOVE.32	A2,{A3}+OLBPREV	; dernier bloc <-- ^nouveau bloc
EXIT$:
	MOVE.32	{A6}+OPSEX,A5
	NTREL	?UNLOCK

	POPM.32	D3|A3|A5
	RET






	.END

