\define g_Fond:\nef11;
\define g_ev:\n(bf)09;
; $sma; $flg: 25010002 $erh:BAL

	.TITLE		400_BAL.ASD

;***************************************************************************************************;
;												    ;
;					Pilote Bote aux lettres				    ;
;												    ;
;												    ;
;			(C) Copyright 1986-1988, Ren Beuchat & EPSITEC SA			    ;
;			(C) Copyright 1988-1994, Denis Dumoulin & EPSITEC SA			    ;
;			(C) Copyright 1998-1999, Pierre Arnaud & EPSITEC SA			    ;
;												    ;
;***************************************************************************************************;

; RB 0.0	860603	Dbut du Pilote
; RB 0.1	860715	Modif avec gestion interne mmoire
; RB 0.2	860820	Modif EROUTF lorsque lecture > buffer du message (PAS ENCORE FAIT!!)
; RB 0.3	870910	Si ertime -> longueur message nulle
; RB, DD 1.0	881220	NOUVEAU NTR
; DD 1.1	900329	BAL + PIPE selon paramtres installation
; DD 1.2	900607	correction timout pour PIPE
; DD 1.3	910404	fermeture du PIPE (aprs WRITE) provoque erOUTF (READ)
; DD 1.5	930928	restitution des tranches mmoires en mode PIPE
; DD 1.6	940922	registre A4 plus modifi par WRITE !
; PA 2.0	980313	premire version pour Smaky 400
; PA 2.1	980318	vrification des sources, utilisation du module WIN32 (il faut le charger
;			 la main pour que $BAL puisse l'utiliser -- c'est voulu).
; PZ 2.2	980916	utilisation du module WIN32, changement dans la correspondance
;			des appels.
;					serveur			client
;			RESET		CREATE+PIPECREATE	CREATE
;			KILL		PIPEDISCONNECT+CLOSE	FILECLOSE+CLOSE
;			OPEN		PIPECONNECT		FILEOPEN
;			CLOSE		PIPEDISCONNECT		FILECLOSE
; PA 2.3	980922	augment la constante LGPIPENAME
; PA 2.4	991027	pass  16 drivers $BAL_0  $BAL_15
;			ajout mode serveur avec dconnexion force  l'OPEN ("<<nom")
; PA 2.5	010911	accepte maintenant les mailslots ( la cration, utiliser "<{nom")
; PA 2.6	020122	corrig allocation mmoire (MTYPBD utilisait fausse base driver)
; PA 2.7	020131	corrig NBDRIV faux

NREV	= 2
NVER	= 7

	.PROC		M68000
	.REF		SMAKY
	.REF		MON
	.REF		BIOSDRIV
	.REF		WIN32

	.BASE		10
	.LAYOUT		HEX, LENGTH 0


; Record, entte pour les messages  transmettre
; ----------------------------------------------

		.LOC	0
OLGMESS:	.BLK.32		1	; 1er par message = longueur
LENTETE:

; Offset des variales
; -------------------

NBDRIV		=	16		; nombre de pilotes
LGPIPENAME	=	200		; lg max du nom du pipe, suffisant ?

		.LOC	0

OBAL:		.BLK.32	1		; descripteur de BAL
OBASMEM:	.BLK.32	1		; ^base pour gesmem
ONBUSE:		.BLK.16	1		; nombre d'ouverture du pilote
ONPROC:		.BLK.16	1		; no du processus qui a fait dernier WRITE
OFPIPE:		.BLK.8	1		; TRUE si fonctionne en pipeline
OFNOEOF:	.BLK.8	1		; TRUE si PIPE sans EOF au close
OFLG:		.BLK.8	1		; divers
 bPipeEOF	= 0			; EOF trouv, jusqu'au CLOSE
 bWin32Srv	= 1			; avec Win32 : install en mode serveur
 bWin32ReCon	= 2			; avec Win32 : force la dconnexion avant la connexion
 bWin32MailSlot	= 3			; avec Win32 : c'est en fait un MailSlot
		.EVEN

OWIN32PIPE:	.BLK.32	1		; canal du pipe Win32 (si existe)
OPIPENAME:	.BLK.8	LGPIPENAME	; nom du pipe Win32

OTIMO:		.BLK.16	1		; time-out en mode pipeline
OCOMPT:		.BLK.16	1		; dcompteur pour timo
OTAMPON:	.BLK.32	1		; ^tampon mmoire en lecture
OPTDATA:	.BLK.32	1		; ^prochain data dans tampon
ONBDATA:	.BLK.32	1		; nombre d'octets valable dans le tampon
LGVARS:					; longueur plage des variables

		.REV	NREV,NVER
		.IDENT	"(C) 1986-1998, Ren Beuchat, Denis Dumoulin, Pierre Arnaud & EPSITEC SA"

; Dbut du code du Pilote
; -----------------------

	.LOC	0

BASEDRIV:
	.16	0,D0BASE
	.16	1,D1BASE
	.16	2,D2BASE
	.16	3,D3BASE
	.16	4,D4BASE
	.16	5,D5BASE
	.16	6,D6BASE
	.16	7,D7BASE
	.16	8,D8BASE
	.16	9,D9BASE
	.16	10,D10BASE
	.16	11,D11BASE
	.16	12,D12BASE
	.16	13,D13BASE
	.16	14,D14BASE
	.16	15,D15BASE
	.16	2**7

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_0			No H'B0
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D0ID:
	.16	OPEN-D0BASE		; adresse routines :
	.16	-1			; D0COMMAND-D0BASE
	.16	-1			; D0RSTATUS-D0BASE
	.16	READ-D0BASE
	.16	WRITE-D0BASE
	.16	CLOSE-D0BASE
	.16	STOPTR-D0BASE
	.16	-1			; D0STARTR-D0BASE
	.16	AVOTR-D0BASE
	.16	-1			; D0AUX1-D0BASE
	.16	-1			; D0AUX2-D0BASE
	.16	RESET-D0BASE
	.16	KILL-D0BASE
	.16	-1			; D0STRT-D0BASE
	.16	-1			; D0TSTRT-D0BASE
	.16	-1			; D0START-D0BASE

D0NAB:
	.ASCII	"BAL_0"			; Nom du Pilote
D0NAF:	.FILL.8	LGDNAM-(D0NAF-D0NAB), 0

	.8	16'B0			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D0ID), 0	; le reste
D0BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_1			No H'B1
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D1ID:
	.16	OPEN-D1BASE		; adresse routines :
	.16	-1			; D1COMMAND-D1BASE
	.16	-1			; D1RSTATUS-D1BASE
	.16	READ-D1BASE
	.16	WRITE-D1BASE
	.16	CLOSE-D1BASE
	.16	STOPTR-D1BASE
	.16	-1			; D1STARTR-D1BASE
	.16	AVOTR-D1BASE
	.16	-1			; D1AUX1-D1BASE
	.16	-1			; D1AUX2-D1BASE
	.16	RESET-D1BASE
	.16	KILL-D1BASE
	.16	-1			; D1STRT-D1BASE
	.16	-1			; D1TSTRT-D1BASE
	.16	-1			; D1START-D1BASE

D1NAB:
	.ASCII	"BAL_1"			; Nom du Pilote
D1NAF:	.FILL.8	LGDNAM-(D1NAF-D1NAB), 0

	.8	16'B1			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D1ID), 0	; le reste
D1BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_2			No H'B2
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D2ID:
	.16	OPEN-D2BASE		; adresse routines :
	.16	-1			; D2COMMAND-D2BASE
	.16	-1			; D2RSTATUS-D2BASE
	.16	READ-D2BASE
	.16	WRITE-D2BASE
	.16	CLOSE-D2BASE
	.16	STOPTR-D2BASE
	.16	-1			; D2STARTR-D2BASE
	.16	AVOTR-D2BASE
	.16	-1			; D2AUX1-D2BASE
	.16	-1			; D2AUX2-D2BASE
	.16	RESET-D2BASE
	.16	KILL-D2BASE
	.16	-1			; D2STRT-D2BASE
	.16	-1			; D2TSTRT-D2BASE
	.16	-1			; D2START-D2BASE

D2NAB:
	.ASCII	"BAL_2"			; Nom du Pilote
D2NAF:	.FILL.8	LGDNAM-(D2NAF-D2NAB), 0

	.8	16'B2			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D2ID), 0	; le reste
D2BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_3			No H'B3
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D3ID:
	.16	OPEN-D3BASE		; adresse routines :
	.16	-1			; D3COMMAND-D3BASE
	.16	-1			; D3RSTATUS-D3BASE
	.16	READ-D3BASE
	.16	WRITE-D3BASE
	.16	CLOSE-D3BASE
	.16	STOPTR-D3BASE
	.16	-1			; D3STARTR-D3BASE
	.16	AVOTR-D3BASE
	.16	-1			; D3AUX1-D3BASE
	.16	-1			; D3AUX2-D3BASE
	.16	RESET-D3BASE
	.16	KILL-D3BASE
	.16	-1			; D3STRT-D3BASE
	.16	-1			; D3TSTRT-D3BASE
	.16	-1			; D3START-D3BASE

D3NAB:
	.ASCII	"BAL_3"			; Nom du Pilote
D3NAF:	.FILL.8	LGDNAM-(D3NAF-D3NAB), 0

	.8	16'B3			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D3ID), 0	; le reste
D3BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_4			No H'B4
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D4ID:
	.16	OPEN-D4BASE		; adresse routines :
	.16	-1			; D4COMMAND-D4BASE
	.16	-1			; D4RSTATUS-D4BASE
	.16	READ-D4BASE
	.16	WRITE-D4BASE
	.16	CLOSE-D4BASE
	.16	STOPTR-D4BASE
	.16	-1			; D4STARTR-D4BASE
	.16	AVOTR-D4BASE
	.16	-1			; D4AUX1-D4BASE
	.16	-1			; D4AUX2-D4BASE
	.16	RESET-D4BASE
	.16	KILL-D4BASE
	.16	-1			; D4STRT-D4BASE
	.16	-1			; D4TSTRT-D4BASE
	.16	-1			; D4START-D4BASE

D4NAB:
	.ASCII	"BAL_4"			; Nom du Pilote
D4NAF:	.FILL.8	LGDNAM-(D4NAF-D4NAB), 0

	.8	16'B4			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D4ID), 0 	; le reste
D4BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_5			No H'B5
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D5ID:
	.16	OPEN-D5BASE		; adresse routines :
	.16	-1			; D5COMMAND-D5BASE
	.16	-1			; D5RSTATUS-D5BASE
	.16	READ-D5BASE
	.16	WRITE-D5BASE
	.16	CLOSE-D5BASE
	.16	STOPTR-D5BASE
	.16	-1			; D5STARTR-D5BASE
	.16	AVOTR-D5BASE
	.16	-1			; D5AUX1-D5BASE
	.16	-1			; D5AUX2-D5BASE
	.16	RESET-D5BASE
	.16	KILL-D5BASE
	.16	-1			; D5STRT-D5BASE
	.16	-1			; D5TSTRT-D5BASE
	.16	-1			; D5START-D5BASE

D5NAB:
	.ASCII	"BAL_5"			; Nom du Pilote
D5NAF:	.FILL.8	LGDNAM-(D5NAF-D5NAB), 0

	.8	16'B5			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D5ID), 0	; le reste
D5BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_6			No H'B6
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D6ID:
	.16	OPEN-D6BASE		; adresse routines :
	.16	-1			; D6COMMAND-D6BASE
	.16	-1			; D6RSTATUS-D6BASE
	.16	READ-D6BASE
	.16	WRITE-D6BASE
	.16	CLOSE-D6BASE
	.16	STOPTR-D6BASE
	.16	-1			; D6STARTR-D6BASE
	.16	AVOTR-D6BASE
	.16	-1			; D6AUX1-D6BASE
	.16	-1			; D6AUX2-D6BASE
	.16	RESET-D6BASE
	.16	KILL-D6BASE
	.16	-1			; D6STRT-D6BASE
	.16	-1			; D6TSTRT-D6BASE
	.16	-1			; D6START-D6BASE

D6NAB:
	.ASCII	"BAL_6"			; Nom du Pilote
D6NAF:	.FILL.8	LGDNAM-(D6NAF-D6NAB), 0

	.8	16'B6			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D6ID), 0	; le reste
D6BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_7			No H'B7
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D7ID:
	.16	OPEN-D7BASE		; adresse routines :
	.16	-1			; D7COMMAND-D7BASE
	.16	-1			; D7RSTATUS-D7BASE
	.16	READ-D7BASE
	.16	WRITE-D7BASE
	.16	CLOSE-D7BASE
	.16	STOPTR-D7BASE
	.16	-1			; D7STARTR-D7BASE
	.16	AVOTR-D7BASE
	.16	-1			; D7AUX1-D7BASE
	.16	-1			; D7AUX2-D7BASE
	.16	RESET-D7BASE
	.16	KILL-D7BASE
	.16	-1			; D7STRT-D7BASE
	.16	-1			; D7TSTRT-D7BASE
	.16	-1			; D7START-D7BASE

D7NAB:
	.ASCII	"BAL_7"			; Nom du Pilote
D7NAF:	.FILL.8	LGDNAM-(D7NAF-D7NAB), 0

	.8	16'B7			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D7ID), 0	; le reste
D7BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_8			No H'1B0
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D8ID:
	.16	OPEN-D8BASE		; adresse routines :
	.16	-1			; D8COMMAND-D8BASE
	.16	-1			; D8RSTATUS-D8BASE
	.16	READ-D8BASE
	.16	WRITE-D8BASE
	.16	CLOSE-D8BASE
	.16	STOPTR-D8BASE
	.16	-1			; D8STARTR-D8BASE
	.16	AVOTR-D8BASE
	.16	-1			; D8AUX1-D8BASE
	.16	-1			; D8AUX2-D8BASE
	.16	RESET-D8BASE
	.16	KILL-D8BASE
	.16	-1			; D8STRT-D8BASE
	.16	-1			; D8TSTRT-D8BASE
	.16	-1			; D8START-D8BASE

D8NAB:
	.ASCII	"BAL_8"			; Nom du Pilote
D8NAF:	.FILL.8	LGDNAM-(D8NAF-D8NAB), 0

	.8	16'B0			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	1			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D8ID), 0	; le reste
D8BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_9			No H'1B1
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D9ID:
	.16	OPEN-D9BASE		; adresse routines :
	.16	-1			; D9COMMAND-D9BASE
	.16	-1			; D9RSTATUS-D9BASE
	.16	READ-D9BASE
	.16	WRITE-D9BASE
	.16	CLOSE-D9BASE
	.16	STOPTR-D9BASE
	.16	-1			; D9STARTR-D9BASE
	.16	AVOTR-D9BASE
	.16	-1			; D9AUX1-D9BASE
	.16	-1			; D9AUX2-D9BASE
	.16	RESET-D9BASE
	.16	KILL-D9BASE
	.16	-1			; D9STRT-D9BASE
	.16	-1			; D9TSTRT-D9BASE
	.16	-1			; D9START-D9BASE

D9NAB:
	.ASCII	"BAL_9"			; Nom du Pilote
D9NAF:	.FILL.8	LGDNAM-(D9NAF-D9NAB), 0

	.8	16'B1			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	1			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D9ID), 0	; le reste
D9BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_10			No H'1B2
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D10ID:
	.16	OPEN-D10BASE		; adresse routines :
	.16	-1			; D10COMMAND-D10BASE
	.16	-1			; D10RSTATUS-D10BASE
	.16	READ-D10BASE
	.16	WRITE-D10BASE
	.16	CLOSE-D10BASE
	.16	STOPTR-D10BASE
	.16	-1			; D10STARTR-D10BASE
	.16	AVOTR-D10BASE
	.16	-1			; D10AUX1-D10BASE
	.16	-1			; D10AUX2-D10BASE
	.16	RESET-D10BASE
	.16	KILL-D10BASE
	.16	-1			; D10STRT-D10BASE
	.16	-1			; D10TSTRT-D10BASE
	.16	-1			; D10START-D10BASE

D10NAB:
	.ASCII	"BAL_10"		; Nom du Pilote
D10NAF:	.FILL.8	LGDNAM-(D10NAF-D10NAB), 0

	.8	16'B2			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	1			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D10ID), 0	; le reste
D10BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_11			No H'1B3
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D11ID:
	.16	OPEN-D11BASE		; adresse routines :
	.16	-1			; D11COMMAND-D11BASE
	.16	-1			; D11RSTATUS-D11BASE
	.16	READ-D11BASE
	.16	WRITE-D11BASE
	.16	CLOSE-D11BASE
	.16	STOPTR-D11BASE
	.16	-1			; D11STARTR-D11BASE
	.16	AVOTR-D11BASE
	.16	-1			; D11AUX1-D11BASE
	.16	-1			; D11AUX2-D11BASE
	.16	RESET-D11BASE
	.16	KILL-D11BASE
	.16	-1			; D11STRT-D11BASE
	.16	-1			; D11TSTRT-D11BASE
	.16	-1			; D11START-D11BASE

D11NAB:
	.ASCII	"BAL_11"		; Nom du Pilote
D11NAF:	.FILL.8	LGDNAM-(D11NAF-D11NAB), 0

	.8	16'B3			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	1			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D11ID), 0	; le reste
D11BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_12			No H'1B4
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D12ID:
	.16	OPEN-D12BASE		; adresse routines :
	.16	-1			; D12COMMAND-D12BASE
	.16	-1			; D12RSTATUS-D12BASE
	.16	READ-D12BASE
	.16	WRITE-D12BASE
	.16	CLOSE-D12BASE
	.16	STOPTR-D12BASE
	.16	-1			; D12STARTR-D12BASE
	.16	AVOTR-D12BASE
	.16	-1			; D12AUX1-D12BASE
	.16	-1			; D12AUX2-D12BASE
	.16	RESET-D12BASE
	.16	KILL-D12BASE
	.16	-1			; D12STRT-D12BASE
	.16	-1			; D12TSTRT-D12BASE
	.16	-1			; D12START-D12BASE

D12NAB:
	.ASCII	"BAL_12"		; Nom du Pilote
D12NAF:	.FILL.8	LGDNAM-(D12NAF-D12NAB), 0

	.8	16'B4			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	1			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D12ID), 0 	; le reste
D12BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_13			No H'1B5
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D13ID:
	.16	OPEN-D13BASE		; adresse routines :
	.16	-1			; D13COMMAND-D13BASE
	.16	-1			; D13RSTATUS-D13BASE
	.16	READ-D13BASE
	.16	WRITE-D13BASE
	.16	CLOSE-D13BASE
	.16	STOPTR-D13BASE
	.16	-1			; D13STARTR-D13BASE
	.16	AVOTR-D13BASE
	.16	-1			; D13AUX1-D13BASE
	.16	-1			; D13AUX2-D13BASE
	.16	RESET-D13BASE
	.16	KILL-D13BASE
	.16	-1			; D13STRT-D13BASE
	.16	-1			; D13TSTRT-D13BASE
	.16	-1			; D13START-D13BASE

D13NAB:
	.ASCII	"BAL_13"		; Nom du Pilote
D13NAF:	.FILL.8	LGDNAM-(D13NAF-D13NAB), 0

	.8	16'B5			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	1			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D13ID), 0	; le reste
D13BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_14			No H'1B6
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D14ID:
	.16	OPEN-D14BASE		; adresse routines :
	.16	-1			; D14COMMAND-D14BASE
	.16	-1			; D14RSTATUS-D14BASE
	.16	READ-D14BASE
	.16	WRITE-D14BASE
	.16	CLOSE-D14BASE
	.16	STOPTR-D14BASE
	.16	-1			; D14STARTR-D14BASE
	.16	AVOTR-D14BASE
	.16	-1			; D14AUX1-D14BASE
	.16	-1			; D14AUX2-D14BASE
	.16	RESET-D14BASE
	.16	KILL-D14BASE
	.16	-1			; D14STRT-D14BASE
	.16	-1			; D14TSTRT-D14BASE
	.16	-1			; D14START-D14BASE

D14NAB:
	.ASCII	"BAL_14"		; Nom du Pilote
D14NAF:	.FILL.8	LGDNAM-(D14NAF-D14NAB), 0

	.8	16'B6			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	1			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D14ID), 0	; le reste
D14BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_15			No H'1B7
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D15ID:
	.16	OPEN-D15BASE		; adresse routines :
	.16	-1			; D15COMMAND-D15BASE
	.16	-1			; D15RSTATUS-D15BASE
	.16	READ-D15BASE
	.16	WRITE-D15BASE
	.16	CLOSE-D15BASE
	.16	STOPTR-D15BASE
	.16	-1			; D15STARTR-D15BASE
	.16	AVOTR-D15BASE
	.16	-1			; D15AUX1-D15BASE
	.16	-1			; D15AUX2-D15BASE
	.16	RESET-D15BASE
	.16	KILL-D15BASE
	.16	-1			; D15STRT-D15BASE
	.16	-1			; D15TSTRT-D15BASE
	.16	-1			; D15START-D15BASE

D15NAB:
	.ASCII	"BAL_15"		; Nom du Pilote
D15NAF:	.FILL.8	LGDNAM-(D15NAF-D15NAB), 0

	.8	16'B7			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	1			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D15ID), 0	; le reste
D15BASE:



;-------\\
; RESET  >
;=======/

; in	D3.16	no du sous-pilote install
;	A0.32	^base du sous-pilote
;	A2.32	^paramtres
; out	A6.32	^variables globales
;	D7.16	erreur
; mod	D0..A1, D7.16

RESET:
	PUSHM.32 D4|D5|A2|A3|A4|A5

	MOVE.32	#LGVARS*NBDRIV,D4
	MOVE.32	#R16^BASEDRIV,A4
	FOS	?GetComMem			; variables du pilote
	JUMP,NE	FRESET$

	MOVE.32	A4,A6
	MOVE.16	D3,D4
	MUL.16	#LGVARS,D4
	ADD.32	D4,A6				; ^variables sous-pilote

	MOVE.32	A0,{A6}+OBASMEM			; ^base du driver pour le ?GETMEM / MTYPBD

	CLR.16	{A6}+ONBUSE
	CLR.16	{A6}+ONPROC
	CLR.8	{A6}+OFPIPE
	CLR.8	{A6}+OFNOEOF
	CLR.32	{A6}+ONBDATA
	CLR.32	{A6}+OBAL
	CLR.32	{A6}+OWIN32PIPE
	CLR.8	{A6}+OFLG

	MOVE.8	{A2+},D4			; paramtres installation

	COMP.8	#"<",D4				; serveur (rception) ?
	JUMP,EQ	WSERVER$
	COMP.8	#">",D4				; client (mission) ?
	JUMP,EQ	WCLIENT$

	COMP.8	#"P",D4
	JUMP,EQ	R8^PIPE$
	COMP.8	#"p",D4				; lettre P = PIPE
	JUMP,EQ	R8^PIPE$
	COMP.8	#"X",D4
	JUMP,NE	R8^NOPIPE$
	SET.8	{A6}+OFNOEOF			; lettre X = PIPE ne gnre pas EOF au close

PIPE$:	SET.8	{A6}+OFPIPE
	MOVE.8	{A2+},D4
	SL.16	#8,D4
	MOVE.8	{A2+},D4			; timeout pour EROUTF
	MOVE.16	D4,{A6}+OTIMO
	MOVE.16	D4,{A6}+OCOMPT			; prpare future timeout

NOPIPE$:
	MOVE.32	#-1,D4
	NTREL	?CREBAL
	JUMP,NE	FRESET$

	MOVE.32	A5,{A6}+OBAL
	JUMP	EXIT$

; Serveur : cre le port + le pipe

WSERVER$:
	COMP.8	#"<",{A2}			; serveur avec Disconnect avant Connect ?
	JUMP,NE	R8^WSERVERinit$

	INC.32	A2
	TSET.8	{A6}+OFLG:#bWin32ReCon		; force une dconnexion/connexion  l'OPEN

WSERVERinit$:
	COMP.8	#"{",{A2}			; serveur avec MailSlot ?
	JUMP,NE	R8^WSERVERinit2$

	INC.32	A2
	TSET.8	{A6}+OFLG:#bWin32MailSlot	; prend note du mode MailSlot

WSERVERinit2$:
	CALL	WIN32$				; D5 = canal / A3 = nom
	JUMP,NE	FRESET$

	WIN32_	PIPECREATE
	JUMP,EQ	R8^OKPipeCreate$

	MON	?AFTIM
	.ASCIZE	"WIN32_PIPECREATE D7="
	EX.32	D4,D7
	MON	?AFX4, ?AFCR
	EX.32	D4,D7
	JUMP	FRESET$

OKPipeCreate$:
	TSET.8	{A6}+OFLG:#bWin32Srv		; mmorise mode serveur pour OPEN/CLOSE
	JUMP	EXIT$

WCLIENT$:
	CALL	WIN32$
	JUMP,NE	FRESET$

	MOVE.32	#{A6}+OPIPENAME,A3		; mmorisation du nom
	MOVE.16	#LGPIPENAME-1,D4
L1$:	MOVE.8	{A2+},{A3+}
	DJ.16,NMO D4,L1$
	TCLR.8	{A6}+OFLG:#bWin32Srv

EXIT$:	CLR.16	D7

FRESET$:
	POPM.32	A2|A3|A4|A5|D4|D5
	RET


WIN32$:	MOVE.32	#MTYPBD,D1
	MOVE.32	{A6}+OBASMEM,A1
	WIN32_	CREATE
	JUMP,NE	R8^EXWIN$

	MOVE.32	A2,A3
	MOVE.32	D5,{A6}+OWIN32PIPE
	CLR.16	D7
	RET

EXWIN$:	MON	?AFTIM
	.ASCIZE	"WIN32_CREATE D7="
	EX.32	D4,D7
	MON	?AFX4, ?AFCR
	EX.32	D4,D7
	RET



;------\\
; KILL  >
;======/
;
; in	A6.32	^var sous-pilote
; out	D7.16	erreur
; mod	D0..A1, D7.16


KILL:	MOVE.32	{A6}+OWIN32PIPE,D0
	JUMP,F	R8^KILL$

	EX.32	D0,D5
	TEST.8	{A6}+OFLG:#bWin32Srv
	JUMP,T	R8^KSRV$		; tue une installation en mode serveur
	WIN32_	FILECLOSE		; install en mode client => FILE CLOSE
	JUMP	R8^K2$

KSRV$:	TEST.8	{A6}+OFLG:#bWin32MailSlot
	JUMP,T	R8^K2$
	WIN32_	PIPEDISCONNECT		; install en mode serveur => PIPE DISCONNECT

K2$:	WIN32_	CLOSE
	EX.32	D0,D5
	CLR.16	D7
	RET

KILL$:	PUSH.32	A5
	MOVE.32	{A6}+OBAL,A5
	NTREL	?KILLBAL
	POP.32	A5
	RET


;------\\
; OPEN  >
;======/

; in	A6.32	^var sous-pilote
;	D3.8	mode d'ouverture
; out	-
; mod	-

OPEN:	MOVE.32	{A6}+OWIN32PIPE,D0
	JUMP,F	R8^OPEN$			; pas un pipe win32 => open normal

; OPEN en mode pipe Win32
; si install en serveur, alors PipeConnect, sinon FileOpen (PipeName)
	
	PUSHM.32 A3|D5|D4
	MOVE.32	D0,D5				; canal Win32
	TEST.8	{A6}+OFLG:#bWin32Srv		; install en serveur ?
	JUMP,T	OPSRV$

	MOVE.32	#{A6}+OPIPENAME,A3		; install en mode client
	WIN32_	FILEOPEN			; ==> FILEOPEN
	JUMP	R1$

OPSRV$:	TEST.8	{A6}+OFLG:#bWin32ReCon		; force une dconnexion avant la connexion ?
	JUMP,F	R8^CONN$			; non => connecte
	WIN32_	PIPEDISCONNECT			; oui => commence par dconnecter...

CONN$:	TEST.8	{A6}+OFLG:#bWin32MailSlot	; est-ce un mailslot cach derrire le pipe ?
	JUMP,T	R8^R1$				; oui => pas de connexion ncessaire
	WIN32_	PIPECONNECT			; mode serveur:connexion

R1$:	POPM.32	D4|D5|A3
	TEST.16	D7
	RET


OPEN$:	INC.16	{A6}+ONBUSE
	TSET.32	D3:#BOPWR			; ouvre en criture ?
	JUMP,F	R8^EXIT$			; non => fin
	NTREL	?GTPNUM				; oui => prend note du numro de proc.
	MOVE.16	D4,{A6}+ONPROC

EXIT$:	CLR.16	D7
	RET


;-------\\
; CLOSE  >
;=======/

; in	A6.32	^var sous-pilote
; out	-
; mod	-

CLOSE:
	MOVE.32	{A6}+OWIN32PIPE,D0
	JUMP,F	R8^CLOSE$			; pas un pipe win32 => close normal

; CLOSE en mode pipe Win32
; si install en serveur, alors PipeDisconnect, sinon FileClose
	
	PUSHM.32 A3|D5
	MOVE.32	D0,D5				; canal Win32
	TEST.8	{A6}+OFLG:#bWin32Srv		; install en serveur ?
	JUMP,T	R8^CLSRV$
	WIN32_	FILECLOSE			; ==> fermeture "fichier"
	JUMP	R1$
CLSRV$:	WIN32_	PIPEDISCONNECT			; mode serveur:dconnexion

R1$:	POPM.32	D5|A3
	TEST.16	D7
	RET

CLOSE$:	DEC.16	{A6}+ONBUSE
	TEST.8	{A6}+OFPIPE			; mode pipe ?
	JUMP,F	R8^R$				; non => ne fait rien

	TEST.8	{A6}+OFNOEOF			; ne signale pas EOF  la fermeture ?
	JUMP,T	R8^R$				; oui => ne fait rien

	PUSHM.32 D3|D4|A4|A5
	NTREL	?GTPNUM
	COMP.16	{A6}+ONPROC,D4			; celui qui crivait ?
	JUMP,NE	R8^P$				; non -> rien  faire

	MOVE.32	{A6}+OBAL,A5			; ^descripteur BAL
	SUB.32	A4,A4
	MOVE.32	#2**BMSNBR,D3			; message nombre dans A4.32 = 0
	NTREL	?GIVMS				; donne le message dans la BAL

	CLR.16	{A6}+ONPROC			; plus valable tant que pas de WRITE ouvert
	JUMP	R8^PP$

; Purge le contenu du pipe, si un EOF a t rencontr.

P$: ;	TSET.8	{A6}+oFlg:#bPipeEOW
	TCLR.8	{A6}+oFlg:#bPipeEOF		; EOF rencontr ?
	JUMP,T	R8^PP$				; oui -> c'est tout

	MOVE.32	#0,D4
	NTREL	?MODTIM				; modifie le timout
	PUSH.32	D4

LP$:	MOVE.32	{A6}+OBAL,A5			; A5 <-- ^descripteur BAL
	MOVE.32	#0,D3
	NTREL	?GETMS				; Lit le message
	JUMP,NE	R8^PX$

	MOVE.32	{A6}+OBASMEM,A1
	MOVE.32	#MTYPBD,D1
	GESMEM	?GIVMEM				; rend la mmoire de la zone
	JUMP	LP$

PX$:	POP.32	D4
	NTREL	?SETTIM				; remet le time-out user

PP$:	POPM.32	D3|D4|A4|A5
R$:	CLR.16	D7
	RET


;-------\\
; WRITE  >
;=======/

; in	A6.32	^var sous-pilote
; in	A4.32	^ la zone mmoire
;	D5.32	lg  crire
; out	D5.32	lg effectivement crite
;	D7.16	erreur
; mod	D0..A1, D7.16

WRITE:
	MOVE.32	{A6}+OWIN32PIPE,D0
	JUMP,F	R8^WRITE$

	PUSH.32 D4

	MOVE.32	D5,D4
	MOVE.32	D0,D5
	WIN32_	FILEWRITE
	MOVE.32	D4,D5

	POP.32	D4
	RET

WRITE$:	PUSHM.32 D3|D4|D5|A2|A5|A4

	MOVE.32	A4,A5				; ^buffer  transmettre
	MOVE.32	D5,D4				; longueur message
	JUMP,EQ	R8^EXIT$			; longueur nulle

	ADD.32	#LENTETE,D4			; rajoute un en-tte au message
	MOVE.32	{A6}+OBASMEM,A1
	MOVE.32	#MTYPBD,D1
	GESMEM	?GETMEM
	JUMP,NE	R8^EXIT$

	MOVE.32	A4,A2				; A4.32 ^Mmoire
						; copie de l'en-tte
	MOVE.32	D5,{A2+}			; longueur du message complet

L1$:	MOVE.8	{A5+},{A2+}			; copie du buffer
	DEC.32	D5
	JUMP,NE	L1$

	MOVE.32	{A6}+OBAL,A5			; ^descripteur BAL
	MOVE.32	#2**BMSNBR,D3			; message nombre dans A4.32
	NTREL	?GIVMS				; donne le message dans la BAL

EXIT$:	POPM.32	D3|D4|D5|A2|A5|A4
	RET


;-------\\
;  READ  >
;=======/

; in	A6.32	^var sous-pilote
; in	A4.32	^ la zone mmoire
;	D5.32	lg  lire
; out	D5.32	lg effectivement lue
;	D7.16	erreur
; mod	D0..A1, D5.32, D7.16


READ:
	MOVE.32	{A6}+OWIN32PIPE,D0
	JUMP,F	R8^READ$

	PUSH.32 D4

	MOVE.32	D5,D4
	MOVE.32	D0,D5
	WIN32_	FILEREAD
	MOVE.32	D4,D5

	POP.32	D4
	RET

READ$:	TEST.8	{A6}+OFPIPE			; mode pipeline ?
	JUMP,T	READ_PIPE			; oui => lecture spciale

	PUSHM.32 D3|D4|A2|A4|A5

	MOVE.32	A4,A2				; ^buffer de rception
	MOVE.32	{A6}+OBAL,A5			; A5 <-- ^descripteur BAL
	MOVE.32	#0,D3
	NTREL	?GETMS				; lit le message
	JUMP,EQ	R8^S0$

	MOVE.32	#0,D5				; longueur message nulle
	JUMP	R8^EXIT$			; --> A4.32 message

S0$:	MOVE.32	A4,A5				; sauve ^mmoire
	MOVE.32	{A5+},D0			; longueur message transmis
	COMP.32	D0,D5				; buffer rception plus grand OK
	JUMP,HS	R8^OK$
	MOVE.16	#ERNEMEM,D7
	MOVE.32	D5,D0				; longueur max
	JUMP	R8^L1$

OK$:	MOVE.16	#EROUTF,D7			; lecture termine
	MOVE.32	D0,D5				; longueur reue

L1$:	MOVE.8	{A5+},{A2+}			; copie de la zone mmoire
	DEC.32	D0
	JUMP,NE	L1$

	MOVE.16	D7,D3
	MOVE.32	{A6}+OBASMEM,A1
	MOVE.32	#MTYPBD,D1
	GESMEM	?GIVMEM				; rend la mmoire du paquet
	MOVE.16	D3,D7

EXIT$:	POPM.32	D3|D4|A2|A4|A5
	TEST.16	D7
	RET


READ_PIPE:
	PUSHM.32 D2|D3|D4|A2|A4|A5

	MOVE.32	A4,A2				; ^buffer de rception
	CLR.32	D2				; longueur lue

	TEST.8	{A6}+oFlg:#bPipeEOF		; reu un marqueur EOF ?
	JUMP,T	O$				; oui => rien lu

COPY$:	MOVE.32	{A6}+ONBDATA,D0			; donnes restant  lire
	JUMP,EQ	R8^GETMS$			; plus rien -> attend un message

	MOVE.32	{A6}+OPTDATA,A0			; ^donnes conserves

C1$:	MOVE.8	{A0+},{A2+}			; copie les donnes restantes
	INC.32	D2				; taille lue

	DEC.32	D0				; un de moins  disposition
	JUMP,NE	C2$

	MOVE.32	D0,{A6}+ONBDATA			; plus rien  attendre
	MOVE.32	{A6}+OTAMPON,A4			; ^zone mmoire tampon
	MOVE.32	{A6}+OBASMEM,A1
	MOVE.32	#MTYPBD,D1
	GESMEM	?GIVMEM				; rend la mmoire de la zone

C2$:	DEC.32	D5				; un de moins  copier
	JUMP,EQ	FinData$			; plus rien -> reste l

	TEST.32	D0				; reste quelque chose dans la tranche ?
	JUMP,NE	C1$				; oui -> copie encore
						; non -> demande la tranche suivante

GetMs$:	NTREL	?GETTIM				; time out utilisateur

	INC.16	D4				; vite timout nul, pour compter les attentes cumules
	JUMP,EQ	R8^MAX$
	COMP.16	{A6}+OTIMO,D4			;  voir pour erOUTF
	JUMP,LO	R8^USER$			; time-out user plus court => prend celui-ci

MAX$:	MOVE.16	{A6}+OTIMO,D4
USER$:	NTREL	?MODTIM				; modifie le timout

	MOVE.32	{A6}+OBAL,A5			; A5 <-- ^descripteur BAL
	MOVE.32	#0,D3
	PUSH.32	D4
	NTREL	?GETMS				; lit le message
	POP.32	D4
	MOVE.16	D7,D3
	NTREL	?MODTIM				; remet le timeout user
	MOVE.16	D3,D7
	JUMP,NE	R8^RE$

	MOVE.32	A4,D3				; reu fin ?
	JUMP,EQ	R8^O$				; oui => termin

	MOVE.16	{A6}+OTIMO,{A6}+OCOMPT		; prpare futur time-out
	DEC.16	{A6}+OCOMPT			; il y a eu des data

S0$:	MOVE.32	A4,{A6}+OTAMPON			; tampon  rendre
	MOVE.32	{A4+},D0			; longueur message transmis
	MOVE.32	A4,{A6}+OPTDATA			; donnes  disposition
	MOVE.32	D0,{A6}+ONBDATA			; taille  disposition
	JUMP	COPY$

O$:	MOVE.16	#erOUTF,D7			; fin du fichier lu
	TSET.8	{A6}+oFlg:#bPipeEOF

RE$:	MOVE.16	{A6}+OTIMO,{A6}+OCOMPT		; prpare prochain time-out
	JUMP	R8^Fin$

FinData$:
	MOVE.32	D0,{A6}+ONBDATA			; reste pour les suivants
	MOVE.32	A0,{A6}+OPTDATA			; ^sur le reste
	CLR.16	D7

Fin$:	MOVE.32	D2,D5				; longueur reue

FRead$:	POPM.32	D2|D3|D4|A2|A4|A5
	TEST.16	D7
	RET



;-------\\
; AVOTR  >
;=======/

; Dbloque le processus en attente en lecture

; in	A6.32	^vars sous-pilote
; out	D7.16	erreur
; mod	D0..A1, D7.16

AVOTR:
	MOVE.32	{A6}+OWIN32PIPE,D0
	JUMP,F	R8^AVOTR$

	MOVE.16	#1,D7
	RET

AVOTR$:	PUSHM.32 D4|A4|A5
	MOVE.32	{A6}+OBAL,A5
	MOVE.32	#ERTRAV,D4			; erreur transmise
	SUB.32	A4,A4
	NTREL	?DBLPBAL			; dbloque la BAL
	POPM.32	D4|A4|A5
	RET


;--------\\
; STOPTR  >
;========/

; Dbloque le processus en attente en lecture

; in	A6.32	^vars sous-pilote
; out	D7.16	erreur
; mod	D0..A1, D7.16

STOPTR:
	MOVE.32	{A6}+OWIN32PIPE,D0
	JUMP,F	R8^STOP$

	MOVE.16	#1,D7
	RET

STOP$:	PUSHM.32 D4|A4|A5
	MOVE.32	{A6}+OBAL,A5
	MOVE.32	#ERTRAV,D4			; erreur transmise
	SUB.32	A4,A4
	NTREL	?DBLPBAL			; dbloque la BAL
	POPM.32	D4|A4|A5
	RET


	.END

