\define g_Fond:\nef11;
\define g_ev:\n(bf)09;
\define g_titre:\m(f)17;
\define g_it:\n(if)07;
; $sma; $flg: 25010002 $erh:BAL

	.TITLE		\g_titre;BAL.ASD\g_Fond;
	.PROC		M68000

;***************************************************************************************************
;
;
;			Pilote Bote aux lettres
;
;				RB 860603
;
;
;***************************************************************************************************

NewEOF	= true		; gnre EOF tant que pilote pas referm

; RB 0.0	860603	Dbut du Pilote
; RB 0.1	860715	Modif avec gestion interne mmoire
; RB 0.2	860820	Modif EROUTF lorsque lecture > buffer du message (PAS ENCORE FAIT!!)
; RB 0.3	870910	Si ertime -> longueur message nulle
; RB, DD 1.0	881220	NOUVEAU NTR
; DD 1.1	900329	BAL + PIPE selon paramtres installation
; DD 1.2	900607	correction timout pour PIPE
; DD 1.3	910404	fermeture du PIPE (aprs WRITE) provoque erOUTF (READ)
; DD 1.5	930928	restitution des tranches mmoires en mode PIPE
; DD 1.6	940922	registre A4 plus modifi par WRITE !

NREV	=	1
NVER	=	6

	.REF		SMAKY
	.REF		MON
;	.REF		MODULES
	.REF		BIOSDRIV
	.REF		BIOS
	.BASE		10
	.LAYOUT		HEX, LENGTH 0


; Record, entte pour les messages  transmettre
	.LOC	0
OLGMESS:	.BLK.32		1	; 1er par message = longueur
LENTETE:

; Offset des variales : 
;-----------------------

NBDRIV		=	8		; Nombre de Pilotes

	.LOC	0

OBAL:		.BLK.32		1		; Descripteur de BAL
OBASMEM:	.BLK.32		1		; ^base pour gesmem
ONBUSE:		.BLK.16		1		; nombre d'ouverture du pilote
ONPROC:		.BLK.16		1		; no du processus qui a fait dernier WRITE
OFPIPE:		.BLK.8		1		; TRUE si fonctionne en pipeline
OFNOEOF:	.BLK.8		1		; TRUE si PIPE sans EOF au close
oFlg:		.blk.8		1		; divers
 bPipeEOF	= 0			; EOF trouv, jusqu'au CLOSE
; bPipeEOW	= 1			; n'a
		.EVEN
OTIMO:		.BLK.16		1		; time-out en mode pipeline
OCOMPT:		.BLK.16		1		; dcompteur pour timo
OTAMPON:	.BLK.32		1		; ^tampon mmoire en lecture
OPTDATA:	.BLK.32		1		; ^prochain data dans tampon
ONBDATA:	.BLK.32		1		; nombre d'octets valable dans le tampon
LGVARS:						; Longueur plage des variables

	.rev		nrev,nver
	.ident		"Pilote bote aux lettres, responsable: DD"

; Dbut du code du Pilote
; -----------------------
	.LOC	0

BASEDRIV:
	.16	0,D0BASE
	.16	1,D1BASE
	.16	2,D2BASE
	.16	3,D3BASE
	.16	4,D4BASE
	.16	5,D5BASE
	.16	6,D6BASE
	.16	7,D7BASE
	.16	2**7

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_0			No H'B0
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D0ID:
	.16	OPEN-D0BASE		; adresse routines :
	.16	-1			; D0COMMAND-D0BASE
	.16	-1			; D0RSTATUS-D0BASE
	.16	READ-D0BASE
	.16	WRITE-D0BASE
	.16	CLOSE-D0BASE
	.16	STOPTR-D0BASE
	.16	-1			; D0STARTR-D0BASE
	.16	AVOTR-D0BASE
	.16	-1			; D0AUX1-D0BASE
	.16	-1			; D0AUX2-D0BASE
	.16	RESET-D0BASE
	.16	KILL-D0BASE
	.16	-1			; D0STRT-D0BASE
	.16	-1			; D0TSTRT-D0BASE
	.16	-1			; D0START-D0BASE

D0NAB:
	.ASCII	"BAL_0"			; Nom du Pilote
D0NAF:	.FILL.8	LGDNAM-(D0NAF-D0NAB), 0

	.8	16'B0			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D0ID), 0	; le reste
D0BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_1			No H'B1
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D1ID:
	.16	OPEN-D1BASE		; adresse routines :
	.16	-1			; D1COMMAND-D1BASE
	.16	-1			; D1RSTATUS-D1BASE
	.16	READ-D1BASE
	.16	WRITE-D1BASE
	.16	CLOSE-D1BASE
	.16	STOPTR-D1BASE
	.16	-1			; D1STARTR-D1BASE
	.16	AVOTR-D1BASE
	.16	-1			; D1AUX1-D1BASE
	.16	-1			; D1AUX2-D1BASE
	.16	RESET-D1BASE
	.16	KILL-D1BASE
	.16	-1			; D1STRT-D1BASE
	.16	-1			; D1TSTRT-D1BASE
	.16	-1			; D1START-D1BASE

D1NAB:
	.ASCII	"BAL_1"			; Nom du Pilote
D1NAF:	.FILL.8	LGDNAM-(D1NAF-D1NAB), 0

	.8	16'B1			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D1ID), 0	; le reste
D1BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_2			No H'B2
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D2ID:
	.16	OPEN-D2BASE		; adresse routines :
	.16	-1			; D2COMMAND-D2BASE
	.16	-1			; D2RSTATUS-D2BASE
	.16	READ-D2BASE
	.16	WRITE-D2BASE
	.16	CLOSE-D2BASE
	.16	STOPTR-D2BASE
	.16	-1			; D2STARTR-D2BASE
	.16	AVOTR-D2BASE
	.16	-1			; D2AUX1-D2BASE
	.16	-1			; D2AUX2-D2BASE
	.16	RESET-D2BASE
	.16	KILL-D2BASE
	.16	-1			; D2STRT-D2BASE
	.16	-1			; D2TSTRT-D2BASE
	.16	-1			; D2START-D2BASE

D2NAB:
	.ASCII	"BAL_2"			; Nom du Pilote
D2NAF:	.FILL.8	LGDNAM-(D2NAF-D2NAB), 0

	.8	16'B2			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D2ID), 0	; le reste
D2BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_3			No H'B3
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D3ID:
	.16	OPEN-D3BASE		; adresse routines :
	.16	-1			; D3COMMAND-D3BASE
	.16	-1			; D3RSTATUS-D3BASE
	.16	READ-D3BASE
	.16	WRITE-D3BASE
	.16	CLOSE-D3BASE
	.16	STOPTR-D3BASE
	.16	-1			; D3STARTR-D3BASE
	.16	AVOTR-D3BASE
	.16	-1			; D3AUX1-D3BASE
	.16	-1			; D3AUX2-D3BASE
	.16	RESET-D3BASE
	.16	KILL-D3BASE
	.16	-1			; D3STRT-D3BASE
	.16	-1			; D3TSTRT-D3BASE
	.16	-1			; D3START-D3BASE

D3NAB:
	.ASCII	"BAL_3"			; Nom du Pilote
D3NAF:	.FILL.8	LGDNAM-(D3NAF-D3NAB), 0

	.8	16'B3			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D3ID), 0	; le reste
D3BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_4			No H'B4
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D4ID:
	.16	OPEN-D4BASE		; adresse routines :
	.16	-1			; D4COMMAND-D4BASE
	.16	-1			; D4RSTATUS-D4BASE
	.16	READ-D4BASE
	.16	WRITE-D4BASE
	.16	CLOSE-D4BASE
	.16	STOPTR-D4BASE
	.16	-1			; D4STARTR-D4BASE
	.16	AVOTR-D4BASE
	.16	-1			; D4AUX1-D4BASE
	.16	-1			; D4AUX2-D4BASE
	.16	RESET-D4BASE
	.16	KILL-D4BASE
	.16	-1			; D4STRT-D4BASE
	.16	-1			; D4TSTRT-D4BASE
	.16	-1			; D4START-D4BASE

D4NAB:
	.ASCII	"BAL_4"			; Nom du Pilote
D4NAF:	.FILL.8	LGDNAM-(D4NAF-D4NAB), 0

	.8	16'B4			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D4ID), 0 	; le reste
D4BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_5			No H'B5
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D5ID:
	.16	OPEN-D5BASE		; adresse routines :
	.16	-1			; D5COMMAND-D5BASE
	.16	-1			; D5RSTATUS-D5BASE
	.16	READ-D5BASE
	.16	WRITE-D5BASE
	.16	CLOSE-D5BASE
	.16	STOPTR-D5BASE
	.16	-1			; D5STARTR-D5BASE
	.16	AVOTR-D5BASE
	.16	-1			; D5AUX1-D5BASE
	.16	-1			; D5AUX2-D5BASE
	.16	RESET-D5BASE
	.16	KILL-D5BASE
	.16	-1			; D5STRT-D5BASE
	.16	-1			; D5TSTRT-D5BASE
	.16	-1			; D5START-D5BASE

D5NAB:
	.ASCII	"BAL_5"			; Nom du Pilote
D5NAF:	.FILL.8	LGDNAM-(D5NAF-D5NAB), 0

	.8	16'B5			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D5ID), 0	; le reste
D5BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_6			No H'B6
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D6ID:
	.16	OPEN-D6BASE		; adresse routines :
	.16	-1			; D6COMMAND-D6BASE
	.16	-1			; D6RSTATUS-D6BASE
	.16	READ-D6BASE
	.16	WRITE-D6BASE
	.16	CLOSE-D6BASE
	.16	STOPTR-D6BASE
	.16	-1			; D6STARTR-D6BASE
	.16	AVOTR-D6BASE
	.16	-1			; D6AUX1-D6BASE
	.16	-1			; D6AUX2-D6BASE
	.16	RESET-D6BASE
	.16	KILL-D6BASE
	.16	-1			; D6STRT-D6BASE
	.16	-1			; D6TSTRT-D6BASE
	.16	-1			; D6START-D6BASE

D6NAB:
	.ASCII	"BAL_6"			; Nom du Pilote
D6NAF:	.FILL.8	LGDNAM-(D6NAF-D6NAB), 0

	.8	16'B6			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D6ID), 0	; le reste
D6BASE:

\g_ev;; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			Pilote $BAL_7			No H'B7
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
\g_Fond;
D7ID:
	.16	OPEN-D7BASE		; adresse routines :
	.16	-1			; D7COMMAND-D7BASE
	.16	-1			; D7RSTATUS-D7BASE
	.16	READ-D7BASE
	.16	WRITE-D7BASE
	.16	CLOSE-D7BASE
	.16	STOPTR-D7BASE
	.16	-1			; D7STARTR-D7BASE
	.16	AVOTR-D7BASE
	.16	-1			; D7AUX1-D7BASE
	.16	-1			; D7AUX2-D7BASE
	.16	RESET-D7BASE
	.16	KILL-D7BASE
	.16	-1			; D7STRT-D7BASE
	.16	-1			; D7TSTRT-D7BASE
	.16	-1			; D7START-D7BASE

D7NAB:
	.ASCII	"BAL_7"			; Nom du Pilote
D7NAF:	.FILL.8	LGDNAM-(D7NAF-D7NAB), 0

	.8	16'B7			; numro Pilote
	.8	TYPIO			; type: priphrique
	.8	NREV,NVER		; rvision - version
	.8	0			; priorit dans Pilote
	.8	0			; no bios high

	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDALRT	; attribut 0
	.FILL.8	LGDDESC-(APC-D7ID), 0	; le reste
D7BASE:


.if	0
tst:
	pushm.32	a3..a5
	Mon		?afcr, ?aftext

	move.32		d5, d0
	comp.32		d4, d0
	jump,hs		r8^c$
	move.32		d4, d0
c$:
	move.32		d0, d4		; longueur lue
	dec.16		d0
	jump,cs		r8^r$
cp$:
	move.8		{A5+}, {A4+}
	dj.16,nmo	d0, cp$
r$:
	clr.16		d7
	popm.32		a3..a5
	ret
.endif

\g_titre;;-------\
; RESET  >
;=======/

\g_Fond;; in	D3.16	no du sous-pilote install
;	A4.32	^base du sous-pilote
;	A2.32	^paramtres
; out	A6.32	^variables globales
;	D7.16	erreur
; mod	D0..A1, D7.16


RESET:
	PUSHM.32	A2|A4|A5|D4

	move.32		A4, A1

	move.32		#LGVARS*NBDRIV,D4
	move.32		#r16^BASEDRIV,A4
	fos		?GetComMem			; variables du pilote
	jump,ne		freset$

	move.32		a4,a6
	move.16		d3, d4
	mul.16		#LgVars, D4
	add.32		d4,a6				; ^variables sous-pilote

	move.32		A1, {A6}+OBASMEM		; pour ?GETMEM
	clr.16		{A6}+ONBUSE
	clr.16		{A6}+ONPROC
	clr.8		{A6}+OFPIPE
	clr.8		{A6}+OFNOEOF
	clr.32		{A6}+ONBDATA
.if	NewEOF
	clr.8		{A6}+oFlg
.endif

	move.8		{A2+}, D4			; paramtres installation
	comp.8		#"P", D4
	jump,eq		pipe$
	comp.8		#"p", D4			; lettre P = PIPE
	jump,eq		pipe$
	comp.8		#"X", D4
	jump,ne		Nopipe$
	set.8		{A6}+OFNOEOF			; PIPE ne gnre pas EOF au close
pipe$:
	set.8		{A6}+OFPIPE
	move.8		{A2+}, d4
	sl.16		#8, d4
	move.8		{A2+}, d4			; time out pour EROUTF
	move.16		d4, {A6}+OTIMO
	move.16		d4, {A6}+OCOMPT			; prpare future timo
Nopipe$:
	MOVE.32		#-1,D4
	NTREL		?CREBAL
	JUMP,NE		FRESET$

	MOVE.32		A5,{A6}+OBAL
FRESET$:
	POPM.32		A2|A4|A5|D4
	RET

\g_titre;;------\
; KILL  >
;======/
\g_Fond;;
; in	A6.32	^var sous-pilote
; out	D7.16	erreur
; mod	D0..A1, D7.16


KILL:
	PUSHM.32	A5
	MOVE.32		{A6}+OBAL,A5
	NTREL		?KILLBAL
	POPM.32		A5
	RET


\g_titre;;------\
; OPEN  >
;======/
\g_Fond;
; in	A6.32	^var sous-pilote
;	D3.8	mode d'ouverture
; out	-
; mod	-

OPEN:
	inc.16		{A6}+ONBUSE
.if	NewEOF
	tset.32		D3:#bOpWr
	jump,bc		r8^a$
	Ntrel		?GtPNum
	move.16		D4, {A6}+ONPROC
a$:
.endif
	clr.16		D7
	RET


\g_titre;;-------\
; CLOSE  >
;=======/

\g_Fond;; in	A6.32	^var sous-pilote
; out	-
; mod	-

CLOSE:
	dec.16		{A6}+ONBUSE
;----	jump,eq		r8^r$

	test.8		{A6}+OFPIPE
	jump,f		r8^r$

	test.8		{A6}+OFNOEOF
	jump,t		r8^r$

	pushm.32	A5|A4|D3|D4
	NTREL		?GTPNUM
	comp.16		{A6}+ONPROC, D4		; celui qui crivait ?
	jump,ne		r8^p$			; non -> rien  faire

	MOVE.32		{A6}+OBAL,A5		; ^descripteur BAL
	move.32		#0, A4
	MOVE.16		#2**BMSNBR,D3		; Message nombre dans A4.32 = 0
	NTREL		?GIVMS			; Donne le message dans la BAL

	clr.16		{A6}+ONPROC		; plus valable tant que pas de WRITE
.if	NewEof
	jump		r8^pp$
p$:
;	tset.8		{A6}+oFlg:#bPipeEOW
	tclr.8		{A6}+oFlg:#bPipeEOF	; EOF rencontr ?
	jump,bs		r8^pp$			; oui -> c'est tout

	move.16		#0, D4
	NTREL		?MODTIM			; modifie le timout
	push.16		d4
lp$:
	MOVE.32		{A6}+OBAL,A5		; A5 <-- ^descripteur BAL
	MOVE.32		#0,D3
	NTREL		?GETMS			; Lit le message
	jump,ne		r8^px$

	MOVE.32		{A6}+OBASMEM, A1
	MOVE.16		#MTYPBD,D1
	GESMEM		?GIVMEM			; rend la mmoire de la zone
	jump		lp$
px$:
	pop.16		D4
	NTREL		?SETTIM			; remet le time-out user
pp$:
.else
p$:
.endif
	popm.32		A5|A4|D3|D4
r$:
	clr.16		D7
	RET


\g_titre;;-------\
; WRITE  >
;=======/
\g_Fond;; in	A6.32	^var sous-pilote
; in	A4.32	^ la zone mmoire
;	D5.32	lg  crire
; out	D5.32	lg effectivement crite
;	D7.16	erreur
; mod	D0..A1, D7.16


WRITE:
	PUSHM.32	D3|D4|D5|A2|A5|A4
	MOVE.32		A4,A5			; ^buffer  transmettre
	MOVE.32		D5,D4			; longueur message
	JUMP,EQ		FWRITE$			; Longueur nulle

	ADD.32		#LENTETE,D4		; Rajoute une entte au message
	MOVE.32		{A6}+OBASMEM, A1
	MOVE.16		#MTYPBD,D1
	GESMEM		?GETMEM
	JUMP,NE		FWRITE$
	MOVE.32		A4,A2			; A4.32 ^Mmoire

						; Copie de l'entte
	MOVE.32		D5,{A2+}		; longueur du message complet
L1$:
	MOVE.8		{A5+},{A2+}		; Copie du buffer
	DEC.32		D5
	JUMP,NE		L1$
.if	0
push.32	D3
mon	?Aftim
.ascize	"<cr>Wr: "
move.16	#5, D3
move.32	A4, A5
da$:
move.32	{A5+}, D4
mon	?Afx8, ?AfSpace
dj.16,nmo D3, da$
mon	?Getcar
pop.32	D3
.endif
	MOVE.32		{A6}+OBAL,A5		; ^descripteur BAL
	MOVE.16		#2**BMSNBR,D3		; Message nombre dans A4.32
	NTREL		?GIVMS			; Donne le message dans la BAL

.if	.not.NewEOF
	test.8		{A6}+OFPIPE
	jump,f		r8^FWRITE$
	push.16		D7
	NTREL		?GTPNUM
	move.16		D4, {A6}+ONPROC
	pop.16		D7
.endif
FWRITE$:
	POPM.32		D3|D4|D5|A2|A5|A4
	RET

\g_titre;;-------\
; READ   >
;=======/
\g_Fond;
; in	A6.32	^var sous-pilote
; in	A4.32	^ la zone mmoire
;	D5.32	lg  lire
; out	D5.32	lg effectivement lue
;	D7.16	erreur
; mod	D0..A1, D5.32, D7.16


READ:
	test.8		{A6}+OFPIPE		; mode pipeline ?
	jump,T		READ_PIPE

	PUSHM.32	D3|D4|A2|A4|A5
	MOVE.32		A4,A2			; ^buffer de rception
	MOVE.32		{A6}+OBAL,A5		; A5 <-- ^descripteur BAL
	MOVE.32		#0,D3
	NTREL		?GETMS			; Lit le message
	JUMP,eq		s0$
	move.32		#0,d5			; longueur message nulle
	jump		FRead$			; --> A4.32 message
s0$:
	MOVE.32		A4, A5			; Sauve ^mmoire
.if	0
push.32	D3
mon	?Aftim
.ascize	"<cr>Rd: "
move.16	#5, D3
da$:
move.32	{A5+}, D4
mon	?Afx8, ?AfSpace
dj.16,nmo D3, da$
mon	?Getcar
pop.32	D3
move.32	A4, A5
.endif
	MOVE.32		{A5+}, D0		; Longueur message transmis
	COMP.32		D0, D5			; Buffer rception plus grand OK
	JUMP,HS		OK$
	MOVE.16		#ERNEMEM,D7
	MOVE.32		D5,D0			; Longueur max
	JUMP		L1$
OK$:
	MOVE.16		#EROUTF,D7		; Lecture termine
	MOVE.32		D0,D5			; Longueur reue
L1$:
	MOVE.8		{A5+},{A2+}		; Copie de la zone mmoire
	DEC.32		D0
	JUMP,NE		L1$

	PUSH.16		D7
	MOVE.32		{A6}+OBASMEM, A1
	MOVE.16		#MTYPBD,D1
	GESMEM		?GIVMEM			; rend la mmoire du paquet
	POP.16		D7
FRead$:
	POPM.32		D3|D4|A2|A4|A5
	TEST.16		D7
	RET


READ_PIPE:
	PUSHM.32	D2|D3|D4|A2|A4|A5

	MOVE.32		A4,A2			; ^buffer de rception
	clr.32		D2			; longueur lue

.if	NewEof
	test.8		{A6}+oFlg:#bPipeEOF
	jump,bs		o$
.endif

Copy$:
	MOVE.32		{A6}+ONBDATA, D0	; donnes restant  lire
	jump,eq		r8^GETMS$		; plus rien -> attend un message

	move.32		{A6}+OPTDATA, A0	; ^donnes conserves
c1$:
	move.8		{A0+}, {A2+}		; copie les donnes restantes
	inc.32		D2			; taille lue

	dec.32		D0			; un de moins  disposition
	jump,ne		c2$
	move.32		D0, {A6}+ONBDATA	; plus rien  attendre
	move.32		{A6}+OTAMPON, A4	; ^zone mmoire tampon
	MOVE.32		{A6}+OBASMEM, A1
	MOVE.16		#MTYPBD,D1
	GESMEM		?GIVMEM			; rend la mmoire de la zone
c2$:
	dec.32		D5			; un de moins  copier
	jump,eq		FinData$		; plus rien -> reste l

	test.32		D0			; reste quelque chose dans la tranche ?
	jump,ne		c1$			; oui -> copie encore
						; non -> demande la tranche suivante
GetMs$:
	NTREL		?GETTIM			; time out utilisateur

	inc.16		d4			; vite le timout nul
						; (pour pouvoir compter les attentes cumules)
	jump,eq		r8^max$
	comp.16		{A6}+OTIMO, d4		;  voir pour erOUTF
	jump,lo		r8^user$
max$:
	move.16		{A6}+OTIMO, d4
user$:
	NTREL		?MODTIM			; modifie le timout

	MOVE.32		{A6}+OBAL,A5		; A5 <-- ^descripteur BAL
	MOVE.32		#0,D3
	push.16		d4
	NTREL		?GETMS			; Lit le message
	pop.16		d4
	push.16		d7
	NTREL		?MODTIM			; remet le timo user
	pop.16		d7
.if	NewEOF
	jump,ne		r8^re$
.else
	JUMP,ne		OutFile$		; erreur (timeout) -> quitte avec ce que reu
.endif

	comp.32		#0, A4
	jump,eq		r8^o$

	move.16		{A6}+OTIMO, {A6}+OCOMPT	; prpare future timo
	dec.16		{A6}+OCOMPT		; il y a eu des data
s0$:
	move.32		A4, {A6}+OTAMPON	; tampon  rendre
	MOVE.32		{A4+},D0		; Longueur message transmis
	move.32		A4, {A6}+OPTDATA	; donnes  disposition
	move.32		D0, {A6}+ONBDATA	; taille  disposition
	JUMP		Copy$
oof$:
.if	.not.NewEof
OutFile$:
	comp.16		#-1, {A6}+OCOMPT	; attente infinie ?
	jump,eq		r8^Fin$
	sub.16		d4, {A6}+OCOMPT		; temps cumul
	jump,eq		re$
	jump,cc		r8^Fin$			; reste du temps
.endif
o$:
	move.16		#erOUTF, D7		; fin du fichier lu
.if	NewEof
	tset.8		{A6}+oFlg:#bPipeEOF
.endif
re$:
	move.16		{A6}+OTIMO, {A6}+OCOMPT	; prpare prochain timo
	jump		r8^Fin$
FinData$:
	move.32		D0, {A6}+ONBDATA	; reste pour les suivants
	move.32		A0, {A6}+OPTDATA	; ^sur le reste
	clr.16		D7
Fin$:
	MOVE.32		D2,D5			; Longueur reue
FRead$:
	POPM.32		D2|D3|D4|A2|A4|A5
	TEST.16		D7
	RET



\g_titre;;-------\
; AVOTR  >
;=======/
\g_Fond;; Dbloque le processus en attente en lecture
;
; in	A6.32	^vars sous-pilote
; out	D7.16	erreur
; mod	D0..A1, D7.16



AVOTR:
	PUSHM.32	D4|A4|A5
	MOVE.32		{A6}+OBAL,A5
	MOVE.32		#ERTRAV,D4		; Erreur transmise
	MOVE.32		#0,A4
	NTREL		?DBLPBAL		; Dbloque la BAL
	POPM.32		D4|A4|A5
	RET


\g_titre;;-------\
; STOPTR  >
;=======/
\g_Fond;; Dbloque le processus en attente en lecture
;
; in	A6.32	^vars sous-pilote
; out	D7.16	erreur
; mod	D0..A1, D7.16

STOPTR:
	PUSHM.32	D4|A4|A5
	MOVE.32		{A6}+OBAL,A5
	MOVE.32		#ERTRAV,D4		; Erreur transmise
	MOVE.32		#0,A4
	NTREL		?DBLPBAL		; Dbloque la BAL
	POPM.32		D4|A4|A5
	RET



	.END
