/*
 *	biosdriver.cc
 *
 *	Implmentation d'un pilote BIOS nomm BAR. Il permet d'implmenter des
 *	accs aux Botes  Rendez-Vous par le rseau.
 *
 *	(C) Copyright 1995-1996, Pierre ARNAUD, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#pragma implementation "biosdriver.h"

#include "portable.h"
#include "biosdriver.h"
#include "gesmem.h"
#include "ntrel.h"
#include "mon.h"

/*
 *	Driver "BAR", nouvelle mouture crite en C++. Vive l'volution
 *	du systme et du BIOS.
 */

const char*	BIOSDriver::driver_name = "BAR";
Card8		BIOSDriver::driver_attr = BIOS_ATTR_RDOK+BIOS_ATTR_WROK;
Card8		BIOSDriver::driver_prio = 0;
Card8		BIOSDriver::driver_type = BIOS_TYPE_IO;
Card16		BIOSDriver::driver_base = 0x00FF;

Card8		_SMAREV = 1;
Card8		_SMAVER = 1;
char		_SMAIDE[] = "(C) 1995-1996 Pierre ARNAUD, OPaC bright ideas";



/*
 *	Alloue une nouvelle instance du driver XDRI.
 */

Int16
new_bios_driver (Card32 type, Card32 desc, BIOSDriver* & driver, Card32 num)
{
	Int16 error = 0x8231;
	
	if (num > 10) {
		return error;
	}
	
	error  = 0;
	driver = new (type, desc) BIOSDriver (error, num);
	
	if (driver == 0) error = 0x8300;					//	erreur GESMEM
	
	return error;
}


/*
 *	Oprateur NEW utilis par la classe BIOSDriver pour allouer
 *	une instance de celle-ci. On utilise btement GESMEM.
 */

static Card32 global_mem_type = 0;
static Card32 global_mem_desc = 0;

void*
BIOSDriver::operator new (long int size, Card32 type, Card32 desc)
{
	global_mem_type = type;
	global_mem_desc = desc;
	
	MemAccount account = MemAccount (desc, type);
	void*      memory  = account.Alloc (size);
	
    return memory;
}

void
BIOSDriver::operator delete (void* ptr)
{
	MemAccount account = MemAccount (global_mem_desc, global_mem_type);
	account.Free (ptr);
}

extern "C" void abort ();
extern "C" void* memcpy (void* dst, const void* src, long unsigned size);

void
abort ()
{
	AfText ("ABORT--fatal.\r");
}

void*
memcpy (void* dst, const void* src, long unsigned size)
{
	Card8*       d = (Card8*)(dst);
	const Card8* s = (const Card8*)(src);
	
	while (size--) *d++ = *s++;
	return dst;
}

void*
operator new (long unsigned size)
{
	MemAccount account = MemAccount (global_mem_desc, global_mem_type);
	return account.Alloc (size);
}


void
operator delete (void* ptr)
{
	MemAccount account = MemAccount (global_mem_type, global_mem_desc);
	account.Free (ptr);
}


/****************************************************************************/
/*																			*/
/*						  POINTS D'ENTREE DU DRIVER BAR 					*/
/*																			*/
/****************************************************************************/

BIOSDriver::BIOSDriver (Int16& error, Card32 num)
{
	error = 0;
}

BIOSDriver::~BIOSDriver ()
{
}


Int16
BIOSDriver::Open (Card16& port)
{
	return 0;
}

Int16
BIOSDriver::Command (const char* cmd)
{
    return 1;
}

Int16
BIOSDriver::ReadStatus (void* buffer, Card32 length)
{
    return 1;
}

Int16
BIOSDriver::WriteData (const void* buffer, Card32 pos, Card32 length, Card32 net)
{
	return 0;
}

Int16
BIOSDriver::ReadData (void* buffer, Card32 pos, Card32 length, Card32 net)
{
    return 1;
}


Int16
BIOSDriver::Close (Card16 port)
{
    return 0;
}

Int16
BIOSDriver::Stop ()
{
    return 1;
}

Int16
BIOSDriver::Start ()
{
    return 1;
}

Int16
BIOSDriver::Abort (Card16 port)
{
    return 1;
}

static Card32
create_bar (const char* name)
{
	Card16 error = 0;
	Card32 bar   = 0;
	Card32 mode  = 0;
	
    asm volatile (	"movel %3,d4\n\t"
		    		"movel %2,a3\n\t"
    				"movel a5,d1\n\t"
		    		".long 0x4E44007A\n\t"
		    		"exg   a5,d1\n\t"
		    		"movel d1,%0\n\t"
		    		"movew d7,%1\n\t"
		    	: "=g" (bar), "=g" (error)
		    	: "g" (name), "g" (mode)
		    	: "d1", "d4", "d7", "a3");
	
	if (error == 0x8161) error = 0;
	if (error) bar = 0;
	
	return bar;
}


static Card32
open_bar (const char* name)
{
	Card16 error = 0;
	Card32 bar   = 0;
	Card32 mode  = 1;
	
    asm volatile (	"movel %3,d4\n\t"
		    		"movel %2,a3\n\t"
    				"movel a5,d1\n\t"
		    		".long 0x4E44007A\n\t"
		    		"exg   a5,d1\n\t"
		    		"movel d1,%0\n\t"
		    		"movew d7,%1\n\t"
		    	: "=g" (bar), "=g" (error)
		    	: "g" (name), "g" (mode)
		    	: "d1", "d4", "d7", "a3");
	
	if (error) bar = 0;
	
	return bar;
}

static Card16
kill_bar (Card32 bar)
{
	Card16 error = 0;
	
    asm volatile (	"movel %1,d1\n\t"
		    		"exg   a5,d1\n\t"
		    		".long 0x4E44007B\n\t"
		    		"exg   a5,d1\n\t"
		    		"movew d7,%0\n\t"
				  : "=g" (error)
				  : "g" (bar)
				  : "d1", "d7");
	
	return error;
}

static Card16
offer_bar (Card32 bar, const void* pwr, void* prd, Card32 len)
{
	Card16 error = 0;
	
	asm volatile ( "movel %1,d1\n\t"
				   "exg   a5,d1\n\t"
				   ".long 0x4E44007C\n\t"
				   "exg   a5,d1\n\t"
				   "movew d7,%0\n\t"
				 : "=g" (error)
				 : "g" (bar)
				 : "d1", "d7");
	
	if (error) return error;
	
	void* out_ptr = 0;
	
	asm volatile ( "movel %2,d1\n\t"
				   "movel %3,a4\n\t"
				   "exg   a5,d1\n\t"
				   ".long 0x4E44007E\n\t"
				   "exg   a5,d1\n\t"
				   "movel a4,%0\n\t"
				   "movew d7,%1\n\t"
				 : "=g" (out_ptr), "=g" (error)
				 : "g" (bar), "g" (pwr)
				 : "d1", "d7", "a4");
	
	if (error == 0) {
		Card8* src = (Card8*)(out_ptr);
		Card8* dst = (Card8*)(prd);
		while (len--) *dst++ = *src++;
	}
	
	return error;
}


Int16
BIOSDriver::Aux1 (const char* cmd, Card32& wr, const void* pwr, Card32& rd, void* prd)
{
	const BarCommandRecord* bar_cmd = (BarCommandRecord*)(cmd);
	Int16   error  = 0;
	Card32* result = (Card32*)(prd);
	
	Card32 bar_id = 0;
	
//	AfText ("Aux1: "); AfX8 (bar_cmd->command); AfCR ();
	
	switch (bar_cmd->command) {
		
		case BAR_CMD_CREATE:
			result[0] = create_bar (bar_cmd->data.name);
			rd        = 4;
			break;
		
		case BAR_CMD_OPEN:
			result[0] = open_bar (bar_cmd->data.name);
			rd        = 4;
			break;
		
		case BAR_CMD_KILL:
			bar_id = open_bar (bar_cmd->data.name);
			error  = kill_bar (bar_id);
			break;
		
		case BAR_CMD_OFFER_NAME:
			bar_id = open_bar (bar_cmd->data.name);
			error  = offer_bar (bar_id, pwr, prd, rd);
			break;
		
		case BAR_CMD_OFFER_ID:
			bar_id = bar_cmd->data.id;
			error  = offer_bar (bar_id, pwr, prd, rd);
			break;
	}
	
    return error;
}

Int16
BIOSDriver::Aux2 (const char* cmd, Card32& wr, const void* pwr, Card32& rd, void* prd)
{
    return 1;
}



Bool
parse_hex (const char* arg, Card32& address)
{
	Card32 a = 0;
	int    i = 8;
	
	while (i--) {
		char c = *arg++;
		if (c < 'A') return FALSE;
		if (c > 'P') return FALSE;
		a  = (a << 4) | (c - 'A');
	}
	
	address = a;
	return TRUE;
}

