
	.globl	__10BIOSDriver$driver_name		| driver name
	.globl	__10BIOSDriver$driver_attr		| driver attributes
	.globl	__10BIOSDriver$driver_prio		| driver priority
	.globl	__10BIOSDriver$driver_type		| driver type
	.globl	__10BIOSDriver$driver_base		| driver base number
	.globl	_new_bios_driver__FUlUlRP10BIOSDriverUl	| driver allocator

	.text
	.word	0x0080,0x0000				| header: immediate terminator
	.word	0x5555,0x5555				| header: special pattern
	.ascii	"DRIV:C++"				| header: C++ implementation
	
	.long	_new_bios_driver__FUlUlRP10BIOSDriverUl	| header: pointer to allocator
	.long	0					| header: reserved
	.long	__10BIOSDriver$driver_name		| header: pointer to driver name
	.long	0					| header: reserved
	.long	__10BIOSDriver$driver_attr		| header: pointer to driver attributes
	.long	__10BIOSDriver$driver_prio		| header: pointer to driver priority
	.long	__10BIOSDriver$driver_type		| header: pointer to driver type
	.long	__10BIOSDriver$driver_base		| header: pointer to driver base number



|
| useful constants
|

LNTREL_CLEARCACHE	= 0x4E440065
LGESMEM_GETMEM		= 0x4E440028
LGESMEM_COPYMEM 	= 0x4E440083
LGESMEM_GIVMEM		= 0x4E44002B
LGESMEM_CLEARMEM	= 0x4E44005C
L_ERMFUL		= 0x8340
L_ERILOP		= 0x8510
L_ERBINA		= 0x8540
L_ERILAD		= 0x8542
L_ERBNRE		= 0x8545

|
| header offsets
|

L_obxunit	=	0x40	| used units
L_obx_info	=	0x60	| machine + magic
L_obx_text	=	0x64	| text length
L_obx_data	=	0x68	| data length
L_obx_bss	=	0x6C	| bss length
L_obx_syms	=	0x70	| symbol table length
L_obx_entry	=	0x74	| start address
L_obx_trsize	=	0x78	| text relocation table size
L_obx_drsize	=	0x7C	| data relocation table size
L_OMAGIC	=	0x107
L_BBXGNU	=	7	| bit in L_obxunit
L_FOSVER	=	0x619	| needed: >= FOS 6.25

|
| input:	A2	^driver (- 256 => header)
|		D1,A1	 memory descriptor
|
| program is loaded in memory; however, the program has to be relocated first;
| this starting up code copies the code in a free memory area, relocates it
| there and jumps there; original program code remains untouched.
|

	movel	d1,d2			| D2 <-- memory type
	movel	a2,a6			| A6 <-- start of address
	movel	#256,d6			| D6 <-- 256 (always)
	subl	d6,a6			| A6 <-- header address
	movew	#L_ERBINA,d0
	cmpl	#L_OMAGIC,a6@(L_obx_info)
	bne	L_err			| bad magic number ?

	movel	d6,d4
	addl	a6@(L_obx_text),d4
	addl	a6@(L_obx_data),d4
	movel	d4,a2			| A2 <-- header + text + data

L_noGNU:
	addl	a6@(L_obx_bss),d4	| D4 <-- memory needed
	addql	#8,d4			| D4 <-- some room for movel (copy/clear)
	andib	#0xfe,d4		| D4 <-- align 2
	movel	d2,d1			| D1 <-- memory type / memory descriptor
	.long	LGESMEM_GETMEM
	movew	d7,d0
	bne	L_err			| something already wrong ?

	movel	a4,a3			| remember relocated code address
	.long	LGESMEM_CLEARMEM	| clear memory, first...

	movel	a3,a1
	movel	a6,a3			| a3 <-- ^program header
	movel	a2,d4			| d4 <-- size to copy (header + text + data)
	.long	LGESMEM_COPYMEM		| copy code to memory
	movel	a1,a3

	movel	a6,a5			| a5 <-- ^header
	movel	a4,a6			| a6 <-- ^memory (copy of code)
	addl	d6,a6			| a6 <-- ^text

| a3 : ^relocated
| a6 : ^text start
| a5 : ^header
| a2 :  header + text + data

	movel	a6,d7			| ^text start
	movel	a5,a4			| ^original
	addl	a2,a4			| + header + text + data = ^reloc table
	tstl	a5@(L_obx_entry)
	beq	L_reloc8		| 8 bytes / reloc info ?

	moveql	#1,d5			| d5.32 = 1
	movel	a4@+,d0			| first address
	beq	L_end1reloc

	addl	d7,d0
	movel	d0,a0			| absolute address
	moveql	#0,d0

L_1relocit:
	addl	d7,a0@
L_1reloc:
	moveb	a4@+,d0
	beq	L_end1reloc
	cmpb	d5,d0
	beq	L_add254
	addl	d0,a0
	bra	L_1relocit
L_add254:
	lea	a0@(254),a0
	bra	L_1reloc
L_reloc8:
	moveql	#0,d5			| offset to text
	movel	a5@(L_obx_trsize),d0	| reloc length for text
	bsr	L_relocall
	movel	a5@(L_obx_text),d5	| offset to data
	movel	a5@(L_obx_drsize),d0	| reloc length for data
	bsr	L_relocall
L_end1reloc:
	addl	a6,a2			| ^bss+256, d0 = 0
	subl	d6,a2			| -256
	movel	a5@(L_obx_bss),d1	| bss length
	beq	L_noclr
	movel	a2,d4
	lsrb	#1,d4
	bcc	L_evenadd
	moveb	d0,a2@+
L_evenadd:
	addql	#3,d1			| adjust to long
	lsrl	#2,d1			| /4
L_clrl:
	movel	d0,a2@+			| clear bss area
	subql	#1,d1
	bne	L_clrl
L_noclr:
	.long	LNTREL_CLEARCACHE	| for 68020, 68030, ...
L_nocache:
	clrl	d7
	movel	a3,a4
	addl	#256,a4
	rts


L_relocall:				| in: a4^ reloc, d7^ start, d0 length
	lsrl	#3,d0			| div 8
	beq	L_endreloc		| none ?
L_reloc:
	movel	a4@+,d4			| r_address
	movel	a4@+,d1			| r_symbolnum+r_pcrel+r_length+r_extern
	cmpl	#0x00000840,d1
	bhi	L_relerror
	beq	L_relok
	cmpw	#0x0640,d1
	beq	L_relok
	cmpw	#0x0440,d1
	bne	L_relerror
L_relok:
	addl	d5,d4			| offset in text or data
	addl	d7,a6@(0,d4:l)		| correct address
	subql	#1,d0
	bne	L_reloc
L_endreloc:
	rts
L_relerror:
	movew	#L_ERBNRE,d0

L_err:
	clrl	d7
	movew	d0,d7
	rts

