
#include <filer.h>
#include <stdio.h>
#include <string.h>

#include <c++/portable.h>

#include "../bardriv.h"

#define	FOS_OPRD	0x02	/* read open */

extern "C" int F_open (const char* name, long mode, short* canal);
extern "C" int F_close (short canal);
extern "C" int F_auxil1 (short canal, BarCommandRecord&, const void* pwr, long& writelen, void* prd, long& readlen);


int
main (int argc, char* argv[])
{
	BarCommandRecord rec;
	short canal = 0;
	long  wrlen = 0;
	long  rdlen = 0;
	
	if (argc < 3) return 1;
	
	int error = F_open ("#bar:", FOS_OPRD, & canal);
	
	printf ("Open: %d avec canal=%d\n", error, canal);
	
	if (strcmp (argv[1], "create") == 0) {
		
		rec.command = BAR_CMD_CREATE;
		strcpy (rec.data.name, argv[2]);
		
		Card32 id = 0;
		rdlen = sizeof (id);
		
		error = F_auxil1 (canal, rec, 0, wrlen, &id, rdlen);
		
		printf ("Cr la bar `%s' avec id=%08x (%04x)\n", argv[2], id, error);
		F_close (canal);
		return 0;
	}
	
	if (strcmp (argv[1], "kill") == 0) {
		
		rec.command = BAR_CMD_KILL;
		strcpy (rec.data.name, argv[2]);
		
		error = F_auxil1 (canal, rec, 0, wrlen, 0, rdlen);
		
		printf ("Dtruit la bar `%s' (%04x)\n", argv[2], error);
		F_close (canal);
		return 0;
	}
	
	F_close (canal);
	return 0;
}

