	.TITLE	CDROM.ASD

	.PROC	M68020
	.REF	SMAKY
	.REF	SCSI
	.REF	WD33C93

	.REF	BIOSDRIV
	.REF	MON

; Attention:
; ----------

; La capacit du disque rendue par le driver est incorrecte.
; Il y a un bloc disque de trop (???)

; ------------------------------------------------------------------------------
; PA  29/05/96	Corrections selon suggestions d'OM. Merci OM pour le feuilleton
;		massacre  Stack City.
; ------------------------------------------------------------------------------

MajRev		= 0
MinRev		= 5
CurRev		= MajRev*16'100+MinRev
CDRom0Prio	= 10
MTMAS		= 5
NDCdRom0	= 16'78

	.INS	TESTMACHINE.ASI

	TestMachine

	.REV	MajRev, MinRev
	.IDENT	"CDROM CHINON, (C) EPSITEC SA et Jean-Franois Gruet"

pcVarGlob	= 0
pcVarLoc	= 1
pcStructure	= 2
pcCode		= 3
pcVarScsi	= 4


; Constantes
; ----------

senseAttention	= 6
senseNotReady	= 2

ScsiEjectDisk	= 16'C0


; Variables globales
; ------------------

		.APC	PcVarGlob
		.LOC	0

oAdVarLoc:	.BLK.32	7		; 7 pointeurs aux variables
oDrivCount:	.BLK.16	1		; nbre de drivers installs
oFlagsGlob:	.BLK.8	1		; flags globaux
LgVarGlob:


; Variables locales  un pilote
; -----------------------------

		.APC	pcVarLoc
		.LOC	0

oCheckVarLoc:	.BLK.32	1		; controle de la validit du pointeur
oChFosDriv:	.BLK.32	1		; canal pour le module de dcoupage
oScratch:	.BLK.8	256		; buffer de 256 bytes
oBufSense:	.BLK.8	16		; buffer pour le Sense Data
oChUnitScsi:	.BLK.16	1		; canal Fos du fichier
oNumPilScsi:	.BLK.8	1		; no du pilote Scsi install

oSemXBlkD:	.BLK.32	1		; smaphore d'exclusion pour la lecture du bloc de disque
oBlkD:		.BLK.32	1		; no du bloc actuellement en mmoire
oAdBufBlkD:	.BLK.32	1		; adresse du buffer pour un bloc du disque
oMaxBlk:	.BLK.32	1		; no du dernier bloc accessible du disque
oShiftBlk:	.BLK.16	1		; valeur de dcalage pour convertir Blocs Fos en bloc Disque
oLgBlkD:	.BLK.16	1		; longueur d'un bloc du disque
oCntOpen:	.BLK.16	1		; compteur d'ouvertures
oFlagsLoc:	.BLK.8	1		; flags locaux au pilote
 BitLg256	= 0
 BitChange	= 1
 BitParamValid	= 2
		.EVEN
LgVarLoc:

		.APC	pcCode
		.LOC	0

; Enttes des drivers
; -------------------

Debut:		.16	0, CDRom0Base
		.16	2**7

; *************************************************************************
; *                     Driver CDROM_0               No 16'78             *
; *************************************************************************

IDCDrom0:
		.16	CDRomOPEN-CDRom0BASE
		.16	-1			;CDRomCOMMAND-CDRom0BASE
		.16	CDRomRSTATUS-CDRom0BASE
		.16	CDRomREAD-CDRom0BASE
		.16	-1			;CDRomWRITE-CDRom0BASE
		.16	CDRomCLOSE-CDRom0BASE
		.16	-1			; DSTOPTR-CDRom0BASE
		.16	-1			; DSTARTR-CDRom0BASE
		.16	-1			; DAVORTR-CDRom0BASE
		.16	CDRomAUX1-CDRom0BASE
		.16	-1			; DAUX2-CDRom0BASE
		.16	CDRomRESET-CDRom0BASE
		.16	CDRomKILL-CDRom0BASE
		.16	-1			; DSTRT-CDRom0BASE
		.16	-1			; DTSTRT-CDRom0BASE
		.16	-1			; DSTART-CDRom0BASE
NOM$:		.ASCII	"CDROM_0"		; nom du driver
FILL$:		.FILL.8	LGDNAM-(FILL$-NOM$), 0
		.8	NDCDRom0		; no du driver
		.8	TYPMM			; type mmoire de masse
		.8	MajRev,MinRev		; rvision, version
		.8	CDRom0PRIO,0		; priorit
		.8	0			; attribut 1
		.8	2**BDRDOK+2**BDNORT
		.FILL.8	LGDDESC-(APC-IDCDRom0), 0
CDRom0Base:
oNumPilote:	.16	0


;-----------\\
; CDRomReset >
;===========/

; in	A0.32	^base du driver
; out	D7.16	Erreur si NE
; mod	D7.16, F

CDRomReset:
	PUSHM.32 	A5

	PUSHM.32	D4|A4
	MOVE.32		#R16^Debut,A4
	MOVE.32		#LgVarGlob,D4
	FOS		?GETcomMEM		; ne pas oublier d'allouer !
	MOVE.32		A4,A6
	POPM.32		D4|A4
	TEST.16		D7
	JUMP,NE		Out$

	CALL		GetVarLoc
	JUMP,NE		Out$
	CALL		GetPtVarLoc
	JUMP,NE		GivMem$
	CALL		InstallCD
	JUMP,NE		Kill$

Out$:	POPM.32		A5
	RET

Kill$:	COMP.16		#ERMFUNC, D7
	JUMP,EQ		Absent$
	COMP.16		#ERMOFF, D7

Absent$:
	MOVE.16		#ERMDISK, D7
	JUMP		Out$

DEINSTALL$:
	PUSH.16		D7
	CALL		DeInstallUnitScsi
	POP.16		D7

GivMem$:
	PUSH.16		D7
	CALL		GivVarLoc
	POP.16		D7
	JUMP		Out$

	
;----------\\
CDRomKill: ;>
;==========/

	PUSHM.32	A5
	CALL		GetPtVarLoc
	JUMP,NE		Out$
	CALL		DeInstallUnitScsi
	CALL		GivVarLoc

Out$:	POPM.32		A5
	RET


;----------\\
CDRomOpen: ;>
;==========/

	PUSHM.32	D0|A4|A5

	CALL		GetPtVarLoc
	JUMP,NE		Out$

	TEST.16		{A5}+oCntOpen
	JUMP,NE		OpenOk$

	CALL		TestUnitReady
	JUMP,EQ		Ready$
	JUMP,MI		Out$

	CALL		TestUnitReady
	JUMP,EQ		Ready$

	CALL		TestUnitReady
	JUMP,EQ		Ready$
	COMP.16		#senseNotReady, D7
	JUMP,NE		ErrFunc$
	MOVE.16		#ERMRDY, D7
	JUMP		Out$

Ready$:	CALL		PreventMediaRemoval
	JUMP,NE		Out$

	MOVE.32		#{A5}+oScratch, A4
	CALL		ReadCapacity
	JUMP,NE		Out$

	MOVE.32		{A4}+4, D0
	MOVE.16		D0, {A5}+oLgBlkD
	MOVE.32		{A4}, {A5}+oMaxBlk
	SR.32		#8, D0
	CLR.16		{A5}+oShiftBlk

Loop$:	SR.32		D0
	JUMP,EQ		OutLoop$
	INC.16		{A5}+oShiftBlk
	JUMP		Loop$

OutLoop$:
	MOVE.32		A0, A1
	CALL		OpenFosDriv
	JUMP,NE		Out$

OpenOk$:
	INC.16		{A5}+oCntOpen

Out$:	POPM.32		D0|A4|A5
	RET

ErrFunc$:
	MOVE.16		#ERMFUNC, D7
	JUMP		Out$


;----------\\
CDRomClose: ;>
;==========/

	PUSHM.32	A5
	CALL		GetPtVarLoc
	JUMP,NE		Out$
	DEC.16		{A5}+oCntOpen
	JUMP,NE		Out$

	CALL		CloseFosDriv
	CALL		AllowMediaRemoval
;;	CALL		EjectDisk

Out$:	POPM.32		A5
	RET

;----------\\
CDRomRead: ; >
;==========/

; Point d'entre READ

; in	D4.32	no du premier bloc  lire
;	D5.32	nb de blocs  lire
;	A4.32	^buffer
; out	D5.32	nb de blocs rellement lus
;	D7.16	erreur
; mod	D0.32, D1.32, D5.32, D7.16, A0.32, A1.32


	PUSHM.32	D4|A5
	CALL		GetPtVarLoc
	JUMP,NE		R8^Out$
	MOVE.32		{A5}+oChFosDriv, A5
	MOVE.32		_IndNtr, A0
	CALL		{A0}+Oin_ReadBlkFos
	JUMP,EQ		r8^Out$
	COMP.16		#ErMFUNC, D7
	JUMP,NE		r8^Out$
Err$:
	move.16		#ERMREAD, d7
Out$:
	POPM.32		D4|A5
	RET


;-------------\\
CDRomRStatus: ;>
;=============/
;
; Point d'entre RSTATUS
;
; in	D4.32	longueur du buffer
;	A4.32	^buffer
; out	D7.16	erreur si NE
; mod	D0.32, D1.32, D7.16, A0.32, A1.32, F

	PUSHM.32	A5
	CALL		GetPtVarLoc
	jump,ne		Out$
	MOVE.32		D4, D0
	MOVE.32		A4, A0
LClear$:
	DEC.32		D0
	JUMP,EQ		Next$
	CLR.8		{A0+}
	jump		LClear$
Next$:
	MOVE.32		{A5}+oMaxBlk, D0
	INC.32		D0
	MOVE.16		{A5}+oShiftBlk, D1
	SL.32		D1, D0			; taille du CD en bloc Fos

	COMP.32		#LGMAM0, D4
	JUMP,EQ		L0$
	COMP.32		#LgMam1, D4
	JUMP,EQ		L1$
	COMP.32		#LgMam2, D4
	JUMP,EQ		L2$
	COMP.32		#LgMam3, D4
	JUMP,NE		Err$
L3$:	; Longueur gale  LgMam3
	move.32		D0, {A4}+omTBlk 		; nombre total de blocs

L2$:	; Longueur gale  LgMam2
	move.16		{a5}+oLgBlkD, {a4}+omLgBlk	; longueur d'un bloc

L1$:	; Longueur gale  LgMam1

L0$:	; Longueur gale  LgMam0
	MOVE.32		D0, {A4}+omNBlk
	move.8		#MTMAS, {A4}+omType
	CLR.16		D7
Out$:
	TEST.16		D7
	POPM.32		A5
	ret
Err$:
	MOVE.16		#ERIRDL, D7
	JUMP		Out$



;----------\\
; CDRomAux1 >
;==========/

; in	A3.32	^ligne de commande
; 	A4.32	^buffer pour la lecture des donnes
;	D4.32	longueur des donnes  lire
;	A5.32	^donnes  crire
;	D5.32	longueur des donnes  crire
; out	D4.32	longueur des donnes lues
;	D4.32	longueur ncessaire si D7<>0
;	D5.32	longueur des donnes crites
;	D7.16	erreur
;---------------------------------------------------------------------
; GetFirstBlockOfLastSession
;	.8	16'26
;	.8	0
;	.32	0
;	.32	0
;---------------------------------------------------------------------
; Seek
;	.8	16'2B		Seek
;	.8	0		
;	.32			LBA
;	.32			Length
;---------------------------------------------------------------------
; PreFetch
;	.8	16'34,
;	.8	0
;		2		Immdiat
;	.32	LBA
;	.32	Length
;---------------------------------------------------------------------
; ReadSubChannel
;	.8	16'42
;	.8	0
;		2		
;	.32	16'00000000
;		16'40000000
;	.32	Length
;---------------------------------------------------------------------
; ReadTOC
;	.8	16'43	ReadToc
;	.8	0	LBA	Logical block address
;		2	MSF address
;	.32	0
;	.16	StartingTrack
;	.16	Length		Allocation length
;---------------------------------------------------------------------
; PlayAudioMSF
;	.8	16'47
;	.8	0
;	.32	StartMSF
; 	.32	EndMSF
;---------------------------------------------------------------------
; PlayAudioTrack
;	.8	16'48
;	.8	0
;	.32	StartingTrack
;	.32	EndingTrack
;---------------------------------------------------------------------
; PauseAudio
;	.8	16'4B
;	.8	0
;	.32	0
;	.32	0
;---------------------------------------------------------------------
; ResumeAudio
;	.8	16'4B
;	.8	0
;	.32	0
;	.32	1
;---------------------------------------------------------------------
; StopAudio
;	.8	16'C6
;	.8	0
;	.32	0
;	.32	0
;---------------------------------------------------------------------
; SetStopAudio
;	.8	16'C7
;	.8	0
;	.32	0
;	.32	EndMSF
;---------------------------------------------------------------------
; StartPlayAudio
;	.8	16'C9
;	.8	16'00 	
;		16'01	fast forward operation
;		16'11	fast reverse operation
;	.32	StartMSF
;	.32	0
;---------------------------------------------------------------------
; SetSpeedMode
;	.8	16'DD
;	.8	0
;	.32	16'00000000	; normal speed 150 Kb/s
;		16'80000000	; double speed 300 Kb/s
;	.32	0

;---------------------------------------------------------------------
; ReadCDDALBA
;	.8	16'F8
;	.8	0
;	.32	LBA
;	.32	Length
;---------------------------------------------------------------------
; ReadCDDAMSF
;	.8	16'F9
;	.8	0
;	.32	StartMSF
;	.32	EndMSF

CDRomAux1:
	PUSHM.32	D6|A3|A5
;;??	MOVE.32		A5, A0
	CALL		GetPtVarLoc
	JUMP,NE		Out$
	MOVE.32		A5, A1
	MOVE.16		{A5}+oChUnitScsi, D6
	MOVE.32		A0, A5
	SUB.A16		#16, A7
	MOVE.32		{A3}+0, {A7}+0
	MOVE.32		{A3}+4,	{A7}+4
	MOVE.16		{A3}+8, {A7}+8
	CLR.8		{A7}+9
	MOVE.32		A7, A3
	CLR.32		{A3}+12
	FOS		?AUXIL1
	CALL		IfScsiError?
	JUMP,EQ		NoErr$
	JUMP,MI		NoErr$
	MOVE.32		#{A1}+oBufSense, A0
	MOVE.32		A0, {A3}+12
	MOVE.16		#16'8400, d7
NoErr$:
	ADD.A16		#16, A7
Out$:
	POPM.32		D6|A3|A5
	RET

;-----------\\
OpenFosDriv:;>
;===========/

; Initialise le module de coupure de block du NTR

; in	A1.32	^base du pilote

	PUSHM.32	D1..D6|A0|A1|A3..A5
	MOVE.32		A5, A0				; ^variables locales
	MOVE.32		#MTYPBD, D1			; type de compte mmoire
	MOVE.32		{A0}+oMaxBlk, D2
	INC.32		D2				; nombre de bloc du disque
	CLR.32		D0
	move.16		{a0}+oLgBlkD, D0
	SR.32		#8, D0
	CLR.32		D3
L$:
	ADD.32		D2, D3
	DEC.16		D0
	JUMP,ZC		L$
	MOVE.32		D3, D2				; capacit du disque en bloc fos
	CLR.32		D3
	MOVE.16		{A0}+oLgBlkD, D3		; longueur d'un bloc
	CLR.16		D4				; longueur d'une piste nulle
;	MOVE.32		#16'20, D5			; offset de base pour accder  la partition
	clr.32		d5
	CLR.32		D6				; pas de buffer de piste
	MOVE.32		#R16^ReadExtended, A3		; routine de lecture de blocs
	MOVE.32		#R16^WriteExtended, A4		; routine d'criture de blocs
	PUSH.32		A0
	MOVE.32		_IndNtr, A0
	CALL		{A0}+OIN_OpenBlkFos
	POP.32		A0
	JUMP,NE		R8^Out$
	MOVE.32		A5, {A0}+oChFosDriv	; sauve le canal du module FosDriv
Out$:
	TEST.16		D7
	POPM.32		D1..D6|A0|A1|A3..A5
	RET

;
;-------------\\
CloseFosDriv: ;>
;=============/
;
; 
	PUSHM.32	D0|A0
	MOVE.32		{A5}+oChFosDriv, D0	; module de coupure initialis ?
	JUMP,EQ		Out$			; non => GivVar$
						; oui =>

	CLR.32		{A5}+oChFosDriv		; oublie le canal...

	PUSH.32		A5
	MOVE.32		D0, A5			; canal --> A5.32
	MOVE.32		_indNtr, A0
	CALL		{A0}+OIN_CloseBlkFos	; ferme le module
	POP.32		A5

Out$:	TEST.16		D7
	POPM.32		D0|A0
	RET
;
;----------\\
GetVarLoc: ;>>
;==========/
;
; Alloue la mmoire pour les variables locales au pilote
;
; in	A0.32	^base du driver
; out	D7.16	erreur si NE
; mod	D7.16, F
;
	PUSHM.32	D0|D1|D4|A4
	MOVE.32		#LgVarLoc, D4
	MOVE.32		A0, A1		; ^ base du pilote --> A1.32
	MOVE.32		#MTYPBD, D1
	MOVE.16		{A0}+oNumPilote-CDRom0Base, D0
	SL.16		#2, D0
	CLR.32		{A6}+A16^{D0}+oAdVarLoc
	GESMEM		?GETMEM
	JUMP,NE		Out$
	GESMEM		?CLEARMEM
	MOVE.32		A4, {A6}+A16^{D0}+oAdVarLoc
	MOVE.32		A4, {A4}+oCheckVarLoc
	TEST.16		D7
Out$:
	POPM.32		D0|D1|D4|A4
	RET
;------------\\
GetPtVarLoc: ;>
;============/
;
; Retourne le pointeur au variables locales au pilote
;
; in	A0.32	^base du pilote
; out	A5.32	^variables locales
; mod	A5.32, F

	PUSHM.32	D0
	CLR.16		D7
	MOVE.16		{A0}+oNumPilote-CDRom0Base, D0
	SL.16		#2, d0
	MOVE.32		{A6}+A16^{D0}+oAdVarLoc, A5
	COMP.32		{A5}+oCheckVarLoc, A5
	jump,eq		Out$
	MOVE.16		#ERPTMEM, D7
Out$:
	TEST.16		D7
	POPM.32		D0
	RET
;
;----------\\
GivVarLoc: ;>
;==========/
;
; Restitue la mmoire occupe par les variables locales
;
; in	A0.32	^base du driver
; 	A6.32	^variables locales

	PUSHM.32	D1|A4
	CLR.16		D7
	MOVE.16		{A0}+oNumPilote-CDRom0Base, D1
	SL.16		#2, D1
	TEST.32		{A6}+A16^{D1}+oAdVarLoc
	JUMP,EQ		Out$
	MOVE.32		{A6}+A16^{D1}+oAdVarLoc, A4
	MOVE.32		A0, A1
	MOVE.32		#MTYPBD, D1
	GESMEM		?GIVMEM
	CLR.32		{A6}+A16^{D1}+oAdVarLoc
Out$:
	TEST.16		D7
	POPM.32		D1|A4
	RET
	
;----------\\
InstallCD:; >
;==========/
;
; Installe l'unit scsi correspondante et vrifie qu'un CD est au bout
;
; in A5.32	^variables locale

	TEST.16		{A5}+oDrivCount
	JUMP,EQ		Inst$
	CLR.16		D7
	RET
Inst$:
	PUSHM.32	D0
	CLR.16		D0
Loop$:
	CALL		InstallUnitScsi
	JUMP,EQ		InstOk$
	COMP.16		#ERNDEV, D7
	JUMP,EQ		Next$
	COMP.16		#ERIDEV, D7
	JUMP,NE		Out$
	MOVE.16		#ERMDISK, D7
	JUMP		Out$
Next$:
	INC.16		D0
	JUMP		Loop$

; Vrifie si CHINON au bout
InstOk$:
	CALL		Inquiry
	JUMP,Eq		Inst10$
	CALL		DeInstallUnitScsi
	JUMP		Next$
Inst10$:
	PUSHM.32	A3|A4

	MOVE.32		#{A5}+oScratch, A4
	MOVE.32		#R16^TxChinon, A3
	ADD.32		#8, A4
Verif$:
	TEST.8		{A3}
	JUMP,EQ		Ok$
	COMP.8		{A3+}, {A4+}
	JUMP,EQ		Verif$
	CALL		DeinstallUnitScsi
	POPM.32		A3|A4
	JUMP		Next$
Ok$:
	POPM.32		A3|A4
Out$:
	POPM.32		D0
	RET

TxChinon:	.ASCIZE		"CHINON  CD-ROM CDS-535"

;
;---------------\\
InstallUnitScsi: ;>
;===============/
;
; Installe et ouvre un pilote SCSI de faon  pouvoir excuter
; des appels FOS	?AUXIL1. En cas d'erreur aucune installation
; ne subsiste
;
; in	D0.16			no du sous-pilote  installer 
; out	{A5}+oNumPilScsi.8	no du sous-pilote SCSI install si EQ
;	{A5}+oChUnitSCSI.16	canal FOS de l'unit si EQ
; 	D7.16			erreur si NE

	PUSHM.32	D0|D3|D6|A2..A4
	SUB.32		#50, SP
	CLR.16		{A5}+oChUnitScsi
	SET.8		{A5}+oNumPilScsi
	MOVE.32		SP, A4
	MOVE.32		A4, A3
	MOVE.32		#R16^TxScsi, A2
Cop$:
	MOVE.8		{A2+}, {A3+}
	JUMP,NE		Cop$

	ADD.16		#"0", D0
	MOVE.8		D0, {A4}+6
	
	MOVE.32		#R16^TxNil, A3
	MOVE.32		#{A4}+8, A2
	MOVE.32		#"N"*16'1000000, {A2}
	CLR.16		D3
	FOS		?INSTALL
	JUMP,NE		Out$
	MOVE.8		D3, {A5}+oNumPilScsi	; sauve le no du sous-pilote install

	MOVE.32		A4, A3
	move.32		#2**BopExtend+2**BopMMUnit+2**BopRd+2**BopWr+2**BopExcl+2**BOPGENERAL, D3
	fos		?ArgsOpen
	JUMP,EQ		SavCh$

	PUSH.16		D7
	CLR.16		D3
	FOS		?DEINSTALL
	SET.8		{A5}+oNumPilScsi
	POP.16		D7
	JUMP		Out$
SavCh$:
	MOVE.16		D6, {A5}+oChUnitScsi	; sauve le canal du fichier
	CLR.16		D7
OUT$:
	ADD.32		#50, SP
	POPM.32		D0|D3|D6|A2..A4
	RET
;
;-----------------\\
DeinstallUnitScsi:; >
;=================/
;
; Ferme et dinstalle l'unit SCSI installe
;
; in	{A5}+oNumPilSCSI.8	no du sous-pilote SCSI install
;	{A5}+oChUnitSCSI.16	canal FOS de l'unit ouverte
; out	D7.16			erreur si NE

	PUSHM.32	D0|D3|D6|A3|A4
	SUB.32		#8, SP

	MOVE.16		{A5}+oChUnitScsi, D6
	JUMP,EQ		Deinst$
	FOS		?CLOSE			; ferme le fichier

Deinst$:
	move.8		{A5}+oNumPilScsi, D0
	JUMP,NS		Out$
	MOVE.32		SP, A4
	MOVE.32		#R16^TxScsi, A3
Cop$:	MOVE.8		{A3+}, {A4+}
	JUMP,NE		Cop$
	MOVE.32		SP, A3
	ADD.8		#"0", D0
	MOVE.8		D0, {A3}+6
	CLR.16		D3

	FOS		?DEINSTALL
Out$:
	ADD.32		#8, SP
	POPM.32		D0|D3|D6|A3|A4
	RET
;-----------------\\
AllowMediaRemoval: ;>
;=================/
;
;
;
	PUSHM.32	D3..D6|A3
	PUSH.32		#0
	PUSH.32		#0
	PUSH.16		#0
	MOVE.32		SP, A3
	MOVE.8		#16'1E, {A3}
	MOVE.16		{A5}+oChUnitScsi, D6
	CLR.32		D4
	CLR.32		D5
	FOS		?Auxil1
	Call		IfScsiError?
	add.32		#10, sp
	POPM.32		D3..D6|A3
	RET
;
;--------------------\\
PreventMediaRemoval: ;>
;====================/
;
;
;
	PUSHM.32	D3..D6|A3
	PUSH.32		#0
	PUSH.32		#0
	PUSH.16		#0
	MOVE.32		SP, A3
	MOVE.8		#16'1E, {A3}
	move.8		#1, {a3}+4
	MOVE.16		{A5}+oChUnitScsi, D6
	CLR.32		D4
	CLR.32		D5
	FOS		?Auxil1
	Call		IfScsiError?
	add.32		#10, sp
	POPM.32		D3..D6|A3
	RET
;
;---------\\
EjectDisk: ;>
;=========/
;
; Ejecte le disque
; 
; in
; out
; mod
	PUSHM.32	D3..D6|A3
	PUSH.32		#0
	PUSH.32		#0
	PUSH.16		#0
	MOVE.32		SP, A3
	MOVE.8		#ScsiEjectDisk, {A3}
	MOVE.16		{A5}+oChUnitScsi, D6
	CLR.32		D4
	CLR.32		D5
	FOS		?Auxil1
	Call		IfScsiError?
	add.32		#10, sp
	POPM.32		D3..D6|A3
	RET
;
;------------\\
TestUnitReady: ;>
;============/
;
; Excute la commande TestUnitReady
; 
; in
; out
; mod
	PUSHM.32	D3..D6|A3
	PUSH.32		#0
	PUSH.32		#0
	PUSH.16		#0
	MOVE.32		SP, A3
	MOVE.8		#ScsiReady, {A3}
	MOVE.16		{A5}+oChUnitScsi, D6
	CLR.32		D4
	CLR.32		D5
	FOS		?Auxil1
	Call		IfScsiError?
	add.32		#10, sp
	POPM.32		D3..D6|A3
	RET
;
;------------\\
ReadCapacity: ;>
;============/
;
; Excute la commande Read Capacity
;
; in	A4.32	^capacity data
; out	D7.16	erreur si NE
; mod	D7.16, F

	PUSHM.32	D3..D6|A3
	PUSH.32		#0
	PUSH.32		#0
	PUSH.16		#0
	MOVE.32		SP, A3
	MOVE.8		#ScsiReadCapacity, {A3}
	MOVE.16		{A5}+oChUnitScsi, D6
	MOVE.32		#8, D4
	CLR.32		D5
	FOS		?Auxil1
	Call		IfScsiError?
	add.32		#10, sp
	POPM.32		D3..D6|A3
	RET
;
;-------------\\
ReadExtended: ;>
;=============/
;
; Excute la commande ReadExtended
;
; in	D4.32	no du premier bloc  lire
;	D5.32	nbre de blocs  lire
;	A4.32	^mmoire
; out	D7.16	erreur si NE
; mod	D7.16, F

	PUSHM.32	D0|D3..D6|A3

	MOVE.32		#0, D0

	PUSH.32		D0
	PUSH.32		D0
	PUSH.16		D0			; met des zros bien propres sur le stack

	TEST.32		D4
	JUMP,MI		OutBounds$

	MOVE.32		D4, D0
	ADD.32		D5, D0
	COMP.32		{A5}+oMaxBlk, D0
	JUMP,HI		OutBounds$

	MOVE.32		SP, A3
	MOVE.16		{A5}+oShiftBlk, D3
	ADD.16		#8, D3
	MOVE.32		SP, A3
	MOVE.8		#ScsiReadExtended, {A3}
	MOVE.32		D4, {A3}+2		; init LBA
	MOVE.32		D5, D4			; longueur du transfert en blocs disque --> D4.32
	SL.32		D3, D4			; longueur du transfert en bytes --> D4.32

	MOVE.8		D5, {A3}+8
	SWAP.16		D5
	MOVE.8		D5, {A3}+7
	CLR.32		D5
	MOVE.16		{A5}+oChUnitScsi, D6

	FOS		?AUXIL1			; excute le transfert
	Call		IfScsiError?
	JUMP,EQ		Out$
	JUMP,MI		Out$
	COMP.16		#1, D7
	JUMP,EQ		Recov$
	COMP.16		#2, D7
	JUMP,EQ		NotReady$

	comp.16		#3, d7
	JUMP,EQ		Medium$

	COMP.16		#4, D7
	JUMP,EQ		Hard$

	COMP.16		#5, D7
	JUMP,EQ		Ill$

	COMP.16		#6, D7
	TSET.8		{A5}+oFlagsLoc:#BitChange
	MOVE.16		#ERMDSK, D7
	JUMP		Out$


Ill$:
Hard$:
	MOVE.16		#ERMFUNC, D7
	JUMP		Out$
Medium$:
	MOVE.16		#ERMREAD, D7
	JUMP		Out$

NotReady$:
	MOVE.16		#ERMRDY, D7
	JUMP		Out$

Recov$:
	CLR.16		D7
	JUMP		Out$

Out$:
	ADD.32		#10, SP
	POPM.32		D0|D3..D6|A3
	RET
OutBounds$:
	MOVE.16		#ERMOUT, D7
	JUMP		Out$


;--------------\\
WriteExtended: ;>
;==============/
;
; Excute la commande WriteExtended
;
; in	D4.32	no du premier bloc  crire
;	D5.32	nbre de blocs  crire
;	A4.32	^mmoire
; out	D7.16	erreur si NE
; mod	D7.16, F

	MOVE.16		#ERMWPR, D7
	RET

;-------\\
Inquiry: ;>
;=======/
;
; Excute la commande Inquiry
;

	PUSHM.32	D4|D5|D6|A3|A4
	PUSH.32		#0
	PUSH.16		#0
	MOVE.32		SP, A3
	MOVE.8		#ScsiInquiry, {A3}
	MOVE.8		#36, {A3}+4
	CLR.32		D5
	MOVE.32		#36, D4
	MOVE.32		#{A5}+oScratch, A4
	MOVE.16		{A5}+oChUnitScsi, D6
	FOS		?AUXIL1
	Call		IfScsiError?
	ADD.32		#6, SP
	POPM.32		D4|D5|D6|A3|A4
	TEST.16		D7
	RET

;------------\\
RequestSense: ;>
;============/
;
; Lit le Sense Data suite  une erreur (Check Condition)
;

	PUSHM.32	D4|D5|D6|A3|A4
	PUSH.32		#0
	PUSH.16		#0
	MOVE.32		SP, A3
	MOVE.8		#ScsiRequestSense, {A3}
	MOVE.8		#16, {A3}+4
	MOVE.32		#16, D4
	CLR.32		D5
	MOVE.32		#{A5}+ObufSense, A4
	MOVE.16		{A5}+oChUnitScsi, D6
	FOS		?AUXIL1
	SUB.16		#16'8400, D7
;	JUMP,NE		Err$
Out$:
	ADD.32		#6, SP
	POPM.32		D4|D5|D6|A3|A4
	RET



;------------\\
IfScsiError?: ;>
;============/
;
; Dtermine si une erreur SCSI s'est produite et affiche
; le message d'erreur associ au Sense Key et  l'additionnal
; Sense Code
;
; in	D7.16	erreur
;
	SUB.16		#16'8400, D7
	JUMP,NE		Err$
Out$:
	test.16		d7
	RET

Err$:
	COMP.16		#2, D7				; Check Condition ?
	JUMP,EQ		RequestSense$

	COMP.16		#8, D7
	JUMP,EQ		Busy$

	COMP.16		#16'10, D7
	JUMP,EQ		IntGood$

	COMP.16		#16'18, D7
	JUMP,EQ		Conflict$

; erreur FOS
	ADD.16		#16'8400, D7
	JUMP		Out$

RequestSense$:
	CALL		RequestSense
	CLR.16		D7
	MOVE.8		{A5}+oBufSense+2, D7		; sense Key --> D7.16
	JUMP		Out$
Busy$:
;	jump	erFunc$
IntGood$:
;	jump	erFunc$
Conflict$:
;	jump	erFunc$

erFunc$:
	move.16		#ERMFUNC, D7
	jump		Out$


TxScsi:	.ASCII	"$SCSI_0"
TxNil:	.8	0
	.EVEN

.END
