\define g_Fond:\nef11;
\define g_ev:\n(bf)12;
\define g_titre:\m(f)17;
\define g_it:\n(if)07;
\define g_comment:\n(f)06;
\define g_Lynx:\kip15;
; paramtre pour ASSEMBLE.CODE : $flg: 03010002 $sma;
; $erh: centro
; $edit: (ECRIT,SMILEC,EDIT,PLUME)

	.TITLE	 	\g_titre;CENTRO\g_Fond;
	.PROC		M68020

\g_ev;; Pilote pour interface Centronics sur tous les Smakys
; ----------------------------------------------------
\g_titre;
\g_Fond;	.IDENT		"Pilote Centronics ROM-able, (c) D.Dumoulin EPSITEC SA"

	.REF		SMAKY
	.REF 		MON
	.REF 		BIOSDRIV
	.REF		BIOS
	.REF		CIO
	.REF		SM130HARD

;;;;;;;;;;;;;;;;; Dfinitions dpendant de la machine ;;;;;;;;;;;;;;;;;;;;;;
	.REF		SHIDRIVxxx	; SHIDRIV100, SHIDRIV324, SHIDRIVCOS, etc...
	.REF		xxxHARD		; SM100HARD,  SM324HARD,  CO2HARD, etc...




MAJREV		= 7				; Rvision majeure
MINREV		= 6				; Rvision mineure

	.REV	MAJREV,MINREV


; 7.06	PA	97/09/11	Version sans message de debug dans le moniteur.
; 7.05	PA	97/07/05	Version exprimentale et lgrement remanie.
; 7.04	PA	96/01/31	Affichage de message #CLOCK que si #CENTRO_DEBUG a t
;				assign au paravant; version distribue (si, si !)
; 7.03	PA	96/01/10	Assemblage automatis.
;
; 7.02	PA	95/12/12	CLOSE ne mettait pas #0 dans D7 si ok.
;				KillInter pour Smaky 130 ne dinitialisait pas l'interrupt !
;
; 7.01	RB	95/07/23	Il arrive que le pilote se bloque, ainsi que la souris,
;				essai de correction
;
; 7.00	RB	95/07/20	Modification du pilote pour imprimantes rapide avec attente active
;				limite sur /Ack
;				Gain de temps norme 110us -> 17us entre accs Centro !!
;				Commandes:
;				- A[xx.w], nombre de boucles d'attente sur /Ack activ
;				- D[xx.w], nombre de boucles d'attente sur /Ack dsactiv
;				- T[xx.w], time-out pour attente de l'Ack aprs /Strobe
;

\g_ev;;	Dfinition PC utilis
;	---------------------
\g_Fond;
PCCODE		= 0				; PC du code
PCVAR		= 1				; PC calcul dim variable
PCOFFSET	= 2				; PC calcul  offset


\g_ev;;	Init PC d'assemblage
;	--------------------
\g_Fond;
	.APC		PCCODE
	.LOC		0

ADRZERO:
	.APC		PCVAR
	.LOC		0
	.APC		PCOFFSET
	.LOC		0

\g_ev;;	Initialise les fanions d'assemblage
;	-----------------------------------

\g_Fond;	.INS		TESTMACHINE.ASI
	TestMachine

; Mode 8255 SM8 :
;-----------------
	Sm8MOD55	=	2'10101001		; PA    : output
							; PB    : output
							; PC6-7 : handshake
							; PC4-5 : input



\g_ev;; Variales non rinitialises au moment de OPEN : 
;------------------------------------------------
\g_Fond;;   Sur le FOS il est ncessaire d'utiliser un canal d'entre et un canal de 
; sortie dans le cas ou on utilise les usarts. Ceci permet la gestion de syn-
; cronisation a l'aide de DC1/DC3.

		.APC	PCVAR

oFlag0:		.BLK.8	1			; divers fanions
 bStop		= 0				; utilisateur dsire stopper
 bInter		= 1				; routine interruption active

		.EVEN
LGVAR0:

oCompteurInter:	.BLK.32	1
oDelay:		.BLK.16	1
oMachine:	.BLK.8	1			; no de la machine SM8/SM100/SM324/...
oION:		.BLK.8	1			; set si on attend une interruption
		.EVEN
oCptOpen:	.BLK.16	1			; nombre d'ouvertures
oPSema:		.BLK.32	1			; ^smaphore pour signaler l'interruption

oRoutPrint:	.BLK.32	1			; ^routine d'impression selon machine
oPtData:	.BLK.32	1			; ^donnes suivante  imprimer
oNbData:	.BLK.32	1			; longueur restant  imprimer
oModeDD:	.BLK.8	1
		.EVEN
oWaitAckA:	.BLK.16	1			; Attente active que l'ack s'active
oWaitAckD:	.BLK.16	1			; Attente active que l'ack se dsactive
oTimeOutCar:	.BLK.16	1			; Time out pour l'envoi d'un car

LGVAR:						; Longueur des variables globales




\g_ev;;==============================================================================
;=				   C O D E    P I L O T E				=
;==============================================================================
\g_Fond;	.APC		PCCODE



\g_ev;; Entte du pilote : 
;===================
\g_Fond;
	.16		0,D0BASE			; Add fin entte pilote
	.16		2**7
D0ID:							; Offset routine :
	.16		D0OPEN-D0BASE			; Open
	.16		D0COMMAND-D0BASE		; Command
	.16		D0RSTATUS-D0BASE		; Read status
	.16		-1				; Read
	.16		D0WRITE-D0BASE			; Write
	.16		D0CLOSE-D0BASE			; Close
	.16		D0STOPTR-D0BASE			; Stop
	.16		D0STARTR-D0BASE			; Start
	.16		D0AVOTR-D0BASE			; Avort
	.16		-1				; Auxiliaire 1
	.16		-1				; Auxiliaire 2
	.16		D0RESET-D0BASE			; Reset
	.16		D0KILL-D0BASE			; Kill
	.16		-1				; 
	.16		-1				; 
	.16		-1				; 
D0NAB:
	.ASCII	 	"CENTRO_0"			; Nom pilote
D0NAF:	.FILL.8		LGDNAM-(D0NAF-D0NAB),0		; Renpli le reste avec des 0
	.8		16'88				; Numro pilote
	.8		TYPIO				; Type : entre/sortie
	.8		MAJREV,MINREV			; Rvision - version
	.8		20				; Priorit dans pilote
	.8		0				; no bios high

	.8		0				; Attribut 1
;	.8		2**BDWROK.OR.2**BDNORT		; Attribut 0
	.8		2**BDWROK			; Attribut 0

	.FILL.8		LGDDESC-(APC-D0ID),0		; Le reste avec des 0
D0BASE:




\g_titre;;--------------\
;     RESET     >
;--------------/
\g_Fond;
; in	A2.32	^paramtres ligne de commande
; out	A6.32	^variables locales du pilote
; 	D7.16	erreur
; mod	D0,D1,A0,A1, A6.32, D7.16

D0RESET:
	PUSHM.32 D3|D4|A2..A5

	MOVE.32	#r16^ADRZERO,A4			; ^base du pilote
	MOVE.32	#LgVAR,D4
	FOS	?GetComMEM			; demande le ^mmoire pour variables locale
	JUMP,NE	R8^Err$
	MOVE.32	A4,A6				; ^variables locales au pilote toujours A6.32

	Ntrel	?GetMachine			; cherche le type de machine
	RL.32	#8,D4
	MOVE.8	D4,{A6}+oMachine		; prend note

	MOVE.32	#0,D4
	NTREL	?CRESEM				; smaphore pour signaler l'interruption
	JUMP,NE	R8^Err$

	MOVE.32	A5,{A6}+oPSema

	MOVE.16	#tWaitAckA,{A6}+oWaitAckA	; attente active que l'ack s'active
	MOVE.16	#tWaitAckD,{A6}+oWaitAckD	; attente active que l'ack se dsactive
	MOVE.16	#tTimeOutCar,{A6}+oTimeOutCar	; time-out pour l'envoi d'un caractre

Err$:	POPM.32	D3|D4|A2..A5
	RET


\g_titre;;--------------\
;     KILL      >
;--------------/
\g_Fond;
; in	A6.32	^variables du pilote
; out	D7.16	erreur
; mod	D0,D1,A0,A1, D7.16

D0KILL:
	PUSH.32 A5
	MOVE.32	{A6}+oPSema,A5
	NTREL	?KILLSEM
	POP.32	A5
	RET



\g_titre;;--------------\
;     OPEN      >
;--------------/
\g_Fond;
; in	A6.32	^variables du pilote
; out	D7.16	erreur
; mod	D0,D1,A0,A1, D7.16

D0OPEN:
	PUSHM.32 D4|A4

	DEC.16	{A6}+oCptOpen			; premire ouverture ?
	JUMP,CC	R8^EXIT$			; non => ne fait rien de particulier

	MOVE.32	A6,A4				; ^variables
	MOVE.32	#LGVAR0,D4			; longueur plage variables
	GESMEM	?CLEARMEM			; clear plage variables

EXIT$:	POPM.32	D4|A4
	RET


\g_titre;;--------------\
;     CLOSE     >
;--------------/
\g_Fond;
; in	A6.32	^variables du pilote
; out	D7.16	erreur
; mod	D0,D1,A0,A1, D7.16

D0CLOSE:
	CLR.16	D7
	INC.16	{A6}+oCptOpen			; dernire fermeture ?
	JUMP,NE	R8^Exit$			; non => ne fait rien

	TCLR.8	{A6}+oFlag0:#bStop		; plus de stop
	TCLR.8	{A6}+oFlag0:#bInter		; encore une interruption ?
	JUMP,F	R8^Exit$

	CALL	KillInter			; supprime l'interrupt

Exit$:	RET


\g_titre;;--------------\
;    RSTATUS    >
;--------------/
\g_Fond;
; in	A6.32	^variables du pilote
;	A4.32	^buffer pour les status
;	D4.32	nombre de bytes  lire
; out	D4.32	longueur lue effectivement
;	D7.16	erreur
; mod	D0,D1,A0,A1, D4.32, D7.16

D0RSTATUS:
	MOVE.16	#ERIRLG,D7			; longueur illgale
	RET



\g_titre;;--------------\
;   COMMAND     >
;--------------/
\g_Fond;
; in	A6.32	^variables du pilote
;	A4.32	^table des commandes termine par un 0
; out	D7.16	erreur
; mod	D0,D1,A0,A1, D7.16

D0COMMAND:
	PUSHM.32 A4|A5

NextCom$:
	MOVE.32	#R16^TableCom,A0
	MOVE.32	#0,D0

	MOVE.8	{A4+},D0
	JUMP,EQ	R8^FOk$				; fin des commandes

Loop$:	MOVE.8	{A0}+1,D1
	JUMP,EQ	R8^FinEr$			; erreur, fin de la table
	COMP.8	D0,D1
	JUMP,EQ	R8^OK$
	ADD.A16	#2+4,A0				; test commande suivante possible
	JUMP	Loop$

OK$:	MOVE.32	{A0}+2,A0			; prend dplacement de la routine -> A0.32
	CALL	R8^TableCom+32^{A0}		; appel de la routine
	JUMP	NextCom$

FOk$:	CLR.16	D7
Fin$:	POPM.32	A4|A5
	TEST.16	D7
	RET

FinEr$:	MOVE.16	#ERILLO,d7
	JUMP	Fin$

; La table est en .16 pour garder l'alignement

TableCom:
	.16.32	"A",SetWaitA-TableCom
	.16.32	"D",SetWaitD-TableCom
	.16.32	"T",SetTimeOut-TableCom
	.16	0

SetWaitA:
	MOVE.16	{A4+},{A6}+oWaitAckA		; attente active que l'ack s'active
	RET

SetWaitD:
	MOVE.16	{A4+},{A6}+oWaitAckD		; attente active que l'ack se dsactive
	RET

SetTimeOut:
	MOVE.16	{A4+},{A6}+oTimeOutCar		; time-out pour l'envoi d'un caractre
	RET

\g_titre;;--------------\
;    WRITE      >
;--------------/
\g_Fond;
; in	A6.32	^variables du pilote
;	A4.32	^ la zone mmoire
;	D5.32	Lg  crire
; out	D5.32	Lg effectivement crite
;	D7.16	Erreur
; mod	D0,D1,A0,A1, D7.16

D0WRITE:
	PUSHM.32 D3|D4|A4|A5|D6

	TSET.8	{A6}+oFlag0:#bInter		; dj init ?
	JUMP,T	Write$				; oui => suite

	CALL	InitInter			; initialise vecteur d'interruption
	JUMP,NE	Exit$				; pas possible => fatal !

; PA: Je ne suis pas sr d'avoir compris le but de la manoeuvre. On dsire tre
;     sr qu'il n'y a plus d'interruptions parasites qui tranent, mais comment
;     est-ce que a marche ?

Wait$:	MOVE.32	{A6}+oCompteurInter,D6		; tat interrupts
	CLR.32	{A6}+oNbData			; pas de donnes
	SET.8	{A6}+oION			; interruptions dsires

	MOVE.32	#10,D4
	NTREL	?DELMS				; attend un peu

	CLR.8	{A6}+oION			; ne dsire plus d'interrupts maintenant

	MOVE.32	#0,D4
	NTREL	?MODTIM				; n'attend pas pour vider le smaphore
	MOVE.32	{A6}+oPSema,A5

Empty$:	NTREL	?WAITEV				; vide les interruptions parasites
	JUMP,EQ	Empty$				; tant qu'il en reste (en principe 1)

	MOVE.16	D7,D0
	NTREL	?SETTIM				; remet time-out user
	MOVE.16	D0,D7

	COMP.16	#ERTIMO,D7			; pas un time-out ?
	JUMP,NE	R8^Exit$			; c'est grave => abandonne

;?	COMP.32	{A6}+oCompteurInter,D6
;?	JUMP,NE	R8^Exit$			; erreur si trop attendu

	MOVE.32	#2,D0
	MOVE.16	D0,{A6}+oDelay			; pas trs patient

	COMP.8	#SMAKY8,{A6}+oMachine
	JUMP,NE	R8^Write$			; on est sur un smaky 8 ?  non	-> crit

; Ici, une interrupt est gnre

	MOVE.16	#2'00001100,Sm8PAD55		; disable interrupt CENTRO
	MOVE.16	#Sm8MOD55,Sm8PAD55		; re-init 8255 
	MOVE.16	#2'00001101,Sm8PAD55		; bit PC^6=1 (enable inter)

Write$:	MOVE.32	D5,D4				; lg  crire -> D4
	CALL	WriteMany

Exit$:	POPM.32	D3|D4|A4|A5|D6
	TEST.16	D7
	RET




\g_titre;;--------------\
;     AVOTR     >
;--------------/
\g_Fond;;    Routine appelle par un processus pour stopper un transfert
; en cours en lui faisant gnrer une erreur lors d'un WRITE.
; tant que le pilote est ouvert, cet appel-systme ne rend pas
; d'erreur et mmorise la requte, s'il n'y a pas de processus
; en criture au moment de l'AVOTR.

; in	A6.32		^variables du pilote
; out	D7.16		Erreur
; mod	D0..A1.32 , D7.16

D0AVOTR:
	PUSHM.32	D4|A5
	TSET.8		{A6}+OFLAG0:#BSTOP		; Stop l'impression
	POPM.32		D4|A5
	RET


\g_titre;;--------------;    STOPTR     >
;--------------/
\g_Fond;
; Routine appelle par un processus pour arrter provisoire-
; ment un transfert en cours en le faisant attendre dans le
; pilote dans WRITE, aussi longtemps que la routine STARTR
; n'est excute.
; Tant que le pilote existe, cet appel-systme ne rend pas
; d'erreur et mmorise la requte, s'il n'y a pas de processus
; en criture au moment de l'STOPTR.

; in	A6.32		^variables du pilote
; out	D7.16		Erreur
; mod	D0..A1.32, D7.16

D0STOPTR:
	RET



\g_titre;;--------------;    STARTR     >
;--------------/
\g_Fond;
; Routine appelle par un processus pour redmarrer un
; transfert en cours stopp auparavant par STOPTR.
; Tant que le pilote existe, cet appel-systme ne rend pas
; d'erreur et mmorise la requte, s'il n'y a pas de processus
; en attente au moment de l'AVOTR.
; Cependant, l'appel  cette routine doit correspondre  un
; appel  la routine STOPTR.

; in	A6.32		^variables du pilote
; out	D7.16		Erreur
; mod	D0..A1.32, D7.16

D0STARTR:
	RET


	.INS		LPnHARD.ASI


	.END
