	.TITLE	CLOCK.ASD

; Driver horloge pour toutes les machines...

; Daniel Roux
; Beat Brunner
; Michael Walz
; Pierre Arnaud

MajRev	= 2
MinRev	= 0

; ---------------------------------------------------------------------
; 2.0	PA	supprim le bug des messages apparaissant lorsque leur
;		nombre dpassait 30 dans la file.
; 1.19	JFG	adaptation Smaky 130 et correction dans le mise  jour
;		de la date (no semaine fantaisiste)
; 1.17	JFG	adaptation au Smaky 300
; 1.16	JFG	adaptation au Smaky 196
; 1.15	JFG	traduction en CALM, assemblage avec ASSEMBLE possible
;		remplacement de M8SYS par MON
; 1.14	BB	version pour Costronic: AUCUNE INTERACTIVITE, CAR
;		SYSTEME INDUSTRIEL SANS PANNE, NI INTERVENTION !!!
; 1.13	BB	romable, nouveaux appels PPI
; ---------------------------------------------------------------------

	.INS	TESTMACHINE.ASI

	TestMachine		; initialise les variables machine-dpendantes

; Assemblage conditionnel
; -----------------------

KEYINST	=	0		; installe #KEYBOARD pour lecture clavier

SIMUL	=	0		; simulation si la pile est  plat

;---------------------------------------------------------------------------
	.if	sm196.or.sm300.or.sm130
	.PROC	M68020
	.ELSE
	.PROC	M68000
	.ENDIF	SM196.or.sm300.or.sm130

	.REF	XXXHARD
	.REF	SHIDRIVXXX
.IF 0
	.IF	SM100
	.REF	SM100HARD
	.ENDIF	SM100

	.IF	SM8
	.REF	SM8HARD
	.ENDIF	SM8

	.IF	SM324
	.REF	SHIDRIV324
	.ENDIF	SM324

	.IF	COS20
	.REF	SHIDRIVCOS
	.REF	COSHARD
	.ENDIF	COS20

	.IF	SM196
	.REF	SHIDRIV196
	.REF	SM196HARD
	.ENDIF	SM196

	.IF	SM300
	.REF	SHIDRIV300
	.REF	SM300HARD
	.ENDIF	SM300
.ENDIF

	.IF	SM130
	.REF	SHIDRIV130
	.ENDIF	SM130

	.REF	MON
	.REF	BIOSDRIV
	.REF	SMAKY
	.REF	BIOS

	.BASE	10'10
;;	.LAYOUT HEX

.REV	MajRev,MinRev



	.IF	SM8

; Signaux connects au 8255
; -------------------------

BCLK	=	5		; bit pour le clock
BCS	=	6		; bit pour le chip select
BDOUT	=	7		; bit pour le data read/write

MOD55	=	16'A9		; PA:		output
				; PB:		output
				; PC6-7:	handshake
				; PC4-5:	input
	.ENDIF	SM8


	.IF	SM8.or.SM100.or.SM324

; Registres internes du E050-16
; -----------------------------

REGHOUR	=	2'010		; heures
REGMIN	=	2'001		; minutes
REGSEC	=	2'000		; secondes
REGDATE	=	2'011		; date
REGMON	=	2'100		; mois
REGYEAR	=	2'110		; anne
REGDAY	=	2'101		; jour de la semaine

	.ENDIF	SM8.or.SM100.or.SM324
	.IF	COS20

; Registres internes de l'Intersil 7170
; -------------------------------------

OP7170CENT	=	0
OP7170SEC	=	3
OP7170MIN	=	2
OP7170HOUR	=	1
OP7170DATE	=	5
OP7170MON	=	4
OP7170YEAR	=	6
OP7170DAY	=	7

	.ENDIF	COS20


; Constantes diverses
; -------------------

MAXMESS	= 30			; nombre maximum de messages en attente
MAXMNUM	= MAXMESS+1		; numero de message maximum, (aprs on recommence  1)


; Offsets pour ?RSTATUS
; ---------------------

OCLSTAT:	.BLK.16	1
OCLPWATCH:	.BLK.32	1
LGCLOCK1:

OCLPBAL:	.BLK.32	1
OCLPDEL:	.BLK.32	1
OCLMAXMESS:	.BLK.16	1
LGCLOCK2:




; Variables
; ---------

.LOC	0
.IF	KEYINST
OCHKEY:		.BLK.16		1
OBUKEY:		.BLK.8		4
.ENDIF
OMESSATT:	.BLK.16		MAXMESS		; messages en attente
OSCPOS:		.BLK.32		1
PSEMA:		.BLK.32		1
PBALMESS:	.BLK.32		1
OCPTMESS:	.BLK.16		1

DAY:		.BLK.16		1
FABORT:		.BLK.16		1
FLAG:		.BLK.16		1
FLAGM:		.BLK.16		1
FLAGT:		.BLK.16		1
 BDEBUG	= 0
BUFFER:		.BLK.8		10'10
WRDATE:		.BLK.8		10'4
WRHOUR:		.BLK.8		10'4
FLHEURE:	.BLK.8		1
FLDATE:		.BLK.8		1
WATCH:		.BLK.8		1
 BWMODIF	= 0
 BWNOAFF	= 1
 BWMEM		= 2
 BWDIR		= 3
 BWMOU		= 4
 BWMESS		= 5
	.IF	SM324
	.EVEN
BUFFPPI:	.BLK.8		10'8
OBUFWRRDPPI:	.BLK.8		10'8		; buffer pour rd after wr PPI
OSEMAPPI:	.BLK.32		1		; smaphore pour PPI-read
OADRDPPI:	.BLK.32		1		; adresse pour PPI-read
	.ENDIF	SM324

LGVAR:

OSEC	= WRHOUR+1
OMIN	= WRHOUR+2
OHOUR	= WRHOUR+3

ODATE	= WRDATE+1
OMON	= WRDATE+2
OYEAR	= WRDATE+3




; Constantes
; ----------

FSIECLE	= 16'75		; frontire 21me sicle



; Dbut du code du driver
; -----------------------

DEBUT:
.LOC	0

	.16	0,D0BASE
	.16	2**7



; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $CLOCK0		No H'94
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

D0ID:
	.16	D0OPEN-D0BASE		; Adresse routines
	.16	D0COMMAND-D0BASE
	.16	D0RSTATUS-D0BASE
	.16	D0READ-D0BASE
	.16	D0WRITE-D0BASE
	.16	D0CLOSE-D0BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; D0AUX1-D0BASE
	.16	-1			; D0AUX2-D0BASE
	.16	D0RESET-D0BASE
	.16	D0KILL-D0BASE
	.16	-1			; D0STRT-D0BASE
	.16	-1			; D0TSTRT-D0BASE
	.16	-1			; D0START-D0BASE

D0NAB:	.ASCII	"CLOCK_0"		; Nom driver
D0NAF:	.FILL.8	LGDNAM-(D0NAF-D0NAB), 0

	.8	16'94			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	MajRev,MinRev		; rvision - version
	.16	0			; Variante

	.8	0			; Attribut 1
	.8	2**BDRDOK.OR.2**BDWROK.OR.2**BDNORT; Attribut 0

	.FILL.8	LGDDESC-(APC-D0ID), 0	; Le reste.
D0BASE:






; Points d'entres pour les routines de bases
; -------------------------------------------



;--------\\
; RESET   >
;========/

; in	-
; out	-
; mod	D0..A1, D7.W

D0RESET:
	PUSHM.32 D0..D6|A0..A5

	MOVE.32	#LGVAR,D4
	MOVE.32	#R16^DEBUT,A4
	FOS	?GETComMem		; Demande la mmoire, rendue vent. par le FOS
	JUMP,NE	D0REND
	MOVE.32	A4,A6			; ^variables

	CLR.8	{A6}+FLAG
	CLR.8	{A6}+FLAGM
	CLR.8	{A6}+FLAGT
	CLR.8	{A6}+WATCH
	CLR.16	{A6}+OCPTMESS

	MOVE.32	#-1,D4
	NTREL	?CREBAL
	JUMP,NE	D0REND
	MOVE.32	A5,{A6}+PBALMESS

	.IF	SM100
;SHI	TCLR.B	VIA0+OVPCR:#BCCLK	; Met le clock down
;SHI	TSET.B	VIA0+OVPA:#BCCS		; d-slect chip
	.ENDIF	SM100

	.IF	SM8
	MOVE.16	#MOD55,PAD55	; re-init 8255 (!)
	TCLR.8	PAB55+1:#BCS	; d-slectionne le chip
	.ENDIF	SM8

	.IF	SM324

	CLR.16	D4
	NTREL	?CRESEM			; smaphore synchro interrupt PPI-read
	JUMP,NE	D0REND
	MOVE.32	A5,{A6}+OSEMAPPI

	MOVE.32	#R16^CLKINTER,A1	; initialise l'interruption de lecture PPI
	MOVE.32	_INDSHI,A0		; et les variables de l'interruption A6 --> A0
	MOVE.16	#PPIHORLO,D0
	CALL	{A0}+_INIRCVPPI

	.ENDIF	SM324

	MOVE.32	#{A6}+BUFFER,A4
	MOVE.32	#10'7,D5
	CALL	D0READ

	CLR.8	{A6}+FLDATE
	CLR.8	{A6}+FLHEURE

	MOVE.32	#{A6}+BUFFER+0,A4
	CALL	HEUREOK?
	SET.8,NE {A6}+FLHEURE

	MOVE.32	#{A6}+BUFFER+3,A4
	CALL	DATEOK?
	SET.8,NE {A6}+FLDATE

.IF	COS20.OR.SM196.OR.sm300.or.sm130
.ELSE
	TEST.8	{A6}+FLDATE
	JUMP,NE	INQUIRE
	TEST.8	{A6}+FLHEURE
	JUMP,NE	INQUIRE
.ENDIF	; ELSE COS20

	CLR.16	D7

D0REND:
	POPM.32	D0..D6|A0..A5

	RET


.IF	COS20.OR.SM196.OR.sm300.or.sm130
.ELSE

INQUIRE:

	CLR.32	CPOS


	MOVE.8	{A4}+1,D2
	MOVE.8	#0,D4
	COMP.8	#16'12,D2
	JUMP,EQ	L1$
	SETX
	ADDX.D8	D4,D2
	JUMP	L3$

L1$:	MOVE.8	#16'11,D2	; heure de test --> D2
	MOVE.8	D2,D3

L3$:	PUSH.8	D2
	MOVE.8	#REGMON,D4
	CALL	RDDATA
	MOVE.8	D3,D1		; heure actuelle --> D1

	MOVE.8	D2,D3
	CALL	WRDATA		; on met l'heure de test
	PUSH.16	D4
	MOVE.16	#10,D4
	NTREL	?DELMS
	POP.16	D4
	CALL	RDDATA		; on relit dans D3

	PUSH.8	D3
	MOVE.8	D1,D3
	CALL	WRDATA
	POP.8	D3

	POP.8	D2

	COMP.8	D3,D2
	JUMP,EQ	L2$

	MON	?AFTIM
.ASCII	"<CR><CR><CR><CR>La pile du circuit horloge est  plat"
.ASCIZE	"<CR>*************************************<CR><CR>"
	CALL	GETDATE

.IF	SIMUL
	CALL	GETHEURE
	CALL	CREFILS
.ELSE
	MOVE.8	#16'0,{A6}+OHOUR
	CLR.8	{A6}+OMIN
	CLR.8	{A6}+OSEC
.ENDIF
	INC.8	{A6}+FLAG
	JUMP	D0REND



L2$:
	MON	?AFTIM
.ASCII	"<CR><CR><CR><CR>L'horloge est mal regle"
.ASCIZE	"<CR>************************<CR><CR>"
	CALL	GETDATE
	MON	?AFCR
	CALL	GETHEURE
	INC.8	{A6}+FLAGM
	JUMP	D0REND



GETDATE:
	MOVE.32	CPOS,{A6}+OSCPOS

GETDATE1:
	MOVE.32	{A6}+OSCPOS,CPOS

	MON	?AFTIM
	.ASCIZE	"Donnez la date (jour/mois/anne) : "

	CALL	AFMSPACE

.IF	SM324
 .IF	KEYINST
	CALL	INSTALLKEY
 .ENDIF
.ENDIF

	MOVE.32	#{A6}+WRDATE,A4
	MOVE.8	#SCDATE,{A4+}
	CALL	GETHEX
	MON	?AFTIM
	.ASCIZ	"/"
	MOVE.8	D4,{A4+}
	CALL	GETHEX
	MON	?AFTIM
	.ASCIZ	"/"
	MOVE.8	D4,{A4+}
	CALL	GETHEX
	MOVE.8	D4,{A4+}

.IF	SM324
 .IF	KEYINST
	CALL	DEINSTALLKEY
 .ENDIF
.ENDIF

	MOVE.32	#{A6}+WRDATE+1,A4
	CALL	DATEOK?
	JUMP,NE	GETDATE1
	DEC.32	A4
	MOVE.32	#4,D5
	CALL	D0WRITE
	CLR.16	D7
	RET


AFMSPACE:
	PUSH.32	CPOS
	MON	?AFTIM
	.ASCIZE	"                            "
	POP.32	CPOS
	RET



GETHEURE:
	MON	?AFTIM
	.ASCIZE	"Donnez l'heure (heure/minutes) : "

	MOVE.32	CPOS,{A6}+OSCPOS

GETHEURE1:
	MOVE.32	{A6}+OSCPOS,CPOS

	CALL	AFMSPACE

.IF	SM324
 .IF	KEYINST
	CALL	INSTALLKEY
 .ENDIF
.ENDIF

	MOVE.32	#{A6}+WRHOUR,A4
	MOVE.8	#SCTIME,{A4}
	CALL	GETHEX
	MON	?AFTIM
	.ASCIZ	":"
	MOVE.8	D4,{A4}+3
	CALL	GETHEX
	MOVE.8	D4,{A4}+2
	CLR.8	{A4}+1

.IF	SM324
 .IF	KEYINST
	CALL	DEINSTALLKEY
 .ENDIF
.ENDIF

	MOVE.32	#{A6}+WRHOUR+1,A4
	CALL	HEUREOK?
	JUMP,NE	GETHEURE1
	DEC.32	A4
	MOVE.32	#4,D5
	CALL	D0WRITE
	CLR.16	D7
	RET

.ENDIF	; ELSE COS20.OR.SM196.OR.sm300.or.sm130


HEUREOK?:
	MOVE.8	{A4}+0,D0
	COMP.8	#16'60,D0
	JUMP,HS	L90$
	CALL	BCD?
	JUMP,NE	L90$

	MOVE.8	{A4}+1,D0
	COMP.8	#16'60,D0
	JUMP,HS	L90$
	CALL	BCD?
	JUMP,NE	L90$

	MOVE.8	{A4}+2,D0
	COMP.8	#16'24,D0
	JUMP,HS	L90$
	CALL	BCD?
	JUMP,NE	L90$

	CLR.16	D7
	RET

L90$:	MOVE.16	#1,D7
	RET




DATEOK?:
	MOVE.8	{A4}+0,D0
	COMP.8	#16'31+1,D0
	JUMP,HS	L90$
	TEST.8	D0
	JUMP,EQ	L90$
	CALL	BCD?
	JUMP,NE	L90$

	MOVE.8	{A4}+1,D0
	COMP.8	#16'12+1,D0
	JUMP,HS	L90$
	TEST.8	D0
	JUMP,EQ	L90$
	CALL	BCD?
	JUMP,NE	L90$

	MOVE.8	{A4}+2,D0
	CALL	BCD?
	JUMP,NE	L90$

	COMP.8	#16'87,D0
	JUMP,LO	L10$

L11$:	CLR.16	D7
	RET

L10$:	COMP.8	#FSIECLE,D0
	JUMP,LO	L11$

L90$:	MOVE.16	#1,D7
	RET



.IF	COS20.OR.SM196.OR.sm300.or.sm130
.ELSE

GETHEX:
	PUSH.32	D2
	CLR.32	D4
	CLR.8	D2

L10$:	CALL	GETCAR1
	COMP.8	#"H"-CTRL,D3
	JUMP,EQ	DOBS$
	COMP.8	#DEL,D3
	JUMP,EQ	DOBS$
	COMP.8	#"0",D3
	JUMP,LO	L90$
	COMP.8	#"9",D3
	JUMP,HI	L90$
	COMP.8	#2,D2
	JUMP,EQ	L10$
	MON	?AFCAR
	INC.8	D2
	SUB.8	#"0",D3
	SL.32	#4,D4
	OR.8	D3,D4
	JUMP	L10$

L90$:	TEST.8	D2
	JUMP,EQ	L10$
	COMP.8	#"/",D3
	JUMP,EQ	L99$
	COMP.8	#":",D3
	JUMP,EQ	L99$
	COMP.8	#SPACE,D3
	JUMP,EQ	L99$
	COMP.8	#CR,D3
	JUMP,NE	L10$

L99$:	POP.32	D2
	RET


DOBS$:	TEST.8	D2
	JUMP,EQ	L10$
	DEC.8	D2
	MON	?AFBS
	SR.8	D4
	JUMP	L10$



GETCAR1:
.IF	SM324
 .IF	KEYINST
	MON	?AFTIM
	.ASCIZ	"_"
	CALL	GETCAR
	MON	?AFBS
 .ELSE
	MON	?GETCAR
 .ENDIF
.ELSE
	MON	?GETCAR
.ENDIF
	RET

.ENDIF	; ELSE COS20.OR.SM196.OR.sm300.or.sm130

.IF	SM324

.IF	KEYINST

;--------\\
; GETCAR  >
;========/

GETCAR:
	PUSHM.32 D4|D6|A4

L10$:	MOVE.16	{A6}+OCHKEY,D6
	MOVE.32	#{A6}+OBUKEY,A4
	MOVE.32	#3,D4
	FOS	?RDBYTE
	CLR.32	D3
	MOVE.8	{A4}+2,D3
	SL.16	#8,D3
	MOVE.8	{A4}+1,D3
	SL.32	#8,D3
	MOVE.8	{A4}+0,D3
	TEST.32	D3:#BKPSEUDO
	JUMP,BS	L10$
	TEST.32	D3:#BKRELEAS
	JUMP,BS	L10$

	POPM.32	D4|D6|A4
	RET



;--------------\\
; DEINSTALLKEY  >
;==============/

; 

DEINSTALLKEY:
	PUSHM.32 D3|D4|D6|A3|A4
	MOVE.16	{A6}+OCHKEY,D6
	FOS	?CLOSE
	JUMP,NE	L99$
	NTREL	?GTPNUM
	MOVE.16	D4,D3
	MOVE.32	#R16^NAMKEYB,A3
	FOS	?DEINSTALL
L99$:
	POPM.32	D3|D4|D6|A3|A4
	RET



;------------\\
; INSTALLKEY  >
;============/

; 

INSTALLKEY:
	PUSHM.32 D3|D4|D6|A3|A4
	NTREL	?GTPNUM
	MOVE.16	D4,D3
	MOVE.32	#R16^TNIL,A2
	MOVE.32	#R16^NAMKEYB,A3
	MOVE.32	#R16^NAMKEYPH,A4
	FOS	?INSTALL
	JUMP,NE	L99$

	MOVE.32	#R16^NAMKEYB,A3
	MOVE.16	#2**BOPRD,D3
	FOS	?OPEN
	JUMP,NE	L99$

	MOVE.16	D6,{A6}+OCHKEY

L99$:	POPM.32	D3|D4|D6|A3|A4
	TEST.16	D7
	RET




NAMKEYB:	.ASCIZ	"#KEYCLOCK"
NAMKEYPH:	.ASCIZ	"$KEY"

TNIL:		.16	0

		.EVEN

.ENDIF
.ENDIF



;--------\\
; KILL    >
;========/

; in	A6	^variables
; out	-
; mod	D0..A1

D0KILL:
.IF	SIMUL
	PUSH.32	A5
	INC.8	{A6}+FABORT
	MOVE.32	{A6}+PSEMA,A5
	NTREL	?WAITEV
	POP.32	A5
.ENDIF
	RET



;--------\\
; OPEN    >
;========/

; in	A6	^variables
; out	-
; mod	D0..A1

D0OPEN:
	RET



;--------\\
; CLOSE   >
;========/

; in	A6	^variables
; out	-
; mod	D0..A1

D0CLOSE:
	RET



;--------\\
; COMMAND >
;========/

; in	A4.32	^table des commandes termine par zro
;	A6	^variables
; out	D7.16	erreur
; mod	D0..A1, D7.16

D0COMMAND:
	PUSHM.32 D3|D4|A3|A4|A5

	CLR.16	D7

L5$:	MOVE.8	{A4+},D3
	JUMP,EQ	L99$
	COMP.8	#"R",D3
	JUMP,EQ	L10$
	COMP.8	#"M",D3
	JUMP,EQ	L20$
	COMP.8	#"N",D3
	JUMP,EQ	L30$
	COMP.8	#"C",D3
	JUMP,EQ	L40$
	COMP.8	#"D",D3
	JUMP,EQ	L50$
	COMP.8	#"S",D3
	JUMP,EQ	L60$
	COMP.8	#"T",D3
	JUMP,EQ	L70$
	COMP.8	#"A",D3
	JUMP,EQ	MESS$
	COMP.8	#"K",D3
	JUMP,EQ	LMESS$
	MOVE.16	#ERILLO,D7
	JUMP	L99$

L20$:	TSET.8	{A6}+WATCH:#BWNOAFF
	JUMP	L5$

L10$:	TCLR.8	{A6}+WATCH:#BWMODIF
	TCLR.8	{A6}+WATCH:#BWNOAFF
	JUMP	L5$

L30$:	TSET.8	{A6}+WATCH:#BWMEM
	TCLR.8	{A6}+WATCH:#BWDIR
	TCLR.8	{A6}+WATCH:#BWMOU
	JUMP	L5$

L40$:	TCLR.8	{A6}+WATCH:#BWMEM
	TCLR.8	{A6}+WATCH:#BWDIR
	TCLR.8	{A6}+WATCH:#BWMOU
	JUMP	L5$

L60$:	TCLR.8	{A6}+WATCH:#BWMEM
	TCLR.8	{A6}+WATCH:#BWDIR
	TSET.8	{A6}+WATCH:#BWMOU
	JUMP	L5$

L50$:	TSET.8	{A6}+WATCH:#BWDIR
	TCLR.8	{A6}+WATCH:#BWMEM
	TCLR.8	{A6}+WATCH:#BWMOU
	JUMP	L5$

L70$:	TNOT.8	{A6}+FLAGT:#BDEBUG
	JUMP	L5$


; libre message dtruit

LMESS$:	CALL	GET16D3
	MOVE.16	#MAXMESS,D4
	MOVE.32	#{A6}+OMESSATT,A5

LLOOP$:	COMP.16	{A5+},D3
	JUMP,EQ	LTROUV$
	DEC.16	D4
	JUMP,NE	LLOOP$
	JUMP	L5$

LTROUV$:
	CLR.16	{A5}-2
	JUMP	LLOOP$


; envoi d'un message
; ------------------

; format du message "A[aa.B][bb.B][cc.B][dd.B]Hallo bonjour !<0>"

; aa = nombre de dfilements
; bb = dure du message sonore
; cc = delay entre chaque  dcalage
; dd = type de message

MESS$:
	MOVE.32	{A6}+PBALMESS,A5

	MOVE.32	#6,D4
	PUSH.32	A4

	ADD.32	#1+1+1+1+1,A4

MESS1$:	TEST.8	{A4+}
	JUMP,EQ	MESS2$
	INC.32	D4
	JUMP	MESS1$

MESS2$:
	POP.32	A4

	INC.16	{A6}+OCPTMESS
	COMP.16	#MAXMNUM,{A6}+OCPTMESS
	JUMP,NE	MESS3$
	MOVE.16	#1,{A6}+OCPTMESS

MESS3$:
	MOVE.8	#2**BMSCOPY,D3
	NTREL	?GIVMS
	JUMP,NE	L99$
	MOVE.8	#2**BMSNBR,D3
	MOVE.16	{A6}+OCPTMESS,D4
	SUB.32	A4,A4
	MOVE.A16 D4,A4
	NTREL	?GIVMS
	JUMP,NE	L99$

	MOVE.16	{A6}+OCPTMESS,D7
	MOVE.32	#{A6}+OMESSATT,A5
	MOVE.32	#MAXMESS-1,D3		; au plus .. messages dans la table !

LOOPM$:	TEST.16	{A5+}
	JUMP,EQ	R8^InsertInTable$
	DJ.16,NMO D3,LOOPM$
	JUMP	R8^L99$			; pas de place, on ne fait rien :-(
					; c'est tout de mme mieux que d'aller
					; crire n'importe o, n'est-ce pas MW ?

InsertInTable$:
	MOVE.16	D7,{A5}-2

; fini trmin

L99$:	TEST.16	D7
	POPM.32	D3|D4|A3|A4|A5

	RET


; fait un MOVE.16 {A4+},D3 mme si A4 est impair

GET16D3:
	MOVE.8	{A4+},D3
	SL.16	#8,D3
	MOVE.8	{A4+},D3
	RET




;--------\\
; RSTATUS >
;========/

; in	A4.32	^buffer
;	D4.32	longueur buffer
;	A6	^variables
; out	D4.32	longueur rendue effectivement
;	D7.16	erreur
; mod	D0..A1, D4.32, D7.16

; O --> pile ok
; V --> pile vide

D0RSTATUS:
	PUSHM.32 D1|A0|A3|A4

	MOVE.32	#R16^TLONG,A0
	CALL	32^_CNVLGS
	JUMP,NE	FIN$

	TEST.8	{A6}+FLAG
	JUMP,EQ	L1$
	MOVE.8	#"V",{A4}+OCLSTAT
	JUMP	L90$

L1$:	TEST.8	{A6}+FLAGM
	JUMP,EQ	L2$
	MOVE.8	#"M",{A4}+OCLSTAT
	JUMP	L90$

L2$:	MOVE.8	#"O",{A4}+OCLSTAT

L90$:
	MOVE.32	#{A6}+WATCH,A3
	MOVE.32	A3,{A4}+OCLPWATCH
	COMP.32	#LGCLOCK1,D4
	JUMP,EQ	FIN$

	MOVE.32	{A6}+PBALMESS,{A4}+OCLPBAL
	MOVE.32	#{A6}+OMESSATT,A3
	MOVE.32	A3,{A4}+OCLPDEL
	MOVE.16	#MAXMESS,{A4}+OCLMAXMESS

	CLR.16	D7

FIN$:	POPM.32	D1|A0|A3|A4
	RET


TLONG:	.16	LGCLOCK1
	.16	LGCLOCK2
	.16	0



.IF	SM196.OR.sm300.or.sm130
;--------\\
; WRITE   >
;========/

; in	A4.L	^buffer texte
;	A1.L	^liste de terminateurs
;	D5.L	lg maximale du texte
;	A6	^variables
; out	D5.L	lg effectivement crite
;	D7.W	erreur
; mod	D7.W, D5.L

D0WRITE:
	PUSHM.32 	D3|D4|A4
	MOVE.32		D5, D1		; D1 <-- nb de bytes  crire
	JUMP,EQ		Out$

	move.32		_IndSHI, A0
	CALL		{A0}+_ReadClock	; lit l'horloge --> D3.32 D4.32

	DEC.32		D1
	JUMP,EQ		Out$

	MOVE.8		{A4+}, D0	; D0 <-- type d'opration

	COMP.8		#SCTIME,D0	; set time ?
	JUMP,EQ		R8^SetTime$

	COMP.8		#SCDATE,D0	; set date ?
	JUMP,EQ	 	R8^SetDate$

	COMP.8		#SCDAY,D0	; set day ?
	JUMP,EQ		SetDay$
	JUMP		Out$		; non => Out$

SetTime$:
	TEST.8		{A6}+FLAGT:#BDEBUG
	JUMP,BS		R8^St10$
	CALL		HeureOK?
	JUMP,NE		Err$
St10$:
	MOVE.8		{A4+}, D3	; crit les secondes
	DEC.32		D1
	JUMP,EQ		Write$		; met  jour l'horloge


	SWAP.16		D3
	MOVE.8		{A4+}, D3	; crit les minutes
	SWAP.16		D3
	DEC.32		D1
	JUMP,EQ		Write$

	SWAP.32		D3
	MOVE.8		{A4+}, D3	; mj les heures
	SWAP.32		D3
	DEC.32		D1
	JUMP		Write$


SetDate$:
	TEST.8		{A6}+FLAGT:#BDEBUG
	JUMP,BS		R8^Sd10$
	CALL		DateOK?
	JUMP,NE		Err$
Sd10$:

	COMP.16		#3, D1		; jour-mois-anne spcifis ?
	JUMP,LO		R8^Sd20$	; non => Sd20$
					; oui =>
	EX.32		D0, D4
	CALL		CalcJS		; D4 <-- jour de la semaine
	EX.32		D0, D4		; jour de la semaine --> D0.8
	TEST.8		D0		; erreur ?
	JUMP,MI		Err$		; oui => Err$
					; non =>
	MOVE.8		D0, {A6}+DAY

	swap.32		d4
	move.8		{a6}+day, d4	; mj le jour de la semaine
	swap.32		d4

Sd20$:
	swap.32		d3
	swap.16		d3

	MOVE.8		{A4+}, D3	; mj la date

	swap.16		d3
	swap.32		d3
	DEC.32		D1
	JUMP,EQ		Write$


	move.8		{a4+}, d4	; mois

	DEC.32		D1
	JUMP,EQ		Write$

	SWAP.16		D4
	MOVE.8		{A4+}, D4	; anne
	SWAP.16		D4
	DEC.32		D1
	JUMP		Write$


SetDay$:

	SWAP.32		D4
	MOVE.8		{A4+}, D4
	SWAP.32		D4
	DEC.32		D1

Write$:
.IF	FALSE
	mon	?aftim
	.ascize	"<CR>Write:"
	TRAP	#1
.ENDIF	FALSE
	MOVE.32		D4, D0
	RL.32		#8, D0
	COMP.8		#16'53, D0
	JUMP,HI		Werr$
	CALL		BCD?
	JUMP,EQ		WW$
Werr$:
	AND.32		#16'00FFFFFF, D4
WW$:
	
	call	{A0}+_WriteCLOCK
Out$:
	CLR.16	D7		; D7 <-- ok
	TEST.32	D1		; reste qq chose  crire ?
	JUMP,EQ	 R8^L90$	; non (ok) => 90$
	MOVE.16	#EROUTF,D7	; oui => erreur

L90$:	TSET.8	{A6}+WATCH:#BWMODIF
	SUB.32	D1,D5		; D5 <-- nb bytes crits

L99$:	POPM.32	D3|D4|A4
	RET


ERR$:	MOVE.16	#ERSYNT,D7
	JUMP	L99$


.ELSE
;--------\\
; WRITE   >
;========/

; in	A4.L	^buffer texte
;	A1.L	^liste de terminateurs
;	D5.L	lg maximale du texte
;	A6	^variables
; out	D5.L	lg effectivement crite
;	D7.W	erreur
; mod	D7.W, D5.L

D0WRITE:
	PUSHM.32 D3|D4|A4

	.if	SM196.OR.sm300.or.sm130
	move.32		_IndSHI, A0
	.ENDIF	SM196.OR.sm300.or.sm130

	.IF	COS20
	CLR.32	D3		; On suppose que les poids forts sont  0 !!!
	.ENDIF	COS20

	MOVE.32	D5,D1		; D1 <-- nb de bytes  crire
L10$:
	TEST.32	D1
	JUMP,EQ	L80$

	DEC.32	D1
	MOVE.8	{A4+},D3	; D3 <-- type d'opration

	COMP.8	#SCTIME,D3	; set time ?
	JUMP,EQ	 R8^L20$
	COMP.8	#SCDATE,D3	; set date ?
	JUMP,EQ	 R8^L40$
	COMP.8	#SCDAY,D3	; set day ?
	JUMP,EQ	L60$
	JUMP	L80$		; non => 80$

L20$:
	TEST.8	{A6}+FLAGT:#BDEBUG
	JUMP,BS	L21$
	CALL	HEUREOK?
	JUMP,NE	ERR$
L21$:
	TEST.32	D1
	JUMP,EQ	L80$


	.IF	SM196.OR.sm300.or.sm130
	CALL		{a0}+_ReadClock
	.ENDIF	SM196.OR.sm300.or.sm130


	DEC.32	D1
	MOVE.8	{A4+},D3	; crit les secondes

	.IF	SM8.or.SM100.or.SM324
	MOVE.8	#REGSEC,D4
	CALL	WRDATA		; mj les secondes
	.ENDIF	SM8.or.SM100.or.SM324

	.IF	COS20
	MOVE.32	D3,D4
	LIB	?BCDBIN
	MOVE.8	D4,P7170+OP7170SEC
	.ENDIF	COS20

	TEST.32	D1
.if	SM196.OR.sm300.or.sm130
	jump,eq	WRITE$
.else
	JUMP,EQ	L80$
.endif	SM196.OR.sm300.or.sm130
	DEC.32	D1

	.IF	SM196.OR.sm300.or.sm130
	SWAP.16	D3
	.ENDIF	SM196.OR.sm300.or.sm130

	MOVE.8	{A4+}, D3	; crit les minutes

	.IF	SM196.OR.sm300.or.sm130
	SWAP.16	D3
	.ENDIF	SM196.OR.sm300.or.sm130

	.IF	SM8.or.SM100.or.SM324
	MOVE.8	#REGMIN,D4
	CALL	WRDATA		; mj les minutes
	.ENDIF	SM8.or.SM100.or.SM324

	.IF	COS20
	MOVE.32	D3,D4
	LIB	?BCDBIN
	MOVE.8	D4,P7170+OP7170MIN
	.ENDIF	COS20

	TEST.32	D1
.if	SM196.OR.sm300.or.sm130
	jump,eq	write$
.else
	JUMP,EQ	L80$
.endif	SM196.OR.sm300.or.sm130

	DEC.32	D1

	.IF	SM196.OR.sm300.or.sm130
	SWAP.32	D3
	.ENDIF	SM196.OR.sm300.or.sm130

	MOVE.8	{A4+},D3		; mj les heures

	.IF	SM196.OR.sm300.or.sm130
	SWAP.32	D3
	.ENDIF	SM196.OR.sm300.or.sm130

	.IF	SM8.or.SM100.or.SM324
	MOVE.8	#REGHOUR,D4
	CALL	WRDATA		; mj les heures
	.ENDIF	SM8.or.SM100.or.SM324

	.IF	COS20
	MOVE.32	D3,D4
	LIB	?BCDBIN
	MOVE.8	D4,P7170+OP7170HOUR
	.ENDIF	COS20
.if	SM196.OR.sm300.or.sm130
	jump	write$
.else
	JUMP	L80$
.endif	SM196.OR.sm300.or.sm130


L40$:
	TEST.8	{A6}+FLAGT:#BDEBUG
	JUMP,BS	L41$
	CALL	DATEOK?
	JUMP,NE	ERR$
L41$:
	.if	SM196.OR.sm300.or.sm130
	test.16	d1
	jump,eq	l80$
	.endif

	COMP.16	#3,D1		; jour-mois-anne spcifis ?
	JUMP,LO	 R8^L45$	; non => 45$
				; oui =>
	CALL	CALCJS		; D4 <-- jour de la semaine
	MOVE.8	D4,D3		; D3 <-- idem
	MOVE.16	#ERSYNT,D7
	INC.8	D4		; erreur (D4=-1) ?
	JUMP,EQ	L90$		; oui => 90$

	MOVE.8	D3,{A6}+DAY

	.IF	SM8.or.SM100.or.SM324
	MOVE.8	#REGDAY,D4
	CALL	WRDATA		; mj le jour de la semaine
	.ENDIF	SM8.or.SM100.or.SM324

	.IF	SM196.OR.sm300.or.sm130
	CALL	{a0}+_ReadClock
	swap.32	d4
	move.8	{a6}+day, d4	; mj le jour de la semaine
	swap.32	d4
	test.32	d1
	jump,eq	write$
	.endif	SM196.OR.sm300.or.sm130

	.IF	COS20
	MOVE.32	D3,D4
	LIB	?BCDBIN
	MOVE.8	D4,P7170+OP7170DAY
	.ENDIF	COS20

L45$:

.if	SM196.OR.sm300.or.sm130
	call		{a0}+_ReadClock
	jump,eq		Write$
.ELSE
	TEST.32	D1
	JUMP,EQ	 R8^L80$
.ENDIF	SM196.OR.sm300.or.sm130
	DEC.32	D1
	.if		SM196.OR.sm300.or.sm130
	swap.32		d3
	swap.16		d3
	.endif		SM196.OR.sm300.or.sm130

	MOVE.8	{A4+}, D3	; mj la date

	.if	SM196.OR.sm300.or.sm130
	swap.16		d3
	swap.32		d3
	.endif		SM196.OR.sm300.or.sm130


	.IF	SM8.or.SM100.or.SM324
	MOVE.8	#REGDATE,D4
	CALL	WRDATA		; mj la date
	.ENDIF	SM8.or.SM100.or.SM324

	.IF	COS20
	MOVE.32	D3,D4
	LIB	?BCDBIN
	MOVE.8	D4,P7170+OP7170DATE
	.ENDIF	COS20

	TEST.32	D1
.if	SM196.OR.sm300.or.sm130
	jump,eq	write$
.else
	JUMP,EQ	 R8^L80$
.endif	SM196.OR.sm300.or.sm130

	DEC.32	D1

	.if	SM196.OR.sm300.or.sm130
	move.8	{a4+}, d4		; mois
	.else
	MOVE.8	{A4+},D3
	.endif	SM196.OR.sm300.or.sm130

	.IF	SM8.or.SM100.or.SM324
	MOVE.8	#REGMON,D4
	CALL	WRDATA		; mj le mois
	.ENDIF	SM8.or.SM100.or.SM324
	.IF	COS20
	MOVE.32	D3,D4
	LIB	?BCDBIN
	MOVE.8	D4,P7170+OP7170MON
	.ENDIF	COS20

	TEST.32	D1
.if	SM196.OR.sm300.or.sm130
	jump,eq	WRITE$
.else
	JUMP,EQ	 R8^L80$
.endif	SM196.OR.sm300.or.sm130
	DEC.32	D1

	.if	SM196.OR.sm300.or.sm130
	swap.16	d4
	move.8	{a4+}, d4		; anne
	swap.16	d4
	.else
	MOVE.8	{A4+},D3
	.endif	SM196.OR.sm300.or.sm130

	.IF	SM8.or.SM100.or.SM324
	MOVE.8	#REGYEAR,D4
	CALL	WRDATA		; mj l'anne
	.ENDIF	SM8.or.SM100.or.SM324
	.IF	COS20
	MOVE.32	D3,D4
	LIB	?BCDBIN
	MOVE.8	D4,P7170+OP7170YEAR
	.ENDIF	COS20
.if	SM196.OR.sm300.or.sm130
	jump	write$
.else
	JUMP	R8^L80$
.endif	SM196.OR.sm300.or.sm130

L60$:
	TEST.32	D1
	JUMP,EQ	 R8^L80$

	.if	SM196.OR.sm300.or.sm130
	call	{A0}+_ReadClock
	.endif	SM196.OR.sm300.or.sm130

	DEC.32	D1
	.if	SM196.OR.sm300.or.sm130
	swap.32		d4
	move.16		{a4+}, d4
	swap.32		d4
	.else
	MOVE.8	{A4+},D3
	.endif	SM196.OR.sm300.or.sm130

	.IF	SM8.or.SM100.or.SM324
	MOVE.8	#REGDAY,D4
	CALL	WRDATA		; mj le jour de la semaine
	.ENDIF	SM8.or.SM100.or.SM324
	.IF	COS20
	MOVE.32	D3,D4
	LIB	?BCDBIN
	MOVE.8	D4,P7170+OP7170DAY
	.ENDIF	COS20

	.if	SM196.OR.sm300.or.sm130
Write$:
;;	mon	?aftim
;;	.ascize	"<CR>Write:"
;;	TRAP	#1
	call	{A0}+_WriteCLOCK
	.endif	SM196.OR.sm300.or.sm130
L80$:

	CLR.16	D7		; D7 <-- ok
	TEST.32	D1		; reste qq chose  crire ?
	JUMP,EQ	 R8^L90$	; non (ok) => 90$
	MOVE.16	#EROUTF,D7	; oui => erreur

L90$:	TSET.8	{A6}+WATCH:#BWMODIF
	SUB.32	D1,D5		; D5 <-- nb bytes crits

L99$:	POPM.32	D3|D4|A4
	RET


ERR$:	MOVE.16	#ERSYNT,D7
	JUMP	L99$

.ENDIF	SM196.OR.sm300.or.sm130

.IF	SM196.OR.sm300.or.sm130

;--------\\
; READ    >
;========/

; in	A4.L	^buffer texte
;	A1.L	^liste de terminateurs
;	D5.L	lg maximale du texte
;	A6	^variables
; out	D5.L	lg effectivement lue
;	D7.W	erreur
; mod	D7.W, D5.L

D0READ:
	PUSHM.32 	D3|D4|A0|A4
	MOVE.32		D5,D1		; D1 <-- nb de bytes  lire
	JUMP,EQ		Out$
	MOVE.32		_IndShi, A0
	CALL		{A0}+_ReadClock


	MOVE.8		D3, {A4+}	; mmorise les secondes
	DEC.32		D1
	JUMP,EQ	 	R8^Out$

	SWAP.16		D3
	MOVE.8		D3, {A4+}	; mmorise les minutes
	SWAP.16		D3
	DEC.32		D1
	JUMP,EQ		R8^Out$

	SWAP.32		D3
	MOVE.8		D3, {A4+}	; mmorise les heures
	SWAP.32		D3
	DEC.32		D1
	JUMP,EQ		R8^Out$

	SWAP.32		D3
	SWAP.16		D3
	MOVE.8		D3, {A4+}	; mmorise la date
	SWAP.16		D3
	SWAP.32		D3
	DEC.32		D1
	JUMP,EQ		R8^Out$

	MOVE.8		D4, {A4+}	; mmorise le mois
	DEC.32		D1
	JUMP,EQ		R8^Out$

	SWAP.16		D4
	MOVE.8		D4, {A4+}	; mmorise l'anne
	SWAP.16		D4
	DEC.32		D1
	JUMP,EQ		R8^Out$

	SWAP.32		D4
	MOVE.8		D4, {A4+}	; mmorise le jour de la semaine
	SWAP.32		D4
	DEC.32		D1

	TEST.32		D1		; reste qq chose  lire ?
	JUMP,EQ		R8^Out$		; non (ok) => 80$
	MOVE.16		#EROUTF, D7	; oui => erreur
Out$:
	SUB.32		D1, D5		; D5 <-- nb de bytes lus
	TEST.16		D7
	POPM.32	D3|D4|A0|A4
	RET



.ELSE

;--------\\
; READ    >
;========/

; in	A4.L	^buffer texte
;	A1.L	^liste de terminateurs
;	D5.L	lg maximale du texte
;	A6	^variables
; out	D5.L	lg effectivement lue
;	D7.W	erreur
; mod	D7.W, D5.L

D0READ:
	PUSHM.32 D3|D4|A0|A4

	MOVE.32	D5,D1		; D1 <-- nb de bytes  lire

.IF	SM324
	MOVE.32	#{A6}+BUFFPPI,A0
	TEST.8	{A6}+FLAG
	JUMP,NE	L2$

	CALL	READPPI
	JUMP	L3$

L2$:	MOVE.8	{A6}+OSEC,{A0}+REGSEC
	MOVE.8	{A6}+OMIN,{A0}+REGMIN
	MOVE.8	{A6}+OHOUR,{A0}+REGHOUR
	MOVE.8	{A6}+ODATE,{A0}+REGDATE
	MOVE.8	{A6}+OMON,{A0}+REGMON
	MOVE.8	{A6}+OYEAR,{A0}+REGYEAR
	MOVE.8	{A6}+DAY,{A0}+REGDAY

L3$:
	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.8	{A0}+REGSEC,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.8	{A0}+REGMIN,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.8	{A0}+REGHOUR,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.8	{A0}+REGDATE,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.8	{A0}+REGMON,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.8	{A0}+REGYEAR,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.8	{A0}+REGDAY,{A4+}
	DEC.32	D1

.ENDIF	SM324
.IF	SM100.or.SM8

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.8	#REGSEC,D4
	CALL	RDDATA		; lit les secondes
	MOVE.8	D3,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.8	#REGMIN,D4
	CALL	RDDATA		; lit les minutes
	MOVE.8	D3,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.8	#REGHOUR,D4
	CALL	RDDATA		; lit les heures
	MOVE.8	D3,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.8	#REGDATE,D4
	CALL	RDDATA		; lit la date
	MOVE.8	D3,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.8	#REGMON,D4
	CALL	RDDATA		; lit le mois
	MOVE.8	D3,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.8	#REGYEAR,D4
	CALL	RDDATA		; lit l'anne
	MOVE.8	D3,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.8	#REGDAY,D4
	CALL	RDDATA		; lit le jour dans la semaine
	MOVE.8	D3,{A4+}
	DEC.32	D1

.ENDIF	SM100.or.SM8
.IF	COS20

	TEST.8	P7170+OP7170CENT	; provoque un latch

	TEST.32	D1
	JUMP,EQ	 L80$
	MOVE.32	#0,D4
	MOVE.8	P7170+OP7170SEC,D4
	LIB	?BINBCD
	MOVE.8	D4,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 L80$
	MOVE.32	#0,D4
	MOVE.8	P7170+OP7170MIN,D4
	LIB	?BINBCD
	MOVE.8	D4,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 L80$
	MOVE.32	#0,D4
	MOVE.8	P7170+OP7170HOUR,D4
	LIB	?BINBCD
	MOVE.8	D4,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.32	#0,D4
	MOVE.8	P7170+OP7170DATE,D4
	LIB	?BINBCD
	MOVE.8	D4,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.32	#0,D4
	MOVE.8	P7170+OP7170MON,D4
	LIB	?BINBCD
	MOVE.8	D4,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.32	#0,D4
	MOVE.8	P7170+OP7170YEAR,D4
	LIB	?BINBCD
	MOVE.8	D4,{A4+}
	DEC.32	D1

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.32	#0,D4
	MOVE.8	P7170+OP7170DAY,D4
	LIB	?BINBCD
	MOVE.8	D4,{A4+}
	DEC.32	D1

.ENDIF	COS20
.IF	SM196.OR.sm300.or.sm130
	MOVE.32	_IndShi, A0
	CALL	{A0}+_ReadClock

	TEST.32	D1
	JUMP,EQ	 R8^L80$
	MOVE.8	D3,{A4+}	; mmorise les secondes
	DEC.32	D1
	JUMP,EQ	 R8^L80$

	SWAP.16	D3
	MOVE.8	D3,{A4+}	; mmorise les minutes
	SWAP.16	D3
	DEC.32	D1

	JUMP,EQ	 R8^L80$
	SWAP.32	D3
	MOVE.8	D3,{A4+}	; mmorise les heures
	SWAP.32	D3
	DEC.32	D1


	JUMP,EQ	 R8^L80$
	SWAP.32	D3
	SWAP.16	D3
	MOVE.8	D3,{A4+}	; mmorise la date
	SWAP.16	D3
	SWAP.32	D3
	DEC.32	D1

	JUMP,EQ	 R8^L80$
	MOVE.8	D4,{A4+}	; mmorise le mois
	DEC.32	D1

	JUMP,EQ	 R8^L80$
	SWAP.16	D4
	MOVE.8	D4,{A4+}	; mmorise l'anne
	SWAP.16	D4
	DEC.32	D1

	JUMP,EQ	 R8^L80$
	SWAP.32	D4
	MOVE.8	D4,{A4+}	; mmorise le jour de la semaine
	SWAP.32	D4
	DEC.32	D1

.ENDIF	SM196.OR.sm300.or.sm130


	TEST.32	D1		; reste qq chose  lire ?
	JUMP,EQ	 R8^L80$	; non (ok) => 80$
	MOVE.16	#EROUTF,D7	; oui => erreur
L80$:
	SUB.32	D1,D5		; D5 <-- nb de bytes lus

	POPM.32	D3|D4|A0|A4
	RET

.ENDIF	SM196.OR.sm300.or.sm130




; Calcul du jour de la semaine
; ----------------------------



;--------\\
; CALCJS  >
;========/

; Calcul le jour de la semaine en fonction d'une date
; quelconque comprise dans le 20me sicle.
; Pour cela, calcul le nombre de jour depuis une date de
; rfrence fixe le 01/01/1900 (c'tait un dimanche).

; in	A4.L	^jour-mois-anne en BCD
; out	D4.B	jour de la semaine 1..7 ou -1 si erreur
; mod	D4.L

CALCJS:
	CALL	CALCNJ		; D4 <-- nb jours depuis rf.
	COMP.32	#-1,D4		; erreur ?
	JUMP,EQ	L92$		; oui => 90$
	DIV.16	#7,D4		; divise par nb jour/semaine
	SWAP.32	D4		; D4 <-- reste de la division
	TEST.8	D4		; dimanche ?
	JUMP,NE	 R8^L90$	; non => 90$
	MOVE.8	#7,D4		; oui => 7
L90$:
	COMP.8	#FSIECLE,{A4}+2	; 21me siecle
	JUMP,HS	L92$		; non => 92$

	DEC.8	D4
	JUMP,NE	L92$		; Dimanche ? non => 92$
	MOVE.8	#7,D4

L92$:
	RET





;--------\\
; CALCNJ  >
;========/

; Calcul le nombre de jours depuis une date de rfrence
; fixe le 01/01/1900.

; in	A4.L	^jour-mois-anne en BCD
; out	D4.L	nombre de jours (-1 si erreur)
; mod	D4.L

CALCNJ:
	PUSHM.32 D0|D1|D2|D3|A0

	CLR.32	D4
	MOVE.32	#-1,D0		; D0 <-- signal date fausse
	CALL	CALCJX		; D3 <-- 28..31 (0 si erreur)
	TEST.8	D3		; mois correct ?
	JUMP,EQ	L80$		; non => 80$
	MOVE.8	{A4}+0,D4	; D4 <-- jour (BCD)
	CALL	CONVAB		; D4 <-- jour (binaire)
	TEST.8	D4
	JUMP,EQ	L80$
	COMP.8	D3,D4		; date correcte ?
	JUMP,HI	L80$		; non => 80$
				; oui =>
	DEC.8	D4		; D4 <-- 0..n
	MOVE.32	D4,D0		; D0 <-- nb jour depuis rf.

	MOVE.8	{A4}+2,D4	; D4 <-- anne (BCD)
	CALL	CONVAB		; D4 <-- anne (binaire)
	MOVE.8	#00,D3		; D3 <-- anne de rfrence
	MOVE.8	#-1,D2		; D2 <-- compteur bissextile
L10$:
	INC.8	D2
	COMP.8	D4,D3
	JUMP,HS	 R8^L20$
	ADD.32	#365,D0		; D0 <-- ajoute une anne
	INC.8	D3		; D3 <-- anne suivante
	AND.8	#2'11,D2	; anne bissextile ?
	JUMP,NE	L10$		; non => 10$
	INC.32	D0		; oui => un jour de plus
	JUMP	L10$

L20$:
	MOVE.8	{A4}+1,D4	; D4 <-- mois (BCD)
	CALL	CONVAB		; D4 <-- mois (binaire)
	MOVE.8	#01,D3		; D3 <-- mois de rfrence
	MOVE.32	#R16^TAMOI1,A0
L30$:
	COMP.8	D4,D3
	JUMP,HS	 R8^L80$
	INC.8	D3		; D3 <-- mois suivant
	CLR.32	D1
	MOVE.8	{A0+},D1	; D1 <-- nb jours ce mois
	COMP.8	#28,D1		; fvrier ?
	JUMP,NE	 R8^L35$	; non => 35$
	AND.8	#2'11,D2	; anne bissextile ?
	JUMP,NE	 R8^L35$	; non => 35$
	INC.8	D1		; D1 <-- 29 jours
L35$:
	ADD.32	D1,D0		; D0 <-- ajoute un mois
	JUMP	L30$

L80$:
	MOVE.32	D0,D4		; D4 <-- nb jours ou -1

	POPM.32	D0|D1|D2|D3|A0
	RET


;--------\\
; CALCJX  >
;========/

; Calcul le nombre de jours dans un mois en tenant compte des
; mois  28, 29, 30 et 31 jours.

; in	A4.L	^jour-mois-anne en BCD
; out	D3.B	jour max 28..31 (0 si erreur)
; mod	D3.B

CALCJX:
	PUSHM.32 D4|A0

	CLR.8	D3		; D3 <-- signal une erreur
	MOVE.8	{A4}+1,D4	; D4 <-- mois (BCD)
	CALL	CONVAB		; D4 <-- mois (binaire)
	TEST.8	D4
	JUMP,EQ	 R8^L90$
	COMP.8	#31,D4		; mois 1..31 ?
	JUMP,HI	 R8^L90$	; non => 90$ (avec D3=zro)

	MOVE.32	#R16^TAMOIS,A0	; A0 <-- ^table
	MOVE.8	{A0}+A16^{D4},D3; D3 <-- 28, 30 ou 31
	COMP.8	#28,D3		; fvrier ?
	JUMP,NE	 R8^L90$	; non => 90$
				; oui =>
	MOVE.8	{A4}+2,D4	; D4 <-- anne (BCD)
	CALL	CONVAB		; D4 <-- anne (binaire)
	DIV.16	#4,D4
	SWAP.32	D4		; D4 <-- reste
	TEST.16	D4		; anne bissextile ?
	JUMP,NE	 R8^L90$	; non => 90$
	INC.8	D3		; oui => 29 jours
L90$:
	POPM.32	D4|A0
	RET


TAMOIS:
	.8	0		;  0 = rien du tout
TAMOI1:	.8	31		;  1 = janvier
	.8	28		;  2 = fvrier
	.8	31		;  3 = mars
	.8	30		;  4 = avril
	.8	31		;  5 = mai
	.8	30		;  6 = juin
	.8	31		;  7 = juillet
	.8	31		;  8 = aot
	.8	30		;  9 = septembre
	.8	31		; 10 = octobre
	.8	30		; 11 = novembre
	.8	31		; 12 = dcembre
	.EVEN 



;--------\\
; CONVAB  >
;========/

; Converti BCD --> binaire.

; in	D4.B	byte BCD
; out	D4.B	idem en binaire
; mod	D4.B

CONVAB:
	PUSH.32	D3

	CLR.16	D3
	MOVE.8	D4,D3
	SR.8	#4,D3		; D3 <-- dizaines
	MUL.16	#10,D3
	AND.8	#16'0F,D4	; D4 <-- units
	ADD.8	D3,D4		; D4 <-- units + dizaines

	POP.32	D3
	RET




	.IF	SM8.or.SM100.or.SM324

; Routines de bases
; -----------------



;--------\\
; WRDATA  >
;========/

; in	D3.B	data (2 digits)
;	D4.B	registre (REG...)
; out	-
; mod	-

WRDATA:
	PUSHM.32 D0|D3|D4

.IF	SM324

	PUSH.32	A0
	MOVE.32	#{A6}+BUFFPPI,A0
	CALL	READPPI
	AND.16	#16'0F,D4
	MOVE.8	D3,{A0}+A16^{D4}
	CALL	WRITEPPI
	POP.32	A0

.ENDIF	SM324
.IF	SM100.or.SM8

	.IF	SM100
	TCLR.8	VIA0+OVPCR:#BCCLK
	.ELSE 
	TCLR.8	PAB55+1:#BCLK
	.ENDIF 

	.IF	SM100
	TSET.8	VIA0+OVPA:#BCDIO ; mode "write"
	TSET.8	VIA0+OVDDRA:#BCDIO ; mode "write"
	TCLR.8	VIA0+OVPA:#BCCS	; slectionne le chip
	.ELSE 
	TSET.8	PAB55+1:#BCS	; slectionne le chip
	.ENDIF 
	CALL	U14

	CALL	WRADR		; crit le numro de registre

	.IF	SM100
	TCLR.8	VIA0+OVPA:#BCDIO
	.ELSE 
	TCLR.8	PAB55+1:#BDOUT	; mode "write"
	.ENDIF 
	.IF	SM100
	TSET.8	VIA0+OVPCR:#BCCLK ; clock up
	.ELSE 
	TSET.8	PAB55+1:#BCLK	; clock up
	.ENDIF 
	CALL	U14
	.IF	SM100
	TCLR.8	VIA0+OVPCR:#BCCLK ; clock down
	.ELSE 
	TCLR.8	PAB55+1:#BCLK	; clock down
	.ENDIF 
	CALL	U14

	CALL	WR2DIG		; crit le contenu du registre

	.IF	SM100
	TSET.8	VIA0+OVPA:#BCCS	; d-slect chip
	.ELSE 
	TCLR.8	PAB55+1:#BCS	; d-slectionne le chip
	.ENDIF


.ENDIF	; SM100.or.SM8

	POPM.32	D0|D3|D4
	RET



;--------\\
; RDDATA  >
;========/

; in	D4.B	registre (REG...)
; out	D3.B	data (2 digits)
; mod	D3.B

RDDATA:
	TEST.8	{A6}+FLAG	; pas de pile
	JUMP,EQ	L1$		; oui => RDDATA1
	JUMP	RDDATA1


.IF	SM324

L1$:
	PUSHM.32 D4|A0
	MOVE.32	#{A6}+BUFFPPI,A0
	CALL	READPPI
	AND.16	#16'0F,D4
	MOVE.8	{A0}+A16^{D4},D3
	POPM.32	D4|A0
	RET

.ELSE	SM324


L1$:	PUSHM.32 D0|D1|D4

	.IF	SM100
	TCLR.8	VIA0+OVPCR:#BCCLK
	.ELSE 
	TCLR.8	PAB55+1:#BCLK
	.ENDIF 

	.IF	SM100
	TCLR.8	VIA0+OVPA:#BCCS	; slectionne chip
	.ELSE 
	TSET.8	PAB55+1:#BCS	; slectionne le chip
	.ENDIF 
	CALL	U14

	CALL	WRADR		; crit le numro de registre

	.IF	SM100
	TCLR.8	VIA0+OVDDRA:#BCDIO ; mode "read"
	.ELSE 
	TSET.8	PAB55+1:#BDOUT	; mode "read"
	.ENDIF 
	.IF	SM100
	TSET.8	VIA0+OVPCR:#BCCLK ; clock up
	.ELSE 
	TSET.8	PAB55+1:#BCLK	; clock up
	.ENDIF 
	CALL	U14
	.IF	SM100
	TCLR.8	VIA0+OVPCR:#BCCLK ; clock down
	.ELSE 
	TCLR.8	PAB55+1:#BCLK	; clock down
	.ENDIF 
	CALL	U14

	CALL	RD2DIG		; D3 <-- byte BCD lu

	.IF	SM100
	TSET.8	VIA0+OVPA:#BCCS	; d-slect chip
	.ELSE 
	TCLR.8	PAB55+1:#BCS	; d-slectionne le chip
	.ENDIF 

	POPM.32	D0|D1|D4
	RET


.ENDIF	; ELSE SM324


RDDATA1:
	COMP.8	#REGSEC,D4
	JUMP,EQ	SEC$
	COMP.8	#REGMIN,D4
	JUMP,EQ	MIN$
	COMP.8	#REGHOUR,D4
	JUMP,EQ	HOUR$
	COMP.8	#REGDATE,D4
	JUMP,EQ	DATE$
	COMP.8	#REGMON,D4
	JUMP,EQ	MON$
	COMP.8	#REGYEAR,D4
	JUMP,EQ	YEAR$
	COMP.8	#REGDAY,D4
	JUMP,EQ	DAY$

	MON	?AFTIM
	.ASCIZE	"Err. fatale dans le driver $CLOCK<CR><CR>"
	TRAP	#0


SEC$:	MOVE.8	{A6}+OSEC,D3
	RET

MIN$:	MOVE.8	{A6}+OMIN,D3
	RET

HOUR$:	MOVE.8	{A6}+OHOUR,D3
	RET

DATE$:	MOVE.8	{A6}+ODATE,D3
	RET

MON$:	MOVE.8	{A6}+OMON,D3
	RET

YEAR$:	MOVE.8	{A6}+OYEAR,D3
	RET

DAY$:	MOVE.8	{A6}+DAY,D3
	RET



.IF	SM324
.ELSE

;--------\\
; WRADR   >
;--------/

; in	D4.B	adresse  envoyer (3 bits)
; out	-
; mod	D0.B, D4.B

WRADR:
	MOVE.16	#3-1,D0		; D0 <-- dcompteur de bits
	SL.8	#8-3,D4
L10$:
	.IF	SM100
	TCLR.8	VIA0+OVPA:#BCDIO
	TSET.8	VIA0+OVDDRA:#BCDIO	;BB????? NECESSAIRE A CET ENDROIT ? oui, merci
	.ELSE 
	TCLR.8	PAB55+1:#BDOUT
	.ENDIF 
	SL.8	#1,D4
	JUMP,CC	 R8^L20$
	.IF	SM100
	TSET.8	VIA0+OVPA:#BCDIO
	.ELSE 
	TSET.8	PAB55+1:#BDOUT
	.ENDIF 
L20$:
	.IF	SM100
	TSET.8	VIA0+OVPCR:#BCCLK ; clock up
	.ELSE 
	TSET.8	PAB55+1:#BCLK	; clock up
	.ENDIF 
	CALL	U14
	.IF	SM100
	TCLR.8	VIA0+OVPCR:#BCCLK ; clock down
	.ELSE 
	TCLR.8	PAB55+1:#BCLK	; clock down
	.ENDIF 
	CALL	U14

	DJ.16,NMO   D0,L10$
	RET



;--------\\
; WR2DIG  >
;--------/

; in	D3.B	2 digits BCD  envoyer
; out	-
; mod	D0.B, D3.B

WR2DIG:
	MOVE.16	#8-1,D0		; D0 <-- dcompteur de bits
L10$:
	.IF	SM100
	TCLR.8	VIA0+OVPA:#BCDIO
	.ELSE 
	TCLR.8	PAB55+1:#BDOUT
	.ENDIF 
	SL.8	#1,D3
	JUMP,CC	 R8^L20$
	.IF	SM100
	TSET.8	VIA0+OVPA:#BCDIO
	.ELSE 
	TSET.8	PAB55+1:#BDOUT
	.ENDIF 
L20$:
	.IF	SM100
	TSET.8	VIA0+OVPCR:#BCCLK ; clock up
	.ELSE 
	TSET.8	PAB55+1:#BCLK	; clock up
	.ENDIF 
	CALL	U14
	.IF	SM100
	TCLR.8	VIA0+OVPCR:#BCCLK ; clock down
	.ELSE 
	TCLR.8	PAB55+1:#BCLK	; clock down
	.ENDIF 
	CALL	U14

	DJ.16,NMO   D0,L10$
	RET


;--------\\
; RD2DIG  >
;--------/

; in	-
; out	D3.B	2 digits BCD lus
; mod	D0.B, D1.B, D3.B

RD2DIG:
	.IF	SM100
	TCLR.8	VIA0+OVDDRA:#BCDIO ; DIO=input
	.ENDIF 
	MOVE.16	#8-1,D0		; D0 <-- dcompteur de bits
L20$:
	.IF	SM100
	TSET.8	VIA0+OVPCR:#BCCLK ; clock up
	.ELSE 
	TSET.8	PAB55+1:#BCLK	; clock up
	.ENDIF 
	CALL	U14

	.IF	SM100
	MOVE.8	VIA0+OVPA,D1
	SR.8	#BCDIO+1,D1	; X  <-- un bit lu
	.ELSE 
	MOVE.16	PAC55,D1	; D1 <-- un bit lu
	SR.16	#2,D1		; X  <-- un bit lu
	.ENDIF 
	RRX.8	#1,D3		; D3 <-- un bit data de plus

	.IF	SM100
	TCLR.8	VIA0+OVPCR:#BCCLK ; clock down
	.ELSE 
	TCLR.8	PAB55+1:#BCLK	; clock down
	.ENDIF 
	CALL	U14

	DJ.16,NMO   D0,L20$
	.IF	SM100
	TSET.8	VIA0+OVDDRA:#BCDIO ; DOUT=output	;DR??? BB: ICI ?
	.ENDIF 
	RET



;--------\\
; U14     >
;--------/

; in	-
; out	-
; mod	-

U14:
	PUSH.32	D3
	MOVE.16	#10'17,D3; D3 <-- delai de 14 us
L10$:	DJ.16,NMO   D3,L10$
	POP.32	D3
	RET


.ENDIF	.not.SM324
.ENDIF	; SM8.or.SM100.or.SM324

;------\\
; BCD?  >
;======/

; regardre si D0 est un nombre BCD

; in	D0.8	nombre
; out	D5.16	<>0 => pas de nombre BCD
;		=0  => nombre BCD
; mod 	D5.16

BCD?:	PUSHM.32 D0|D1|D5
	CLR.16	D5
	MOVE.8	D0,D1
	AND.8	#16'0F,D1
	COMP.8	#16'9,D1
	JUMP,LS	L1$
	INC.16	D5

L1$:	MOVE.8	D0,D1
	AND.8	#16'F0,D1
	COMP.8	#16'90,D1
	JUMP,LS	L2$
	INC.16	D5

L2$:	TEST.16	D5

	POPM.32	D0|D1|D5
	RET



.IF	SIMUL



;--------------------------------------------------

; Processus fils


NFILS:	.ASCIZE	"CLOCK_INC"

PFILS:
	MON	?AFTIM
	.ASCIZE	" ** INC ** "
	MOVE.32	#10'50,D4
	NTREL	?DELMS
	CALL	INCSEC
	TEST.8	{A6}+FABORT
	JUMP,EQ	PFILS

	NTREL	?ABORT

INCSEC:	MOVE.8	{A6}+OSEC,D4
	MOVE.8	#0,D1
	SETX
	ADDX.D8	D1,D4
	COMP.8	#16'60,D4
	JUMP,NE	L1$
	CLR.8	{A6}+OSEC
	CALL	INCMIN
	RET

L1$:	MOVE.8	D4,{A6}+OSEC
	RET


INCMIN:	MOVE.8	{A6}+OMIN,D4
	MOVE.8	#0,D1
	SETX
	ADDX.D8	D1,D4
	COMP.8	#16'60,D4
	JUMP,NE	L1$
	CLR.8	{A6}+OMIN
	CALL	INCHOUR
	RET

L1$:	MOVE.8	D4,{A6}+OMIN
	RET


INCHOUR:
	MOVE.8	{A6}+OHOUR,D4
	MOVE.8	#0,D1
	SETX
	ADDX.D8	D1,D4
	COMP.8	#16'24,D4
	JUMP,NE	L1$
	CLR.8	{A6}+OHOUR
	CALL	INCDATE
	RET

L1$:	MOVE.8	D4,{A6}+OHOUR
	RET

INCDATE:
	MOVE.32	#{A6}+ODATE,A4
	CALL	CALCJX1
	CLR.8	D1
	SETX
	ADDX.D8	D1,D3
	MOVE.8	{A6}+ODATE,D4
	SETX
	ADDX.D8	D1,D4
	COMP.8	D3,D4
	JUMP,NE	L1$
	MOVE.8	#1,{A6}+ODATE
	CALL	INCMON
	RET

L1$:	MOVE.8	D4,{A6}+ODATE
	RET


INCMON:	MOVE.8	{A6}+OMON,D4
	MOVE.8	#0,D1
	SETX
	ADDX.D8	D1,D4
	COMP.8	#16'13,D4
	JUMP,NE	L1$
	MOVE.8	#1,{A6}+OMON
	CALL	INCYEAR
	RET

L1$:	MOVE.8	D4,{A6}+OMON
	RET

INCYEAR:
	MOVE.8	{A6}+OYEAR,D4
	MOVE.8	#0,D1
	SETX
	ADDX.D8	D1,D4
	MOVE.8	D4,{A6}+OYEAR
	RET



;---------\\
; CALCJX1  >
;=========/

; Calcul le nombre de jours dans un mois en tenant compte des
; mois  28, 29, 30 et 31 jours.

; in	A4.L	^jour-mois-anne en BCD
; out	D3.B	jour max 28..31 (0 si erreur)
; mod	D3.B

CALCJX1:
	PUSHM.32 D1|D4|A0

	CLR.8	D3		; D3 <-- signal une erreur
	MOVE.8	{A4}+1,D4	; D4 <-- mois (BCD)
	CALL	CONVAB		; D4 <-- mois (binaire)
	TEST.8	D4
	JUMP,EQ	 R8^L90$
	COMP.8	#31,D4		; mois 1..31 ?
	JUMP,HI	 R8^L90$	; non => 90$ (avec D3=zro)

	MOVE.32	#R16^TAMOIS2,A0
	AND.32	#16'FF,D4
	MOVE.8	{A0}+A16^{D4},D3; D3 <-- 28, 30 ou 31
	COMP.8	#16'28,D3	; fvrier ?
	JUMP,NE	 R8^L90$	; non => 90$
				; oui =>
	MOVE.8	{A4}+2,D4	; D4 <-- anne (BCD)
	CALL	CONVAB		; D4 <-- anne (binaire)
	DIV.16	#4,D4
	SWAP.32	D4		; D4 <-- reste
	TEST.16	D4		; anne bissextile ?
	JUMP,NE	 R8^L90$	; non => 90$
	CLR.8	D1		; oui => 29 jours
	SETX
	ADDX.D8	D1,D3

L90$:	POPM.32	D1|D4|A0
	RET


TAMOIS2:
	.8	0		;  0 = rien du tout
	.8	16'31		;  1 = janvier
	.8	16'28		;  2 = fvrier
	.8	16'31		;  3 = mars
	.8	16'30		;  4 = avril
	.8	16'31		;  5 = mai
	.8	16'30		;  6 = juin
	.8	16'31		;  7 = juillet
	.8	16'31		;  8 = aot
	.8	16'30		;  9 = septembre
	.8	16'31		; 10 = octobre
	.8	16'30		; 11 = novembre
	.8	16'31		; 12 = dcembre
	.EVEN 



CREFILS:
	MON	?AFTIM
	.ASCIZE	" ** CREFILS ** "
	MOVE.16	#0,D4
	NTREL	?CRESEM
	MOVE.32	A5,{A6}+PSEMA

	MON	?AFTIM
	.ASCIZE	" ** CRESEM ** "

	CLR.8	{A6}+FABORT

	MOVE.32	#500,D5
	MOVE.32	#R16^PFILS,A5
	MOVE.32	#R16^NFILS,A3
	NTREL	?GETPRIO
	AND.32	#16'1F,D4
	TSET.32	D4:#BTSIAB
	MOVE.32	{A6}+PSEMA,A2
	NTREL	?CRETASK
	MON	?AFTIM
	.ASCIZE	" ** END CREFILS **"
	RET

.ENDIF	SIMUL


	.IF	SM324
;-----------\\
;  READPPI   >
;===========/

; in	A0		^zone mmoire
;	A6		^VAR
; out	{A0}+REG...	zone
; mod	?

READPPI:
	PUSHM.32 D0..D4|D7|A5

	MOVE.32	A0,{A6}+OADRDPPI	; init ad. buffer pour inter rd-ppi

	MOVE.32	#16'02000000,D0
	CLR.32	D1
	CLR.32	D2
	CLR.16	D3
	MOVE.8	#PPIHORLO,D4

	MOVE.32	32^_INDSHI,A5
	CALL	{A5}+_SENDPPI

	MOVE.16	#-1,D4			; met timeout infini
	NTREL	?MODTIM

	MOVE.32	{A6}+OSEMAPPI,A5
	NTREL	?WAITEV

	NTREL	?SETTIM

	POPM.32	D0..D4|D7|A5
	RET




; WRITEPPI
;
; in	A0		^zone mmoire remplie (REG...)
; out	-
; mod	?


WRITEPPI:
	PUSHM.32 D0..D4|D7|A5

	MOVE.32	#16'00030000,D0		; set & read horloge
	MOVE.16	{A0+},D0		; (read comme acknowledge de write)
	SL.32	#8,D0
	MOVE.8	{A0+},D0
	MOVE.32	{A0+},D1
	CLR.32	D2
	CLR.16	D3
	MOVE.8	#PPIHORLO,D4
	MOVE.32	32^_INDSHI,A5
	CALL	{A5}+_SENDPPI

	MOVE.16	#-1,D4
	NTREL	?MODTIM			; met timeout infini

	MOVE.32	#{A6}+OBUFWRRDPPI,A0
	MOVE.32	A0,{A6}+OADRDPPI	; init ad. buffer pour inter rd-ppi
	MOVE.32	{A6}+OSEMAPPI,A5
.IF	FALSE
	CALL	32^_SYSWAITEV
.ELSE
	NTREL	?WAITEV
.ENDIF	FALSE

	NTREL	?SETTIM
	POPM.32	D0..D4|D7|A5
	RET




;----------\\
; CLKINTER  >
;==========/

; Routine d'interruption pour la lecture du PPI

; In	VAR+OADRDPPI	^buffer
;	A0		^variables
;	D0..D2:		message du PPI
; Out	{VAR+OADRDPPI}	donnes de l'horloge
; Mod	D0..D3,D7,A0,A1

CLKINTER:
;;;	PUSHM.32 D0..D3|A0|A1		; Sauvetage par le SHI

; in	D0.32:	<sec><min><hr><date>
;	D1.32:	<mois><jr.sem><anne><X>

	MOVE.32	{A0}+OADRDPPI,A1	; A1 <-- ^o crire
	MOVE.32	D0,{A1+}
	SR.32	#8,D1
	SWAP.32	D1
	MOVE.8	D1,{A1+}
	SWAP.32	D1
	MOVE.16	D1,{A1+}

	MOVE.32	{A0}+OSEMAPPI,A1	; A1 <-- ^smaphore
	CALL	A16^_ISSIGNEV		; dbloque processus read
L90$:
;;;	POPM.32	D0..D3|A0|A1		; sauvetage par SHI
	RET				; retour au SHI

	.ENDIF 	SM324


.IF	SM100
	.IDENT	"(SM100)  (C) B. BRUNNER, M. WALZ et EPSITEC-system sa"
.ENDIF	SM100
.IF	SM324
	.IDENT	"(SM324)  (C) B. BRUNNER, M. WALZ et EPSITEC-system sa"
.ENDIF	SM324
.IF	SM8
	.IDENT	"(SM8)  (C) B. BRUNNER, M. WALZ et EPSITEC-system sa"
.ENDIF	SM8
.IF	COS20
	.IDENT	"(COS)  (C) B. BRUNNER, M. WALZ et EPSITEC-system sa"
.ENDIF	COS20
.IF	SM196
	.IDENT	"(SM196) (C) B. BRUNNER, M. WALZ, J-F GRUET et EPSITEC-system sa"
.ENDIF	SM196
.IF	SM300
	.IDENT	"(SM300) (C) B. BRUNNER, M. WALZ, J-F GRUET et EPSITEC-system sa"
.ENDIF	SM300
.IF	SM130
	.IDENT	"(SM130) (C) B. BRUNNER, M. WALZ, J-F GRUET et EPSITEC-system sa"
.ENDIF	SM130
	.END
