\define g_Fond:\nef11;
\define g_Evidence:\nbf09;
; $erh: dis

	.TITLE	\g_Evidence;DIS.ASD\g_Fond;

;	--------------------------------------------------------
;	  Copyright (C) 1994-96  Daniel MARMIER & EPSITEC SA
;	  Copyright (C) 1994-98  Pierre ARNAUD & EPSITEC SA
;	--------------------------------------------------------

; Certaines parties sont tires de versions prcdentes dues  la somme
; des talents de MM D. Roux, M. Walz, J-F. Gruet et P. Arnaud.

	.PROC	M68020

	.REF	SM130HARD


DISREV	= 10					; rvision
DISVERS	= 10					; version

	.REV	DISREV,DISVERS
	.CODE	0,0,0,0,0,0,0,0,0,0,0
	.IDENT	"(C) 1994-98  Daniel MARMIER, Pierre ARNAUD & EPSITEC SA"
	.START	0


; Date	    Rev	 Amliorations
; ------------------------------------------------------------------------------
; 13.03.98 10.10 PA: Verrouille les accs  MONSEL pour viter les problmes 
;		     l'installation des fentres.
; 14.02.98 10.9  DD: Smaphore d'exclusion spcifique pour LOADGC
; 03.10.97 10.8  PA: Verrouille GRA2 pendant une commutation de fentre.
;		     Messages EvPixmapShow pour SMA_SMAKY en 3 phases.
; 06.06.97 10.7  PA: Nouvelle commande ScrDefPixSwap pour aider SMA_SMAKY.
; 04.06.97 10.6  PA: Petite modification du processus PixSwapUpdate.
; 17.05.97 10.5  PA: Mcanisme "PixSwapUpdate" mis en place pour carte Alpine.
;		     Ncessite GRA2 9.3 pour corriger ODFABS/CAB/IIY aprs coup.
; 21.03.97 10.4  PA: Utilise ODFPIXORG pour spcifier le mode prfrentiel de la
;		     carte graphique (TRUE => [BGRx], FALSE => [xRGB]).
; 07.03.97 10.3  PA: Time-out infini pour ENDOFFERBAR.
; 15.02.97 10.2  PA: Nouveau champ odfISM (silent mouse) pour SMA_SMAKY/MOUSE.
;		     Remise en service des mcanismes de grabbing de GRA2.
; 08.02.97 10.1  PA: Zone d'exclusion spare pour les commandes.
; 05.11.96 10.0  DM: Report des modifs de la version 9.8 de PA.
; 01.06.96  9.9  DM: Initialise descripteurs avec ^fonctions de dessin.
; 13.05.96  9.8  DM: Commande "S" pour trouver nouveaux display managers.
;		     Tentative de dmarrage sur chaque display manager.
; 19.04.96  9.7  PA: Corrige bug de la profondeur copie de $DIS_x -> $DIS_0.
;		     Commandes "#" et "|" pour slectionner le curseur bloc/fin.
; 11.05.95  9.6  PA: Ne charge plus XCAR du tout. Le XCAR_OPEN sera automatique.
; 09.05.95  9.5  DM: Origine/dimensions $DIS_0 correctes aprs commutation.
; 05.05.95  9.4  PA: Ne charge plus ni GRAMISC, ni GRA (nouveau LIB).
; 03.05.95  9.3  DM: COLORPUSH/POP fonctionnent en monochrome.
;		     Passage du descripteur dans les vnements.
;		     Mise  jour meilleure de $DIS_0  la commutation.
; 20.04,95  9.2  DM: Correction pour cran  fond non blanc.
;		     KILL restaure les dimensions originales avant l'EOP.
;		     Dclench mode modulo par dfaut.
; 31.03.95  9.1  PA: Supprim appels  ODFGRBEF/ODFGRAFT de WRITE.
; 19.03.95  9.0  DM: Utilise les dimensions par dfaut du DM pour le(s)
;		     pixmap(s) des mini-fentres et le mode prfrentiel.
;		     Correction des positions des mini-fentres.
;		 PA: Correction de KILLGC.
; 25.02.95  8.9  DM: Gestion du curseur lors du dessin.
;		     DRAWMATRIX passe par GRA2_RASTER.
;		     DRAWMATRIX modifiait A3 !
;		     Mise  jour des flags de la fentre lors d'une commutation.
; 24.01.95  8.8  DM: DIS n'utilise plus la CLUT globale de TCOLOR, mais gre
;		      lui-mme les CLUTs par dfaut pour chaque profondeur.
;		     Ajout CLUT par dfaut pour 2 et 8 bits/pixel.
;		     N'utilise plus TCOL_ACTIVE.
;		     Correction $DIS_7/x, o x > 16/17.
;		     Utilise la CLUT de %M_SYSTEM(_%L,).CRET par dfaut.
;		     Accde aux gencars par #:(GENC:,).
; 16.01.95  8.7	 DM: Complt UpdateDesc, nettoyage, supprim $DIS_7/8.
;		     Fentres : 1..8 : grandes, 9..17 : mini.
;		     Les mini-fentres s'adaptent dynamiquement aux dimensions
;		      par dfaut du display manager 0.
; 13.01.95  8.6  PA: Ajout oPDACT dans les variables globales.
;		     Tient  jour le canal TCOLOR actif dans $DIS_0.
; 12.12.94  8.5  DM: Correction chargement de la CLUT par dfaut.
;		     Ajout commande pour spcifier dimensions de SMA_SMAKY.
;		     Evnements par BAR remplacent le mcanisme primitif  BAL.
; 20.11.94  8.4  DM: Correction ODFIY/X & ODFIDY/X : MOUSE ne bipe plus.
; 17.08.94  8.3  DM: Report des modifs de PA.
;		     Utilisation de la librairie MONSEL.
; 15.08.94  8.2  DM: Essaie d'utiliser le fichier d'infos sur les modes vido.
; 12.08.94  8.1  PA: DM_Open a chang d'interface.
; 15.07.94  8.0	 DM: Nouveau source pour Smaky 130 couleur.
;		     READ : supprim lecture de pixels horiz/vert.
;		     Supprim choses relatives aux fentres doubles.
;		     Gestion couleur reprise du pilote pour Smaky 300.
;		     Rcrit SAVWDO/GETWDO pour toutes profondeurs 2^k.
;		     Supprim tout ce qui concernait le lutin souris.
;		     Renumrot les fentres (1..6|9|10 : grandes,
;		      7|8 : SMA_SMAKY, 11..18 : petites).
;		     Plus de commande SCRBITMAP : il faut envoyer un SCRCENTRE
;		       la fentre  centrer.
;		     Utilise le pilote HWDIS.
;		     Refait gestion des pixmaps.
;		     Supprim gestion des soft-keys (SMA_SMAKY s'en occupe).
;		     Ajout rvision/version dans les headers de pilotes
;		      (utilis provisoirement par LIB ?PDUMP).
;		     Mis provisoirement IDLE dans une zone inoffensive
;		      (en attendant un nouveau pilote Z-net).
;		     Tient compte de la profondeur prfrentielle, exprime sous
;		      la forme de 4 nouveaux bits dans l'en-tte BX.
;		     Supprim la plupart des commandes (pour voir).
;		     Dans l'en-tte des logiciels (BX), 2 nouveaux bits permettent
;		      de supprimer les soft-keys ou la bande suprieure.
;		     Une mise en vidence de la petite fentre active par un
;		      cadre remplace les anciens "coins".
;		     Plus de commande "SCRCOIN", gestion faite par DIS
;		     Nouveau mcanisme pour les icnes : changements transmis par
;		      BAL  SMA_SMAKY


CheckCanalTCol	= False
KillRegions	= True		; Dtruit {A2}+ODFCRG


	.INS 	13C_DIS.ASSR


	.REF	COLORS
	.REF	GENCAR
	.REF	GRA2
	.REF	GRA
	.REF	GRAMISC
	.REF	RES
	.REF	TCOLOR
	.REF	XCAR
	.REF	MONSEL

	.REF	HWDIS
	.REF	DISPLAYMAN
	.REF	SYSTEM
	.REF	BIOSDRIV
	.REF	MON

	.REF	SMAKY

DEBUG = FALSE;.OR.TRUE

.MACRO dbug
  .IF DEBUG
	mon	?aftim
	.ASCIZE	%1
  .ENDIF DEBUG
.ENDMACRO

.MACRO dbtw ; "text", 16
  .IF DEBUG
	mon ?aftim
	.ascize %1
	push.16	d4
	move.16	%2,d4
	mon ?afx4, ?afspace
	pop.16	d4
  .ENDIF DEBUG
.ENDMACRO

.MACRO dbtl ; "text", 32
  .IF DEBUG
	Mon ?AfTIm
	.ASCIZE %1
	push.32	d4
	move.32	%2,d4
	Mon ?AfX8, ?AfSpace
	pop.32	d4
  .ENDIF DEBUG
.ENDMACRO

.MACRO dbcr
  .IF DEBUG
	Mon ?AfCR
  .ENDIF DEBUG
.ENDMACRO

.MACRO dbterr ; "texte"
  .IF DEBUG
	push.16	d4
	move.16	d7,d4
	Mon	?AfTIm
	.ASCIZE	%1
	Mon	?AfTIm
	.ASCIZE	", D7 = 0x"
	Mon	?AfX4,?AfCR
	move.16	d4,d7
	pop.16	d4
	test.16	d7
  .ENDIF DEBUG
.ENDMACRO

.macro wc
.localmacro ok
	TEST.32	{A2}+odfPDrawFuncs
	JUMP,F	R8^OK
	CALL	WaitClick
OK:
.endmacro



	.INS	DISDEF.ASI


;	Dbut du code proprement dit
;	----------------------------

	.LOC	0
DEBUT:
	.INS	DISHEADERS.ASI


; Points d'entres pour les routines de base
; ------------------------------------------


;--------\\
;  RESET  >
;========/

; in	A0.32	^base du driver
;	A2.32	^paramtres pour la fentre
; out	A6.32	^variables du pilote
; mod	D0..A1, D7.16

D0RESET:				; $DIS_0
	PUSHM.32 D2..D6|A2..A5

	MOVE.32	#LGVAR,D4		; D4 <-- longueur totale
	MOVE.32	#MTYPBD,D1		; D1 <-- type driver bios
	MOVE.32	A0,A1			; A1 <-- ^base du driver
	GESMEM	?GETMEM			; demande mmoire pour variables globales
	GESMEM	?CLEARMEM
	MOVE.32	A4,A6			; A6 <-- ^variables globales

; Init fonction de calcul des dimensions

	MOVE.32	#R16^DefaultGeomFunc,A4
	MOVE.32	A4,{A6}+oGeomFunc

; Init record d'vnements

	MOVE.32	#{A6}+oEventRec,A4
	MOVE.32	#EventRecSize,{A4}+oEvSize

; Charge le fichier de ressources pour le pilote cran

	MOVE.32	#2**BRSOPSYSTEM,D2	; D2 <-- ouverture systme
	MOVE.32	#RSKEYDisDriv,D3	; D3 <-- clef du binaire
	MOVE.32	#16'10000*SYSREV+SYSVERS,D4 ; D4 <-- rv./vers. du systme
	RES_	OPEN			; charge le fichier de ressource
	JUMP,NE	L90$			; erreur => fatal

	MOVE.32	A6,{A6}+OPTSELF		; <-- check pour debug externe
	MOVE.32	A2,{A6}+ORESCAN		; <-- canal des ressources

	MOVE.16	#RES_GET,D3
	LIB_	GETAD
	MOVE.32	A3,{A6}+OPTRESGET

	MOVE.16	#RES_GIVE,D3
	LIB_	GETAD
	MOVE.32	A3,{A6}+OPTRESGIVE

	MOVE.32	#R16^NmMonSel,A3
	MOVE.16	#MonSel_First,D3
	LIB_	OPEN			; charge le module de gestion des moniteurs
	JUMP,NE	L90$

	MOVE.32	#0,D2			; D2 <- mode
	MONSEL_	OPEN			; ouvre le module de gestion des moniteurs
	JUMP,NE	L90$
	MOVE.32	A2,{A6}+oChMonSel

	MOVE.32	#R16^NmTColor,A3	; ouvre le module de gestion
	MOVE.16	#TCol_First,D3		; des palettes de fausses couleurs.
	LIB_	OPEN
	JUMP,NE	L90$

; Il n'y a pas besoin de charger GRAMISC et GRA2, car LIB le fait automatiquement
; quand quelqu'un en a besoin.

	MOVE.32	#R16^NMGRA2,A3		; A3 <-- ^nom module graphique
	MOVE.16	#GRA2_FIRST,D3		; D3 <-- code du premier appel
	LIB_	OPEN			; charge le module GRA2
	JUMP,NE L90$

	MOVE.32	#{A6}+OADGRA,A1		; A1 <-- ^buffer pour les adresses
	MOVE.16	#GRA2_FIRST,D3		; D3 <-- premier code du module GRA2
	MOVE.16	#(GRA2_LAST-GRA2_FIRST+1)-1,D4

L20$:	LIB_	GETAD
	MOVE.32	A3,{A1+}		; mmorise l'adresse de la routine
	INC.16	D3			; D3 <-- code de l'appel GRA2 suivant
	DJ.16,NMO D4,L20$

	MOVE.32	#1,D4
	NTREL	?CRESEM			; cre smaphore d'exclusion
	MOVE.32	A5,{A6}+OSEMAX		; init ^smaphore

;	MOVE.32	#1,D4
	NTREL	?CRESEM			; cre smaphore d'exclusion des commandes
	MOVE.32	A5,{A6}+OSEMAXCMD	; init ^smaphore

;	MOVE.32	#1,D4
	NTREL	?CRESEM			; cre smaphore d'exclusion des commandes
	MOVE.32	A5,{A6}+oSemaLDGC	; init ^smaphore pour LAODGC (DD0298)

	MOVE.32	#R16^DEBUT,A1
	MOVE.32	A1,{A6}+OSTART

	FOS	?OPINFO			; A4 <-- ^infos
	JUMP,NE L90$
	MOVE.32	A4,{A6}+OPINFO		; mm. ^informations
	CLR.16	D4			; D4 <-- pas de mj.
	FOS	?CLINFO			; ferme les infos

;;;;	CALL	InitPrefMode		; initialise le mode prfrentiel
	CALL	StartDMPixSwapUpdate	; dmarre le processus "PixSwap"
	CALL	ScanDMs			; prend note des diffrents display managers prsents

	MOVE.16	{A6}+OCHHWD,D6		; D6 <- canal HWDIS
	MOVE.32	{A6}+oChDM0,A1		; A1 <- canal DisplayMan 0
	MOVE.32	#0,D2			; mode
	CALL	GetDMDefaults
	MOVE.32	D4,D3
	CALL	InitMisc

	CALL	OpenDesc		; A2 <-- ^descripteur de $DIS_0
	JUMP,NE	L90$

	MOVE.32	A2,{A6}+oPDACT		; pour le moment, $DIS_0 est actif

	MOVE.32	{A6}+oChDM0,A1		; A1 <- canal DisplayMan 0
	MOVE.32	#0,D2			; mode
	CALL	GetDMDefaults
	MOVE.32	D4,{A6}+oDefaultDims	; conserve les dimensions par dfaut
	MOVE.16	D3,{A6}+oDefaultDepth	; conserve la profondeur par dfaut
	MOVE.32	#1,D3			; 1er pixmap toujours 1 bit/pixel
	MOVE.32	D4,{A2}+ODFPDY
	MOVE.32	D4,{A2}+odfDY
;;;;	MOVE.16	{A6}+OCHHWD,D6		; D6 <- canal HWDIS
	CALL	DM_Open
	JUMP,NE	L90$

	MOVE.32	A1,{A2}+ODFCHDM		; mmorise canal display manager
	MOVE.8	D3,{A2}+ODFCNP		; init profondeur
	MOVE.32	A4,{A2}+ODFABS		; addr de base du pixmap
	MOVE.32	A4,{A2}+ODFCAB		; idem
	MOVE.16	D4,{A2}+ODFIIY		; rowbytes
	MOVE.32	D5,{A2}+ODFPMID		; ID de pixmap

	PUSHM.32 D4|A4
	MOVE.32	#0,D2			; D2 <- mode
;;;;	MOVE.32	A1,A1			; A1 <- canal display manager
;;;;	MOVE.16	{A6}+OCHHWD,D6		; D6 <- canal HWDIS
	CALL	DM_CursorFuncs		; demande les fonctions d'accs au curseur
	MOVE.32	{A4}+oDMCBegDraw,{A2}+odfBDraw
	MOVE.32	{A4}+oDMCEndDraw,{A2}+odfEDraw
	POPM.32	D4|A4

	MOVE.32	#{A6}+OTPMREC+(LenPmRec*8),A1
	MOVE.32	A4,{A1}+oPmAddress	; INIT ADR PIXMAP 8
	INC.8	{A1}+oPmCount		; une ouverture du pixmap 8
	MOVE.8	D3,{A1}+oPmDepth
	MOVE.16	D4,{A1}+oPmWidth
	MOVE.32	D5,{A1}+oPmID

	CALL	InitPrefMode
	CALL	InitDesc
	JUMP,NE	L90$

	CALL	CherPixmap
	MOVE.32	{A2}+odfCNb,{A5}+oPmColMode

; Initialisation du module GRA2

	GRA2_	SYSINIT			; initialise GRA2 et le descripteur $DIS_0
	JUMP,NE	L90$

	MOVE.32	{A2}+ODFCHDM,A1
;	MOVE.32	{A2}+ODFPMID,D5
;	MOVE.32	#0,D2
;	MOVE.16	{A6}+OCHHWD,D6		; D6 <- canal HWDIS
	CALL	DM_Show			; montre le pixmap

	CLR.8	D0			; D0 <-- fonte par dfaut
	CLR.32	D1			; D1 <-- style par dfaut
	CLR.8	D2			; D2 <-- taille par dfaut

	CALL	GCLOAD			; charge le gnrateur standard
	JUMP,NE	R8^L90$
	CALL	GCUSE			; {A2}++ <-- paramtres
	JUMP,NE	R8^L90$
L80$:
	CLR.16	D7			; D7 <-- ok
L90$:
	POPM.32	D2..D6|A2..A5
	TEST.16	D7
	RET


;-----------------------\\
;  StartDMPixSwapUpdate  >
;-----------------------/

; Dmarre le processus de surveillance de changement de pixmaps. Celui-
; ci met  jour les divers ^pixmap des divers descripteurs lorsqu'il y
; a des changements. Ceci permet de permuter le contenu de la mmoire
; cran avec la mmoire centrale pour avoir accs  plus de fentres.

StartDMPixSwapUpdate:
	PUSHM.32 D4|D5|A3|A4|A5

	MOVE.32	#0,D4
	MOVE.32	#R16^PixSwapUpdateName,A3
	NTREL	?CREBAR
	MOVE.32	A5,{A6}+oPSUBar

	MOVE.32	#10,D5
	MOVE.32	#R16^PixSwapUpdateProc,A5
;	MOVE.32	#R16^PixSwapUpdateName,A3
	MOVE.16	#2**BTDRIV+3,D4
	NTREL	?CRETASK
	MOVE.32	A4,{A6}+oPSUPID

	POPM.32	D4|D5|A3|A4|A5
	RET

PixSwapUpdateName:
	.ASCIZE	"$DIS:PixSwap"

PixSwapUpdateProc:
	MOVE.32	{A6}+oPSUBar,A5
	NTREL	?ACCEPTBAR
	PUSH.32	A4

; Traite le message reu en entre : un canal DM a chang et il faut
; mettre  jour les descripteurs de fentres.

	MOVE.32	{A4+},D4		; D4 <-- canal du display manager (interne  $HWDIS)
	MOVE.32	{A4+},D5		; D5 <-- ID du pixmap (unique)
	MOVE.32	{A4+},A3		; A3 <-- ^base du pixmap
	MOVE.32	{A4+},D6		; D6 <-- [iiy] du pixmap

	MOVE.32	#{A6}+OPDFEN,A0		; A0 <-- ^table des ^descripteurs
	MOVE.32	#MaxPDFen-1,D0		; D0 <--  nombre de ^descripteurs

LOOP$:	MOVE.32	{A0+},A1		; A1 <-- ^descripteur
;;	COMP.32	{A1}+odfChDM,D4		; mme display manager ?
;;	JUMP,NE	R8^NEXT$		; non => suite
	COMP.32	{A1}+odfPmId,D5		; mme pixmap ?
	JUMP,NE	R8^NEXT$		; non => suite

	MOVE.32	{A1}+odfABS,D1
	COMP.32	{A1}+odfCAB,D1		; l'application dessine-t-elle dans l'"cran" ?
	JUMP,EQ	R8^OK$			; oui => simple

; Zut - l'application dessine actuellement en mmoire en utilisant un
; descripteur de fentre officiel touill... Quand la restauration aura
; lieu (LIB?CLOBITMAP par exemple), odfABS sera cras.

	SET.8	{A1}+odfNEWSWAP		; signale  GRA2 qu'il y aura du travail !
	MOVE.32	A3,{A1}+odfNEWABS	; met la nouvelle adresse de base  restaurer
	MOVE.16	D6,{A1}+odfNEWIIY	; met la nouvelle largeur en bytes  restaurer
	JUMP	R8^NEXT$

OK$:	MOVE.32	A3,{A1}+odfABS		; change l'adresse de base
	MOVE.32	A3,{A1}+odfCAB		; idem
	MOVE.16	D6,{A1}+odfIIY		; change la largeur en bytes

NEXT$:	DJ.16,NMO D0,LOOP$

	POP.32	A4
	NTREL	?ENDACCEPTBAR
	JUMP	PixSwapUpdateProc


;----------\\
;  ScanDMs  >
;==========/

; Recherche les display managers prsents dans le systme.

; in	-
; out	D7.16	erreur
; mod	D7.16

ScanDMs:
	PUSHM.32 D0|D3|D4|D6|A0|A1|A2|A3|A4

	MOVE.16	{A6}+oChHWD,D6		; dja ouvert ?
	JUMP,NE	R8^Open$
	MOVE.32	#R16^NMHWDIS,A3
	MOVE.32	#2**BOPOPEN,D3
	FOS	?ARGSOPEN		; ouvre $HWDIS
	JUMP,NE	L90$
	MOVE.16	D6,{A6}+OCHHWD		; mmorise canal FOS HWDIS
Open$:

	MOVE.32	#lgHWStatDisRec,D4
	MOVE.32	#{A6}+OStatDisRec,A4
	FOS	?RSTATUS
	JUMP,NE	L90$

	MOVE.32	#4-1,D0			; 4 display managers
	MOVE.32	#{A6}+oChDM0,A1		; A1 <- ^table des canaux des display mangers
	MOVE.32	#{A6}+oPSUActiveDM0,A2	; A2 <- ^table des canaux avec PixSwapUpdate "activ"
	MOVE.32	A4,A0			; A0 <- ^records des display managers
LoopCopy$:
	MOVE.32	{A0}+oHWDisChannel,{A1+} ; copie les canaux dans la table
	JUMP,F	R8^Skip$		 ; pas de DM => saute
	TEST.32	{A2}			 ; dj PixSwapUpdate activ ?
	JUMP,T	R8^Skip$		 ; oui => saute

	PUSHM.32 D3|A1|A5
	MOVE.32	{A0}+oHWDisChannel,A1	; A1 <-- canal Display Manager
	MOVE.32	#cHWSPixSwapUpdate,D3	; D3 <-- type de message
	MOVE.32	{A6}+oPSUBar,A5		; A5 <-- ID de BAR pour les messages
;	MOVE.16	{A6}+OCHHWD,D6		; D6 <-- canal $HWDIS
	CALL	DM_Subscribe		; enregistre...
	MOVE.32	A1,{A2}
	POPM.32	D3|A1|A5

Skip$:	ADD.A16	#4,A2
	ADD.A16	#lgHWDisRec,A0
	DJ.16,NMO D0,LoopCopy$

L90$:	POPM.32	D0|D3|D4|D6|A0|A1|A2|A3|A4
	TEST.16	D7
	RET

; Enregistre la BAR passe en entre afin d'espionner les messages
; "Pixmap Swapped" diffuss par les display managers.

; in	A5.32	^BAR  souscrire (aide pour SMA_SMAKY)
; out	-
; mod	-

SubscribePixSwap:
	PUSHM.32 D0|D3|D6|D7|A0|A1

	MOVE.32	#4-1,D0			; 4 display managers
	MOVE.32	#{A6}+OStatDisRec,A0	; A0 <- ^records des display managers

Loop$:	TEST.32	{A0}+oHWDisChannel	; y a-t-il un display manager ?
	JUMP,F	R8^Skip$		; non => saute

	MOVE.32	{A0}+oHWDisChannel,A1	; A1 <-- canal Display Manager
	MOVE.32	#cHWSPixSwapUpdate,D3	; D3 <-- type de message
	MOVE.16	{A6}+OCHHWD,D6		; D6 <-- canal $HWDIS
	CALL	DM_Subscribe		; enregistre...

Skip$:	ADD.A16	#lgHWDisRec,A0
	DJ.16,NMO D0,Loop$

	POPM.32	D0|D3|D6|D7|A0|A1
	RET


;----------\\
;  DORESET  >
;==========/

; Appel lors de l'install des pilotes $DIS_1 .. $DIS_n

; in	A0.32	^base du driver
;	A2.32	^paramtres pour la fentre
; out	A6	^variables du pilote
; mod	D0,D1,A0,A1, D7.16

DORESET:
	PUSHM.32 D2..D4|A2..A5

	PUSH.32	A0
	MOVE.32	#R16^D0BASE,A0
	CLR.32	D0
	MOVE.32	_INDNTR,A1
	CALL	{A1}+OIN_GETDRIVVAR	; A6 <-- ^variables de $DIS_0
	POP.32	A0

	MOVE.32	{A6}+OSEMAX,A5		; A5 <-- ^smaphore
	CALL	LOCK			; dbut de zone critique

	PUSH.32	A2
	MOVE.32	{A6}+oChMonSel,A2	; A2 <- canal MONSEL
	MONSEL_	LOCK			; verrouille tout changement futur
	POP.32	A2

	MOVE.32	A2,A1			; A1 <-- ^paramtres
	CALL	OpenDesc		; A2 <-- ^descripteur
	JUMP,NE Done$

	MOVE.32	#0,D0
	MOVE.8	{A2}+odfNoW,D0		; D0 <- no fentre

	COMP.16	#FirstLittle,D0
	JUMP,LO	Big$
	MOVE.16	#ErDiOut,D7
	COMP.16	{A6}+oLastMini,D0
	JUMP,HI	GivDesc$

; petites fentres : on prend les dimensions du pixmap par dfaut,
; ----------------   et on force le monochrome

Small$:
	MOVE.32	{A6}+oDefaultDims,D4
	MOVE.32	D4,D3
	MOVE.32	#0,D2
	MOVE.8	{A2}+odfNoW,D2
;;;;	MOVE.32	D3,D3
	PUSH.32	D4
	CALL	GetBox			; D4, D3 <- position, dimensions
	POP.32	D4
	MOVE.32	D3,D0			; D0 <- dimensions fentre
	CALL	CheckDims		; OK ?
	JUMP,NE	GivDesc$

	MOVE.32	#1,D3			; monochrome pour petites fentres
	PUSH.32	A1
	MOVE.32	{A6}+oChDM0,A1		; A1 <- toujours canal de displayman 0
	CALL	OpePixmap
	POP.32	A1
	JUMP,NE	GivDesc$

	CLR.8	{A2}+odfPFlags
	JUMP	PixmapOK$

; grandes fentres
; ----------------
Big$:
; on commence par vrifier si les dimensions correspondent  une mini-fentre
; (DXMAX < 512 ou DYMAX < 384). Si oui, on retourne une erreur

	MOVE.16	#ErDiOut,D7
	COMP.16	#512,{A1}+oiDXMax
	JUMP,LO	GivDesc$
	COMP.16	#384,{A1}+oiDYMax
	JUMP,LO	GivDesc$

; on essaie maintenant les records proposs par MonSel ...

	MOVE.32	#{A1}+oiDXMIN,A3	; A3 <- ^dimensions min/max
	MOVE.32	#{A6}+oBufMonSel,A4	; A4 <- ^buffer pour record MonSel
	MOVE.32	#0,D2			; D2 <- mode
	MOVE.32	#-1,D3			; D3 <- compteur
LoopBig$:
	INC.32	D3
	PUSH.32	A2
	MOVE.32	{A6}+oChMonSel,A2	; A2 <- canal MonSel
	MonSel_	Info
	POP.32	A2
	JUMP,NE	GivDesc$

; essaie d'allouer un pixmap au format propos

	PUSHM.32 D3|A1
	MOVE.16	{A4}+oMonSelNum,D0
	MOVE.32	{A6}+A16^{D0}*4+oChDM0,A1
	MOVE.32	{A4}+oMonSelDX,D4
	SWAP.32	D4
	MOVE.32	#0,D3
	MOVE.16	{A4}+oMonSelDepth,D3
	CALL	OpePixmap
	POPM.32	D3|A1
	JUMP,NE	LoopBig$		; erreur => suivant

	MOVE.8	{A4}+oMonSelMode,{A2}+odfPFlags

PixmapOK$:

	MOVE.32	#0,{A2}+odfY
	MOVE.32	D4,{A2}+odfDY
	CALL	CorrDims		; corrige dimensions selon bandes sup et inf

	CALL	InitDesc
	JUMP,NE	Err$

CALL	CherPixmap
MOVE.32	{A2}+odfCNb,{A5}+oPmColMode

.IF 0 ; @PA 10/05/95
	COMP.8	#DisCLE,{A2}+odfNoW	; fentre du CLE ?
	JUMP,EQ	R8^NoXCAR$
	COMP.8	#DisBOOT,{A2}+odfNoW	; fentre du BOOT ?
	JUMP,EQ	R8^NoXCAR$

	CALL	GCMXCARLOAD		; charge le module XCAR si ncessaire
NoXCAR$:
.ENDIF 0 ; @PA 10/05/95

	CALL	GetGenc			; D0-D1-D2 <- gencar
	CALL	GCLOAD			; charge le gnrateur standard
	JUMP,NE	Err$
	CALL	GCUSE			; (A2)++ <-- paramtres
	JUMP,NE	Err$

	MOVE.32	{A2}+ODFC1Y,{A2}+ODFPY

	CLR.16	D7			; D7 <-- ok

Err$:	TEST.16	D7			; ok ?
	JUMP,EQ	R8^Done$		; oui => fini

	PUSH.16	D7
	CALL	CloPixmap		; libre le bitmap si ncessaire
	POP.16	D7
GivDesc$:
	PUSH.16	D7
	CALL	CloDesc			; rend le descripteur
	POP.16	D7

Done$:	PUSH.16	D7
	MOVE.32	{A6}+OSEMAX,A5		; A5 <-- ^smaphore
	NTREL	?Unlock			; fin de zone critique

	MOVE.32	{A6}+oChMonSel,A2	; A2 <- canal MONSEL
	MONSEL_	UNLOCK			; dverrouille...

	POP.16	D7
	POPM.32	D2..D4|A2..A5
;	TEST.16	D7
	RET



;-------\\
;  KILL  >
;=======/

; Deinstalle un pilote.

; in	A0.32	^base du driver
; out	-
; mod	D0,D1,A0,A1

DOKILL:
	PUSHM.32 A2|A5

	MOVE.32	{A6}+OSEMAX,A5		; A5 <-- ^smaphore
	CALL	LOCK			; dbut de zone critique

.if 0
push.32	d4
mon	?aftim
.ascize	"$DIS KILL A5="
move.32	a5,d4
mon	?afx8
mon	?aftim
.ascize	" D7="
move.16	d7,d4
mon	?afx4
pop.32	d4
.endif

	CALL	SRCDESC			; A2 <-- ^descripteur fentre

; pour que GriseEff porte sur toute la fentre, il faut
; changer la taille de la sous-fentre

	CLR.32	{A2}+odfFY		; origine sous-fentre
	MOVE.32	{A2}+odfDY,{A2}+odfFDY	; dimensions fentre
	CALL	WMINMAX

	CALL	GRISEEFF

	TEST.8	{A2}+ODFFLG:#BFIMAA	; image existe ?
	JUMP,BC	R8^NoImage$
	CALL	KILIMA			; oui => libre mmoire
NoImage$:
	CALL	WDOGET			; libre zone sauvetage fentre
	CALL	CLOPIXMAP		; libre le pixmap si ncessaire
	CALL	GCRESET			; supprime gencar(s) utilis(s)
	CALL	CLODESC			; libre le descripteur
	NTREL	?UNLOCK			; fin de zone critique

.if 0
push.32	d4
mon	?aftim
.ascize	", out A5="
move.32	a5,d4
mon	?afx8
mon	?aftim
.ascize	" D7="
move.16	d7,d4
mon	?afx4, ?afcr
pop.32	d4
.endif

	POPM.32	A2|A5
;	TEST.16	D7
	RET



;----------\\
;  COMMAND  >
;==========/

; in	A0.32	base du driver
;	A4.32	^table des commandes termine par zro
; out	D7.16	erreur
; mod	D0,D1,A0,A1, D7.16

DOCOMMAND:
	PUSHM.32 A2|A4|A5

	MOVE.32	{A6}+OSEMAXCMD,A5	; A5 <-- ^smaphore
	CALL	SRCDESC			; A2 <-- ^description fentre
	CALL	LOCK			; dbut de zone critique

	CLR.16	D7			; D7 <-- ok

Loop$:	TEST.8	{A4}			; fin de la table ?
	JUMP,EQ	R8^Done$

	CALL	WRONEC			; excute une commande
	TEST.16	D7			; commande ok ?
	JUMP,EQ	Loop$			; oui => continue

Done$:	PUSH.16	D7
	NTREL	?UNLOCK			; fin de zone critique
	POP.16	D7

	POPM.32	A2|A4|A5
;	TEST.16	D7
	RET



;----------\\
;  RSTATUS  >
;==========/

; in	A0.32	^base du driver
;	A4.32	^buffer
;	D4.32	longueur buffer
; out	D4.32	longueur rendue effectivement
;	D7.16	erreur
; mod	D0,D1,A0,A1, D4.32, D7.16

DORSTATUS:
	PUSHM.32 A2|A5

	MOVE.32	{A6}+OSEMAX,A5		; A5 <-- ^smaphore
	CALL	LOCK			; dbut de zone critique
	CALL	SRCDESC			; A2 <-- ^description fentre

	MOVE.32	A2,{A2}+ODFPST		; met le ^au status rel

	COMP.16	#4,D4			; profondeur = 4 ?
	JUMP,NE	R8^L10$			; non => 10$
					; oui =>
	MOVE.32	A2,{A4}			; rend juste le ^au status rel !
	CLR.16	D7			; D7 <-- ok
	JUMP	L90$

L10$:
	MOVE.32	#R16^L00$,A0
	CALL	32^_CNVLGS
	JUMP,NE	 R8^L90$

	MOVE.32	A4,A0			; A0 <-- ^buffer utilisateur
	MOVE.16	D4,D0
L20$:
	MOVE.8	{A2+},{A0+}		; transfre chez l'utilisateur
	DEC.16	D0
	JUMP,NE L20$
L90$:
	PUSH.16	D7
	NTREL	?UNLOCK			; fin de zone critique
	POP.16	D7

	POPM.32	A2|A5
	RET

L00$:					; table pour CNVLGS :
	.16	LGDIS0
	.16	LGDIS1
	.16	LGDIS2
	.16	LGDIS3
	.16	LGDIS4
	.16	LGDIS5
	.16	LGDIS6
	.16	LGDIS7
	.16	LGDIS8
	.16	LGDIS9
	.16	LGDIS10
	.16	0



;--------\\
;  WRITE  >
;========/

; in	A0.32	^base du driver
;	A4.32	^buffer texte
;	D5.32	lg maximale du texte
; out	D5.32	lg effectivement crite
;	D7.16	erreur
; mod	D7.16, D5.32

DOWRITE:
	PUSHM.32 D3|D4|D6|A2|A4|A5
	MOVE.32	{A6}+OSEMAX,A5		; A5 <-- ^smaphore
	CALL	LOCK			; dbut de zone critique
	CALL	SRCDESC			; A2 <-- ^description fentre
	CALL	CLRCURS			; enlve le curseur

	CLR.16	D6			; D6 <-- mm dernire erreur
	MOVE.32	D5,D4			; D4 <-- nb caractres  crire

Loop$:	MOVE.8	{A4+},D3		; D3 <-- caractre  afficher
	DEC.32	D4

	CALL	AFCAR			; "affiche" un caractre
	TEST.16	D7			; erreur lors du AFCAR ?
	JUMP,EQ	R8^L50$			; non => 50$
	JUMP,NS	R8^L40$			; si erreur grave => 40$
	TEST.16	D6			; dj mm. erreur grave ?
	JUMP,NS	R8^L50$			; oui => 50$
L40$:	MOVE.16	D7,D6			; D6 <-- dernire erreur
L50$:	TEST.32	D4
	JUMP,NE Loop$

	SUB.32	D4,D5			; D5 <-- nb caractres crits

	CALL	SETCURS			; remet le curseur
	NTREL	?UNLOCK			; fin de zone critique
	MOVE.16	D6,D7			; D7 <-- dernire erreur
EXIT$:	POPM.32	D3|D4|D6|A2|A4|A5
	RET



;-------\\
;  READ  >
;=======/

; in	A0.32	^base du driver
;	A4.32	^buffer texte
;	D5.32	lg  lire
; out	D5.32	lg effectivement lue
;	D7.16	erreur
; mod	D7.32, D5.32

DOREAD:
	PUSHM.32 D3|D4|A2..A5

	MOVE.32	{A6}+OSEMAX,A5		; A5 <-- ^smaphore
	CALL	LOCK			; dbut de zone critique
	CALL	SRCDESC			; A2 <-- ^description fentre

	MOVE.16	D5,D4			; D4 <-- lg  lire
	CLR.32	D5			; D5 <-- rien d'encore lu
	MOVE.16	#ERRDPR,D7		; D7 <-- read protected driver
	CALL	OPIMA?			; image alphanum. existe ?
	JUMP,NE L90$			; non => 90$ (erreur)

	MOVE.32	A4,A5			; A5 <-- ^o mettre les cars.
	CALL	GPTIMA			; A4 <-- ^dans image
	JUMP,NE L90$			; si hors => 90$

	MOVE.32	{A2}+ODFPIM,A3		; A3 <-- ^base de l'image
	MOVE.16	{A3}+OIMADX,D3
	MUL.16	{A3}+OIMADY,D3		; D3 <-- lg utile de l'image
	ADD.32	#LGIMA,D3		; D3 <-- ajoute les frais fixes
	ADD.32	D3,A3			; A3 <-- ^max  ne pas dpasser
	MOVE.16	#EROUTF,D7		; D7 <-- erreur si dpassement

L20$:	COMP.32	A3,A4			; image dpasse ?
	JUMP,HS L90$			; oui => 90$
	MOVE.8	{A4+},{A5+}		; buffer lecture <- image alpha
	INC.32	D5			; D5 <-- un car. lu de plus
	DEC.16	D4			; encore qq chose  lire ?
	JUMP,NE L20$			; oui => 20$
					; non =>
	CLR.16	D7			; D7 <-- ok

L90$:	PUSH.16	D7
	MOVE.32	{A6}+OSEMAX,A5		; A5 <-- ^smaphore
	NTREL	?UNLOCK			; fin de zone critique
	POP.16	D7

	POPM.32	D3|D4|A2..A5
	RET


	.INS	DISDESC.ASI

	.INS	DISCHR.ASI

	.INS	DISWDO.ASI

	.INS	DISGENC.ASI

	.INS	DISALPHA.ASI

	.INS	DISCMD.ASI

	.INS	DISPIXMAP.ASI

	.INS	DISCURS.ASI

	.INS	DISCOLOR.ASI

	.INS	DISDMINTF.ASI

	.INS	DISMISC.ASI

	.INS	DISDATA.ASI



	.END
