	.TITLE	SONIC_TEST.ASM

	.PROC		M68000
	.BASE		10		; base 10 par defaut
	.LAYOUT		HEX		; listing en hexadecimal

	.REF		SMAKY		; reference generale
	.REF		MON
	.REF		NTREL
	.REF		BIOSDRIV
	.REF		BIOS


MajRev		=	2		; revision majeure
MinRev		=	0		; revision mineure

; Le programme de test est  excuter sous smile

.REV		MajRev,MinRev


;changements:	-passe de mode 32 bits en mode 16 bit. Tout les acces au registres
;		du sonic doivent etre fait par des operations 16 bits.
;		-reecrit les routines d'initialisation et de desinitialisation
;		des interruptions.
;commentaires:	-adresse sonic souvent chargee dans A5 mais pas toujours utilisee.
;		-ne pas oublier remettre les ION et IOFF pour tourner en mode driver
;a faire:	- verifier que tout les points d'entree sauvent A5 et que toutes les
;		routines le chargent.
;		-ajouter une routine pour enlever des adresses physiques.
;		-faire des commandes standard 
;		-tester que le resultat est vraiment mis a zero s'il n y a pas d'erreur ({A4}+OPB_RES)
;a tester:
;		-lecture chainee
;		-ecriture chainee
;		-commande 'A' et autres commandes standard
; 1.0	RB	93/02/23	Modification pour adaptation S130
;		93/02/25	Interruption vectorise S130 + Autovectorise niveau 2
; 1.1	RB	93/03/08	Bug dans InitLCAM au Reset (+16'10 dans le code  la place de oCamEnable)
;				tstLCAM pour test DMA
; 1.2	RB	93/04/05	Suite des tests
; 1.3 ..1.8			Lgre adaptation pour tests
; 1.9	RB	93/08/09	Reprise, test plus complets
;				CAM complte initialise  chaque nouvelle adresse fournie
;				+ vrification sur le SONIC
;				+ possibilit d'enlever une adresse de la CAM (CM[adresse (6*.b)]
; 1.10	RB	93/08/11	Write avec chanage possible
;				Test interruption avec timer
; 1.11	RB	93/08/18	Lecture 
; 1.12	RB	93/08/20	Amlioration programme de test
; 1.13	RB	93/08/23	Idem Echo TxRx et RxTx
; 1.14	RB	93/08/24	Commande pour ne pas recevoir des adresses de la CAM (RE, RD)
; 1.15	RB	93/09/13	AfMon flag d'assemblage
;				Relit CAM en cas de CM
;
; 2.00	RB	96/07/05	Adaptation pour circuit DP83934
;
; Choix version Carte302/S130
;****************************
Carte302	=	false		; Carte avec 68302 du LTI (BB)
S130		=	true		; Carte pour S130 du LAMI (RB)
 Grafem		=	true		; Assemblage pour carte GRAFEM sur S130

;*************
; MODE TEST
;*************

TestSansSonic	= ?ASCOND ;	false		; test avec "registre" Sonic en RAM
TESTDRIV	=	true			; genere programme de test  la place d'un driver
.if	Testdriv
assmile	=	false ;true
.else
assmile	=	false
.endif
AfMon	=	true ;false			; affichage de message par moniteur
DEBUG	= 	FALSE			; commentaires de debug

; ** MODIFICATION 7.12.92, CHANGE IR7 POUR QU'IL SOIT FALSE, PH.
IR7		= 	FALSE		; installe la routine du nmi

	.IF	Carte302
	.REF		GCM302HARD
BUS16	=	true			; la carte 68302 a un bus de 16 bits
BUS32	=	false
	.endif
	.IF	S130
BUS16	=	false
BUS32	=	true			; le bus d'extension du s130 est sur 32 bits
	.endif


;**************
; Def APC
;**************

PC_code		=	0
PC_var		=	1
PC_record	=	2

	.APC	PC_code
	.LOC	0
	.APC	PC_var
	.LOC	0
	.APC	PC_record
	.LOC	0

;*****************
;  Def MACROS
;*****************
	.INS		MACROS.ASI

; Macro pour le programme de test inclus en fin du source

	.MACRO		CALLDRIV	; Appel Driver simule avec sauvetage des registres
	.localmacro	s
	PUSHM.32	D0..D6|A0..A6
	MOVE.32		R16^DRIVARPTR,A6	; Recupere ptr vars driver
;	SUP	
	CALL		%1
	jump,eq		r8^s
	pushm.32	a0|a1|d0|d1|d7
	push.32		d7
	lib	?aftim
	.ascize	"<CR>Erreur: "
	pop.32		d4
	lib	?afx8
	popm.32		a0|a1|d0|d1|d7
s:
;	USER
;	exit
	MOVE.32		#R16^DRIVARPTR,A0
	MOVE.32		A6,{A0}	
	POPM.32		D0..D6|A0..A6
	test.16		d7
	.ENDMACRO

; Mode User

	.MACRO		CALLDRIVU	; Appel Driver simule avec sauvetage des registres
	PUSHM.32	D0..D7|A0..A6
	MOVE.32		R16^DRIVARPTR,A6	; Recupere ptr vars driver
	CALL		%1
	MOVE.32		#R16^DRIVARPTR,A0
	MOVE.32		A6,{A0}	
	POPM.32		D0..D7|A0..A6
	test.16		d7
	.ENDMACRO


;************
; Constantes
;************

	.if	Carte302
AdSonic		=	16'F02000	; Adresse physique du Sonic
;n'existe plus ! AdReset		=	16'FFFC80	; Adresse du Ha
	.endif
	.if	S130
AdSonic		=	16'1C000000+2**29	; Mode non cacheable (A29=1)
	 .if	Grafem
	 .else
AdWrVect	=	16'1C002000+2**29	; Pour crire le vecteur d'interruption
VectSonic	=	16'C0			; A vrifier!!
	 .endif
AVectSonic	=	16'18+2			; Autovecteur 2
	.endif

AdPhys0		=	16'0606		; Adresse physique Ethernet par defaut, LSB
AdPhys1		=	16'0606		; Adresse physique Ethernet par defaut
AdPhys2		=	16'0303		; Adresse physique Ethernet par defaut, MSB
NbMaxCam	=	16		; Nombre maximum d'adresses multicast
NbMaxTDA	=	10		; Nombre max de TDA
LgMaxEth	=	1518+4		; Longueur maximale d'un paquet Ethernet
					; Plus 4 pour les debordement eventuels du chip Sonic
LgMinEth	=	64		; Longueur minimum d'un bloc Ethernet
NULL		=	0
NbMaxRdBuf	=	100		; Nombre max de descripteurs de ressources reception
LgAdrEth	=	6		; Longueur d'un adresse
EOL		=	1		; End Of List du sonic
TCRConfig	=	0		; Config registre TCR

	.if	BUS16
LgRxBuffer	=	LgMaxEth	; Longueur du buffer de reception. Doit etre LgMaxEth+2
					; en mode 32 bits.
	.endif
	.if	BUS32
LgRxBuffer	=	10'1524		; Longueur du buffer de reception. Doit etre LgMaxEth+2
					; en mode 32 bits.
	.endif

;******************
; Etats du Driver
;******************

CLOSED		=	1
IDLE		=	2

;************************
; Codes Erreur du Driver
;************************

NO_ERR		=	0
ERR_NO_INIT	=	1	; Attempt to use driver before it is initialised
DRV_OVER_CLOSE	=	2	; More closes than opens
ERR_EMPTY_BUF	=	3	; Buffer is empty
ERR_FRG_CNT	=	4	; Trop de fragments ( ou plus que 1 fragment pour read )
ERR_SIZE_BUF	=	5	; Buffer trop petit pour read ou write ou status
ERR_MAX_BUF	=	6	; Nombre de buffers en lecture maximum depasse
ERR_CMD_TYPE	=	7	; Commande Incorrecte
ERR_NB_CAM	=	8	; Nombre de descripteurs de CAM depasse
ERR_TX		=	9	; Erreur de Transmission
ERR_RX		=	10	; Erreur de Reception ( CRC ou Runt packet )
ERR_CAM_V	=	11	; Erreur lecture de CAM
ERR_CAM_WR	=	12	; Erreur d'criture de la CAM

;*********************
; Commandes du Driver
;*********************

MAC_LOOP	=	0	; Loopback au niveau du MAC
ENDEC_LOOP	=	1	; Loopback au niveau de l'ENDEC
TRANS_LOOP	=	2	; Loopback au niveau du Transceiver
LOOP_OFF	=	3	; Loopback Disable
PRMSC_ON	=	4	; Promiscuous Enable
PRMSC_OFF	=	5	; Promiscuous Disable
BROAD_ON	=	6	; Broadcast Enable
BROAD_OFF	=	7	; Broadcast Disable
ADD_MULTI	=	16'41	; Add MultiCast Adress (charactere A pour compatibilite Beuchat

	.INS		ASYNC.ASS	; Insere descripteur structure passage parametres
	.INS		SONIC_DEF.ASI	; Definition des registres internes du Sonic

;********************
; Structure Commande
;********************
; Commande sous forme de .16 :  modifier prochainement: c'est fait!! RB 93/08/10
; .asciz	

; Le champ TDA descripteur de packet en transmission est rallong pour contenir 
; des informations annexes utiles au driver


	.APC	PC_record
	.LOC	LgTxpktDescriptor
oTxPntPB:		.blk.32	1	; ^PB fourni en accs Write
oTxPntNextTDA:		.blk.32	1	; ^prochain TDA (idem link mais .32 et adresse connue)
oTxpntPrevTDA:		.blk.32	1	; ^TDA prcdent
oTxpntPrevTDAlink:	.blk.32	1	; ^TDA link prcdent (pour faciliter mise  0 EOL)
oTDAstatus:		.blk.8	1
 bTDAFree = 0
 bTDAInUse = 1
			.blk.8	3	; pour aligner
LgTxpktDescMod	=	APC

;*******************
; Variables driver
;*******************

; Cette zone doit tenir dans un unique bloc de 64k, ce qui limite le choix du nombre max
; de buffers en attente de READ. Cette zone doit de plus etre alignee au debut d'un bloc de 64k

	.APC	PC_record
	.LOC	0

	;; Stats block, returned by STATS command.
		
OS_REVISION:	.BLK.8	1	; Revision number of Driver
OS_VERSION:	.BLK.8	1	; Version number of Driver
OS_DRV_MEM:	.BLK.32	1	; Base Address of Driver variables
OS_TX_INT_C:	.BLK.32	1	; Count of Transmit Interruptions
OS_RX_INT_C:	.BLK.32	1	; Count of Receive Interruptions
OS_TX_FR_C:	.BLK.32	1	; Count of good frames transmitted
OS_TX_ERR:	.BLK.32	1	; Count of transmit errors
OS_TX_COL:	.BLK.32	1	; Count of collisions during transmissions
OS_RX_FR_C:	.BLK.32	1	; Count of good frames receives
OS_TX_BYTE_C:	.BLK.32	1	; Count of bytes transmitted (good frames)
OS_RX_BYTE_C:	.BLK.32	1	; Count of bytes received (good frames)
OS_BAD_CRC:	.BLK.32	1	; Count of receive CRC errors
OS_DEBUG1:	.BLK.32	1	; Miscelaneous counter for debugging purposes
OS_DEBUG2:	.BLK.32	1	; Miscelaneous counter for debugging purposes
OS_STATE:	.BLK.8	1	; State of driver
		.EVEN
oRdCAM:		.blk.16		3*NbMaxCam	; Place pour relire la CAM
STAT_MEM_LEN	=	APC

ODR_ETAT:	.BLK.8		1	; Etat du driver
		.align	4
ODR_TETE:	.BLK.32		1	; Tete de liste READ
ODR_QUEUE:	.BLK.32		1	; Queue de liste READ
ODW_TETE:	.BLK.32		1	; Tete de liste WRITE
ODW_QUEUE:	.BLK.32		1	; Queue de liste WRITE

DRIV_STATE:	.BLK.8		1	; Etat du driver
		.align	4
NBRD_BUF:	.BLK.16		1	; Nombre de buffers en attente lecture ( <NbMaxRdBuf )
ONbCamDesc:	.BLK.16		1	; Nombre de descripteurs de CAM
OAD_SONIC:	.BLK.32		1	; Adresse du SONIC
oSemTimer:	.blk.32		1	; Smaphore Timer Sonic (pour les tests interruptions)
oSemWaitTDAFree:.blk.32		1	; Smaphore d'attente TDA libr
oCntWaitTDAFree:.blk.32		1	; compteur d'attente de TDA libre
oPntTDANextFree:.blk.32		1	; ^prochain TDA libre
oTxPntFirstTDA:	.blk.32		1	; 1er TDA de la liste  transmettre
.if	TestSansSonic
oRegSonic:	.blk.8		16'40*FactSize	; registre fictifs pour Debug
.endif	TestSansSonic

	.align	4		; alignement 32 bits

;**************
; Champs SONIC
;**************
; Descripteurs en mmoire
;------------------------
; RRA:	Receive Ressource Area -> Pointe sur les RBA libres
; RDA:	Receive Descriptor Area
; RBA:	Receive Buffer Area
;
; TDA:	Transmit Descriptor Area
; TBA:	Transmit Buffer Area
;
; CDA:	CAM Descriptor Area: CAM: Content Access Memory
;
; Registres SONIC
;----------------
; UTDA, CTDA:	Current Transmit Descriptor Area pointer
; URDA, CRDA:	Current Receive Descriptor Area pointer
;
; URRA, RSA:	Ressource Start Area
; URRA, RRP:	Ressource Read Pointer
; URRA, RWP:	Ressource Write Pointer
; URRA, REA:	Ressource End Area
;
; URRA, CDP:	CAM Descriptor Pointer
;
;PH
; RB -> .8
; Attention  ne pas modifier l'ordre des variables

ORRAStart:	.BLK.8		LgRXrsrcDescriptor*NbMaxRdBuf	; Zone pour les descripteurs de buffers
oRRAEnd:
ORDAStart:	.BLK.8		LgRXpktDescriptor*NbMaxRdBuf	; Zone pour les descripteurs de paquet
oRDAEnd:
OTDAStart:	.BLK.8		LgTxpktDescMod*NbMaxTDA		; Zone pour stocker NbMaxTDA de taille maximale (16 fragments)
oTDAEnd:
OCAMStart:	.BLK.8		LgCam				; Zone pour stocker la table des CAM
oCAMEnd:

LgVarZone	=	APC	; Attention, doit etre < 64k ...!

	.if	LgVarZone.GT.65536
erreur LgVarZone > 64k
	.endif

;***************************
;* *********************** *
;* *   Debut du DRIVER   * *
;* *********************** *
;***************************


	.APC	PC_CODE


DEBUT:
	.16	10'0,S0BASE	; Pilote 0
;	.16	10'1,S0BASE	; Pilote 1
	.16	2**7		; fin 1ere indirection



; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $eth_0	No H'5A
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

S0ID:				; Adresse routines
	.16	S0OPEN-S0BASE
	.16	S0COMMAND-S0BASE
	.16	S0STATUS-S0BASE
	.16	S0READ-S0BASE
	.16	S0WRITE-S0BASE
	.16	S0CLOSE-S0BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1
	.16	-1			; S0AUX2-S0BASE
	.16	S0RESET-S0BASE
	.16	S0KILL-S0BASE
	.16	-1			; S0STRT-S0BASE
	.16	-1			; S0TSTRT-S0BASE
	.16	-1			; S0START-S0BASE

S0NAB:	.ASCII	"ETH_0"			; Nom driver
S0NAF:	.FILL.8 LGDNAM-(S0NAF-S0NAB),0

	.8	16'5A			; Numero driver
	.8	TYPIO			; Type: Streamer

	.8	MAJREV,MINREV		; Revision - version -
	.16	0			; - Variante

	.8	0			; Attribut 1
	.8	2**BDWROK.OR.2**BDRDOK	; Attribut 0
	.FILL.8 	LGDDESC-(APC-S0ID), 0	; Le reste.
S0BASE:

;***************************************************************************************
;--------\
; S0RESET >
;========/
;***************************************************************************************
;
; Appelle lors de l'INSTALL 
;
; In	A2.32	^ligne de parametres d'installation
; Out	A6.32	^variables globales du pilote
; Mod	rien
;D1|D2|A0|A3|A5
;

S0RESET:
.if	DEBUG
	WRITE_STR_C	ETH:Reset
.endif
	PUSHM.32	A5
	CALL		RequestMem		; Demande la memoire, initialise les variables
	jump,ne		f$
.if	TestSansSONIC
	move.32		#{a6}+oRegSonic,A5	; "Registres" en RAM
.else
	MOVE.32		#AdSonic,A5		; A5 pointe sur le Sonic (on prend la constante
						; lors de l'installation du driver. Permettrait
						; d'avoir plusieurs SONICs
.endif	TestSansSonic

	MOVE.32		A5,{A6}+OAD_SONIC	; Met a jour l'adresse du Sonic

	CALL		InitMEM			; Initialise zone CDA
	CALL		InitSonic
	CALL		InitSem			; Initialise smaphore
	jump,ne		f$
	CALL		InitInterrupt
	CALL		InitCAM			; Vide entre de CAM
.if 	IR7
	CALL		IRQ7_Install
.endif
	MOVE.8		#CLOSED,{A6}+DRIV_STATE	; Driver initialise, non ouvert
f$:
	POPM.32		A5
	test.16		d7
	RET


;-----------\
; RequestMem >
;===========/
;
; Demande la memoire necessaire et initialise les variables du programme principal
;
; In	
; Out	A6.32	^variables
; Mod
; RB Modif ClearMem et test erreur
RequestMem:
	PUSHM.32	D0|D1|D4|D5|A4|A5
;BUG	MOVE.32		#LgVarZone,D4		; Longueur zone variables et descripteurs
	MOVE.32		#16'10000,D4
	MOVE.32		#16'0,A4		; Adresse min du debut de la portion de memoire
	MOVE.32		#16'FFFFFE,A5		; Adresse max du debut de la portion de memoire
	MOVE.32		#16'10000,D5		; Modulo d'alignement (un seul 1)
	MOVE.16		#MTYPCP,D1		; Type
	GESMEM		?GETALMEM		; Adresse de la memoire allouee dans A4.32
	JUMP,ne		r8^f$

	MOVE.32		A4,A6			; A6 pointe sur la zone des variables
	gesmem		?clearmem
f$:
	POPM.32		D0|D1|D4|D5|A4|A5	; Recupere les registres
	test.16		d7
	RET



	

;***************************************************************************************
;-------\
; S0KILL >
;=======/
;***************************************************************************************
;
; Appelle lors du DEINSTALL 
;
; In	A6.32	^variables globales du pilote
; Out
; Mod	

S0KILL:
.if	DEBUG
	WRITE_STR_C	ETH:Kill
.endif
	PUSHM.32	A4|A5
	MOVE.32		{A6}+OAD_SONIC,A5	; Charge l'adresse du Sonic
	CALL		StopReceive		; Declenche le mode de reception du Sonic
	CALL		StopInterrupt		; Desactive la routine d'interruption
	MOVE.32		A6,A4
	MOVE.16		#MTYPCP,D1		; Type
	GESMEM		?GIVMEM			; Rend la memoire
	POPM.32		A4|A5
	RET



;***************************************************************************************
;----------\
; S0COMMAND >
;==========/
;***************************************************************************************
;
; Appelle lors de l'appel COMMAND
;
; In	A6.32	^variables globales du pilote
;	A4.32	^table de commande
; Out
; Mod	D7
;
; 		Commandes:

; LM LC MAC_LOOP	 Loopback au niveau du MAC (contrleur)
; LE LS	ENDEC_LOOP	 Loopback au niveau de l'ENDEC (srialisateur)
; LT	TRANS_LOOP	 Loopback au niveau du Transceiver
; LD	LOOP_OFF	 Loopback Disable
; PE			 Promiscuous Enable
; PD			 Promiscuous Disable
; BE			 Broadcast Enable
; BD			 Broadcast Disable
; A			 Add Address + 6*[xx.b]
; MC			 Add Multicast address + 6*[xx.b]
; ME			 Multicast Enable
; MD			 Multicast Disable
; RE			 Reject On Cam Match Enable
; RD			 Reject On Cam Match Disable
; CM			 Clear Multicast adresse (enlve une adresse multicast de la liste)
; ICAM			 Initialise variable CAM
; TCAM			 +param [xx.L] nombre d'essais

; Commandes: ( faire) (Intel)
; T[8.b]	test mmoire sur 8 bits (destructif)
; T[16.b]	test mmoire sur 16 bits (destructif)
; TP		test priphrique (destructif)



S0COMMAND:
.if	DEBUG
	WRITE_STR_C	ETH:Command
.endif
	PUSHM.32	A0|A3|A5
	move.32		a4,a3				; ^ligne de commande -> A3.32
	MOVE.32		{A6}+OAD_SONIC,A5		; Charge l'adresse du Sonic

	CLR.16		D7

	move.32		#r16^TCom,a0
	call		SearchCom
FINCOMM:
	POPM.32		A0|A3|A5
	TEST.16		D7
	RET

; Table des commandes format:
;; .ASCIZ "Commande"
;; .16	adresse_routine-APC
;;...
.32	0

TCom:
	.asciz		"A"
	.16		RSMC-APC			; Adresse locale
	.asciz		"MC"
	.16		RSMC-APC			; Adresse multicast
	.asciz		"CM"				; Enlve adresse de multicast
	.16		ClearMC-APC
	.asciz		"ME"
	.16		Multicast-APC			; multicast autoris
	.asciz		"MD"
	.16		NoMulticast-APC			; multicast interdit (rception)

	.asciz		"LM"
	.16		MacLoopback-APC			; Mode Loopback
	.asciz		"LC"
	.16		MacLoopback-APC			; Mode Loopback
	.asciz		"MAC_LOOP"
	.16		MacLoopback-APC			; Mode Loopback
	.asciz		"LE"
	.16		EndecLoopback-APC		; Mode Loopback
	.asciz		"LS"
	.16		EndecLoopback-APC		; Mode Loopback
	.asciz		"ENDEC_LOOP"
	.16		EndecLoopback-APC		; Mode Loopback
	.asciz		"LT"
	.16		TransceiverLoopback-APC		; Mode Loopback
	.asciz		"TRANS_LOOP"
	.16		TransceiverLoopback-APC		; Mode Loopback
	.asciz		"LD"
	.16		NoLoopback-APC			; Mode Loopback
	.asciz		"LOOP_OFF"
	.16		NoLoopback-APC			; Mode Loopback

	.asciz		"PE"
	.16		Promiscuious-APC		; Modif du mode promiscuous (prend tout)
	.asciz		"PD"
	.16		NoPromiscuious-APC		; Modif du mode promiscuous
	.asciz		"BE"
	.16		Broadcast-APC			; Modif du mode Broadcast (accepte broadcast)
	.asciz		"BD"
	.16		NoBroadcast-APC			; Modif du mode Broadcast (n'accepte plus broadcast)
	.asciz		"RE"
	.16		RejectOnCAMMatch-APC		; Reject On CAM Match Enable
	.asciz		"RD"
	.16		NoRejectOnCAMMatch-APC		; Reject On CAM Match Enable

; Tests
	.asciz		"ICAM"				; Initialise variable CAM
	.16		InitCAM-APC
	.asciz		"TCAM"				; +param [xx.L] nombre d'essais
	.16		TestCAM-APC
	.asciz		"TINT"				; Test interruption
	.16		TestInt-APC
	.32		0
	.even

;***************************************************************************************
;-------\
; S0AUX1 >
;=======/
;***************************************************************************************
;
; Commandes auxiliaires utilises pour le passage de commande de debug
;
; In	A6.32	^variables globales du pilote
;	A3.32	^ligne de commande
;	A4.32	^rponse
;	D4.32	longueur rponse
;	A5.32	^donnes pour driver
;	D5.32	longueur donnes
; Out	D7.16	erreur
;	D7.<31..16>	CB_Status: Status du bloc de commande
; Mod	A0|A1|D0|D1|D7
; Commandes:
;	A[xx.b][xx.b][xx.b][xx.b][xx.b][xx.b]	Adresse locale (6 octets) 
; ou	A[xxxx.w][xxxx.w][xxxx.w]
; ou	A[xxxx.w][xxxxxxxx.l]			
;	MC[xx.b][xx.b][xx.b][xx.b][xx.b][xx.b]	Donne des adresses de multicast


S0AUX1:
	pushm.32	a2|a3|a4|a5|d2

	move.32		#0,d7
	move.32		a4,a1			; ^rponse 		-> A1.32
	move.32		d4,d1
	move.32		a5,a2			; ^donnes pour driver	-> A2.32
	move.32		d5,d2
	MOVE.32		{A6}+OAD_SONIC,A5		; Charge l'adresse du Sonic

; Recherche de la commande

	move.32		#r16^Taux1,a0
	call		SearchCom
	popm.32		a2|a3|a4|a5|d2
	test.16		d7
	ret

TAUX1:
	.asciz		"A"
	.16		RSMC-APC			; Adresse locale
	.asciz		"MC"
	.16		RSMC-APC			; Adresse de multicast
	.32		0				; Fin table
	.even

;----------\
; SearchCom >
;==========/
;
; Recherche d'une commande dans la table et saute  la routine correspondante
; Effectue toutes les commandes de la liste
; S'arrte ds qu'une erreur est rencontre sur D7.16
;
; In	A3.32	^chane de commande
;	A0.32	^dbut table .ASCIZ .16	commande, adresse relative depuis position courante
;					table termine par 0, 0
; Out	A3.32	^aprs paramtres lus
;	D7<31..16>	D4.16 de la dernire routine appele
;	D7.16		D7.16 de la dernire routine appele
; Mod	selon routine sauf: A0, D0, D3, D4

SearchCom:
	pushm.32	d3|a0|d0|d4|A1|A2
	comp.32		#0,a3
	jump,eq		f$			; pas de commande
	move.32		a0,a1			; sauve ^dbut table de commandes possibles
loop$:
	call		SkipSep			; saute sparateur
	jump,ne		f$			; fin de ligne atteinte

ls$:
	call		CompString		; ^A0.32 = ^A3.32 ?
	jump,eq		comok$			; oui -> ok
	call		NextComPoss		; ^prochaine commande possible -> A0.32
	jump,eq		ls$			; et boucle
	move.16		#erillo,d7		; Commande incorrecte
f$:
	popm.32		d3|a0|d0|d4|A1|A2
	test.16		d7
	ret

; Recherche de la routine associe

comok$:
	move.16		{a0},d0			; offset routine
	push.32		a1
	call		{a0}+A16^{d0}		; et on saute  la routine
	pop.32		a1
	move.32		a1,a0			; rcupre ^table commandes possibles
	swap.32		d7
	move.16		d4,d7			; CB_Status -> 31..16 de D7
	swap.32		d7
	test.16		d7
	jump,eq		loop$
	jump		f$


;--------\
; SkipSep >
;========/
; saute les sparateurs de la ligne de commande
; In:	A3.32	^ligne de commande
; Out:	A3.32	^car commande autre que liste sparateur
;	SETZ	EQ: normal
;	CLRZ	NE: fin de ligne atteinte

SkipSep:
	pushm.32	a0|d0
l$:
	move.8		{a3},d0			; caractre source
	move.32		#r16^TablSep,a0		; ^table sp.
l1$:
	test.8		{a0}			; table toute parcourue
	jump,mi		r8^s$			; oui -> s$
	comp.8		{a0+},d0		; est-ce un sparateur ?
	jump,ne		l1$			; non-> va tester spar. possible suivant
	inc.32		a3			; oui-> avance sur ligne de commande 
	jump		l$			; et recommence
s$:
	; va voir si terminateur final

	move.32		#r16^TablTerm,a0	; table de terminateur
l2$:
	test.8		{a0}
	jump,mi		r8^f$			; table toute parcourue -> f$
	comp.8		{a0+},d0		; Est-ce un terminateur ?
	jump,ne		l2$			; non essaie le suivant

	popm.32		a0|d0		; terminateur
	CLRZ		
	ret

f$:
	popm.32		a0|d0		; pas de terminateur
	SETZ
	ret

TablSep:
	.8	TAB, SPACE, ",", -1
TablTerm:
	.8	CR, 0, -1
	.even

;-----------\
; CompString >
;===========/
;
; ^A0.32 = ^A3.32 ?
;
; In:	A0.32	^chane  trouver en entier
;	A3.32	^chane source
; Out:	A0.32	^offset routine si chane trouve, autrement ne change pas
;	A3.32	^aprs chane trouve (si trouve)
;	EQ	trouv
;	NE	pas trouv

CompString:
	pushm.32	a0|a3
l$:
	test.8	{a0}
	jump,eq	f$		; fin de chane  comparer -> trouv
	comp.8	{a0+},{a3+}
	jump,eq	l$
	popm.32	a0|a3		; pas trouv
	CLRZ			; pas trouv
	ret

f$:	inc.32	a0		; ^offset routine
	add.32	#2*4,A7		; ajuste le stack !!
	SETZ			; trouv
	ret


;------------\
; NextComPoss >
;============/
; Checrche prochaine commande possible
; In:	A0.32	^commande
; Out:	A0.32	^commande suivante
;	EQ	commande suivante existe
;	NE	plus de commande dans la liste	
; Mod	D0

NextComPoss:
	clr.16	d0
l$:
	test.8	{a0+}
	jump,ne	l$		; cherche fin de chane
	add.32	#2, A0		; saute offset routine 
	test.8	{a0}
	jump,ne	r8^f$		; fin de table
	not.16	d0
f$:
	test.16	d0
	ret

;-----\
; RSMC >
;=====/
;
; Met une entre multicast en mmoire CAM du SONIC
;
; In	A3.32	^adresse
; Out	A3.32	^aprs l'adresse
; Mod

RSMC:
;	move.32		#{a4}+oCmd_Type,A4	; ^commande
	call		RMC
	ret

;----\
; RMC >
;====/
;
; Ajoute une adresse de multicast a la liste
; A chaque nouvelle adresse, toute la table est recharge
; La table est chaque fois charge en entier (16 entres)
;
; In	A3.32	^adresse  rajouter (6 octets)
; Exemple	10:20:30:40:50:60    A4 ^10
;		Least          Most: 10 Reut en 1er sur le rseau
;		CAP0: 2010
;		CAP1: 4030
;		CAP2: 6050
; Out	D7.16	Erreur
; Mod	

RMC:
	PUSHM.32	D0|D1|D2|A0			; Sauve les registres
	call		SearchAdCAM
	jump,eq		ld$				; adresse dj dans la table -> recharge
	call		SearchFreeCAM			; entre libre, offset -> d2.32
	jump,ne		f$
	call		LoadAdCAM

; charge LCAM
ld$:
	call		LdCAM				; Charge la CAM
	jump,ne		f$
	call		VerifCAM			; Vrifie CAM
	move.32		#{a6}+oRdCAM,A0
	call		RdCAM				; Relit la CAM
F$:
	POPM.32		D0|D1|D2|A0			; Recupere les registres
	test.16		d7
	ret

;--------\
; ClearMC >
;========/
;
; Enlve une adresse de multicast a la liste
; La table est chaque fois charge en entier (16 entres)
;
; In	A3.32	^adresse  enlever (6 octets)
; Exemple	10:20:30:40:50:60    A4 ^10
;		Least          Most: 10 Reut en 1er sur le rseau
;		CAP0: 2010
;		CAP1: 4030
;		CAP2: 6050
; Out	D7.16	Erreur
; Mod	

ClearMC:
	PUSHM.32	D0|D1|D2|A0			; Sauve les registres
;;push.16	d7
;;lib	?aftim
;;.ascize	"<CR>ClearMC"
;;pop.16	d7
	call		SearchAdCAM
	move.32		#{a3}+6,a3			; ^aprs adresse
	jump,ne		f$				; pas trouv -> f$
	move.32		d0,d2
	mul.16		#LgCamDescriptor,d2		; offset
	call		UnLoadAdCAM

	; charge LCAM
ld$:
	call		LdCAM
	jump,ne		f$
	call		VerifCAM			; Vrifie CAM
	move.32		#{a6}+oRdCAM,A0
	call		RdCAM				; Relit la CAM
F$:
	POPM.32		D0|D1|D2|A0			; Recupere les registres
	ret

;----------\
; LoadAdCAM >
;==========/
; Met une adresse dans la table CAM en mmoire
;
; In	A3.32	^adresse
;	D0.16	no entre (0..NbMAxCAM-1)
;	D2.32	offset dans CAM
; Out:	A3.32	^aprs adresse
; Mod	-

LoadAdCAM:
	pushm.32	a0|d1
	MOVE.32		#{A6}+OCAMStart,A0		; dbut table CAM -> A0.32
	MOVE.8		{a3}+0,{A0}+32^{D2}+OCamAddressPort0+1	; Ecrit l'adresse en swappant
	MOVE.8		{a3}+1,{A0}+32^{D2}+OCamAddressPort0	; les bytes
	MOVE.8		{a3}+2,{A0}+32^{D2}+OCamAddressPort1+1
	MOVE.8		{a3}+3,{A0}+32^{D2}+OCamAddressPort1
	MOVE.8		{a3}+4,{A0}+32^{D2}+OCamAddressPort2+1
	MOVE.8		{a3}+5,{A0}+32^{D2}+OCamAddressPort2
	move.32		#{a3}+6,a3				; ^aprs adresse
	inc.16		{A6}+ONbCamDesc
	move.16		{a0}+oCAMEnable,d1
	tset.32		d1:d0
	move.16		d1,{a0}+oCAMEnable		; entre valide
	popm.32		a0|d1
	ret

;------------\
; UnLoadAdCAM >
;============/
; Enlve une adresse dans la table CAM en mmoire
;
; In	D0.16	no entre (0..NbMAxCAM-1)
;	D2.32	offset dans CAM
; Out:	-
; Mod	-

UnLoadAdCAM:
	pushm.32	a0|d1
	MOVE.32		#{A6}+OCAMStart,A0		; dbut table CAM -> A0.32
	MOVE.8		#0,{A0}+32^{D2}+OCamAddressPort0+1	; Ecrit l'adresse en swappant
	MOVE.8		#0,{A0}+32^{D2}+OCamAddressPort0	; les bytes
	MOVE.8		#0,{A0}+32^{D2}+OCamAddressPort1+1
	MOVE.8		#0,{A0}+32^{D2}+OCamAddressPort1
	MOVE.8		#0,{A0}+32^{D2}+OCamAddressPort2+1	
	MOVE.8		#0,{A0}+32^{D2}+OCamAddressPort2
	dec.16		{A6}+ONbCamDesc
	move.16		{a0}+oCAMEnable,d1
	tclr.32		d1:d0
	move.16		d1,{a0}+oCAMEnable		; entre invalide
	popm.32		a0|d1
	ret

;------\
; LdCAM >
;======/
;
; Charge la CAM
; In:	A5.32 ^adresse du Sonic
; Out:	D7.16	erreur

LdCAM:
	pushm.32	d0|d1|a0
	move.16		#NbMaxCAM,{A5}+SonicCDC		; Charge le CDC du Sonic (NbMaxCAM)
	MOVE.32		#{A6}+OCAMStart,A0		; dbut table CAM -> A0.32
	MOVE.16		A0,{A5}+SonicCDP		; dbut CAM -> SONIC
	MOVE.16		#2**bSonicLCAM,{A5}+SonicCR	; Envoie la commande LCAM

;*******************************************
;!!!!!! Attente active sur le Sonic !!!!!!!!
;*******************************************
.if	TestSansSonic
.else
	move.32		#100000,d1			; attente active limite !!
	move.16		#ERR_CAM_WR,d7			; erreur ventuelle
LCAM$:
	dec.32		d1
	jump,eq		r8^f$				; fin de l'attente -> f$ erreur
	MOVE.16		{A5}+SonicCR,D0			; on attend que l'operation se soit
	TEST.32		D0:#bSonicLCAM			; terminee pour eviter de mettre TXP
	JUMP,BS		LCAM$				; quand LCAM vaut encore 1 ->DeadLock
.endif	TestSansSonic
	MOVE.16		#2**bSonicLCD,{a5}+SonicISR	; Clear LCAM Done
	clr.16		d7
f$:
	popm.32		d0|d1|a0
	test.16		d7
	ret

;----------\
; VerifCAM  >
;==========/
; Vrifie le contenu de la CAM sur SONIC
; 
; In:	A5.32	^Sonic
;	A6.32	^variables
; Out:	D7.16	erreur

VerifCAM:
	pushm.32	d0|d1|d2|a0
	push.16		{a5}+SonicCR
	move.16		#2**bSonicRST,{a5}+SonicCR	; Reset Soft

	MOVE.32		#{A6}+OCAMStart,A0		; dbut table CAM -> A0.32
	move.16		{a0}+oCamEnable,d2		; Entre autorise -> d2.16

	move.32		#0,d0				; Index dans CAM
							; 0..15
l$:
;;	test.32		d2:d0				; test bit d0 de d1
;;	jump,bc		r8^fc$				; inactif -> suite
; Test de toute faon, mme si entre inactive

	move.16		d0,{a5}+SonicCEP		; slectionne l'entre  tester

	MOVE.16		{a5}+SonicCAP0,D1
	COMP.16		{A0}+OCamAddressPort0,D1	; COMPARE avec le contenu de la table CAM en RAM
	jump,ne		r8^fe$				; diffrent -> erreur
	MOVE.16		{a5}+SonicCAP1,D1
	COMP.16		{A0}+OCamAddressPort1,D1	; COMPARE avec le contenu de la table CAM en RAM
	jump,ne		r8^fe$				; diffrent -> erreur
	MOVE.16		{a5}+SonicCAP2,D1
	COMP.16		{A0}+OCamAddressPort2,D1	; COMPARE avec le contenu de la table CAM en RAM
	jump,ne		r8^fe$				; diffrent -> erreur

	; identique -> pas d'erreur passe au suivant
fc$:
	add.32		#LgCamDescriptor,a0		; ^descr suivant
	inc.32		d0				; index suivant
	comp.32		#NbMaxCam,d0
	jump,lo		l$

	; tout est bon
	clr.16		d7
f$:
	pop.16		{a5}+SonicCR
;;	clr.16		{a5}+SonicCR			; Enlve reset soft
	popm.32		d0|d1|d2|a0
	test.16		d7
	ret

	; erreur
fe$:
	move.16		#ERR_CAM_V,d7			; Erreur de vrification
	jump		f$

;------\
; RdCAM >
;======/
; Lecture de la CAM
; In:	A0.32	^O recopier la CAM

RdCAM:
	pushm.32	d0|d1|a0
	push.16		{a5}+SonicCR
	move.16		#2**bSonicRST,{a5}+SonicCR	; Reset Soft

	move.32		#0,d0				; Index dans CAM
							; 0..15
l$:
	move.16		d0,{a5}+SonicCEP		; slectionne l'entre  tester

	MOVE.16		{a5}+SonicCAP0,d1		; adresse LSB en premier
	rr.16		#8,d1
	move.16		d1,{a0+}
	MOVE.16		{a5}+SonicCAP1,d1
	rr.16		#8,d1
	move.16		d1,{a0+}
	MOVE.16		{a5}+SonicCAP2,d1
	rr.16		#8,d1
	move.16		d1,{a0+}

	; identique -> pas d'erreur passe au suivant
fc$:
	inc.32		d0				; index suivant
	comp.32		#NbMaxCam,d0
	jump,lo		l$

f$:
	pop.16		{a5}+SonicCR
;;	clr.16		{a5}+SonicCR			; Enlve reset soft
	popm.32		d0|d1|a0
	test.16		d7
	ret

;--------\
; InitCAM >
;========/
; Initialise les OCamEntryPointer
; + oCAMEnable
; In:	A5.32 ^adresse du Sonic

InitCAM:
	pushm.32	a0|d0
	clr.32		d0
	MOVE.32		#{A6}+OCAMStart,A0		; dbut table CAM -> A0.32
l$:
	MOVE.16		D0,{A0}+OCamEntryPointer	; Ecrit le CAM Entry Pointer
	move.16		#0,{a0}+OCamAddressPort0	; Efface CAM entry
	move.16		#0,{a0}+OCamAddressPort1
	move.16		#0,{a0}+OCamAddressPort2

	add.32		#LgCAMDescriptor,A0		; ^sur descr suivant
	inc.32		d0
	comp.16		#NbMaxCAM,d0
	jump,lo		l$
	move.16		#0,{a6}+oCAMStart+oCAMEnable	; Entres vides
	move.16		#0,{A6}+ONbCamDesc		; Pas d'adresses fournies
	popm.32		a0|d0
	ret

;-------------\
; SearchAdCAM  >
;=============/
; Recherche d'une adresse dans la CAM
; In:	A3.32	^adresse  trouver
; Out:	A0.32	^table CAM sur adresse trouve
;	D0.16	numro de l'entre dans la CAM
;	D7.16	0: trouv (EQ)
;		-1 pas trouv (NE)
	
SearchAdCAM:
	pushm.32	d1
	MOVE.32		#{A6}+OCAMStart,A0		; dbut table CAM -> A0.32
	MOVE.16		A0,{A5}+SonicCDP		; dbut CAM -> SONIC

	move.32		#0,d0				; Index dans CAM
							; 0..15
l$:
	MOVE.8		{a3}+0,D1
	COMP.8		{A0}+OCamAddressPort0+1,D1	; COMPARE l'adresse en swappant les bytes
	jump,ne		r8^fc$
	MOVE.8		{a3}+1,D1
	COMP.8		{A0}+OCamAddressPort0,D1	
	jump,ne		r8^fc$
	MOVE.8		{a3}+2,D1
	COMP.8		{A0}+OCamAddressPort1+1,D1	
	jump,ne		r8^fc$
	MOVE.8		{a3}+3,D1
	COMP.8		{A0}+OCamAddressPort1,D1	
	jump,ne		r8^fc$
	MOVE.8		{a3}+4,D1
	COMP.8		{A0}+OCamAddressPort2+1,D1	
	jump,ne		r8^fc$
	MOVE.8		{a3}+5,D1
	COMP.8		{A0}+OCamAddressPort2,D1	
	jump,ne		r8^fc$
; trouv
	clr.16		d7
f$:
	popm.32		d1
	test.16		d7
	ret

; pas trouv
fc$:
	add.32		#LgCamDescriptor,a0		; ^descr suivant
	inc.32		d0				; index suivant
	comp.32		#NbMaxCam,d0
	jump,lo		l$
	move.16		#-1,d7				; pas trouv
	jump		f$

;--------------\
; SearchFreeCAM >
;==============/
; In:	-
; Out:	D0.16	no CAM libre
;	D2.32	offset descripteur libre
;	D7.16	ER_NB_CAM plus de CAM libre

SearchFreeCAM:
	move.16		#ERR_NB_CAM,d7			; plus de CAM de libre
	move.16		{A6}+oCAMStart+oCAMEnable,d2	; entres valides
	comp.16		#16'FFFF,d2
	jump,eq		r8^f$
	clr.32		d0				; no CAM libre
l$:
	TEST.32		d2:d0
	jump,bc		t$
	inc.32		d0
	comp.16		#NbMaxCAM,d0
	jump,lo		l$
	jump		f$

; trouv
t$:
	move.32		d0,d2
	mul.16		#LgCamDescriptor,d2		; offset
	clr.16		d7
f$:
	test.16		d7
	ret

;-------\\
; TestCAM >
;========/
;
; Test du DMA en chargeant la CAM
; 
; In	A3.32	^commande: paramtre nombre d'essais
; Out	
; Mod	

TestCAM:
	push.32	d0
	move.32	{a3+},d0
l$:
	call	LdCAM
	call	VerifCAM
	jump,ne	fe$
	dec.32	d0
	jump,ne	l$
f$:
	pop.32	d0
	test.16	d7
	ret


fe$:
	pushm.32	a0|a1|d0|d1|d7
	mon	?aftim
	.ascize	"Erreur dans test CAM"
	popm.32	a0|a1|d0|d1|d7
	jump	f$

;--------\
; TestINT >
;========/
; Test d'interruption par Timer

TestINT:
	pushm.32	d0|d4|a5

	move.16		#0,{a5}+SonicWT1		; Initialise timer
	move.16		#16'100,{a5}+SonicWT0

	move.16		{a5}+SonicIMR,d0
	tset.32		d0:#bSonicTCEN			; autorise int timer
	move.16		d0,{a5}+SonicIMR

	move.16		#2**bSonicST,{a5}+SonicCR	; Start Timer

	move.32		#2*50,d4
	ntrel		?modtim
	push.32		a5
	move.32		{a6}+oSemTimer,a5
	ntrel		?waitev
	pop.32		a5

	move.16		{a5}+SonicIMR,d0
	tclr.32		d0:#bSonicTCEN			; enlve interrupt timer
	move.16		d0,{a5}+SonicIMR

	push.16		d7
	ntrel		?settim
	pop.16		d7
	popm.32		d0|d4|a5
	test.16		d7
	ret

;***************************************************************************************
;---------\
; S0STATUS >
;=========/
;***************************************************************************************
;
; Donne les status du driver 
;
; In	A6.32	^variables globales du pilote
;	A4.32	^buffer ou rendre les status
;	D4.16	longueur buffer ou mettre les status
; Out	D7	erreur
; Mod

S0STATUS:
.if	DEBUG
	WRITE_STR_C	ETH:Status
.endif
	PUSHM.32	D0|A0

	CLR.16		D7
	COMP.16		#STAT_MEM_LEN,D4
	JUMP,GE		r8^BUFOK$		; Le buffer est-il assez grand ?
	MOVE.16		#ERR_SIZE_BUF,D7
	JUMP		FIN$			; Si non, erreur buffer trop petit
BUFOK$:
	MOVE.16		#STAT_MEM_LEN,D4	; Longueur reelle buffer

	MOVE.8		{A6}+DRIV_STATE,D0
	MOVE.8		D0,{A6}+oS_STATE	; Recopie etat driver

	MOVE.32		#{A6}+OS_REVISION,A0	; A0 ^sur debut stats
	MOVE.16		#STAT_MEM_LEN-1,D0
BOU$:
	MOVE.8		{A0+},{A4+}		; Transfert dans buffer
	DJ.16,NMO 	D0,BOU$
FIN$:
	POPM.32		D0|A0
	RET


;***************************************************************************************
;-------\
; S0OPEN >
;=======/
;***************************************************************************************
;
; In	A6.32	^variables globales du pilote
; Out	D7.16	Erreur
; Mod

S0OPEN:
.if	DEBUG
	WRITE_STR_C	ETH:Open
.endif
;	pushm.32	a5
;	MOVE.32		{A6}+OAD_SONIC,A5		; Charge l'adresse du Sonic

	MOVE.8		#IDLE,{A6}+DRIV_STATE
;	popm.32		a5
	CLR.16		D7
	TEST.16		D7
	RET


;***************************************************************************************
;--------\
; S0CLOSE >
;========/
;***************************************************************************************
;
; Ferme le driver et supprime la liste des requetes en attente
;
; In	A6.32	^variables globales du pilote
; Out	D7.16	Erreur
; Mod

S0CLOSE:
.if	DEBUG
	WRITE_STR_C	ETH:Close
.endif

;	SUP
	IOFF
	MOVE.32		#NULL,{A6}+ODR_TETE	; Vide les listes
	MOVE.32		#NULL,{A6}+ODR_QUEUE
	MOVE.32		#NULL,{A6}+ODW_TETE
	MOVE.32		#NULL,{A6}+ODW_QUEUE
	MOVE.8		#CLOSED,{A6}+DRIV_STATE

;PH
	CALL		StopReceive		; evite d'appeler la routine
						; d'interruption a chaque packet broadcast
							
	ION
;	USER
	CLR.16		D7
	TEST.16		D7
	RET



;***************************************************************************************
;-------\
; S0READ >
;=======/
;***************************************************************************************
;
; 
;
; In	A6.32	^variables globales du pilote
;	A4.32	^descripteur des donnees PCB
;	D5.32	longueur descripteur ( ignore )
; Out	A4	PCB mis a jour
;	D7.16	Erreur
; Mod
;

S0READ:
.if	DEBUG
	WRITE_STR_C	ETH:Read
.endif
	PUSHM.32	D0|D1|A0|A1|A2|A5
	MOVE.32		{A6}+OAD_SONIC,A5		; Charge l'adresse du Sonic
	move.16		#-1,{A4}+OPB_RES		; descripteur utilis
	
; test divers

	COMP.8		#IDLE,{A6}+DRIV_STATE		; Driver ouvert ?
	JUMP,NE		ERR0$
	COMP.16		#1,{A4}+OPB_BUF_NB		; Nbre fragments trop grand ?		
	JUMP,HI		ERR1$
	COMP.16		#0,{A4}+OPB_BUF_NB
	JUMP,EQ		ERR3$
OK1$:
	COMP.32		#LgRXBuffer,{A4}+OPB_BUF_TAB	; Teste taille minimum
	JUMP,LO		ERR2$

	COMP.16		#NbMaxRdBuf-1,{A6}+NBRD_BUF	; Nombre maximal de buffers en lecture atteint?
	JUMP,HS		ERR4$

; paramtres d'entre correct

	INC.16		{A6}+NBRD_BUF		; Un buffer de plus en attente
	MOVE.32		#NULL,{A4}+OPB_NXT	; Dernier lment de la liste
;^^^^^^	
	IOFF	; Zone protegee car la manipulation des listes pourrait bloquer la routine interrupt

	COMP.32		#NULL,{A6}+ODR_TETE	
	JUMP,EQ		LIST_VID$		; Liste Vide ?

; Dj au moins 1 lment dans liste
; Il y en aura toujours au moins un car le sonic ne libre jamais le dernier RDA

	MOVE.32		{A6}+ODR_QUEUE,A2	; ^dernier PCB -> A2.32

	MOVE.32		{A2}+OPB_DRV,A1		; Recupere ptr sur dernier RDA -> A1.32
	MOVE.32		#{A1}+LgRXpktDescriptor,A0	; Nouvel RDA -> A0.32
	move.16		a0,d0
	COMP.16		#oRDAEnd,d0		; Fin zone RDA atteinte ?
	JUMP,LO		r8^NFRDA$
	MOVE.32		#{A6}+ORDAStart,A0	; Si oui, remet ptr au debut de la zone
NFRDA$:
	CALL		ADD_RD_PKT		; Met a jour les listes RDA et RRA du SONIC

	MOVE.32		A4,{A2}+OPB_NXT		; Ce PCB devient next_element du dernier PCB
	MOVE.32		A4,{A6}+ODR_QUEUE	; Ce PCB devient  son tour le dernier element	

	MOVE.16		{A5}+SonicISR,D0	; Teste le bit RBE.
	TEST.32		D0:#bSonicRBE
	JUMP,BC		r8^s0$

; Reset le bit RBE si on etait out of buffer	
.if debug
	WRITE_4NUM	D0
	WRITE_STR_C	Receive buffers exhausted resetting RBE bit
.endif
	MOVE.16		#2**bSonicRBE,{A5}+SonicISR
	move.16		{a5}+SonicRRP,D0
	move.16		{a5}+SonicRWp,D0
;	jump		testbug$
WAIT_RBE$:
;	move.16		#16'BABE,D0
;	move.16		{a5}+SonicRRP,D0
;	move.16		{a5}+SonicRWp,D0
testbug$:
;	MOVE.16		{A5}+SonicISR,D0
;	TEST.32		D0:#bSonicRBE
;	JUMP,BS		WAIT_RBE$

s0$:
	MOVE.16		{A5}+SonicISR,D0	; Teste le bit RDE.
	TEST.32		D0:#bSonicRDE
	JUMP,BC		FIN$
.if debug
	WRITE_4NUM	D0
	WRITE_STR_C	RDA exhausted resetting RDE bit
.endif
	MOVE.16		#2**bSonicRDE,{A5}+SonicISR
	JUMP		FIN$			; On laisse la routine d'interrupt terminer le travail

; 1er accs en lecture
;*********************
LIST_VID$:
	call		StopReceive		; Etre sure de ne rien recevoir
	MOVE.32		A4,{A6}+ODR_TETE
	MOVE.32		A4,{A6}+ODR_QUEUE	; Premier et dernier PCB
	MOVE.32		#{A6}+ORDAStart,A0	; ^1er RDA -> A0.32
	move.32		#0,A1			; pas de descripteur prcdent 0 -> A1.32
	
	CALL		ADD_RD_PKT		; Met a jour les listes RDA et RRA du SONIC

; Les RRA , RDA et buffer de rception sont entre-chan avec PCB

;;??	move.32		#0,A0
	MOVE.16		{A5}+SonicISR,D0
	TEST.32		D0:#bSonicRBE
	JUMP,BC		r8^NEW_RRA$

.if	DEBUG
	WRITE_STR_C	resetting RBE bit in liste vide
.endif
	MOVE.16		#2**bSonicRBE,{A5}+SonicISR

NEW_RRA$:					; Envoie READ RRA 
.if 	DEBUG	
	WRITE_4NUM	D0	
	WRITE_STR_C	Reading RRA
.endif
	MOVE.16		#2**bSonicRRRA,{A5}+SonicCR	; Ne doit tre effectu qu'un seule fois !!

;*************************************
; ! attente par scrutation sur SONIC
;*************************************
.if	TestSansSonic
.else
	move.16		#10000,d1
WAIT_RRRA$:
	MOVE.16		{A5}+SonicCR,D0
	TEST.32		D0:#bSonicRRRA
	JUMP,BC		r8^sRRRA$		; Attend RRRA passe  0
	dj.16,nmo	d1,WAIT_RRRA$
	mon	?aftim
	.ascize	"<CR> bSonicRRRA reste actif !! (S0READ), problme avec le SONIC "
sRRRA$:
.endif	TestSansSonic
FIN$:
	ION					; Fin de la zone protegee
;^^^^^^
;  mettre ventuellement
	comp.16		#3,{A6}+NBRD_BUF
	jump,ne		r8^cont$
	call		StartReceive		; Prt  recevoir si au moins 3 buffers de rception
cont$:

	POPM.32		D0|D1|A0|A1|A2|A5
	TEST.16		D7
	RET



ERR0$:
	MOVE.16		#ERR_NO_INIT,{A4}+OPB_RES	; Renvoie erreur
	JUMP		r8^Fe$
ERR1$:
	MOVE.16		#ERR_FRG_CNT,{A4}+OPB_RES
	JUMP		r8^Fe$
ERR2$:
	MOVE.16		#ERR_SIZE_BUF,{A4}+OPB_RES
	JUMP		r8^Fe$
ERR3$:
	MOVE.16		#ERR_EMPTY_BUF,{A4}+OPB_RES
	JUMP		r8^Fe$
ERR4$:
	MOVE.16		#ERR_MAX_BUF,{A4}+OPB_RES
Fe$:
	MOVE.16		{A4}+OPB_RES,D7
	JUMP		FIN$

;-----------\
; ADD_RD_PKT >
;===========/
;
; Met a jour les listes RRA et RDA du SONIC en fonction du PCB courant
;
; in	A0.32	^sur RDA libre
;	A1.32	^RDA prcdent (0 si 1er lien)
;	A4.32	^PCB
;	A5.32	^Sonic
; out	A0.32	^RRA courant
; mod	A0.32, d0.32, d1.32

ADD_RD_PKT:
	; Gestion RDA, 2 champs ORXpktLink et ORXpktInUse sont  initialiser
	; EOL = 1 sur ORXpktLink et 16'FFFF sur ORXpktInUse
	; Le RDA est chan sur le PCB courant
	
	MOVE.16		#EOL,{A0}+ORXpktLink		; Dernier descripteur de la liste, pas de link
	MOVE.16		#16'FFFF,{A0}+ORXpktInUse	; Paquet utilis
	MOVE.32		A0,{A4}+OPB_DRV			; OPB_DRV pointe sur RDA correspondant

	comp.32		#0,A1
	jump,eq		r8^s1$
	MOVE.16		A0,{A1}+ORXpktLink	; Linke le nouveau RDA a l'ancien. Note: le
						; nouveau RDA n'existe pas encore, mais on 
						; se trouve dans une zone IOFF, donc pas de
						; problemes. NJET! le DMA peux quand-meme s'executer
s1$:
	; gestion RRA courant, il faut assez de RRA de libre
	
	clr.32		d0
	MOVE.16		{A5}+SonicRWP,D0		; Ptr 16 bits sur prochain RRA libre
	MOVE.32		#{A6}+32^{D0},A0		; A0 ^sur RRA courant

	MOVE.32		{A4}+OPB_BUF_TAB+OBUF_PTR,D1	; Ptr sur le buffer a lire ( adr paire !! )
							; Multiple long word pour s130
 	MOVE.16		D1,{A0}+ORXrsrcBuffPtr0		; Initialise ptr sur buffer fournit
	SWAP.32		D1
 	MOVE.16		D1,{A0}+ORXrsrcBuffPtr1

	MOVE.32		#LgRXbuffer,D1			; Longueur buffer est toujours egale a la 
							; longueur maximale
	SR.32		#1,D1				; Compte en words
	MOVE.16		D1,{A0}+ORXrsrcBuffWC0
;	SWAP.32		D1
;	MOVE.16		D1,{A0}+ORXrsrcBuffWC1
	MOVE.16		#0,{A0}+ORXrsrcBuffWC1

	ADD.32		#LgRXrsrcDescriptor,D0		; Aligne RWP pour descripteur suivant
	COMP.16		#ORRAEnd,D0			; Fin de zone RRA atteinte ?
	JUMP,LO		r8^OK$
	MOVE.16		#ORRAStart,D0			; Revient au debut de zone
OK$:
;PH
	MOVE.16		D0,{A5}+SonicRWP		; Mise  jour RWP

FIN$:
	RET	


;***************************************************************************************
;--------\
; S0WRITE >
;========/
;***************************************************************************************
;
; Une seule commande d'emission est fournie a la fois (pas de chainage de transmission) au niveau
; du SONIC. Mais par contre les requetes sont chainees et traitees a la suite de facon asynchrone
; La taille de tous les fragments doit tre plus petite que 1500 octets !!
;
; Les paquets sont chans pour tre transmis plus efficacement (RB)
;
; In	A6.32	^variables globales du pilote
;	A4.32	^descripteur des donnees PCB
;	D5.32	longueur descripteur ( ignore )
; Out	D7.32	erreur
;
; Mod	
;

S0WRITE:
.if	DEBUG
;;	WRITE_STR_C	ETH:Write
.endif
	PUSHM.32	D0|D1|A0|A1|A5
	MOVE.32		{A6}+OAD_SONIC,A5		; Charge l'adresse du Sonic
	MOVE.16		#-1,{A4}+OPB_RES		; -1 pour occup

	COMP.8		#IDLE,{A6}+DRIV_STATE		; Driver ouvert ?
	JUMP,NE		ERR0$

	CLR.16		D7

; Test nbre de fragments

	MOVE.16		{A4}+OPB_BUF_NB,D0		; Compteur nb fragments
	JUMP,EQ		ERR3$
	COMP.16		#PBNbBufDescr,D0		; Nbre fragments trop grand ?		
	JUMP,HI		ERR1$

; Nb fragments OK

	DEC.16		D0				; pour DJ
	CLR.32		D1				; Compteur taille
	MOVE.32		#{A4}+OPB_BUF_TAB,A0
BOU1$:
	ADD.32		{A0}+OBUF_L_LEN,D1		; Additionne longueur de tous les fragments
	COMP.32		#0,{A0}+OBUF_L_LEN		; Teste taille min fragment
	JUMP,EQ		r8^ERR2$
	ADD.32		#BLEN,A0			; passe au buffer suivant
	DJ.16,NMO 	D0,BOU1$

; Vrifie si > paquet Ethernet

	COMP.32		#LgMaxEth,D1			; Teste taille maximum
	JUMP,HI		ERR2$
;	COMP.32		#LgMinEth,D1			; La taille minimale n'est pas un 
;	JUMP,LO		ERR2$				; probleme. Le driver allonge le packet
							; dans send_packet.
.if	DEBUG
;	WRITE_STR	ETH:Write: paquet ok
.endif
	MOVE.32		#NULL,{A4}+OPB_NXT	; Ici OPB_NXT est le pointeur next_element

; Met le paquet en queue de transmission
; Le signal sera effectu directement sur le smaphore associ au paquet (fournit dans PB)

	call		PutPacketInTDA
	
FIN$:
	POPM.32		D0|D1|A0|A1|A5
	TEST.16		D7
	RET

ERR0$:
	MOVE.16		#ERR_NO_INIT,{A4}+OPB_RES	; Renvoie erreur
	JUMP		Fe$
ERR1$:
	MOVE.16		#ERR_FRG_CNT,{A4}+OPB_RES
	JUMP		Fe$
ERR2$:
	MOVE.16		#ERR_SIZE_BUF,{A4}+OPB_RES
	JUMP		Fe$
ERR3$:
	MOVE.16		#ERR_EMPTY_BUF,{A4}+OPB_RES
Fe$:
	move.16		{A4}+OPB_RES,d7
	JUMP		FIN$


;***********************************************************************************************
; Routines de gestion des interruptions
;***********************************************************************************************


;--------------\
; InitInterrupt >
;==============/
;
; Demasque l'interruption et initialise la routine d'interruption
; Cette routine est executee en mode superviseur
;
; In	A6.32		^variables (passe dans A0.32 dans la routine d'interruption)
; Out
; Mod

InitInterrupt:
.if	.NOT.TestSansSonic
	PUSHM.32	A0|A1|A2|D0
	SUP
	.if	Carte302
	MOVE.32		#V_PB9,A0
	.endif
	.if	S130.AND.(.NOT.Grafem)
	move.8		#VectSonic,AdWrVect	; Ecrit vecteur sur carte Sonic
	.endif
	.if	S130
	MOVE.32		_INDNTR,A2
	MOVE.32		#R16^InterruptRout,A1
	MOVE.32		#AVectSonic*4,A0	; Mode Autovecteur galement niveau 2
	CALL		{A2}+OIN_INITVECTOR
	.endif
	.if	.NOT.Grafem
;;	MOVE.32		_INDNTR,A2
	MOVE.32		#R16^InterruptRout,A1
	MOVE.32		#VectSonic*4,A0
	CALL		{A2}+OIN_INITVECTOR
	.endif

	.if	Carte302
	MOVE.32		#BASE,A0
	MOVE.16		{A0}+O_IMR,D0		; Masque interruptions
	TSET.32		D0:#B_IMR_PB9		; Autorise interrupt Sonic

	MOVE.16		D0,{A0}+O_IMR
	.endif

	USER
	POPM.32		A0|A1|A2|D0
.endif	.NOT.TestSansSonic
	RET

;--------------\
; StopInterrupt >
;==============/
;
; Masque l'interruption et desactive la routine d'interruption
; Cette routine est executee en mode superviseur
;
; In
; Out
; Mod

StopInterrupt:
.if	.NOT.TestSansSonic
	PUSHM.32	A0|A1|A2
;	SUP

	.if		Carte302
	MOVE.32		#BASE,A0
	MOVE.16		{A0}+O_IMR,D0		; Masque interruptions
	TCLR.32		D0:#B_IMR_PB9		; Interdit interrupt Sonic

	MOVE.16		D0,{A0}+O_IMR

	MOVE.32		#V_PB9,A0
	.endif
	.if	.NOT.Grafem
	.if	S130
	move.32		#VectSonic*4,A0
	.endif
	MOVE.32		#0,A1			; adresse routine = 0
	MOVE.32		_INDNTR,A2

	CALL		{A2}+OIN_INITVECTOR	; desinstallation de la routine
	.endif
;	USER
	POPM.32		A0|A1|A2
.endif	.NOT.TestSansSonic
	RET


;--------------\
; InterruptRout >
;==============/
;
; Trie et traite les differentes interruptions pouvant se presenter
; Tous les registres autres que A0|A1|D0|D1 ne sont pas sauves automatiquement ???PH
;
; In	A0.32	^variables (contenu de A6 au moment de l'InitInterrupt)
; Out
; Mod

	.IF	0
;**********************
;     /
;  /\/
; /
;**********************
InterruptRout:
.if	TestDriv
	or.16	#16'2700,sf
.endif	TestDriv
	PUSHM.32	A5|A6|d7			; Sauve les registres
.if	AfMon
push.16	d7
mon	?aftim
.ascize	"<CR>InterruptRout "
pop.16	d7
.endif	AfMon
	MOVE.32		A0,A6				; ^debut de la zone memoire
	MOVE.32		{A6}+OAD_SONIC,A5		; Charge l'adresse du Sonic

	.if	Carte302
	MOVE.32		#BASE,A0
;;	MOVE.16		{A0}+O_ISR,D0

.if 	DEBUG
;	WRITE_STR	68000 ISR : 
;	WRITE_4NUM	D0	
;	WRITE_CR
.endif
	MOVE.16		#2**B_IMR_PB9,{A0}+O_ISR	; ACK de l'interrupt 68000
	.endif

	MOVE.16		{A5}+SonicISR,D0		; Lit le ISR

Again$:
;;	WRITE_STR	sonic ISR : 
;;	WRITE_4NUM	D0
;;	WRITE_CR

	TEST.32		D0:#bSonicTXDN			; 1) Packet Sent ?
	JUMP,BC		S0$
	MOVE.16		#2**bSonicTXDN+2**bSonicTXER,{A5}+SonicISR
	CALL		PktSent
	JUMP		S1$
S0$:
	TEST.32		D0:#bSonicTXER			; 2) Packet Sent with Errors ?
	JUMP,BC		S1$
	MOVE.16		#2**bSonicTXER+2**bSonicTXDN,{A5}+SonicISR
	CALL		PktSent
S1$:
	TEST.32		D0:#bSonicPKTRX			; 3) Packet Received ?
	JUMP,BC		S2$
	MOVE.16		#2**bSonicPKTRX,{A5}+SonicISR
	CALL		PktReceived
S2$:
	MOVE.16		{A5}+SonicISR,D0		; Lit le ISR
;;	AND.16		#2**bSonicTXDN+2**bSonicTXER+2**bSonicPKTRX,D0
	AND.16		{A5}+SonicIMR,D0		; Test avec ce qui est autoris
	JUMP,NE		AGAIN$

	POPM.32		A5|A6|d7			; Recupere les registres
	RET
.ELSE
;**********************
;     /
;  /\/
; /
;**********************
InterruptRout:
.if	TestDriv
	or.16	#16'2700,sf
.endif	TestDriv
	PUSHM.32	A5|A6|d7			; Sauve les registres
.if	AfMon
push.16	d7
mon	?aftim
.ascize	"<CR>InterruptRout "
pop.16	d7
.endif	AfMon
	MOVE.32		A0,A6				; ^debut de la zone memoire
	MOVE.32		{A6}+OAD_SONIC,A5		; Charge l'adresse du Sonic

	.if	Carte302
	MOVE.32		#BASE,A0
;;	MOVE.16		{A0}+O_ISR,D0

.if 	DEBUG
;	WRITE_STR	68000 ISR : 
;	WRITE_4NUM	D0	
;	WRITE_CR
.endif
	MOVE.16		#2**B_IMR_PB9,{A0}+O_ISR	; ACK de l'interrupt 68000
	.endif

; Nouvelle mthode de traitement
;RB*******************************
; Boucle pour traitement de toutes les interruptions en attente

l$:
	move.32		#R16^TIntSonic,A0		; ^Table int Sonic
	MOVE.16		{A5}+SonicISR,D0		; Lit le ISR

	move.16		d0,d1
	AND.16		{A5}+SonicIMR,D1		; Test avec ce qui est autoris
	jump,eq		r8^f$				; plus de requtes d'int en cours
l1$:
	move.16		{A0+},D1			; bit  tester
	jump,mi		l$				; fin de la table si ngatif (-1) -> recommence
	test.32		D0:D1				; Interruption active ?
	jump,bc		r8^s$				; non -> va au suivant
; Interruption active

	move.16		{a0+},d1
	move.16		d1,{A5}+SonicISR		; Quittance interruption
	move.16		{a0+},d1			; Offset
	call		{a0}+A16^{d1}-2
	jump		l1$				; Et passe  l'interruption suivante

s$:
	add.32		#4,a0
	jump		l1$

; Plus d'interruption en attente

f$:
	POPM.32		A5|A6|d7			; Recupere les registres
	RET


TIntSonic:
	.16	bSonicTXDN, 2**bSonicTXDN+2**bSonicTXER, PktSent-APC	; 1) Packet Sent ?
;;	.16	bSonicTXER, 2**bSonicTXER+2**bSonicTXDN, PktSent-APC	; 2) Packet Sent with Errors ? test avec TXDN !!
	.16	bSonicPKTRX, 2**bSonicPKTRX, PktReceived-APC		; 3) Packet Received ?
;;	.16	bSonicBR, 2**bSonicBR, Rien-APC				; Bus Retry Ocurred
;;	.16	bSonicHBL, 2**bSonicHBL, Rien-APC			; CD HeartbeatLost
;;	.16	bSonicLCD, 2**bSonicLCD, Rien-APC			; Load CAM Done
;;	.16	bSonicPINT, 2**bSonicPINT, Rien-APC			; Programmable Interrupt
	.16	bSonicTC, 2**bSonicTC, WTimer-APC			; Timer Complete
;;	.16	bSonicRDE, 2**bSonicRDE, Rien-APC			; Receive Descriptors Exhausted
;;	.16	bSonicRBE, 2**bSonicRBE, Rien-APC			; Receive Buffers Exhausted
;;	.16	bSonicRBAE, 2**bSonicRBAE, Rien-APC			; Receive Buffer Area Exceeded
;;	.16	bSonicCRC, 2**bSonicCRC, Rien-APC			; CRC Tally Counter Rollover
;;	.16	bSonicFAE, 2**bSonicFAE, Rien-APC			; Frame Alignment Error, Tally Counter Rollover
;;	.16	bSonicMP, 2**bSonicMP, Rien-APC				; Missed Packed Tally Counter Rollover
;;	.16	bSonicRFO, 2**bSonicRFO, Rien-APC			; Receive FIFO Overrun
	.16	-1

RIEN:
	ret
.endif

;------------\
; PktReceived >
;============/
;
; Recoit un paquet
;
; In	A6.32	^variables
; Out
; Mod
;
PktReceived:
	PUSHM.32	A0|A1|D0
.if	AfMon
push.16	d7
mon	?aftim
.ascize	"<CR>PktReceived"
pop.16	d7
.endif	AfMon
	INC.32		{A6}+OS_RX_INT_C		; Met a jour les stats
l$:
	MOVE.32		{A6}+ODR_TETE,A0		; ^1er PCB de la liste
	COMP.32		#NULL,A0
	JUMP,EQ		FIN$				; Erreur si liste vide, sort

	MOVE.32		{A0}+OPB_DRV,A1			; Ptr sur RDA -> A1.32

; test s'il est bien libre

	test.16		{A1}+ORXpktInUse		; paquet bien libr par le Sonic ?
	jump,ne		FIN$				; non -> fin rception

; Vrifie la cohrence des pointeurs du buffer de donnes

	move.16		{A1}+ORXpktPktPtr1,D0
	swap.32		D0
	move.16		{A1}+ORXpktPktPtr0,D0		; ^buffer -> d0.32
	comp.32		{A0}+OPB_BUF_TAB+OBUF_PTR,D0
	jump,ne		bug$				; dcalage !!!

; C'est le bon buffer qui est remplit

	MOVE.16		{A1}+ORXpktStatus,D0		; Resultat de la rception
;;RB	CLR.16		{A0}+OPB_RES			; Indique pas d'erreur
	MOVE.16		D0,{A0}+OPB_RES			; erreur de rception
	TEST.32		D0:#bSonicPRX			; Receive OK ?
	JUMP,BS		r8^NXT_PKT$

;;RB	MOVE.16		#ERR_RX,{A0}+OPB_RES		; Sinon indique erreur de transmission
	TEST.32		D0:#bSonicCRCR			; Teste erreur de CRC
	JUMP,BC		r8^ERR_PKT$
	INC.32		{A6}+OS_BAD_CRC			; Met a jour stats
	JUMP		r8^ERR_PKT$	

NXT_PKT$:
	INC.32		{A6}+OS_RX_FR_C			; Met a jour stats
	CLR.32		D0
	MOVE.16		{A1}+ORXpktByteCount,D0
	ADD.32		D0,{A6}+OS_RX_BYTE_C		; Nbre de bytes recus	
	MOVE.32		D0,{A0}+OPB_BUF_TAB+OBUF_L_LEN	; Nombre d'octets reus
	
ERR_PKT$:
	DEC.16		{A6}+NBRD_BUF			; decremente le nombre de paquet en attente
	MOVE.32		{A0}+OPB_NXT,A1			; Ptr sur PCB suivant ou NULL si dernier PCB
	MOVE.32		A1,{A6}+ODR_TETE		; Il prend la tete de liste

	MOVE.32		{A0}+OPB_SEMA,A1		; Recupere Semaphore a signaler
	CALL		32^_ISIGNEV			; Et le signale a l'utilisateur
.if	AfMon
push.16	d7
mon	?aftim
.ascize	"<CR>Signev PktReceived "
pop.16	d7
WRITE_8NUM A0
.endif	AfMon
	jump		l$				; va voir si un autre paquet a t reu
FIN$:
	POPM.32		A0|A1|D0			; Recupere les registres
	RET

bug$:
	write_str_c	eth:bug	
	write_8num	D0
	write_str	:  :
	write_8num	{A0}+OPB_BUF_TAB+OBUF_PTR
	write_Tab
	MOVE.16		{A1}+ORXpktStatus,D0		; Resultat de la reception
	write_8num	d0
	write_cr
	call 		showreg
	jump		FIN$


;--------\
; PktSent >
;========/
;
; Appele apres transmission d'un paquet ou plusieurs paquets.
; S'il n'y a pas d'erreurs, tous les paquets sont transmis
; Arrt de transmission ds qu'une erreur apparait
; 	Dans ce cas il faut relancer la transmission
;
; In	A5.32	^Sonic		
;	A6.32	^variables
; Out
; Mod

; Paquets avec ou sans erreur de transmission ( tester)


PktSent:
	PUSHM.32	A0|A1|D0|D1			; Sauve les registres

	INC.32		{A6}+OS_TX_INT_C		; Met a jour les stats
l$:
	move.32		{a6}+oTxPntFirstTDA,A1		; Prend ^1er TDA transmis -> A1.32

	MOVE.16		{A1}+OTXpktStatus,D0		; Resultat de la transmission
;;	WRITE_STR_C	eth:PktSend
;;	WRITE_4NUM	D0
;;	WRITE_CR
	test.16		d0
	jump,eq		fin$				; pas encore transmis

; paquet transmis y a-t-il une erreur ?

	clr.16		{A1}+OTXpktStatus		; Mis  0 en cas de oTxPntFirstTDA "dborde"
	move.32		{a1}+oTxPntPB,A0		; ^PB associ -> A0.32
	CLR.16		{A0}+OPB_RES			; Indique pas d'erreur

; statistique commune erreur ou pas
	
	move.16		d0,d1
	RL.16		#5,D1
	AND.32		#2'11111,D1			; prend les bits compteur de collision
	ADD.32		D1,{A6}+OS_TX_COL		; Met a jour nbre collisions

; prend ^next TDA ! 
	
	move.32		{a1}+oTxPntNextTDA,{a6}+oTxPntFirstTDA	; ^prochain TDA transmis ou  transmettre
	tclr.8		{a1}+oTDAStatus:#bTDAInUse	; TDA libre

	TEST.32		D0:#bSonicPTX			; Transmit OK ?
	JUMP,BS		r8^NXT_PKT$
	
; traitement en cas d'erreurs
	
	MOVE.16		#ERR_TX,{A0}+OPB_RES		; Sinon indique erreur de transmission
	INC.32		{A6}+OS_TX_ERR			; Met a jour stats
	move.16		{a6}+oTxPntFirstTDA+2,{a5}+SonicCTDA	; CTDA ^paquet suivant  ventuellement transmettre si EOL courant = 0

	move.16		{a1}+oTxPktFragCount,d1		; nombre de fragment
	mul.16		#LgTxpktFragDesc,d1
	test.8		{a1}+32^{d1}+oTxPktFragDesc+oTxpktLink+1:#0	; EOL courant =0 ?
	JUMP,bs		r8^ERR_PKT$			; EOL = 1 -> suite du traitement
	write_str_c	TXP
	move.16		#2**bSonicTXP,{a5}+SonicCR	; commande de transmission
	jump		r8^ERR_PKT$			; et continue 

; traitement sans erreurs

NXT_PKT$:
	INC.32		{A6}+OS_TX_FR_C			; Met a jour stats
	MOVE.16		{A1}+OTXpktPktSize,D1
	ADD.32		D1,{A6}+OS_TX_BYTE_C
ERR_PKT$:

	MOVE.32		{A0}+OPB_SEMA,A1		; Recupere Semaphore a signaler
	CALL		32^_ISIGNEV			; Et le signale a l'utilisateur

	dec.32		{a6}+oCntWaitTDAFree		; quelqu'un attend TDA libre?
	jump,mi		l$				; va voir si un nouveau paquet a t transmis
	move.32		{a6}+oSemWaitTDAFree,A1
	CALL		32^_ISIGNEV			; signal TDA libre
	jump		l$

FIN$:
	POPM.32		A0|A1|D0|D1			; Recupere les registres
	RET


;****************************
;****************************
; Gestion de la transmission
;****************************
;****************************

;--------------\\
; PutPacketInTDA >
;===============/
;
; Met le paquet dans la TDA et envoi de la commande de transmission
; On n'attend pas que le paquet soit transmis pour quitter
; Il faut qu'il y ait une entre dans la TDA de libre
; 
; In	A4.32	^descripteur PB
; Out	
; Mod	

PutPacketInTDA:
	pushm.32	a0|a2|a3|d2
	call		GiveTDA		; A2.32 ^TDA libre
					; A3.32 ^Next TDA
	jump,ne		r8^f$
	call		InitTDA		; Met les descripteurs de buffer en ordre

; reprend le link TDA prcdent

	move.32		{a2}+oTxpntPrevTDALink,a0	; TDA prcdent -> A0.32
	comp.32		#0,a0
	jump,eq		r8^s1$				; ^nil -> s1$
	tclr.8		{a0}+1:#0			; EOL TDA prcdent =0
s2$:
	move.32		a3,{a6}+oPntTDANextFree		; ^A3 sera prochain TDA libre
	MOVE.16		#2**bSonicTXP,{A5}+SonicCR	; Met le bit TXP a 1 -> transmission
f$:
	popm.32		a0|a2|a3|d2
	test.16		d7
	ret

; Premire TDA

s1$:
	move.16		a2,{a5}+SonicCTDA		; ^TDA courante
	move.32		a2,{a6}+oTxPntFirstTDA		; 1re TDA
	jump		s2$

;-------\\
; GiveTDA >
;========/
;
; Trouve 1 TDA de libre et le suivant de la liste
; 
; In	-
; Out	A2.32	^TDA libre
;	A3.32	^prochaine TDA
;	D7.16	erreur sur smaphore possible
; Mod	

GiveTDA:
	pushm.32	a0|a5
l1$:

; Prend un 1er TDA -> A2.32

	move.32		{a6}+oPntTDANextFree,A2		; ^prochaine TDA de libre
	inc.32		{a6}+oCntWaitTDAFree
	tset.8		{a2}+oTDAstatus:#bTDAInUse	; TDA occup
	jump,bs		wait1$

; Prend un 2me TDA -> A3.32 pour prparer le chanage
; ce nouveau TDA peut tre en utilisation maintenant -> pas important

	move.32		#{a2}+LgTxpktDescMod,a3		; ^next TDA
	move.32		#{a6}+oTDAEnd,a0
	comp.32		a3,a0
	jump,hi		r8^s$				; limite TDAEnd pas atteinte
	move.32		#{a6}+oTDAStart,a3		; retour au dpart des descripteurs
s$:
f$:
	popm.32		a0|a5
	test.16		d7
	ret	


;Attente sur libration TDA

wait1$:
	push.32		a5
	move.32		{a6}+oSemWaitTDAFree,a5
	ntrel		?waitev				; attend que TDA se libre
	popm.32		a5
	jump,eq		l1$
	move.32		#0,a2
	move.32		#0,a3
push.32	d7
mon	?aftim
.ascize	"<CR>GiveTDA, erreur oSemWaitTDAFree"
pop.32	d7
	jump		f$


;-------\\
; InitTDA >
;========/
;
; Initialise les paramtres de la TDA fournie
; 
; In	A2.32	^TDA
;	A3.32	^prochaine TDA
;	A4.32	^PB
; Out	
; Mod	

InitTDA:
	PUSHM.32	A0|A1|D0|D1|D2
	move.32		a4,{a2}+oTxpntPB		; ^PB associ

	clr.16		{a2}+oTxpktStatus		; efface le status
	MOVE.16		#TCRConfig,{A2}+OTXpktConfig	; Initialise structure TDA
	MOVE.16		{A4}+OPB_BUF_NB,D0		; Compteur nb fragments
	MOVE.16		D0,{A2}+OTXpktFragCount		; -> Nb fragment indiqu dans descr TDA
	
	DEC.16		D0				; pour dj.16,nmo ...
	CLR.32		D1				; Compteur taille
	MOVE.32		#{A4}+OPB_BUF_TAB,A0
	MOVE.32		#{A2}+OTXpktFragDesc,A1		; ^TDA+fradesc -> A1.32
BOU1$:
	ADD.32		{A0}+OBUF_L_LEN,D1		; Additionne longueur de tous les fragments
	MOVE.32		{A0}+OBUF_L_LEN,D2		; Lg Buffer -> D2 -> taille du fragment
	MOVE.16		D2,{A1}+OTXpktFragSize		; Transfere taille fragment dans TDA
	MOVE.32		{A0}+OBUF_PTR,D2
	MOVE.16		D2,{A1}+OTXpktFragPtr0		; Transfere pointeurs buffers
	SWAP.32		D2
	MOVE.16		D2,{A1}+OTXpktFragPtr1

	ADD.32		#LgTXpktFragDesc,A1		; ^descr frag suivant
	ADD.32		#BLEN,A0			; Passe au buffer suivant
	DJ.16,NMO 	D0,BOU1$

	COMP.16		#LgMinEth,D1
	JUMP,HS		r8^LENOK$

; rajoute un fragment pour complter la taille minimum

	SUB.16		#LgMinEth, d1				; d1 - LgMin -> d1 (<0)
	neg.16		d1
	move.16		D1,{A1}+OTXpktFragSize			; nouveau fragment
	MOVE.16		#LgMinEth,D1				; corrige la taille totale.
	move.32		#r16^BufferDummy,a0
	move.32		a0,d2
	MOVE.16		D2,{A1}+OTXpktFragPtr0			; Transfere pointeurs buffers
	SWAP.32		D2
	MOVE.16		D2,{A1}+OTXpktFragPtr1
	inc.16		{a2}+OTXpktFragCount			; 1 fragment de plus
	ADD.32		#LgTXpktFragDesc,A1			; ^descr frag suivant

LENOK$:		
	MOVE.16		D1,{A2}+OTXpktPktSize			; Stocke taille totale
	move.16		a3,d2					; ^link suivant
	or.16		#EOL,D2					; Indique dernier descripteur	
	MOVE.16		D2,{A1}+OTXpktLink			; A1.32 ^sur ~TxPktLink  (RB)
								; aprs avoir charg tous les descr de fragments
; Initialise lien avec descripteur suivant (futur prochain libre))
	
	move.32		a2,{a3}+oTxpntPrevTDA			; met lien arrire
	move.32		a3,{a2}+oTxPntNextTDA			; ^next TDA
	move.32		#{A1}+OTXpktLink,a0
	move.32		a0,{a3}+oTxPntPrevTDALink		; place dans le prochain TDA l'adresse de link courant
FIN$:
	POPM.32		A0|A1|D0|D1|D2
	RET

BufferDummy:	.fill.8	64,0

;-------\
; WTimer >
;=======/
; Interruption du timer
; Action :
; - STOP le Timer
; - Effectue un signal sur Smaphore oSemTimer
; In:	A5.32	^Sonic
;	A6.32	^variables

WTimer:
	PUSHM.32	A0|A1|D0|D1
	move.16		#2**bSonicSTP,{a5}+SonicCR	; Stop le timer
	MOVE.32		{A6}+oSemTimer,A1		; Recupere Semaphore a signaler
	CALL		32^_ISIGNEV			; Et le signale a l'utilisateur
	POPM.32		A0|A1|D0|D1
	ret

;***********************************************************************************************
;			ROUTINES D'INITIALISATION
;***********************************************************************************************


;--------\
; InitMEM >
;========/
;
; Initialise la memoire
;
; In	A6.32	^variables
; Out
; Mod

InitMEM:

; Initialisation des listes de rception ( voir)
; **************************

	MOVE.32		#NULL,{A6}+ODR_TETE		; Listes Vides

; Initialisation Status
; *********************
;PH move.16->move.8
	MOVE.8		#MajRev,{A6}+OS_REVISION	; Mise a jour version driver
	MOVE.8		#MinRev,{A6}+OS_VERSION
	MOVE.32		A6,{A6}+OS_DRV_MEM		; Ptr vars driver

; Initialisation ^pour TDA
;*************************
; Les TDA sont utiliss les uns aprs les autres

	move.32		#{a6}+oTDAStart,a0		; adresse 1er TDA
	move.32		a0,{a6}+oPntTDANextFree
	
	move.32		#0,{a0}+oTxPntPrevTDA		; pas de TDA avant
	move.32		#0,{a0}+oTxPntPrevTDALink	; pas de TDA avant
	move.32		#0,{a0}+oTxPntNextTDA		; pas de TDA aprs
	move.8		#0,{a0}+oTDAstatus		; TDA pas utilis
	move.32		#0,{a0}+oTxPntPB
	
	move.32		#-NbMaxTDA,{a6}+oCntWaitTDAFree	; Compteur pour nombre de TDA libre attendu

	RET


;----------\
; InitSonic >
;==========/
;
; Initialisation du Sonic
;
; Effectue un Software Reset du Sonic, fixe sa configuration et initialise ses registres
; Tous les acces au Sonic doivent se faire par des MOVE.16 car la ligne A0 n'est pas cablee
;
; In	A5.32	^Sonic
;	A6.32	^variables
; Out
; Mod

;PH, ajoute la programmation du chip-select
	.if	Carte302
; programmation du chip-select:

; SONIC_BR (SONIC position)
; SONIC_OR 
;
SONIC_BR		= BASE+O_BR1					; SONIC uses CS3
SONIC_OR		= BASE+O_OR1

SONIC_BR_FC	= 2'001		*(2**B_BR_FC0)			; FC2-FC0, Not used (see ROM1_OR_CFC)
SONIC_BR_BA	= AdSonic	/(2**10'13)*(2**B_BR_BA)	; SONIC_BASE  (upper 11 bits << 2)
SONIC_BR_RW	= 2'0		*(2**B_BR_RW)			; Read only, Not used (see SONIC_OR_MRW)
SONIC_BR_EN	= 2'1		*(2**B_BR_EN)			; Enable
SONIC_BR_VAL	= SONIC_BR_FC.or.SONIC_BR_BA.or.SONIC_BR_RW.or.SONIC_BR_EN

SONIC_OR_DTACK	= 2'111		*(2**B_OR_DTACK)		; DTACK made by SONIC
SONIC_OR_MASK	= 2'11111111111	*(2**B_OR_MASK)			; ROM = A1..A12 not decoded
SONIC_OR_MRW	= 2'0		*(2**B_OR_MRW)			; Disable ROM1_BR_RW
SONIC_OR_CFC	= 2'0		*(2**B_OR_CFC)			; ignore FC2-FC0 in BR0
SONIC_OR_VAL	= SONIC_OR_DTACK.or.SONIC_OR_MASK.or.SONIC_OR_MRW.or.SONIC_OR_CFC
	.endif	Carte302


InitSonic:
	PUSHM.32	A0|D0|a3				; Sauvegarde les registres
	.if	Carte302
	MOVE.16		#SONIC_OR_VAL,	BASE+O_OR3	; init CS Sonic
	MOVE.16		#SONIC_BR_VAL,	BASE+O_BR3	; """
	.endif	Carte302

; Effectue un Software Reset du Sonic
; ***********************************

	MOVE.16		#2**bSonicRST,D0		; Met le bit RST a 1
	MOVE.16		D0,{A5}+SonicCR

	MOVE.16		{A5}+SonicDCR,D0		; ** DATA CONFIGURATION REGISTER **
	Clr.32		d0
	TCLR.32		D0:#bSonicSTERM			; Asynchronous Mode
;	TSET.32		D0:#bSonicWC0			; 3 Wait State
;	TSET.32		D0:#bSonicWC1			; 3 Wait State
	TCLR.32		D0:#bSonicWC0			; 0 Wait State
	TCLR.32		D0:#bSonicWC1			; 0 Wait State
	.if	BUS16
	TCLR.32		D0:#bSonicDW			; 16 bit Data Width
	.endif
	.if	BUS32
	TSET.32		D0:#bSonicDW			; 32 bit Data Width
	.endif
	TCLR.32		D0:#bSonicBMS			; Empty/fill FIFOs Mode

	TSET.32		D0:#bSonicRFT1			; set receive fifo threshold
	TSET.32		D0:#bSonicRFT0			; to 24 bytes

	TCLR.32		D0:#bSonicTFT1			; set transmit fifo threshold
	TSET.32		D0:#bSonicTFT0			; to 16 bytes

	TCLR.32		D0:#bSonicPO1			; set programmable output 1 to 0
	TSET.32		D0:#bSonicPO0			; set programmable output 0 to 1
	.if	S130
	TSET.32		D0:#bSonicExBus			; Mode bus d'extension
	.endif
	MOVE.16		D0,{A5}+SonicDCR

	.if	S130
;;	MOVE.16		{A5}+SonicDCR2,D0		; ** DATA CONFIGURATION REGISTER 2**
	move.16		#2'0000*(2**bSonicEXPO0),d0	; SIZ1, SIZ0, A0 = 0
	MOVE.16		D0,{A5}+SonicDCR2
	.endif	S130

	MOVE.16		#0,D0				; Remet le bit RST a 0		
	MOVE.16		D0,{A5}+SonicCR


; Fixe la configuration du Sonic
; ******************************

	MOVE.16		{A5}+SonicRCR,D0		; ** RECEIVE CONTROL REGISTER **
;	TSET.32		D0:#bSonicERR			; Accept Packets with Errors
	TCLR.32		D0:#bSonicERR			; Don't Accept Packets with Errors
	TCLR.32		D0:#bSonicRNT			; Reject Runt Packets
	TSET.32		D0:#bSonicBRD			; Accept Broadcast Packets
;	TSET.32		D0:#bSonicAMC			; Accept Multicast Packets
	TCLR.32		D0:#bSonicAMC			; Don't Accept Multicast Packets
	TCLR.32		D0:#bSonicPRO			; No Promiscuious Mode
	TCLR.32		D0:#bSonicLB0			; No Loopback
	TCLR.32		D0:#bSonicLB1			; No Loopback
	MOVE.16		D0,{A5}+SonicRCR

	MOVE.16		{A5}+SonicTCR,D0		; ** TRANSMIT CONTROL REGISTER **
	TCLR.32		D0:#bSonicPINTR			; No Transmit Programable Interrupt
	TCLR.32		D0:#bSonicPOWC			; Timer begins after the SFD
	TCLR.32		D0:#bSonicCRCI			; Transmit Packet with CRC
	TCLR.32		D0:#bSonicEXDIS			; Excessive Deferral Timer Enable
	MOVE.16		D0,{A5}+SonicTCR

	MOVE.16		{A5}+SonicIMR,D0		; ** INTERRUPT MASK REGISTER **
	TCLR.32		D0:#bSonicBREN			; Bus Retry Occurred		Disable
	TCLR.32		D0:#bSonicHBLEN			; Heartbeat Lost		Disable
	TCLR.32		D0:#bSonicLCDEN			; Load CAM Done			Disable
	TCLR.32		D0:#bSonicPINTEN		; Programmable Interrupt	Disable
	TSET.32		D0:#bSonicPRXEN			; Packet Received		Enable
	TSET.32		D0:#bSonicPTXEN			; Packet Transmitted OK		Enable
	TSET.32		D0:#bSonicTXEREN		; Transmit Error		Enable
	TCLR.32		D0:#bSonicTCEN			; Timer Complete		Disable
	TCLR.32		D0:#bSonicRDEEN			; Receive Descriptors Exhausted	Disable
	TCLR.32		D0:#bSonicRBEEN			; Receive Buffers Exhausted	Disable
	TCLR.32		D0:#bSonicRBAEEN		; Receive Buffer Area Exceeded	Disable
	TCLR.32		D0:#bSonicCRCEN			; CRC Tally Counter Warning	Disable
	TCLR.32		D0:#bSonicFAEEN			; FAE Tally Counter Warning	Disable
	TCLR.32		D0:#bSonicMPEN			; MP Tally Counter Warning	Disable
	TCLR.32		D0:#bSonicRFOEN			; Receive FIFO Overrun		Disable
	MOVE.16		D0,{A5}+SonicIMR


; Initialisation des registres qui grent la RRA
; **********************************************

	MOVE.32		A6,D0					; Initialisation du URRA
	SWAP.32		D0
	MOVE.16		D0,{A5}+SonicURRA

	MOVE.32		#{A6}+ORRAStart,A0			; Initialisation du RSA
	MOVE.16		A0,{A5}+SonicRSA
	MOVE.16		A0,{A5}+SonicRRP			; Initialisation du RRP
	MOVE.16		A0,{A5}+SonicRWP			; et du RWP, table descr. vide
	MOVE.32		#{A6}+ORDAStart,A0			; Initialisation du REA
	MOVE.16		A0,{A5}+SonicREA

; Initialise les registres qui gerent la CDA (CAM)
; ******************************************
; Le URRA est initialise lors de l'initialisation de la RRA

;	L'adresse locale est initialise par une commande de haut niveau
	
; Initialisation des registres qui gerent la RDA
; **********************************************

	MOVE.32		A6,D0				; Initialisation du URDA
	SWAP.32		D0
	MOVE.16		D0,{A5}+SonicURDA
	MOVE.32		#{A6}+ORDAStart,A0		; Initialisation du CRDA
	MOVE.16		A0,{A5}+SonicCRDA


; Initialisation des registres qui gerent la TDA
; **********************************************

	MOVE.32		A6,D0				; Initialisation du UTDA
	SWAP.32		D0
	MOVE.16		D0,{A5}+SonicUTDA
	MOVE.32		#{A6}+OTDAStart,A0		; Initialisation du CTDA
	MOVE.16		A0,{A5}+SonicCTDA


; Initialisation des registres qui gerent la RBA
; **********************************************

	.if	Carte302	
	MOVE.16		#(LgRXBuffer/2)-2,{A5}+SonicEOBC ; Initialise le EOBC pour avoir 1 paquet/buffer
	.endif
	.if	S130
	MOVE.16		#1520/2,{A5}+SonicEOBC		; Pour 32 bits
	.endif

; Initialisation des compteurs de debug  -1
;*******************************************

	move.16		#-1,{a5}+SonicCRCT
	move.16		#-1,{a5}+SonicFAET
	move.16		#-1,{a5}+SonicMPT

	POPM.32		A0|D0|a3			; Recupere les registres
	RET

;--------\
; InitSem >
;========/
; Initialise les smaphores ncessaires au pilote

InitSem:
	pushm.32	d4|a5
	CLR.16		D4
	NTREL		?CRESEM		; Cree le semaphore timer
	jump,ne		r8^f$
	MOVE.32		A5,{A6}+oSemTimer

	CLR.16		D4
	NTREL		?CRESEM
	jump,ne		r8^f$
	MOVE.32		A5,{A6}+oSemWaitTDAFree	; Smaphore d'attente TDA libr
f$:
	popm.32		d4|a5
	test.16		d7
	ret

;-------\\
; KillSem >
;========/
;
; Tue les smaphores du pilote
; 
; In	
; Out	
; Mod	

KillSem:
	pushm.32	a5
	MOVE.32		{A6}+oSemTimer, A5
	comp.32		#0,a5
	jump,eq		r8^s0$
	ntrel		?killsem
s0$:
	MOVE.32		{A6}+oSemWaitTDAFree,A5	; Smaphore d'attente TDA libr
	comp.32		#0,a5
	jump,eq		r8^s1$
	ntrel		?killsem
s1$:
	popm.32		a5
	ret

;-------------\
; StartReceive >
;=============/
;
; Autorise le Sonic a recevoir des paquets
;
; In	A5.32	^Sonic
; Out
; Mod

StartReceive:
;	PUSH.32		D0				; Sauve les registres

	MOVE.16		#2**bSonicRXEN,{A5}+SonicCR	; Met le bit RXEN a 1	

L1$:
;	MOVE.16		{A5}+SonicCR,D0			; Attend que RXDIS soit a 0
;	TEST.32		D0:#bSonicRXDIS
;	JUMP,NE		L1$

;	POP.32		D0				; Recupere les registres
	RET


;------------\
; StopReceive >
;============/
;
; Interdit au Sonic de recevoir des paquets
;
; In	A5.32	^Sonic
; Out
; Mod

StopReceive:
;	PUSH.32		D0				; Sauve les registres
	MOVE.16		#2**bSonicRXDIS,{A5}+SonicCR	; Met le bit RXDIS a 1

L1$:
;	MOVE.16		{A5}+SonicCR,D0			; Attend que RXEN soit a 0
;	TEST.32		D0:#bSonicRXEN
;	JUMP,NE		L1$

;	POP.32		D0				; Recupere les registres
	RET


;--------------\
; StartTransmit >
;==============/
;
; Demarre la transmission d'un paquet
;
; In	A5.32	^Sonic
; Out
; Mod
; On suppose qu'on est pas en train de faire un LCAM (load cam). Le fait de mettre 
; TXP a un quand LCAM est a un aussi bloque le SONIC! On ne veut pas tester LCAM
; a chaque emission d'un paquet par contre quand on charge la cam on attend que 
; l'operation se termine.

StartTransmit:
push.16	d7
lib	?aftim
.ascize	"<CR>Start Transmit ..."
pop.16	d7

;	PUSHM.32	A0				; Sauve les registres
;;	MOVE.32		#{A6}+OTDAStart,A0
;;	MOVE.16		A0,{A5}+SonicCTDA		; Initialise ptr sur zone TDA
	MOVE.16		#2**bSonicTXP,{A5}+SonicCR	; Met le bit TXP a 1

;	POPM.32		A0				; Recupere les registres
	RET


;-------------\
; StopTransmit >
;=============/
;
; Stoppe la transmission d'un paquet
;
; In	A5.32	^Sonic
; Out
; Mod

StopTransmit:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		#2**bSonicHTX,{A5}+SonicCR	; Met le bit HTX a 1
L1$:
	MOVE.16		{A5}+SonicCR,D0			; Attend que TXP soit a 0
	TEST.32		D0:#bSonicTXP
	JUMP,NE		L1$

	POP.32		D0				; Recupere les registres
	RET


;----------\
; Broadcast >
;==========/
;
; Accepte les paquets en mode Broadcast
;
; In	A5.32		^Sonic
; Out
; Mod

Broadcast:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0		
	TSET.32		D0:#bSonicBRD
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET


;------------\
; NoBroadcast >
;============/
;
; Refuse les paquets en mode Broadcast
;
; In	A5.32		^Sonic
; Out
; Mod

NoBroadcast:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0		
	TCLR.32		D0:#bSonicBRD
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET

;----------\
; Multicast >
;==========/
;
; Accepte les paquets en mode Multicast
;
; In	A5.32		^Sonic
; Out
; Mod

Multicast:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0		
	TSET.32		D0:#bSonicAMC
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET


;------------\
; NoMulticast >
;============/
;
; Refuse les paquets en mode Multicast
;
; In	A5.32		^Sonic
; Out
; Mod

NoMulticast:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0		
	TCLR.32		D0:#bSonicAMC
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET



;-------------\
; Promiscuious >
;=============/
;
; Accepte tous les paquets recus
;
; In	A5.32		^Sonic
; Out
; Mod

Promiscuious:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0		
	TSET.32		D0:#bSonicPRO
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET


;---------------\
; NoPromiscuious >
;===============/
;
; Annule le mode Promiscuious
;
; In	A5.32		^Sonic
; Out
; Mod

NoPromiscuious:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0		
	TCLR.32		D0:#bSonicPRO
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET


;------------\
; MacLoopback >
;============/
;
; Effectue un Loopback au niveau du MAC
;
; In	A5.32		^Sonic
; Out
; Mod

MacLoopback:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0
	TSET.32		D0:#bSonicLB0		
	TCLR.32		D0:#bSonicLB1
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET


;--------------\
; EndecLoopback >
;==============/
;
; Effectue un Loopback au niveau de l'ENDEC
;
; In	A5.32		^Sonic
; Out
; Mod

EndecLoopback:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0
	TCLR.32		D0:#bSonicLB0		
	TSET.32		D0:#bSonicLB1
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET


;--------------------\
; TransceiverLoopback >
;====================/
;
; Effectue un Loopback au niveau du Transceiver
;
; In	A5.32		^Sonic
; Out
; Mod

TransceiverLoopback:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0
	TSET.32		D0:#bSonicLB0		
	TSET.32		D0:#bSonicLB1
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET


;-----------\
; NoLoopback >
;===========/
;
; Selectionne le mode normal de fonctionnement
;
; In	A5.32		^Sonic
; Out
; Mod

NoLoopback:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0
	TCLR.32		D0:#bSonicLB0		
	TCLR.32		D0:#bSonicLB1
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET

;-----------------\
; RejectOnCAMMatch >
;=================/
;
; Reject On CAM Match
;

RejectOnCAMMatch:
	push.16		{a5}+SonicCR
	move.16		#2**bSonicRST,{a5}+SonicCR	; Reset Soft
	move.16		{a5}+SonicDCR2,d0
	tset.32		d0:#bSonicRJCM
	move.16		d0,{a5}+SonicDCR2
	pop.16		{a5}+SonicCR
	ret

;-------------------\
; NoRejectOnCAMMatch >
;===================/
;
; Reject On CAM Match disable
;

NoRejectOnCAMMatch:
	push.16		{a5}+SonicCR
	move.16		#2**bSonicRST,{a5}+SonicCR	; Reset Soft
	move.16		{a5}+SonicDCR2,d0
	tclr.32		d0:#bSonicRJCM
	move.16		d0,{a5}+SonicDCR2
	pop.16		{a5}+SonicCR
	ret



	.if	Carte302
;-----------\
; IRQ7       >
;===========/

; ROUTINE D'INTERRUPTION QUI AFFICHE LES REGISTRES DU SONIC

; in	-
; out	-
; mod	-

IRQ7:
	pushm.32	a0|d0
	MOVE.32		#BASE,A0
	MOVE.16		{A0}+O_ISR,D0

	WRITE_STR	68000 ISR : 
	WRITE_4NUM	D0	
	WRITE_CR

	CALL		R16^SHOWREG
	SHOW_68000
	TRAP		#1
	RETSF


;------------\
; IRQ7_INSTALL>
;============/

; intalle une routine d'interruption IRQ7 et met le processeur
; en mode dedicaced ( numero vecteur utilise = 16'17)

; in	-
; out	-
; mod	-

;GIMR_MOD	=	2'1	*(2**B_GIMR_MOD)
;GIMR_IV7	=	2'0	*(2**B_GIMR_IV7)
;GIMR_ET7	=	2'1	*(2**B_GIMR_ET7)


IRQ7_INSTALL:
	PUSHM.32		D0|A0

	MOVE.16		BASE+O_GIMR,D0		;INITIALISE GIMR
	TSET.32		D0:#B_GIMR_MOD
	TCLR.32		D0:#B_GIMR_IV7
	TSET.32		D0:#B_GIMR_ET7
	TCLR.32		D0:#B_GIMR_V
	TSET.32		D0:#B_GIMR_V+1
	TCLR.32		D0:#B_GIMR_V+2
	MOVE.16		D0, BASE+O_GIMR
	
	MOVE.32		#R16^IRQ7, A0	; INSTALLE VECT INTERUPT IRQ7
	MOVE.32		A0, V_IRQ7
	POPM.32		D0|A0
	RET

	.endif	Carte302
;-----------\
; SHOWREG    >
;===========/

; Montre registres internes du chip

; in	-
; out	registres par port seriel
; mod	-

SHOWREG:
	PUSHM.32 	D4|A5|d7

.if	TestSansSONIC
	move.32		#{a6}+oRegSonic,A5	; "Registres" en RAM
.else
	MOVE.32		#AdSonic,A5		; A5 pointe sur le Sonic (on prend la constante
						; lors de l'installation du driver. Permettrait
						; d'avoir plusieurs SONICs
.endif	TestSansSonic
.if	0
	MON		?AFTIM
	.ASCIZE		"CR="
	MOVE.16		{A5}+SonicCR,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" DCR="
	MOVE.16		{A5}+SonicDCR,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" DCR2="
	MOVE.16		{A5}+SonicDCR2,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" RCR="
	MOVE.16		{A5}+SonicRCR,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" TCR="
	MOVE.16		{A5}+SonicTCR,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" IMR="
	MOVE.16		{A5}+SonicIMR,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" ISR="
	MOVE.16		{A5}+SonicISR,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		"<CR>UTDA="
	MOVE.16		{A5}+SonicUTDA,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CTDA="
	MOVE.16		{A5}+SonicCTDA,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" URDA="
	MOVE.16		{A5}+SonicURDA,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CRDA="
	MOVE.16		{A5}+SonicCRDA,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		"<CR>EOBC="
	MOVE.16		{A5}+SonicEOBC,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" URRA="
	MOVE.16		{A5}+SonicURRA,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" RSA="
	MOVE.16		{A5}+SonicRSA,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" REA="
	MOVE.16		{A5}+SonicREA,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" RRP="
	MOVE.16		{A5}+SonicRRP,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" RWP="
	MOVE.16		{A5}+SonicRWP,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" RSC="
	MOVE.16		{A5}+SonicRSC,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		"<CR>CEP="
	MOVE.16		{A5}+SonicCEP,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CAP2="
	MOVE.16		{A5}+SonicCAP2,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CAP1="
	MOVE.16		{A5}+SonicCAP1,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CAP0="
	MOVE.16		{A5}+SonicCAP0,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CE="
	MOVE.16		{A5}+SonicCE,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CDP="
	MOVE.16		{A5}+SonicCDP,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CDC="
	MOVE.16		{A5}+SonicCDC,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		"<CR>CRCT ="
	MOVE.16		{A5}+SonicCRCT,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" FAET="
	MOVE.16		{A5}+SonicFAET,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" MPT="
	MOVE.16		{A5}+SonicMPT,D4
	MON		?AFX4
	MON		?AFTIM
	.ASCIZE		" SR="
	MOVE.16		{A5}+SonicSR,D4
	MON		?AFX4
	MON		?AFTIM
	.ASCIZE		"<CR>"	
	MON		?AFTIM
	.ASCIZE		"<CR>"	
.else
	LIB		?AFTIM
	.ASCIZE		"<CR>CR="
	MOVE.16		{A5}+SonicCR,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" DCR="
	MOVE.16		{A5}+SonicDCR,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" DCR2="
	MOVE.16		{A5}+SonicDCR2,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" RCR="
	MOVE.16		{A5}+SonicRCR,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" TCR="
	MOVE.16		{A5}+SonicTCR,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" IMR="
	MOVE.16		{A5}+SonicIMR,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" ISR="
	MOVE.16		{A5}+SonicISR,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		"<CR>UTDA="
	MOVE.16		{A5}+SonicUTDA,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CTDA="
	MOVE.16		{A5}+SonicCTDA,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" URDA="
	MOVE.16		{A5}+SonicURDA,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CRDA="
	MOVE.16		{A5}+SonicCRDA,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		"<CR>EOBC="
	MOVE.16		{A5}+SonicEOBC,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" URRA="
	MOVE.16		{A5}+SonicURRA,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" RSA="
	MOVE.16		{A5}+SonicRSA,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" REA="
	MOVE.16		{A5}+SonicREA,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" RRP="
	MOVE.16		{A5}+SonicRRP,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" RWP="
	MOVE.16		{A5}+SonicRWP,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" RSC="
	MOVE.16		{A5}+SonicRSC,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		"<CR>CEP="
	MOVE.16		{A5}+SonicCEP,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CAP2="
	MOVE.16		{A5}+SonicCAP2,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CAP1="
	MOVE.16		{A5}+SonicCAP1,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CAP0="
	MOVE.16		{A5}+SonicCAP0,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CE="
	MOVE.16		{A5}+SonicCE,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CDP="
	MOVE.16		{A5}+SonicCDP,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CDC="
	MOVE.16		{A5}+SonicCDC,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		"<CR>CRCT ="
	MOVE.16		{A5}+SonicCRCT,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" FAET="
	MOVE.16		{A5}+SonicFAET,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" MPT="
	MOVE.16		{A5}+SonicMPT,D4
	LIB		?AFX4
	LIB		?AFTIM
	.ASCIZE		" SR="
	MOVE.16		{A5}+SonicSR,D4
	LIB		?AFX4
	LIB		?AFTIM
	.ASCIZE		"<CR>"	
	LIB		?AFTIM
	.ASCIZE		"<CR>"	
 .endif
	POPM.32 	D4|A5|d7
	SETZ
	RET


.if TESTDRIV

;********************
; Variable Programme
;********************
NbRcv	=	4

	.APC	PC_record
	.loc	0
oPntFirst:	.blk.32	1	; ^descr First
oPntLast:	.blk.32	1	; ^descr Last
LgDescList	=	APC


LgBufferCom	=	256	; Buffer pour fournir une commande

	.APC	PC_var
	.LOC	0

oBufferCom:	.blk.8	LgBufferCom	; Buffer pour commande
oBufferComTr:	.blk.8	LgBufferCom	; Buffer pour commande traduite

	.EVEN

ORXSemDriv:	.BLK.32	1	; Semaphore de synchronisation avec le driver en reception
OTXSemDriv:	.BLK.32	1	; idem pour transmission
oPntDescRd:	.blk.8	LgDescList	; ^descr Driver async Lecture (list)
oPntDescWr:	.blk.32	1	; ^descr Driver async Ecriture
oFlag:		.blk.32	1	; Flags divers
 bAffBuffRcv	=	0	; Affiche le buffer de rception
oAdrMC:		.blk.8	LgAdrEth	; buffer pour mettre une adresse multicast
oAdrSrc:	.blk.8	LgAdrEth	; buffer pour une adresse  mettre dans la CAM
oAdrDest:	.blk.8	LgAdrEth	; buffer pour une adresse distante
TestVarLen	=	APC

;*******************************************************************
;               P R O G R A M M E   D E    T E S T 	
;*******************************************************************

	.START	TESTETH
	.APC	PC_code

;*********************************************
; Initialisation Memoire Variables et Buffers 
;*********************************************

TESTETH:	
	.if	assmile
	.else
	lib	?opelib
	.endif

	JUMP	STEST

DRIVARPTR:	.BLK.32		1	; Stocke A6 driver pour le test

STEST:
	MOVE.32		#TestVarLen,D4
	MOVE.16		#MTYPCP,D1
	GESMEM		?GETMEM			; Alloue memoire variables
	push.16		d7
	gesmem		?clearmem
	pop.16		d7
	JUMP,NE		FINTEST$		
	MOVE.32		A4,A6			; A6 ptr sur variables

	lib		?aftim
	.ascize		"<AUTOEFLI><NOROLL><CR>Test du pilote Ethernet SONIC"
	
;***************************
; Initialisation Semaphore
;***************************

	CLR.16		D4
	NTREL		?CRESEM		; Cree le semaphore pour la synchro read avec le driver
	JUMP,NE		ERRTEST$
	MOVE.32		A5,{A6}+ORXSemDriv

	CLR.16		D4
	NTREL		?CRESEM		; Cree le semaphore pour la synchro write avec le driver
	JUMP,NE		ERRTEST$
	MOVE.32		A5,{A6}+OTXSemDriv


.if	TestSansSONIC
	move.32		#{a6}+oRegSonic,A5	; "Registres" en RAM
.else
	MOVE.32		#AdSonic,A5		; A5 pointe sur le Sonic (on prend la constante
						; lors de l'installation du driver. Permettrait
						; d'avoir plusieurs SONICs
.endif	TestSansSonic

	move.32		#{a6}+oPntDescRd,a0	; ^descr list PCB rd
	call		InitList		; Initialise la liste de rception

l$:
	call		SelOrdre	; Slectionne un ordre
	jump,eq		l$

FINTEST$:
push.16	d7
	lib	?aftim
	.ascize	"<CR>Fin du test ?"
pop.16	d7
	lib	?yesno
	jump,ne	l$
	.if	assmile
	exit
	JUMP	FINTEST$	
	.else
	lib	?clolib
	fos	?stop
	.endif	assmile

ERRTEST$:
push.16	d7
	lib	?aftim
	.ascize	"<CR>Erreur ..."
pop.16	d7
	jump	FinTest$

;--------\
; C_Reset >
;========/
;
; Commande de reset du pilote
;
; In	
; Out
; Mod

C_Reset:
push.16	d7
	lib	?aftim
	.ascize	"<CR> S0Reset"
pop.16	d7

	CALLDRIV	S0RESET
	CALLDRIV	SHOWREG		; ^variable driver dans A6.32
	ret

;--------\
; C_Kill  >
;========/
;
; Commande de kill (deinstall) du pilote
;
; In	
; Out
; Mod

C_Kill:
push.16	d7
	lib	?aftim
	.ascize	"<CR> S0Kill"
pop.16	d7

	CALLDRIV	S0KILL
	ret


;-------\
; C_Open >
;=======/
;
; Commande d'ouverture du pilote
;
; In
; Out
; Mod

C_Open:
push.16	d7
	lib	?aftim
	.ascize	"<CR> S0Open "
pop.16	d7
	CALLDRIV	S0OPEN
	ret

;--------------\
; C_Command_LBT >
;==============/
;
; Commande LoopBack Transceiver
;
; In
; Out
; Mod

C_Command_LBT:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Transceiver_LoopBack"
pop.16	d7
	MOVE.32		#R16^c$,a4
	CALLDRIV	S0COMMAND
	ret

c$:	.ascize	"LT"

;--------------\
; C_Command_LBE >
;==============/
;
; Commande LoopBack EnDec
;
; In
; Out
; Mod

C_Command_LBE:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Endec_LoopBack"
pop.16	d7
	MOVE.32		#R16^c$,a4
	CALLDRIV	S0COMMAND
	ret

c$:	.ascize	"LE"

;--------------\
; C_Command_LBM >
;==============/
;
; Commande LoopBack Mac
;
; In
; Out
; Mod

C_Command_LBM:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Mac_LoopBack"
pop.16	d7
	MOVE.32		#R16^c$,a4
	CALLDRIV	S0COMMAND
	ret

c$:	.ascize	"LM"


;---------------\
; C_Command_NoLB >
;===============/
;
; Commande pas de LoopBack
;
; In
; Out
; Mod

C_Command_NoLB:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande pas de LoopBack"
pop.16	d7
	MOVE.32		#R16^c$,a4
	CALLDRIV	S0COMMAND
	ret

c$:	.ascize	"LD"


;---------------\
; C_Command_Prm  >
;===============/
;
; Commande Promiscious Mode (prend tous les paquets)
;
; In
; Out
; Mod

C_Command_Prm:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Promiscious"
pop.16	d7
	MOVE.32		#R16^c$,a4
	CALLDRIV	S0COMMAND
	ret

c$:	.ascize	"PE"


;----------------\
; C_Command_NoPrm >
;================/
;
; Commande pas de Promiscious Mode
;
; In
; Out
; Mod

C_Command_NoPrm:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Promiscious disable"
pop.16	d7
	MOVE.32		#R16^c$,a4
	CALLDRIV	S0COMMAND
	ret

c$:	.ascize	"PD"


;---------------\
; C_Command_Brd  >
;===============/
;
; Commande Broadcast Enable
;
; In
; Out
; Mod

C_Command_Brd:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Broadcast Enable"
pop.16	d7
	MOVE.32		#R16^c$,a4
	CALLDRIV	S0COMMAND
	ret

c$:	.ascize	"BE"

;----------------\
; C_Command_NoBrd >
;================/
;
; Commande Broadcast Disable
;
; In
; Out
; Mod

C_Command_Brd_Off:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Broadcast Disable"
pop.16	d7
	MOVE.32		#R16^c$,a4
	CALLDRIV	S0COMMAND
	ret

c$:	.ascize	"BD"

;---------------\
; C_Command_MC   >
;===============/
;
; Commande Multicast Enable
;
; In
; Out
; Mod

C_Command_MC:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Multicast Enable"
pop.16	d7
	MOVE.32		#R16^c$,a4
	CALLDRIV	S0COMMAND
	ret

c$:	.ascize	"ME"

;----------------\
; C_Command_NoMC  >
;================/
;
; Commande Multicast Disable
;
; In
; Out
; Mod

C_Command_MC_Off:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Multicast Disable"
pop.16	d7
	MOVE.32		#R16^c$,a4
	CALLDRIV	S0COMMAND
	ret

c$:	.ascize	"MD"


;--------\
; PutAdMC >
;========/
;
; Met une adresse dans la CAM

PutAdMC:
	lib		?aftim
	.ascize		"Adresse Ethernet Multicast: 6 bytes (dcimal) LSB first ...   "
	move.32		#{a6}+oAdrMC,a0
	move.16		#LgAdrEth-1,d0
l$:
	lib		?getdec
	move.8		d4,{a0+}
	dj.16,nmo	d0,l$

	move.32		#{a6}+oBufferComTr,a1
	move.8		#"M",{a1+}
	move.8		#"C",{a1+}
	move.32		#{a6}+oAdrMC,a0
	move.16		#LgAdrEth-1,d0
l1$:
	move.8		{a0+},{a1+}
	dj.16,nmo	d0,l1$
	move.8		#0,{a1}


	lib	?aftim
	.ascize	"<CR> Rajoute une adresse au Sonic "

	move.32		#{a6}+oBufferComTr,a4
	CALLDRIV	S0COMMAND
	jump,eq		f$
	lib		?aferror
f$:
	clr.16		d7
	ret

;---------\
; PutAdSrc >
;=========/
;
; Met l'adresse locale dans la CAM

PutAdSrc:
	lib		?aftim
	.ascize		"Adresse Ethernet locale: 6 bytes (dcimal) LSB first ...   "
	move.32		#{a6}+oAdrSrc,a0
	move.16		#LgAdrEth-1,d0
l$:
	lib		?getdec
	move.8		d4,{a0+}
	dj.16,nmo	d0,l$

	move.32		#{a6}+oBufferComTr,a1
	move.8		#"M",{a1+}
	move.8		#"C",{a1+}
	move.32		#{a6}+oAdrSrc,a0
	move.16		#LgAdrEth-1,d0
l1$:
	move.8		{a0+},{a1+}
	dj.16,nmo	d0,l1$
	move.8		#0,{a1}


	lib	?aftim
	.ascize	"<CR> Rajoute une adresse au Sonic "

	move.32		#{a6}+oBufferComTr,a4
	CALLDRIV	S0COMMAND
	jump,eq		f$
	lib		?aferror
f$:
	clr.16		d7
	ret


;--------\
; EnlAdMC >
;========/
;
; Enleve une adresse dans la CAM

EnlAdMC:
	lib		?aftim
	.ascize		"Adresse Ethernet  enlever: 6 bytes (dcimal) LSB first ... "
	move.32		#{a6}+oAdrMC,a0
	move.16		#LgAdrEth-1,d0
l$:
	lib		?getdec
	move.8		d4,{a0+}
	dj.16,nmo	d0,l$


	move.32		#{a6}+oBufferComTr,a1
	move.8		#"C",{a1+}
	move.8		#"M",{a1+}
	move.32		#{a6}+oAdrMC,a0
	move.16		#LgAdrEth-1,d0
l1$:
	move.8		{a0+},{a1+}
	dj.16,nmo	d0,l1$
	move.8		#0,{a1}


	lib	?aftim
	.ascize	"<CR> Enlve une adresse au Sonic "

	move.32		#{a6}+oBufferComTr,a4
	CALLDRIV	S0COMMAND
	jump,eq		r8^f$
	lib		?aferror
f$:
	clr.16		d7
	ret

;-------\
; AdDest >
;=======/
; Dfinit l'adresse de destination

AdDest:
	lib		?aftim
	.ascize		"Adresse Ethernet destination: 6 bytes (dcimal) LSB first ... "
	move.32		#{a6}+oAdrDest,a0
	move.16		#LgAdrEth-1,d0
l$:
	lib		?getdec
	move.8		d4,{a0+}
	dj.16,nmo	d0,l$

	clr.16		d7
	ret



;--------\
; C_TxRcv >
;========/
; 
; Se prpare  recevoir
; Envoie un paquet
; Attend qu'il soit reu

C_TxRcv:
	pushm.32	d3|d4
	call		C_PrepRead
	jump,ne		fe$
	lib		?aftim
	.ascize		"<EOP><noroll><CR>Nombre de boucle d'envoi-rception : "
	lib		?getdec
	test.32		d4
	jump,eq		f$
	lib		?aftim
	.ascize		"<CR>Affiche buffer de rception ?"

	lib		?getcurs			; pos curs -> d3.32

	tset.8		{a6}+oFlag:#bAffBuffRcv
	lib		?yesno
	jump,eq		l$
	tclr.8		{a6}+oFlag:#bAffBuffRcv
l$:
	ex.32		d0,d3
	lib		?ifcar			; test si on veut arrter
	jump,ne		r8^s$
	comp.8		#end,d3
	jump,eq		f$
s$:
	ex.32		d0,d3

	lib		?setcurs
	lib		?afx8			; dcompteur de transmission
	move.32		#0,a0			; prend donnes par dfaut
	call		C_Transmit
	jump,ne		l$			; Si erreur n'attend pas rception
	call		C_Wait_Rcv
	push.32		d4
	move.32		#1,d4			; 1 buffer utilis -> refournit un nouveau
	call		C_PrepRead0		; Se prpare pour une nouvelle rception
	pop.32		d4
	test.16		d7
	jump,ne		r8^f$
	dec.32		d4
	jump,ne		l$
f$:
	popm.32		d3|d4
	test.16		d7
	ret

fe$:
	push.16	d7
	lib	?aftim
	.ascize	" Erreur : "
	pop.16	d7
	push.16	d7
	move.16	d7,d4
	lib	?afx4
	pop.16	d7
	jump	f$


;--------\
; C_RcvTx >
;========/
; 
; Se prpare  recevoir
; Attend qu'il soit reu
; Renvoie le paquet en echo

C_RcvTx:
	pushm.32	a4|d4|A0|D0|d3
	call		C_PrepRead		; Prpare quelques buffers en avance
	jump,ne		fe$
	lib		?aftim
	.ascize		"<CR>Nombre de boucle rception-envoi: "
	lib		?getdec
	test.32		d4
	jump,eq		f$
	move.16		d4,d3
	dec.16		d3
l$:
	ex.32		d0,d3
	lib		?ifcar			; test si on veut arrter
	jump,ne		r8^s$
	comp.8		#end,d3
	jump,eq		f$
s$:
	ex.32		d0,d3
	move.32		#1,d4			; nombre de buffer  prparer
	call		C_PrepRead0		; Se prpare pour une nouvelle rception
	call		C_Wait_Rcv0		; attend un paquet
						; A4.32	^PCB
						; A0.32	^paquet reu
						; d0.32	longueur
						; D4.16	erreur rception
	push.16		d7
	lib		?aftim
	.ascize		"<CR>Status Rcv: "
	lib		?afx4
	pop.16		d7

	jump,ne		r8^fe$
	call		C_Transmit		; et le retransmet

	call		GivBackPCB		; rend PCB lecture
	move.32		a0,a4			; ^paquet -> A4.32
	call		GivRxBuffer		; rend mmoire du buffer de rception

skip,ne	dj.16,nmo	d3,l$
f$:
	popm.32		a4|d4|A0|D0|d3
	test.16		d7
	ret

fe$:
	push.16	d7
	lib	?aftim
	.ascize	" Erreur : "
	pop.16	d7
	push.16	d7
	move.16	d7,d4
	lib	?afx4
	pop.16	d7
	jump	f$

;------------\
; mC_Transmit >
;============/
;
; Transmission multiple
;
; In
; Out
; Mod

mC_Transmit:
	pushm.32	d0|d1|d3|d4|a0
	lib		?aftim
	.ascize		"<CR>Nombre de boucle:"
	lib		?getdec
	test.32		d4
	jump,eq		f$
	
	move.32		d4,d1			; compteur max -> d1.32
	clr.32		d4			; compteur de boucle de transmission -> D4.32
	lib	?aftim
	.ascize	"<NOCURS>"
	lib		?getcurs		; Position -> D3.32
l$:
	lib		?Setcurs
	lib		?afx8			; Affiche nombre de transmission
	clr.32		d0
	move.32		d0,a0			; pour que Transmit prenne un buffer  lui
	call		C_Transmit
	jump,ne		r8^f$
	inc.32		d4
	comp.32		d1,d4
	jump,lo		l$
f$:
	push.16	d7
	lib	?aftim
	.ascize	"<CURS>"
	pop.16	d7

	popm.32		d0|d1|d3|d4|a0
	ret

;------------\
; C_TransmitD >
;============/
;
; Transmet un paquet par dfaut
;
; In	-
; Out	-
; Mod	-

C_TransmitD:
	pushm.32	a0
	clr.32		d0
	move.32		d0,a0
	call		C_Transmit
	popm.32		a0
	ret		

;-----------\
; C_Transmit >
;===========/
;
; Transmet un paquet
;
; In	A0.32	^buffer  transmettre (6 adresse dest, 6 adresse source, 2 type, donnes) (si 0 -> donnes internes)
;	d0.32	longueur
; Out	-
; Mod	-

C_Transmit:
	pushm.32	d4|a4
	call		GetPCB			; ^PCB pour l'criture -> A4.32
	JUMP,NE		ERR$	
	call		TrAndWait		; transmet et attend fin de transmission
						; oPB_RES -> d4.16
	call		GivBackPCB		; rend PCB criture
	move.16		d4,d7			; Erreur de transmission
f$:
	popm.32		d4|a4
	test.16		d7
	ret

Err$:
	push.16	d7
	lib	?aftim
	.ascize	" Erreur GetPCB"
	pop.16	d7
	push.16	d7
	lib	?aferror
	pop.16	d7
	jump	f$

;----------\
; TrAndWait >
;==========/
;
; In	A4.32	^PCB pour transmettre
;	A0.32	^buffer  transmettre (6 adresse dest, 6 adresse source, 2 type, donnes) (si 0 -> donnes internes)
;	d0.32	longueur
; Out	d4.16	status de transmission
;	D7.16	erreur
; Mod	

TrAndWait:
	pushm.32	d0|d3|a4|a5
	push.16	d7
	lib	?aftim
	.ascize	" Tr"
	pop.16	d7

	CALL		INIT_TXPCB		; Initialise le descripteur du paquet
	CALLDRIV	S0WRITE			; Envoie le paquet
	jump,ne		Err$	

	push.16	d7
	lib	?aftim
	.ascize	" W"
	pop.16	d7
	move.32		#5*50,d4
	ntrel		?modtim			; modifie Time out ~5 sec.

	MOVE.32		{A4}+OPB_SEMA,A5	; Smaphore
	NTREL		?WAITEV			; Attend Transmission
	push.16		d7
	ntrel		?modtim
	pop.16		d7


	push.16	d7
	lib	?aftim
	.ascize	"T"
;;	.ascize	"<CR>Transmission effectue"
	pop.16	d7

	JUMP,NE		ERR$

	push.16	d7
	lib	?aftim
	.ascize	"Tx oPB_Res "
	MOVE.16		{A4}+OPB_RES,D4		; Resultat Intermediaire
	lib		?afx4
	pop.16	d7
f$:
	popm.32		d0|d3|a4|a5
	test.16		d7
	ret

Err$:
	push.16	d7
	lib	?aftim
	.ascize	" Erreur S0Write "
	pop.16	d7
	push.16	d7
	lib	?aferror
	pop.16	d7
	jump	f$

;----------\
; C_LoopRcv >
;==========/
; Boucle de:
; - prparation de lecture
; - attente paquet
; - affichage

C_LoopRcv:
	lib		?aftim
	.ascize		"<CR>boucle de rception de paquets rseau (END termine) "
	call		C_PrepRead		; Prpare quelques buffers de rception
	jump,ne		f$
	lib		?getcurs
	move.32		d3,d0
l$:
	move.32		d0,d3
	lib		?setcurs
	call		C_Wait_Rcv		; Attend un paquet
	lib		?ifcar			; test si on veut arrter
	jump,ne		r8^s$
	comp.8		#end,d3
	jump,eq		f$
s$:
	move.32		#1,d4
	call		C_PrepRead0		; reprpare un buffer de rception
	jump,eq		l$			; et boucle
f$:
	test.16		d7
	ret


;-----------\
; C_PrepRead >
;===========/
;
; Prparation pour recevoir des paquets
;
; In	-
; Out	d4.32
; Mod
;


C_PrepRead:
	push.32		d3
	lib		?aftim
	.ascize		"<CR>Nombre de buffer de rception  prparer: "
	lib		?getdec
	pop.32		d3

;------------\
; C_PrepRead0 >
;============/
;
; In:	d4.32	nombre de buffer de rception  prparer en avance

C_PrepRead0:
	pushm.32	d4|d6|a4|a0

	test.32		d4
	jump,eq		f$

push.16	d7
	lib	?aftim
	.ascize	"<CR> Initialise "

	lib	?afx4
	lib	?aftim
	.ascize	" descripteurs de paquets Rx "
pop.16	d7
	dec.16		d4			; pour dj.16,nmo
	move.16		d4,d6			; compteur de buffers  prparer
llrd$:
	call		GetPCB			; ^PCB pour la lecture -> A4.32
	jump,ne		ERR$
	move.32		#{a6}+oPntDescRd,a0	; ^descr list PCB rd
	call		PutLastPCB		; Met PCB dans la liste

	CALL		INIT_RXPCB		; Initialise le descripteur du buffer
	jump,ne		ERR$

push.16	d7
lib		?aftim
.ascize		"<CR> S0Read PCB: "
pop.16	d7
AFX8	a4
	CALLDRIV	S0READ			; donne le buffer au pilote
	dj.16,nmo	d6,llRd$

f$:
	popm.32		d4|d6|a4|a0
	ret

Err$:
	push.16	d7
	lib	?aftim
	.ascize	"<CR>Erreur Prparation rception "
	pop.16	d7
.if	assmile
	exit
.endif
	jump	f$
	

;-----------\
; C_Wait_Rcv >
;===========/
;
; Attend de recevoir un paquet, l'affiche et rend la mmoire
;
; In	-
; Out	-
; Mod	-

C_Wait_Rcv:
	pushm.32	a4|d4|a0|d0
	call		C_Wait_Rcv0		; A4.32	^PCB
						; A0.32	^paquet reu
						; d0.32	longueur
						; D4.16	erreur rception
	jump,ne		r8^f$
	call		GivBackPCB		; rend PCB lecture
	move.32		a0,a4			; ^paquet -> A4.32
	call		GivRxBuffer		; rend mmoire du buffer de rception
f$:
	popm.32		a4|d4|a0|d0
	ret

;------------\
; C_Wait_Rcv0 >
;============/
;
; Attend de recevoir un paquet, l'affiche et le transmet  l'appelant
; c'est l'appelant qui devra rendre la mmoire
;
; In	-
; Out	A4.32	^PCB
;	d4.16	erreur de rception du paquet 
;	A0.32	^buffer de rception
;	d0.32	longueur reue
;	d7.16	erreur
; Mod	-


C_Wait_Rcv0:
	pushm.32	a1|d1|a5

; Prend le 1er PCB de la liste
;*****************************

	move.32		#{a6}+oPntDescRd,a0	; ^descr list PCB rd
	call		GetFirstPCB		; ^First PCB -> A4.32
	jump,eq		r8^s$
	push.16		d7
	lib		?aftim
	.ascize		"<CR>Il n'y a plus de buffer en attente !! "
	pop.16		d7
	jump		f$

; Attend la rception d'un paquet (avec time out pour debug)
;********************************

s$:
ll$:
	AFX8		A4
push.16	d7
	lib	?aftim
	.ascize	"<CR> Attend rception "
pop.16	d7
.if	TestSansSonic
push.16	d7
	lib	?aftim
	.ascize	" (time out 5 sec)"
pop.16	d7
	move.32		#5*50,d4
	ntrel		?modtim			; modifie Time out
.endif	TestSansSonic
	MOVE.32		{A4}+OPB_SEMA,A5	; Semaphore
	NTREL		?WAITEV			; Attend Reception

; Paquet reu ou erreur (time out)
;**********************

.if	TestSansSonic
	push.16		d7
	ntrel		?modtim
	pop.16		d7
	jump,eq		r8^s0$

	push.16		d7
	lib		?aftim
	.ascize		"<CR>Erreur Attente Paquet (time out)"
	pop.16		d7
s0$:
.endif	TestSansSonic

	push.16		d7
	lib		?aftim
	.ascize		"Rx oPB_Res "
	MOVE.16		{A4}+OPB_RES,D4		; Resultat Intermediaire
	lib		?aftab
	lib		?afx4
	pop.16	d7

	comp.16		#-1,d4
	jump,ne		r8^s1$
	lib		?aftim
	.ascize		"<CR> C_Wait_Rcv0: Paquet pas reu !! ou mauvais descripteur !! "
	move.16		d4,d7
	jump		f$
s1$:
; Affiche le paquet Reu (mme en cas de time out pour debug)
;***********************

	call		AffRcvPaquet
	move.32		{a4}+oPB_Buf_Tab+oBuf_Ptr,A0	; ^buffer de rception
	move.32		{a4}+oPB_Buf_Tab+oBuf_L_Len,d0	; longueur totale reue

.if	TestSansSonic
	comp.16		#ertimo,d7
;;	jump,eq		ll$
	jump,ne		r8^f$
	clr.16		d7
.endif	TestSansSonic
f$:
	popm.32		a1|d1|a5
	test.16		d7
	ret

;-------------\
; AffRcvPaquet >
;=============/
;
; Affiche le paquet reu avec  adresse destination, source, type et donne + longueur donnes 
;
; In:	A4.32		^PCB paquet en rception
; Out:	-
; Mod:	-

AffRcvPaquet:
	pushm.32	a0|d0|a1|d1|d7
	move.32		{a4}+oPB_Buf_Tab+oBuf_Ptr,A0	; ^buffer de rception
	move.32		{a4}+oPB_Buf_Tab+oBuf_L_Len,d0	; longueur reue

	test.8		{a6}+oFlag:#bAffBuffRcv
	jump,bc		r8^s1$			; N'affiche pas si pas demand

	move.32		#{a0}+0,a1		; ^adresse destination
	move.32		#LgAdrEth,d1
	call		AffRcvBuffer		; Affiche adresse destination (locale)

	move.32		#{a0}+LgAdrEth,a1	; ^adresse source
	move.32		#LgAdrEth,d1
	call		AffRcvBuffer		; Affiche adresse source (distante)

	move.32		#{a0}+2*LgAdrEth,a1	; ^type ou length
	move.32		#2,d1
	call		AffRcvBuffer		; Affiche le buffer de rception

	move.32		#{a0}+2*LgAdrEth+2,a1	; ^adresse donne
	sub.32		#2*LgAdrEth+2,d0
	jump,mi		r8^s1$
	move.32		d0,d1
	call		AffRcvBuffer		; Affiche le buffer de rception
	lib		?aftim
	.ascize		"<CR>Longueur des donnes reues (sans adresses ni type): "
	move.32		d0,d4
	lib		?afx4
s1$:
	popm.32		a0|d0|a1|d1|d7
	ret

;-------------\
; AffRcvBuffer >
;=============/
;
; Affiche le buffer de rception
;
; In:	A1.32	^buffer
;	D1.32	longueur  afficher

AffRcvBuffer:
	test.8		{a6}+oFlag:#bAffBuffRcv
	jump,bc		f$			; N'affiche pas si pas demand
	call		AfficheMem
f$:
	ret

;-----------\
; AfficheMem >
;===========/
;
; In:	A1.32	^buffer			; Adresse de dbut d'affichage
;	D1.32	longueur reue		; Longueur  afficher
; Out:	
; Mod:	

LgAffich	=	16

AfficheMem:
	pushm.32	A0|A1|D0..D4
	move.32		a1,a0
	lib	?afcr
l$:
	sub.16	#LgAffich,d1
	jump,mi	s$
	move.16	#LgAffich,d0
	call	Affnoctets
	add.32	#LgAffich,A0
	jump	l$
s$:
	add.16	#LgAffich,d1
	move.16	d1,d0
	jump,eq	f$
	call	Affnoctets
f$:
	popm.32		A0|A1|D0..d4
	ret

;-----------\
; Affnoctets >
;===========/
; 
; Affiche n octets sous la forme:
;
; Adresse: <data 8x hexa> <space> <data 8x hexa> <space> <data 2x 8x ASCII>
; 
; In:	A0.32	adresse de base
;	D0.16	longueur  afficher 1..16
; Out:	A0.32	adresse suivante (+16)
; Mod:	...

Affnoctets:
	pushm.32 d1..d4|a1
	move.32	A0,d4		; Affiche adresse mmoire
	lib	?afx8
	move.8	#":",d3
	lib	?afcar
	lib	?afspace

; Affiche data hexa

	move.32	A0,a1		; ^mmoire -> A1.32
	clr.16	d2		; compteur
l1$:
	move.8	{A1+},D4	; Affiche une position
	lib	?afx2
	lib	?afspace

	inc.16	d2		; un de plus affich
	comp.16	d2,d0
	jump,eq	s1$		; gaux -> fini en hexa
	comp.16	#8,d2
	jump,ne	s2$
	lib	?afspace
	jump	l1$
s2$:
	comp.16	#16,d2
	jump,ne	l1$

; Fin d'affichage hexa

s1$:
	sub.16	#16,d2		; d2-16
	neg.16	d2		; 16-d2 -> d2
	move.16	d2,d1
	mul.16	#3,d2		; 2 hex + space
	comp.16	#8,d1
	jump,lo	s3$
	inc.16	d2
s3$:
; d2.16 nombre d'espace  afficher
	test.16	d2
	jump,eq	s4$
	lib	?afspace
	dec.16	d2
	jump	s3$
s4$:
	lib	?afspace
	lib	?afspace

; Affiche data ASCII

	move.32	A0,a1		; Rcupre adresse  afficher
	move.16	d0,d2
ll$:
	move.8	{A1+},D3
;	and.8	#16'7f,d3	; masque bit 7
;	comp.8	#16'20,d3
;	jump,hs	ss$
;	move.8	#".",d3
ss$:
	lib	?afcode
;	lib	?afcar
	dec.16	d2
	jump,ne	ll$

	lib	?afcr

	popm.32 d1..d4|a1
	ret

;---------------\
; C_Statistiques >
;===============/
;
; Lit les statistiques d'erreurs
;
; In
; Out
; Mod

C_Statistiques:
	MOVE.32		#STAT_MEM_LEN+2,D4
	MOVE.16		#MTYPCP,D1
	GESMEM		?GETMEM			; Alloue memoire variables
	gesmem		?ClearMem		; A4.32	^zone pour statistiques
	JUMP,NE		Err$

push.16	d7
	lib	?aftim
	.ascize	"<ROLL><CR> Lecture de statistiques "
pop.16	d7
	CALLDRIV	S0STATUS

; Affiche statistiques
;*********************
move.16		#10,d3				; nombre de digit
move.16		#2**BAFDSP,d2			; mode affichage

lib	?aftim
.ascize	"<CR> Revision number of Driver                   "
clr.32	d4
move.8	{a4}+OS_REVISION,d4
lib	?afdec
lib	?aftab
lib	?afx2

lib	?aftim
.ascize	"<CR> Version number of Driver                    "
clr.32	d4
move.8	{a4}+OS_VERSION,d4
lib	?afdec
lib	?aftab
lib	?afx2

lib	?aftim
.ascize	"<CR> Base Address of Driver variables            "
move.32	{a4}+OS_DRV_MEM,d4
lib	?afdec
lib	?aftab
lib	?afx8

lib	?aftim
.ascize	"<CR> Count of Transmit Interruptions             "
move.32	{a4}+OS_TX_INT_C,d4
lib	?afdec
lib	?aftab
lib	?afx8

lib	?aftim
.ascize	"<CR> Count of Receive Interruptions              "
move.32	{a4}+OS_RX_INT_C,d4
lib	?afdec
lib	?aftab
lib	?afx8

lib	?aftim
.ascize	"<CR> Count of good frames transmitted            "
move.32	{a4}+OS_TX_FR_C,d4
lib	?afdec
lib	?aftab
lib	?afx8

lib	?aftim
.ascize	"<CR> Count of transmit errors                    "
move.32	{a4}+OS_TX_ERR,d4
lib	?afdec
lib	?aftab
lib	?afx8

lib	?aftim
.ascize	"<CR> Count of collisions during transmissions    "
move.32	{a4}+OS_TX_COL,d4
lib	?afdec
lib	?aftab
lib	?afx8

lib	?aftim
.ascize	"<CR> Count of good frames receives               "
move.32	{a4}+OS_RX_FR_C,d4
lib	?afdec
lib	?aftab
lib	?afx8

lib	?aftim
.ascize	"<CR> Count of bytes transmitted (good frames)    "
move.32	{a4}+OS_TX_BYTE_C,d4
lib	?afdec
lib	?aftab
lib	?afx8

lib	?aftim
.ascize	"<CR> Count of bytes received (good frames)       "
move.32	{a4}+OS_RX_BYTE_C,d4
lib	?afdec
lib	?aftab
lib	?afx8

lib	?aftim
.ascize	"<CR> Count of receive CRC errors                 "
move.32	{a4}+OS_BAD_CRC,d4
lib	?afdec
lib	?aftab
lib	?afx8

lib	?aftim
.ascize	"<CR> Miscelaneous counter for debugging purposes "
move.32	{a4}+OS_DEBUG1,d4
lib	?afdec
lib	?aftab
lib	?afx8

lib	?aftim
.ascize	"<CR> Miscelaneous counter for debugging purposes "
move.32	{a4}+OS_DEBUG2,d4
lib	?afdec
lib	?aftab
lib	?afx8

	lib	?aftim
	.ascize	"<CR> State of driver                             "
	clr.32	d4
	move.8	{a4}+OS_STATE,d4
	lib	?afdec
	lib	?aftab
	lib	?afx2

	lib	?aftim
	.ascize	"<CR> CAM  (Appuyez sur une touche)               "
	lib	?getcar

	move.32	#{a4}+oRdCAM,a0
	clr.32	d0
l1$:
	move.32	d0,d4
	lib	?afx2
	lib	?aftab
	move.16	#6-1,d1
l$:
	move.8	{a0+},d4			; Toute l'adresse
	lib	?afx2
	lib	?afspace
	dj.16,nmo	d1,l$
	lib	?aftim
	.ascize	"<CR>                                             "
	inc.16	d0
	comp.16	#NbMaxCam,d0
	jump,lo	l1$

	MOVE.16		#MTYPCP,D1
	Gesmem		?Givmem		; Rend la mmoire
f$:
	test.16		d7
	ret
	
Err$:
push.16	d7
	lib	?aftim
	.ascize	"<CR>Erreur mmoire Statistique "
pop.16	d7
.if	assmile
	exit
.endif	assmile
	jump	f$

;--------\
; C_Close >
;========/
;
; Ferme le pilote
;
; In
; Out
; Mod

C_Close:
push.16	d7
	lib	?aftim
	.ascize	"<CR> S0Close "
pop.16	d7
	CALLDRIV	S0CLOSE
push.16	d7
lib	?aftim
.ascize	"<CR>Fin close"
pop.16	d7
f$:
	ret

;------\
; C_End >
;======/
;
; Fin du programme
;

C_End:
	CLRZ
	ret

;----------\
; C_ShowReg >
;==========/
;
; Affiche les registres du Sonic

C_ShowReg:
	calldriv	showreg
	SETZ
	ret

ToggleAffRx:
	pushm.32	d0|d3
	lib		?aftim
	.ascize		"<CR>Affiche buffer de rception ?"

	lib		?getcurs			; pos curs -> d3.32

	tset.8		{a6}+oFlag:#bAffBuffRcv
	lib		?yesno
	jump,eq		l$
	tclr.8		{a6}+oFlag:#bAffBuffRcv
l$:
	ex.32		d0,d3
	lib		?ifcar			; test si on veut arrter

	comp.8		#end,d3

	ex.32		d0,d3
	popm.32		d0|d3
	ret

;---------\
; SelOrdre >
;=========/
;
; Slection d'un ordre et excution
;
; In
; Out
; Mod

SelOrdre:
	move.32	#R16^Menu,a3
	lib	?afmenu
l$:
	lib	?aftim
	.ascize	"<CR>Slectionne un ordre: "
 	move.32	#R16^TOrdre,A0
	lib	?getcar			; code touche -> D3.16
l1$:
	move.16	{a0+},d0
	jump,eq	l$			; fin de la table
	comp.16	d0,d3			; touche connue ?
	jump,eq	s1$			; oui -> s1$
	add.32	#2,A0
	jump	l1$			; essaie plus loin
s1$:
	move.16	{a0},d0			; offset
	move.32	#R16^TOrdre,a0
	move.32	#{a0}+A16^{D0},A0	; adresse de la routine -> A0.32
	call	{a0}			; et y saute
	ret

TOrdre:
	.16.16	F0,C_End-TOrdre

	.16.16	shift+F1,C_Kill-TOrdre			; Deinstall le pilote
	.16.16	F1,C_Reset-TOrdre			; Install le pilote

	.16.16	shift+F2,C_Close-TOrdre			; Ferme le pilote
	.16.16	F2,C_Open-TOrdre			; Ouvre le pilote

	.16.16	shift+F3,C_Showreg-TOrdre		; Affiche les registres Sonic
	.16.16	F3,C_Command_manuelle-TOrdre		; Ordre manuel

	.16.16	shift+F4,C_Command_NoLB-TOrdre		; Commande pas de LoopBack
	.16.16	F4,C_Command_LBT-TOrdre			; Commande Transceiver_LoopBack

	.16.16	shift+F5,C_Command_LBE-TOrdre		; Commande Endec_LoopBack
	.16.16	F5,C_Command_LBM-TOrdre			; Commande Mac_LoopBack

	.16.16	shift+F6,C_Command_NoPrm-TOrdre		; Commande Promiscious disable"
	.16.16	F6,C_Command_Prm-TOrdre			; Commande Promiscious"

	.16.16	shift+F7,C_Command_Brd_Off-TOrdre	; Commande Broadcast Disable
	.16.16	F7,C_Command_Brd-TOrdre			; Commande Broadcast Enable"

	.16.16	shift+F8,C_Command_MC_Off-TOrdre	; Commande Multicast Disable
	.16.16	F8,C_Command_MC-TOrdre			; Commande Multicast Enable"

	.16.16	F9,C_Statistiques-TOrdre		; Lecture de statistiques "

	.16.16	shift+F10,EnlAdMC-TOrdre		; Enlve une adresse rception
	.16.16	F10,PutAdMC-TOrdre			; Rajoute une adresse

	.16.16	shift+F11,PutAdSrc-TOrdre		; Met adrese src
	.16.16	F11,AdDest-TOrdre			; Dfinit l'adresse destination

	.16.16	shift+F12,ToggleAffRx-TOrdre
	.16.16	F12,C_LoopRcv-TOrdre			; Boucle de rception de paquets

	.16.16	shift+F13,mC_Transmit-TOrdre		; Transmet plusieurs paquets
	.16.16	F13,C_TransmitD-TOrdre			; Transmet un paquet

	.16.16	shift+F14,C_Wait_Rcv0-TOrdre		; Attend rception 1 paquet avec affichage
	.16.16	F14,C_PrepRead-TOrdre			; Prparation pour recevoir des paquets

	.16.16	shift+F15,C_RcvTx-TOrdre		; Prpare rception, attend rception et Transmet echo
	.16.16	F15,C_TxRcv-TOrdre			; Prpare rception, Transmet et attend rception
	.16	0


Menu:
	.asciz	""
	.asciz	"Fin"
		;     ;     ;     ;
	.asciz	"Kill  Close ShowR"
	.asciz	"Reset Open  Comm."
		;     ;     ;     ;
	.asciz	"NoLB   LBE  NoPrm"
	.asciz	" LBT   LBM   Prm "
		;     ;     ;     ;
	.asciz	"NoBrd NoMC       "
	.asciz	"Brd   MultC  Stat"
		;     ;     ;     ;
	.asciz	"-MC.. AdSrc AffRx"
	.asciz	" MC.. AdDis LpRcv"
		;     ;     ;     ;
	.asciz	"mTx  WaitRx RcvTx"
	.ascize	"Tx   PrepRx TxRcv"

; ********************************************************
; Paquet Exemple a Transmettre separe en trois fragments :
; Donnees, Adresse Source, Adresse Destination
; ********************************************************

TR_DATA:
	.8.8	16'CA,16'FE
	.ASCII "Ceci est un beau paquet Ethernet avec Suffisament de caracteres..."
	.ASCIZ "Il devrait d'ailleurs etre suffisamment long pour pouvoir passer le test"
LgTXData	=	APC - TR_DATA
	.even

SRC_ADR:
AdrLocal:
TR_ADR:
	.16	AdPhys2,AdPhys1,AdPhys0		; Adresse Source
	.BLK.16	1

;;TR_ADR:
	.16	16'0102,16'FFFF,16'ABCD		; Adresse Broadcast

	
;**********************************************
; Initialisation buffers et structure PCB Read
;**********************************************
; Attention, le ^buffer de rception doit pointer sur une adresse multiple de 4 
; pour bus 32 bits
;
; in	A6.32	^var
;	A4.32	^PCB
; out	A4	^PCB intialis
; mod	-

INIT_RXPCB:	; Initialise structure PCB reception avec Buffer

	PUSHM.32	A0|A1|d1|d4|d5|a5

	move.32		A4,a1			; ^PCB -> A1.32
	
	MOVE.32		#LgRXBuffer,D4		; Longueur du buffer de rception
	MOVE.32		#16'0,A4		; Adresse min du debut de la portion de memoire
	MOVE.32		#16'FFFFFC,A5		; Adresse max du debut de la portion de memoire
	MOVE.32		#16'4,D5		; Modulo d'alignement (un seul 1)
	MOVE.16		#MTYPCP,D1		; Type
	GESMEM		?GETALMEM		; Adresse de la memoire allouee dans A4.32
						;    memoire buffer RX
	JUMP,NE		r8^ERR$	
	EX.32		A4,A1			; ^buffer -> A1.32
						; ^PCB -> A4.32
	MOVE.32		{A6}+ORXSemDriv,A0
	MOVE.32		A0,{A4}+OPB_SEMA	; Indique semaphore a signaler dans le PCB
	MOVE.16		#1,{A4}+OPB_BUF_NB	; Indique un seul buffer ( pour read )
	MOVE.32		#{A4}+OPB_BUF_TAB,A0	; Aligne A0 ^sur descriptif buffer
	MOVE.32		#LgRXBuffer,{A0}+OBUF_P_LEN
	MOVE.32		#LgRXBuffer,{A0}+OBUF_L_LEN	; Indique longueur buffer
	MOVE.32		A1,{A0}+OBUF_PTR		; Donne pointeur sur buffer

FIN$:
ERR$:
	POPM.32		A0|A1|d1|d4|d5|a5
	test.16		d7
	RET


;***********************************************
; Initialisation buffers et structure PCB WRITE
;***********************************************

;-------\
; GetPCB >
;=======/
;
; Demande une zone mmoire pour un PCB et l'initialise  0
;
; In	-
; Out	A4.32	^PCB
;	D7.16	selom ?GetMem
; Mod
;
; Variable supplmentaire dans le PCB pour lien des PCB utilisateur

	.APC	PC_RECORD
	.LOC	PB_Len
oLnkPCB:	.blk.32	1		; ^next PCB, user use
nPB_Len	=	APC

	.APC	PC_CODE
	
GetPCB:
	pushm.32	d4|d1
	MOVE.32		#nPB_LEN,D4
	MOVE.16		#MTYPCP,D1
	GESMEM		?GETMEM			; Alloue memoire structure PCB
	push.16		d7
	GESMEM		?CLEARMEM
	pop.16		d7
	popm.32		d4|d1
	ret

;-----------\
; GivBackPCB >
;===========/
;
; Rend la mmoire pour un PCB
;
; In	A4.32	^mmoire PCB  rendre
; Out
; Mod

GivBackPCB:
	pushm.32	d1
	move.16		#mtypcp,d1
	Gesmem		?GivMem
	popm.32		d1
	ret

;---------\
; InitList >
;=========/
;
; Initialise une liste chane
; oPntFirst	^1er lment
; oPntLast	^dernier lment
;
; In	A0.32	^descripteur de la liste
; Out
; Mod

InitList:
	move.32	#0,{a0}+oPntFirst
	move.32	#0,{a0}+oPntLast
	ret

;-----------\
; PutLastPCB >
;===========/
;
; Rajoute un PCB  la fin de la list
;
; In	A0.32	^descr de la list
;	A4.32	^PCB
; Out:	-
; Mod

PutLastPCB:
	move.32	#0,{a4}+oLnkPCB		; ^link = nil
	test.32	{a0}+oPntLast		; last = ^nil -> 1er lment  mettre
	jump,eq	r8^s1$

; rajoute un lment fin de liste

	push.32	a1
	move.32	{a0}+oPntLast,A1	; ^last courant
	move.32	a4,{a1}+oLnkPCB		; y effectue le lien avec nouveau PCB
	move.32	a4,{a0}+oPntLast	; et le met  la fin de la liste
	pop.32	a1
	jump	r8^f$

; 1er lment de la liste

s1$:
	move.32	a4,{a0}+oPntFirst
	move.32	a4,{a0}+oPntLast
f$:
AFX8	A4
	ret

;------------\
; GetFirstPCB >
;============/
;
; Retire 1er PCB de la list
;
; In:	A0.32	^descr de la list
; Out: 	A4.32	^PCB
; 	D7.16	-1 si list vide
; Mod

GetFirstPCB:
	test.32		{a0}+oPntFirst		; first = ^nil -> plus rien dans la liste
	jump,eq		r8^fe$

; prend 1er lment de la liste

	move.32		{a0}+oPntFirst,A4	; ^first PCB -> A4.32
	move.32		{a4}+oLnkPCB,{a0}+oPntFirst	; met le suivant comme 1er
	jump,ne		r8^s1$			; Link ^sur nil si =0
	move.32		#0,{a0}+oPntLast	; c'tait le dernier
s1$:
	clr.16		d7			; pas d'erreur
f$:
	ret

fe$:
	move.32		#0,a4			; pour ne pas avoir un pointeur bidon en cas de fin de liste
	move.16		#-1,d7
	jump		f$

;------------\
; GivRxBuffer >
;============/
;
; Rend la mmoire du buffer de rception
;
; In	A4.32	^buffer
; Out
; Mod	-

GivRxBuffer:
	pushm.32	d1
	move.16		#mtypcp,d1
	Gesmem		?GivMem
	popm.32		d1
	ret

;***************************************************************************
; Init pour transmission
;***************************************************************************

;-----------\
; INIT_TXPCB >
;===========/
;
; Initialise structure PCB emission avec Buffer en trois fragments
;
; in	A6.32	^var
;	A4.32	^PCB
;	A0.32	^buffer  transmettre (6 adresse dest, 6 adresse source, 2 type, donnes) (si 0 -> donnes internes)
;	d0.32	longueur
; out	A4.32	^PCB intialise
;	D7.16	erreur
; mod

INIT_TXPCB:
	PUSHM.32	A0|A1|a2

	MOVE.32		{A6}+OTXSemDriv,a1
	MOVE.32		a1,{A4}+OPB_SEMA	; Indique semaphore a signaler dans le PCB
	MOVE.16		#3,{A4}+OPB_BUF_NB	; Indique trois buffers ( pour write )
	MOVE.32		#{A4}+OPB_BUF_TAB,a1	; a1.32 ^sur descriptif buffer

	comp.32		#0,a0
	jump,eq		r8^s$

; Donnes fournies en paramtre
; Attention, inversion des adresses

	MOVE.32		#LgAdrEth,{a1}+OBUF_L_LEN	; Indique longueur adresse dest
	MOVE.32		#{a0}+LgAdrEth,a2		; 2me adresse reue devient destination
	MOVE.32		a2,{a1}+OBUF_PTR		; Donne pointeur sur adresse
	ADD.32		#BLEN,a1			; Passe descriptif suivant

	MOVE.32		#LgAdrEth,{a1}+OBUF_L_LEN	; Indique longueur adresse src
	MOVE.32		#{a0},A2
	MOVE.32		a2,{a1}+OBUF_PTR		; Donne pointeur sur adresse
	ADD.32		#BLEN,a1	

	sub.32		#2*LgAdrEth,d0
	MOVE.32		d0,{a1}+OBUF_L_LEN		; Indique longueur donnees
	MOVE.32		#{a0}+2*LgAdrEth,a2
	MOVE.32		a2,{a1}+OBUF_PTR		; Donne pointeur sur donnees
	jump		r8^f$

; Donnes par dfaut
s$:
	MOVE.32		#LgAdrEth,{a1}+OBUF_L_LEN	; Indique longueur adresse dest
	MOVE.32		#{a6}+oAdrDest,a0
	MOVE.32		a0,{a1}+OBUF_PTR		; Donne pointeur sur adresse
	ADD.32		#BLEN,a1			; Passe descriptif suivant

	MOVE.32		#LgAdrEth,{a1}+OBUF_L_LEN	; Indique longueur adresse src
	MOVE.32		#{a6}+oAdrSrc,a0
	MOVE.32		a0,{a1}+OBUF_PTR		; Donne pointeur sur adresse
	ADD.32		#BLEN,a1	

	MOVE.32		#LgTXData,{a1}+OBUF_L_LEN	; Indique longueur donnees
	MOVE.32		#R16^TR_DATA,a0
	MOVE.32		a0,{a1}+OBUF_PTR		; Donne pointeur sur donnees
f$:
	POPM.32		A0|A1|a2
	test.16		d7
	RET


;------------------\\
; C_Command_manuelle >
;===================/
;
; Envoi d'une commande manuelle
; 
; In	A6.32	^variables de test
; Out	
; Mod	

C_Command_manuelle:
c$:
	lib		?aftim
	.ascize		"<CR>Commande  fournie: "
	move.32		#{a6}+oBufferCom,a3
	move.32		#LgBufferCom,d3
	lib		?getline
	comp.8		#HELP,d3
	jump,eq		h$
	move.32		#{a6}+oBufferComTr,A4
	move.32		#LgBufferCom,d4
	lib		?trComm
push.16	d7
	lib	?aftim
	.ascize	"<CR> Envoi d'une commande "
pop.16	d7
	CALLDRIV	S0COMMAND
	ret

h$:
	lib	?aftim
	.ascii	"<CR>LM ou LC  Loopback au niveau du MAC (contrleur)"
	.ascii	"<CR>LE ou LS  Loopback au niveau de l'ENDEC (srialisateur)"
	.ascii	"<CR>LT        Loopback au niveau du Transceiver"
	.ascii	"<CR>LD        Loopback Disable"
	.ascii	"<CR>PE        Promiscuous Enable"
	.ascii	"<CR>PD        Promiscuous Disable"
	.ascii	"<CR>BE        Broadcast Enable"
	.ascii	"<CR>BD        Broadcast Disable"
	.ascii	"<CR>A[6 * .b] Add Address ou Multicast address"
	.ascii	"<CR>MC[6 * .b] Address Multicast"
	.ascii	"<CR>CM[6 *.b] Clear Multicast adresse (enlve une adresse multicast de la liste)"
	.ascii	"<CR>ICAM      Initialise variable CAM"
	.ascii	"<CR>TCAM   +param [xx.L] nombre d'essais CAM"
	.ascize	""
	jump	c$

.endif

.END


 
