	.TITLE	SONIC_TEST.ASM

	.PROC		M68000
	.BASE		10		; base 10 par defaut
	.LAYOUT		HEX		; listing en hexadecimal

	.REF		SMAKY		; reference generale
	.REF		MON
	.REF		NTREL
	.REF		BIOSDRIV
	.REF		BIOS


MajRev		=	1		; revision majeure
MinRev		=	8		; revision mineure

; Le programme de test est  excuter sous smile

.REV		MajRev,MinRev


;changements:	-passe de mode 32 bits en mode 16 bit. Tout les acces au registres
;		du sonic doivent etre fait par des operations 16 bits.
;		-reecrit les routines d'initialisation et de desinitialisation
;		des interruptions.
;commentaires:	-adresse sonic souvent chargee dans A5 mais pas toujours utilisee.
;		-ne pas oublie remettre les ION et IOFF pour tourner en mode driver
;a faire:	- verifier que tout les points d'entree sauvent A5 et que toutes les
;		routines le chargent.
;		-ajouter une routine pour enlever des adresses physiques.
;		-faire des comandes standard 
;		-tester que le resultat et vraiment mis a zero si il n y a pas d'erreur ({A4}+OPB_RES)
;a tester:
;		-lecture chainee
;		-ecriture chainee
;		-commande 'A' et autres commandes standard
; 1.0	RB	93/02/23	Modification pour adaptation S130
;		93/02/25	Interruption vectorise S130 + Autovectorise niveau 2
; 1.1	RB	93/03/08	Bug dans InitLCAM au Reset (+16'10 dans le code  la place de oCamEnable)
;				tstLCAM pour test DMA
; 1.2	RB	93/04/05	Suite des tests
; 1.3 ..1.8			Lgre adaptation pour tests
; 1.9	RB	93/08/09	Reprise, test plus complets

; Choix version Carte302/S130
;****************************
Carte302	=	false		; Carte avec 68302 du LTI (BB)
S130		=	true		; Carte pour S130 du LAMI (RB)

;*************
; MODE TEST
;*************

TESTDRIV	=	true		; genere programme de test  la place d'un driver
.if	Testdriv
assmile	=	true
.else
assmile	=	false
.endif
tstLCAM		=	true		; boucle dans le chargement de la LCAM (test DMA)
DEBUG		= 	true ;FALSE		; commentaires
; ** MODIFICATION 7.12.92, CHANGE IR7 POUR QU'IL SOIT FALSE, PH.
IR7		= 	FALSE		; installe la routine du nmi

	.IF	Carte302
	.REF		GCM302HARD
BUS16	=	true			; la carte 68302 a un bus de 16 bits
BUS32	=	false
	.endif
	.IF	S130
BUS16	=	false
BUS32	=	true			; le bus d'extension du s130 est sur 32 bits
	.endif


;**************
; Def APC
;**************

PC_code		=	0
PC_var		=	1
PC_record	=	2

	.APC	PC_code
	.LOC	0
	.APC	PC_var
	.LOC	0
	.APC	PC_record
	.LOC	0

;*****************
;  Def MACROS
;*****************
	.INS		MACROS.ASI

; Macro pour le programme de test inclus en fin du source

	.MACRO		CALLDRIV	; Appel Driver simule avec sauvetage des registres
	PUSHM.32	D0..D7|A0..A6
	MOVE.32		R16^DRIVARPTR,A6	; Recupere ptr vars driver
;	SUP	
	CALL		%1
;	USER
;	exit
	MOVE.32		#R16^DRIVARPTR,A0
	MOVE.32		A6,{A0}	
	POPM.32		D0..D7|A0..A6
	test.16		d7
	.ENDMACRO

; Mode User

	.MACRO		CALLDRIVU	; Appel Driver simule avec sauvetage des registres
	PUSHM.32	D0..D7|A0..A6
	MOVE.32		R16^DRIVARPTR,A6	; Recupere ptr vars driver
	CALL		%1
	MOVE.32		#R16^DRIVARPTR,A0
	MOVE.32		A6,{A0}	
	POPM.32		D0..D7|A0..A6
	test.16		d7
	.ENDMACRO


;************
; Constantes
;************

	.if	Carte302
AdSonic		=	16'F02000	; Adresse physique du Sonic
;n'existe plus ! AdReset		=	16'FFFC80	; Adresse du Ha
	.endif
	.if	S130
AdSonic		=	16'1C000000+2**29	; Mode non cacheable (A29=1)
AdWrVect	=	16'1C002000+2**29	; Pour crire le vecteur d'interruption
VectSonic	=	16'C0			; A vrifier!!
AVectSonic	=	16'18+2			; Autovecteur 2
	.endif

AdPhys0		=	16'0606		; Adresse physique Ethernet par defaut, LSB
AdPhys1		=	16'0606		; Adresse physique Ethernet par defaut
AdPhys2		=	16'0303		; Adresse physique Ethernet par defaut, MSB
NbMaxCam	=	16		; Nombre maximum d'adresses multicast
LgMaxEth	=	1518+4		; Longueur maximale d'un paquet Ethernet
					; Plus 4 pour les debordement eventuels du chip Sonic
LgMinEth	=	64		; Longueur minimum d'un bloc Ethernet
NULL		=	0
NbMaxRdBuf	=	100		; Nombre max de descripteurs de ressources reception
LgAdrEth	=	6		; Longueur d'un adresse
EOL		=	1		; End Of List du sonic
TCRConfig	=	0		; Config registre TCR

	.if	BUS16
LgRxBuffer	=	LgMaxEth	; Longueur du buffer de reception. Doit etre LgMaxEth+2
					; en mode 32 bits.
	.endif
	.if	BUS32
LgRxBuffer	=	10'1524		; Longueur du buffer de reception. Doit etre LgMaxEth+2
					; en mode 32 bits.
	.endif

;******************
; Etats du Driver
;******************

CLOSED		=	1
IDLE		=	2

;************************
; Codes Erreur du Driver
;************************

NO_ERR		=	0
ERR_NO_INIT	=	1	; Attempt to use driver before it is initialised
DRV_OVER_CLOSE	=	2	; More closes than opens
ERR_EMPTY_BUF	=	3	; Buffer is empty
ERR_FRG_CNT	=	4	; Trop de fragments ( ou plus que 1 fragment pour read )
ERR_SIZE_BUF	=	5	; Buffer trop petit pour read ou write ou status
ERR_MAX_BUF	=	6	; Nombre de buffers en lecture maximum depasse
ERR_CMD_TYPE	=	7	; Commande Incorrecte
ERR_NB_CAM	=	8	; Nombre de descripteurs de CAM depasse
ERR_TX		=	9	; Erreur de Transmission
ERR_RX		=	10	; Erreur de Reception ( CRC ou Runt packet )

;*********************
; Commandes du Driver
;*********************

MAC_LOOP	=	0	; Loopback au niveau du MAC
ENDEC_LOOP	=	1	; Loopback au niveau de l'ENDEC
TRANS_LOOP	=	2	; Loopback au niveau du Transceiver
LOOP_OFF	=	3	; Loopback Disable
PRMSC_ON	=	4	; Promiscuous Enable
PRMSC_OFF	=	5	; Promiscuous Disable
BROAD_ON	=	6	; Broadcast Enable
BROAD_OFF	=	7	; Broadcast Disable
ADD_MULTI	=	16'41	; Add MultiCast Adress (charactere A pour compatibilite Beuchat

	.INS		ASYNC.ASS	; Insere descripteur structure passage parametres
	.INS		SONIC_DEF.ASI	; Definition des registres internes du Sonic

;********************
; Structure Commande
;********************
; Commande sous forme de .16 :  modifier prochainement
	.LOC	0

OCMD_TYPE:	.BLK.16	1		; Type de Commande ( cf codes ci-dessus )
OCMD_Ad:	.BLK.8	LgAdrEth	; Adresse Transmise LSB..MSB

CMD_LEN		=	APC

;*******************
; Variables driver
;*******************

; Cette zone doit tenir dans un unique bloc de 64k, ce qui limite le choix du nombre max
; de buffers en attente de READ. Cette zone doit de plus etre alignee au debut d'un bloc de 64k

	.APC	PC_record
	.LOC	0

	;; Stats block, returned by STATS command.
		
OS_REVISION:	.BLK.8	1	; Revision number of Driver
OS_VERSION:	.BLK.8	1	; Version number of Driver
OS_DRV_MEM:	.BLK.32	1	; Base Address of Driver variables
OS_TX_INT_C:	.BLK.32	1	; Count of Transmit Interruptions
OS_RX_INT_C:	.BLK.32	1	; Count of Receive Interruptions
OS_TX_FR_C:	.BLK.32	1	; Count of good frames transmitted
OS_TX_ERR:	.BLK.32	1	; Count of transmit errors
OS_TX_COL:	.BLK.32	1	; Count of collisions during transmissions
OS_RX_FR_C:	.BLK.32	1	; Count of good frames receives
OS_TX_BYTE_C:	.BLK.32	1	; Count of bytes transmitted (good frames)
OS_RX_BYTE_C:	.BLK.32	1	; Count of bytes received (good frames)
OS_BAD_CRC:	.BLK.32	1	; Count of receive CRC errors
OS_DEBUG1:	.BLK.32	1	; Miscelaneous counter for debugging purposes
OS_DEBUG2:	.BLK.32	1	; Miscelaneous counter for debugging purposes
OS_STATE:	.BLK.8	1	; State of driver
		.EVEN
STAT_MEM_LEN	=	APC

ODR_ETAT:	.BLK.8		1	; Etat du driver
		.align	4
ODR_TETE:	.BLK.32		1	; Tete de liste READ
ODR_QUEUE:	.BLK.32		1	; Queue de liste READ
ODW_TETE:	.BLK.32		1	; Tete de liste WRITE
ODW_QUEUE:	.BLK.32		1	; Queue de liste WRITE

DRIV_STATE:	.BLK.8		1	; Etat du driver
		.align	4
NBRD_BUF:	.BLK.16		1	; Nombre de buffers en attente lecture ( <NbMaxRdBuf )
ONbCamDesc:	.BLK.16		1	; Nombre de descripteurs de CAM
OAD_SONIC:	.BLK.32		1	; Adresse du SONIC

	.align	4		; alignement 32 bits

;**************
; Champs SONIC
;**************
; Descripteurs en mmoire
;------------------------
; RRA:	Receive Ressource Area -> Pointe sur les RBA libres
; RDA:	Receive Descriptor Area
; RBA:	Receive Buffer Area
;
; TDA:	Transmit Descriptor Area
; TBA:	Transmit Buffer Area
;
; CDA:	CAM Descriptor Area: CAM: Content Access Memory
;
; Registres SONIC
;----------------
; UTDA, CTDA:	Current Transmit Descriptor Area pointer
; URDA, CRDA:	Current Receive Descriptor Area pointer
;
; URRA, RSA:	Ressource Start Area
; URRA, RRP:	Ressource Read Pointer
; URRA, RWP:	Ressource Write Pointer
; URRA, REA:	Ressource End Area
;
; URRA, CDP:	CAM Descriptor Pointer
;
;PH
; RB -> .8
; Attention  ne pas modifier l'ordre des variables

ORRAStart:	.BLK.8		LgRXrsrcDescriptor*NbMaxRdBuf	; Zone pour les descripteurs de buffers
oRRAEnd:
ORDAStart:	.BLK.8		LgRXpktDescriptor*NbMaxRdBuf	; Zone pour les descripteurs de paquet
oRDAEnd:
OTDAStart:	.BLK.8		LgTxpktDescriptor		; Zone pour stocker un TDA de taille maximale (16 fragments)
oTDAEnd:
OCAMStart:	.BLK.8		LgCam				; Zone pour stocker la table des CAM
oCAMEnd:

LgVarZone	=	APC	; Attention, doit etre < 64k ...!


;***************************
;* *********************** *
;* *   Debut du DRIVER   * *
;* *********************** *
;***************************


	.APC	PC_CODE


DEBUT:
	.16	10'0,S0BASE	; Pilote 0
;	.16	10'1,S0BASE	; Pilote 1
	.16	2**7		; fin 1ere indirection



; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $eth_0	No H'5A
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

S0ID:				; Adresse routines
	.16	S0OPEN-S0BASE
	.16	S0COMMAND-S0BASE
	.16	S0STATUS-S0BASE
	.16	S0READ-S0BASE
	.16	S0WRITE-S0BASE
	.16	S0CLOSE-S0BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1
	.16	-1			; S0AUX2-S0BASE
	.16	S0RESET-S0BASE
	.16	S0KILL-S0BASE
	.16	-1			; S0STRT-S0BASE
	.16	-1			; S0TSTRT-S0BASE
	.16	-1			; S0START-S0BASE

S0NAB:	.ASCII	"ETH_0"			; Nom driver
S0NAF:	.FILL.8 LGDNAM-(S0NAF-S0NAB),0

	.8	16'5A			; Numero driver
	.8	TYPIO			; Type: Streamer

	.8	MAJREV,MINREV		; Revision - version -
	.16	0			; - Variante

	.8	0			; Attribut 1
	.8	2**BDWROK.OR.2**BDRDOK	; Attribut 0
	.FILL.8 	LGDDESC-(APC-S0ID), 0	; Le reste.
S0BASE:

;***************************************************************************************
;--------\
; S0RESET >
;========/
;***************************************************************************************
;
; Appelle lors de l'INSTALL 
;
; In	A2.32	^ligne de parametres d'installation
; Out	A6.32	^variables globales du pilote
; Mod	rien
;D1|D2|A0|A3|A5
;

S0RESET:
.if	DEBUG
	WRITE_STR_C	ETH:Reset
.endif
	PUSHM.32	A5
	MOVE.32		#AdSonic,A5		; A5 pointe sur le Sonic (on prend la constante
						; lors de l'installation du driver. Permetterait
						; d'avoir plusieurs SONICs

	CALL		RequestMem		; Demande la memoire, initialise les variables
push.16	d7
lib	?aftim
.ascize	"<CR>RequestMem"
pop.16	d7
	jump,ne		f$
	MOVE.32		A5,{A6}+OAD_SONIC	; Met a jour l'adresse du Sonic

	CALL		InitMEM			; Initialise zone CDA
	CALL		InitSonic
	CALL		InitInterrupt
	CALL		InitCAM			; Vide entre de CAM
.if 	IR7
	CALL		IRQ7_Install
.endif
	MOVE.8		#CLOSED,{A6}+DRIV_STATE	; Driver initialise, non ouvert
f$:
	POPM.32		A5
	test.16		d7
	RET


;-----------\
; RequestMem >
;===========/
;
; Demande la memoire necessaire et initialise les variables du programme principal
;
; In	
; Out	A5.32	^Sonic
;	A6.32	^variables
; Mod
; RB Modif ClearMem et test erreur
RequestMem:
	PUSHM.32	D0|D1|D4|D5|A4|A5
;BUG	MOVE.32		#LgVarZone,D4		; Longueur zone variables et descripteurs
	MOVE.32		#16'10000,D4
	MOVE.32		#16'0,A4		; Adresse min du debut de la portion de memoire
	MOVE.32		#16'FFFFFE,A5		; Adresse max du debut de la portion de memoire
	MOVE.32		#16'10000,D5		; Modulo d'alignement (un seul 1)
	MOVE.16		#MTYPCP,D1		; Type
	GESMEM		?GETALMEM		; Adresse de la memoire allouee dans A4.32
.if	DEBUG
	WRITE_STR	Erreur a l'allocation de la memoire :
	WRITE_4NUM	D7
	WRITE_CR
	test.16		d7
.endif
	JUMP,ne		f$

	MOVE.32		A4,A6			; A6 pointe sur la zone des variables
	gesmem		?clearmem
;;L0$:
;;	CLR.8		{A4+}			; Mise a zero de la memoire
;;	DEC.32		D4
;;	JUMP,HI		L0$
f$:
	POPM.32		D0|D1|D4|D5|A4|A5	; Recupere les registres
	test.16		d7
	RET



	

;***************************************************************************************
;-------\
; S0KILL >
;=======/
;***************************************************************************************
;
; Appelle lors du DEINSTALL 
;
; In	A6.32	^variables globales du pilote
; Out
; Mod	

S0KILL:
.if	DEBUG
	WRITE_STR_C	ETH:Kill
.endif
	PUSHM.32	A4|A5
	MOVE.32		{A6}+OAD_SONIC,A5		; Charge l'adresse du Sonic
	CALL		StopReceive			; Declenche le mode de reception du Sonic
	CALL		StopInterrupt			; Desactive la routine d'interruption
	MOVE.32		A6,A4
	GESMEM		?GIVMEM				; Rend la memoire
	POPM.32		A4|A5
	RET



;***************************************************************************************
;----------\
; S0COMMAND >
;==========/
;***************************************************************************************
;
; Appelle lors de l'appel COMMAND
;
; In	A6.32	^variables globales du pilote
;	A4.32	^table de commande
; Out
; Mod	D7
;
; 		Commandes:

; LM LC MAC_LOOP	 Loopback au niveau du MAC (contrleur)
; LE LS	ENDEC_LOOP	 Loopback au niveau de l'ENDEC (srialisateur)
; LT	TRANS_LOOP	 Loopback au niveau du Transceiver
; LD	LOOP_OFF	 Loopback Disable
; PE	PRMSC_ON	 Promiscuous Enable
; PD	PRMSC_OFF	 Promiscuous Disable
; BE	BROAD_ON	 Broadcast Enable
; BD	BROAD_OFF	 Broadcast Disable
; A	ADD_MULTI	 Add Multicast Address
; M			 Address Multicast
; CM			 Clear Multicast adresse (enlve une adresse multicast de la liste)

; Commandes: ( faire) (Intel)
; T[8.b]	test mmoire sur 8 bits (destructif)
; T[16.b]	test mmoire sur 16 bits (destructif)
; TP		test priphrique (destructif)
; LC		Loopback sur contrleur (82586)
; LS		Loopback srialisateur (82C501)
; LD		Loopback Disable
; PE		Promiscuous Enable
; PD		Promiscuous Disable
; BE		Broadcast Enable
; BD		Broadcast Disable


S0COMMAND:
.if	DEBUG
	WRITE_STR_C	ETH:Command
.endif
	PUSHM.32	A0|A3|A5
	move.32		a4,a3				; ^ligne de commande -> A3.32
	MOVE.32		{A6}+OAD_SONIC,A5		; Charge l'adresse du Sonic

	CLR.16		D7

	move.32		#r16^TCom,a0
	call		SearchCom
FINCOMM:
	POPM.32		A0|A3|A5
	TEST.16		D7
	RET

.IF 0
	(ancien mode)
	COMP.16		#LOOP_OFF,{A4}+OCMD_TYPE
	JUMP,LS		RLoopback			; Selection mode loopback ?
	COMP.16		#PRMSC_OFF,{A4}+OCMD_TYPE
	JUMP,LS		RConfProm			; Selection promiscuous ?
	COMP.16		#BROAD_OFF,{A4}+OCMD_TYPE
	JUMP,LS		RConfBroad			; Selection broadcast ?
	COMP.16		#ADD_MULTI,{A4}+OCMD_TYPE
	JUMP,EQ		RSMC				; Selection MultiCast ?

	MOVE.16		#ERR_CMD_TYPE,D7		; Commande fausse
.endif

 TCom:
	.16.16		"A",RSMC-APC			; Adresse locale
	.16.16		"a",RSMC-APC			; Adresse locale
	.16.16		"M",RSMC-APC			; Adresse de multicast
	.16.16		"m",RSMC-APC			; Adresse de multicast
;;	.16.16		"C",				; Enlve adresse de multicast
;;	.16.16		"c",				; Enlve adresse de multicast
	.16.16		"L",RLoopback-APC		; Mode Loopback
	.16.16		"l",RLoopback-APC
;;	.16.16		"T",RLoopback-APC			; Mode Test
;;	.16.16		"t",RLoopback-APC
	.16.16		"P",RConfProm-APC		; Modif du mode promiscuous (prend tout)
	.16.16		"p",RConfProm-APC		; Modif du mode promiscuous (prend tout)
	.16.16		"B",RConfBroad-APC		; Modif du mode Broadcast (accepte broadcast)
	.16.16		"b",RConfBroad-APC		; Modif du mode Broadcast (accepte broadcast)
	.16.16		0,0				; Fin table

;***************************************************************************************
;-------\
; S0AUX1 >
;=======/
;***************************************************************************************
;
; Commandes auxiliaires utilises pour le passage de commande de debug
;
; In	A6.32	^variables globales du pilote
;	A3.32	^ligne de commande
;	A4.32	^rponse
;	D4.32	longueur rponse
;	A5.32	^donnes pour driver
;	D5.32	longueur donnes
; Out	D7.16	erreur
;	D7.<31..16>	CB_Status: Status du bloc de commande
; Mod	A0|A1|D0|D1|D7
; Commandes:
;	A[xx.b][xx.b][xx.b][xx.b][xx.b][xx.b]	Adresse locale (6 octets)
; ou	A[xxxx.w][xxxx.w][xxxx.w]
; ou	A[xxxx.w][xxxxxxxx.l]			
;	M[xx.b][xx.b][xx.b][xx.b][xx.b][xx.b]	Donne des adresses de multicast


S0AUX1:
	pushm.32	a2|a3|a4|a5|d2
;!mon	?aftim
;!.ascize	"<CR>Aux1 "
	move.32		#0,d7
	move.32		a4,a1			; ^rponse 		-> A1.32
	move.32		d4,d1
	move.32		a5,a2			; ^donnes pour driver	-> A2.32
	move.32		d5,d2
	MOVE.32		{A6}+OAD_SONIC,A5		; Charge l'adresse du Sonic

; Recherche de la commande

	move.32		#r16^Taux1,a0
	call		SearchCom
	popm.32		a2|a3|a4|a5|d2
	test.16		d7
	ret

TAUX1:
	.16.16		"A",RIA-APC			; Adresse locale
	.16.16		"a",RIA-APC			; Adresse locale
	.16.16		"M",RMC-APC			; Adresse de multicast
	.16.16		"m",RMC-APC			; Adresse de multicast
	.16.16		0,0				; Fin table
LgTaux1	=	(APC-Taux1)/4

;----------\
; SearchCom >
;==========/
;
; Recherche d'une commande dans la table et saute  la routine correspondante
; Effectue toutes les commandes de la liste
; S'arrte ds qu'une erreur est rencontre sur D7.16
;
; In	A3.32	^chane de commande
;	A0.32	^dbut table .16.16	car, adresse relative depuis position courante
;					table termine par 0, 0
; Out	A3.32	^aprs paramtres lus
;	D7<31..16>	D4.16 de la dernire routine appele
;	D7.16		D7.16 de la dernire routine appele
; Mod	selon routine sauf: A0, D0, D3, D4

SearchCom:
	pushm.32	d3|a0|d0|d4
	comp.32		#0,a3
	jump,eq		f$
loop$:
	move.32		#0,d3
	move.8		{a3+},d3		; paramtre de commande
	jump,eq		f$			; fin de commande
l$:
	move.16		{a0+},d0
	jump,eq		s$			; fin de la table
	comp.16		d0,d3			; Commande
	jump,eq		comok$
	add.32		#2,a0			; ^suite
	jump		l$
s$:
	move.16		#erillo,d7		; Commande incorrecte
	jump		f$

; Recherche de la routine associe

comok$:
	move.16		{a0},d0			; offset routine
	call		{a0}+A16^{d0}		; et on saute  la routine
	swap.32		d7
	move.16		d4,d7			; CB_Status -> 31..16 de D7
	swap.32		d7
	test.16		d7
	jump,eq		loop$
f$:
	popm.32		d3|a0|d0|d4
	test.16		d7
	ret



;----------\
; RLoopback >
;==========/
;
; LM ou LC	MAC_LOOP	 Loopback au niveau du MAC (contrleur)
; LE ou LS	ENDEC_LOOP	 Loopback au niveau de l'ENDEC (srialisateur)
; LT 		TRANS_LOOP	 Loopback au niveau du Transceiver
; LD		LOOP_OFF	 Loopback Disable
;
; Choisit un mode de Loopback
;
; In	A3.32 	^commande
;	A5.32	^Sonic
; Out	A3.32	^ajust
;	D7.16	Erreur
; Mod	

RLoopback:
	move.8		{A3+},d0		; caractre suivant pour commande
	COMP.8		#"M",d0
	jump,eq		sLoopMAC$		; loopback niveau MAC (contrleur)
	COMP.8		#"m",d0
	jump,eq		sLoopMAC$
	COMP.8		#"C",d0
	jump,eq		sLoopMAC$
	COMP.8		#"c",d0
	jump,eq		sLoopMAC$

	COMP.8		#"E",d0		
	JUMP,EQ		sLoopSer$		; loopback niveau ENDEC (srialisateur)
	COMP.8		#"e",d0		
	JUMP,EQ		sLoopSer$
	COMP.8		#"S",d0		
	JUMP,EQ		sLoopSer$
	COMP.8		#"s",d0		
	JUMP,EQ		sLoopSer$

	COMP.8		#"T",d0		
	JUMP,EQ		sLoopTrans$		; loopback niveau Transceiver
	COMP.8		#"t",d0		
	JUMP,EQ		sLoopTrans$

	COMP.8		#"D",d0		
	JUMP,EQ		sLoopDis$	
	COMP.8		#"d",d0		
	JUMP,EQ		sLoopDis$	
	move.16		#erillo,d7		; Commande incorrecte
	jump	f$

sLoopMAC$:
	CALL		MacLoopback
	JUMP		F$
sLoopSer$:
	CALL		EndecLoopback
	JUMP		F$
sLoopTrans$:
	CALL		TransceiverLoopback
	JUMP		F$
sLoopDis$:
	CALL		NoLoopback
F$:
	ret



;----------\
; RConfProm >
;==========/
;
; Mode Promiscuous ou pas (accepte tous les paquets)
; 
; In	A3.32 	^commande
;	A5.32	^Sonic	
; Out	D7.16	Erreur
; Mod	D0.16

RConfProm:
	move.8		{A3+},d0
	COMP.8		#"D",d0
	JUMP,EQ		sNoProm$
	COMP.8		#"d",d0
	JUMP,EQ		sNoProm$

	COMP.8		#"E",d0
	JUMP,EQ		sProm$
	COMP.8		#"e",d0
	JUMP,EQ		sProm$
	move.16		#erillo,d7		; Commande incorrecte
	jump	f$

sProm$:
	CALL		Promiscuious
	JUMP		r8^F$
sNoProm$:
	CALL		NoPromiscuious
F$:
	ret


;-----------\
; RConfBroad >
;===========/
;
; Mode Broadcast accepte ou non (paquets avec adresse FF FF FF FF FF FF)
; 
; In	A3.32	^table de commande
;	A5.32	^Sonic
; Out	D7.16	Erreur
; Mod	d0

RConfBroad:
	move.8		{A3+},d0
	COMP.8		#"D",d0
	JUMP,EQ		sNoBroad$
	COMP.8		#"d",d0
	JUMP,EQ		sNoBroad$

	COMP.8		#"E",d0
	JUMP,EQ		sBroad$
	COMP.8		#"e",d0
	JUMP,EQ		sBroad$
	move.16		#erillo,d7		; Commande incorrecte
	jump		r8^f$

	JUMP,EQ		sNoBroad$
sBroad$:
	CALL		Broadcast
	JUMP		r8^F$
sNoBroad$:
	CALL		NoBroadcast
F$:
	ret


;-----\
; RSMC >
;=====/
;
; Met une entre multicast en mmoire CAM du SONIC
;
; In	A3.32	^adresse
; Out	A3.32	^aprs l'adresse
; Mod

RSMC:
;	move.32		#{a4}+oCmd_Type,A4	; ^commande
	call		RMC
	ret

;----\
; RMC >
;====/
;
; Ajoute une adresse de multicast a la liste
; Une adresse ne peut tre enleve dans la version actuelle (mais c'est possible,  faire...)
; A chaque nouvelle adresse, toute la table est recharge
; La table est chaque fois charge en entier (16 entres)
;
; In	A3.32	^adresse  rajouter (6 octets)
; Exemple	10:20:30:40:50:60    A4 ^10
;		Least          Most: 10 Reut en 1er sur le rseau
;		CAP0: 2010
;		CAP1: 4030
;		CAP2: 6050
; Out	D7.16	Erreur
; Mod	

RMC:
	PUSHM.32	D0|D1|D2|A0			; Sauve les registres
push.16	d7
lib	?aftim
.ascize	"<CR>RMC"
pop.16	d7
	call		SearchAdCAM
	jump,eq		ld$				; adresse dj dans la table -> recharge
	call		SearchFreeCAM			; entre libre, offset -> d2.32
	jump,ne		f$
	call		LoadAdCAM

; charge LCAM
ld$:
	call		LdCAM
F$:
	POPM.32		D0|D1|D2|A0			; Recupere les registres
	ret

;--------\
; ClearMC >
;========/
;
; Enlve une adresse de multicast a la liste
; La table est chaque fois charge en entier (16 entres)
;
; In	A3.32	^adresse  enlever (6 octets)
; Exemple	10:20:30:40:50:60    A4 ^10
;		Least          Most: 10 Reut en 1er sur le rseau
;		CAP0: 2010
;		CAP1: 4030
;		CAP2: 6050
; Out	D7.16	Erreur
; Mod	

ClearMC:
	PUSHM.32	D0|D1|D2|A0			; Sauve les registres
push.16	d7
lib	?aftim
.ascize	"<CR>ClearMC"
pop.16	d7
	call		SearchAdCAM
	jump,ne		f$				; pas trouv -> f$
	move.32		d0,d2
	mul.16		#LgCamDescriptor,d2		; offset
	call		UnLoadAdCAM

	; charge LCAM
ld$:
	call		LdCAM
F$:
	POPM.32		D0|D1|D2|A0			; Recupere les registres
	ret

;----------\
; LoadAdCAM >
;==========/
; Met une adresse dans la table CAM en mmoire
;
; In	A3.32	^adresse
;	D0.16	no entre (0..NbMAxCAM-1)
;	D2.32	offset dans CAM
; Out:	-
; Mod	-

LoadAdCAM:
	pushm.32	a0|d1
	MOVE.32		#{A6}+OCAMStart,A0		; dbut table CAM -> A0.32
	MOVE.8		{a3}+0,{A0}+32^{D2}+OCamAddressPort0+1	; Ecrit l'adresse en swappant
	MOVE.8		{a3}+1,{A0}+32^{D2}+OCamAddressPort0	; les bytes
	MOVE.8		{a3}+2,{A0}+32^{D2}+OCamAddressPort1+1
	MOVE.8		{a3}+3,{A0}+32^{D2}+OCamAddressPort1
	MOVE.8		{a3}+4,{A0}+32^{D2}+OCamAddressPort2+1	
	MOVE.8		{a3}+5,{A0}+32^{D2}+OCamAddressPort2
	inc.16		{A6}+ONbCamDesc
	move.16		{a0}+oCAMEnable,d1
	tset.32		d1:d0
	move.16		d1,{a0}+oCAMEnable		; entre valide
	popm.32		a0|d1
	ret

;------------\
; UnLoadAdCAM >
;============/
; Enlve une adresse dans la table CAM en mmoire
;
; In	D0.16	no entre (0..NbMAxCAM-1)
;	D2.32	offset dans CAM
; Out:	-
; Mod	-

UnLoadAdCAM:
	pushm.32	a0|d1
	MOVE.32		#{A6}+OCAMStart,A0		; dbut table CAM -> A0.32
	MOVE.8		#0,{A0}+32^{D2}+OCamAddressPort0+1	; Ecrit l'adresse en swappant
	MOVE.8		#0,{A0}+32^{D2}+OCamAddressPort0	; les bytes
	MOVE.8		#0,{A0}+32^{D2}+OCamAddressPort1+1
	MOVE.8		#0,{A0}+32^{D2}+OCamAddressPort1
	MOVE.8		#0,{A0}+32^{D2}+OCamAddressPort2+1	
	MOVE.8		#0,{A0}+32^{D2}+OCamAddressPort2
	dec.16		{A6}+ONbCamDesc
	move.16		{a0}+oCAMEnable,d1
	tclr.32		d1:d0
	move.16		d1,{a0}+oCAMEnable		; entre invalide
	popm.32		a0|d1
	ret

;------\
; LdCAM >
;======/
;
; Charge la CAM
; In:	A5.32 ^adresse du Sonic
; Out:	-

LdCAM:
	pushm.32	d0
	MOVE.16		#16'1000,{a5}+SonicISR		; Clear Receive Buffer Area Excedeed ??
	MOVE.16		#2**bSonicLCAM,{A5}+SonicCR	; Envoie la commande LCAM

;*******************************************
;!!!!!! Attente active sur le Sonic !!!!!!!!
;*******************************************
LCAM$:
	MOVE.16		{A5}+SonicCR,D0			; on attend que l'operation se soit
	TEST.32		D0:#bSonicLCAM			; terminee pour eviter de mettre TXP
	JUMP,BS		LCAM$				; quand LCAM vaut encore 1 ->DeadLock
	popm.32		d0
	ret

;--------\
; InitCAM >
;========/
; Initialise les OCamEntryPointer
; + oCAMEnable
; In:	A5.32 ^adresse du Sonic

InitCAM:
	pushm.32	a0|d0
	clr.32		d0
	MOVE.32		#{A6}+OCAMStart,A0		; dbut table CAM -> A0.32
	MOVE.16		A0,{A5}+SonicCDP		; dbut CAM -> SONIC
l$:
	MOVE.16		D0,{A0}+OCamEntryPointer	; Ecrit le CAM Entry Pointer
	add.32		#LgCAMDescriptor,A0		; ^sur descr suivant
	inc.32		d0
	comp.16		#NbMaxCAM,d0
	jump,lo		l$
	move.16		#0,{a6}+oCAMStart+oCAMEnable	; Entres vides
	move.16		#0,{A6}+ONbCamDesc		; Pas d'adresses fournies
	move.16		#NbMaxCAM,{A5}+SonicCDC		; Charge le CDC du Sonic (NbMaxCAM)
	popm.32		a0|d0
	ret

;-------------\
; SearchAdCAM  >
;=============/
; Recherche d'une adresse dans la CAM
; In:	A3.32	^adresse  trouver
; Out:	A0.32	^table CAM sur adresse trouve
;	D0.16	numro de l'entre dans la CAM
;	D7.16	0: trouv (EQ)
;		-1 pas trouv (NE)
	
SearchAdCAM:
	pushm.32	d1
	MOVE.32		#{A6}+OCAMStart,A0		; dbut table CAM -> A0.32
	MOVE.16		A0,{A5}+SonicCDP		; dbut CAM -> SONIC

	move.32		#0,d0				; Index dans CAM
							; 0..15
l$:
	MOVE.8		{a3}+0,D1
	COMP.8		{A0}+OCamAddressPort0+1,D1	; COMPARE l'adresse en swappant les bytes
	jump,ne		r8^fc$
	MOVE.8		{a3}+1,D1
	COMP.8		{A0}+OCamAddressPort0,D1	
	jump,ne		r8^fc$
	MOVE.8		{a3}+2,D1
	COMP.8		{A0}+OCamAddressPort1+1,D1	
	jump,ne		r8^fc$
	MOVE.8		{a3}+3,D1
	COMP.8		{A0}+OCamAddressPort1,D1	
	jump,ne		r8^fc$
	MOVE.8		{a3}+4,D1
	COMP.8		{A0}+OCamAddressPort2+1,D1	
	jump,ne		r8^fc$
	MOVE.8		{a3}+5,D1
	COMP.8		{A0}+OCamAddressPort2,D1	
	jump,ne		r8^fc$
; trouv
	clr.16		d7
f$:
	popm.32		d1
	test.16		d7
	ret

; pas trouv
fc$:
	add.32		#LgCamDescriptor,a0		; ^descr suivant
	inc.32		d0				; index suivant
	comp.32		#NbMaxCam,d0
	jump,lo		l$
	move.16		#-1,d7				; pas trouv
	jump		f$

;--------------\
; SearchFreeCAM >
;==============/
; In:	-
; Out:	D0.16	no CAM libre
;	D2.32	offset descripteur libre
;	D7.16	ER_NB_CAM plus de CAM libre

SearchFreeCAM:
	move.16		#ER_NB_CAM,d7			; plus de CAM de libre
	move.16		{A6}+oCAMStart+oCAMEnable,d2	; entres valides
	comp.16		#16'FFFF,d2
	jump,eq		r8^f$
	clr.32		d0				; no CAM libre
l$:
	TEST.32		d2:d0
	jump,bc		t$
	inc.32		d0
	comp.16		#NbMaxCAM,d0
	jump,lo		l$
	jump		f$

; trouv
t$:
	move.32		d0,d2
	mul.16		#LgCamDescriptor,d2		; offset
	clr.16		d7
f$:
	test.16		d7
	ret

		
;***************************************************************************************
;---------\
; S0STATUS >
;=========/
;***************************************************************************************
;
; Donne les status du driver 
;
; In	A6.32	^variables globales du pilote
;	A4.32	^buffer ou rendre les status
;	D4.16	longueur buffer ou mettre les status
; Out	D7	erreur
; Mod

S0STATUS:
.if	DEBUG
	WRITE_STR_C	ETH:Status
.endif
	PUSHM.32	D0|A0

	CLR.16		D7
	COMP.16		#STAT_MEM_LEN,D4
	JUMP,GE		BUFOK$			; Le buffer est-il assez grand ?
	MOVE.16		#ERR_SIZE_BUF,D7
	JUMP		FIN$			; Si non, erreur buffer trop petit
BUFOK$:
	MOVE.16		#STAT_MEM_LEN,D4	; Longueur reelle buffer

	MOVE.8		{A6}+DRIV_STATE,D0
	MOVE.8		D0,{A6}+DRIV_STATE	; Recopie etat driver

	MOVE.32		#{A6}+OS_REVISION,A0	; A0^ sur debut stats
	MOVE.16		#STAT_MEM_LEN-1,D0
BOU$:
	MOVE.8		{A0+},{A4+}		; Transfert dans buffer
	DJ.16,NMO 	D0,BOU$
FIN$:
	POPM.32		D0|A0
	RET


;***************************************************************************************
;-------\
; S0OPEN >
;=======/
;***************************************************************************************
;
; In	A6.32	^variables globales du pilote
; Out	D7.16	Erreur
; Mod

S0OPEN:
.if	DEBUG
	WRITE_STR_C	ETH:Open
.endif
;	MOVE.32		{A6}+OAD_SONIC,A5		; Charge l'adresse du Sonic

	MOVE.8		#IDLE,{A6}+DRIV_STATE
	CLR.16		D7
	TEST.16		D7
	RET


;***************************************************************************************
;--------\
; S0CLOSE >
;========/
;***************************************************************************************
;
; Ferme le driver et supprime la liste des requetes en attente
;
; In	A6.32	^variables globales du pilote
; Out	D7.16	Erreur
; Mod

S0CLOSE:
.if	DEBUG
	WRITE_STR_C	ETH:Close
.endif

;	SUP
	IOFF
	MOVE.32		#NULL,{A6}+ODR_TETE	; Vide les listes
	MOVE.32		#NULL,{A6}+ODR_QUEUE
	MOVE.32		#NULL,{A6}+ODW_TETE
	MOVE.32		#NULL,{A6}+ODW_QUEUE
	MOVE.8		#CLOSED,{A6}+DRIV_STATE

;PH
	CALL		StopReceive		; evite d'appeler la routine
						; d'interruption a chaque packet broadcast
							
	ION
;	USER
	CLR.16		D7
	TEST.16		D7
	RET



;***************************************************************************************
;-------\
; S0READ >
;=======/
;***************************************************************************************
;
; 
;
; In	A6.32	^variables globales du pilote
;	A4.32	^descripteur des donnees PCB
;	D5.32	longueur descripteur ( ignore )
; Out	A4	PCB mis a jour
;	D7.16	Erreur
; Mod
;

S0READ:
.if	DEBUG
	WRITE_STR_C	ETH:Read
.endif
	PUSHM.32	D0|D1|A0|A1|A5
	MOVE.32		{A6}+OAD_SONIC,A5		; Charge l'adresse du Sonic
	CLR.16		{A4}+OPB_RES
	
	COMP.8		#IDLE,{A6}+DRIV_STATE		; Driver ouvert ?
	JUMP,NE		ERR0$
	COMP.16		#1,{A4}+OPB_BUF_NB		; Nbre fragments trop grand ?		
	JUMP,HI		ERR1$
	COMP.16		#0,{A4}+OPB_BUF_NB
	JUMP,EQ		ERR3$
OK1$:
	COMP.32		#LgRXBuffer,{A4}+OPB_BUF_TAB	; Teste taille minimum
	JUMP,LO		ERR2$

	COMP.16		#NbMaxRdBuf-1,{A6}+NBRD_BUF	; Nombre maximal de buffers en lecture atteint?
	JUMP,HS		ERR4$

	comp.16		#3,{A6}+NBRD_BUF
	jump,ne		cont$
;	write_str	?
	call		StartReceive
;	pushm.32	d3|d7
;	mon		?getcar
;	popm.32		d3|d7
cont$:
	INC.16		{A6}+NBRD_BUF		; Un buffer de plus en attente

	MOVE.32		#NULL,{A4}+OPB_NXT	; Ici OPB_NXT est le pointeur next_element
	
	IOFF	; Zone protegee car la manipulation des listes pourrait bloquer la routine interrupt

	COMP.32		#NULL,{A6}+ODR_TETE	
	JUMP,EQ		LIST_VID$		; Liste Vide ?

	MOVE.32		{A6}+ODR_QUEUE,A0
	MOVE.32		A4,{A0}+OPB_NXT		; Ce PCB devient next_element du dernier PCB
	MOVE.32		A4,{A6}+ODR_QUEUE	; Ce PCB devient a son tour le dernier element
	
	MOVE.32		{A0}+OPB_DRV,A0		; Recupere ptr sur RDA
	MOVE.32		A0,A1
	ADD.32		#LgRXpktDescriptor,A0	; Place pour paquet suivant
	MOVE.32		A0,D0
	COMP.16		#oRDAEnd-LgRXpktDescriptor,D0		; Fin zone RDA atteinte ?
	JUMP,LO		NFRDA$
	MOVE.32		#{A6}+ORDAStart,A0	; Si oui, remet ptr au debut de la zone
NFRDA$:
;	pushm.32	A0|A1
	CALL		ADD_RD_PKT2		; Met a jour les listes RDA et RRA du SONIC
;	popm.32		A0|A1
;	MOVE.16		A0,{A1}+ORXpktLink	; Linke le nouveau RDA a l'ancien. 

	MOVE.16		{A5}+SonicISR,D0	; Teste le bit RBE.
	TEST.32		D0:#bSonicRBE
	JUMP,BC		FIN$

BUF_EXH$:					; Reset le bit RBE si on etait out of buffer	
.if debug
;	WRITE_4NUM	D0
;	WRITE_STR_C	Receive buffers exhausted resetting RBE bit
.endif
	MOVE.16		#2**bSonicRBE,{A5}+SonicISR
	move.16		{a5}+SonicRRP,D0
	move.16		{a5}+SonicRWp,D0
;	jump		testbug$
WAIT_RBE$:
;	move.16		#16'BABE,D0
;	move.16		{a5}+SonicRRP,D0
;	move.16		{a5}+SonicRWp,D0
testbug$:
;	MOVE.16		{A5}+SonicISR,D0
;	TEST.32		D0:#bSonicRBE
;	JUMP,BS		WAIT_RBE$

	JUMP		FIN$			; On laisse la routine d'interrupt terminer le travail

LIST_VID$:
	call		StopReceive
	MOVE.32		A4,{A6}+ODR_TETE
	MOVE.32		A4,{A6}+ODR_QUEUE	; Premier et dernier PCB
	MOVE.32		#{A6}+ORDAStart,A0
	
	CALL		ADD_RD_PKT		; Met a jour les listes RDA et RRA du SONIC

	move.32		#0,A0
	MOVE.16		{A5}+SonicISR,D0
	TEST.32		D0:#bSonicRBE
	JUMP,BC		NEW_RRA$

.if	DEBUG
;	WRITE_STR_C	resetting RBE bit in liste vide
.endif


	MOVE.16		#2**bSonicRBE,{A5}+SonicISR

;	JUMP		RDONE$

NEW_RRA$:					; Envoie READ RRA 
.if 	DEBUG	
;	WRITE_4NUM	D0	
;	WRITE_STR_C	Reading RRA
.endif
	MOVE.16		#2**bSonicRRRA,{A5}+SonicCR
WAIT_RRRA$:
	MOVE.16		{A5}+SonicCR,D0
	TEST.32		D0:#bSonicRRRA
	JUMP,BS		WAIT_RRRA$
	add.32		#ORDAStart,A0
	add.32		A6,A0
	MOVE.16		A0,{A5}+SonicCRDA	; Donne le nouveau descripteur. Met a jour ptr sur premier RDA
	
RDONE$:
;	MOVE.16		#2**bSonicRDE,{A5}+SonicISR

;	CALL		StartReceive		; Passe la main au SONIC
FIN$:
	ION					; Fin de la zone protegee
	POPM.32		D0|D1|A0|A1|A5
	MOVE.16		{A4}+OPB_RES,D7
	TEST.16		D7
	RET

ERR0$:
	MOVE.16		#ERR_NO_INIT,{A4}+OPB_RES	; Renvoie erreur
	JUMP		FIN$
ERR1$:
	MOVE.16		#ERR_FRG_CNT,{A4}+OPB_RES
	JUMP		FIN$
ERR2$:
	MOVE.16		#ERR_SIZE_BUF,{A4}+OPB_RES
	JUMP		FIN$
ERR3$:
	MOVE.16		#ERR_EMPTY_BUF,{A4}+OPB_RES
	JUMP		FIN$
ERR4$:
	MOVE.16		#ERR_MAX_BUF,{A4}+OPB_RES
	JUMP		FIN$

;-----------\
; ADD_RD_PKT >
;===========/

; Met a jour les listes RRA et RDA du SONIC en fonction du PCB courant

; in	A0^ sur RDA libre, A4^ PCB, A5^Sonic
; out	A0^ RRA courant
; mod	-

ADD_RD_PKT:
	MOVE.32		A0,{A4}+OPB_DRV			; OPB_DRV pointe sur RDA correspondant
	MOVE.16		#EOL,{A0}+ORXpktLink		; Dernier descripteur de la liste, pas de link
	MOVE.16		#16'FFFF,{A0}+ORXpktInUse
;	push.32		a0
;	move.32		#{A0}+ORXpktLink,A0
;	write_str	adresse du pktlink :
;	write_8num	A0
;	pop.32		A0
;	write_cr

	MOVE.16		{A5}+SonicRWP,D0
	AND.32		#16'FFFF,D0			; Ptr 16 bits sur prochain RRA libre

	MOVE.32		#{A6}+A16^{D0},A0		; A0^ sur RRA courant

	MOVE.32		{A4}+OPB_BUF_TAB+OBUF_PTR,D1	; Ptr sur le buffer a lire ( adr paire !! )

 	MOVE.16		D1,{A0}+ORXrsrcBuffPtr0		; Initialise ptr sur buffer fournit
	SWAP.32		D1
 	MOVE.16		D1,{A0}+ORXrsrcBuffPtr1

	MOVE.32		#LgRXbuffer,D1			; Longueur buffer est toujours egale a la 
							; longueur maximale
	SR.32		#1,D1				; Compte en words
	MOVE.16		D1,{A0}+ORXrsrcBuffWC0
;	SWAP.32		D1
;	MOVE.16		D1,{A0}+ORXrsrcBuffWC1
	MOVE.16		#0,{A0}+ORXrsrcBuffWC1

	ADD.32		#LgRXrsrcDescriptor,D0		; Aligne RWP pour descripteur suivant
	COMP.16		#ORRAEnd,D0			; Fin de zone RRA atteinte ?
	JUMP,LO		OK$
	MOVE.16		#ORRAStart,D0			; Revient au debut de zone
OK$:
;PH
	MOVE.16		D0,{A5}+SonicRWP

FIN$:
	RET	

;-----------\
; ADD_RD_PKT2 > deuximme routine avec le link, pour debugage
;===========/

; Met a jour les listes RRA et RDA du SONIC en fonction du PCB courant

; in	A0^ sur RDA libre, A4^ PCB, A5^Sonic
; out	A0^ RRA courant
; mod	-

ADD_RD_PKT2:
	MOVE.32		A0,{A4}+OPB_DRV			; OPB_DRV pointe sur RDA correspondant
	MOVE.16		#EOL,{A0}+ORXpktLink		; Dernier descripteur de la liste, pas de link
	MOVE.16		#16'FFFF,{A0}+ORXpktInUse

	MOVE.16		A0,{A1}+ORXpktLink	; Linke le nouveau RDA a l'ancien. Note: le
						; nouveau RDA n'existe pas encore, mais on 
						; se trouve dans une zone IOFF, donc pas de
						; problemes. NJET! le DMA peux quand-meme s'executer


;	push.32		a0
;	move.32		#{A0}+ORXpktLink,A0
;	write_str	adresse du pktlink :
;	write_8num	A0
;	pop.32		A0
;	write_cr

	MOVE.16		{A5}+SonicRWP,D0
	AND.32		#16'FFFF,D0			; Ptr 16 bits sur prochain RRA libre

	MOVE.32		#{A6}+A16^{D0},A0		; A0^ sur RRA courant

	MOVE.32		{A4}+OPB_BUF_TAB+OBUF_PTR,D1	; Ptr sur le buffer a lire ( adr paire !! )

 	MOVE.16		D1,{A0}+ORXrsrcBuffPtr0		; Initialise ptr sur buffer fournit
	SWAP.32		D1
 	MOVE.16		D1,{A0}+ORXrsrcBuffPtr1

	MOVE.32		#LgRXbuffer,D1			; Longueur buffer est toujours egale a la 
							; longueur maximale
	SR.32		#1,D1				; Compte en words
	MOVE.16		D1,{A0}+ORXrsrcBuffWC0
;	SWAP.32		D1
;	MOVE.16		D1,{A0}+ORXrsrcBuffWC1
	MOVE.16		#0,{A0}+ORXrsrcBuffWC1

	ADD.32		#LgRXrsrcDescriptor,D0		; Aligne RWP pour descripteur suivant
	COMP.16		#ORRAEnd,D0			; Fin de zone RRA atteinte ?
	JUMP,LO		OK$
	MOVE.16		#ORRAStart,D0			; Revient au debut de zone
OK$:
;PH
	MOVE.16		D0,{A5}+SonicRWP

FIN$:
	RET	




;***************************************************************************************
;--------\
; S0WRITE >
;========/
;***************************************************************************************
;
; Une seule commande d'emission est fournie a la fois (pas de chainage de transmission) au niveau
; du SONIC. Mais par contre les requetes sont chainees et traitees a la suite de facon asynchrone
;
; In	A6.32	^variables globales du pilote
;	A4.32	^descripteur des donnees PCB
;	D5.32	longueur descripteur ( ignore )
; Out	D7.32	erreur
;
; Mod	
;

S0WRITE:
.if	DEBUG
	WRITE_STR_C	ETH:Write
.endif
	PUSHM.32	D0|D1|A0|A1|A5
	MOVE.32		{A6}+OAD_SONIC,A5		; Charge l'adresse du Sonic
	MOVE.16		#0,{A4}+OPB_RES			; Initialise le resultat

	COMP.8		#IDLE,{A6}+DRIV_STATE		; Driver ouvert ?
	JUMP,NE		ERR0$

	CLR.16		D7

	COMP.16		#16,{A4}+OPB_BUF_NB		; Nbre fragments trop grand ?		
	JUMP,HI		ERR1$
	COMP.16		#0,{A4}+OPB_BUF_NB
	JUMP,EQ		ERR3$
OK1$:
	MOVE.16		{A4}+OPB_BUF_NB,D0		; Compteur nb fragments
	DEC.16		D0
	CLR.32		D1				; Compteur taille
	MOVE.32		#{A4}+OPB_BUF_TAB,A0
BOU1$:
	ADD.32		{A0}+OBUF_L_LEN,D1		; Additionne longueur de tous les fragments
	COMP.32		#0,{A0}+OBUF_L_LEN		; Teste taille min fragment
	JUMP,EQ		ERR2$
	ADD.32		#BLEN,A0			; passe au buffer suivant
	DJ.16,NMO 	D0,BOU1$

	COMP.32		#LgMaxEth,D1			; Teste taille maximum
	JUMP,HI		ERR2$
;	COMP.32		#LgMinEth,D1			; La taille minimale n'est pas un 
;	JUMP,LO		ERR2$				; probleme. Le driver alonge le packet
							; dans send_packet.
	

.if	DEBUG
;	WRITE_STR	ETH:Write: paquet ok
.endif
	MOVE.32		#NULL,{A4}+OPB_NXT	; Ici OPB_NXT est le pointeur next_element
	
	IOFF	; Zone protegee car la manipulation des listes pourrait bloquer l'interrupt routine

	COMP.32		#NULL,{A6}+ODW_TETE	
	JUMP,EQ		LIST_VID$		; Liste Vide ?

	MOVE.32		{A6}+ODW_QUEUE,A0
	MOVE.32		A4,{A0}+OPB_NXT		; Ce PCB devient next_element du dernier PCB
	MOVE.32		A4,{A6}+ODW_QUEUE	; Ce PCB devient a son tour le dernier element
	JUMP		FIN$		; On laisse la routine d'interruption terminer le travail

LIST_VID$:
	MOVE.32		A4,{A6}+ODW_TETE
	MOVE.32		A4,{A6}+ODW_QUEUE	; Premier et dernier PCB
	CALL		SEND_PACKET		; Commence la transmission

FIN$:
	ION					; Fin de la zone protegee
	POPM.32		D0|D1|A0|A1|A5
	MOVE.16		{A4}+OPB_RES,D7
	TEST.16		D7
	RET

ERR0$:
	MOVE.16		#ERR_NO_INIT,{A4}+OPB_RES	; Renvoie erreur
	JUMP		FIN$
ERR1$:
	MOVE.16		#ERR_FRG_CNT,{A4}+OPB_RES
	JUMP		FIN$
ERR2$:
	MOVE.16		#ERR_SIZE_BUF,{A4}+OPB_RES
	JUMP		FIN$
ERR3$:
	MOVE.16		#ERR_EMPTY_BUF,{A4}+OPB_RES
	JUMP		FIN$


;***********************************************************************************************
; Routines de gestion des interruptions
;***********************************************************************************************


;--------------\
; InitInterrupt >
;==============/
;
; Demasque l'interruption et initialise la routine d'interruption
; Cette routine est executee en mode superviseur
;
; In	A6.32		^variables (passe dans A0.32 dans la routine d'interruption)
; Out
; Mod

InitInterrupt:

	PUSHM.32	A0|A1|A2|D0
	SUP
	.if	Carte302
	MOVE.32		#V_PB9,A0
	.endif
	.if	S130
	move.8		#VectSonic,AdWrVect	; Ecrit vecteur sur carte Sonic
	MOVE.32		#VectSonic*4,A0
	.endif

	MOVE.32		#R16^InterruptRout,A1
	MOVE.32		_INDNTR,A2

	CALL		{A2}+OIN_INITVECTOR
	.if	S130
	MOVE.32		#AVectSonic*4,A0	; Mode Autovecteur galement niveau 2
	CALL		{A2}+OIN_INITVECTOR
	.endif

	.if	Carte302
	MOVE.32		#BASE,A0
	MOVE.16		{A0}+O_IMR,D0		; Masque interruptions
	TSET.32		D0:#B_IMR_PB9		; Autorise interrupt Sonic

	MOVE.16		D0,{A0}+O_IMR
	.endif

	USER
	POPM.32		A0|A1|A2|D0
	RET

;--------------\
; StopInterrupt >
;==============/
;
; Masque l'interruption et desactive la routine d'interruption
; Cette routine est executee en mode superviseur
;
; In
; Out
; Mod

StopInterrupt:

	PUSHM.32	A0|A1|A2
;	SUP

	.if		Carte302
	MOVE.32		#BASE,A0
	MOVE.16		{A0}+O_IMR,D0		; Masque interruptions
	TCLR.32		D0:#B_IMR_PB9		; Interdit interrupt Sonic

	MOVE.16		D0,{A0}+O_IMR

	MOVE.32		#V_PB9,A0
	.endif
	.if	S130
	move.32		#VectSonic*4,A0
	.endif
	MOVE.32		#0,A1			; adresse routine = 0
	MOVE.32		_INDNTR,A2

	CALL		{A2}+OIN_INITVECTOR	; desinstallation de la routine

;	USER
	POPM.32		A0|A1|A2
	RET


;--------------\
; InterruptRout >
;==============/
;
; Trie et traite les differentes interruptions pouvant se presenter
; Tous les registres autres que A0|A1|D0|D1 ne sont pas sauves automatiquement ???PH
;
; In	A0.32	^variables (contenu de A6 au moment de l'InitInterrupt)
; Out
; Mod

InterruptRout:
;.if	DEBUG
;	WRITE_STR_C	Interrupt
;.endif
or.16	#16'2700,sf
	PUSHM.32	A5|A6|d7			; Sauve les registres
push.16	d7
mon	?aftim
.ascize	"<CR>InterruptRout "
pop.16	d7
	MOVE.32		A0,A6				; ^debut de la zone memoire
	MOVE.32		{A6}+OAD_SONIC,A5		; Charge l'adresse du Sonic

	.if	Carte302
	MOVE.32		#BASE,A0
;;	MOVE.16		{A0}+O_ISR,D0

.if 	DEBUG
;	WRITE_STR	68000 ISR : 
;	WRITE_4NUM	D0	
;	WRITE_CR
.endif
	MOVE.16		#2**B_IMR_PB9,{A0}+O_ISR	; ACK de l'interrupt 68000
	.endif

	MOVE.16		{A5}+SonicISR,D0		; Lit le ISR

Again$:
	WRITE_STR	sonic ISR : 
	WRITE_4NUM	D0
	WRITE_CR

	TEST.32		D0:#bSonicTXDN			; 1) Packet Sent ?
	JUMP,BC		S0$
	MOVE.16		#2**bSonicTXDN+2**bSonicTXER,{A5}+SonicISR
	CALL		PktSent
	JUMP		S1$
S0$:
	TEST.32		D0:#bSonicTXER			; 2) Packet Sent with Errors ?
	JUMP,BC		S1$
	MOVE.16		#2**bSonicTXER+2**bSonicTXDN,{A5}+SonicISR
	CALL		PktSent
S1$:
	TEST.32		D0:#bSonicPKTRX			; 3) Packet Received ?
	JUMP,BC		S2$
	MOVE.16		#2**bSonicPKTRX,{A5}+SonicISR
	CALL		PktReceived
S2$:
	MOVE.16		{A5}+SonicISR,D0		; Lit le ISR
	AND.16		#2**bSonicTXDN+2**bSonicTXER+2**bSonicPKTRX,D0
	JUMP,NE		AGAIN$

	POPM.32		A5|A6|d7				; Recupere les registres
	RET


;------------\
; PktReceived >
;============/
;
; Recoit un paquet
;
; In	A6.32	^variables
; Out
; Mod
;
PktReceived:
.if	DEBUG
;	WRITE_STR_C	ETH:PktReceived
.endif
	PUSHM.32	A0|A1|D0
push.16	d7
mon	?aftim
.ascize	"<CR>PktReceived"
pop.16	d7
	INC.32		{A6}+OS_RX_INT_C		; Met a jour les stats

	MOVE.32		{A6}+ODR_TETE,A0		; ^1er PCB de la liste
	COMP.32		#NULL,A0
	JUMP,EQ		FIN$				; Erreur si liste vide, sort

	MOVE.32		{A0}+OPB_DRV,A1			; Ptr sur RDA -> A1.32

;test bug RRA:
	move.16		{A1}+ORXpktPktPtr1,D0
	swap.32		D0
	move.16		{A1}+ORXpktPktPtr0,D0		; ^buffer -> d0.32
	comp.32		{A0}+OPB_BUF_TAB+OBUF_PTR,D0
	jump,ne		bug$

	MOVE.16		{A1}+ORXpktStatus,D0		; Resultat de la reception
;;RB	CLR.16		{A0}+OPB_RES			; Indique pas d'erreur
	MOVE.16		D0,{A0}+OPB_RES			; erreur de rception
	TEST.32		D0:#bSonicPRX			; Receive OK ?
	JUMP,BS		NXT_PKT$

;;RB	MOVE.16		#ERR_RX,{A0}+OPB_RES		; Sinon indique erreur de transmission
	TEST.32		D0:#bSonicCRCR			; Teste erreur de CRC
	JUMP,BC		ERR_PKT$
	INC.32		{A6}+OS_BAD_CRC			; Met a jour stats
	JUMP		ERR_PKT$	

NXT_PKT$:
	INC.32		{A6}+OS_RX_FR_C			; Met a jour stats
	CLR.32		D0
	MOVE.16		{A1}+ORXpktByteCount,D0
	ADD.32		D0,{A6}+OS_RX_BYTE_C		; Nbre de bytes recus	
	MOVE.32		D0,{A0}+OPB_BUF_TAB+OBUF_L_LEN	

	
ERR_PKT$:
	DEC.16		{A6}+NBRD_BUF			; decremente le nombre de paquet en attente
	MOVE.32		{A0}+OPB_NXT,A1			; Ptr sur PCB suivant ou NULL si dernier PCB
	MOVE.32		A1,{A6}+ODR_TETE		; Il prend la tete de liste

	MOVE.32		{A0}+OPB_SEMA,A1		; Recupere Semaphore a signaler
	CALL		32^_ISIGNEV			; Et le signale a l'utilisateur
push.16	d7
mon	?aftim
.ascize	"<CR>Signev PktReceived "
pop.16	d7
WRITE_8NUM A0
FIN$:
	POPM.32		A0|A1|D0			; Recupere les registres
	RET

bug$:
	write_str_c	eth:bug	
	write_8num	D0
	write_str	:  :
	write_8num	{A0}+OPB_BUF_TAB+OBUF_PTR
	write_Tab
	MOVE.16		{A1}+ORXpktStatus,D0		; Resultat de la reception
	write_8num	d0
	write_cr
	call 		showreg
	jump		FIN$

;--------\
; PktSent >
;========/
;
; Appelee apres transmission d'un paquet. Prend le paquet suivant et signale le paquet transmis
;
; In	A5.32	^Sonic		
;	A6.32	^variables
; Out
; Mod

; Paquets avec erreur de transmission


PktSent:
	PUSHM.32	A0|A1|D0|D1			; Sauve les registres

	INC.32		{A6}+OS_TX_INT_C		; Met a jour les stats

	MOVE.32		{A6}+ODW_TETE,A0
	COMP.32		#NULL,A0
	JUMP,EQ		FIN$				; Erreur si liste vide, sort

	MOVE.16		{A6}+OTDAStart+OTXpktStatus,D0	; Resultat de la transmission
	write_str_c	eth:PktSend
	write_8num	D0
	write_cr
	CLR.16		{A0}+OPB_RES			; Indique pas d'erreur
	TEST.32		D0:#bSonicPTX			; Transmit OK ?
	JUMP,BS		NXT_PKT$
	MOVE.16		#ERR_TX,{A0}+OPB_RES		; Sinon indique erreur de transmission
	INC.32		{A6}+OS_TX_ERR			; Met a jour stats
	JUMP		ERR_PKT$	
NXT_PKT$:
	
	INC.32		{A6}+OS_TX_FR_C			; Met a jour stats
	MOVE.16		{A6}+OTDAStart+OTXpktPktSize,D1
	ADD.32		D1,{A6}+OS_TX_BYTE_C
ERR_PKT$:
	RL.16		#5,D0
	AND.32		#2'11111,D0
	ADD.32		D0,{A6}+OS_TX_COL		; Met a jour nbre collisions
		
	MOVE.32		{A0}+OPB_NXT,A1			; Ptr sur PCB suivant ou NULL si dernier PCB
	MOVE.32		A1,{A6}+ODW_TETE		; Il prend la tete de liste

	MOVE.32		{A0}+OPB_SEMA,A1		; Recupere Semaphore a signaler
	CALL		32^_ISIGNEV			; Et le signale a l'utilisateur

	CALL		SEND_PACKET			; S'occupe du Paquet suivant
FIN$:
	POPM.32		A0|A1|D0|D1			; Recupere les registres
	RET

;------------\
; SEND_PACKET >
;============/

; Routine transferrant un paquet de la liste vers le TDA du SONIC pour transmission

; in	A6^variables 
; out	-
; mod	-

SEND_PACKET:
	PUSHM.32	A0|A1|D0|D1|D2
	COMP.32		#NULL,{A6}+ODW_TETE
	JUMP,EQ		FIN$			; Liste Vide ?
	MOVE.32		{A6}+ODW_TETE,A0

	MOVE.16		#TCRConfig,{A6}+OTDAStart+OTXpktConfig	; Initialise structure TDA
	MOVE.16		{A0}+OPB_BUF_NB,D0		; Compteur nb fragments
	MOVE.16		D0,{A6}+OTDAStart+OTXpktFragCount	; -> Nb fragment indiqu dans descr TDA
	
	DEC.16		D0				; pour dj.16,nmo ...
	CLR.32		D1				; Compteur taille
	MOVE.32		#{A0}+OPB_BUF_TAB,A0
	MOVE.32		#{A6}+OTDAStart+OTXpktFragDesc,A1		; ^TDA+fradesc -> A1.32
BOU1$:
	ADD.32		{A0}+OBUF_L_LEN,D1		; Additionne longueur de tous les fragments
	MOVE.32		{A0}+OBUF_L_LEN,D2		; Lg Buffer -> D2 -> taille du fragment
	MOVE.16		D2,{A1}+OTXpktFragSize		; Transfere taille fragment dans TDA
	MOVE.32		{A0}+OBUF_PTR,D2
	MOVE.16		D2,{A1}+OTXpktFragPtr0		; Transfere pointeurs buffers
	SWAP.32		D2
	MOVE.16		D2,{A1}+OTXpktFragPtr1

	ADD.32		#LgTXpktFragDesc,A1		; ^descr frag suivant
	ADD.32		#BLEN,A0			; Passe au buffer suivant
	DJ.16,NMO 	D0,BOU1$

	COMP.16		#LgMinEth,D1
	JUMP,HS		LENOK$
								; additionne la difference entre la
	ADD.16		#LgMinEth,{A1}+OTXpktFragSize-LgTXpktFragDesc	; longueur du packet et l le minimum
	SUB.16		D1,{A1}+OTXpktFragSize-LgTXpktFragDesc		; a la longueur du dernier fragment.
	MOVE.16		#LgMinEth,D1				; corrige la taille totale.

LENOK$:		
	MOVE.16		D1,{A6}+OTDAStart+OTXpktPktSize		; Stocke taille totale
	MOVE.16		#EOL,D2					; Indique dernier descripteur	
	MOVE.16		D2,{A1}+OTXpktLink			; A1.32 ^sur ~TxPktLink  (RB)
								; aprs avoir charg tous les descr de fragments
	CALL		StartTransmit				; Commence la transmission		
FIN$:
	POPM.32		A0|A1|D0|D1|D2
	RET


;***********************************************************************************************
;			ROUTINES D'INITIALISATION
;***********************************************************************************************


;--------\
; InitMEM >
;========/
;
; Initialise la memoire
;
; In	A6.32	^variables
; Out
; Mod

InitMEM:

; Initialisation des listes
; **************************

	MOVE.32		#NULL,{A6}+ODR_TETE		; Listes Vides
	MOVE.32		#NULL,{A6}+ODW_TETE

; Initialisation Status
; *********************
;PH move.16->move.8
	MOVE.8		#MajRev,{A6}+OS_REVISION	; Mise a jour version driver
	MOVE.8		#MinRev,{A6}+OS_VERSION
	MOVE.32		A6,{A6}+OS_DRV_MEM		; Ptr vars driver

	RET


;----------\
; InitSonic >
;==========/
;
; Initialisation du Sonic
;
; Effectue un Software Reset du Sonic, fixe sa configuration et initialise ses registres
; Tous les acces au Sonic doivent se faire par des MOVE.16 car la ligne A0 n'est pas cablee
;
; In	A5.32	^Sonic
;	A6.32	^variables
; Out
; Mod

;PH, ajoute la programmation du chip-select
	.if	Carte302
; programmation du chip-select:

; SONIC_BR (SONIC position)
; SONIC_OR 
;
SONIC_BR		= BASE+O_BR1					; SONIC uses CS3
SONIC_OR		= BASE+O_OR1

SONIC_BR_FC	= 2'001		*(2**B_BR_FC0)			; FC2-FC0, Not used (see ROM1_OR_CFC)
SONIC_BR_BA	= AdSonic	/(2**10'13)*(2**B_BR_BA)	; SONIC_BASE  (upper 11 bits << 2)
SONIC_BR_RW	= 2'0		*(2**B_BR_RW)			; Read only, Not used (see SONIC_OR_MRW)
SONIC_BR_EN	= 2'1		*(2**B_BR_EN)			; Enable
SONIC_BR_VAL	= SONIC_BR_FC.or.SONIC_BR_BA.or.SONIC_BR_RW.or.SONIC_BR_EN

SONIC_OR_DTACK	= 2'111		*(2**B_OR_DTACK)		; DTACK made by SONIC
SONIC_OR_MASK	= 2'11111111111	*(2**B_OR_MASK)			; ROM = A1..A12 not decoded
SONIC_OR_MRW	= 2'0		*(2**B_OR_MRW)			; Disable ROM1_BR_RW
SONIC_OR_CFC	= 2'0		*(2**B_OR_CFC)			; ignore FC2-FC0 in BR0
SONIC_OR_VAL	= SONIC_OR_DTACK.or.SONIC_OR_MASK.or.SONIC_OR_MRW.or.SONIC_OR_CFC
	.endif	Carte302


InitSonic:
	PUSHM.32	A0|D0				; Sauvegarde les registres
	.if	Carte302
	MOVE.16		#SONIC_OR_VAL,	BASE+O_OR3	; init CS Sonic
	MOVE.16		#SONIC_BR_VAL,	BASE+O_BR3	; """
	.endif	Carte302

; Effectue un Software Reset du Sonic
; ***********************************

	MOVE.16		#2**bSonicRST,D0		; Met le bit RST a 1
	MOVE.16		D0,{A5}+SonicCR

	MOVE.16		{A5}+SonicDCR,D0		; ** DATA CONFIGURATION REGISTER **
	TCLR.32		D0:#bSonicSTERM			; Asynchronous Mode
;	TSET.32		D0:#bSonicWC0			; 3 Wait State
;	TSET.32		D0:#bSonicWC1			; 3 Wait State
	TCLR.32		D0:#bSonicWC0			; 0 Wait State
	TCLR.32		D0:#bSonicWC1			; 0 Wait State
	.if	BUS16
	TCLR.32		D0:#bSonicDW			; 16 bit Data Width
	.endif
	.if	BUS32
	TSET.32		D0:#bSonicDW			; 32 bit Data Width
	.endif
	TCLR.32		D0:#bSonicBMS			; Empty/fill FIFOs Mode

	TSET.32		D0:#bSonicRFT1			; set receive fifo threshold
	TSET.32		D0:#bSonicRFT0			; to 24 bytes

	TCLR.32		D0:#bSonicTFT1			; set transmit fifo threshold
	TSET.32		D0:#bSonicTFT0			; to 16 bytes

	TCLR.32		D0:#bSonicPO1			; set programmable output 1 to 0
	TSET.32		D0:#bSonicPO0			; set programmable output 0 to 1
	.if	S130
	TSET.32		D0:#bSonicExBus			; Mode bus d'extension
	.endif
	MOVE.16		D0,{A5}+SonicDCR

	.if	S130
;;	MOVE.16		{A5}+SonicDCR2,D0		; ** DATA CONFIGURATION REGISTER 2**
	move.16		#2'0000*(2**bSonicEXPO0),d0	; SIZ1, SIZ0, A0 = 0
	MOVE.16		D0,{A5}+SonicDCR2
	.endif	S130

	MOVE.16		#0,D0				; Remet le bit RST a 0		
	MOVE.16		D0,{A5}+SonicCR


; Fixe la configuration du Sonic
; ******************************

	MOVE.16		{A5}+SonicRCR,D0		; ** RECEIVE CONTROL REGISTER **
;	TSET.32		D0:#bSonicERR			; Accept Packets with Errors
	TCLR.32		D0:#bSonicERR			; Don't Accept Packets with Errors
	TCLR.32		D0:#bSonicRNT			; Reject Runt Packets
	TSET.32		D0:#bSonicBRD			; Accept Broadcast Packets
;	TSET.32		D0:#bSonicAMC			; Accept Multicast Packets
	TCLR.32		D0:#bSonicAMC			; Don't Accept Multicast Packets
	TCLR.32		D0:#bSonicPRO			; No Promiscuious Mode
	TCLR.32		D0:#bSonicLB0			; No Loopback
	TCLR.32		D0:#bSonicLB1			; No Loopback
	MOVE.16		D0,{A5}+SonicRCR

	MOVE.16		{A5}+SonicTCR,D0		; ** TRANSMIT CONTROL REGISTER **
	TCLR.32		D0:#bSonicPINTR			; No Transmit Programable Interrupt
	TCLR.32		D0:#bSonicPOWC			; Timer begins after the SFD
	TCLR.32		D0:#bSonicCRCI			; Transmit Packet with CRC
	TCLR.32		D0:#bSonicEXDIS			; Excessive Deferral Timer Enable
	MOVE.16		D0,{A5}+SonicTCR

	MOVE.16		{A5}+SonicIMR,D0		; ** INTERRUPT MASK REGISTER **
	TCLR.32		D0:#bSonicBREN			; Bus Retry Occurred		Disable
	TCLR.32		D0:#bSonicHBLEN			; Heartbeat Lost		Disable
	TCLR.32		D0:#bSonicLCDEN			; Load CAM Done			Disable
	TCLR.32		D0:#bSonicPINTEN		; Programmable Interrupt	Disable
	TSET.32		D0:#bSonicPRXEN			; Packet Received		Enable
	TSET.32		D0:#bSonicPTXEN			; Packet Transmitted OK		Enable
	TSET.32		D0:#bSonicTXEREN		; Transmit Error		Enable
	TCLR.32		D0:#bSonicTCEN			; Timer Complete		Disable
	TCLR.32		D0:#bSonicRDEEN			; Receive Descriptors Exhausted	Disable
	TCLR.32		D0:#bSonicRBEEN			; Receive Buffers Exhausted	Disable
	TCLR.32		D0:#bSonicRBAEEN		; Receive Buffer Area Exceeded	Disable
	TCLR.32		D0:#bSonicCRCEN			; CRC Tally Counter Warning	Disable
	TCLR.32		D0:#bSonicFAEEN			; FAE Tally Counter Warning	Disable
	TCLR.32		D0:#bSonicMPEN			; MP Tally Counter Warning	Disable
	TCLR.32		D0:#bSonicRFOEN			; Receive FIFO Overrun		Disable
	MOVE.16		D0,{A5}+SonicIMR


; Initialisation des registres qui grent la RRA
; **********************************************

	MOVE.32		A6,D0					; Initialisation du URRA
	SWAP.32		D0
	MOVE.16		D0,{A5}+SonicURRA

	MOVE.32		#{A6}+ORRAStart,A0			; Initialisation du RSA
	MOVE.16		A0,{A5}+SonicRSA
	MOVE.16		A0,{A5}+SonicRRP			; Initialisation du RRP
	MOVE.16		A0,{A5}+SonicRWP			; et du RWP, table descr. vide
	MOVE.32		#{A6}+ORDAStart,A0			; Initialisation du REA
	MOVE.16		A0,{A5}+SonicREA

; Initialise les registres qui gerent la CDA (CAM)
; ******************************************
; Le URRA est initialise lors de l'initialisation de la RRA

push.16	d7
;;	LIB	?aftim
;;	.ascize	"<CR>Chargement LCAM avec 1 adresse"
pop.16	d7

	move.32		#R16^AdrLocal,A4
	call		RMC					; Met l'adresse local dans la LCAM

; Initialisation des registres qui gerent la RDA
; **********************************************
push.16	d7
;;	lib	?aftim
;;	.ascize	"<CR>URDA"
pop.16	d7

	MOVE.32		A6,D0				; Initialisation du URDA
	SWAP.32		D0
	MOVE.16		D0,{A5}+SonicURDA
	MOVE.32		#{A6}+ORDAStart,A0		; Initialisation du CRDA
	MOVE.16		A0,{A5}+SonicCRDA


; Initialisation des registres qui gerent la TDA
; **********************************************


	MOVE.32		A6,D0				; Initialisation du UTDA
	SWAP.32		D0
	MOVE.16		D0,{A5}+SonicUTDA
	MOVE.32		#{A6}+OTDAStart,A0		; Initialisation du CTDA
	MOVE.16		A0,{A5}+SonicCTDA


; Initialisation des registres qui gerent la RBA
; **********************************************

	.if	Carte302	
	MOVE.16		#(LgRXBuffer/2)-2,{A5}+SonicEOBC ; Initialise le EOBC pour avoir 1 paquet/buffer
	.endif
	.if	S130
	MOVE.16		#1520/2,{A5}+SonicEOBC		; Pour 32 bits
	.endif
	POPM.32		A0|D0				; Recupere les registres
	RET


;-------------\
; StartReceive >
;=============/
;
; Autorise le Sonic a recevoir des paquets
;
; In	A5.32	^Sonic
; Out
; Mod

StartReceive:
	PUSH.32		D0				; Sauve les registres

	MOVE.32		#2**bSonicRXEN,D0		; Met le bit RXEN a 1
	MOVE.16		D0,{A5}+SonicCR	

L1$:
;	MOVE.16		{A5}+SonicCR,D0			; Attend que RXDIS soit a 0
;	TEST.32		D0:#bSonicRXDIS
;	JUMP,NE		L1$

	POP.32		D0				; Recupere les registres
	RET


;------------\
; StopReceive >
;============/
;
; Interdit au Sonic de recevoir des paquets
;
; In	A5.32	^Sonic
; Out
; Mod

StopReceive:

	PUSH.32		D0				; Sauve les registres
	MOVE.16		#2**bSonicRXDIS,{A5}+SonicCR	; Met le bit RXDIS a 1

L1$:
;	MOVE.16		{A5}+SonicCR,D0			; Attend que RXEN soit a 0
;	TEST.32		D0:#bSonicRXEN
;	JUMP,NE		L1$

	POP.32		D0				; Recupere les registres
	RET


;--------------\
; StartTransmit >
;==============/
;
; Demarre la transmission d'un paquet
;
; In	A5.32	^Sonic
; Out
; Mod
; On suppose qu'on est pas en train de faire un LCAM (load cam). Le fait de mettre 
; TXP a un quand LCAM est a un aussi bloque le SONIC! On ne veut pas tester LCAM
; a chaque emission d'un paquet par contre quand on charge la cam on attend que 
; l'operation se termine.

StartTransmit:
push.16	d7
lib	?aftim
.ascize	"<CR>Start Transmit ..."
pop.16	d7

	PUSHM.32	A0				; Sauve les registres
	MOVE.32		#{A6}+OTDAStart,A0
	MOVE.16		A0,{A5}+SonicCTDA		; Initialise ptr sur zone TDA
	MOVE.16		#2**bSonicTXP,{A5}+SonicCR	; Met le bit TXP a 1

	POPM.32		A0				; Recupere les registres
	RET


;-------------\
; StopTransmit >
;=============/
;
; Stoppe la transmission d'un paquet
;
; In	A5.32	^Sonic
; Out
; Mod

StopTransmit:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		#2**bSonicHTX,{A5}+SonicCR	; Met le bit HTX a 1
L1$:
	MOVE.16		{A5}+SonicCR,D0			; Attend que TXP soit a 0
	TEST.32		D0:#bSonicTXP
	JUMP,NE		L1$

	POP.32		D0				; Recupere les registres
	RET


;----------\
; Broadcast >
;==========/
;
; Accepte les paquets en mode Broadcast
;
; In	A5.32		^Sonic
; Out
; Mod

Broadcast:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0		
	TSET.32		D0:#bSonicBRD
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET


;------------\
; NoBroadcast >
;============/
;
; Refuse les paquets en mode Broadcast
;
; In	A5.32		^Sonic
; Out
; Mod

NoBroadcast:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0		
	TCLR.32		D0:#bSonicBRD
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET


;-------------\
; Promiscuious >
;=============/
;
; Accepte tous les paquets recus
;
; In	A5.32		^Sonic
; Out
; Mod

Promiscuious:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0		
	TSET.32		D0:#bSonicPRO
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET


;---------------\
; NoPromiscuious >
;===============/
;
; Annule le mode Promiscuious
;
; In	A5.32		^Sonic
; Out
; Mod

NoPromiscuious:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0		
	TCLR.32		D0:#bSonicPRO
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET


;------------\
; MacLoopback >
;============/
;
; Effectue un Loopback au niveau du MAC
;
; In	A5.32		^Sonic
; Out
; Mod

MacLoopback:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0
	TSET.32		D0:#bSonicLB0		
	TCLR.32		D0:#bSonicLB1
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET


;--------------\
; EndecLoopback >
;==============/
;
; Effectue un Loopback au niveau de l'ENDEC
;
; In	A5.32		^Sonic
; Out
; Mod

EndecLoopback:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0
	TCLR.32		D0:#bSonicLB0		
	TSET.32		D0:#bSonicLB1
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET


;--------------------\
; TransceiverLoopback >
;====================/
;
; Effectue un Loopback au niveau du Transceiver
;
; In	A5.32		^Sonic
; Out
; Mod

TransceiverLoopback:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0
	TSET.32		D0:#bSonicLB0		
	TSET.32		D0:#bSonicLB1
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET


;-----------\
; NoLoopback >
;===========/
;
; Selectionne le mode normal de fonctionnement
;
; In	A5.32		^Sonic
; Out
; Mod

NoLoopback:
;PH
	PUSH.32		D0				; Sauve les registres
	MOVE.16		{A5}+SonicRCR,D0
	TCLR.32		D0:#bSonicLB0		
	TCLR.32		D0:#bSonicLB1
	MOVE.16		D0,{A5}+SonicRCR
	POP.32		D0				; Recupere les registres
	RET

	.if	Carte302
;-----------\
; IRQ7       >
;===========/

; ROUTINE D'INTERRUPTION QUI AFFICHE LES REGISTRES DU SONIC

; in	-
; out	-
; mod	-

IRQ7:
	pushm.32	a0|d0
	MOVE.32		#BASE,A0
	MOVE.16		{A0}+O_ISR,D0

	WRITE_STR	68000 ISR : 
	WRITE_4NUM	D0	
	WRITE_CR

	CALL		R16^SHOWREG
	SHOW_68000
	TRAP		#1
	RETSF


;------------\
; IRQ7_INSTALL>
;============/

; intalle une routine d'interruption IRQ7 et met le processeur
; en mode dedicaced ( numero vecteur utilise = 16'17)

; in	-
; out	-
; mod	-

;GIMR_MOD	=	2'1	*(2**B_GIMR_MOD)
;GIMR_IV7	=	2'0	*(2**B_GIMR_IV7)
;GIMR_ET7	=	2'1	*(2**B_GIMR_ET7)


IRQ7_INSTALL:
	PUSHM.32		D0|A0

	MOVE.16		BASE+O_GIMR,D0		;INITIALISE GIMR
	TSET.32		D0:#B_GIMR_MOD
	TCLR.32		D0:#B_GIMR_IV7
	TSET.32		D0:#B_GIMR_ET7
	TCLR.32		D0:#B_GIMR_V
	TSET.32		D0:#B_GIMR_V+1
	TCLR.32		D0:#B_GIMR_V+2
	MOVE.16		D0, BASE+O_GIMR
	
	MOVE.32		#R16^IRQ7, A0	; INSTALLE VECT INTERUPT IRQ7
	MOVE.32		A0, V_IRQ7
	POPM.32		D0|A0
	RET

	.endif	Carte302
;-----------\
; SHOWREG    >
;===========/

; Montre registres internes du chip

; in	-
; out	registres par port seriel
; mod	-

SHOWREG:
	PUSHM.32 	D4|A5|d7

	MOVE.32		#AdSonic,A5	;Adresse Sonic, permet d'afficher les registres
.if	0
	MON		?AFTIM
	.ASCIZE		"CR="
	MOVE.16		{A5}+SonicCR,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" DCR="
	MOVE.16		{A5}+SonicDCR,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" DCR2="
	MOVE.16		{A5}+SonicDCR2,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" RCR="
	MOVE.16		{A5}+SonicRCR,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" TCR="
	MOVE.16		{A5}+SonicTCR,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" IMR="
	MOVE.16		{A5}+SonicIMR,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" ISR="
	MOVE.16		{A5}+SonicISR,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		"<CR>UTDA="
	MOVE.16		{A5}+SonicUTDA,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CTDA="
	MOVE.16		{A5}+SonicCTDA,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" URDA="
	MOVE.16		{A5}+SonicURDA,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CRDA="
	MOVE.16		{A5}+SonicCRDA,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		"<CR>EOBC="
	MOVE.16		{A5}+SonicEOBC,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" URRA="
	MOVE.16		{A5}+SonicURRA,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" RSA="
	MOVE.16		{A5}+SonicRSA,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" REA="
	MOVE.16		{A5}+SonicREA,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" RRP="
	MOVE.16		{A5}+SonicRRP,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" RWP="
	MOVE.16		{A5}+SonicRWP,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" RSC="
	MOVE.16		{A5}+SonicRSC,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		"<CR>CEP="
	MOVE.16		{A5}+SonicCEP,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CAP2="
	MOVE.16		{A5}+SonicCAP2,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CAP1="
	MOVE.16		{A5}+SonicCAP1,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CAP0="
	MOVE.16		{A5}+SonicCAP0,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CE="
	MOVE.16		{A5}+SonicCE,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CDP="
	MOVE.16		{A5}+SonicCDP,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" CDC="
	MOVE.16		{A5}+SonicCDC,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		"<CR>CRCT ="
	MOVE.16		{A5}+SonicCRCT,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" FAET="
	MOVE.16		{A5}+SonicFAET,D4
	MON		?AFX4	
	MON		?AFTIM
	.ASCIZE		" MPT="
	MOVE.16		{A5}+SonicMPT,D4
	MON		?AFX4
	MON		?AFTIM
	.ASCIZE		"<CR>"	
	MON		?AFTIM
	.ASCIZE		"<CR>"	
.else
	LIB		?AFTIM
	.ASCIZE		"CR="
	MOVE.16		{A5}+SonicCR,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" DCR="
	MOVE.16		{A5}+SonicDCR,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" DCR2="
	MOVE.16		{A5}+SonicDCR2,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" RCR="
	MOVE.16		{A5}+SonicRCR,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" TCR="
	MOVE.16		{A5}+SonicTCR,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" IMR="
	MOVE.16		{A5}+SonicIMR,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" ISR="
	MOVE.16		{A5}+SonicISR,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		"<CR>UTDA="
	MOVE.16		{A5}+SonicUTDA,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CTDA="
	MOVE.16		{A5}+SonicCTDA,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" URDA="
	MOVE.16		{A5}+SonicURDA,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CRDA="
	MOVE.16		{A5}+SonicCRDA,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		"<CR>EOBC="
	MOVE.16		{A5}+SonicEOBC,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" URRA="
	MOVE.16		{A5}+SonicURRA,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" RSA="
	MOVE.16		{A5}+SonicRSA,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" REA="
	MOVE.16		{A5}+SonicREA,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" RRP="
	MOVE.16		{A5}+SonicRRP,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" RWP="
	MOVE.16		{A5}+SonicRWP,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" RSC="
	MOVE.16		{A5}+SonicRSC,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		"<CR>CEP="
	MOVE.16		{A5}+SonicCEP,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CAP2="
	MOVE.16		{A5}+SonicCAP2,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CAP1="
	MOVE.16		{A5}+SonicCAP1,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CAP0="
	MOVE.16		{A5}+SonicCAP0,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CE="
	MOVE.16		{A5}+SonicCE,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CDP="
	MOVE.16		{A5}+SonicCDP,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" CDC="
	MOVE.16		{A5}+SonicCDC,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		"<CR>CRCT ="
	MOVE.16		{A5}+SonicCRCT,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" FAET="
	MOVE.16		{A5}+SonicFAET,D4
	LIB		?AFX4	
	LIB		?AFTIM
	.ASCIZE		" MPT="
	MOVE.16		{A5}+SonicMPT,D4
	LIB		?AFX4
	LIB		?AFTIM
	.ASCIZE		"<CR>"	
	LIB		?AFTIM
	.ASCIZE		"<CR>"	
 .endif
	POPM.32 	D4|A5|d7

	RET


;
.if TESTDRIV

;********************
; Variable Programme
;********************
NbRcv	=	4

	.APC	PC_record
	.loc	0
oPntFirst:	.blk.32	1	; ^descr First
oPntLast:	.blk.32	1	; ^descr Last
LgDescList	=	APC

	.APC	PC_var
	.LOC	0

OCMDStruct:	.BLK.8		CMD_LEN	; Structure de passage de commande

	.EVEN

ORXSemDriv:	.BLK.32	1	; Semaphore de synchronisation avec le driver en reception
OTXSemDriv:	.BLK.32	1	; idem pour transmission
oPntDescRd:	.blk.8	LgDescList	; ^descr Driver async Lecture (list)
oPntDescWr:	.blk.32	1	; ^descr Driver async Ecriture
TestVarLen	=	APC

;*******************************************************************
;               P R O G R A M M E   D E    T E S T 	
;*******************************************************************

	.START	TESTETH
	.APC	PC_code

;*********************************************
; Initialisation Memoire Variables et Buffers 
;*********************************************

TESTETH:	
	.if	assmile
	.else
	lib	?opelib
	.endif

	call	showreg
	JUMP	STEST

DRIVARPTR:	.BLK.32		1	; Stocke A6 driver pour le test

STEST:
	MOVE.32		#TestVarLen,D4
	MOVE.16		#MTYPCP,D1
	GESMEM		?GETMEM			; Alloue memoire variables
	push.16		d7
	gesmem		?clearmem
	pop.16		d7
	JUMP,NE		FINTEST		
	MOVE.32		A4,A6			; A6 ptr sur variables

	
;***************************
; Initialisation Semaphore
;***************************
push.16	d7
	lib	?aftim
	.ascize	"<CR><NOROLL>Initialise smaphores "
pop.16	d7

	CLR.16		D4
	NTREL		?CRESEM		; Cree le semaphore pour la synchro read avec le driver
	TEST.16		D7
	JUMP,NE		ERRTEST
	MOVE.32		A5,{A6}+ORXSemDriv

	CLR.16		D4
	NTREL		?CRESEM		; Cree le semaphore pour la synchro write avec le driver
	TEST.16		D7
	JUMP,NE		ERRTEST
	MOVE.32		A5,{A6}+OTXSemDriv
	
	MOVE.32		#AdSonic,A5	;Adresse Sonic, permet d'afficher les registres

	move.32		#{a6}+oPntDescRd,a0	; ^descr list PCB rd
	call		InitList		; Initialise la liste de rception

l$:
	call		SelOrdre	; Slectionne un ordre
	jump,eq		l$

FINTEST:
push.16	d7
	lib	?aftim
	.ascize	"<CR>Fin du test "
pop.16	d7
	.if	assmile
	exit
	JUMP	FINTEST	
	.else
	lib	?clolib
	fos	?stop
	.endif	assmile

ERRTEST:
push.16	d7
	lib	?aftim
	.ascize	"<CR>Erreur ..."
pop.16	d7
	jump	FinTest

;--------\
; C_Reset >
;========/
;
; Commande de reset du pilote
;
; In	
; Out
; Mod

C_Reset:
push.16	d7
	lib	?aftim
	.ascize	"<CR> S0Reset"
pop.16	d7

	CALLDRIV	S0RESET
	call		SHOWREG
	ret


;-------\
; C_Open >
;=======/
;
; Commande d'ouverture du pilote
;
; In
; Out
; Mod

C_Open:
push.16	d7
	lib	?aftim
	.ascize	"<CR> S0Open "
pop.16	d7
	CALLDRIV	S0OPEN
	ret

;--------------\
; C_Command_LBT >
;==============/
;
; Commande LoopBack Transceiver
;
; In
; Out
; Mod

C_Command_LBT:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Transceiver_LoopBack"
pop.16	d7
	MOVE.32		#{A6}+OCMDStruct,A4	; Structure CMD dans les variables utilisee pour
						; passer les commandes
	MOVE.16		#Trans_Loop,{A4}+OCMD_TYPE	; Mode LoopBack Transceiver
	CALLDRIV	S0COMMAND
	ret

;--------------\
; C_Command_LBE >
;==============/
;
; Commande LoopBack EnDec
;
; In
; Out
; Mod

C_Command_LBE:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Endec_LoopBack"
pop.16	d7
	MOVE.32		#{A6}+OCMDStruct,A4	; Structure CMD dans les variables utilisee pour
						; passer les commandes
	MOVE.16		#Endec_Loop,{A4}+OCMD_TYPE	; Mode LoopBack EnDec
	CALLDRIV	S0COMMAND
	ret

;--------------\
; C_Command_LBM >
;==============/
;
; Commande LoopBack Mac
;
; In
; Out
; Mod

C_Command_LBM:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Mac_LoopBack"
pop.16	d7
	MOVE.32		#{A6}+OCMDStruct,A4	; Structure CMD dans les variables utilisee pour
						; passer les commandes
	MOVE.16		#Mac_Loop,{A4}+OCMD_TYPE	; Mode LoopBack Mac
	CALLDRIV	S0COMMAND
	ret

;---------------\
; C_Command_NoLB >
;===============/
;
; Commande pas de LoopBack
;
; In
; Out
; Mod

C_Command_NoLB:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande pas de LoopBack"
pop.16	d7
	MOVE.32		#{A6}+OCMDStruct,A4	; Structure CMD dans les variables utilisee pour
						; passer les commandes
	MOVE.16		#Loop_Off,{A4}+OCMD_TYPE	; Mode pas de LoopBack
	CALLDRIV	S0COMMAND
	ret

;---------------\
; C_Command_Prm  >
;===============/
;
; Commande Promiscious Mode (prend tous les paquets)
;
; In
; Out
; Mod

C_Command_Prm:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Promiscious"
pop.16	d7
	MOVE.32		#{A6}+OCMDStruct,A4	; Structure CMD dans les variables utilisee pour
						; passer les commandes
	MOVE.16		#Prmsc_On,{A4}+OCMD_TYPE	; Mode promiscious
	CALLDRIV	S0COMMAND
	ret

;----------------\
; C_Command_NoPrm >
;================/
;
; Commande pas de Promiscious Mode
;
; In
; Out
; Mod

C_Command_NoPrm:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Promiscious disable"
pop.16	d7
	MOVE.32		#{A6}+OCMDStruct,A4	; Structure CMD dans les variables utilisee pour
						; passer les commandes
	MOVE.16		#Prmsc_Off,{A4}+OCMD_TYPE	; Mode pas de promiscious
	CALLDRIV	S0COMMAND
	ret

;---------------\
; C_Command_Brd  >
;===============/
;
; Commande Broadcast Enable
;
; In
; Out
; Mod

C_Command_Brd:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Broadcast Enable"
pop.16	d7
	MOVE.32		#{A6}+OCMDStruct,A4	; Structure CMD dans les variables utilisee pour
						; passer les commandes
	MOVE.16		#Broad_On,{A4}+OCMD_TYPE	; Mode Broadcast
	CALLDRIV	S0COMMAND
	ret


;----------------\
; C_Command_NoBrd >
;================/
;
; Commande Broadcast Disable
;
; In
; Out
; Mod

C_Command_Brd_Off:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Commande Broadcast Enable"
pop.16	d7
	MOVE.32		#{A6}+OCMDStruct,A4	; Structure CMD dans les variables utilisee pour
						; passer les commandes
	MOVE.16		#Broad_Off,{A4}+OCMD_TYPE	; Mode Broadcast disable
	CALLDRIV	S0COMMAND
	ret

;------------\
; mC_Transmit >
;============/
;
; Transmission multiple
;
; In
; Out
; Mod

mC_Transmit:
push.16	d7
	lib	?aftim
	.ascize	"<CR>Nombre de boucle:"
	lib	?getdec
	test.32	d4
	jump,eq	f$
l$:
	push.32	d4
	call	C_Transmit
	popm.32	d4
	jump,ne	f$
	dec.32	d4
	jump,ne	l$
f$:
pop.16	d7

	ret
;-----------\
; C_Transmit >
;===========/
;
; Transmet un paquet
;
; In
; Out
; Mod

C_Transmit:
	call		GetPCB			; ^PCB pour l'criture -> A4.32
	JUMP,NE		ERR$	
	move.32		a4,{a6}+oPntDescWr

push.16	d7
lib	?aftim
.ascize	"<CR>Prt  transmettre "

PUSH.32	#R16^DrivARPTR
pop.32	d4
lib	?afx8
lib	?aftab
PUSH.32	R16^DrivARPTR
pop.32	d4
lib	?afx8
pop.16	d7

	CALL		INIT_TXPCB		; Initialise le descripteur du paquet
	CALLDRIVU	S0WRITE			; Envoie le paquet
	jump,ne		Err$	
;;SUP
;;	CALLDRIV 	PktSent			; simule interrupt chip
;;USER
push.16	d7
	lib	?aftim
	.ascize	"<CR> Attend fin transmission"
pop.16	d7

	MOVE.32		{A4}+OPB_SEMA,A5	; Smaphore
	NTREL		?WAITEV			; Attend Transmission

	push.16	d7
	lib	?aftim
	.ascize	"<CR>Transmission effectue"
	pop.16	d7

	JUMP,NE		ERR$

push.16	d7
	lib	?aftim
	.ascize	"<CR>Tx oPB_Res "
pop.16	d7
	MOVE.16		{A4}+OPB_RES,D4		; Resultat Intermediaire
push.16	d7
	lib		?aftab
	lib		?afx4
pop.16	d7

	move.32		{a6}+oPntDescWr,A4
	call		GivBackPCB		; rend PCB criture

;exit
f$:
	ret

Err$:
	push.16	d7
	lib	?aftim
	.ascize	"<CR>Erreur Transmission "
	pop.16	d7
	exit
	jump	f$

;-----------\
; C_PrepRead >
;===========/
;
; Prparation pour recevoir des paquets
;
; In	D6.16	nbres de paquets  tre prt  recevoir
; Out
; Mod

C_PrepRead:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Initialise "

	move.16	d6,d4
	lib	?afx2
	lib	?aftim
	.ascize	" descripteurs de paquets Rx "
pop.16	d7
llrd$:
	call		GetPCB			; ^PCB pour la lecture -> A4.32
	jump,ne		ERR$
	move.32		#{a6}+oPntDescRd,a0	; ^descr list PCB rd
	call		PutLastPCB		; Met PCB dans la liste

	CALL		INIT_RXPCB		; Initialise le descripteur du buffer
	jump,ne		ERR$

push.16	d7
lib		?aftim
.ascize		"<CR> S0Read PCB: "
pop.16	d7
AFX8	a4
	CALLDRIV	S0READ			; Envoie le buffer
	dj.16,nmo	d6,llRd$

f$:
	ret

Err$:
	push.16	d7
	lib	?aftim
	.ascize	"<CR>Erreur Prparation rception "
	pop.16	d7
	exit
	jump	f$
	

;-----------\
; C_Wait_Rcv >
;===========/
;
; Attend de recevoir un paquet
;
; In
; Out
; Mod

C_Wait_Rcv:
push.16	d7
	lib	?aftim
	.ascize	"<CR> Attend rception "
pop.16	d7

	move.32		#{a6}+oPntDescRd,a0	; ^descr list PCB rd
	call		GetFirstPCB		; ^First PCB -> A4.32
;call	showreg
;exit
AFX8	A4
	move.32		#5*50,d4
	ntrel		?modtim			; modifie Time out

	MOVE.32		{A4}+OPB_SEMA,A5	; Semaphore
	NTREL		?WAITEV			; Attend Reception

	push.16	d7
	ntrel		?modtim
	lib	?aftim
	.ascize	"<CR> Reu si pas d'erreur "
	pop.16		d7
;exit
	JUMP,NE		ERR$

push.16	d7
	lib	?aftim
	.ascize	"<CR>Rx oPB_Res "
pop.16	d7
	MOVE.16		{A4}+OPB_RES,D4		; Resultat Intermediaire
push.16	d7
	lib		?aftab
	lib		?afx4
pop.16	d7

	move.32		{a4}+oPB_Buf_Tab+oBuf_Ptr,A0	; ^buffer de rception
	call		GivBackPCB		; rend PCB lecture
	move.32		a0,a4
	call		GivRxBuffer		; rend mmoire du buffer de rception
f$:
	ret

Err$:
	push.16	d7
	lib	?aftim
	.ascize	"<CR>Erreur Attente Paquet "
	pop.16	d7
	exit
	jump	f$

;---------------\
; C_Statistiques >
;===============/
;
; Lit les statistiques d'erreurs
;
; In
; Out
; Mod

C_Statistiques:
	MOVE.32		#STAT_MEM_LEN+2,D4
	MOVE.16		#MTYPCP,D1
	GESMEM		?GETMEM			; Alloue memoire variables
	gesmem		?ClearMem
	JUMP,NE		Err$

push.16	d7
	lib	?aftim
	.ascize	"<CR> Lecture de statistiques "
pop.16	d7
	CALLDRIV	S0STATUS

	exit

	Gesmem	?Givmem
f$:
	ret
	
Err$:
push.16	d7
	lib	?aftim
	.ascize	"<CR>Erreur Statistique "
pop.16	d7
	exit
	jump	f$

;--------\
; C_Close >
;========/
;
; Ferme le pilote
;
; In
; Out
; Mod

C_Close:
push.16	d7
	lib	?aftim
	.ascize	"<CR> S0Close "
pop.16	d7
	CALLDRIV	S0CLOSE
push.16	d7
lib	?aftim
.ascize	"<CR>Fin close"
pop.16	d7
exit
f$:
	ret

C_End:
	CLRZ
	ret

;---------\
; SelOrdre >
;=========/
;
; Slection d'un ordre et excution
;
; In
; Out
; Mod

SelOrdre:
	move.32	#R16^Menu,a3
	lib	?afmenu
l$:
	move.32	#R16^TOrdre,A0
	lib	?getcar			; code touche -> D3.16
l1$:
	move.16	{a0+},d0
	jump,eq	l$			; fin de la table
	comp.16	d0,d3			; touche connue ?
	jump,eq	s1$			; oui -> s1$
	add.32	#2,A0
	jump	l1$			; essaie plus loin
s1$:
	move.16	{a0},d0			; offset
	move.32	#R16^TOrdre,a0
	move.32	#{a0}+A16^{D0},A0	; adresse de la routine -> A0.32
	call	{a0}			; et y saute
	ret

TOrdre:
	.16.16	F0,C_End-TOrdre
	.16.16	F1,C_Reset-TOrdre	;
	.16.16	F2,C_Open-TOrdre	;
	.16.16	F3,C_Close-TOrdre	; Ferme le pilote
	.16.16	F4,C_Command_LBT-TOrdre	;Commande Transceiver_LoopBack
	.16.16	F5,C_Command_LBE-TOrdre	;Commande Endec_LoopBack
	.16.16	F6,C_Command_LBM-TOrdre	;Commande Mac_LoopBack
	.16.16	F7,C_Command_NoLB-TOrdre	;Commande pas de LoopBack
	.16.16	F8,C_Command_Prm-TOrdre	;Commande Promiscious"
	.16.16	F9,C_Command_NoPrm-TOrdre	;Commande Promiscious disable"
	.16.16	F10,C_Command_Brd-TOrdre	;Commande Broadcast Enable"
	.16.16	F11,C_Command_Brd_Off-TOrdre	;Commande Broadcast Enable"
	.16.16	F12,C_Statistiques-TOrdre	;Lecture de statistiques "
	.16.16	F13,C_Transmit-TOrdre	;Transmet un paquet
	.16.16	F14,C_PrepRead-TOrdre	;Prparation pour recevoir des paquets
	.16.16	F15,C_Wait_Rcv-TOrdre	;Attend rception "
	.16.16	shift+F13,mC_Transmit-TOrdre	;Transmet un paquet

	.16	0

Menu:
	.asciz	""
	.asciz	"Fin"
		;     ;     ;     ;
	.asciz	""
	.asciz	"Reset Open Close"
		;     ;     ;     ;
	.asciz	""
	.asciz	"LBT   LBE   LBM"
		;     ;     ;     ;
	.asciz	""
	.asciz	"NoLB  Prm  NoPrm"
		;     ;     ;     ;
	.asciz	""
	.asciz	"Brd  NoBrd  Stat"
		;     ;     ;     ;
	.asciz	"mTx"
	.ascize	"Tx   PrepRx WaitRx"

; ********************************************************
; Paquet Exemple a Transmettre separe en trois fragments :
; Donnees, Adresse Source, Adresse Destination
; ********************************************************

TR_DATA:
	.ASCII "Ceci est un beau paquet Ethernet avec Suffisament de caracteres..."
	.ASCIZ "Il devrait d'ailleurs etre suffisamment long pour pouvoir passer le test"
	.EVEN
LgTXData	=	APC - TR_DATA

SRC_ADR:
AdrLocal:
TR_ADR:
	.16	AdPhys2,AdPhys1,AdPhys0		; Adresse Source
	.BLK.16	1

;;TR_ADR:
	.16	16'0102,16'FFFF,16'ABCD		; Adresse Broadcast

	
;**********************************************
; Initialisation buffers et structure PCB Read
;**********************************************
; Attention, le ^buffer de rception doit point sur une adresse multiple de 4 
; pour bus 32 bits
;
; in	A6.32	^var
;	A4.32	^PCB
; out	A4	^PCB intialise
; mod	-

INIT_RXPCB:	; Initialise structure PCB reception avec Buffer

	PUSHM.32	A0|A1|d1|d4|d5|a5

	move.32		A4,a1
	MOVE.32		#LgRXBuffer,D4
	MOVE.32		#16'0,A4		; Adresse min du debut de la portion de memoire
	MOVE.32		#16'FFFFFE,A5		; Adresse max du debut de la portion de memoire
	MOVE.32		#16'4,D5		; Modulo d'alignement (un seul 1)
	MOVE.16		#MTYPCP,D1		; Type
	GESMEM		?GETALMEM		; Adresse de la memoire allouee dans A4.32
;;	GESMEM		?GETMEM			; Alloue memoire buffer RX
	JUMP,NE		ERR$	
	EX.32		A4,A1			; ^buffer -> A1.32
						; ^PCB -> A4.32
	MOVE.32		{A6}+ORXSemDriv,A0
	MOVE.32		A0,{A4}+OPB_SEMA	; Indique semaphore a signaler dans le PCB
	MOVE.16		#1,{A4}+OPB_BUF_NB	; Indique un seul buffer ( pour read )
	MOVE.32		#{A4}+OPB_BUF_TAB,A0	; Aligne A0^ sur descriptif buffer
	MOVE.32		#LgRXBuffer,{A0}+OBUF_P_LEN
	MOVE.32		#LgRXBuffer,{A0}+OBUF_L_LEN	; Indique longueur buffer
	MOVE.32		A1,{A0}+OBUF_PTR		; Donne pointeur sur buffer

FIN$:
ERR$:
	POPM.32		A0|A1|d1|d4|d5|a5
	test.16		d7
	RET


;***********************************************
; Initialisation buffers et structure PCB WRITE
;***********************************************

;-------\
; GetPCB >
;=======/
;
; Demande une zone mmoire pour un PCB et l'initialise  0
;
; In	-
; Out	A4.32	^PCB
; Mod
; Variable supplmentaire dans le PCB pour lien des PCB utilisateur

	.APC	PC_RECORD
	.LOC	PB_Len
oLnkPCB:	.blk.32	1		; ^next PCB, user use
nPB_Len	=	APC

	.APC	PC_CODE
	
GetPCB:
	pushm.32	d4|d1
	MOVE.32		#nPB_LEN,D4
	MOVE.16		#MTYPCP,D1
	GESMEM		?GETMEM			; Alloue memoire structure PCB
	push.16		d7
	GESMEM		?CLEARMEM
	pop.16		d7
	popm.32		d4|d1
	ret

;-----------\
; GivBackPCB >
;===========/
;
; Rend la mmoire pour un PCB
;
; In	A4.32	^mmoire PCB  rendre
; Out
; Mod

GivBackPCB:
	pushm.32	d1
	move.16		#mtypcp,d1
	Gesmem		?GivMem
	popm.32		d1
	ret

;---------\
; InitList >
;=========/
;
; Initialise une liste chane
; oPntFirst	^1er lment
; oPntLast	^dernier lment
;
; In	A0.32	^descripteur de la liste
; Out
; Mod

InitList:
	move.32	#0,{a0}+oPntFirst
	move.32	#0,{a0}+oPntLast
	ret

;-----------\
; PutLastPCB >
;===========/
;
; Rajoute un PCB  la fin de la list
;
; In	A0.32	^descr de la list
; Out	A4.32	^PCB
; Mod

PutLastPCB:
	move.32	#0,{a4}+oLnkPCB		; ^link = nil
	test.32	{a0}+oPntLast		; last = ^nil -> 1er lment  mettre
	jump,eq	r8^s1$

; rajoute un lment fin de liste

	push.32	a1
	move.32	{a0}+oPntLast,A1	; ^last courant
	move.32	a4,{a1}+oLnkPCB		; y effectue le lien avec nouveau PCB
	move.32	a4,{a0}+oPntLast	; et le met  la fin de la liste
	pop.32	a1
	jump	f$

; 1er lment de la liste

s1$:
	move.32	a4,{a0}+oPntFirst
	move.32	a4,{a0}+oPntLast
f$:
AFX8	A4
	ret

;------------\
; GetFirstPCB >
;============/
;
; Retire 1er PCB de la list
;
; In	A0.32	^descr de la list
; 	A4.32	^PCB
; Out	D7.16	-1 si list vide
; Mod

GetFirstPCB:
	move.16	#-1,d7
	test.32	{a0}+oPntFirst		; first = ^nil -> plus rien dans la liste
	jump,eq	r8^f$

; prend 1er lment de la liste

	move.32	{a0}+oPntFirst,A4	; ^first PCB -> A4.32
	move.32	{a4}+oLnkPCB,{a0}+oPntFirst	; met le suivant comme 1er
	jump,ne	r8^s1$			; Link ^sur nil si =0
	move.32	#0,{a0}+oPntLast	; c'tait le dernier
s1$:
	clr.16	d7			; pas d'erreur
f$:
	test.16	d7
	ret

;------------\
; GivRxBuffer >
;============/
;
; Rend la mmoire du buffer de rception
;
; In	A4.32	^buffer
; Out
; Mod	-

GivRxBuffer:
	pushm.32	d1
	move.16		#mtypcp,d1
	Gesmem		?GivMem
	popm.32		d1
	ret

	ret

;-----------\
; INIT_TXPCB >
;===========/
;
; Initialise structure PCB emission avec Buffer en trois fragments
;
; in	A6.32	^var
;	A4.32	^PCB
; out	A4.32	^PCB intialise
;	D7.16	erreur
; mod

INIT_TXPCB:
	PUSHM.32	A0|A1

	MOVE.32		{A6}+OTXSemDriv,A0
	MOVE.32		A0,{A4}+OPB_SEMA	; Indique semaphore a signaler dans le PCB
	MOVE.16		#3,{A4}+OPB_BUF_NB	; Indique trois buffers ( pour write )
	MOVE.32		#{A4}+OPB_BUF_TAB,A0	; Aligne A0^ sur descriptif buffer

	MOVE.32		#LgAdrEth,{A0}+OBUF_L_LEN		; Indique longueur adresse dest
	MOVE.32		#R16^TR_ADR,A1
	MOVE.32		A1,{A0}+OBUF_PTR		; Donne pointeur sur adresse
	ADD.32		#BLEN,A0			; Passe descriptif suivant

	MOVE.32		#LgAdrEth,{A0}+OBUF_L_LEN		; Indique longueur adresse src
	MOVE.32		#R16^SRC_ADR,A1
	MOVE.32		A1,{A0}+OBUF_PTR		; Donne pointeur sur adresse
	ADD.32		#BLEN,A0	

	MOVE.32		#LgTXData,{A0}+OBUF_L_LEN		; Indique longueur donnees
	MOVE.32		#R16^TR_DATA,A1
	MOVE.32		A1,{A0}+OBUF_PTR		; Donne pointeur sur donnees

FIN$:
ERR$:
	POPM.32		A0|A1
	test.16		d7
	RET

.endif

.END


 
