	.TITLE	SONIC_TEST.ASM

	.PROC		M68000
	.BASE		10		; base 10 par defaut
	.LAYOUT		HEX		; listing en hexadecimal

	.REF		SMAKY		; reference generale
	.REF		MON
	.REF		NTREL
	.REF		BIOSDRIV
	.REF		BIOS
	.REF		ASYNC

BUS16	=	false		; Pour l'utilisation du SONIC en mode 16 bits (carte 68302)
BUS32	=	true		; Pour l'utilisation du SONIC en mode 32 

; Choix version Carte302/S130
;****************************
Carte302	=	false		; Carte avec 68302 du LTI (BB)
S130		=	true		; Carte pour S130 du LAMI (RB)
 Grafem		=	true		; Assemblage pour carte GRAFEM sur

TestSansSonic	=	false

;**************
; Def APC
;**************

PC_code		=	0
PC_var		=	1
PC_record	=	2

	.APC	PC_code
	.LOC	0
	.APC	PC_var
	.LOC	0
	.APC	PC_record
	.LOC	0

;*****************
;  Def MACROS
;*****************
	.INS		MACROS.ASI

;************
; Constantes
;************

	.if	Carte302
AdSonic		=	16'F02000	; Adresse physique du Sonic
;n'existe plus ! AdReset		=	16'FFFC80	; Adresse du Ha
	.endif
	.if	S130
AdSonic		=	16'1C000000+2**29	; Mode non cacheable (A29=1)
	 .if	Grafem
	 .else
AdWrVect	=	16'1C002000+2**29	; Pour crire le vecteur d'interruption
VectSonic	=	16'C0			; A vrifier!!
	 .endif
AVectSonic	=	16'18+2			; Autovecteur 2
	.endif

AdPhys0		=	16'0606		; Adresse physique Ethernet par defaut, LSB
AdPhys1		=	16'0606		; Adresse physique Ethernet par defaut
AdPhys2		=	16'0303		; Adresse physique Ethernet par defaut, MSB
NbMaxCam	=	16		; Nombre maximum d'adresses multicast
NbMaxTDA	=	10		; Nombre max de TDA
LgMaxEth	=	1518+4		; Longueur maximale d'un paquet Ethernet
					; Plus 4 pour les debordement eventuels du chip Sonic
LgMinEth	=	64		; Longueur minimum d'un bloc Ethernet
NULL		=	0
NbMaxRdBuf	=	100		; Nombre max de descripteurs de ressources reception
LgAdrEth	=	6		; Longueur d'un adresse
EOL		=	1		; End Of List du sonic
TCRConfig	=	0		; Config registre TCR

	.if	BUS16
LgRxBuffer	=	LgMaxEth	; Longueur du buffer de reception. Doit etre LgMaxEth+2
					; en mode 32 bits.
	.endif
	.if	BUS32
LgRxBuffer	=	10'1524		; Longueur du buffer de reception. Doit etre LgMaxEth+2
					; en mode 32 bits.
	.endif


	.start	start

	.ins		Sonic_def.asi


; Variables
;**********

;********************
; Structure Commande
;********************
; Commande sous forme de .16 :  modifier prochainement: c'est fait!! RB 93/08/10
; .asciz	

; Le champ TDA descripteur de packet en transmission est rallong pour contenir 
; des informations annexes utiles au driver


	.APC	PC_record
	.LOC	LgTxpktDescriptor
oTxPntPB:		.blk.32	1	; ^PB fourni en accs Write
oTxPntNextTDA:		.blk.32	1	; ^prochain TDA (idem link mais .32 et adresse connue)
oTxpntPrevTDA:		.blk.32	1	; ^TDA prcdent
oTxpntPrevTDAlink:	.blk.32	1	; ^TDA link prcdent (pour faciliter mise  0 EOL)
oTDAstatus:		.blk.8	1
 bTDAFree = 0
 bTDAInUse = 1
			.blk.8	3	; pour aligner
LgTxpktDescMod	=	APC

;*******************
; Variables driver
;*******************

; Cette zone doit tenir dans un unique bloc de 64k, ce qui limite le choix du nombre max
; de buffers en attente de READ. Cette zone doit de plus etre alignee au debut d'un bloc de 64k

	.APC	PC_record
	.LOC	0

	;; Stats block, returned by STATS command.
		
OS_REVISION:	.BLK.8	1	; Revision number of Driver
OS_VERSION:	.BLK.8	1	; Version number of Driver
OS_DRV_MEM:	.BLK.32	1	; Base Address of Driver variables
OS_TX_INT_C:	.BLK.32	1	; Count of Transmit Interruptions
OS_RX_INT_C:	.BLK.32	1	; Count of Receive Interruptions
OS_TX_FR_C:	.BLK.32	1	; Count of good frames transmitted
OS_TX_ERR:	.BLK.32	1	; Count of transmit errors
OS_TX_COL:	.BLK.32	1	; Count of collisions during transmissions
OS_RX_FR_C:	.BLK.32	1	; Count of good frames receives
OS_TX_BYTE_C:	.BLK.32	1	; Count of bytes transmitted (good frames)
OS_RX_BYTE_C:	.BLK.32	1	; Count of bytes received (good frames)
OS_BAD_CRC:	.BLK.32	1	; Count of receive CRC errors
OS_DEBUG1:	.BLK.32	1	; Miscelaneous counter for debugging purposes
OS_DEBUG2:	.BLK.32	1	; Miscelaneous counter for debugging purposes
OS_STATE:	.BLK.8	1	; State of driver
		.EVEN
oRdCAM:		.blk.16		3*NbMaxCam	; Place pour relire la CAM
STAT_MEM_LEN	=	APC

ODR_ETAT:	.BLK.8		1	; Etat du driver
		.align	4
ODR_TETE:	.BLK.32		1	; Tete de liste READ
ODR_QUEUE:	.BLK.32		1	; Queue de liste READ
ODW_TETE:	.BLK.32		1	; Tete de liste WRITE
ODW_QUEUE:	.BLK.32		1	; Queue de liste WRITE

DRIV_STATE:	.BLK.8		1	; Etat du driver
		.align	4
NBRD_BUF:	.BLK.16		1	; Nombre de buffers en attente lecture ( <NbMaxRdBuf )
ONbCamDesc:	.BLK.16		1	; Nombre de descripteurs de CAM
OAD_SONIC:	.BLK.32		1	; Adresse du SONIC
oSemTimer:	.blk.32		1	; Smaphore Timer Sonic (pour les tests interruptions)
oSemWaitTDAFree:.blk.32		1	; Smaphore d'attente TDA libr
oCntWaitTDAFree:.blk.32		1	; compteur d'attente de TDA libre
oPntTDANextFree:.blk.32		1	; ^prochain TDA libre
oTxPntFirstTDA:	.blk.32		1	; 1er TDA de la liste  transmettre
.if	TestSansSonic
oRegSonic:	.blk.8		16'40*FactSize	; registre fictifs pour Debug
.endif	TestSansSonic

	.align	4		; alignement 32 bits

;**************
; Champs SONIC
;**************
; Descripteurs en mmoire
;------------------------
; RRA:	Receive Ressource Area -> Pointe sur les RBA libres
; RDA:	Receive Descriptor Area
; RBA:	Receive Buffer Area
;
; TDA:	Transmit Descriptor Area
; TBA:	Transmit Buffer Area
;
; CDA:	CAM Descriptor Area: CAM: Content Access Memory
;
; Registres SONIC
;----------------
; UTDA, CTDA:	Current Transmit Descriptor Area pointer
; URDA, CRDA:	Current Receive Descriptor Area pointer
;
; URRA, RSA:	Ressource Start Area
; URRA, RRP:	Ressource Read Pointer
; URRA, RWP:	Ressource Write Pointer
; URRA, REA:	Ressource End Area
;
; URRA, CDP:	CAM Descriptor Pointer
;
;PH
; RB -> .8
; Attention  ne pas modifier l'ordre des variables

ORRAStart:	.BLK.8		LgRXrsrcDescriptor*NbMaxRdBuf	; Zone pour les descripteurs de buffers
oRRAEnd:
ORDAStart:	.BLK.8		LgRXpktDescriptor*NbMaxRdBuf	; Zone pour les descripteurs de paquet
oRDAEnd:
OTDAStart:	.BLK.8		LgTxpktDescMod*NbMaxTDA		; Zone pour stocker NbMaxTDA de taille maximale (16 fragments)
oTDAEnd:
OCAMStart:	.BLK.8		LgCam				; Zone pour stocker la table des CAM
oCAMEnd:

LgVarZone	=	APC	; Attention, doit etre < 64k ...!

	.if	LgVarZone.GT.65536
erreur LgVarZone > 64k
	.endif


	.APC	PC_CODE

; Test des accs Sonic

start:
	move.32		a4,a6
	MOVE.32		#AdSonic,A5		; A5 pointe sur le Sonic
l$:
	Call		InitSonic
	Jump		l$


;----------\
; InitSonic >
;==========/
;
; Initialisation du Sonic
;
; Effectue un Software Reset du Sonic, fixe sa configuration et initialise ses registres
; Tous les acces au Sonic doivent se faire par des MOVE.16 car la ligne A0 n'est pas cablee
;
; In	A5.32	^Sonic
;	A6.32	^variables
; Out
; Mod


InitSonic:
	PUSHM.32	A0|D0|a3	; Sauvegarde les registres

; Effectue un Software Reset du Sonic
; ***********************************

	MOVE.16		#2**bSonicRST,D0	; Met le bit RST a 1
	MOVE.16		D0,{A5}+SonicCR

	MOVE.16		{A5}+SonicDCR,D0	; ** DATA CONFIGURATION REGISTER **
   Clr.32		d0
	TCLR.32		D0:#bSonicSTERM		; Asynchronous Mode
;	TSET.32		D0:#bSonicWC0			; 3 Wait State
;	TSET.32		D0:#bSonicWC1			; 3 Wait State
	TCLR.32		D0:#bSonicWC0		; 0 Wait State
	TCLR.32		D0:#bSonicWC1		; 0 Wait State

	TSET.32		D0:#bSonicDW		; 32 bit Data Width
	TCLR.32		D0:#bSonicBMS		; Empty/fill FIFOs Mode

	TSET.32		D0:#bSonicRFT1		; set receive fifo threshold
	TSET.32		D0:#bSonicRFT0		; to 24 bytes

	TCLR.32		D0:#bSonicTFT1		; set transmit fifo threshold
	TSET.32		D0:#bSonicTFT0		; to 16 bytes

	TCLR.32		D0:#bSonicPO1		; set programmable output 1 to 0
	TSET.32		D0:#bSonicPO0		; set programmable output 0 to 1
	TSET.32		D0:#bSonicExBus		; Mode bus d'extension
	MOVE.16		D0,{A5}+SonicDCR
	MOVE.16		{A5}+SonicDCR,D0	; relit
	

	MOVE.16		{A5}+SonicDCR2,D0	; ** DATA CONFIGURATION REGISTER 2**
	move.16		#2'0000*(2**bSonicEXPO0),d0	; SIZ1, SIZ0, A0 = 0
	MOVE.16		D0,{A5}+SonicDCR2
	MOVE.16		{A5}+SonicDCR2,D0	; ** DATA CONFIGURATION 2 relit

	MOVE.16		#0,D0			; Remet le bit RST a 0
	MOVE.16		D0,{A5}+SonicCR
	MOVE.16		{A5}+SonicCR,D0

; Fixe la configuration du Sonic
; ******************************

	MOVE.16		{A5}+SonicRCR,D0	; ** RECEIVE CONTROL REGISTER **
;	TSET.32		D0:#bSonicERR			; Accept Packets with Errors
	TCLR.32		D0:#bSonicERR		; Don't Accept Packets with Errors
	TCLR.32		D0:#bSonicRNT		; Reject Runt Packets
	TSET.32		D0:#bSonicBRD		; Accept Broadcast Packets
;	TSET.32		D0:#bSonicAMC			; Accept Multicast Packets
	TCLR.32		D0:#bSonicAMC		; Don't Accept Multicast Packets
	TCLR.32		D0:#bSonicPRO		; No Promiscuious Mode
	TCLR.32		D0:#bSonicLB0		; No Loopback
	TCLR.32		D0:#bSonicLB1		; No Loopback
	MOVE.16		D0,{A5}+SonicRCR
	MOVE.16		{A5}+SonicRCR,D0	; Relit RCR

	MOVE.16		{A5}+SonicTCR,D0	; ** TRANSMIT CONTROL REGISTER **
	TCLR.32		D0:#bSonicPINTR		; No Transmit Programmable Interrupt
	TCLR.32		D0:#bSonicPOWC		; Timer begins after the SFD
	TCLR.32		D0:#bSonicCRCI		; Transmit Packet with CRC
	TCLR.32		D0:#bSonicEXDIS		; Excessive Deferral Timer Enable
	MOVE.16		D0,{A5}+SonicTCR
	MOVE.16		{A5}+SonicTCR,d0	; relit TCR

	MOVE.16		{A5}+SonicIMR,D0	; ** INTERRUPT MASK REGISTER **
	TCLR.32		D0:#bSonicBREN		; Bus Retry Occurred Disable
	TCLR.32		D0:#bSonicHBLEN		; Heartbeat Lost Disable
	TCLR.32		D0:#bSonicLCDEN		; Load CAM Done	Disable
	TCLR.32		D0:#bSonicPINTEN	; Programmable Interrupt Disable
	TSET.32		D0:#bSonicPRXEN		; Packet Received Enable
	TSET.32		D0:#bSonicPTXEN		; Packet Transmitted OK Enable
	TSET.32		D0:#bSonicTXEREN	; Transmit Error Enable
	TCLR.32		D0:#bSonicTCEN		; TimerComplete	Disable
	TCLR.32		D0:#bSonicRDEEN		; ReceiveDescriptors Exhausted Disable
	TCLR.32		D0:#bSonicRBEEN		; Receive Buffers Exhausted Disable
	TCLR.32		D0:#bSonicRBAEEN	; Receive Buffer Area Exceeded Disable
	TCLR.32		D0:#bSonicCRCEN		; CRC Tally Counter Warning Disable
	TCLR.32		D0:#bSonicFAEEN		; FAE Tally Counter Warning Disable
	TCLR.32		D0:#bSonicMPEN		; MP Tally Counter Warning Disable
	TCLR.32		D0:#bSonicRFOEN		; Receive FIFO Overrun Disable
	MOVE.16		D0,{A5}+SonicIMR
	MOVE.16		{A5}+SonicIMR,d0	; Relit IMR

; Initialisation des registres qui grent la RRA
; **********************************************

	MOVE.32		A6,D0			; Initialisation du URRA
	SWAP.32		D0
	MOVE.16		D0,{A5}+SonicURRA
	MOVE.16		{A5}+SonicURRA,d0	; Relit URRA

	MOVE.32		#{A6}+ORRAStart,A0	; Initialisation du RSA
	MOVE.16		A0,{A5}+SonicRSA
	MOVE.16		{A5}+SonicRSA,d0	; Relit RSA

	MOVE.16		A0,{A5}+SonicRRP	; Initialisation du RRP
	MOVE.16		{A5}+SonicRRP,d0	; Relit RRP
	MOVE.16		A0,{A5}+SonicRWP	; et du RWP, table descr. vide
	MOVE.16		{A5}+SonicRWP,d0	; Relit RWP

	MOVE.32		#{A6}+ORDAStart,A0	; Initialisation du REA
	MOVE.16		A0,{A5}+SonicREA
	MOVE.16		{A5}+SonicREA,d0	; Relit REA

; Initialise les registres qui gerent la CDA (CAM)
; ******************************************
; Le URRA est initialise lors de l'initialisation de la RRA

;	L'adresse locale est initialise par une commande de haut niveau
	
; Initialisation des registres qui gerent la RDA
; **********************************************

	MOVE.32		A6,D0			; Initialisation du URDA
	SWAP.32		D0
	MOVE.16		D0,{A5}+SonicURDA
	MOVE.16		{A5}+SonicURDA,d0	; Relit URDA

	MOVE.32		#{A6}+ORDAStart,A0	; Initialisation du CRDA
	MOVE.16		A0,{A5}+SonicCRDA
	MOVE.16		{A5}+SonicCRDA,d0	; Relit CRDA


; Initialisation des registres qui gerent la TDA
; **********************************************

	MOVE.32		A6,D0			; Initialisation du UTDA
	SWAP.32		D0
	MOVE.16		D0,{A5}+SonicUTDA
	MOVE.16		{A5}+SonicUTDA,d0	; Relit UTDA

	MOVE.32		#{A6}+OTDAStart,A0	; Initialisation du CTDA
	MOVE.16		A0,{A5}+SonicCTDA
	MOVE.16		{A5}+SonicCTDA,d0	; Relit CTDA

; Initialisation des registres qui gerent la RBA
; **********************************************

	MOVE.16		#1520/2,{A5}+SonicEOBC		; Pour 32 bits
	MOVE.16		{A5}+SonicEOBC,d0		; Relit EOBC

; Initialisation des compteurs de debug  -1
;*******************************************

	move.16		#-1,{a5}+SonicCRCT
	move.16		{a5}+SonicCRCT,d0
	move.16		#-1,{a5}+SonicFAET
	move.16		{a5}+SonicFAET,d0
	move.16		#-1,{a5}+SonicMPT
	move.16		{a5}+SonicMPT,d0

	POPM.32		A0|D0|a3			; Recupere les registres
	RET

	.end

