BOPGENERAL = 19

	.TITLE	FILE.ASD
	.REF	SMAKY
	.REF	BIOSDRIV
	.REF	BIOS
	.PROC	M68000
	.REF	MFMT
	.REF	MON

REVMAJ	= 2
REVMIN	= 1
PRIO	= 13

LGFILE	= 200

	.IDENT	"(C) 1989-1999  Pierre Arnaud et EPSITEC SA"
	.REV	REVMAJ,REVMIN
	.START	-1

;	Pour chaque pilote, on a
;	------------------------

	.LOC	0

ONOM:	.BLK.8	LGFILE			; nom du fichier
OARGS:	.BLK.8	LGARGS			; arguments du fichier
OCANAL:	.BLK.16	1			; canal du fichier
OCOMPT:	.BLK.16	1			; compteur d'utilisation
OWRITE:	.BLK.16	1			; utilis en criture ?
OSEXCL:	.BLK.32	1			; smaphore d'exclusion
OPILOT:	.BLK.8	8			; nom du pilote
OPNUM:	.BLK.16	1			; numro du processus faisant le FORMAT
OFERR:	.BLK.16	1			; erreur du fils
OWAIT:	.BLK.8	1			; si 1 => formatage par processus fils
ONOCRE:	.BLK.8	1			; si 1 => ne pas crer
OMALLE:	.BLK.8	1			; si 1 => c'est une malle
OTWEAKZIP:	.BLK.8	1		; si 1 => c'est un ZIP bidouill
		.EVEN
OSTATUS:	.BLK.8	LGMAM3+lgmfmtrec; buffer pour les statuts du ZIP
		.EVEN
OZIPOFF:	.BLK.32	1		; offset
LGPIL:


;	Dfinition des variables globales
;	---------------------------------

	.LOC	0

OPIL0:	.BLK.8	LGPIL			; premier pilote
OPIL1:	.BLK.8	LGPIL			; second pilote
OPIL2:	.BLK.8	LGPIL			; troisime pilote
OPIL3:	.BLK.8	LGPIL			; quatrime pilote
LGVAR:


;	Driver mmoire de masse utilisant comme support un fichier PsOS
;	---------------------------------------------------------------


	.LOC	0

DEBUT:	.16	0, F0BASE
	.16	1, F1BASE
	.16	2, F2BASE
	.16	3, F3BASE
	.16	2**7

; ------------------------------------------
; 		DRIVER $FILE_0	   No H'6C
; ------------------------------------------

F0ID:	.16	F0OPEN-F0BASE
	.16	F0COMMAND-F0BASE
	.16	F0RSTATUS-F0BASE
	.16	F0READ-F0BASE
	.16	F0WRITE-F0BASE
	.16	F0CLOSE-F0BASE
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	F0RESET-F0BASE
	.16	F0KILL-F0BASE
	.16	-1
	.16	-1
	.16	-1

F0NAME:	.ASCIZE	"FILE_0"
F0NAMF:	.FILL.8	LGDNAM-(F0NAMF-F0NAME),0

	.8	16'6C			; numro
	.8	TYPMM			; type de driver
	.8	REVMAJ,REVMIN		; version
	.8	PRIO,0			; priorit
	.8	0
	.8	2**BDRDOK.OR.2**BDWROK

	.FILL.8	LGDDESC-(APC-F0ID),0
F0BASE:

; ------------------------------------------
; 		DRIVER $FILE_1	   No H'6D
; ------------------------------------------

F1ID:	.16	F1OPEN-F1BASE
	.16	F1COMMAND-F1BASE
	.16	F1RSTATUS-F1BASE
	.16	F1READ-F1BASE
	.16	F1WRITE-F1BASE
	.16	F1CLOSE-F1BASE
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	F1RESET-F1BASE
	.16	F1KILL-F1BASE
	.16	-1
	.16	-1
	.16	-1

F1NAME:	.ASCIZE	"FILE_1"
F1NAMF:	.FILL.8	LGDNAM-(F1NAMF-F1NAME),0

	.8	16'6D			; numro
	.8	TYPMM			; type de driver
	.8	REVMAJ,REVMIN		; version
	.8	PRIO,0			; priorit
	.8	0
	.8	2**BDRDOK.OR.2**BDWROK

	.FILL.8	LGDDESC-(APC-F1ID),0
F1BASE:


; ------------------------------------------
; 		DRIVER $FILE_2	   No H'6E
; ------------------------------------------

F2ID:	.16	F2OPEN-F2BASE
	.16	F2COMMAND-F2BASE
	.16	F2RSTATUS-F2BASE
	.16	F2READ-F2BASE
	.16	F2WRITE-F2BASE
	.16	F2CLOSE-F2BASE
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	F2RESET-F2BASE
	.16	F2KILL-F2BASE
	.16	-1
	.16	-1
	.16	-1

F2NAME:	.ASCIZE	"FILE_2"
F2NAMF:	.FILL.8	LGDNAM-(F2NAMF-F2NAME),0

	.8	16'6E			; numro
	.8	TYPMM			; type de driver
	.8	REVMAJ,REVMIN		; version
	.8	PRIO,0			; priorit
	.8	0
	.8	2**BDRDOK.OR.2**BDWROK

	.FILL.8	LGDDESC-(APC-F2ID),0
F2BASE:

; ------------------------------------------
; 		DRIVER $FILE_3	   No H'6F
; ------------------------------------------

F3ID:	.16	F3OPEN-F3BASE
	.16	F3COMMAND-F3BASE
	.16	F3RSTATUS-F3BASE
	.16	F3READ-F3BASE
	.16	F3WRITE-F3BASE
	.16	F3CLOSE-F3BASE
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	F3RESET-F3BASE
	.16	F3KILL-F3BASE
	.16	-1
	.16	-1
	.16	-1

F3NAME:	.ASCIZE	"FILE_3"
F3NAMF:	.FILL.8	LGDNAM-(F3NAMF-F3NAME),0

	.8	16'6F			; numro
	.8	TYPMM			; type de driver
	.8	REVMAJ,REVMIN		; version
	.8	PRIO,0			; priorit
	.8	0
	.8	2**BDRDOK.OR.2**BDWROK

	.FILL.8	LGDDESC-(APC-F3ID),0
F3BASE:


; --------------------------------------------------------
;		ROUTINES BAS NIVEAU DU DRIVER
; --------------------------------------------------------

; On peut modifier D0/D1 et A0/A1 comme registres. D7.16 rend l'erreur



;--------\\
;  RESET  >
;========/

; Installe le driver

; in	A2.32	^paramtres
; out	D7.16
; mod	...

F0RESET:
	MOVE.16	#OPIL0,D1
	JUMP	R8^RESET

F1RESET:
	MOVE.16	#OPIL1,D1
	JUMP	R8^RESET

F2RESET:
	MOVE.16	#OPIL2,D1
	JUMP	R8^RESET

F3RESET:
	MOVE.16	#OPIL3,D1

RESET:	PUSHM.32 D0..D6|A0..A5

	MOVE.32	#R16^DEBUT,A4
	MOVE.32	#LGVAR,D4
	FOS	?GETcomMEM
	JUMP,NE	ERR$

	MOVE.32	#1,D4
	NTREL	?CRESEM			; A5 <-- smaphore d'exclusion
	JUMP,NE	ERR$

	MOVE.32	#{A4}+A16^{D1},A6	; ^mmoire du pilote
	MOVE.32	A5,{A6}+OSEXCL		; ^smaphore d'exclusion
	MOVE.32	#{A6}+ONOM,A4		; ^nom de fichier
	MOVE.32	#"$"*16'1000000+"F"*16'10000+"I"*16'100+"L",{A6}+OPILOT
	MOVE.16	#"E"*16'100+"_",{A6}+OPILOT+4
	MOVE.16	D1,D4
	DIV.16	#LGPIL,D4
	ADD.8	#"0",D4
	SWAP.16	D4
	MOVE.16	D4,{A6}+OPILOT+6
	CLR.8	{A6}+OWAIT
	CLR.8	{A6}+ONOCRE
	CLR.8	{A6}+OMALLE
	CLR.16	{A6}+OFERR
	CLR.8	{A6}+OTWEAKZIP

	MOVE.32	#16'10,{A6}+OZIPOFF

	MOVE.32	A2,A3

	COMP.8	#"!",{A2}
	JUMP,NE	R8^WHAT$

	SET.8	{A6}+OTWEAKZIP
	MOVE.32	#16'40,{A6}+OZIPOFF
	INC.32	A2
	JUMP	R8^OKWHAT$

WHAT$:	FOS	?WHAT			; syntaxe correcte ?
	JUMP,NE	ERR$			; non => erreur

OKWHAT$:
	MOVE.16	#LGFILE-1,D1
	COMP.8	#"#",{A2}
	JUMP,EQ	COPY$
	COMP.8	#"$",{A2}
	JUMP,EQ	COPY$
	COMP.8	#"@",{A2}
	JUMP,EQ	COPY$

	FOS	?GDIR

COP1$:	MOVE.8	{A3+},{A4+}		; copie rpertoire
	JUMP,EQ	R8^NXT$
	DJ.16,NMO D1,COP1$
	JUMP	R8^TOLO$

NXT$:	DEC.32	A4

COPY$:	MOVE.8	{A2+},D3
	JUMP,EQ	R8^COPYOK$
	COMP.8	#SPACE,D3
	JUMP,EQ	R8^COPYOK$
	COMP.8	#TAB,D3
	JUMP,EQ	R8^COPYOK$
	COMP.8	#CR,D3
	JUMP,EQ	R8^COPYOK$
	COMP.8	#"/",D3
	JUMP,EQ	R8^SLASH$

COx$:	MOVE.8	D3,{A4+}
	DJ.16,NMO D1,COPY$		; copie au maximum LGFILE caractres
TOLO$:	MOVE.16	#ERTOLO,D7		; nom trop long
	JUMP	ERR$

SLASH$:	COMP.8	#"X",{A2}		; ne pas crer ?
	JUMP,EQ	R8^NOCRE$
	COMP.8	#"x",{A2}		; ne pas crer ?
	JUMP,EQ	R8^NOCRE$
	COMP.8	#"M",{A2}		; "Malle" ?
	JUMP,EQ	R8^MALLE$

; Ok, pas un "/X", on copie quand-mme le slash (peut tre un /0../3)

	JUMP	COx$


NOCRE$:	SET.8	{A6}+ONOCRE
	INC.32	A2			; saute le "X" aussi..
	JUMP	COPY$			; ..et copie une suite ventuelle

MALLE$:	SET.8	{A6}+OMALLE
	INC.32	A2
	JUMP	COPY$

COPYOK$:
	CLR.8	{A4+}			; ok !
	CLR.16	D7			; tout s'est bien pass
	CLR.16	{A6}+OCANAL		; canal aucun
	CLR.16	{A6}+OCOMPT		; compteur  zro
	CLR.16	{A6}+OWRITE		; pas d'criture faite

; Gre l'unit physique...

	TEST.8	{A6}+OTWEAKZIP		; unit physique ?
	JUMP,T	OK$			; oui => pas de vrification

	MOVE.32	#{A6}+ONOM,A3
	MOVE.32	#{A6}+OARGS,A4		; buffer pour attributs
	FOS	?ARGS			; cherche les attributs
	JUMP,EQ	OK$			; fichier existe => ok !

	COMP.16	#ERFDNE,D7
	JUMP,NE	ERR$

	TEST.8	{A6}+ONOCRE		; on ne veut pas crer ?
	JUMP,T	ERR$			; oui => erreur si pas de fichier..

; Le fichier n'existe pas. On va se dpcher de le crer et de formater le disque

	SET.8	{A6}+OWAIT		; met les accs au pilote en attente

	MOVE.32	#1000,D5		; D5 <-- pile
	MOVE.32	#9+2**BTPROG+2**BTNCHD,D4 ; D4 <-- pas notre fils, celui de FIRST
	MOVE.32	#R16^NMFILS,A3
	MOVE.32	#R16^CODFILS,A5
	NTREL	?CRETASK		; initialise le fils qui va s'occuper de l'ENTER + formatage

	MOVE.16	D4,{A6}+OPNUM		; numro de proc. du fils

	MOVE.16	#5,D4
	NTREL	?DELMS

OK$:	CLR.16	D7

ERR$:	POPM.32 D0..D6|A0..A5
	TEST.16	D7
	RET



;-------\\
;  KILL  >
;=======/

; D-installe le driver, ferme le fichier utilis.

; in	-
; out	D7.16
; mod	...

F0KILL:
F1KILL:
F2KILL:
F3KILL:
	CLR.16	D7			; on ne fait rien du tout !
	RET



;--------\\
;  WRITE  >
;========/

; Ecrit un certain nombre de blocs

; in	D4.32	premier bloc
;	D5.32	nombre de blocs
;	A4.32	^buffer
; out	D7.16
; mod	...

F0WRITE:
F1WRITE:
F2WRITE:
F3WRITE:
WRITE:	PUSHM.32 D3|D4|D6

	CALL	WAIT
	MOVE.16	{A6}+OFERR,D7
	JUMP,NE	ERR$

	MOVE.16	{A6}+OCANAL,D6			; canal du fichier

	CALL	STARTLOCK
	JUMP,NE	ERR$

	ADD.32	{A6}+OZIPOFF,D4
	MOVE.32	D4,D3
	SL.32	#8,D4				; D4 <-- poids faible
	RL.32	#8,D3				; D3 <-- poids fort
	FOS	?SPOS
	JUMP,NE	R8^ER$

	MOVE.32	D5,D4
	SL.32	#8,D4
	FOS	?WRBYTE
	JUMP,NE	R8^ER$

	CALL	ENDLOCK

	SET.8	{A6}+OWRITE			; on a crit qqch !
	JUMP	R8^ERR$

ER$:	CALL	ENDLOCK

	COMP.16	#EROUTF,D7
	JUMP,EQ	R8^OUTF$
	COMP.16	#ERATTR,D7
	JUMP,EQ	R8^READ$
	COMP.16	#ERATTW,D7
	JUMP,EQ	R8^WRITE$

	JUMP	R8^ERR$

OUTF$:	MOVE.16	#ERMOUT,D7			; si hors du fichier, alors hors de MM...
	JUMP	R8^ERR$
READ$:	MOVE.16	#ERMNORD,D7			; si lecture imp., alors lecture interdite
	JUMP	R8^ERR$
WRITE$:	MOVE.16	#ERMWPR,D7			; si write imp., alors protg en criture
;	JUMP	R8^ERR$

ERR$:	POPM.32 D3|D4|D6
	TEST.16	D7
	RET



;-------\\
;  READ  >
;=======/

; Lit un certain nombre de blocs

; in	D4.32	premier bloc
;	D5.32	nombre de blocs
;	A4.32	^buffer
; out	D7.16
; mod	...


F0READ:
F1READ:
F2READ:
F3READ:
READ:
	PUSHM.32 D3|D4|D6

	CALL	WAIT

	MOVE.16	{A6}+OFERR,D7
	JUMP,NE	ERR$

	MOVE.16	{A6}+OCANAL,D6			; canal du fichier

	CALL	STARTLOCK
	JUMP,NE	ERR$

	ADD.32	{A6}+OZIPOFF,D4
	MOVE.32	D4,D3
	SL.32	#8,D4				; D4 <-- poids faible
	RL.32	#8,D3				; D3 <-- poids fort
	FOS	?SPOS
	JUMP,NE	ER$

	MOVE.32	D5,D4
	SL.32	#8,D4
	FOS	?RDBYTE
	JUMP,NE	ER$

	CALL	ENDLOCK
	JUMP	R8^ERR$

ER$:	CALL	ENDLOCK

	COMP.16	#EROUTF,D7
	JUMP,EQ	R8^OUTF$
	COMP.16	#ERATTR,D7
	JUMP,EQ	R8^READ$
	COMP.16	#ERATTW,D7
	JUMP,EQ	R8^WRITE$

	JUMP	R8^ERR$

OUTF$:	MOVE.16	#ERMOUT,D7			; si hors du fichier, alors hors de MM...
	JUMP	R8^ERR$
READ$:	MOVE.16	#ERMNORD,D7			; si lecture imp., alors hors de lecture interdite
	JUMP	R8^ERR$
WRITE$:	MOVE.16	#ERMWPR,D7			; si write imp., alors protg en criture
;	JUMP	R8^ERR$


ERR$:	POPM.32 D3|D4|D6
	TEST.16	D7
	RET





;----------\\
;  COMMAND  >
;==========/

; Commande au pilote $FILE :

; SIZ[taille.16] -> agrandit au nombre de blocs voulu (SIze)
; REL		 -> fait un release du fichier utilis (faire ensuite RELEASE/ENTER -> rcup)

; in	A4.32	^commandes
; out	D7.16
; mod	...

F0COMMAND:
F1COMMAND:
F2COMMAND:
F3COMMAND:
COMMAND:
	PUSHM.32 D0..D6|A0..A5

	CALL	WAIT

	MOVE.16	{A6}+OCANAL,D6			; canal du fichier

	MOVE.8	{A4+},D3
	CALL	MINMAJ
	COMP.8	#"S",D3
	JUMP,EQ	OKSIZ$				; SIZ[taille.16] ?
	COMP.8	#"R",D3
	JUMP,EQ	OKREC$				; REL => recup aura lieu sur le disque
	COMP.8	#"M",D3
	JUMP,EQ	OKMOD$
	COMP.8	#"F",D3				; F => formate "physiquement" le mdia
	JUMP,EQ	OKFORMAT$

ER$:	MOVE.16	#ERILLO,D7			; commande incorrecte
	JUMP	ERR$

OKFORMAT$:
	MOVE.32	#MTYPCP,D1
	MOVE.32	#1024,D4
	GESMEM	?GETMEM
	JUMP,NE	ERR$
	GESMEM	?CLEARMEM

	CLR.32	D3
	CLR.32	D4
	FOS	?SPOS

	MOVE.32	#1024,D4
	FOS	?WRBYTE				; blocs 0..3
	FOS	?WRBYTE				; blocs 4..7
	FOS	?WRBYTE				; blocs 8..11
	FOS	?WRBYTE				; blocs 12..15
	FOS	?WRBYTE				; blocs 16..19

	GESMEM	?GIVMEM
	JUMP	ERR$

OKMOD$:	COMP.8	#"a",{A4}+0
	JUMP,NE	R8^ISMOD$

	COMP.8	#"-",{A4}+1
	JUMP,NE	ER$

	MOVE.8	{A4}+2,D3
	MOVE.32	#50000*4,D4			; malle de 50 MB
	SUB.8	#"0",D3
	JUMP,EQ	BLOC$
	SL.32	D4				; malle de 100 MB
	DEC.8	D3
	JUMP,EQ	BLOC$
	ADD.32	#50000*4,D4			; malle de 150 MB
	DEC.8	D3
	JUMP,EQ	BLOC$
	ADD.32	#50000*4,D4			; malle de 200 MB
	DEC.8	D3
	JUMP,EQ	BLOC$

	JUMP	ER$

ISMOD$:	MOVE.8	{A4+},D3
	CALL	MINMAJ
	COMP.8	#"O",D3
	JUMP,NE	ER$

	MOVE.8	{A4+},D3
	CALL	MINMAJ
	COMP.8	#"D",D3
	JUMP,NE	ER$

	MOVE.8	{A4+},D3
	MOVE.32	#2880,D4

	SUB.8	#"0",D3
	JUMP,EQ	BLOC$

	SL.32	D4
	DEC.8	D3
	JUMP,EQ	BLOC$

	SL.32	D4
	DEC.8	D3
	JUMP,EQ	BLOC$

	MOVE.32	#3200*4,D4
	DEC.8	D3
	JUMP,EQ	BLOC$

	JUMP	ER$


OKREC$:	MOVE.8	{A4+},D3
	CALL	MINMAJ
	COMP.8	#"E",D3
	JUMP,NE	ER$

	MOVE.8	{A4+},D3
	CALL	MINMAJ
	COMP.8	#"L",D3
	JUMP,NE	ER$

	FOS	?CLOSE
	JUMP	ERR$

OKSIZ$:	MOVE.8	{A4+},D3
	CALL	MINMAJ
	COMP.8	#"I",D3
	JUMP,NE	ER$

	MOVE.8	{A4+},D3
	CALL	MINMAJ
	COMP.8	#"Z",D3
	JUMP,NE	ER$

	CLR.32	D4
	MOVE.8	{A4+},D4
	SL.16	#8,D4
	MOVE.8	{A4+},D4

BLOC$:	SL.32	#8,D4				; pour atteindre nombre d'octets
	CLR.32	D3				; taille  atteindre
	FOS	?SPOSPLUS			; agrandit si ncessaire
	JUMP,NE	R8^ERR$

	FOS	?TRUNC				; tronque le reste

ERR$:	POPM.32	D0..D6|A0..A5
	TEST.16	D7
	RET

MINMAJ:	COMP.8	#96,D3
	JUMP,LT	R8^OK$
	SUB.8	#32,D3				; transforme un "a" en un "A"
OK$:	RET



;----------\\
;  RSTATUS  >
;==========/

; Rend le status du driver

; in	D4.32	taille du buffer
;	A4.32	^buffer
; out	D7.16
; mod	...

F0RSTATUS:
F1RSTATUS:
F2RSTATUS:
F3RSTATUS:
RSTATUS:
	PUSHM.32 D0..D6|A0..A5

	CALL	WAIT

	MOVE.32	{A6}+OCANAL,D6
	MOVE.32	D4,D0

	TEST.8	{A6}+OTWEAKZIP
	JUMP,F	R8^FLO$

	MOVE.32	#{A6}+OSTATUS,A3
	GESMEM	?COPYMEM

	MOVE.16	#1,{A4}+oMNBFmtRec
	JUMP	END$

FLO$:	MOVE.8	#MTFLO,{A4}+OMTYPE	; type mmoire de masse (floppy)
	
	PUSH.32 A4
	MOVE.32	#{A6}+ONOM,A3
	MOVE.32	#{A6}+OARGS,A4
	FOS	?ARGS
	MOVE.32	{A4}+OBALGF,D4
	POP.32	A4

	SR.32	#8,D4
	SUB.32	#16'10,D4

	MOVE.32	D4,{A4}+OMNBLK		; nombre de blocs
	CLR.32	{A4}+OMRBLK		; bloc le plus rapide

	COMP.32	#LGMAM3,D0
	JUMP,LT	END$

	ADD.32	#16'10,D4
	MOVE.32	D4,{A4}+OMTBLK		; nombre total de blocs
	CLR.8	{A4}+OMTTYP		; pas un WINCH, pas de type de WINCH !
	MOVE.16	#4,{A4}+oMNBFmtRec	; 3 records pour le moment

	SUB.32	#LGMAM3,D0
	JUMP,LE	END$

	MOVE.32	#{A4}+LGMAM3,A4
	MOVE.32	D4,D3

	MOVE.32	D0,D4
	MOVE.32	#R16^TABLE0$,A3
;	MOVE.32	A4,A4
	GESMEM	?COPYMEM

	COMP.16	#2880,D3
	JUMP,EQ	R8^MOD0$
	COMP.16	#2880*2,D3
	JUMP,EQ	R8^MOD1$
	COMP.16	#2880*4,D3
	JUMP,EQ	R8^MOD2$
	COMP.16	#12800,D3
	JUMP,EQ	R8^MOD3$

	JUMP	END$

MOD0$:	MOVE.8	#2**BitMFmtDiskIn+2**BitMFmtCurMode,{A4}+LgMFmtRec*0+oMFmtFlag
	JUMP	END$

MOD1$:	MOVE.8	#2**BitMFmtDiskIn+2**BitMFmtCurMode,{A4}+LgMFmtRec*1+oMFmtFlag
	JUMP	END$

MOD2$:	MOVE.8	#2**BitMFmtDiskIn+2**BitMFmtCurMode,{A4}+LgMFmtRec*2+oMFmtFlag
	JUMP	END$

MOD3$:	MOVE.8	#2**BitMFmtDiskIn+2**BitMFmtCurMode,{A4}+LgMFmtRec*3+oMFmtFlag

END$:	POPM.32	D0..D6|A0..A5
	TEST.16	D7
	RET


TABLE0$:
	.8	0
	.8	FmtPSOS				; format PSOS
	.16	2				; nb faces
	.16	2				; nb cylindres
	.16	720/2				; nb sect./piste
	.16	256*2				; nb bytes/sect.
	.ASCII	"MOD0"
	.32	0
	.FILL.8	14,0

TABLE1$:
	.8	0
	.8	FmtPSOS				; format PSOS
	.16	2				; nb faces
	.16	2				; nb cylindres
	.16	1440/2				; nb sect./piste
	.16	256*2				; nb bytes/sect.
	.ASCII	"MOD1"
	.32	0
	.FILL.8	14,0

TABLE2$:
	.8	0
	.8	FmtPSOS				; format PSOS
	.16	2				; nb faces
	.16	2				; nb cylindres
	.16	2880/2				; nb sect./piste
	.16	256*2				; nb bytes/sect.
	.ASCII	"MOD2"
	.32	0
	.FILL.8	14,0

TABLE3$:
	.8	0
	.8	FmtPSOS				; format PSOS
	.16	2				; nb faces
	.16	2				; nb cylindres
	.16	3200/2				; nb sect./piste
	.16	256*2				; nb bytes/sect.
	.ASCII	"MOD3"
	.32	0
	.FILL.8	14,0



;-------\\
;  OPEN  >
;=======/

; On ouvre une unit !

F0OPEN:
F1OPEN:
F2OPEN:
F3OPEN:
XOPEN:	PUSHM.32 D3|D4|D5|D6|A3|A4|A6

	CALL	WAIT

	TEST.16	{A6}+OCOMPT			; dj en utilisation ?
	JUMP,EQ	R8^BEGIN$			; non => ouvre

	INC.16	{A6}+OCOMPT
	MOVE.16	{A6}+OCANAL,D6
	CLR.16	D7
	JUMP	ERR$				; et termine avec l'ancien canal

; On n'a pas encore ouvert le fichier, alors on va essayer.

BEGIN$:	MOVE.32	#{A6}+ONOM,A3
	TEST.8	{A6}+OTWEAKZIP
	JUMP,T	ZIP$

REDO$:	MOVE.32	#{A6}+OARGS,A4			; buffer pour attributs
	FOS	?ARGS				; cherche les attributs
	JUMP,EQ	OK$
	COMP.16	#ERFDNE,D7
	JUMP,NE	ERR$

	NTREL	?GTPNUM
	COMP.16	{A6}+OPNUM,D4			; est-ce le processus de formatage ?
	JUMP,EQ	R8^OPEN$			; oui => ouvre & cre le fichier

	MOVE.16	#ERFDNE,D7			; non => signale une erreur !
	JUMP	ERR$

; Le fichier n'existe pas. Il faut donc le crer et l'ouvrir en criture et en lecture
; exclusifs.

OPEN$:	MOVE.32	#2**BOPRD+2**BOPWR+2**BOPEXWR+2**BOPEXTEND+2**BOPGENERAL+2**BOPCREATE+2**BOPPRE,D3
	MOVE.32	#737280,D5
	FOS	?ARGSOPEN			; cre le fichier en question
	JUMP,NE	ERR$

	JUMP	MEMO$

OK$:	TEST.8	{A4}+OBAOPE			; dj ouvert ?
	JUMP,NE	R8^WRPRO$			; oui => ouverture en WR-PRO

	MOVE.32	#2**BOPRD+2**BOPWR+2**BOPEXWR+2**BOPEXTEND+2**BOPGENERAL,D3
	FOS	?ARGSOPEN
	JUMP,EQ	MEMO$
	COMP.16	#ERATTW,D7
	JUMP,EQ	R8^WRPRO$			; protg  l'criture
	COMP.16	#ERATTE,D7
	JUMP,EQ	R8^WRPRO$			; ouverture exclusive impossible
	COMP.16	#ERMWPR,D7
	JUMP,EQ	R8^WRPRO$			; criture sur disque interdite
	COMP.16	#ERFUSE,D7
;	JUMP,EQ	R8^WRPRO$			; ouverture exclusive pas possible (dj ouvert)

	JUMP,NE	ERR$				; erreur autre que "protg  l'criture"

WRPRO$:	MOVE.32	#2**BOPRD+2**BOPEXTEND+2**BOPGENERAL,D3
	FOS	?ARGSOPEN
	JUMP,NE	ERR$				; ok pour l'ouverture

	JUMP	R8^MEMO$

ZIP$:	MOVE.32	#2**BOPRSTATUS+2**BOPMMUNIT+2**BOPEXTEND,D3
	FOS	?ARGSOPEN
	JUMP,NE	R8^ERR$

	PUSHM.32 D4|A3|A4
	MOVE.32	#{A6}+OSTATUS,A4
	MOVE.32	#LGMAM3+lgmfmtrec,D4
	FOS	?RSTATUS			; lit le statut du driver sous-jacent
	FOS	?CLOSE

	MOVE.32	{A4}+OMNBLK,D4
	SUB.32	{A6}+OZIPOFF,D4
	MOVE.32	D4,{A4}+OMNBLK

	MOVE.32	{A4}+OMTBLK,D4
	SUB.32	{A6}+OZIPOFF,D4
	MOVE.32	D4,{A4}+OMTBLK

	POPM.32	D4|A3|A4

	MOVE.32	#20,D4
	NTREL	?DELMS

	MOVE.32	#2**BOPMMUNIT+2**BOPEXTEND+2**BOPGENERAL+2**BOPRD+2**BOPWR,D3
	FOS	?ARGSOPEN
	JUMP,NE	R8^ERR$

MEMO$:	MOVE.16	D6,{A6}+OCANAL			; mmorise le canal
	INC.16	{A6}+OCOMPT			; incrmente le nb d'utilisations
	CLR.16	D7

ERR$:	POPM.32	D3|D4|D5|D6|A3|A4|A6
	TEST.16	D7
	RET



;--------\\
;  CLOSE  >
;========/

; On referme l'unit (et le fichier .DI)

F0CLOSE:
F1CLOSE:
F2CLOSE:
F3CLOSE:
XCLOSE:
	PUSH.32 D6

	CALL	WAIT

	DEC.16	{A6}+OCOMPT			; dcrmente le nb de use..
	JUMP,GT	R8^ERR$				; ok !
	MOVE.16	{A6}+OCANAL,D6
	TEST.8	{A6}+OWRITE			; modifi ?
	JUMP,EQ	R8^CLO$				; non => ferme normalement

	PUSHM.32 D3|D4
	MOVE.32	#-1,D3
	MOVE.32	#-1,D4
	FOS	?CLOMDC
	POPM.32	D3|D4
	JUMP	R8^OK$

CLO$:	FOS	?CLOSE				; ferme le fichier ouvert au-paravant

OK$:	CLR.16	{A6}+OCANAL
	CLR.16	{A6}+OCOMPT

ERR$:	POP.32	D6
	CLR.16	D7
	RET



NMMOD0:	.ASCIZ	"MOD0"
	.ASCIZ	"Ma-0"
NMMOD1:	.ASCIZ	"MOD1"
	.ASCIZ	"Ma-1"
NMMOD2:	.ASCIZ	"MOD2"
	.ASCIZ	"Ma-2"
NMMOD3:	.ASCIZ	"MOD3"
	.ASCIZ	"Ma-3"

NMCMDF:	.ASCIZ	"F"
NMFILS:	.ASCIZ	"FFORMAT"
	.EVEN

; Code propre au fils. Il s'occupe de formater le disque .DI en appelant
; le pilote lui-mme.

CODFILS:
	CLR.32	D4
	FOS	?CREDT

WAIT$:	MOVE.32	#10,D4
	NTREL	?DELMS
	TEST.16	{A6}+OPNUM			; attend que le pre soit prt  nous accepter
	JUMP,EQ	WAIT$

	NTREL	?DELMS

	MOVE.32	#-1,D4				; time-out pour accs au disque (bug SCSI !)
	NTREL	?SETTIM

	MOVE.32	#{A6}+OPILOT,A3
	MOVE.32	#2**BOPMMUNIT+2**BOPEXTEND+2**BOPRSTATUS,D3
	FOS	?ARGSOPEN

	PUSH.32	A3
	MOVE.32	#{A6}+ONOM,A3
	MOVE.32	#R16^NMMOD0,A4

X$:	MOVE.8	{A3+},D3
	JUMP,EQ	R8^CMD$
	COMP.8	#"/",D3
	JUMP,NE	X$

	MOVE.8	{A3+},D3
	SUB.8	#"0",D3				; Mode 720 K ?
	JUMP,EQ	R8^CMD$

	MOVE.32	#R16^NMMOD1,A4
	DEC.8	D3				; Mode 1440 K ?
	JUMP,EQ	R8^CMD$

	MOVE.32	#R16^NMMOD2,A4
	DEC.8	D3				; Mode 2880 K ?
	JUMP,EQ	R8^CMD$

	MOVE.32	#R16^NMMOD3,A4
	DEC.8	D3				; Mode 3200 K ?
	JUMP,EQ	R8^CMD$

	MOVE.32	#R16^NMMOD0,A4

CMD$:	POP.32	A3
	TEST.8	{A6}+OMALLE			; est-ce une malle ?
	JUMP,F	R8^OKCMD$

	ADD.A16	#4+1,A4				; oui => utilise la bonne commande

OKCMD$:	FOS	?COMMAND
	JUMP,NE	CLOFAT$

	MOVE.32	#R16^NMCMDF,A4
	FOS	?COMMAND
	FOS	?CLOSE

	MOVE.32	#30,D4
	MOVE.32	#2**BFRLIST,D3
	FOS	?nFORMAT

	MOVE.32	#2**BeAUTOM,D3
	FOS	?nENTER				; vite que START ne croie que le pilote s'ouvre

	SUB.A16	#24,A7
	MOVE.32	{A6}+OPILOT,{A7}+0		; '$FIL'
	MOVE.32	{A6}+OPILOT+4,{A7}+4		; 'E_n<0>'
	MOVE.8	#":",{A7}+7			; --> '$FILE_n:'
	MOVE.32	#"D"*16'1000000+"O"*16'10000+"S"*16'100+"S",{A7}+8
	MOVE.32	#"I"*16'1000000+"E"*16'10000+"R"*16'100+":",{A7}+12
	CLR.8	{A7}+16

	MOVE.32	#1,D3
	MOVE.32	A7,A3
	FOS	?CDIR
	ADD.A16	#24,A7

	MOVE.32	#{A6}+OPILOT,A3
	MOVE.32	#2**BeAUTOM,D3
	FOS	?nRELEASE

END$:	CLR.8	{A6}+OWAIT
	FOS	?KILDT
	NTREL	?ABORT

CLOFAT$:
	CLR.8	{A6}+OWAIT
	MOVE.16	D7,{A6}+OFERR
	FOS	?CLOSE
	FOS	?KILDT
	NTREL	?ABORT


;-------\\
;  WAIT  >
;=======/

; Attend que le pilote soit initialis. On ne passe pas par un smaphore
; et on n'attend pas si c'est le processus de formatage qui effectue ces
; oprations.

; in	A6.32	^var. du pilote
; out	-
; mod	-

WAIT:
	PUSHM.32 D4|D7

	TEST.8	{A6}+OWAIT
	JUMP,EQ	ERR$

	NTREL	?GTPNUM
	COMP.16	{A6}+OPNUM,D4
	JUMP,EQ	ERR$

WAIT$:	TEST.8	{A6}+OWAIT
	JUMP,EQ	ERR$

	MOVE.32	#25,D4
	NTREL	?DELMS
	JUMP	WAIT$

ERR$:	POPM.32	D4|D7
	RET


;------------\\
;  STARTLOCK  >
;============/

; Dbut de l'exclusion pour faire un SPOS + (READ/WRITE)

; in	A6.32	^variables
; out	D7.16	erreur (time-out)
; mod	D7.16

STARTLOCK:
	PUSH.32 A5

	MOVE.32	{A6}+OSEXCL,A5
	NTREL	?LOCK

	POP.32	A5
	TEST.16	D7
	RET


;----------\\
;  ENDLOCK  >
;==========/

; Fin de l'exclusion. Teste D7.16 comme pass en entre.

; in	D7.16	erreur
;	A6.32	^variables
; out	-	(flags mis  jour selon D7.16 in)
; mod	-

ENDLOCK:
	PUSHM.32 D7|A5

	MOVE.32	{A6}+OSEXCL,A5
	NTREL	?UNLOCK

ERR$:	POPM.32	D7|A5
	TEST.16	D7
	RET


	.END


