
	.TITLE  FLOTEST.ASM

	.PROC	M68000

	.BASE	10'10

	.LAYOUT	HEX

	.START	START
	.IDENT	"Copyright (C) 1992  Daniel MARMIER et EPSITEC-system SA"

REVMAJ		=	0
REVMIN		=	1

SM8		=	FALSE
SM100		=	FALSE
SM130		=	TRUE

MUBUS		=	SM8.OR.SM100;.or.true


ImpliedSeek	=	false		; seek automatique par commandes de transfert

;---------------------------------------------------------------------------------------------------

; On peut mettre le mode qui suit si tous les drives ont le signal DISKCHANGE sur la ligne 34.
; Cela signifie qu'on ne peut pas connecter les anciens TEC, mais seulement des drives CHINON
; modifis : jumper wire en R-D 6 ou short plug en DC.
; Si on le met, a permet de dtecter l'absence/le changement de disque trs rapidement.
; De plus a vite une gestion pnible et incertaine de ce maudit signal RDY, totalement dpass
; et de plus compltement ignor par le 82077.

DCinIF34	=	FALSE		; toujours DISKCHANGE dans I/F#34

;---------------------------------------------------------------------------------------------------

; ATTENTION : La longueur du buffer de formatage dpend directement du nombre de secteurs/piste.
; Il ne faut pas oublier de mettre  jour NBMAXSEC lors d'adjonctions de nouveaux formats.

NBMAXSEC	=	18		; nb de secteurs/piste maximum interformats

;---------------------------------------------------------------------------------------------------

; Fichiers de rfrence
; ---------------------

	.REF	SMAKY
	.REF	I82077			; dfinitions du contrleur floppy Intel 82077
	.REF	BIOS
	.REF	BIOSDRIV
	.REF	MON

	.IF	SM8
	.REF	SM8HARD			; rferences hard pour Smaky 8
	.ENDIF
	.IF	SM100
	.REF	SM100HARD		; rfrences hard pour Smaky 100
	.ENDIF
	.IF	SM130
	.REF	SM130HARD
	.REF	SHIDRIV130
	.ENDIF


;---------------------------------------------------------------------------------------------------

PCCODE		=	1
PCDEF		=	2

addr0:
	.INS	FLOREF.ASI		; dfinitions internes

	.INS	FLOFOS.ASI		; rfrences pour le FOS
	.INS	FLOL1.ASI		; niveau 1 : utilitaires
^		.IF	ImpliedSeek
				   ^ valeur du symbole indefinie
^		.ELSE	 ImpliedSeek
			 ^ erreur IF/ELSE/ENDIF
^		.ENDIF	ELSE ImpliedSeek
			^ erreur IF/ELSE/ENDIF
	.INS	FLOL2.ASI		; niveau 2 : dplacements, lecture, criture
^		.IF	.NOT.ImpliedSeek
					^ valeur du symbole indefinie
^		.ENDIF .NOT.ImpliedSeek
		       ^ erreur IF/ELSE/ENDIF
	.INS	FLOL3.ASI		; niveau 3 : accs compatibles FOS

	.APC	PCCODE
	.LOC	0

	.MACRO	BCALL
	PUSHM.32 D0|D1|A0|A1
	CALL	%1
	POPM.32	D0|D1|A0|A1
	.ENDMACRO


START:
	MOVE.32	#R16^Main,A5
	NTREL	?IEP15TRP
	JUMP,NE	R8^EXIT$
	TRAP	#15
	MOVE.32	#0,A5
	NTREL	?IEP15TRP
EXIT$:
	EXIT

Main:
	MOVE.32	#R16^NameFlo,A3
	FOS	?DECACHE
	PUSH.32	A4
	MOVE.32	#R16^Addr0-256,A4
	MOVE.32	#0,D3
	FOS	?MCACHE
	POP.32	A4
	JUMP,NE	ERR$
	MOVE.32	#0,D0
	BCALL	FRESET
	JUMP,NE	DeCache$
;	BCALL	FOPEN
;	JUMP,NE	Kill$

	BCALL	BUSY
	BCALL	SELECT
	COMP.16	#ERMRDY,D7
	JUMP,EQ	UnBusy$
	BCALL	DOE512			; choix du format
	CLR.16	D7

	MOVE.32	#40,D1
	MOVE.32	#0,D2
	BCALL	SEEK
	bcall	restore
	MOVE.32	#R16^intread,a1
	CALL	inivect

	BCALL	READID
	CALL	AFRES
	JUMP	DESEL$

	MOVE.32	#5-1,D4
	MOVE.32	a4,a0
CLR.16	{A0}+4000-2
LOOP$:
	MOVE.32	#2,d1			; no de cylindre (0..79)
	MOVE.32	#1,d2			; no de tte (0..1)
	MOVE.32	#8,d3			; no du 1er secteur sur piste (DD : 1..9, HD : 1..18)
	MOVE.32	#1,d6			; nb de secteurs  lire (1..8, car A4 ^ sur 4K de libre)
	MOVE.32	a0,a4
	BCALL	rdtrk
	JUMP,NE	R8^RATE$
	INC.16	{A0}+4000-2
RATE$:
	CALL	AFRES
	DJ.16,NMO D4,LOOP$
	MOVE.32	a0,a4
	LIB	?AFCR,?AFTAB
	MOVE.16	{A0}+4000-2,D4
	MOVE.32	#4,D3
	MOVE.32	#0,D2
	LIB	?AFDEC,?AFSPACE,?AFTIM
	.ASCIZE	"russites."
	LIB	?AFCR
DeSel$:
	PUSH.16	D7
	BCALL	DESEL
	POP.16	D7
UnBusy$:
	PUSH.16	D7
	BCALL	UNBUSY
	POP.16	D7
Close$:
	PUSH.16	D7
;	BCALL	FCLOSE
	POP.16	D7
Kill$:
	PUSH.16	D7
	BCALL	FKILL
	POP.16	D7
DeCache$:
	PUSH.16	D7
	MOVE.32	#R16^NameFlo,A3
	FOS	?DECACHE
	POP.16	D7
	JUMP,EQ	R8^Ret$
Err$:
	MOVE.16	D7,D4
	LIB	?AFX4
Ret$:
	POPM.32	A0|D0
	RETSF

NameFlo:
	.ASCIZE	"%M_FLO.DRIV"


;--------\\
;  AFRES  >
;========/

; Affiche les bytes de rsultat

; in	A6.32	^variables globales
; out	-
; mod	-

AfRes:
	PUSHM.32 A0|D4
	PUSH.16	D7

	MOVE.32	#{A6}+OST0,A0

	MOVE.8	{A0+},D4
	LIB	?AFB8,?AFSPACE
	MOVE.8	{A0+},D4
	LIB	?AFB8,?AFSPACE
	MOVE.8	{A0+},D4
	LIB	?AFB8,?AFTAB
	MOVE.8	{A0+},D4
	LIB	?AFX2,?AFSPACE
	MOVE.8	{A0+},D4
	LIB	?AFX2,?AFSPACE
	MOVE.8	{A0+},D4
	LIB	?AFX2,?AFSPACE
	MOVE.8	{A0},D4
	LIB	?AFX2,?AFTAB

	POP.16	D4
	JUMP,EQ	R8^OK$
	LIB	?AFX4,?AFCR
	MOVE.16	D4,D7
	JUMP	R8^RET$
OK$:
	LIB	?AFTIM
	.ASCIZE	"<AFINV>OK<AFDIR>"
	LIB	?AFCR
	CLR.16	D7
RET$:
	POPM.32	A0|D4
	RET




; Processus fils de gestion du moteur
; -----------------------------------


MOFF:	AND.8	#2'00001111,_DOR		; clear les 4 bits MOTOR ENABLE

MOTCTRL:MOVE.32	#-1,D4
	JUMP	R8^SET$

PUT5$:	MOVE.16	#50*5,D4		; timeout : 5 s.

SET$:	NTREL	?SETTIM			; change le timeout

	MOVE.32	{A6}+OPSEMSCMD,A5	; ^sma. pour commandes
	NTREL	?WAITEV			; attend commande
	JUMP,NE	R8^MOFF			; si timeout => on peut arrter les moteurs

	TEST.8	{A6}+OCOMMOT
	JUMP,EQ	PUT5$			; MOTOR OFF
	JUMP,PL	MOTCTRL			; MOTOR ON	

	NTREL	?ABORT			; fin


NOMFILS:
	.ASCIZE	"FLO_MOTOR"


	.END
