
	.TITLE  FLO.ASD


;-------------------------------------------------------------------------------
;	Copyright (C) 1992, '93, '94, '95  Daniel MARMIER & EPSITEC SA
;-------------------------------------------------------------------------------


REVMAJ		=	2		; rvision du driver
REVMIN		=	3		; version du driver


	.PROC	M68020

	.START	START
	.REV	REVMAJ,REVMIN
	.IDENT	"Copyright (C) 1995 Daniel MARMIER & EPSITEC SA"


TEST = FALSE


;-------------------------------------------------------------------------------

	.INS	TESTMACHINE.ASI

	TESTMACHINE

;-------------------------------------------------------------------------------


MUBUS		=	SM8.OR.SM100 ;.OR.TRUE

GPL1E256	=	1

FormatTrack	=	FALSE		; supporte commande format track (pour DR)
ImpliedSeek	=	TRUE		; seek automatique par commandes de transfert

; Le FOS manquant quelque peu de subtilit, il incombe aux pilotes d'interdire
; toute criture entre un changement de disque et le CLOSE

LockTilClose	=	TRUE		; bloque tout jusqu'au prochain CLOSE
DefFmt		=	FALSE		; format par dfaut si dtection choue

;-------------------------------------------------------------------------------

; ATTENTION : La longueur du buffer de formatage dpend directement du nombre de
; secteurs/piste. Il ne faut pas oublier de mettre  jour NBMAXSEC lors 
; d'adjonctions de nouveaux formats.

NBMAXSEC	=	18		; nb de secteurs/piste maximum interformats

;-------------------------------------------------------------------------------

; Fichiers de rfrence
; ---------------------

	.REF	SMAKY
	.REF	I82077			; dfinitions du contrleur floppy Intel 82077
	.REF	BIOS
	.REF	BIOSDRIV
	.REF	MON

	.IF	SM8
	.REF	SM8HARD			; rferences hard pour Smaky 8
	.REF	SHIDRIVSM8
	.ENDIF
	.IF	SM100
	.REF	SM100HARD		; rfrences hard pour Smaky 100
	.ENDIF
	.IF	SM130
	.REF	SM130HARD
	.REF	SHIDRIV130
	.ENDIF

;-------------------------------------------------------------------------------

PCCODE		=	1
PCDEF		=	2

	.INS	FLOREF.ASI		; dfinitions internes

;-------------------------------------------------------------------------------

	.APC	PCCODE
	.LOC	0

START:
	.16	0, D0BASE
	.16	1, D1BASE
	.16	2**7


;	================================================
;		DRIVER $FLO_0		No 16'64
;	================================================

D0ID:	.16	FOPEN-D0BASE
	.16	FCOMMAND-D0BASE
	.16	FRSTATUS-D0BASE
	.16	FREAD-D0BASE
	.16	FWRITE-D0BASE
	.16	FCLOSE-D0BASE
	.16	-1			; D0STOPTR-D0BASE
	.16	-1			; D0STARTR-D0BASE
	.16	-1			; D0AVOTR-D0BASE
	.16	-1			; D0AUX1-D0BASE
	.16	-1			; D0AUX2-D0BASE
	.16	FRESET-D0BASE
	.16	FKILL-D0BASE
	.16	-1			; D0STRT-D0BASE
	.16	-1			; D0TSTRT-D0BASE
	.16	-1			; D0START-D0BASE

D0NAME:
	.IF	MUBUS
	.ASCII	"FLOM_0"		; nom du driver
	.ELSE	MUBUS
	.ASCII	"FLO_0"
	.ENDIF	ELSE MUBUS
	.FILL.8 LGDNAM-(APC-D0NAME), 0

	.IF	MUBUS
	.8	16'66			; numro de driver
	.ELSE	MUBUS
	.8	16'64			; numro de driver
	.ENDIF	ELSE MUBUS
	.8	TYPMM			; type "mmoire de masse"
	.8	REVMAJ, REVMIN		; rvision, version
	.8	PRIODRIV, 0		; priorit
	.8	0			; attribut 1
	.8	2**BDRDOK.OR.2**BDWROK ; .OR.2**BDNORT  ; attribut 0
	.FILL.8 LGDDESC-(APC-D0ID), 0
D0BASE:
	.16	0


;	================================================
;		DRIVER $FLO_1		No 16'65
;	================================================

D1ID:	.16	FOPEN-D1BASE
	.16	FCOMMAND-D1BASE
	.16	FRSTATUS-D1BASE
	.16	FREAD-D1BASE
	.16	FWRITE-D1BASE
	.16	FCLOSE-D1BASE
	.16	-1			; D1STOPTR-D1BASE
	.16	-1			; D1STARTR-D1BASE
	.16	-1			; D1AVOTR-D1BASE
	.16	-1			; D1AUX1-D1BASE
	.16	-1			; D1AUX2-D1BASE
	.16	FRESET-D1BASE
	.16	FKILL-D1BASE
	.16	-1			; D1STRT-D1BASE
	.16	-1			; D1TSTRT-D1BASE
	.16	-1			; D1START-D1BASE

D1NAME:
	.IF	MUBUS
	.ASCII	"FLOM_1"		; nom du driver
	.ELSE	MUBUS
	.ASCII	"FLO_1"			; nom du driver
	.ENDIF	ELSE MUBUS
	.FILL.8 LGDNAM-(APC-D1NAME), 0
	.IF	MUBUS
	.8	16'67			; numro de driver
	.ELSE	MUBUS
	.8	16'65			; numro de driver
	.ENDIF	ELSE MUBUS
	.8	TYPMM			; type "mmoire de masse"
	.8	REVMAJ, REVMIN		; rvision, version
	.8	PRIODRIV, 0		; priorit
	.8	0			; attribut 1
	.8	2**BDRDOK.OR.2**BDWROK ; .OR.2**BDNORT  ; attribut 0
	.FILL.8 LGDDESC-(APC-D1ID), 0
D1BASE:
	.16	1

;---------------------------------------------------------------------------------------------------


	.INS	FLOL1.ASI		; niveau 1 : utilitaires
	.INS	FLOL2.ASI		; niveau 2 : dplacements, lecture, criture
	.INS	FLOL3.ASI		; niveau 3 : accs compatibles FOS



; Processus fils de gestion du moteur
; -----------------------------------


MOFF:	AND.8	#2'00001111,_DOR		; clear les 4 bits MOTOR ENABLE

MOTCTRL:MOVE.32	#-1,D4
	JUMP	R8^SET$

PUT5$:	MOVE.16	#50*5,D4		; timeout : 5 s.

SET$:	NTREL	?SETTIM			; change le timeout

	MOVE.32	{A6}+OPSEMSCMD,A5	; ^sma. pour commandes
	NTREL	?WAITEV			; attend commande
	JUMP,NE	R8^MOFF			; si timeout => on peut arrter les moteurs

	TEST.8	{A6}+OCOMMOT
	JUMP,EQ	PUT5$			; MOTOR OFF
	JUMP,PL	MOTCTRL			; MOTOR ON	

	NTREL	?ABORT			; fin


NOMFILS:
	.ASCIZE	"FLO_MOTOR"



	.END
