	.TITLE	KEY.ASD		; Smaky 8, 100 et 324, Costronic 20 et 21
	.PROC	M68030F
	.BASE	10'10
	.LAYOUT HEX

K1	=	TRUE	; diver supportant le processeur K1 du SM130
jfgK1	=	True	; chercher jfgK1 pour les dernires modifs
azerty	=	FALSE
.if	azerty
NUMLOCK	=	TRUE
.endif	azerty
newPattern	=	true
.if	NewPattern
SyncPattern	=	2'1000000000000000
.else
SyncPattern	=	2'1000000000001000
.endif	NewPattern
; Responsable: Beat Brunner

MajRevKey	=	1
MinRevKey	=	18
ClefVer	=	MajrevKey*16'100+MinRevKey
ClefVer1_14 = 10'1*16'100+10'14

.rev	MajRevKey,MinRevKey

; Date	    Rev	 Auteur	Amliorations
; ------------------------------------------------------------------------------
; 16.01.95  1.18  DM	Ajout RSTATUS de longueur 4, qui rend un pointeur sur
;			le nombre d'lments dans le FIFO (rserv  MOUSE !).
; 19.08.94  1.17  PA	Modifi commande pour $DIS_0, utilise le FOS.
; 22.07.94  1.16  DM	Ajout des pilotes (pour DIS 8.0), chercher @DM 22/7/94.
;			Macro pour les headers (quand y'en a marre ...)
;-------------------------------------------------------------------------------

; Paramtres d'assemblage
; -----------------------

	.MACRO		Testmachine
	.IF		%P=SYS
DEBUG		=	0
AfDebug		=	0
MINI		=	0
SM8		=	1		; Assemblage pour SM8
SM100		=	0		;
sm130		=	false
SM300		=	FALSE
SM324		=	0
COS20		=	0
COS21		=	0
SM196		=	FALSE
	.ENDIF

	.IF		%P=100
DEBUG		=	0
AfDebug		=	0
MINI		=	0
SM8		=	0
SM100		=	1		; 1 => pour SMAKY100
sm130		=	false
SM300		=	FALSE
SM324		=	0
COS20		=	0
COS21		=	0
SM196		=	FALSE
	.ENDIF

	.IF		%P=130
DEBUG		=	0
AfDebug		=	false
MINI		=	false
SM8		=	0
SM100		=	0		; 1 => pour SMAKY100
sm130		=	true
SM300		=	FALSE
SM324		=	0
COS20		=	0
COS21		=	0
SM196		=	FALSE
	.ENDIF

	.IF		%P=324
DEBUG		=	0
AfDebug		=	0
MINI		=	0
SM8		=	0
SM100		=	0		; 
sm130		=	false
SM300		=	FALSE
SM324		=	1
COS20		=	0
COS21		=	0
SM196		=	FALSE
	.ENDIF
	.IF		%P=196
DEBUG		=	0
AfDebug		=	0
MINI		=	0
SM8		=	0
SM100		=	0		; 
sm130		=	false
SM300		=	FALSE
SM324		=	0
COS20		=	0
COS21		=	0
SM196		=	TRUE
	.ENDIF

	.IF		%P=300
DEBUG		=	0
AfDebug		=	0
MINI		=	0
SM8		=	0
SM100		=	0		; 
sm130		=	false
SM300		=	true		; Clavier pour SM300
SM324		=	0
COS20		=	0
COS21		=	0
SM196		=	false
	.ENDIF



	.IF		%P=COS
DEBUG		=	0
AfDebug		=	0
MINI		=	0
SM8		=	0
SM100		=	0
sm130		=	false
SM300		=	FALSE
SM324		=	0
COS20		=	1
COS21		=	0
SM196		=	FALSE

	.ENDIF

	.IF		%P=CO2
DEBUG		=	0
AfDebug		=	0
MINI		=	0
SM8		=	0
SM100		=	0
sm130		=	false
SM300		=	FALSE
SM324		=	0
COS20		=	0
COS21		=	1
SM196		=	FALSE
	.ENDIF

	.ENDMACRO


	TESTmachine		; initialise les variables machine-dpendantes

.IF	FALSE
; Assemblage conditionnel
; -----------------------

SM8	=	0		; driver pour Smaky 8
SM100	=	0		; driver pour Smaky 100
SM324	=	0		; driver pour Smaky 324
COS20	=	1		; driver pour terminal Costronic
COS21	=	0		; driver pour systme Costronic, carte d'extension
MINI	=	0		; driver utilisant les appels moniteur

DEBUG	=	0		; SM8: Err dans KEY_CONTROL beaucoup plus svre
AFDEBUG	=	0		; Affichage des debugs

.ENDIF	FALSE
	.IF	.NOT.(SM196.OR.SM300.or.sm130)
	.IF	(SM8+SM100+SM324+COS20+COS21+MINI).NE.1
Attention, assemblage conditionnel faux !	;%error
	.ENDIF
	.ENDIF

.IF	SM8
.IDENT	"Pilote clavier pour Smaky 8, (C) Beat BRUNNER & EPSITEC-sytem sa"
.ENDIF	SM8

.IF	SM100
.IF	Azerty
.IDENT	"Pilote clavier AZERTY pour Smaky 100, (C) Beat BRUNNER & EPSITEC-system sa"
.else
.IDENT	"Pilote clavier pour Smaky 100, (C) Beat BRUNNER & EPSITEC-system sa"
.endif	Azerty
.ENDIF	SM100

.IF	SM130
.IF	AZERTY
.IDENT	"Pilote clavier AZERTY pour Smaky 130, (C) Beat BRUNNER & EPSITEC-system sa"
.ELSE

.IDENT	"Pilote clavier pour Smaky 130, (C) Beat BRUNNER & EPSITEC-system sa"
.ENDIF	AZERTY
.ENDIF	SM130

.IF	SM324
.IF	AZERTY
.IDENT	"Pilote clavier AZERTY pour Smaky 324, (C) Beat BRUNNER & EPSITEC-system sa"
.ELSE
.IDENT	"Pilote clavier pour Smaky 324, (C) Beat BRUNNER & EPSITEC-system sa"
.ENDIF	AZERTY
.ENDIF	SM324

.IF	SM196
.IF	AZERTY
.IDENT	"Pilote clavier AZERTY pour Smaky 196, (C) Beat BRUNNER & EPSITEC-system sa"
.ELSE
.IDENT	"Pilote clavier pour Smaky 196, (C) Beat BRUNNER & EPSITEC-system sa"
.ENDIF	AZERTY
.ENDIF	SM324

.IF	SM300
.IF	AZERTY
.IDENT	"Pilote clavier AZERTY pour Smaky 300, (C) Beat BRUNNER & EPSITEC-system sa"
.ELSE

.IDENT	"Pilote clavier pour Smaky 300, (C) Beat BRUNNER & EPSITEC-system sa"
.ENDIF	AZERTY

; PA --> JFG
;
; rv 1.9 :	Dans la routine PGEST, on compte le nombre de touches
;		presses  un moment donn. Lorsque ce nombre de touches
;		est dj gal ou suprieur  2 et que le code "SPACE"
;		apparat, on l'ignore simplement.
;
;		Lorsque l'on presse une touche SUPER-SHIFT, puis une
;		touche SHIFT, on ne perd plus le code SUPER-SHIFT.
;
;		Ajouts reprs par un @PA dans la marge.

.ENDIF	SM300

.IF	COS20
.IDENT	"Pilote clavier pour sytme Costronic 20, (C) Beat BRUNNER & COSTRONIC sa"

;	JFG --> BB
;	J'ai modifi la configuration du terminal de faon  disposer des
;	touches suivantes @, $, [, ], ..
;	Il y a dsormais 2 types de codes doubles  convertir. D'autre part
;	la dtermination du pseudo code d'une touche n'tait pas correcte;
;	j'ai rajout une table pour effectuer la conversion de code

; 1.0	Premire version livre  COSTRONIC SA
; 1.1	Adjonction des touches M0, M1, M2, M3 dans les tables de conversion

.ENDIF	COS20

.IF	COS21
.IDENT	"Pilote clavier pour sytme Costronic 21, (C) Beat BRUNNER & COSTRONIC sa"

; Journal des modifications
; -------------------------

; JFG --> BB
;	J'ai d me mettre totalement IOF pendant l'une des phase du
;	balayage du clavier. Le floppy fonctionne encore parfaitement

; 1.0	Premire version livre  COSTRONIC SA

.ENDIF	COS21




	.IF	SM8
	.REF 	SM8HARD
	.ENDIF	SM8
	.IF	SM100
	.REF 	SM100HARD
	.ref		bios
	.REF	SHIDRIV100
SAVCONFI	=	16'959	; priph con
BCLAPAR		=	6
	.ENDIF	SM100

	.if	sm130
	.REF	MON
	.REF	SM130HARD
	.ref	bios
	.ref	shidriv130
	.endif	sm130

	.IF	SM324
	.REF 	SM324HARD
	.ref	bios
	.REF	SHIDRIV324
	.ENDIF	SM324

	.IF	SM196
	.REF	SM196HARD
	.REF	SHIDRIV196
	.REF	BIOS
	.ENDIF	SM196

	.IF	SM300
	.REF	SM300HARD
	.REF	SHIDRIV300
	.REF	BIOS

AdModeKeyLoad	=	AdMode+6*8		; Bits de commande du clavier.
AdModeKeyClock	=	AdMode+7*8

On		=	-1			; Pour le clavier
Off		=	0			; balay

	.ENDIF	SM300

	.IF	COS20.or.COS21
	.REF	COSHARD
	.IF	COS21
	.REF	CO2HARD
	.ENDIF	COS21
	.REF	SHIDRIVCOS
	.ENDIF	COS20.or.COS21

	.REF	MON
	.REF	CLAVIER
	.REF	SMAKY
	.REF	BIOSDRIV


; Constantes
; ----------

BASNUM	=	0		; numros claviers = 0..n
;@DM NBKEYB	=	10'16		; nb max numros de claviers
NBKEYB	=	10'20		; nb max numros de claviers


DREP1	=	10'40		; premier dlai si repeat
DREP2	=	10'2		; deuxime dlai si repeat

MAXLST	=	10'40		; lg max d'une liste de touches




; Dfinition des variables gnrales des drivers clavier
; ------------------------------------------------------

	.LOC	0
OPDGEST:	.BLK.32	1		; identificateur du process fils
OPTDKP:		.BLK.32	1		; ^desc clavier pseudo-p actuel
OSEMAS:		.BLK.32	1		; ^desc sm d'arbit de l'assign
OSEMAW:		.BLK.32	1		; smaphore d'attente d'attrib
OPTDKE:		.BLK.32	1		; ^desc/flag clavier espion
OSEMWESP:	.BLK.32	1		; sma d'attente de traitement espion
OTAPKD:		.BLK.32	NBKEYB		; table des ^descript claviers
OLASND:		.BLK.32	1		; last car envoy ds un KFIFO
OCFNCT:		.BLK.8	1		; touches-fonction courantes
ONBKOP:		.BLK.8	1		; nombre de drivers ouverts
OGKYIP:		.BLK.8	MAXLST		; liste globale touches inter-p
OREP:		.BLK.16	1		; Attente de rptition courante
OREP1:		.BLK.16	1		; Premire attente
OREP2:		.BLK.16	1		; Attentes suivantes
OKACTIF:	.BLK.32	1		; ^descr. du seul clavier actif
OACTIF:		.BLK.8	1		; Code/flag clavier (non-)actif
OFLAGS:		.BLK.8	1		; Flags divers
		.EVEN
 BINESP		=	 0		  ; en train d'envoyer  un espion
 BFIVID		=	 1		  ; Fifo final vide
	.IF	COS20
 BSS3		=	 6		  ; Cursor en en cours
 BCSI		=	 5
	.ENDIF	COS20
	.IF	SM8.or.SM324
 BWFIVID	=	 7		  ; Attente sur fifo final vide
OSEMA1:		.BLK.32	1		; smaphore du FIFO 1.
OFIFO1:		.BLK.32	1		; ^descritpeur du premier FIFO
	.ENDIF	SM8.or.SM324
	.IF	SM8
OFIFO2:		.BLK.32	1		; ^FIFO de gest 1 de codes ASCII
OOLDKEY:	.BLK.16	1		; dernire configuration rendue
	.ENDIF	SM8
	.IF	SM324
OOLDKEY:	.BLK.32	1		; dernire configuration rendue
	.ENDIF	SM324
	.IF	SM100.or.COS21.or.sm196.or.sm300.or.sm130
OCNTREP:	.BLK.16	1		; dcompteur pour repeats
OLASTKEY:	.BLK.32	1		; Dernier code de touche appuie envoy
OIETAT:		.BLK.16	10		; tat des touches (bitmap)
OIPRES:		.BLK.16	10		; touches presses (bitmap)
OIREL:		.BLK.16	10		; touches relches (bitmap)
OCLAMODE:	.BLK.16	1		; Mode de clavier (distant)
ONBROW:		.BLK.8	1		; Nombre de lignes disponibles
OCAPS:		.BLK.8	1		; Flag 'caps lock enfonc'
OLSTFON:	.BLK.8	1		; Dernires touches fonctions envoyes
oLstShift:	.BLK.8	1		; dernier tat des touches Shift + CTRL
OFLGCOD:	.BLK.8	1		; Flags pour codes modifis
 BCODMOD	=	 0		;  routine KEYCNV: un code a t modifi
	.ENDIF	SM100.or.COS21.or.sm196.or.sm300.or.sm130
.IF	SM324.AND.AZERTY
oLstShift:	.BLK.8	1
.ENDIF	SM324.AND.AZERTY
	.IF	COS20
OCANUSA:	.BLK.16	1		; canal pour l'USART
OBYTEUSA:	.BLK.8	1		; mmoire pour read de l'usart
	.ENDIF	COS20
	.IF	SM300			; @PA
OCOUNTPRESS:	.BLK.8	1		; compte les touches presses
	.ENDIF	SM300

	.IF	K1
	.EVEN
OIK1:		.BLK.16	10		; tat des touches (bitmap K1)
OBUFREAD:	.BLK.8	1		; buffer de lecture K1
OUSEK1:		.BLK.8	1		; 1=> utilise le proc. K1
		.EVEN
OK1IN:		.BLK.16	1		; canal USART K1 en lecture
OK1OUT:		.BLK.16	1		; canal USART K1 en criture
	.EVEN
	.ENDIF	K1
	.EVEN
LGVAR:



; Dfinition d'un descripteur de clavier pseudo-physique
; ------------------------------------------------------

		.LOC	0
OKNUM:		.BLK.8	1		; numro de clavier pseuo-phys
		.BLK.8	1		; rserve
OKREP1:		.BLK.16	1		; premier dlai pour repeat
OKREP2:		.BLK.16	1		; deuxime dlai pour repeat
OKFIFO:		.BLK.16	2		; ^FIFO interne
OKSEMA:		.BLK.16	2		; ^smaphore associ au FIFO
OWSEMA:		.BLK.16	2		; ^smaphore pour WFSKEY
OWKEY:		.BLK.16	2		; touche reue pour WFSKEY
OLKYIP:		.BLK.8	MAXLST		; liste touches inter-prog.
OLKYDP:		.BLK.8	MAXLST		; liste touches dans prog.
LGPPKD:



; Dfinition de constantes de gestion internes
; --------------------------------------------

; Arrivant depuis la routine d'interruption:

BPSEUDO	=	10'15
BRELEASE=	10'7

;	|---------------|---------------|
;	|0   fonction	|   code ascii	|  code ascii press
;	|---------------|---------------|
;
;	|---------------|---------------|
;	|1   fonction	|0  pseudo-code	|  pseudo-code press
;	|---------------|---------------|
;
;	temps ...
;
;	|---------------|---------------|
;	|1   fonction	|1  pseudo-code	|  pseudo-code relach
;	|---------------|---------------|
;
; Sur le Smaky 8:
; Les deux premiers words ne sont pas forcment conscutifs (mais
; obligatoirement dans cet ordre.
; Lacune de conception: le 2me word peut tre innexistant
; Moyen de dtection: il doit venir 8 ms aprs le premier.

	.MACRO	AFDEB
	.IF	AFDEBUG
	PUSHM.32 D4|D7|D3
	MON	?AFTIM
	.ASCIZE	" %1"
	MOVE.32	A6,D4
	MON	?AFX8,?AFSPACE,?GETCAR
	POPM.32	D4|D7|D3
	.ENDIF	AFDEBUG
	.ENDMACRO

	.MACRO	AFDEBR8
	.IF	AFDEBUG
	PUSHM.32 D4|D7|D3
	MON	?AFTIM
	.ASCIZE	" %1"
	MOVE.32	%2,D4
	MON	?AFX8,?AFSPACE,?GETCAR
	POPM.32	D4|D7|D3
	.ENDIF	AFDEBUG
	.ENDMACRO


; Macro pour gnrer un header de driver @DM 22/7/94

   .MACRO _Header ; log num, phys num
   .LOCALMACRO Start,Name
Start:
	.16	KOPEN-K%1BASE
	.16	KCOMMAND-K%1BASE
	.16	KRSTATUS-K%1BASE
	.16	KREAD-K%1BASE
	.16	-1		; KWRITE
	.16	KCLOSE-K%1BASE
	.16	-1		; STOPTR
	.16	-1		; STARTR
	.16	-1		; AVORTTR
	.16	KAUX1-K%1BASE
	.16	-1		; KAUX2
      .IF %1.EQ.0
	.16	K0RESET-K%1BASE
	.16	K0KILL-K%1BASE
      .ELSE
	.16	KRESET-K%1BASE
	.16	KKILL-K%1BASE
      .ENDIF
	.16	-1		; KSTRT
	.16	-1		; KTSTRT
	.16	-1		; KSTART

Name:	.ASCII	"KEY_%1"	; Nom driver
	.FILL.8 LGDNAM-(APC-Name), 0

	.8	%2		; Numro driver
	.8	TYPKEY		; Type de priphrique

	.8	MajRevKey,MinRevKey	; Rvision - version
	.8	-1,0		; Priorit ds driver

	.8	0		; Attribut 1
      .IF %1.EQ.0
	.8	0		; Attribut 0
      .ELSE
	.8	2**BDRDOK.OR.2**BDAPRG; Attribut 0
      .ENDIF

	.FILL.8 	LGDDESC-(APC-Start), 0 ; Le reste.
K%1BASE:
; @DM 22/7/94
	.16	%1		; Numro logique (drivers plus conscutifs)
LASTDRIV == %1
   .ENDMACRO


; Entte gnrale du fichier driver.
; ----------------------------------

	.LOC	0

	.16	10'0,K0BASE
	.16	10'1,K1BASE
	.16	10'2,K2BASE
	.16	10'3,K3BASE
	.16	10'4,K4BASE
	.16	10'5,K5BASE
	.16	10'6,K6BASE
	.16	10'7,K7BASE
	.16	10'8,K8BASE
	.16	10'9,K9BASE
	.16	10'10,K10BASE
	.16	10'11,K11BASE
	.16	10'12,K12BASE		; nouveau...
	.16	10'13,K13BASE
	.16	10'14,K14BASE
	.16	10'15,K15BASE		; ...nouveau
; @DM 22/7/94
	.16	10'16,K16BASE		; tout ...
	.16	10'17,K17BASE
	.16	10'18,K18BASE
	.16	10'19,K19BASE		; ... nouveau !
; @DM 22/7/94
	.16	2**7


; Entte des diffrents drivers:
; ------------------------------

.if true ; @DM 22/7/94
	_Header	0, BASNUM+16'00
	_Header	1, BASNUM+16'01
	_Header	2, BASNUM+16'02
	_Header	3, BASNUM+16'03
	_Header	4, BASNUM+16'04
	_Header	5, BASNUM+16'05
	_Header	6, BASNUM+16'06
	_Header	7, BASNUM+16'07
	_Header	8, BASNUM+16'08
	_Header	9, BASNUM+16'09
	_Header	10, BASNUM+16'0A
	_Header	11, BASNUM+16'0B
	_Header	12, BASNUM+16'0C
	_Header	13, BASNUM+16'0D
	_Header	14, BASNUM+16'0E
	_Header	15, BASNUM+16'0F
; Nouveaux pour pilote DISPLAY 8.0 (systme 10), @DM 22/7/94
	_Header	16, 16'18
	_Header 17, 16'19
	_Header 18, 16'1a
	_Header 19, 16'1b
; @DM : la tranche 16'18  16'1f est pour le clavier ...

.IF	LASTDRIV+1.NE.NBKEYB
.ERROR	"nombre de drivers (NBKEYB) faux !!!"
.ENDIF

.else ; @DM 22/7/94
	.INS	OldHeaders.ASI
.endif


; Routines de gestion correspondantes
; -----------------------------------

;----------\\
;  K0RESET  >
;==========/

; in	A0.L	^adresse de base du descipteur de $KEY_0
; out	D7.W	Si erreur:
;			Celles de ?GETMEM
;	A6	^variables
; mod	D0..A1, D7.W

K0RESET:
AFDEB	IK0RESET
	PUSHM.32 D2|D4|D5|A0|A2|A3|A4|A5 ; sauve variables user

	MOVE.32	#LGVAR,D4		; s'attribue les variables
	MOVE.32	#MTYPBD,D1		; globales du binaire
	MOVE.32	A0,A1
	GESMEM	?GETMEM
	JUMP,NE	L90$

	MOVE.32	A4,A6			; initialise les variables  0
	GESMEM	?CLEARMEM		; @PA

.IF	K1
	CALL	INITK1
.ENDIF	K1

	.IF	SM8.or.SM324
	TSET.8	{A6}+OFLAGS:#BFIVID	; Au dpart, le fifo final est vide
	.ENDIF	SM8.or.SM324

			; cre le smaphore d'arbitration de
			; la gestion de l'attribution du clavier.
	MOVE.32	#1,D4			; sm. d'exclusion mutuelle
	NTREL	?CRESEM
	JUMP,NE	L87$
	MOVE.32	A5,{A6}+OSEMAS		; mmorise l'identificateur

			; cre le smaphore d'attente de r-
			; attribution du clavier.
	MOVE.32	#0,D4			; smaphore synchronisation
	NTREL	?CRESEM
	JUMP,NE	L86$
	MOVE.32	A5,{A6}+OSEMAW		; mmorise l'identificateur

			; cre le smaphore d'attente d'acquisition
			; du clavier espion

;;	MOVE.32	#0,D4			; smaphore synchronisation
	NTREL	?CRESEM
	JUMP,NE	L86$
	MOVE.32	A5,{A6}+OSEMWESP	; mmorise l'identificateur

	.IF	SM8
	TCLR.8	PAB55+1:#3		; teint lampe M0
	TCLR.8	PAB55+1:#2		; teint lampe M1
	TCLR.8	PAB55+1:#1		; teint lampe M2
	TCLR.8	PAB55+1:#0		; teint lampe M3
	.ENDIF	SM8

	.IF	SM8.or.SM324
			; cre le FIFO primaire, agissant entre
			; routine d'interruption et processus gestionnaire.
	MOVE.32	#4,D0			; D0 <-- Longueur d'un lment
	MOVE.32	#100,D2			; D2 <-- Nombre d'lments
					; D1,A1 : paramtres pour compte-mmoir
	CALL	32^_INIFIFO		; cre et vide le FIFO
	JUMP,NE	L85$			; erreur => 85$
	MOVE.32	A0,{A6}+OFIFO1		; mmorise le ^au FIFO
	.ENDIF	SM8.or.SM324

	.IF	SM8
			; cre le FIFO utilitaire de stockage
			; des codes ASCII seuls.
	DEC.16	D0			; Longueur d'un lment = 1
	MOVE.32	#50,D2			; D2 <-- Nombre d'lments
					; D1,A1 : paramtres pour compte-mmoir
	CALL	32^_INIFIFO		; cre et vide le FIFO
	JUMP,NE	L85$			; erreur => 85$
	MOVE.32	A0,{A6}+OFIFO2		; mmorise le ^au FIFO
	.ENDIF	SM8

	.IF	SM8.or.SM324
			; cre le smaphore associ au FIFO 1.
	MOVE.32	#0,D4			; smaphore de synchronisation
	NTREL	?CRESEM
	JUMP,NE	L85$			; erreur => 85$
	MOVE.32	A5,{A6}+OSEMA1		; mmorise le ^au descritpeur
	.ENDIF	SM8.or.SM324

	.IF	SM324
	CLR.16	D0
	MOVE.16	D0,{A6}+OOLDKEY
	.ENDIF	SM324

	.IF	SM8
	MOVE.16	CLA,D0			; dbloque les compteurs.
	MOVE.16	FONC,D0
	MOVE.16	SOURIS,D0

	MOVE.32	#2,D4			; Attend une vent prochaine arrive
	NTREL	?DELMS

	MOVE.16	FONC,D0			; initialise le registre de
	SL.16	#8,D0			; dernire touche traite
	MOVE.8	CLA+1,D0
	MOVE.16	D0,{A6}+OOLDKEY
	.ENDIF	SM8
	.IF	COS20
	PUSHM.32 A3|A4|A2|D3
	MOVE.32	#R16^TXUSALOG,A3
	MOVE.32	#R16^TXUSAPHYS,A4
	MOVE.32	#R16^TXUSAPARAM,A2
	CLR.16	D3
	FOS	?INSTALL
	POPM.32	 A3|A4|A2|D3
	JUMP,NE	L90$			; erreur fatale !!!
	PUSHM.32 A3|D3|D6
	MOVE.32	#R16^TXUSAPHYS,A3
	MOVE.32	#2**BOPEXCL+2**BOPRD,D3
	FOS	?OPEN
	MOVE.16	D6,{A6}+OCANUSA		; canal pour l'USART
	TEST.16	D7
	POPM.32	 A3|D3|D6
	JUMP,NE	L90$			; erreur fatale !!!

	TCLR.8	{A6}+OFLAGS:#BSS3	; reset SS3 pour mul. curseur

	.ENDIF	COS20


	CLR.16	{A6}+OREP		; Initialement pas de repeat
	CLR.16	{A6}+OREP1

				; cre le processus gestionnaire
	MOVE.32	#16'200,D5		; longueur du stack user (ignore)
	MOVE.32	#R16^PGEST,A5		; adr de dmarrage
	.IF	MINI
	MOVE.16	#10'30+2**BTDRIV,D4	; priorit + proc fils + mode superviseur
	.ENDIF	MINI
	.IF	SM8.or.SM324.or.COS20
	MOVE.16	#3+2**BTDRIV,D4		; priorit + proc fils + mode superviseur
	.ENDIF	SM8.or.SM324.or.COS20
	.IF	SM100.or.COS21.or.SM196.OR.SM300.or.sm130
	MOVE.16	#5+2**BTDRIV,D4		; priorit + proc fils + mode superviseur
	.ENDIF	SM100.or.COS21.or.SM196.OR.SM300.or.sm130
	MOVE.32	#R16^TXPGEST,A3		; nom du processus
					; A6: transmet ^variables
	CLR.32	D1			; entre avec D7.W = #0
	NTREL	?CRETASK		; cre la tche.
	JUMP,NE	L84$			; si erreur, retour en arrire
	MOVE.32	A4,{A6}+OPDGEST		; init le ^descript proc fils.

	.IF	SM8
			; initialise l'interruption:
	MOVE.16	#IRKEYF,D1
	MOVE.32	#R16^ADRINT,A1
	CALL	32^_ININIAD		; l'adresse de la routine, et A6 ^vars
	CALL	32^_ISEACR		; mode Auto-Clear,
	CALL	32^_ICLMRR		; et clear Mask.
	MOVE.16	CLA,D0			; dbloque les compteurs.
	MOVE.16	FONC,D0
	MOVE.16	SOURIS,D0
	.ENDIF	SM8

	.IF	SM324
			; initialise l'interruption:
	MOVE.32	#R16^ADRINT,A1
	MOVE.32	32^_INDSHI,A0
	MOVE.16	#PPIKEY,D0
	CALL	{A0}+_INIRCVPPI		; init int. lecture PPI pour paquets clavier
	.ENDIF	SM324

	JUMP	L90$

L84$:			; retour avec erreur:
	.IF	SM8.or.SM324
	MOVE.32	{A6}+OSEMA1,A5		; A5 <-- ^smaphore 1
	PUSH.16	D7			; ignore les erreurs
	NTREL	?KILLSEM		; dtruit le smaphore
	POP.16	D7			; reprend l'erreur originelle
	.ENDIF	SM8.or.SM324

L85$:			; retour avec erreur:
	PUSH.16	D7			; sauve l'erreur originelle
	MOVE.32	#MTYPBD,D1
	MOVE.32	#R16^K0BASE,A1
	GESMEM	?GBAMEM			; rend toute la mmoire
	POP.16	D7			; reprend l'erreur originelle

L86$:			; retour avec erreur:
	PUSH.16	D7			; ignore une ventuelle erreur
	MOVE.32	{A6}+OSEMAW,A5		; A5 <-- ^smaphore de synchro
	NTREL	?KILLSEM		; dtruit le smaphore
	POP.16	D7			; reprend l'erreur originelle

L87$:			; retour avec erreur:
	PUSH.16	D7			; ignore une ventuelle erreur
	MOVE.32	{A6}+OSEMAS,A5		; A5 <-- ^smaphore d'exclusion
	NTREL	?KILLSEM		; dtruit le smaphore
	POP.16	D7			; reprend l'erreur originelle
L90$:
AFDEB	OK0RESET
	POPM.32	D2|D4|D5|A0|A2|A3|A4|A5
	TEST.16	D7			; teste si erreur
	JUMP,EQ	KRESET			; reset le clavier pseudo-logik
	RET


;----------\\
;  K0KILL   >
;==========/

; Destruction des drivers clavier (KILLDRIV KEY_0)

; in	A6	^variables
; out	D7.W	Erreur= #ERKLPR	Driver indestructible.
; mod	D7.W

K0KILL:
	MOVE.16	#ERKLPR,D7
	RET


;-----------\\
;  RESET     >
;===========/

; in	A0.L	^descripteur du driver
; out	D7.W	si erreur
;	A6	^variables
; mod	D0..A1, D7.W

KRESET:
AFDEB	IKRESET
	PUSHM.32 D2|D4|A4|A5

	MOVE.32	#LGPPKD,D4		; rserve le descripteur du
	MOVE.32	#MTYPBD,D1		; clavier pseudo-physique
	MOVE.32	A0,A1			; sur le compte du driver
	GESMEM	?GETMEM			; A1 ^descripteur de driver
	JUMP,NE	L90$			; erreur => 90$
					; A4 ^descripteur de clavier
	MOVE.32	A4,A0			; initialise les variables  0
L10$:
	CLR.8	{A0+}
	DEC.16	D4
	JUMP,NE	L10$

	MOVE.32	#R16^K0BASE,A0
	COMP.32	A1,A0
	JUMP,EQ	NOGETVAR$		; sauf si juste aprs K0RESET
	MOVE.32	_INDNTR,A6
	CALL	{A6}+OIN_GETDRIVVAR	; A6 <-- ^var du driver $KEY_0
NOGETVAR$:
	MOVE.16	#DREP1,{A4}+OKREP1
	MOVE.16	#DREP2,{A4}+OKREP2

			; Cre le FIFO final de bufferisation
			; des caractres traits par le
			; processus de gestion du clavier.
	MOVE.32	#3,D0			; D0 <-- Longueur d'un lment
	MOVE.32	#100,D2			; D2 <-- Nombre d'lments
					; D1,A1: Paramtres pour GESMEM
	CALL	32^_INIFIFO		; cre et vide le FIFO
	JUMP,NE	L85$			; erreur => 85$
	MOVE.32	A0,{A4}+OKFIFO		; mmorise le ^au FIFO

	MOVE.32	#0,D4			; D4 <-- sm. synchronisation
	NTREL	?CRESEM			; cre sm. associ au FIFO
	JUMP,NE	L85$			; erreur => 85$
	MOVE.32	A5,{A4}+OKSEMA		; mmorise le ^au descritpeur

	MOVE.32	#0,D4			; D4 <-- sm. synchronisation
	NTREL	?CRESEM			; cre sm. pour WFSKEY
	JUMP,NE	L80$			; erreur => 80$
	MOVE.32	A5,{A4}+OWSEMA		; mmorise le ^au descritpeur

.if true ; @DM 22/7/94
	MOVE.8	{A1}+1,{A4}+OKNUM	; mm no de clavier logique
.else ; @DM 22/7/94
	MOVE.8	{A1}+ODHNUM,D0		; mmorise le numro de clavier
	SUB.8	#BASNUM,D0		; pseudo-physique
	MOVE.8	D0,{A4}+OKNUM
.endif

	MOVE.32	A1,A0			; A0 ^descript du driver
	CALL	MEMKPT			; mmorise le ^au descripteur
	JUMP	L90$

L80$:
	PUSH.16	D7
	MOVE.32	{A4}+OKSEMA,A5
	NTREL	?KILLSEM		; dtruit le smaphore du FIFO
	POP.16	D7
L85$:
	PUSH.16	D7			; sauve l'erreur originelle
	MOVE.32	#MTYPBD,D1
	GESMEM	?GBAMEM			; rend toute la mmoire
	POP.16	D7			; reprend l'erreur originelle
L90$:
AFDEB	OKRESET
	POPM.32	D2|D4|A4|A5
	RET


;---------\\
;  OPEN    >
;=========/

; in	A0.L	^descripteur du driver
;	A6	^variables
; out	D7.W	si erreur
; mod	D0..A1, D7.W

KOPEN:
AFDEB	IKOPEN
	PUSHM.32 D2|D4|A4|A5

	CALL	GETKPT			; A4 <-- le ^au descripteur

	TEST.8	{A6}+ONBKOP		; premier clavier ouvert ?
	JUMP,NE	L70$			; non => 70$

	MOVE.32	{A6}+OSEMAS,A5		; etablit l'exclusion des autre
	NTREL	?LOCK			; attend l'exclusivit d'accs
	JUMP,NE	L90$
			;>>>>>>>> DEBUT ZONE D'EXCLUSION

	TEST.32	{A6}+OPTDKP		; dj assign ?
	JUMP,NE	L60$			; oui => 60$
	MOVE.32	A4,{A6}+OPTDKP		; non => c'est le clavier actuel
	MOVE.16	{A4}+OKREP1,{A6}+OREP1
	MOVE.16	{A4}+OKREP2,{A6}+OREP2	; met les repeat courants
	MOVE.32	{A6}+OSEMAW,A5
	NTREL	?SSIGNEV		; signale l'attribution
L60$:
			;<<<<<<<< FIN ZONE D'EXCLUSION
	MOVE.32	{A6}+OSEMAS,A5
	NTREL	?UNLOCK			; rend les droits d'exclusivit

L70$:
	INC.8	{A6}+ONBKOP		; un clavier ouvert de plus.
L90$:
AFDEB	OKOPEN
	POPM.32	D2|D4|A4|A5
	RET


;---------\\
;  CLOSE   >
;=========/

; Effectue la fonction CLOSE dans le driver

; in	A0.L	^descripteur du driver
;	A6	^variables
; out	D7.W	si erreur
; mod	D0..A1, D7.W

KCLOSE:
	DEC.8	{A6}+ONBKOP		; un clavier ouvert de moins.
	RET


;---------\\
;  KILL    >
;=========/

; Enlve le clavier de la liste des claviers pseudo-physiques
; actifs du systme.

; in	A0.L	^descripteur du driver
;	A6	^variables
; out	D7.W	si erreur
; mod	D0..A1, D7.W

KKILL:
AFDEB	IKKILL
	PUSHM.32 D4|A4|A5
	MOVE.32	A0,A1			; A1 ^descripteur de driver
	CALL	GETKPT			; A4 <-- le ^au descripteur
	CALL	CLRKPT			; enlve le ^au descripteur

	MOVE.32	{A6}+OSEMAS,A5		; etablit l'exclusion des autre
	NTREL	?LOCK			; attend l'exclusivit d'accs
	JUMP,NE	L90$
			;>>>>>>>> DEBUT ZONE D'EXCLUSION

	COMP.32	{A6}+OPTDKP,A4		; clavier courant ?
	JUMP,NE	L30$			; non => 30$
	CLR.32	{A6}+OPTDKP		; oui => Plus de clavier cour.
L30$:
			;<<<<<<<< FIN ZONE D'EXCLUSION
	NTREL	?UNLOCK			; rend les droits d'exclusivit

	MOVE.32	{A4}+OWSEMA,A5
	NTREL	?KILLSEM		; dtruit sm. pour WFSKEY

	MOVE.32	{A4}+OKSEMA,A5
	NTREL	?KILLSEM		; dtruit sm. associ au FIFO
	JUMP,NE	L90$

	MOVE.32	{A4}+OKFIFO,A0		; dtruit le FIFO final
	MOVE.32	#MTYPBD,D1
					; A1,A4	: ^descr driver et ^mmoire
	CALL	32^_KILLFIFO		; (vent caractres perdus)

	GESMEM	?GBAMEM			; rend toute la mm associe
L90$:
AFDEB	OKKILL
	POPM.32	D4|A4|A5
	RET



;--------\\
;  READ   >
;========/

; in	A4.L	^buffer texte
;	D5.L	len  lire (ici doit tre <=  3)
;	A6	^variables
; out	D5.L	len effectivement lue
;	D7.W	erreur
; mod	D0..A1, D7.W, D5.L

KREAD:
AFDEB	IKREAD
	PUSHM.32 D4|D5|A4|A5

	TEST.8	D5			; lecture de zro byte ?
	JUMP,EQ	L90$			; oui => 90$

	COMP.32	#3,D5			; longueur correcte ?
	JUMP,HI	L85$			; non => 85$ (erreur)
	MOVE.32	A4,A1			; sauve le ^buffer

	CALL	GETKPT			; A4 <-- le ^au descripteur
L10$:
	MOVE.32	{A4}+OKFIFO,A0		; A0 ^K-FIFO
	TEST.16	{A0}+OFFNBE		; nombre d'lments restants = 0 ?
	JUMP,NE	L20$			; non => 20$

	COMP.32	{A6}+OPTDKP,A4		; Clavier assign ?
	JUMP,NE	L20$			; non => 20$
	TSET.8	{A6}+OFLAGS:#BFIVID	; met le flag "fifo vide"
	.IF	SM8.or.SM324
	TEST.8	{A6}+OFLAGS:#BWFIVID	; flag "Attente pour fifo vide" mis ?
	JUMP,EQ	L20$			; non => 20$

	MOVE.32	{A6}+OSEMA1,A5		; A5 <-- ^sma sync process de gestion
	NTREL	?SIGNEV			; signale "fifo vide" selon dsir
	.ENDIF	SM8.or.SM324
L20$:
	MOVE.32	{A4}+OKSEMA,A5		; attend le signal d'FIFO final
	NTREL	?WAITEV
	JUMP,NE	L90$

	MOVE.32	{A4}+OKFIFO,A0		; lit un triplet du K-FIFO
	CALL	32^_RDFIFO
	JUMP,NE	L10$			; si FIFO clear entre-temps


	COMP.32	{A6}+OPTDKE,A4		; est-ce le clavier espion ?
	JUMP,NE	L40$			; non => 40$

	MOVE.32	{A6}+OSEMWESP,A5	; signale l'acceptation
	NTREL	?SIGNEV
L40$:
	.IF	SM8.or.SM100.or.MINI.or.COS20.or.COS21.OR.SM196.OR.SM300.or.sm130
	SWAP.32	D0			; transfre:
	MOVE.8	D0,{A1+}		; le code ASCII
	DEC.8	D5
	JUMP,EQ	L90$
	RL.32	#8,D0
	MOVE.8	D0,{A1+}		; les touches-fnct associes
	DEC.8	D5
	JUMP,EQ	L90$
	RL.32	#8,D0
	MOVE.8	D0,{A1+}		; le pseudo-code correspondant
	.ENDIF	SM8.or.SM100.or.MINI.or.COS20.or.COS21.or.SM196.OR.SM300.or.sm130

	.IF	SM324
	MOVE.8	D0,{A1+}		; le code ASCII
	DEC.8	D5
	JUMP,EQ	L90$
	RL.16	#8,D0
	MOVE.8	D0,{A1+}		; les touches-fnct associes
	DEC.8	D5
	JUMP,EQ	L90$
	SWAP.32	D0
	MOVE.8	D0,{A1+}		; le pseudo-code correspondant
	.ENDIF	SM324

	JUMP	L90$

L85$:
	MOVE.16	#ERIRDL,D7		; erreur 'longueur de READ ill'
L90$:
AFDEB	OKREAD
	POPM.32	D4|D5|A4|A5
	RET



;----------\\
;  WFSKEY   >	( Wait For Special Key )
;==========/

; in	A6	^variables
; out	D3.L	-pseudo-fonc-code press
;	D7.W	erreur
; mod	D0..A1, D3.L, D7.W, D5.L

KAUX1:
	PUSHM.32 D4|A4|A5

	CALL	GETKPT			; A4 <-- le ^au descripteur

	MOVE.32	{A4}+OWSEMA,A5
	NTREL	?WAITEV			; attend le signal
	JUMP,NE	L90$

	MOVE.32	{A4}+OWKEY,D3		; D3 <-- touche presse
L90$:
	POPM.32	D4|A4|A5
	RET




;-----------\\
;  KRSTATUS  >
;===========/

; in	A4.L	^buffer
;	D4.L	longueur buffer
;	A6	^variables
; out	D4.L	longueur rendue effectivement
;	D7.W	erreur
; mod	D0..A1, D4.L, D7.W

KRSTATUS:
	PUSHM.32 A2|A4

	MOVE.32	A4,A2			; A2 ^buffer
	CALL	GETKPT			; A4 ^descripteur de clavier

;BEGIN @DM 16/1/95
	COMP.32	#4,D4
	JUMP,NE	R8^Not4$

; Un RSTATUS de longueur 4 rend le ^ sur le nombre de caractres dans le FIFO
; C'est bien laid, mais MOUSE doit connatre cette valeur  chaque changement 
; de position de la souris, alors ...

	MOVE.32	{A4}+OKFIFO,A0		; A0 <- ^FIFO du clavier
	MOVE.32	#{A0}+OFFNBE,A0		; A0 <- ^nombre de caractres dans FIFO
	MOVE.32	A0,{A2}
	JUMP	L80$

Not4$:
;END @DM 16/1/95

	MOVE.32	#R16^L00$,A0
	CALL	32^_CNVLGS		; D1 <-- profondeur d'investig.
	JUMP,NE	L90$

	MOVE.32	{A6}+OPTDKP,A1		; A1 <-- ^descr. clavier actuel
	MOVE.8	{A1}+OKNUM,{A2}+OKYASS	; OKYASS: no du clavier assign act.
	CLR.8	{A2}+OKYLAM		; lampes allumes <<<<<  faire <<<<<

	DEC.16	D1
	JUMP,EQ	L80$

	MOVE.8	{A4}+OKREP1+1,{A2}+OKYRP1 ; 1 er dlai de repeat
	MOVE.8	{A4}+OKREP2+1,{A2}+OKYRP2 ; 2 me dlai
	CLR.32	{A2}+OKYPRP		  ; paramtre abandonn

	MOVE.32	{A4}+OKFIFO,A0		; A0 <-- ^entte du FIFO
	MOVE.16	{A0}+OFFMAX,{A2}+OKYLGF	; longueur maximum du FIFO
	MOVE.16	{A0}+OFFNBE,{A2}+OKYUSF	; nombre de caractres dans FIFO

	MOVE.32	#{A4}+OLKYIP,A0
	MOVE.32	A0,{A2}+OKYLIP		; ^liste touches inter-prog.

	MOVE.32	#{A4}+OLKYDP,A0
	MOVE.32	A0,{A2}+OKYLDP		; ^liste touches dans prog.
L80$:
	CLR.16	D7			; D7 <-- ok
L90$:
	POPM.32	A2|A4
	RET

; Table pour CNVLGS:

L00$:
	.16	LGKEY0			; profondeurs d'investigation
	.16	LGKEY1			; pour le RDSTATUS
	.16	0



;------------\\
;  KCOMMAND   >
;============/

; in	A4.L	^table des commandes termine par zro
;	A6	^variables
; out	D7.W	erreur
;	A4.L	^commande innexistante, si erreur ERILLO
; mod	D0..A1, D7.W

KCOMMAND:
	PUSHM.32 D5|A2|A4
	PUSH.32	A4
	MOVE.32	A4,A2			; A2 ^liste d'ordres
	CALL	GETKPT			; A4 ^descripteur de clavier
L10$:
	CLR.16	D5
	MOVE.8	{A2+},D5		; lit une commande
	JUMP,EQ	L90$			; fin de liste => 90$

	COMP.8	#MAXCMD,D5		; commande erronne ?
	JUMP,LS	L20$			; non => 20$

	MOVE.16	#ERILLO,D7		; Prpare l'erreur, et
L15$:					; Retour avec A2-->A4  l'endroit
	ADD.32	#4,SP
	DEC.32	A2			; met A2 ^Paramtre faux
	MOVE.32	A2,A4			; rend le ^ds A4.
	JUMP	L95$			; retour avec erreur (sans A4)

L20$:
	SL.16	#1,D5			; D5 * 2 --> .16
	MOVE.16	R8^ADRCOM+A16^{D5},D2	; D2 <-- adr rel rout
	MOVE.32	#R16^ADRCOM,A0		; A0 <-- adr abs dpart code
	CALL	{A0}+A16^{D2}		; appelle la routine d'exec
	TEST.16	D7			; de commande: params, cf fin
	JUMP,NE	L15$			; erreur => 15$
	JUMP	L10$			; regarde la commande suivante

L90$:
	POP.32	A4
L95$:
	POPM.32	D5|A2|A4
	RET




	.INS 	KEYCOMM.ASI





;==============================================================
;	SOUS-ROUTINES UTILITAIRES.
;==============================================================


;------------\\
;  GETKPT     >
;============/

; Rend le pointeur au ^descripteur d'un clavier pseudo-physique

; in	A6.L	^variables globales du programme
;	A0.L	^descripteur du driver
; out	A4.L	^ l'identificateur du smaphore
; mod	A4.L, F

GETKPT:
	PUSH.16	D0			; Sauve D0
	CALL	CALCOFS			; Calcule l'offset
	MOVE.32	{A6}+A16^{D0}+OTAPKD,A4	; A4 <-- identificateur
	POP.16	D0			; Restitue D0
	RET


;------------\\
;  MEMKPT     >
;============/

; Mmorise le pointeur au ^descripteur d'un clavier
; pseudo-physique.

; in	A6.L	^variables globales du programme
;	A0.L	^descripteur du driver
;	A4.L	^ l'identificateur du smaphore
; out	-
; mod	F

MEMKPT:
	PUSH.16	D0			; Sauve D0
	CALL	CALCOFS			; Calcule l'offset
	MOVE.32	A4,{A6}+A16^{D0}+OTAPKD	; Mmorise l'indentificateur
	POP.16	D0			; Restitue D0
	RET



;------------\\
;  CLRKPT     >
;============/

; Annule le pointeur au ^descripteur d'un clavier
; pseudo-physique.

; in	A6.L	^variables globales du programme
;	A0.L	^descripteur du driver
; out	-
; mod	F

CLRKPT:
	PUSH.32	A4
	MOVE.32	#0,A4
	CALL	MEMKPT
	POP.32	A4
	RET


;----------\\
; CALCOFS   >
;==========/

; Sous-routine utilitaire

; in	A0.L	^descripteur du driver
; out	#(A6)+(D0.W)+OTAPKD ^au ^descript du clavier
; mod	D0.W,F

CALCOFS:
.if true ; @DM 22/7/94
	MOVE.16	{A0},D0			; le no logique est aprs le header
.else ; @DM 22/7/94
	CLR.16	D0
	MOVE.8	{A0}+ODHNUM,D0		; D0.W <-- Numro du driver
	SUB.8	#BASNUM,D0		; D0.W <-- Position ds table
.endif
	SL.16	#2,D0			; *4 (.L) ==> offset
	RET



	.INS 	KEYFILS.ASI		; traitement des codes


	.IF	SM100.or.COS21.or.SM196.OR.SM300.or.sm130
	.INS	KEYGETC.ASI		; Balayage clavier
	.ENDIF	SM100.or.COS21.or.SM196.OR.SM300.or.sm130

	.IF	SM130.AND.K1
	.INS	KEYK1.ASI
	.ENDIF	SM130.AND.K1


	.IF	COS20
TXUSALOG:	.ASCIZ	""
TXUSAPHYS:	.ASCIZ	"$USART_0"	; #MI, canal B du 68681
TXUSAPARAM:	.ASCIZ	"*"
		.EVEN
	.ENDIF	COS20



	.END
