\define g_Fond:\nef11;
\define g_ev:\n(bf)09;
\define g_titre:\m(f)17;
\define g_it:\n(if)07;
; $sma; $flg:25010002 $erh:MEM

	.TITLE 		\g_titre;MEM.ASD\g_Fond;		; pilote pour SMILEC - ASCALM
debug	=	false
	.LISTIF

	.Macro		TrapErr
	.LocalMacro	Bon

	jump,eq		r8^Bon
	Trap		#1
Bon:

	.EndMacro

\g_titre;;*****************************
;* Pilote de gestion mmoire *
;*****************************
\g_Fond;;
; utilisation:
;	installation du pilote:		install #MEM $MEM (nom_fichier.disk)
;	chargement d'un fichier:	command #MEM LNomDuFichier
;	suppression d'un fichier:	command #MEM KNomDuFichier
;	init. fichier dj en mmoire:	command #MEM I[dbut.L][long.L]NomDuFichier
;	init. fichier donn par routine:command #MEM R[routine.L][long.L][ref.W]NomDuFichier
;	init. fichier ecrit.lib:	commnad #MEM D[routine.L][long.L][ref.W][var.L]NomDuFichier
;		Cette dernire fonction a t prvue pour ECRIT.CODE,
;		la routine (RDBLOC) reois A6=var et D1=ref
;

	.PROC		M68000			; CALM
	.REF		SMAKY			; Table de symboles...
	.REF		BIOSDRIV
	.REF		BIOS
	.REF		Mon

MAJREV		= 	6			; Revision majeur
MINREV		= 	10			; Revision mineur

	.REV		MAJREV,MINREV		; Met revision dans entte binaire
	.IDENT		"Pilote MEM pour SMILEC. D.Dumoulin 89"


PcCode		=	1
PcDef		=	2
Controle	=	16'81234567
TailleMax	=	0			; pour information sur RSTATUS


\g_ev;; Dfinition des tampons dynamiques
; ---------------------------------
\g_Fond;
	.LOC		0
oEntPtPetit:	.blk.32		1	; ^tranche infrieure
oEntPtGrand:	.blk.32		1	; ^tranche suprieure
oEntLong:	.blk.16		1	; nombre de blocs
oEntFlag:	.blk.8		2	; fanions
oEntMAP:	.blk.32		1	; bit-map blocs utilis
oEntPtData:	.blk.32		1	; ^donnes de la tranche ou adr. routine (R)
oEntNumro:	.blk.32		1	; no de bloc pour recherche
oEntPrecedent:	.blk.32		1	; ^prcdent pour dchainage
oEntDbut:	.blk.16		1	; position dbut de tranche dans fichier
oEntRfrence:	.blk.16		1	; valeur de rfrence
oEntPtVArA6:	.blk.32		1	; ^variables A6 pour routine user
		.blk.32		3	; rserve
lgEntte:
	; ne pas modifier la longueur (imcompatibilit des fichiers disques)

\g_ev;; Dfinition des variables permanentes
; ------------------------------------
\g_Fond;
	.APC		PcDef
	.LOC		0
oPtBase:	.blk.32		1		; ^base chanage blocs
oPtGesmem:	.blk.32		1		; compte mmoire oTYPBD
oPtSema:	.blk.32		1		; smaphore d'exclusion
oLgUtilis:	.blk.32		1		; nombre de blocs utiliss
oFlg:		.blk.16		1		; fanions
 bOldDisk	=	0			; vieux fichier .DISK
LgVar0:						; longueur pour un pilote
LgVar	= 4*LgVar0				; longueur pour les 4 pilotes
\g_ev;
\g_Fond;
	.APC		PCCODE
	.LOC		0
BASE:
	.16		0,D0BASE		; Add fin entte driver
	.16		1,D1BASE		; Add fin entte driver
	.16		2,D2BASE		; Add fin entte driver
	.16		3,D3BASE		; Add fin entte driver
	.16		2**7


\g_titre;;****************
;  Pilote $MEM_0 
;****************
\g_Fond;
D0ID:		\g_titre;		\g_Fond;		; Offset routine :
	.16		D0OPEN-D0BASE		; Open
	.16		D0COMMAND-D0BASE	; Command
	.16		D0RSTATUS-D0BASE	; Read status
	.16		D0READ-D0BASE		; Read
	.16		D0WRITE-D0BASE		; Write
	.16		D0CLOSE-D0BASE		; Close
	.16		-1			; Stop
	.16		-1			; Start
	.16		-1			; Avort
	.16		-1			; Auxiliaire 1
	.16		D0ACTION-D0BASE		; Auxiliaire 2
	.16		D0RESET-D0BASE		; Reset
	.16		D0KILL-D0BASE		; Kill
	.16		-1			; 
	.16		-1			; 
	.16		-1			; 
D0NAB:
	.ASCII		"MEM_0"			; Nom driver
D0NAF:	.FILL.8 	LGDNAM-(D0NAF-D0NAB), 0	; Rempli le reste avec des 0
	.8		16'68			; Numro driver ($MEM 68..6B)
	.8		TYPMM			; Type : mmoire de masse
	.8		MAJREV,MINREV		; Rvision - version
	.8		0			; Priorit dans pilote
	.8		0			; no bios high

	.8		0			; Attribut 1
;	.8		2**BDRDOK+2**BDWROK+2**BDNORT
	.8		2**BDRDOK+2**BDWROK	; Attribut 0
	.FILL.8		LGDDESC-(APC-D0ID), 0	; Le reste avec des 0
D0BASE:



\g_ev;; Dfinition tampon travail
; -------------------------

\g_Fond;LgTravail	=	100
	.APC		PcDef
	.LOC		0
oNomFichier:	.blk.8		LgName		; place pour nom
oNomTravail:
oArguments:	.blk.8		LgARGS		; argument
oNomMEM:	.blk.8		D0NAF-D0NAB+2	; place pour $MEM_0:
oNomCreate:	.blk.8		LgName
	.LOC		256			; pour tampon travail consquent
LgTampon:

	.APC		PCCODE


\g_titre;;****************
;  Pilote $MEM_1 
;****************
\g_Fond;
D1ID:		\g_titre;		\g_Fond;		; Offset routine :
	.16		D1OPEN-D1BASE		; Open
	.16		D1COMMAND-D1BASE	; Command
	.16		D1RSTATUS-D1BASE	; Read status
	.16		D1READ-D1BASE		; Read
	.16		D1WRITE-D1BASE		; Write
	.16		D1CLOSE-D1BASE		; Close
	.16		-1			; Stop
	.16		-1			; Start
	.16		-1			; Avort
	.16		-1			; Auxiliaire 1
	.16		D1ACTION-D1BASE		; Auxiliaire 2
	.16		D1RESET-D1BASE		; Reset
	.16		D1KILL-D1BASE		; Kill
	.16		-1			; 
	.16		-1			; 
	.16		-1			; 
D1NAB:
	.ASCII		"MEM_1"			; Nom driver
D1NAF:	.FILL.8 	LGDNAM-(D1NAF-D1NAB), 0	; Rempli le reste avec des 0
	.8		16'69			; Numro driver ($MEM 68..6B)
	.8		TYPMM			; Type : mmoire de masse
	.8		MAJREV,MINREV		; Rvision - version
	.8		0			; Priorit dans pilote
	.8		0			; no bios high

	.8		0			; Attribut 1
;	.8		2**BDRDOK+2**BDWROK+2**BDNORT
	.8		2**BDRDOK+2**BDWROK	; Attribut 0
	.FILL.8		LGDDESC-(APC-D1ID), 0	; Le reste avec des 0
D1BASE:


\g_titre;;****************
;  Pilote $MEM_2 
;****************
\g_Fond;
D2ID:		\g_titre;		\g_Fond;		; Offset routine :
	.16		D2OPEN-D2BASE		; Open
	.16		D2COMMAND-D2BASE	; Command
	.16		D2RSTATUS-D2BASE	; Read status
	.16		D2READ-D2BASE		; Read
	.16		D2WRITE-D2BASE		; Write
	.16		D2CLOSE-D2BASE		; Close
	.16		-1			; Stop
	.16		-1			; Start
	.16		-1			; Avort
	.16		-1			; Auxiliaire 1
	.16		D2ACTION-D2BASE		; Auxiliaire 2
	.16		D2RESET-D2BASE		; Reset
	.16		D2KILL-D2BASE		; Kill
	.16		-1			; 
	.16		-1			; 
	.16		-1			; 
D2NAB:
	.ASCII		"MEM_2"			; Nom driver
D2NAF:	.FILL.8 	LGDNAM-(D2NAF-D2NAB), 0	; Rempli le reste avec des 0
	.8		16'6A			; Numro driver ($MEM 68..6B)
	.8		TYPMM			; Type : mmoire de masse
	.8		MAJREV,MINREV		; Rvision - version
	.8		0			; Priorit dans pilote
	.8		0			; no bios high

	.8		0			; Attribut 1
;	.8		2**BDRDOK+2**BDWROK+2**BDNORT
	.8		2**BDRDOK+2**BDWROK	; Attribut 0
	.FILL.8		LGDDESC-(APC-D2ID), 0	; Le reste avec des 0
D2BASE:



\g_titre;;****************
;  Pilote $MEM_3
;****************
\g_Fond;
D3ID:		\g_titre;		\g_Fond;		; Offset routine :
	.16		D3OPEN-D3BASE		; Open
	.16		D3COMMAND-D3BASE	; Command
	.16		D3RSTATUS-D3BASE	; Read status
	.16		D3READ-D3BASE		; Read
	.16		D3WRITE-D3BASE		; Write
	.16		D3CLOSE-D3BASE		; Close
	.16		-1			; Stop
	.16		-1			; Start
	.16		-1			; Avort
	.16		-1			; Auxiliaire 1
	.16		D3ACTION-D3BASE		; Auxiliaire 2
	.16		D3RESET-D3BASE		; Reset
	.16		D3KILL-D3BASE		; Kill
	.16		-1			; 
	.16		-1			; 
	.16		-1			; 
D3NAB:
	.ASCII		"MEM_3"			; Nom driver
D3NAF:	.FILL.8 	LGDNAM-(D3NAF-D3NAB), 0	; Rempli le reste avec des 0
	.8		16'6B			; Numro driver ($MEM 68..6B)
	.8		TYPMM			; Type : mmoire de masse
	.8		MAJREV,MINREV		; Rvision - version
	.8		0			; Priorit dans pilote
	.8		0			; no bios high

	.8		0			; Attribut 1
;	.8		2**BDRDOK+2**BDWROK+2**BDNORT
	.8		2**BDRDOK+2**BDWROK	; Attribut 0
	.FILL.8		LGDDESC-(APC-D3ID), 0	; Le reste avec des 0
D3BASE:




\g_titre;;***********************
; Code des pilotes $MEM
;***********************
\g_Fond;

	.APC		PCCODE


\g_titre;;--------------\
;     RESET     >
;--------------/
\g_Fond;
; in	A2.32	^paramtres ligne de commande (fichier)
; out	A6.32	^variable du pilote (#n)
;	D7.16	Erreur
; mod	D0.32 , D1.32 , D7.16 , A0.32 , A1.32, A6.32

D0\g_ev;RESET\g_Fond;:
	move.32		#0, D0
	jump		r8^Reset
D1\g_ev;RESET\g_Fond;:
	move.32		#1, D0
	jump		r8^Reset
D2\g_ev;RESET\g_Fond;:
	move.32		#2, D0
	jump		r8^Reset
D3\g_ev;RESET\g_Fond;:
	move.32		#3, D0
\g_ev;Reset\g_Fond;:
	pushm.32	A2..A5|D4|D1

	move.32		#r16^BASE, A4				; ^base du pilote
	move.32		#lgVAR, D4				; longueur variables locales
	\g_ev;FOS		?GetComMem\g_Fond;				; demande la zone au FOS
	jump,ne		ERR$
	move.32		A4, A6					; A6.32 ^permanent au variables
	move.16		D0, D4
	mul.16		#LgVar0, D4
	add.32		D4, A6					; ^permanent sous-pilote
	mul.16		#lgDDesc, D0
	move.32		#r16^D0Base, A1
	add.32		D0, A1					; ^entte nime pilote
	move.32		A1, {A6}+oPtGesmem			; pour ?GETMEM
	clr.32		{A6}+oPtBase

	move.16		#1, d4
	\g_ev;Ntrel		?CreSem\g_Fond;
	jump,ne		Err$
	move.32		A5, {A6}+oPtSema			; pour exclusion chanes

	comp.32		#0, A2
	jump,eq		r8^NoParam$
	test.8		{A2}
	jump,eq		r8^NoParam$
	call		\g_ev;LoadDisk\g_Fond;				; charge le fichier .DISK
	jump		Err$
NoParam$:
	move.32		#2*lgBLK+LgEntte, D4
	move.32		#MtypBD, D1
	\g_ev;GesMem		?GetMem\g_Fond;					; demande la mmoire pour DB+BL
	jump,ne		Err$

	move.32		#2, {A6}+oLgUtilis			; 2 blocs utiliss

	\g_ev;GesMem		?ClearMem\g_Fond;				; vide tout

	move.32		A4, {A6}+oPtBase			; garde le ^base

	move.16		#3, {A4}+oEntLong			; nombre de blocs (#0,#1,#2)
	move.32		#2'111, {A4}+oEntMAP			; 3 blocs dans le MAP
	move.32		#{A4}+LgEntte-lgBLK, A2		; position imaginaire du bloc 0
	move.32		A2, {A4}+oEntPtData			; ^donnes de la tranche

	move.32		#{A4}+LgEntte, A2			;\g_ev; Construit le BD #1\g_Fond;
								; \g_ev;dj format !
\g_Fond;	move.32		A1, D0
	xor.32		#Contrle, D0
	move.32		D0, {A2}+oBDCHK				; init valeur de contrle
	move.16		#1, {A2}+oBDNPT				; 1 pointeur
	move.32		#2, {A2}+oBDPTS				; valeur du pointeur
	move.8		#1, {A2}+oBDNBS				; nombre de bloc de ce fichier
	move.16		#LgBLK, {A2}+oBDLST			; dernier bloc tout plein
	move.16		#1, {A2}+oBDHAC				; fonction de hachge
	move.16		#1, {A2}+oBDNBL				; 1 seul bloc de liste

	move.32		#{A4}+LgEntte+LgBLK, A2		; \g_ev;Construit le BL #2
\g_Fond;								; \g_ev;contenant dj SYS_LIST\g_Fond;
	move.32		D0, {A2}+oBLCHK				; contrle d'un BL
	move.32		#r16^nSYS_LIST, A1
	move.32		#{A2}+OBLNAM, A3			; place pour nom SYS_LIST
c$:
	move.8		{A1+}, {A3+}				; copie le nom
	jump,ne		c$
	move.32		#1, {A2}+oBLPT				; ^BD de sys_list
	move.32		#DEFATT+2**BATTP-2**BATTD, {A2}+oBLATT	; attribut pour dossier

ERR$:
	popm.32		A2..A5|D4|D1
	RET

nSYS_LIST:
	.ascize		"SYS_LIST"


\g_titre;;--------------\
;     KILL      >
;--------------/
\g_Fond;
; in	A6.32	^variables du pilote
; out	D7.16	Erreur
; mod	D0.32 , D1.32 , D7.16 , A0.32 , A1.32

D0\g_ev;KILL\g_Fond;:
D1\g_ev;KILL\g_Fond;:
D2\g_ev;KILL\g_Fond;:
D3\g_ev;KILL\g_Fond;:
	pushm.32	A5
	move.32		{A6}+oPtSema, A5
	\g_ev;Ntrel		?KillSem\g_Fond;
	popm.32		A5
	clr.16		D7		; NTREL rend la mmoire
	RET


\g_titre;;--------------\
;     OPEN      >
;--------------/
\g_Fond;
; in	A6.32	^variables du pilote
; out	D7.16	Erreur
; mod	D0.32 , D1.32 , D7.16 , A0.32 , A1.32

D0\g_ev;OPEN\g_Fond;:
D1\g_ev;OPEN\g_Fond;:
D2\g_ev;OPEN\g_Fond;:
D3\g_ev;OPEN\g_Fond;:
	clr.16		D7
	RET
\g_ev;
\g_titre;;--------------\
;     CLOSE     >
;--------------/
\g_Fond;; referme le pilote

; in	A6.32	^variables du pilote
; out	D7.16	Erreur
; mod	D0.32 , D1.32 , D7.16 , A0.32 , A1.32

D0\g_ev;CLOSE\g_Fond;:
D1\g_ev;CLOSE\g_Fond;:
D2\g_ev;CLOSE\g_Fond;:
D3\g_ev;CLOSE\g_Fond;:
	clr.16		D7
	RET


\g_titre;;--------------\
;    RSTATUS    >
;--------------/
\g_Fond;
; in	A6.32	^variables du pilote
;	A4.32	^tampon  remplir
;	D4.32	longueur voulue
; out	D4.32	longueur rendue
;	D7.16	erreur
; mod	D0..A1.32, D4.32, D7.16

D0\g_ev;RSTATUS\g_Fond;:
D1\g_ev;RSTATUS\g_Fond;:
D2\g_ev;RSTATUS\g_Fond;:
D3\g_ev;RSTATUS\g_Fond;:
; partie rcupre ....
	comp.32		#2, D4			; lecture de la rvision ?
	jump,ne		r8^rs$
	move.16		#MajREV*16'100+MinREV, {A4}
	clr.16		D7			; c'est tout bon
	Ret
rs$:
; .....................
	move.32		#r16^LONGS$, A0
	call		\g_ev;32^_CNVLGS\g_Fond;			; contrle longueur possible
	jump,ne		ERR$
	\g_ev;GESMEM		?CLEARMEM\g_Fond;			; vide tout

	move.8		#MTRAM, {A4}+OMTYPE		; type \g_ev;mmoire de masse
\g_Fond;	move.32		#TailleMax, {A4}+OMNBLK		; nombre de blocs illimit !
	comp.16		#LGMAM2, D4
	jump,ls		r8^ERR$
	move.32		#TailleMax, {A4}+OMTBLK		; nombre total de blocs
ERR$:
	Ret

LONGS$:
	.16		LGMAM0
	.16		LGMAM1
	.16		LGMAM2
	.16		0



\g_titre;;--------------\
;    COMMAND    >
;--------------/
\g_Fond;
; in	A6.32	^variables du pilote
;	A4.32	^ligne de commande
; out	D7.16	erreur
; mod	D0..A1.32, D4.32, D7.16

D0\g_ev;COMMAND\g_Fond;:
D1\g_ev;COMMAND\g_Fond;:
D2\g_ev;COMMAND\g_Fond;:
D3\g_ev;COMMAND\g_Fond;:
	; pas de push
	move.8		{A4}, D0
	comp.8		#"L", D0		; chargement d'un fichier
	jump,eq		\g_ev;LoadFile\g_Fond;
	comp.8		#"K", D0		; suppression d'un fichier
	jump,eq		\g_ev;KillFile\g_Fond;
	comp.8		#"I", D0		; initialisation d'un fichier
	jump,eq		\g_ev;InitFile\g_Fond;
	comp.8		#"J", D0		; initialisation d'un fichier WRPROTECT
	jump,eq		\g_ev;InitFileWP\g_Fond;
	comp.8		#"R", D0		; fichier donne par routine user
	jump,eq		\g_ev;RoutFile\g_Fond;
	comp.8		#"D", D0		; idem avec A6 donn
	jump,eq		\g_ev;RoutFile2\g_Fond;
	comp.8		#"S", D0		; sauve le ramdisk sur mm
	jump,eq		\g_ev;SaveDisk\g_Fond;

	move.16		#erCOMA, D7		; commande inconnue
	Ret



\g_titre;;--------------\
;    ACTION     >
;--------------/
\g_Fond;
; in	A6.32		^variables du pilote
;	D5.32		Numro de la demande
;	D3.32, D4.32	Selon demande
; out	D7.16	erreur
;	D3.32, D4.32	Selon demande
; mod	D0..A1.32, D4.32, D7.16

D0\g_ev;ACTION\g_Fond;:
D1\g_ev;ACTION\g_Fond;:
D2\g_ev;ACTION\g_Fond;:
D3\g_ev;ACTION\g_Fond;:
	comp.16		#1, D5			; rservation
	jump,eq		\g_ev;GetPre\g_Fond;
	comp.16		#2, D5			; annulation
	jump,eq		\g_ev;ClrPre\g_Fond;
	comp.16		#3, D5			; ?DISK
	jump,eq		\g_ev;InfoDisk\g_Fond;
	move.16		#ERILOP, D7
	Ret

\g_titre;;--------------\
;     READ      >
;--------------/
\g_Fond;
; in	A6.32		^variables du pilote
;	A4.32		^tampon  remplir
;	D4.32		No du premier bloc
;	D5.32		nombre de blocs  lire
; out	D5.32		nombre de blocs lus
;	D7.16		Erreur
; mod	D0..A1 , D4.32 ,  D7.16

D0\g_ev;READ\g_Fond;:
D1\g_ev;READ\g_Fond;:
D2\g_ev;READ\g_Fond;:
D3\g_ev;READ\g_Fond;:
.if	Debug
.16	?aftim
.ascize	"<tab>RD "
.16	?afx8
ex.32	d4,d5
.16	?afspace, ?afx4
ex.32	d4,d5
.endif
	pushm.32	A4|D4|A1|D5|A6	; \g_ev;ATTENTION\g_Fond; idem READ / WRITE / CALLROUTINE
	test.32		D5			; aucun bloc demand ?
	jump,eq		NOP$

	test.32		D4			; lecture du bloc 0 ?
	jump,ne		r8^BD1$

	move.32		#LGBLK, D4
	\g_ev;GESMEM		?ClearMem\g_Fond;		; vide le tampon utilisateur
	add.32		#LGBLK, A4		; ^suite
	move.32		#1, D4			; no bloc suivant
	dec.32		D5			
	jump,eq		NOP$
BD1$:
	call		\g_ev;ChercheA0\g_Fond;		; A0.32 ^lment selon D4
	jump,ne		r8^Nop$			; A1.32 ^donnes associe

	move.16		#0, D0			; signale lecture
	test.8		{A0}+oEntFlag
	jump,ns		r8^\g_ev;CallRoutine\g_Fond;		; appelle la routine utilisateur

	call		\g_ev;CopieA1toA4\g_Fond;
NOP$:
.if	debug
.16	?aftim
.ascize	" eRD"
.endif
	popm.32		A4|D4|A1|D5|A6
	RET



\g_titre;;--------------\
;    WRITE      >
;--------------/
\g_Fond;
; in	A6.32		^variables du pilote
;	A4.32		^aux donnes  crire
;	D4.32		No du premier bloc  crire
;	D5.32		Nombre de blocs  crire
; out	D5.32		Nombre de blocs crits
;	D7.16		Erreur
; mod	D0.32 , D1.32 , D7.16 , A0.32 , A1.32

D0\g_ev;WRITE\g_Fond;:
D1\g_ev;WRITE\g_Fond;:
D2\g_ev;WRITE\g_Fond;:
D3\g_ev;WRITE\g_Fond;:
.if	debug
.16	?aftim
.ascize	"<cr>WR "
.16	?afx8
ex.32	d4,d5
.16	?afspace, ?afx4
ex.32	d4,d5
.endif
	pushm.32	A4|D4|A1|D5|A6	; \g_ev;ATTENTION\g_Fond; idem READ / WRITE / CALLROUTINE
	test.32		D5			; aucun bloc  crire ?
	jump,eq		NOP$

;	move.16		#erMWPR, D7		; protg  l'criture !
;	test.8		{A6}+oFlg:#bOldDisk	; si ancien fichier.DISK
;	jump,bs		r8^Nop$

	test.32		D4			; criture du bloc 0 ?
	jump,ne		r8^BD1$

	add.32		#LGBLK, A4		; ^suite
	move.32		#1, D4			; no bloc suivant
	dec.32		D5			
	jump,eq		NOP$
BD1$:
	call		\g_ev;ChercheA0\g_Fond;		; A0.32 ^lment
	jump,ne		r8^Nop$			; A1.32 ^donnes
Bon$:
	move.16		#-1, D0			; signale criture
	test.8		{A0}+oEntFlag
	jump,ns		r8^\g_ev;CallRoutine\g_Fond;		; appel la routine utilisateur
	jump,eq		r8^wr$
	move.16		#ERATTW, D7		; criture interdite sur ce fichier
	jump		r8^nop$
wr$:
	ex.32		A1, A4
	call		\g_ev;copieA1toA4\g_Fond;
Nop$:
	popm.32		A4|D4|A1|D5|A6	; \g_ev;ATTENTION\g_Fond; idem READ / WRITE / CALLROUTINE
.if	debug
.16	?aftim
.ascize	" eWR"
.endif
	test.16		d7
	RET



; Appel de la routine utilisateur (commande R ou D)
; in	D4.32		no du premier bloc  traiter
;	D5.32		nombre de blocs  traiter
;	D0.8		mode (#0=lecture, #-1=criture)
;	D1.16		rfrence selon commande
;	A6.32		^var si commande "D"
; out	D7.16		erreur (?)
;			ne pas signaler #erOUTF

\g_ev;CallRoutine\g_Fond;:
	move.16		{A0}+oEntRfrence, D1	; no rfrence
	move.32		{A0}+oEntPtVarA6, A6	; ^variables  transmettre
	and.32		#16'FF, D4		; garde l'offset
	add.16		{A0}+oEntDbut, D4	; position dans le fichier
	move.32		{A0}+oEntPtData, A0	; ^routine utilisateur
	call		{A0}			; appelle la routine user
	popm.32		A4|D4|A1|D5|A6	; \g_ev;ATTENTION\g_Fond; idem READ / WRITE / CALLROUTINE
	Ret

\g_ev;CopieA1toA4\g_Fond;:
	move.32		A1, D0
	test.32		D0:#0
	jump,bs		r8^CopieOctet
	move.32		A4, D0
	test.32		D0:#0
	jump,bs		r8^CopieOctet

	mul.16		#LgBlk/4, D5		; longueur en longs mots
	dec.16		D5
Copie$:
	move.32		{A1+}, {A4+}		; copie les donnes
	dj.16,nmo	D5, Copie$
	Ret

CopieOctet:
	mul.16		#LgBlk, D5		; longueur en octets
	dec.16		D5
Copie$:
	move.8		{A1+}, {A4+}		; copie les donnes
	dj.16,nmo	D5, Copie$
	Ret



\g_titre;; ROUTINES
; ========
\g_Fond;

\g_ev;; COMMANDES SPECIALES

\g_titre;;----------\
; LoadDisk  >
;==========/
\g_Fond;; charge un fichier .DISK en mmoire
;
; in	A2.32		^nom du fichier
; out	D7.16		erreur

\g_ev;
LoadDisk:
\g_Fond;	comp.8		#2**7+"@", {A2}
	jump,eq		\g_ev;LoadRomDisk\g_Fond;

	pushm.32	A3|A4|D3|D4|D1|A1|D6
	move.32		A2, A3
	move.32		#2**BopRD, D3
	\g_ev;Fos		?Open\g_Fond;				; ouvre le fichier .DISK
	jump,ne		Ret$

	clr.32		D3
	move.32		#-1, D4
	\g_ev;Fos		?Spos\g_Fond;				; positionne  la fin out D4.32 longueur

	move.32		{A6}+oPtGesmem, A1
	move.32		#MtypBD, D1
	\g_ev;GesMem		?Getmem\g_Fond;				; demande la mmoire pour tout le fichier
	jump,ne		r8^close$

	push.32		d4
	clr.32		d4
	\g_ev;Fos		?Spos\g_Fond;
	pop.32		d4

	\g_ev;Fos		?RdByte\g_Fond;				; lit tout le fichier
	jump,ne		r8^Giv$

	move.32		r16^patern, d3
	comp.32		{A4}, d3			; fichier .DISK ancienne version ?
	call		\g_ev;AjouteDisk\g_Fond;			; ajoute les tranches
	jump,eq		r8^Close$
giv$:
	\g_ev;GesMem		?GivMem\g_Fond;
TrapErr
close$:
	push.16		d7
	\g_ev;Fos		?close\g_Fond;
	pop.16		d7
Ret$:
	popm.32		A3|A4|D3|D4|D1|A1|D6
	Ret

patern:	.ascii		"*** "		; dbut d'un vieux .DISK

\g_ev;LoadRomDisk\g_Fond;:
	Pushm.32	A4|D3|D4
	move.32		{A2}+1, A4			; ^donne en Rom
	move.32		{A2}+1+4, D4			; longueur

	move.32		r16^patern, d3
	comp.32		{A4}, d3			; fichier .DISK ancienne version ?
	call		\g_ev;AjouteRomDisk\g_Fond;			; ajoute les tranches
	Popm.32		A4|D3|D4
	Ret


\g_titre;;----------\
; LoadFile  >
;==========/
\g_Fond;; charge un fichier dans la liste, en prenant les donnes sur disque (#:)
;
; in	A4.32		^commande
; out	D7.16		erreur

\g_ev;LoadFile\g_Fond;:
	pushm.32	A0..A5|D1..D6
	move.32		#{A4}+1, A3			; ^nom du fichier

	\g_ev;Fos		?What\g_Fond;				; vrifie la syntaxe
	jump,ne		Ret$

	move.32		#LgTampon, d4
	move.32		#mtypCP, D1
	\g_ev;Gesmem		?Getmem\g_Fond;				; petit tampon travail
	jump,ne		ret$
	move.32		A4, d2				; ^mmoire  rendre

	move.32		#{A4}+oNomTravail, A2

	comp.8		#"#", {A3}			; unit prcise ?
	jump,ne		r8^a$
	comp.8		#":", {A3}+1			; "#:" devant le nom
	jump,ne		r8^CopyFichier$
	add.32		#2, A3
	jump		r8^b$
a$:
	comp.8		#"@", {A3}			; rseau donn ?
	jump,eq		r8^CopyFichier$
	comp.8		#"$", {A3}			; unit phys ?
	jump,eq		r8^CopyFichier$
b$:
	pushm.32	A2..A4
	move.32		A2, A4
	move.32		A3, A2
	call		\g_ev;NomFichierRam\g_Fond;			; nom du fichier dans $MEM
	\g_ev;Fos		?ARGS\g_Fond;				; existe dj dans le disque ?
	popm.32		A2..A4
	jump,eq		GivMem$

	push.32		A3
	move.8		#"(", {A2+}			; prpare les options
	clr.16		D4
	\g_ev;Fos		?GSDIR\g_Fond;				; gre soit-mme le dossier systme
CopySDIR$:
	move.8		{A3+}, {A2+}			; copie le dossier systme
	jump,ne		CopySDIR$

	move.8		#",", {A2}-1

	\g_ev;Fos		?GDIR\g_Fond;				; gre aussi dossier user
CopyDIR$:
	move.8		{A3+}, {A2+}			; copie le dossier systme
	jump,ne		CopyDIR$

	move.8		#")", {A2}-1
	pop.32		A3

CopyFichier$:
	move.8		{A3+}, {A2+}			; copie le nom du fichier donn
	jump,ne		CopyFichier$

	move.32		#{A4}+oNomTravail, A3		; revient sur le nom
	move.32		#{A4}+oNomFichier, A2		; ^nom du fichier retourn
clr.32		{A2}+4*0
clr.32		{A2}+4*1
clr.32		{A2}+4*2
clr.32		{A2}+4*3
	move.32		#{A4}+oArguments, A4		; retourne les ARGS  la place du tampon
	move.32		#LGNAME, D4			; longueur du nom retourn
	move.32		#2**BopRD+2**BopARGS+2**BopEXTEND+2**BopNAME+2**BopnoDIR, D3
							; mode avec attributs
	\g_ev;FOS		?ARGSOPEN			\g_Fond;; ouvre le fichier
	jump,ne		Giv$

	move.32		A2, A3
	call		\g_ev;CreeFichier\g_Fond;			; fichier dj en mmoire ?
	jump,ne		Close$

	move.32		{A3}+oBLLG, D3			; longueur fichier en blocs
	move.32		D3, D5				; nb de blocs  lire
	inc.32		D3				; plus pour BD
	call		\g_ev;GetPre\g_Fond;				; demande prrservation
	jump,ne		Close$

	move.32		D4, {A3}+oBLPT			; ^BD pour SYS_LIST
	call		\g_ev;CorrigeFichier\g_Fond;			; modifie le fichier dans SYS_LIST
	jump,ne		Close$

	call		\g_ev;ChercheA0\g_Fond;			; donne ^donnes rserve (BD)
	jump,ne		Close$

	move.32		A1, A5				; ^BD  construire
	call		\g_ev;InitBD\g_Fond;				; initialise le BD
	move.16		{A3}+oBLLGB, {A5}+OBDLST	; ajoute nb d'octet dans dernier bloc
	jump,ne		r8^o$
	move.16		#LgBlk, {A5}+OBDLST
o$:

	dec.32		D3				; un de moins
	inc.32		D4				; no suivant
	add.32		#LgBLK, A1			; blocs suivant
Loop$:
	call		\g_ev;AjoutBD				\g_Fond;; ajoute la tranche dans le BD
	move.32		A1, A4
	move.16		D3, D4
	jump,eq		Close$
	mul.16		#lgBlk, D4
	\g_ev;Fos		?RdByte\g_Fond;				; lit les donnes en place
	jump,ne		Close$

	sub.32		D3, D5				; reste  lire
	jump,eq		r8^Close$
	move.32		D5, D3
	call		\g_ev;GetPre				\g_Fond;; rserve une nouvelle tranche
	jump,ne		r8^Close$
	call		\g_ev;ChercheA0			\g_Fond;; donne le ^donnes
	jump,eq		Loop$
Close$:
	push.16		D7
	\g_ev;Fos		?Close
\g_Fond;	pop.16		D7
	comp.16		#erOUTF, D7			; erreur normale ?
	jump,ne		r8^Giv$
	clr.16		D7
Giv$:
	move.32		d2, a2
	move.32		#{A2}+oNomTravail, A4
	move.32		A4, A2				; reprend le nom copi
	call		\g_ev;NomFichierRam\g_Fond;			; ajoute $MEM_x:
	push.16		d7
	jump,eq		r8^Bien$
	move.32		#DefAtt, D3
	\g_ev;Fos		?Chatr, ?Delete\g_Fond;		; dtruit le fichier en chargement
	jump		r8^gm$
Bien$:
	move.16		#2**bOpWr+2**bOpRd, D3
	\g_ev;Fos		?Open, ?Close\g_Fond;			; met  jour heures et dates
gm$:
	pop.16		d7
GivMem$:
	push.16		d7
	move.32		#MtypCP, D1
	move.32		d2, A4
	\g_ev;Gesmem		?GivMem\g_Fond;				; rend la mmoire du tampon
TrapErr
	pop.16		d7
Ret$:
	popm.32		A0..A5|D1..D6
	Ret



\g_titre;;----------\
; KillFile  >
;==========/
\g_Fond;; Supprime un fichier de la liste interne
;
; in	A4.32		^commande
; out	D7.16		erreur
;
\g_ev;KillFile\g_Fond;:
	pushm.32	A2..A4|D1|D3|D4
	move.32		#{A4}+1, A2			; ^nom du fichier  tuer

	move.32		#LgTampon, D4
	move.32		#MtypCP, D1
	\g_ev;GesMem		?Getmem\g_Fond;				; demande un petit tampon
	jump,ne		r8^Ret$

	call		\g_ev;NomFichierRam\g_Fond;			; out A3.32 ^nom du fichier dans $RAM

	move.32		#DEFATT, D3
	\g_ev;Fos		?Chatr, ?Delete\g_Fond;		; dtruit normalement
	push.16		d7
	\g_ev;Gesmem		?GivMem\g_Fond;
TrapErr
	pop.16		d7
Ret$:
	popm.32		A2..A4|D1|D3|D4
	Ret


\g_titre;;----------\
; InitFile  >
;==========/
\g_Fond;; ajoute un fichier dans la liste, donn par ^origine et longueur (+longueur maxi)
;
; in	A4.32		^commande
; out	D7.16		erreur

\g_ev;InitFile\g_Fond;:
	clr.8		D0
	jump		r8^InitF


; ajoute un fichier dans la liste, donn par ^origine et longueur (+longueur maxi)
;
; in	A4.32		^commande
; out	D7.16		erreur

\g_ev;InitFileWP\g_Fond;:
	move.8		#1, D0
	jump		r8^InitF


\g_titre;;----------\
; RoutFile  >
;==========/
\g_Fond;; ajoute un fichier dans la liste, donn par ^routine et longueur
;
; in	A4.32		^commande
; out	D7.16		erreur (#1  #maxFile ok -> numro du fichier)

RoutFile2:
	move.8		#16'80, D0
	jump		r8^InitF

\g_ev;RoutFile\g_Fond;:
	set.8		D0		; #-1

InitF:
	pushm.32	A0..A5|D1..D6
	sub.32		#4*4, SP			; place pour 3 paramtres

	inc.32		A4
	call		getX8				; ^dbut du fichier / routine
	move.32		D4, {SP}+0
	call		getX8				; longueur originale
	move.32		D4, {SP}+4
	clr.32		D4
	test.8		D0
	jump,nc		r8^n$
	call		getX4				; rfrence
n$:
	move.16		D4, {SP}+8

	clr.32		D4
	comp.8		#16'80, D0
	jump,ne		r8^nn$
	call		GetX8
nn$:
	move.32		D4, {Sp}+12

	move.32		A4, A3				; ^nom du fichier
	\g_ev;Fos		?What\g_Fond;				; vrifie la syntaxe
	jump,ne		Ret$

	move.32		#LgTampon, d4
	move.32		#mtypCP, D1
	\g_ev;Gesmem		?Getmem\g_Fond;				; petit tampon travail
	jump,ne		ret$
	move.32		A4, d5				; ^mmoire  rendre

	\g_ev;Gesmem		?ClearMem\g_Fond;			; initialise les arguements
	move.32		#{A4}+oNomFichier, A2
	move.32		#LgName, D4
	move.32		#2**BOPNAME+2**BOPNDIR+2**BOPnoDIR+2**BOPEXTEND, D3
\g_ev;	Fos		?ArgsOpen\g_Fond;			; ne veut que le vrai nom
	jump,ne		Giv$

	move.32		#DEFATT+2**30, {A4}+oArguments+oBAATT	; attributs par dfaut
	move.32		{SP}+4, D4
	move.32		D4, {A4}+oArguments+oBALGF	; longueur du fichier
	move.8		D4, {A4}+oArguments+oBALGB+1	; nombre dans dernier bloc
	jump,ne		r8^cre$
	move.16		#lgBLK, {A4}+oArguments+oBALGB	; tout plein
cre$:
	add.32		#lgBLK-1, D4
	sr.32		#8, D4
	move.32		D4, {A4}+oArguments+oBALG	; longueur en blocs

	move.32		#{A4}+oNomFichier, A3
	call		\g_ev;CreeFichier\g_Fond;			; fichier dj en mmoire ?
	jump,ne		Close$

	move.32		#1, D3				; rserve pour BD
	call		\g_ev;GetPre\g_Fond;				; demande prrservation
	jump,ne		Close$

	move.32		D4, {A3}+oBLPT			; ^BD pour SYS_LIST
	call		\g_ev;CorrigeFichier\g_Fond;			; modifie le fichier dans SYS_LIST
	jump,ne		Close$

	call		\g_ev;ChercheA0\g_Fond;			; donne ^donnes rserve (BD)
	jump,ne		close$

	move.32		A1, A5				; ^BD  construire
	call		\g_ev;InitBD\g_Fond;				; initialise le BD
	move.16		{A3}+oBLLGB, {A5}+OBDLST	; ajoute nb d'octet dans dernier bloc

	move.32		{A3}+oBLLG, D1			; longueur en blocs
	jump,eq		Close$
	clr.32		D2				; position dbut tranche
Loop$:
	move.32		#0, D3
	call		\g_ev;GetPre\g_Fond;				; rserve juste un descripteur
	jump,ne		close$

	call		\g_ev;ChercheA0\g_Fond;			; donne le ^descripteur
	clr.16		d7				; resort #erOUTF car long=0 (pour l'instant)

	move.32		{SP}+0, {A0}+oEntPtData		; ^donnes / routine
	move.16		D1, D3
	comp.16		#16'F0, D3
	jump,lo		r8^Bon$
	move.16		#16'F0, D3			; limite par tranche (FOS tranche 16'FF)
Bon$:
	sub.16		D3, D1
.if	true
	test.8		D0
	jump,ns		r8^noInc$
	sl.32		#8, d3
	add.32		D3, {SP}+0			; ^suite des donnes
	sr.32		#8, d3
noInc$:
.endif
	move.16		D2, {A0}+oEntDbut		; position dbut tranche
	add.16		D3, D2				; prpare suivante
			; bug corrig  la place de add.16 d1, d2
	move.16		D3, {A0}+oEntLong
	move.16		{SP}+8, {A0}+oEntRfrence
	move.32		{SP}+12, {A0}+oEntPtVarA6
	move.8		D0, {A0}+oEntFlag
	call		\g_ev;AjoutBD				\g_Fond;; ajoute la tranche dans le BD
	test.16		D1
	jump,ne		Loop$
Close$:
Giv$:
	push.16		d7
	move.32		#MtypCP, D1
	move.32		d5, A4
	\g_ev;Gesmem		?GivMem\g_Fond;				; rend la mmoire du tampon
TrapErr
	pop.16		d7
Ret$:
	add.32		#4*4, SP
	popm.32		A0..A5|D1..D6
	Ret





\g_ev;GetX8\g_Fond;:
	move.8		{A4+}, D4
	sl.32		#8, D4
	move.8		{A4+}, D4
	sl.32		#8, D4
\g_ev;GetX4\g_Fond;:
	move.8		{A4+}, D4
	sl.32		#8, D4
	move.8		{A4+}, D4
	Ret




\g_titre;; ================== ;
; Appels pour le FOS ;
; ================== ;

\g_ev;GetPre\g_Fond;:
; donne une prrservation de bloc
; in	D3.16	nombre de bloc contigus voulus (#0 possible pour data spar)
; out	D4.32	no du premier bloc
;	D3.16	nombre de blocs allous
;	D7.16	erreur (disque plein)

	pushm.32	A4|A1|D1

	test.8		{A6}+oFlg:#bOldDisk	; si ancien fichier.DISK
	jump,bs		RetWpr$

	comp.32		#32, D3			; si tranche trop grande
	jump,lo		r8^Bon$
	move.32		#32, D3			; limite  32 (pour MAP.32)
Bon$:
	move.32		D3, D4
	mul.16		#lgBLK, D4		; taille mmoire
	add.32		#lgEntte, D4		; avec entte
	move.32		{A6}+oPtGesmem, A1	; compte sous-pilote
	move.32		#mTypBD, D1
	\g_ev;Gesmem		?Getmem\g_Fond;			; demande la mmoire
	jump,eq		r8^Done$
	sr.32		D3			; demande la moiti
	jump,ne		Bon$
	move.16		#ERDKFU, D7		; Disque plein !
	jump		r8^Ret$
Done$:
	add.32		d3, {A6}+oLgUtilis
	move.32		#0, {A4}+oEntPtPetit	; ^chanage petits
	move.32		#0, {A4}+oEntPtGrand	; ^chanage grands
	move.16		D3, {A4}+oEntLong	; nombre de blocs
	move.16		#0, {A4}+oEntFlag
	move.16		D3, D1
	move.32		#0, D4			; prpare le MAP
	dec.16		D1
	jump,cs		r8^vide$
set$:
	tset.32		D4:D1			; ajoute un bloc dans MAP
	dec.16		D1
	jump,cc		Set$
vide$:
	move.32		D4, {A4}+oEntMAP	; tous utiliss !

	move.32		#{A4}+LgEntete, A1
	move.32		A1, {A4}+oEntPtData	; ^donnes de la tranche

	move.32		A4, D4			; No de blocs pour le FOS!
	clr.8		D4			; plus facile  retrouver la base
	swap.32		D4
	move.32		D4, {A4}+oEntNumro
	swap.32		D4
	call		\g_ev;ChaneA4\g_Fond;		; ajoute dans les listes
	move.32		{A4}+oEntNumro, D4	; peut tre modifi
	swap.32		D4
.if	debug
.16	?aftim
.ascize	"<cr>PRE="
.16	?afx8
ex.32	D3, d4
.16	?afspace, ?afx4
ex.32	d3,d4
.endif
	jump		r8^Ret$
RetWpr$:
	move.16		#erMWPR, D7		; protg  l'criture !
	clr.32		D3
	clr.32		D4
Ret$:
	popm.32		A4|D1|A1
	test.16		D7
	Ret

\g_ev;ClrPre\g_Fond;:
; supprime un bloc de la liste utilise
; in	D4.32		no du bloc
	pushm.32	A4|A1|D4|D1|D0

	call		\g_ev;ChercheA0\g_Fond;		; cherche le ^tranche
	jump,ne		Ret$

	move.32		A0, A4
	move.32		{A4}+oEntMAP, D0	; map des blocs utiliss
	tclr.32		D0:D4			; celui-ci en moins
	move.32		D0, {A4}+oEntMAP
	jump,eq		r8^GivMem$		; tous rendus -> rend la mmoire

	move.32		#32, D4
test$:
	dec.16		D4
	test.32		D0:D4			; cherche le plus grand utilis
	jump,bc		test$

	inc.16		D4			; nombre de blocs ncessaires
	comp.16		{A4}+oEntLong, D4	; dernier ncessaire ?
	jump,eq		Ret$			; oui -> garde
jump,lo	r8^ok$
trap	#1
ok$:
	clr.32		D0
	move.16		{A4}+oEntLong, D0
	sub.16		D4, D0			; taille perdue
	sub.32		D0, {A6}+oLgUtilis	; utilis en moins

	move.16		D4, {A4}+oEntLong	; nouvelle longueur
	mul.16		#lgBLK, D4
	add.32		#LgEntte, D4		; place ncessaire  garder
	move.32		{A6}+oPtGesmem, A1
	move.32		#MtypBD, D1
	\g_ev;Gesmem		?TruncMem\g_Fond;		; rend la mmoire en trop
	jump		r8^Ret$
GivMem$:
	move.16		{A4}+oEntLong, D0
	sub.32		D0, {A6}+oLgUtilis
	test.8		{A4}+oEntFlag+1		; zone ancien fichier.DISK ?
	jump,T		r8^Ret$			; impossible de rendre, pas de MAP

	move.32		{A4}+oEntPtPetit, D0
	move.32		{A4}+oEntPtGrand, D4
	call		\g_ev;DeChaneA4\g_Fond;
	move.32		{A6}+oPtGesmem, A1
	move.32		#MtypBD, D1
	\g_ev;GesMem		?GivMem\g_Fond;			; rend cette tranche
TrapErr
	move.32		D0, A4
	call		\g_ev;ChaneA4\g_Fond;		; remet ^plus petit
	move.32		D4, A4
	call		\g_ev;ChaneA4\g_Fond;		; remet ^plus grand
Ret$:
	popm.32		A4|A1|D4|D1|D0
	Ret

\g_ev;ChercheA0\g_Fond;:
; in	D4.32		no de bloc FOS
; out	A0.32		^lment
;	A1.32		^Bloc de donne

	pushm.32	D0|D4|A4|A5
	move.32		{A6}+oPtSema, A5
	\g_ev;Ntrel		?LOCK\g_Fond;
	jump,ne		r8^Ret0$

	clr.32		D0
	move.8		D4, D0			; garde le dcalage
	clr.8		D4			; base de la tranche
	swap.32		D4			; no dans les tables

	move.32		{A6}+oPtBase, A4	; ^lment 0
Next$:
	move.16		#erMOUT, D7		; hors de la mmoire de masse
	comp.32		#0, A4
	jump,eq		r8^Ret$
	move.32		A4, A0
	comp.32		{A0}+oEntNumro, D4
	move.32		{A0}+oEntPtPetit, A4	; ^lment plus petit
	jump,lo		Next$
	move.32		{A0}+oEntPtGrand, A4
	jump,hi		Next$

	move.32		{A0}+oEntPtData, A1	; ^donnes
	comp.16		{A0}+oEntLong, D0
	jump,hs		r8^Ret$
	mul.16		#lgBLK, D0		; offset dans la tranche
	add.32		d0, A1			; sur nime bloc
	clr.16		d7
Ret$:
	push.16		d7
	\g_ev;Ntrel		?UnLOCK
	\g_Fond;pop.16		d7
Ret0$:
	popm.32		D0|D4|A4|A5
	Ret


\g_ev;ChaineA4\g_Fond;:
; ajoute une tranche dans l'arbre
; in	A4.32		^entte d'une tranche
	pushm.32	A0|D1|D0|A5
	move.32		{A6}+oPtSema, A5
	\g_ev;Ntrel		?LOCK\g_Fond;
	jump,ne		r8^Ret0$

	comp.32		#0, A4				; rien  chaner ?
	jump,eq		r8^Bon$
	test.32		{A6}+oPtBase
	jump,ne		r8^Base$
	move.32		A4, {A6}+oPtBase		; ajoute  la base
	jump		r8^Bon$
Base$:
	move.32		{A4}+oEntNumro, D0		; no rfrence  placer
	move.32		{A6}+oPtBase, A0		; base de liste
	move.32		A0, D1
Next$:
	move.32		D1, A0				; ^suivant
	comp.32		{A0}+oEntNumro, D0		; chane plus grand ou plus petit ?
	jump,hi		r8^Grand$
	jump,lo		r8^Petit$
	inc.32		{A4}+oEntNumro			; existe dj -> nouveau s.v.p.
	jump		Base$
Grand$:
	move.32		{A0}+oEntPtGrand, D1		; ^lment suivant plus grand
	jump,ne		Next$
	move.32		A4, {A0}+oEntPtGrand		; mmorise le ^courant = suivant
	move.32		#{A0}+oEntPtGrand, A0
	move.32		A0, {A4}+oEntPrecedent		; mmorise le ^au ^suivant
	jump		r8^Bon$
Petit$:
	move.32		{A0}+oEntPtPetit, D1		; ^lment suivant plus petit
	jump,ne		Next$
	move.32		A4, {A0}+oEntPtPetit		; ajoute comme plus petit
	move.32		#{A0}+oEntPtPetit, A0
	move.32		A0, {A4}+oEntPrecedent		; mmorise le ^au ^suivant
Bon$:
	clr.16		D7				; pas d'erreur
Ret$:
	push.16		d7
	\g_ev;Ntrel		?UnLOCK\g_Fond;
	pop.16		d7
Ret0$:
	popm.32		A0|D1|D0|A5
	Ret

\g_ev;DeChaineA4\g_Fond;:
	pushm.32	A0|A5
	move.32		{A6}+oPtSema, A5
	\g_ev;Ntrel		?LOCK\g_Fond;
	jump,ne		r8^Ret0$

	test.32		{A4}+oEntPrecedent
	jump,eq		r8^Ret$
	move.32		{A4}+oEntPrecedent, A0
	clr.32		{A0}			; tue le ^ celui-ci
Ret$:
	\g_ev;Ntrel		?UnLOCK\g_Fond;
Ret0$:
	popm.32		A0|A5
	Ret


.if	false
\g_it;ChercheFichier:
; regarde si un nom de fichier existe dans SYS_LIST
; in	A3.32		^nom du fichier seul
; out	D7.16		#erFDNE (NE)
;	D7.16		#erFAEX (EQ)

	pushm.32	D0|D1|A0|A1|D4|A4|A5
	move.32		#1, D4
	call		ChercheA0		; A1.32 ^BD premier
	jump,ne		r8^Ret$

	move.16		{A1}+oBDNPT, D0		; nombre de pointeurs
	move.32		#{A1}+oBDPTS, A5	; ^liste de pointeurs
	move.32		#{A1}+oBDNBS, A4	; ^liste de longueurs
Suivant$:
	move.32		{A5+}, D4		; prochaine tranche
	call		ChercheA0
	jump,ne		r8^Ret$

	move.8		{A4+}, D1		; nombre d'lment
Comp$:
	move.16		#erFAEX, D7
	call		CompareA1A3		; compare 1er nom
	jump,eq		r8^Ret$
	add.32		#lgBL, A1
	call		CompareA1A3		; compare 2me nom
	jump,eq		r8^Ret$
	add.32		#lgBL, A1
	call		CompareA1A3		; compare 3me nom
	jump,eq		r8^Ret$
	add.32		#lgBL, A1
	call		CompareA1A3		; compare 4me nom
	jump,eq		r8^Ret$
	add.32		#lgBLK-4*lgBL, A1	; ^bloc suivant dans la mme tranche
	dec.8		D1			; reste ?
	jump,ne		Comp$
	dec.16		d0			; reste une tranche ?
	jump,ne		suivant$
	move.16		#erFDNE, D7		; fichier pas trouv
Ret$:
						; EQ si fichier trouv
	popm.32		D0|D1|A0|A1|D4|A4|A5
	Ret

CompareA1A3:
	pushm.32	A1|A3|D3
Lp$:
	move.8		{A1+}, D3
	comp.8		{A3+}, D3
	jump,ne		r8^Ret$
	test.8		D3
	jump,ne		Lp$
Ret$:
	popm.32		A1|A3|D3
	Ret

AjouteFichier:
; ajoute un nom de fichier dans SYS_LIST
; in	A3.32		^nom du fichier + ARGS (format BL)
; out

	pushm.32	D0..D5|A0..A5
	move.32		#1, D4
	call		ChercheA0		; A1.32 ^BD premier
	jump,ne		r8^Ret$

	move.32		A1, A5
	move.16		{A5}+oBDNPT, D0		; nombre de pointeurs
	move.32		#{A5}+oBDPTS, A2	; ^liste de pointeurs
	move.32		#{A5}+oBDNBS, A4	; ^liste de longueurs
	clr.32		d2			; compte le BL existant
Suivant$:
	move.32		{A2+}, D4		; prochaine tranche
	call		ChercheA0
	jump,ne		r8^Ret$

	move.8		{A4+}, D1		; nombre d'lment
Comp$:
	inc.32		d2			; un BL de plus
	move.32		A1, D5			; garde le ^dernier
	test.8		{A1}			; place libre ?
	jump,eq		r8^Place$
	add.32		#lgBL, A1
	test.8		{A1}			; place libre ?
	jump,eq		r8^Place$
	add.32		#lgBL, A1
	test.8		{A1}			; place libre ?
	jump,eq		r8^Place$
	add.32		#lgBL, A1
	test.8		{A1}			; place libre ?
	jump,eq		r8^Place$

	add.32		#lgBLK-4*lgBL, A1	; ^bloc suivant dans la mme tranche
	dec.8		D1			; reste ?
	jump,ne		Comp$
	dec.16		d0			; reste une tranche ?
	jump,ne		suivant$

	move.32		#1, D3
	call		GetPre			; reserve un nouveau bloc
	jump,ne		r8^Ret$

	call		AjoutBD
	move.32		d5, A2
	move.16		d2, {A2}+oBLNEXT	; chane pour le FOS
	;FosParam Kill
	call		ChercheA0
	jump,ne		r8^Ret$
	move.32		A1, A4
	move.32		#LgBLK, D4
	GesMem		?ClearMem		; vide le nouveau BL
	move.32		{A5}+oBDCHK, {A1}+oBLCHK
Place$:
	move.16		#LgBL/4-1, d0
C$:
	move.32		{A3+}, {A1+}		; copie le BL donn
	dj.16,nmo	d0, c$
Ret$:
	test.16		d7			; EQ si fichier trouv
	popm.32		D0..D5|A0..A5
	Ret

\g_Fond;.endif

\g_ev;CreeFichier\g_Fond;:
; in	A3.32		^Nom du fichier en oNOMFICHIER dans tampon
	pushm.32	A1..A4|D3|D4|D6
	move.32		#{A3}-oNomFichier, A4

	move.32		{A6}+oPtGesmem, A1	; ^DiBASE sous-pilote
	move.32		#{A1}-D0BASE+D0NAB, A1	; ^MEM_i
	move.32		#{A4}+oNomMEM, A2
	move.8		#"$", {A2+}
c$:
	move.8		{A1+}, {A2+}		; copie $MEM_i:
	jump,ne		c$
	move.8		#":", {A2}-1
cn$:
	move.8		{A3+}, {A2+}		; copie nom fichier
	jump,ne		cn$

	move.32		#{A4}+oNomMEM, A3	; ^nom prcd de $MEM_i:
	move.32		#DEFATT, D3
	move.32		#TYPRAND, D4
	\g_ev;Fos		?Create\g_Fond;			; cre le fichier
	jump,ne		r8^Ret$

	move.32		#{A4}+oNomCreate, A2
	move.32		#r16^nSYS_LIST, A1
cl$:
	move.8		{A1+}, {A2+}
	jump,ne		cl$

	move.32		#2**BOPRD+2**BOPEXTEND+2**BOPDIR+2**BOPNETW, D3
	\g_ev;Fos		?ARGSOPEN\g_Fond;
	jump,ne		r8^Ret$
	\g_ev;Fos		?MajBD\g_Fond;			; met  jour le BD de SYS_LIST
	\g_ev;Fos		?CLOSE\g_Fond;
Ret$:
	popm.32		A1..A4|D3|D4|D6
	Ret

\g_ev;CorrigeFichier\g_Fond;:
; modifie le nom d'un fichier dans BL pour ^nouveau BD
; in	A3.32		^nom du fichier seul suivi des attributs (format BL)
; out

	pushm.32	D0..D5|A0..A5
	move.32		#1, D4
	call		\g_ev;ChercheA0\g_Fond;		; A1.32 ^BD premier
	jump,ne		r8^Ret$

	move.16		{A1}+oBDNPT, D0		; nombre de pointeurs
	move.32		#{A1}+oBDPTS, A5	; ^liste de pointeurs
	move.32		#{A1}+oBDNBS, A4	; ^liste de longueurs
Suivant$:
	move.32		{A5+}, D4		; prochaine tranche
	call		\g_ev;ChercheA0		\g_Fond;; ^BL tranche suivante
	jump,ne		r8^Ret$

	move.8		{A4+}, D1		; nombre de blocs conscutifs
Comp$:
	call		\g_ev;CompareA1A3\g_Fond;		; compare 1er nom
	jump,eq		r8^Trouv$
	add.32		#lgBL, A1
	call		\g_ev;CompareA1A3\g_Fond;		; compare 2me nom
	jump,eq		r8^Trouv$
	add.32		#lgBL, A1
	call		\g_ev;CompareA1A3\g_Fond;		; compare 3me nom
	jump,eq		r8^Trouv$
	add.32		#lgBL, A1
	call		\g_ev;CompareA1A3\g_Fond;		; compare 4me nom
	jump,eq		r8^Trouv$
	inc.32		D4			; no bloc suivant
	add.32		#lgBLK-3*lgBL, A1	; ^bloc suivant dans la mme tranche
	dec.8		D1			; reste ?
	jump,ne		Comp$
	dec.16		d0			; reste une tranche ?
	jump,ne		suivant$
	move.16		#erFDNE, D7		; fichier pas trouv
	jump		r8^Ret$
Trouv$:
	move.16		#LgBL/4-1, d0
C$:
	move.32		{A3+}, {A1+}		; copie le BL donn
	dj.16,nmo	d0, c$
	move.32		D4, {A3}+2
	clr.8		{A3}+2+4
	move.8		#"K", {A3}+1		; commande K[no.l]
	move.32		#{A3}+1, A4
	\g_ev;Fos		?PARAM\g_Fond;			; enlve ce bloc du cache FOS
Ret$:
	test.16		d7			; EQ si fichier trouv
	popm.32		D0..D5|A0..A5
	Ret


\g_ev;CompareA1A3\g_Fond;:
	pushm.32	A1|A3|D3
Lp$:
	move.8		{A1+}, D3
	comp.8		{A3+}, D3
	jump,ne		r8^Ret$
	test.8		D3
	jump,ne		Lp$
Ret$:
	popm.32		A1|A3|D3
	Ret



\g_ev;InitBD\g_Fond;:
; in	A5.32		^bloc pour BD
	pushm.32	A4|D4
	move.32		A5, A4
	move.32		#LgBlk, D4
	\g_ev;GesMem		?ClearMem\g_Fond;		; efface tout
	move.32		{A6}+oPtBase, A4
	move.32		{A4}+oEntPtData, A4	; ^donnes du bloc zro
	move.32		{A4}+OBDCHK+LGBLK, {A5}+oBDCHK
	popm.32		A4|D4
	Ret

\g_ev;AjoutBD\g_Fond;:
; in	A5.32		^bloc pour BD
;	D4.32		no 1er bloc
;	D3.32		longueur en blocs
	pushm.32	D0|A5
	move.16		{A5}+oBDNPT, D0
	inc.16		{A5}+oBDNPT
	add.32		#lgBLK/2, A5			; pour adressage rel 8bits
	move.8		D3, {A5}+A16^{D0}+oBDNBS-lgBLK/2
	sl.16		#2, D0				; offset de .32
	move.32		D4, {A5}+A16^{D0}+oBDPTS-lgBLK/2
	popm.32		D0|A5
	Ret


\g_ev;AjouteDisk\g_Fond;:
; in	A4.32		^fichier.disk
;	D4.32		longueur de ce fichier
;	EQ		ancien fichier .disk

	jump,eq		\g_ev;AjouteVieux\g_Fond;

	pushm.32	A1..A4|D1..D5
	move.32		A4, A3
	add.32		D4, A3				; ^fin des donnes

	move.32		A4, A2				; ^insertion des portions gesmem !
Lp$:
	move.32		#{A4}+LgEntte, A1
	move.32		A1, {A4}+oEntPtData		; ^donnes suivant l'entte
	move.32		#0, {A4}+oEntPtPetit		; pas de chanage pour l'instant
	move.32		#0, {A4}+oEntPtGrand
	call		\g_ev;ChaneA4\g_Fond;			; ajoute dans le chanage
	jump,ne		r8^Ret$

	comp.32		A4, A2				; 1er passage ?
	jump,eq		r8^Av$

	move.32		A2, {A4}-16'8			; ^lment gesmem prcdent
	move.32		{A2}-16'4, {A4}-16'4		; ^lment gesmen suivant
	move.32		A4, {A2}-16'4			; ^suivant sur celui-ci
	move.32		{A4}-16'4, A1			; ^suivant
	tclr.8		{A4}-16'9:#0			; pas premier
	tclr.8		{A4}-16'9:#1			; ni dernier  priori
	tclr.8		{A4}-16'A:#0			; pas de contrle dpassement
	tclr.8		{A2}-16'9:#1			; plus dernier
	jump,bc		r8^Pt$
	tset.8		{A4}-16'9:#1			; nouveau dernier
	move.32		#{a1}+4+16'8, A1		; ^suivant = base
Pt$:
	move.32		A4, {A1}-16'8			; nouveau prcdent
Av$:
	clr.32		D4
	move.16		{A4}+oEntLong, D4		; nombre de blocs dans la tranche
	add.32		D4, {A6}+oLgUtilis
	mul.16		#lgBLK, D4			; soit en octets
	add.32		#LgEntte, D4			; plus entte
	call		\g_ev;ModifLongA4\g_Fond;			; ajuste la longueur dans descrition Gesmem
	add.32		#16'10, D4			; long. entte gesmem  sauter
	add.32		D4, A4				; ^tranche suivant
	comp.32		A3, A4
	jump,lo		Lp$
	clr.16		d7
Ret$:
	popm.32		A1..A4|D1..D5
	Ret

\g_ev;ModifLongA4\g_Fond;:
	push.32		D4
	move.32		D4, {A4}-16'E			; modifie la long dans descripteur
							; de gesmem. cacher a  Bat !
	xor.16		#16'5B81, D4
	RR.16		#3, D4				; calcul la valeur de contrle
	move.16		D4, {A4}-16'10
	tclr.8		{A4}-16'A:#0			; pas de contrle de dpassement
	pop.32		D4
	Ret

\g_ev;AjouteRomDisk\g_Fond;:
; in	A4.32		^fichier disque en mmoire
;	D4.32		longueur de ce fichier
;	EQ		ancien fichier .disk !

	jump,eq		\g_ev;AjouteVieux\g_Fond;

	pushm.32	A1..A4|D1..D5
	move.32		A4, A3
	add.32		D4, A3				; ^fin des donnes

	move.32		A4, A2				; ^insertion des portions gesmem !
Lp$:
	move.32		#LgEntte, D4
	move.32		{A6}+oPtGesmem, A1
	move.32		#MtypBD, D1
	\g_ev;Gesmem		?Getmem\g_Fond;				; mmoire pour un descripteur
	jump,ne		r8^Ret$
	\g_ev;GesMem		?clearMem\g_Fond;			; tout propre

	move.32		#{A2}+LgEntte, A1
	move.32		A1, {A4}+oEntPtData		; ^donnes suivant l'entte
;	move.32		#0, {A4}+oEntPtPetit		; pas de chanage pour l'instant
;	move.32		#0, {A4}+oEntPtGrand
;	move.32		#0, {A4}+oEntPrecedent
	move.16		{A2}+oEntFlag, {A4}+oEntFlag
	set.8		{A4}+oEntFlag+1			; zone sans MAP !

	move.32		{A2}+oEntMAP, {A4}+oEntMAP
	move.32		{A2}+oEntNumro, {A4}+oEntNumro
	move.16		{A2}+oEntDbut, {A4}+oEntDbut
	move.16		{A2}+oEntRfrence, {A4}+oEntRfrence
	call		\g_ev;ChaneA4\g_Fond;			; ajoute dans le chanage
	jump,ne		r8^Ret$

	clr.32		D4
	move.16		{A2}+oEntLong, D4		; nombre de blocs dans la tranche
	move.16		D4, {A4}+oEntLong
	add.32		D4, {A6}+oLgUtilis
	mul.16		#lgBLK, D4			; soit en octets
	add.32		#LgEntte, D4			; plus entte
	add.32		#16'10, D4			; long. entte gesmem  sauter
	add.32		D4, A2				; ^tranche suivant
	comp.32		A3, A2
	jump,lo		Lp$

	tset.8		{A6}+oFlg:#bOldDisk		; pas modifiable !
	clr.16		d7
Ret$:
	popm.32		A1..A4|D1..D5
	Ret

\g_ev;AjouteVieux\g_Fond;:
	pushm.32	A1..A4|D1..D5
	move.32		A4, A2				; ^donnes
	move.32		d4, d5
	sr.32		#8, d5				; nb de blocs

	move.32		#0, d2				; no du premier bloc
Lp$:
	move.32		d5, d3
	comp.32		#16'100, d3
	jump,ls		r8^b$
	move.32		#16'100, d3			; limite les taille de tranche
b$:
	sub.32		d3, d5

	move.32		#LgEntte, D4
	move.32		{A6}+oPtGesmem, A1
	move.32		#MtypBD, D1
	\g_ev;Gesmem		?Getmem\g_Fond;				; mmoire pour un descripteur
	jump,ne		r8^Ret$

	\g_ev;GesMem		?clearMem\g_Fond;			; tout propre

	move.32		A2, {A4}+oEntPtData		; ^donnes de la tranche
	move.16		d3, {A4}+oEntLong		; longueur de la tranche
	swap.32		d2
	move.32		d2, {A4}+oEntNumro		; numro de base tranche
	swap.32		d2
	set.8		{A4}+oEntFlag+1			; zone sans MAP !

	call		\g_ev;ChaneA4\g_Fond;			; ajoute dans le chanage
	jump,ne		r8^Ret$

	add.32		d3, d2				; no 1er bloc tranche suivante
	sl.32		#8, d3
	add.32		d3, a2				; ^suite des donnes
	test.32		d5				; reste  faire ?
	jump,ne		Lp$
	tset.8		{A6}+oFlg:#bOldDisk		; pas modifiable !
	clr.16		d7
Ret$:
	popm.32		A1..A4|D1..D5
	Ret

\g_ev;SaveDisk\g_Fond;:
	pushm.32	A5|A3|D3|A0|D0|A4|D4|D6
	move.32		{A6}+oPtSema, A5
	Ntrel		?LOCK
	jump,ne		Ret0$

	move.32		#{A4}+1, A3
	move.8		#"D", D3
	\g_ev;Lib		?IfSwitch\g_Fond;			; regarde si /D
	jump,ne		r8^cre$
	\g_ev;Fos		?DELETE\g_Fond;				; dtruit l'ancien
cre$:
	move.32		#DEFATT, D3
	\g_ev;Fos		?Create\g_Fond;				; tente de crer le fichier .DISK
	jump,ne		r8^Ret$

	move.32		#2**BopWR+2**BopEXCL, D3
	\g_ev;Fos		?Open\g_Fond;
	jump,ne		r8^Ret$

	move.32		{A6}+oPtBase, A0		; ^base de chanage
	clr.8		D0
	call		\g_ev;Archive\g_Fond;				; archive rcursivement
	push.16		d7
	\g_ev;Fos		?close\g_Fond;
	pop.16		d7
Ret$:
	push.16		d7
	\g_ev;Ntrel		?UnLOCK\g_Fond;
	pop.16		d7
Ret0$:
	popm.32		A5|A3|D3|A0|D0|A4|D4|D6
	Ret

\g_ev;Archive\g_Fond;:
; mod	A0.32, A4.32, D4.32, D0.8
	pushm.32	A1		; minimum sur la pile car rcursif
	comp.32		#0, A0
	jump,eq		r8^Done$

	test.8		{A0}+oEntFlag			; fichier donn par une routine ?
	jump,ns		r8^Next$
	test.16		{A0}+oEntLong
	jump,eq		r8^Next$

	move.32		A0, A4				; ^entte
	move.32		#LgEntete, D4			; longueur
	comp.32		{A6}+oPtBase, A0		; si tout premier -> crit ainsi
	jump,eq		r8^Wr$
	move.32		#{A0}-16'10, A4			; ^entte avec portion Gesmem
	move.32		#LgEntte+16'10, D4
Wr$:
	\g_ev;Fos		?WrByte\g_Fond;				; crit l'entte
	jump,ne		r8^Done$
	move.32		{A0}+oEntPtData, A4		; ^donnes
	move.16		{A0}+oEntLong, D4		; nombre de blocs
	mul.16		#LgBLK, D4			; nombre d'octets
	\g_ev;Fos		?WrByte\g_Fond;
Next$:
	move.32		A0, A1
	not.8		D0
	jump,eq		Hi$
	move.32		{A1}+oEntPtPetit, A0
	call		\g_ev;Archive\g_Fond;				; archive rcursivement
	move.32		{A1}+oEntPtGrand, A0
	call		\g_ev;Archive\g_Fond;
	jump		r8^Done$
Hi$:
	move.32		{A1}+oEntPtGrand, A0
	call		\g_ev;Archive\g_Fond;				; archive rcursivement
	move.32		{A1}+oEntPtPetit, A0
	call		\g_ev;Archive\g_Fond;
Done$:
	popm.32		A1
	Ret


\g_ev;InfoDisk\g_Fond;:
	\g_ev;Gesmem		?ArgMem\g_Fond;				; mmoire libre  disposition
	sr.32		#8, D4				; valeur en blocs = reste
	move.32		{A6}+oLgUtilis, D3		; nombre de blocs utilis
	ex.32		D3,D4
	Ret


; in	A2.32		^nom fichier
; 	A4.32		^tampon pour copie
; out	A3.32		^nom fichier copi (=A4in)
; mod	A3.32
\g_ev;NomFichierRam\g_Fond;:
	pushm.32	A1|A2|A4
	move.32		a4, A3				; ^nom  tuer
i$:
	move.32		{A6}+oPtGesmem, A1		; ^D0base du pilote
	move.32		#{A1}-D0BASE+D0NAB, A1		; dbut nom MEM_i
	move.32		a3, a4
	move.8		#"$", {A4+}
c$:
	move.8		{A1+}, {A4+}			; copie $MEM_i:
	jump,ne		c$
	move.8		#":", {A4}-1
cn$:
	move.8		{A2+}, {A4+}			; copie le nom du fichier
	jump,eq		r8^r$
	comp.8		#":", {A4}-1			; supprime les noms de dossier
	jump,ne		cn$
	jump		i$
r$:
	popm.32		A1|A2|A4
	Ret

	.END
