	.TITLE 	MOUSE.ASD
	.BASE	10'10
	.LAYOUT HEX
;	.LISTIF
nouveau		=	true
	.REF	MON

BIOS?NAMDRIV	=	16'21		; viel appel, encore utilis !!!


; Source du driver souris pour Smaky 8, 100, 130, 196, 300, 324 et Costronic 21
; -----------------------------------------------------------------------------

; Daniel Roux
; Beat Brunner

	.INS	TESTMACHINE.ASI

MajRev	= 1
MinRev	= 5

	.REV	MajRev, MinRev

	TESTmachine		; initialise les variables machine-dpendantes

	.IF	SM130.OR.SM196.OR.SM300
	.PROC	M68030f
	.ELSE	
	.PROC	M68000
	.ENDIF	SM130.OR.SM196.OR.SM300

; Date     Rv      Modifications
; -----------------------------------------------------------------
; 10/04/95 1.5  PA  Petites optimisations
;          1.4  DM  ?
; 12/06/93 1.3  PA  Nouvel assemblage optimis pour mise en ROM.


.IF	SM100
.IDENT	"Pilote souris pour Smaky 100 (C) Beat BRUNNER & EPSITEC-system sa"

; 1.0	JFG	07.07.88
; ----------------------
;	Traduction en CALM et adjonction du numro de rvision et version

.ENDIF	SM100

.IF	SM8
.IDENT	"Pilote souris pour Smaky 8 (C) Beat BRUNNER & EPSITEC-system sa"

; 1.0	JFG	07.07.88
; ----------------------
;	Traduction en CALM et adjonction du numro de rvision et version

.ENDIF	SM8

.IF	SM324
.IDENT	"Pilote souris pour Smaky 324 (C) Beat BRUNNER & EPSITEC-system sa"

; 1.0	JFG	07.07.88
; ----------------------
;	Traduction en CALM et adjonction du numro de rvision et version

.ENDIF	SM324

.IF	COS21
.IDENT	"Pilote souris parallle pour systme COSTRONIC 21 (C) Beat BRUNNER & COSTRONIC sa"

; 1.0	JFG	07.07.88
; ----------------------
;	Premire version fournie  COSTRONIC SA

.ENDIF	COS21

.IF	SM196
.IDENT	"Pilote souris pour Smaky 196 (C) Beat BRUNNER, J-F GRUET & EPSITEC-system SA"

.ENDIF	SM196

.IF	SM300
.IDENT	"Pilote souris pour Smaky 300 (C) Beat BRUNNER, J-F GRUET & EPSITEC-system SA"

.ENDIF	SM300

.IF	SM130
.IDENT	"Pilote souris pour Smaky 130 (C) Beat BRUNNER, J-F GRUET & EPSITEC-system SA"

.ENDIF	SM130


; Constantes
; ----------

	.IF	SM100
	.REF 	SM100HARD
	.REF 	SHIDRIV100
	.ENDIF 	SM100

	.IF	SM8
	.REF 	SM8HARD
	.REF	SHIDRIVSM8
	.ENDIF 	SM8

	.IF	SM324
	.REF 	SM324HARD
	.REF 	SHIDRIV324
	.ENDIF 	SM324

	.IF	SM196
	.REF	SM196HARD
	.REF	SHIDRIV196
	.REF	CIO
	.ins	shimac196.asi
	.ENDIF	SM196

	.IF	SM300
	.REF	SM300HARD
	.REF	SHIDRIV300
	.REF	CIO
	.ENDIF	SM300


	.IF	SM130
	.REF	SM130HARD
	.REF	SHIDRIV130
	.REF	CIO
	.ENDIF	SM130


	.IF	COS21
	.REF 	COSHARD
	.REF	CO2HARD

BMISX	=	0	; H1 status	PIT2_PSR	(Xa latch)
BMISY	=	2	; H3 status	"		(Ya latch)
BMSX	=	5	; Xb		PIT2_PBAR
BMSY	=	4	; Yb		"

	.REF 	SHIDRIVCOS
	.ENDIF 	COS21
.IF	FALSE
	.REF 	SM8
	.REF 	BIOS
	.REF 	BIOSDRIV
	.REF 	NTREL
	.REF 	DRIVERS
	.REF	GESMEM

	.REF	M8SYS			; pour debugs
.ELSE
	.REF	SMAKY
	.REF	BIOS
	.REF	BIOSDRIV
.ENDIF	FALSE
	; Rglage de la bote de vitesses automatique:

DEFAC2		=	10		; vitesse pour 1er changement de vitesse
DEFAC3		=	30		; idem pour le passage de la 2me  la 3me

	.IF	SM324
BSOGAUC		=	BMOLEFT		; bits des touches souris hard
BSODROI		=	BMORIGHT
BSOCENT		=	BMOCENT
	.ENDIF	SM324
	.IF	COS21
BSOGAUC		=	1		; bits des touches souris hard
BSODROI		=	2
BSOCENT		=	3
	.ENDIF	COS21

	.if	sm196
BSOGAUC		=	1		; bits des touches souris hard
BSODROI		=	2
BSOCENT		=	3
	.endif	sm196

	.if	sm300
BSOGAUC		=	BitMouseGauche		; bits des touches souris hard
BSODROI		=	BitMouseDroite
BSOCENT		=	BitMouseCentre
	.endif	sm300

	.if	sm130
BSOGAUC		=	BitMouseGauche		; bits des touches souris hard
BSODROI		=	BitMouseDroite
BSOCENT		=	BitMouseCentre
	.endif	sm130

.if	sm300
.macro	Waitcio
test.8	AdRet350
test.8	AdRet700
.endmacro
.endif	sm300

.if	sm130
	.MACRO	WaitCio
	TEST.16	AdRet350
	.ENDMACRO
.endif	sm130

; Dfinitions des variables
; -------------------------

	.LOC	0
		.BLK.8	LGMOU2		; table dfinie dans DRIVERS
;.... 	 Cf DRIVERS

OFLAGS:		.BLK.8	1		; flags divers
 BSIMUL		 =  0			;  souris simule avec clavier
 BATTEND	 =  1			;  attend un signal de l'inter.
 BBOUGE		 =  2			;  la souris a t bouge
 BFFILS		 =  3			;  fin du processus fils
 BFLEON		 =  4			;  "flche" pav num. presse
 BESPION	 =  5			;  mode d'espionnage enclanch
 BOBEIT		 =  6			;  mode d'obissance enclanch
		.BLK.8	1
OMOKEY:		.BLK.8	1		; boutons de la souris
OMOIKY:		.BLK.8	1		; boutons bruts
OMOLKY:		.BLK.8	1		; derniers boutons
	.EVEN
OMOPOS:		.BLK.8	4		; position de la souris (Y;X)
OMOLPO:		.BLK.8	4		; dernire position (Y;X)
OMOORI:		.BLK.8	4		; coordonnes origine (Y;X)
OMODLT:		.BLK.8	4		; delta (Y;X)
OMOLDL:		.BLK.8	4		; dernier delta (Y;X)
OMOAC2:		.BLK.8	2		; vitesse pour passage de la 2me
OMOAC3:		.BLK.8	2		; vitesse pour passage de la 3me
OSYTIME:	.BLK.8	4		; temps systme, dernire lecture
OLDPOS:		.BLK.8	2		; ancien status de la souris
OSEMAS:		.BLK.8	4		; id smaphore de synchro
OSEMAF:		.BLK.8	4		; id smaphore pour le fils
OSEMESP:	.BLK.8	4		; id smaphore pour espionnage
OSEMWESP:	.BLK.8	4		; id smaphore pour sync d'espion.
OKACCE:		.BLK.8	2		; acclration si clavier
ONOKEY:		.BLK.8	2		; no driver clavier KEY_0
OOLKEY:		.BLK.8	2		; dernire touche "flche"
OBUKEY:		.BLK.8	50		; buffer pour le clavier
LGVAR:





; Dbut du code du driver
; -----------------------


	.LOC	0

	.16	0,D0BASE
	.16	31,D31BASE
	.16	2**7



; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $MOUSE_0		No H'10
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

D0ID:
	.16	D0OPEN-D0BASE		; Adresse routines
	.16	D0COMMAND-D0BASE
	.16	D0RSTATUS-D0BASE
	.16	D0READ-D0BASE
	.16	-1			; D0WRITE-D0BASE
	.16	D0CLOSE-D0BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; D0AUX1-D0BASE
	.16	-1			; D0AUX2-D0BASE
	.16	D0RESET-D0BASE
	.16	D0KILL-D0BASE
	.16	-1			; D0STRT-D0BASE
	.16	-1			; D0TSTRT-D0BASE
	.16	-1			; D0START-D0BASE

D0NAB:	.ASCII	"MOUSE_0"		; Nom driver
D0NAF:	.FILL.8 	LGDNAM-(D0NAF-D0NAB), 0

	.8	16'10			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	MAJREV,MINREV		; Rvision - version
	.16	0			; Variante

	.8	0			; Attribut 1
	.8	2**BDRDOK ;;!2**BDNORT	; Attribut 0

	.FILL.8 LGDDESC-(APC-D0ID), 0	; Le reste.
D0BASE:




; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $MOUSE_31	No H'11
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

D31ID:
	.16	D31OPEN-D31BASE		; Adresse routines
	.16	D31COMMAND-D31BASE
	.16	-1			; D31RSTATUS-D31BASE
	.16	D31READ-D31BASE
	.16	D31WRITE-D31BASE
	.16	D31CLOSE-D31BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; D31AUX1-D31BASE
	.16	-1			; D31AUX2-D31BASE
	.16	D31RESET-D31BASE
	.16	-1			; D31KILL-D31BASE
	.16	-1			; D31STRT-D31BASE
	.16	-1			; D31TSTRT-D31BASE
	.16	-1			; D31START-D31BASE

D31NAB:	.ASCII	"MOUSE_31"		; Nom driver
D31NAF:	.FILL.8 	LGDNAM-(D31NAF-D31NAB), 0

	.8	16'11			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	MAJREV,MINREV		; Rvision - version
	.8	0,0			; priorit

	.8	0			; Attribut 1
	.8	2**BDRDOK.OR.2**BDWROK	; Attribut 0

	.FILL.8 LGDDESC-(APC-D31ID), 0	; Le reste.
D31BASE:





; Points d'entres pour les routines de bases
; -------------------------------------------



;--------\\
; RESET   >
;========/

; Le reset n'est pas possible (retour avec une erreur) si
; la souris n'est pas branche ou si les trois boutons
; sont presss.

; in	-
; out	A6	^variables
;	D7.16	erreur
; mod	D0..A1, D7.W

D0RESET:
	PUSHM.32 D2|D3|D4|D5|A2|A3|A4|A5

	MOVE.32	#R16^D0BASE,A1
	MOVE.32	#MTYPBD,D1
	MOVE.32	#LGVAR,D4
	GESMEM	?GETMEM
	JUMP,NE	L90$
	MOVE.32	A4,A6			; pour rendre le ^var.
	MOVE.32	A6,A1			; A1 <-- ^variables

	CLR.8	{A1}+OFLAGS		; clear tous les flags
	CLR.32	{A1}+OSEMAS
	CLR.32	{A1}+OSEMAF
	CLR.16	{A1}+OLDPOS		; clear ancien status souris
	SET.8	{A1}+OMOIKY
	MOVE.16	#1,{A1}+OKACCE		; acclration minimale
	NTREL	?GETSYTIME
	MOVE.32	D4,{A1}+OSYTIME		; Initialise le temps courant

	MOVE.32	A2,D0			; Paramtre qcq ?
	JUMP,EQ	L10$
	COMP.8	#"S",{A2}		; Souris simule obligatoirement ?
	JUMP,EQ	L50$
	COMP.8	#"s",{A2}		; Teste aussi si minuscule
	JUMP,EQ	L50$
L10$:
	.IF	SM100.or.SM324.or.COS21.or.SM196.OR.sm300.or.sm130
	MOVE.8	#-1,D0			; D0 <-- souris toujours l
	.ENDIF 	SM100.or.SM324.or.COS21.or.SM196.OR.sm300.or.sm130

	.IF	SM8
	MOVE.8	SOURIS+1,D0
	AND.8	#2**BMOLEFT.OR.2**BMOCENT.OR.2**BMORIGHT,D0
	JUMP,EQ	L50$			; zro => pas de souris
	.ENDIF	SM8

	MOVE.32	#0,D4
	NTREL	?CRESEM
	JUMP,NE	L90$
	MOVE.32	A5,{A1}+OSEMAS		; init ^smaphore synchro

	CALL	INITINT			; active l'interruption

	CLR.16	D7			; D7 <-- ok
	JUMP	L90$

L50$:	MOVE.32	#R16^NAKEY0,A3
	BIOS	?NAMDRIV		; D2 <-- no du driver KEY_0
	JUMP,NE	R8^L90$
	MOVE.16	D2,{A1}+ONOKEY

	MOVE.32	#0,D4
	NTREL	?CRESEM
	JUMP,NE	R8^L90$
	MOVE.32	A5,{A1}+OSEMAS		; init ^smaphore synchro

;;	MOVE.32	#0,D4
	NTREL	?CRESEM
	JUMP,NE	R8^L90$
	MOVE.32	A5,{A1}+OSEMAF		; init ^smaphore pour fils
	MOVE.32	A5,A2			; A2 <-- ^smaphode

	MOVE.32	#200,D5			; D5 <-- lg stack
	MOVE.32	#R16^PFILS,A5		; A5 <-- start
	MOVE.32	#3.OR.2**BTSIAB,D4	; D4 <-- priorit + ^sm. donn
	MOVE.32	#R16^NFILS,A3
	NTREL	?CRETASK		; cre processus fils
	JUMP,NE	R8^L90$

	TSET.8	{A1}+OFLAGS:#BSIMUL

L90$:	POPM.32	D2|D3|D4|D5|A2|A3|A4|A5
	RET



;--------\\
; KILL    >
;========/

; in	A6	^variables
; out	-
; mod	D0..A1

D0KILL:
	PUSHM.32 A4|A5

	MOVE.32	A6,A1			; A1 <-- ^variables

	TEST.8	{A1}+OFLAGS:#BSIMUL	; souris simule ?
	JUMP,BC	R8^L50$			; non => 50$
					; oui =>
	TSET.8	{A1}+OFLAGS:#BFFILS	; fin du processus fils
	MOVE.32	{A1}+OSEMAF,A5		; A5 <-- ^smaphore fils
	NTREL	?WAITEV			; attend la fin du fils ...
	NTREL	?KILLSEM		; dtruit le smaphore

L50$:	CALL	DISABLEINT		; dsactive l'interruption

	MOVE.32	{A1}+OSEMAS,A5		; A5 <-- ^smaphore synchro
	NTREL	?KILLSEM		; dtruit smaphore synchro

	MOVE.32	A1,A4
	MOVE.32	#R16^D0BASE,A1
	MOVE.32	#MTYPBD,D1
	GESMEM	?GIVMEM

	CLR.16	D7			; D7 <-- ok
	POPM.32	A4|A5
	RET



;--------\\
; OPEN    >
;========/

; Rserve le pav numrique pour simuler la souris.

; in	A6	^variables
; out	-
; mod	D0..A1

D0OPEN:
	MOVE.32	A6,A1			; A1 <-- ^variables

	TEST.8	{A1}+OFLAGS:#BSIMUL	; souris simule ?
	JUMP,BC	R8^L50$			; non => 50$
					; oui =>
	MOVE.8	#KEYSIP,D0		; D0 <-- "set inter-programme"
	CALL	RESKMO			; rserve pav numrique
	JUMP,NE	R8^L90$
L50$:
	SET.8	{A1}+OMOLKY		; derniers boutons impossibles
	CLR.32	{A1}+OMOORI		; clear position souris
	CLR.32	{A1}+OMODLT
	CLR.32	{A1}+OMOLDL
	.IF	SM100.or.COS21.or.SM196.OR.sm300.or.sm130
	CLR.8	{A1}+OMOSCA		; chelle 1:1
	.ELSE
	MOVE.8	#1,{A1}+OMOSCA		; chelle 1:2
	.ENDIF	SM100.or.COS21.or.SM196.OR.sm300.or.sm130

	.IF	SM8.or.SM324
	MOVE.16	#DEFAC2,{A1}+OMOAC2	; Rgle le changeur automatique
	MOVE.16	#DEFAC3,{A1}+OMOAC3	; de vitesses...
	.ENDIF	SM8.or.SM324

	.IF	SM100.or.COS21.or.SM196.OR.sm300.or.sm130
	MOVE.16	#DEFAC2/4,{A1}+OMOAC2	; Rgle le changeur automatique
	MOVE.16	#DEFAC3/4,{A1}+OMOAC3	; de vitesses...
	.ENDIF	SM100.or.COS21.orSM196.OR.sm300.or.sm130

	MOVE.8	#5,{A1}+OMOVI2		; Prpare pour RDSTATUS
	MOVE.8	#5,{A1}+OMOVI3
	CLR.16	D7			; D7 <-- ok
L90$:	RET


;--------\\
; CLOSE   >
;========/

; Libre le pav numrique pour simuler la souris.
; Il faudrait le faire dans KILL, mais cela n'est pas
; possible, car le BIOS interdit d'excuter un ?DCOMMAND
; dans un KILL !!!

; in	A6	^variables
; out	-
; mod	D0..A1

D0CLOSE:
	MOVE.32	A6,A1			; A1 <-- ^variables

	TEST.8	{A1}+OFLAGS:#BSIMUL	; souris simule ?
	JUMP,BC	R8^L50$			; non => 50$
					; oui =>
	MOVE.8	#KEYCIP,D0		; D0 <- "clear inter-programme"
	CALL	RESKMO			; libre pav numrique

L50$:	CLR.16	D7			; D7 <-- ok
	RET


;--------\\
; RESKMO  >
;--------/

; Rserve ou libre les touches ncessaires pour simuler
; une souris avec le clavier.

; in	D0.B	KEYSIP/KEYCIP
; out	D7.W	erreur
; mod	D7.W

RESKMO:
	PUSHM.32 D1|D2|A4

	MOVE.32	#{A1}+OBUKEY,A4
	MOVE.8	D0,{A4+}
	MOVE.8	#"1".OR.2**6,{A4+}	; pseudo-code (1)
	MOVE.8	D0,{A4+}
	MOVE.8	#"2".OR.2**6,{A4+}	; pseudo-code (2)
	MOVE.8	D0,{A4+}
	MOVE.8	#"3".OR.2**6,{A4+}	; pseudo-code (3)
	MOVE.8	D0,{A4+}
	MOVE.8	#"4".OR.2**6,{A4+}	; pseudo-code (4)
	MOVE.8	D0,{A4+}
	MOVE.8	#"5".OR.2**6,{A4+}	; pseudo-code (5)
	MOVE.8	D0,{A4+}
	MOVE.8	#"6".OR.2**6,{A4+}	; pseudo-code (6)
	MOVE.8	D0,{A4+}
	MOVE.8	#"7".OR.2**6,{A4+}	; pseudo-code (7)
	MOVE.8	D0,{A4+}
	MOVE.8	#"8".OR.2**6,{A4+}	; pseudo-code (8)
	MOVE.8	D0,{A4+}
	MOVE.8	#"9".OR.2**6,{A4+}	; pseudo-code (9)
	MOVE.8	D0,{A4+}
	MOVE.8	#M0.AND.16'7F,{A4+}	; pseudo-code (M0)
	MOVE.8	D0,{A4+}
	MOVE.8	#M1.AND.16'7F,{A4+}	; pseudo-code (M1)
	MOVE.8	D0,{A4+}
	MOVE.8	#M2.AND.16'7F,{A4+}	; pseudo-code (M2)
	CLR.8	{A4}

	MOVE.32	#{A1}+OBUKEY,A4		; A4 <-- ^commandes
	MOVE.16	{A1}+ONOKEY,D2		; D2 <-- no du driver KEY_0
	MOVE.32	#TYPKEY,D1		; D1 <-- type driver clavier
	BIOS	?DCOMMAND		; rserve/libre touches

	POPM.32	D1|D2|A4
	TEST.16	D7			; retour EQ/NE
	RET




;--------\\
; COMMAND >
;========/

; in	A4.L	^table des commandes termine par zro
;	A6	^variables
; out	D7.W	erreur
; mod	D0..A1, D7.W

D0COMMAND:
	PUSHM.32 A4

	MOVE.32	A6,A1			; A1 <-- ^variables
L10$:
	TEST.8	{A4}			; fin de la table ?
	JUMP,EQ	R8^L50$
	CALL	WRONEC			; excute une commande
	TEST.16	D7			; commande ok ?
	JUMP,NE	R8^L90$			; non => 90$
	JUMP	L10$

L50$:
	CLR.16	D7			; D7 <-- ok
L90$:
	POPM.32	A4
	RET


;--------\\
; WRONEC  >
;========/

; Excute une commande.

; in	A4.L	^commande  excuter
;	A1.L	^variables
; out	A4.L	^commande suivante
; mod	D7.W, A4.L

WRONEC:
	PUSHM.32 D0..D1|A5

	CLR.16	D7			; D7 <-- ok

	MOVE.8	{A4+},D0		; D0 <-- type de la commande
	COMP.8	#MOUPOS,D0
	JUMP,EQ	L20$			; Positionnement
	COMP.8	#MOUSCA,D0
	JUMP,EQ	L60$			; Changement d'chelle
	COMP.8	#MOUACC,D0
	JUMP,EQ	L70$			; Rglage de la bote  vitesses
	JUMP	L89$			; Retour avec erreur

L20$:			; Positionnement
			; --------------
	MOVE.8	{A4+},D0		; D0 <-- high byte Y
	SL.16	#8,D0
	MOVE.8	{A4+},D0		; D0 <-- low byte  Y
	MOVE.16	D0,{A1}+OMOORI+0

	MOVE.8	{A4+},D0		; D0 <-- high byte X
	SL.16	#8,D0
	MOVE.8	{A4+},D0		; D0 <-- low byte  X
	MOVE.16	D0,{A1}+OMOORI+2

	CLR.32	{A1}+OMODLT
	CLR.32	{A1}+OMOLDL

	TEST.8	{A1}+OFLAGS:#BATTEND	; processus read attend ?
	JUMP,BS	L45$			; oui => 45$
					; non =>
	TSET.8	{A1}+OFLAGS:#BBOUGE	; signal souris bouge (!)
	JUMP	L90$

L45$:
	MOVE.32	{A1}+OSEMAS,A5		; A5 <-- ^smaphore
	NTREL	?SSIGNEV		; dbloque processus read
	CLR.16	D7			; D7 <-- ok
	JUMP	L90$

L60$:			; Changement d'chelle
			; --------------------
	CALL	GETVAR			; Mj la position courante
	MOVE.8	{A4+},D0		; D0 <-- l'chelle
	COMP.8	#2,D0			; Pas plus qu'chelle 1/3.
	JUMP,HI	L89$
	MOVE.8	D0,{A1}+OMOSCA		; Mmorise l'echelle
	MOVE.32	{A1}+OMOPOS,{A1}+OMOORI	; la prend comme nouvelle origine d'chelle
	CLR.32	{A1}+OMODLT		; Delta par rapport  la nouvelle origine nul
	CLR.32	{A1}+OMOLDL		; Dernier delta (pour acclration) aussi nul
	JUMP	L90$

L70$:			; Rglage de la bote  vitesses
			; ------------------------------
	CLR.16	D0
	MOVE.8	{A4+},D0		; D0 <-- limite 1re vitesse (5=moyen)
	CLR.16	D1
	MOVE.8	{A4+},D1		; D1 <-- limite 2me vitesse (5=moyen)

	COMP.16	#10,D0
	JUMP,HI	L89$			; Sur chelle de 10
	COMP.16	#10,D1
	JUMP,HI	L89$			; Valeur illgale => 89$: sortie avec erreur

	MOVE.8	D0,{A1}+OMOVI2		; Prpare pour RDSTATUS
	MOVE.8	D1,{A1}+OMOVI3

	.IF	SM8.or.SM324.or.COS21.or.SM196.OR.sm300.or.sm130
	MUL.16	#DEFAC2/5,D0		; Ajuste relativement  la valeur par dfaut
	MUL.16	#(DEFAC3-DEFAC2)/5,D1	; pour les 2 vitesses
	.ENDIF	SM8.or.SM324.or.COS21.or.SM196.OR.sm300.or.sm130

	.IF	SM100
	MUL.16	#DEFAC2/5/4,D0		; Ajuste relativement  la valeur par dfaut
	MUL.16	#(DEFAC3-DEFAC2)/5/4,D1	; pour les 2 vitesses
	.ENDIF	SM100

	MOVE.16	D0,{A1}+OMOAC2		; Mmorise le 1er changement de vitesse
	ADD.16	D0,D1
	MOVE.16	D1,{A1}+OMOAC3		; ainsi que le 2me
	JUMP	L90$
L89$:
	MOVE.16	#ERIRLG,D7		; D7 <-- erreur
L90$:
	POPM.32	D0..D1|A5
	RET




;--------\\
; RSTATUS >
;========/

; in	A4.L	^buffer
;	D4.L	longueur buffer
;	A6.L	^variables
; out	D4.L	longueur rendue effectivement
;	D7.W	erreur
; mod	D0..A1, D4.L, D7.W

D0RSTATUS:
	MOVE.32	A6,A1			; A1 <-- ^variables

	CLR.8	{A4}+OMOSIM		; met un "zro"
	TEST.8	{A1}+OFLAGS:#BSIMUL	; souris simule ?
	JUMP,BC	L10$			; non => 10$
	INC.8	{A4}+OMOSIM		; oui => met un "un"
L10$:
	MOVE.32	#LGMOU1,D0		; Prpare la longueur  rendre
	COMP.32	#LGMOU2,D4		; A-t-on demand plus ?
	JUMP,LO	L90$			; non => 90$

	MOVE.8	{A1}+OMOSCA,{A4}+OMOSCA	; Rend l'chelle utilise
	MOVE.8	{A1}+OMOVI2,{A4}+OMOVI2	; Ainsi que les 2 changements de vitesses
	MOVE.8	{A1}+OMOVI3,{A4}+OMOVI3
	MOVE.32	#LGMOU2,D0		; Prpare aussi la longueur  rendre
L90$:
	MOVE.32	D0,D4			; Rend la longueur effective dans D4
	CLR.16	D7			; D7 <-- ok
	RET





;--------\\
; READ    >
;========/

; in	A4.L	^buffer texte
;	D5.L	lg  lire
;	D7.W	=0
; out	D5.L	lg effectivement lue
;	D7.W	erreur
; mod	D7.W, D5.L

D0READ:
	PUSHM.32 D3|D4|A4

	MOVE.32	A6,A1			; A1 <-- ^variables

	COMP.32	#4,D5
	JUMP,LO	R8^L80$
	COMP.32	#6,D5
	JUMP,HI	R8^L80$

	CALL	RDONE			; lit la souris
	TEST.16	D7
	JUMP,NE	R8^L90$

	MOVE.8	D4,{A4}+1		; met X low
	SR.32	#10'8,D4
	MOVE.8	D4,{A4}+0		; met X high
	SR.32	#10'8,D4
	MOVE.8	D4,{A4}+3		; met Y low
	SR.32	#10'8,D4
	MOVE.8	D4,{A4}+2		; met Y high
	COMP.8	#4,D5
	JUMP,EQ	R8^L90$

	MOVE.8	D3,{A4}+4		; met les boutons

	COMP.8	#5,D5
	JUMP,EQ	R8^L90$

	CLR.8	{A4}+5			; met un "zro"
	TEST.8	{A1}+OFLAGS:#BSIMUL	; souris simule ?
	JUMP,BC	R8^L90$			; non => 90$
	INC.8	{A4}+5			; oui => met un "un"
	JUMP	R8^L90$

L80$:
	MOVE.16	#ERIRDL,D7		; D7 <-- "lg read illgale"
L90$:
	POPM.32	D3|D4|A4
	RET





;--------\\
; RDONE   >
;========/

; Lit une coordonne de la souris, et attend si tout est
; immobile.
; Si un signal arrive et que les informations lues sont
; identiques  la dernire lecture, attend encore !

; in	A1.L	^variables
;	D7.W	=0
; out	D3.B	boutons
;	D4.L	coorodnnes (Y;X)
;	D7.W	erreur
; mod	D3.B, D4.L, D7.W

RDONE:
	PUSHM.32 D0|A5
L10$:
	TSET.8	{A1}+OFLAGS:#BATTEND	; "on attend"
	TCLR.8	{A1}+OFLAGS:#BBOUGE	; souris dj bouge ?
	JUMP,BS	R8^L50$			; oui => 50$
	MOVE.32	{A1}+OSEMAS,A5		; A5 <-- ^smaphore
	NTREL	?WAITEV			; attend un mouvement ...
L50$:
	TCLR.8	{A1}+OFLAGS:#BBOUGE	; "on a vu un boug" vent.
	TCLR.8	{A1}+OFLAGS:#BATTEND	; "on n'attend plus
	TEST.16	D7
	JUMP,NE	L90$

	TEST.8	{A1}+OFLAGS:#BOBEIT	; On obit ?
	JUMP,BS	L55$
	CALL	GETVAR
L55$:
	MOVE.8	{A1}+OMOKEY,D3		; D3 <-- boutons
	MOVE.32	{A1}+OMOPOS,D4		; D4 <-- position souris (Y;X)

	COMP.8	{A1}+OMOLKY,D3		; idem  dernire touche ?
	JUMP,NE	L60$			; non => 60$
	COMP.32	{A1}+OMOLPO,D4		; idem  dernire position ?
	JUMP,EQ	L10$			; oui => 10$ (rien de nouveau)
L60$:
	MOVE.8	D3,{A1}+OMOLKY		; mm derniers boutons
	MOVE.32	D4,{A1}+OMOLPO		; mm dernire position

	TEST.8	{A1}+OFLAGS:#BESPION	; mode espion ?
	JUMP,BC	L70$			; non => sortie normale

	MOVE.32	{A1}+OSEMESP,A5		; id sm. d'espionnage
	NTREL	?SSIGNEV		; signale l'vnement
	PUSH.16	D4
	MOVE.16	#-1,D4			; pas de timeout
	NTREL	?MODTIM
	MOVE.32	{A1}+OSEMWESP,A5	; id sm. d'att. d'espionnage
	NTREL	?WAITEV			; attend prsence
	NTREL	?SETTIM
	POP.16	D4
L70$:
	CLR.16	D7			; D7 <-- ok
L90$:
	POPM.32	D0|A5
	RET



;--------\\
; GETVAR  >
;========/

; Transforme les variables rendues par la routine d'interrupt
; pour qu'elles soient utilisables (masques, chelle, etc).

; in	A1.L	^variables
; out	-
; mod	-

GETVAR:
	PUSHM.32 D0..D5|D7

	MOVE.8	{A1}+OMOIKY,D0

	.IF	SM324
	XOR.8	#2**BSOGAUC.OR.2**BSOCENT.OR.2**BSODROI,D0
	.ELSE	SM324
	.if	sm300.or.sm130
	.else
	NOT.8	D0			; 1 => actif !
	.endif	sm300.or.sm130
	AND.8	#2**BSOGAUC.OR.2**BSOCENT.OR.2**BSODROI,D0

	TEST.8	{A1}+OFLAGS:#BSIMUL	; souris simule ?
	JUMP,BS	L20$			; oui => 20$
					; non =>

	.IF	SM196
	MOVE.8	AdCioPortC, D1
	.ENDIF	SM196

	.IF	SM300.or.sm130
	MOVE.8	AdCla, d1
	.ENDIF	SM300.or.sm130


	.IF	SM100
	MOVE.8	VIA0+OVPB,D1
	.ENDIF 	SM100
	.IF	SM8
	MOVE.8	SOURIS+1,D1
	.ENDIF 	SM8
	.IF	COS21
	MOVE.8	PIT2_PBAR,D1
	.ENDIF	COS21
.if	sm300.or.sm130
.else
	NOT.8	D1			; 1 => actif
.endif	sm300.or.sm130
	AND.8	#2**BSOGAUC.OR.2**BSOCENT.OR.2**BSODROI,D1
	OR.8	D1,D0			; prend l'tat le meilleur
L20$:
	.IF	SM100.or.COS21.OR.sm196
	SL.8	#BMOLEFT-BSOGAUC,D0	; adapte aux dfinitions
	.ENDIF 	SM100.or.COS21.OR.sm196.
	.if	sm300
;	SL.8	#BSOGAUC-BMOLEFT,D0	; adapte aux dfinitions
	move.8	d0, d1
	sr.8	#3, d1
	and.8	#2**4, d1
	and.8	#2'01111111, d0
	or.8	d1, d0
	.endif	sm300
	.if	sm130
	move.8	d0, d1			; bit	6 en place
	and.8	#2**bMoRight+2**bMoCent, d0
	test.8	d1
	jump,pl	r8^s130$
	tset.32	d0:#bMoLeft
s130$:
	.endif	sm130

	.ENDIF	.not.SM324

	MOVE.8	D0,{A1}+OMOKEY		; =1 lorsqu'on appuie...

	MOVE.32	{A1}+OMODLT,D0		; Prend le delta en (Y;X)
	MOVE.32	D0,D2

	SUB.16	{A1}+OMOLDL+2,D2	; Dplacement depuis la dernire fois selon X
	MOVE.16	D2,D3			; Avec signe dans D3
	JUMP,NC	L25$
	NEG.16	D2			; Prend la valeur absolue dans D2
L25$:
	SWAP.32	D3
	SWAP.32	D2
	MOVE.16	D2,D1
	SWAP.32	D2
	SUB.16	{A1}+OMOLDL+0,D1	; Dplacement depuis la dernire fois selon Y
	MOVE.16	D1,D3			; Avec signe dans D3
	JUMP,NC	L30$
	NEG.16	D1			; Prend la valeur absolue dans D1
L30$:
	SWAP.32	D3
	COMP.16	D1,D2
	JUMP,GE	L35$
	EX.32	D1,D2
L35$:
	PUSHM.32 D2..D3
	NTREL	?GETSYTIME
	MOVE.32	{A1}+OSYTIME,D2		; Reprend l'ancien temps dans D2
	MOVE.32	D4,{A1}+OSYTIME		; R-init le temps courant
	SUB.32	D2,D4
	POPM.32	D2..D3
	DIV.16	#78,D4			; convertit D4 en units de 10 ms
	JUMP,EQ	L60$			; moins de 10 ms => pas d'valuation
	AND.32	#2**16-1,D2		; on ne s'intresse qu' D2.16
	DIV.16	D4,D2			; D2 dplacement -> vitesse points/10ms

	TEST.16	{A1}+OMOAC2		; Bote  vitesses dsactive ?
	JUMP,EQ	L60$			; eh oui, on ne touche pas  la vitesse
	COMP.16	{A1}+OMOAC2,D2		; Ca fonce dj pas mal ?
	JUMP,LT	L60$			; non => laisse la vitesse de manoeuvre
	COMP.16	{A1}+OMOAC3,D2		; A fond la gomme ?
	JUMP,GE	L50$			; oui => double l'avancement
L40$:
	ASR.16	D3			; sinon ajoute seulement la moiti
	SWAP.32	D3
	ASR.16	D3
	SWAP.32	D3
L50$:
	ADD.16	D3,D0			; oui => dcuple l'nergie de l'oprateur
	ADD.16	D3,{A1}+OMODLT+2	; Se rappelle de ce supplment de vitamines
	SWAP.32	D0
	SWAP.32	D3
	ADD.16	D3,D0			; la mme chose en Y
	ADD.16	D3,{A1}+OMODLT+0
	SWAP.32	D3
	SWAP.32	D0
L60$:
	MOVE.32	D0,{A1}+OMOLDL		; ainsi que de la nouvelle position

	MOVE.8	{A1}+OMOSCA,D1		; D1 <-- l'chelle 1/(n+1)
	.IF	SM8.or.SM324.or.COS21
	JUMP,EQ	L80$			; 1/1 => 80$
	.ENDIF	SM8.or.SM324.or.COS21
	.IF	SM100
	JUMP,NE	L70$			; <> 1/1 => 70$
	ASR.16	D1,D0			; 1/1 --> par compatibilit Sm8, --> *2
	SWAP.32	D0
	ASR.16	D1,D0
	SWAP.32	D0
	JUMP	L80$			; et c'est fini
L70$:
	DEC.8	D1			; sinon calcule n-1
	JUMP,EQ	L80$			; chelle 1/2 (=1/1 du Sm100) => 80$
	.ENDIF	SM100
	ASR.16	D1,D0			; modifie selon l'chelle (1/2,1/3)
	SWAP.32	D0
	ASR.16	D1,D0
	SWAP.32	D0
L80$:
	ADD.16	{A1}+OMOORI+2,D0	; Additionne selon l'origine du dernier changement
	SWAP.32	D0			; d'chelle
	ADD.16	{A1}+OMOORI+0,D0
	SWAP.32	D0

	MOVE.32	D0,{A1}+OMOPOS		; Position calcule rendue dans OMOPOS

	POPM.32	D0..D5|D7
	RET

;-----------------------------------------------------------------------------

;	GESTION DE $MOUSE_31
;	====================

; Module d'espionnage et de dictationnalit pour les beaux yeux pats d'un
; hypothtique passant....

; Attention: il s'agit de primitives SYSTEME, donc PAS de CONTROLES !


;---------\\
; RESET    >
;=========/

; Installation du driver d'espionnage

; in	-
; out	A6	^variables
;	D7	erreur
; mod	A6, A0,A1,D0,D1,D7

D31RESET:
	MOVE.32	#R16^D0BASE,A0
	MOVE.32	_INDNTR,A1
	CALL	{A1}+OIN_GETDRIVVAR	; A6 <-- ^var du driver $MOUSE_0
	RET



;--------\\
; OPEN    >
;========/

; Cre smaphore de synchro

; in	A6	^variables
; out	D7.16	erreur
; mod	D0..A1

D31OPEN:
	MOVE.32	A6,A1			; A1 <-- ^variables

	CLR.16	D4			; Smaphore de synchro
	NTREL	?CRESEM			; cre sma pour sync
	MOVE.32	A5,{A1}+OSEMESP		; se rappelle de l'id.
	NTREL	?CRESEM			; cre sma pour sync inverse
	MOVE.32	A5,{A1}+OSEMWESP	; se rappelle de l'id.

L90$:
	RET


;--------\\
; CLOSE   >
;========/

; Dtruit smaphgore de synchro, NE REMET PAS mode normal

; in	A6	^variables
; out	D7.16	erreur
; mod	D0..A1

D31CLOSE:
	MOVE.32	A6,A1			; A1 <-- ^variables

	MOVE.32	{A1}+OSEMESP,A5		; reprend l'id.
	NTREL	?KILLSEM
	MOVE.32	{A1}+OSEMWESP,A5	; reprend l'id.
	NTREL	?KILLSEM
	RET


;--------\\
; COMMAND >
;========/

; Accepte 3 commandes:
;			N	mode normal
;			E	espionnage (lecture possible)
;			R	obissance (criture possible)

; in	A4.L	^caractre de commande
;	A6	^variables
; out	D7.W	erreur
; mod	D0..A1, D7.W

D31COMMAND:
	PUSH.32	A5
	MOVE.32	A6,A1			; A1 <-- ^variables
	TCLR.8	{A1}+OFLAGS:#BESPION
	TCLR.8	{A1}+OFLAGS:#BOBEIT	; Suppose mode normal
	COMP.8	#"N",{A4}
	JUMP,EQ	L80$			; gagn, bien vu...
	COMP.8	#"E",{A4}		; espionnage ?
	JUMP,EQ	L70$
					; obissance:
	TSET.8	{A1}+OFLAGS:#BOBEIT	; met le bit corresp.

	CALL	DISABLEINT		; dsactive l'interruption

	MOVE.32	{A1}+OSEMWESP,A5
	NTREL	?SSIGNEV		; dbloque une vent. attente
	CLR.16	D7			; si erreur, normal
	JUMP	L90$

L70$:
	TSET.8	{A1}+OFLAGS:#BESPION	; Met le mode espion
	JUMP	L90$			; et c'est tout

L80$:
	MOVE.32	{A1}+OSEMWESP,A5
	NTREL	?SSIGNEV		; dbloque une vent. attente
	CLR.16	D7			; si erreur, normal

	TEST.8	{A1}+OFLAGS:#BSIMUL	; souris simule ?
	JUMP,BS	L90$			; oui => tout est dj fait

	CALL	INITINT			; ractive l'interruption
L90$:
	POP.32	A5
	RET


;--------\\
; READ    >
;========/

; Attente, et lecture d'une nouvelle position

; in	A4.L	^buffer texte
;	D5.L	= 5   lg  lire
;	A6	^variables
; out	{A4}+0.16	X
;	{A4}+2.16	Y
;	{A4}+4.8	boutons
;	D7.W	erreur
; mod	D7.W

D31READ:
	PUSH.32	A5
	MOVE.32	A6,A1			; A1 <-- ^variables

	MOVE.32	{A1}+OSEMESP,A5
	NTREL	?WAITEV			; Attend un changement

	MOVE.32	{A1}+OMOPOS,D0		; Prend la position
	MOVE.8	D0,{A4}+1
	SR.32	#8,D0
	MOVE.8	D0,{A4}			; Init en X
	SR.32	#8,D0
	MOVE.8	D0,{A4}+3
	SR.32	#8,D0
	MOVE.8	D0,{A4}+2		; init en Y
	MOVE.8	{A1}+OMOKEY,{A4}+4	; donne les boutons pour finir

	TEST.16	D7			; timeout dans ?WAITEV ?
	JUMP,NE	L30$			; oui => 30$
	MOVE.32	{A1}+OSEMWESP,A5
	NTREL	?SSIGNEV		; signale le traitement
	CLR.16	D7			; pas d'erreur possible
L30$:
	POP.32	A5
	RET


;--------\\
; WRITE   >
;========/

; Simulation d'une action de la souris.

; in	A4.L	^
;	{A4}+0.16	X
;	{A4}+2.16	Y
;	{A4}+4.8	boutons
;	D5.L	= 5  lg  crire
;	D7.16	=0
;	A6	^variables
; out	D5.L	lg effectivement crite
;	D7.W	erreur
; mod	D7.W, D5.L

D31WRITE:
	PUSHM.32 A5|D7
	MOVE.32	A6,A1			; A1 <-- ^variables

	MOVE.8	{A4}+2,D0
	SL.32	#8,D0
	MOVE.8	{A4}+3,D0		; Reprend en Y
	SL.32	#8,D0
	MOVE.8	{A4},D0
	SL.32	#8,D0
	MOVE.8	{A4}+1,D0		; Reprend en X
	MOVE.32	D0,{A1}+OMOPOS		; Prend la position
	MOVE.8	{A4}+4,{A1}+OMOKEY	; donne les boutons pour finir

	TEST.8	{A1}+OFLAGS:#BATTEND	; processus read attend ?
	JUMP,BS	L50$			; oui => 50$
					; non =>
	TSET.8	{A1}+OFLAGS:#BBOUGE	; signal souris bouge
	JUMP	L90$

L50$:
	MOVE.32	{A1}+OSEMAS,A5		; A5 <-- id smaphore
	NTREL	?SSIGNEV		; dbloque processus read
L90$:
	POPM.32	A5|D7
	RET



;-----------------------------------------------------------------------------


;--------\\
; PFILS   >
;========/

; Processus fils de gestion de la souris lorsqu'elle est
; simule avec le pav numrique.

NFILS:	.ASCIZ	"MOUSE_CONTROL"
	.EVEN

PFILS:	MOVE.32	A6,A1			; A1 <-- ^variables

	MOVE.32	#50,D4
	NTREL	?SETTIM

L10$:	TEST.8	{A1}+OFLAGS:#BFLEON
	JUMP,BS	R8^L15$
	TEST.8	{A1}+OFLAGS:#BFFILS
	JUMP,BS	L90$

	MOVE.16	{A1}+ONOKEY,D2		; D2 <-- no du driver KEY_0
	BIOS	?WFSKEY			; wait for special key ...
	JUMP,NE	L10$
	JUMP	R8^L20$

L15$:
	MOVE.16	#2,D4
	NTREL	?SETTIM
	MOVE.16	{A1}+ONOKEY,D2		; D2 <-- no du driver KEY_0
	BIOS	?WFSKEY			; wait for special key ...
	PUSH.16	D7
	MOVE.16	#50,D4
	NTREL	?SETTIM
	POP.16	D7
	JUMP,EQ	R8^L20$			; si nouvelle touche => 20$
	CLR.32	D3			; si repeat =>
	MOVE.8	{A1}+OOLKEY,D3		; D3 <-- dernire "flche"
L20$:
	TEST.8	{A1}+OFLAGS:#BOBEIT	; Obit sans agir ?
	JUMP,BS	L10$			; oui => on attend des temps meilleurs

	MOVE.16	{A1}+OKACCE,D4		; D4 <-- acclration

	COMP.8	#"1",D3
	JUMP,EQ	R8^L31$
	COMP.8	#"2",D3
	JUMP,EQ	R8^L32$
	COMP.8	#"3",D3
	JUMP,EQ	R8^L33$
	COMP.8	#"4",D3
	JUMP,EQ	R8^L34$
	COMP.8	#"6",D3
	JUMP,EQ	R8^L36$
	COMP.8	#"7",D3
	JUMP,EQ	R8^L37$
	COMP.8	#"8",D3
	JUMP,EQ	R8^L38$
	COMP.8	#"9",D3
	JUMP,EQ	R8^L39$

	TCLR.8	{A1}+OFLAGS:#BFLEON
	MOVE.32	D3,D0
	SWAP.32	D0			; D0 <-- pseudo-code + 2^7

	COMP.8	#M0.AND.16'7F,D0	; (M0) press ?
	JUMP,EQ	R8^L50$			; oui => 50$
	COMP.8	#M0,D0			; (M0) relach ?
	JUMP,EQ	R8^L51$			; oui => 51$

	COMP.8	#M1.AND.16'7F,D0	; (M1) press ?
	JUMP,EQ	R8^L52$			; oui => 52$
	COMP.8	#M1,D0			; (M1) relach ?
	JUMP,EQ	R8^L53$			; oui => 53$

	COMP.8	#M2.AND.16'7F,D0	; (M2) press ?
	JUMP,EQ	L54$			; oui => 54$
	COMP.8	#M2,D0			; (M2) relach ?
	JUMP,EQ	L55$			; oui => 55$

	MOVE.16	#1,{A1}+OKACCE		; repart lentement
	JUMP	L10$

L31$:
	SUB.16	D4,{A1}+OMODLT+2	; recule X
	ADD.16	D4,{A1}+OMODLT+0	; descend Y
	JUMP	R8^L60$

L32$:
	ADD.16	D4,{A1}+OMODLT+0	; descend Y
	JUMP	R8^L60$

L33$:
	ADD.16	D4,{A1}+OMODLT+2	; avance X
	ADD.16	D4,{A1}+OMODLT+0	; descend Y
	JUMP	R8^L60$

L34$:
	SUB.16	D4,{A1}+OMODLT+2	; recule X
	JUMP	R8^L60$

L36$:
	ADD.16	D4,{A1}+OMODLT+2	; avance X
	JUMP	R8^L60$

L37$:
	SUB.16	D4,{A1}+OMODLT+2	; recule X
	SUB.16	D4,{A1}+OMODLT+0	; monte Y
	JUMP	R8^L60$

L38$:
	SUB.16	D4,{A1}+OMODLT+0	; monte Y
	JUMP	R8^L60$

L39$:
	ADD.16	D4,{A1}+OMODLT+2	; avance X
	SUB.16	D4,{A1}+OMODLT+0	; monte Y
	JUMP	R8^L60$

L50$:
	TCLR.8	{A1}+OMOIKY:#BSOGAUC
	JUMP,BC	L10$
	JUMP	R8^L62$

L51$:
	TSET.8	{A1}+OMOIKY:#BSOGAUC
	JUMP,BS	L10$
	JUMP	R8^L62$

L52$:
	TCLR.8	{A1}+OMOIKY:#BSOCENT
	JUMP,BC	L10$
	JUMP	R8^L62$

L53$:
	TSET.8	{A1}+OMOIKY:#BSOCENT
	JUMP,BS	L10$
	JUMP	R8^L62$

L54$:
	TCLR.8	{A1}+OMOIKY:#BSODROI
	JUMP,BC	L10$
	JUMP	R8^L62$

L55$:
	TSET.8	{A1}+OMOIKY:#BSODROI
	JUMP,BS	L10$
	JUMP	R8^L62$

L60$:
	MOVE.8	D3,{A1}+OOLKEY		; mm. dernire "flche"
	TSET.8	{A1}+OFLAGS:#BFLEON

	ADD.16	#1,{A1}+OKACCE		; acclre ...
	COMP.16	#10,{A1}+OKACCE		; passe la 2me ?
	JUMP,LO	L62$			; non => 62$
	ADD.16	#2,{A1}+OKACCE		; acclre encore plus
	COMP.16	#35,{A1}+OKACCE		; champignon  fond ?
	JUMP,LO	L62$			; non => 62$
	MOVE.16	#35,{A1}+OKACCE		; plafond (vitesse maximale)
L62$:
	TEST.8	{A1}+OFLAGS:#BATTEND	; processus read attend ?
	JUMP,BS	R8^L65$			; oui => 65$
					; non =>
	TSET.8	{A1}+OFLAGS:#BBOUGE	; signal souris bouge
	JUMP	L10$

L65$:
	MOVE.32	{A1}+OSEMAS,A5		; A5 <-- ^smaphore
	NTREL	?SSIGNEV		; signale un mouvement
	JUMP	L10$

L90$:
	NTREL	?ABORT



;---------\\
; INITINT  >
;=========/

; active l'interruption souris

; in	-
; out	int. active
; mod	D0,D1,A0,A1,F

INITINT:
	.IF	SM196
	PUSHM.32 A2|A3
	MOVE.32	#R16^IntMouse50Hz, A1
	MOVE.32	#R16^IntMouseXY, A2
	MOVE.32	_INDSHI,A0
	CALL	{A0}+_InitIntMouse
	POPM.32	A2|A3
	RET
	.ENDIF	SM196
	.IF	SM130
	PUSHM.32 A2|A3
	MOVE.32	#R16^IntMouse50Hz,A1
	MOVE.32	#R16^IntMouseXY,A2
	CALL	{_indShi}+_InitIntMouse
	POPM.32	A2|A3
	RET
	.ENDIF	SM130

	.IF	SM300
	PUSH.16	SF
	MOVE.16	#16'2500, SF
	PUSH.32	A2
	MOVE.32	#R16^IntMouse50Hz, A1
	MOVE.32	_INDSHI, A0
	CALL	{A0}+_InitIntMouse

	MOVE.32	#R16^IntMouseXY, A1
	MOVE.32	#AdVectCioPortB, A0
	MOVE.32	_INDNTR, A2
	CALL	{A2}+OIN_InitVector	; initialise le vecteur d'interruption

	MOVE.8	#CioPortBComST, AdCioControl
	WaitCio
	MOVE.8	#McioClrIPIUS, AdCioControl
	WaitCio

	;modification Pattern Polarity Register
	MOVE.8	#CioPortBPatPol, AdCioControl
	waitCio
	move.8	#2'00000000, AdCioControl

	;Modification Pattern Transition Register
	MOVE.8	#CioPortBPatTra, AdCioControl
	WaitCio

	move.8	#2'11001100, AdCioControl
	WaitCio

	;Modification Pattern Mask Register
	MOVE.8	#CioPortBPatMsk, AdCioControl
	waitCio
	move.8	#2'00000000, AdCioControl
	WaitCio

	;Sert une ventuelle requte d'interruption tranante
	MOVE.8	#CioPortBComSt, AdCioControl
	WaitCio
	MOVE.8	#MCioClrIPIUS, AdCioControl
	WaitCio
	MOVE.8	#CioPortBComSt, AdCioControl
	WaitCio
	MOVE.8	#MCioSetIE, AdCioControl	; autorise les interruptions pour le port B
	POP.32		A2
	POP.16		SF
	.ENDIF	SM300

	.IF	SM100
	MOVE.32	#R16^MINTER,A1
	MOVE.32	_INDSHI,A0		; init vecteur
	CALL	{A0}+_INIMOUSEINT	; et les variables d'interruption
	MOVE.8	#2**7.OR.2**BVIMOX.OR.2**BVIMOY,VIA0+OVIER; set mouse interrupt enable
				 	; et donne ^routine 50 Hz  $KEY par le SHI
	.ENDIF 	SM100

	.IF	SM8
	MOVE.16	#IRMOU,D1
	MOVE.32	#R16^MINTER,A1
	CALL	A16^_ININIAD		; init vecteur interrupt + ^vars A6
	CALL	A16^_ISEACR		; mode auto-clear
	CALL	A16^_ICLMRR		; clear mask and int. request
	.ENDIF 	SM8

	.IF	SM324
	MOVE.32	#R16^MINTER,A1		; initialise l'interruption:
	MOVE.32	32^_INDSHI,A0
	MOVE.16	#PPIMOUSE,D0
	CALL	{A0}+_INIRCVPPI		; init int. lecture PPI pour paquets souris
	.ENDIF	SM324

	.IF	COS21
	PUSHM.32 A1|D0
	MOVE.32	#R16^MINTER,A1
	MOVE.32	_INDSHI,A0
	CALL	{A0}+_INIMOUSEINT
	POPM.32	A1|D0
	OR.8	#H1ION,PIT2_PACR	; initialise les interruptions X et Y
	OR.8	#H3ION,PIT2_PBCR
	.ENDIF	COS21

	RET

.IF	SM300.OR.SM130

;-------------\\
; IntMouse50Hz >
;=============/

; Pseudo routine d'interruption appele par le clavier
; pour venir lire l'tat des boutons de la souris

; in	
; out	
; mod

IntMouse50Hz:
	SUB.32	A1,A1
	MOVE.8	AdCla,D0
	MOVE.8	{A0}+OMOIKY,D1

MASK	== 2**BSOGAUC+2**BSODROI+2**BSOCENT

	AND.8	#MASK,D0		; masque les bons bits
	MOVE.8	D0,{A0}+OMOIKY		; met  jour l'tat des boutons
	XOR.8	D0,D1			; changement par rapport  l'tat prcdent ?
	JUMP,EQ	OUT$			; non => rien n'a chang
					; oui =>
	TEST.8	{A0}+OFlags:#BATTEND
	JUMP,BS	Signev$
	CLR.16	D1
	TSET.8	{A0}+OFlags:#BBOUGE	; signale souris bouge
	JUMP	Out$
Signev$:
	MOVE.32	{A0}+OSEMAS, A1
	MOVE.16	#1,D1
Out$:	RET
.ENDIF	SM300.OR.SM130

.IF	SM130

;-----------\\
; IntMouseXY >
;===========/

; in	
; out	
; mod

IntMouseXY:
	AND.16		#16'FF,D0
	SR.8		#2,D0
	MOVE.8		D0,D1
	SR.8		#2,D1
	AND.8		#2'00000011,D0
	AND.8		#2'00001100,D1
	OR.8		D1,D0			; Yb Ya Xb Xa --> D0.4
;	AND.16		#16'F,D0		; ne garde que les bits significatifs
	MOVE.16		{A0}+OLDPOS,D1		; lit l'tat prcdent
	MOVE.16		D0,{A0}+OLDPOS		; met  jour l'tat "prcdent"

	MOVE.32		#R16^SwapTable,A1
	MOVE.8		{A1}+A16^{D0},D0	; Ya Yb Xa Xb --> D0.4
	XOR.8		D1,D0
	MOVE.32		#R16^DplTable,A1	; table des dplacments
	SL.16		#2,D0
	MOVE.32		{A1}+A16^{D0},D0	; incrments --> D0.32
	ADD.16		D0,{A0}+OMODLT+2	; met  jour delta X
	SWAP.32		D0
	ADD.16		D0,{A0}+OMODLT+0	; met  jour delta Y
	TEST.8		{A0}+OFlags:#BAttend	;
	JUMP,BS		Signev$
	TSET.8		{A0}+OFlags:#BBouge
	JUMP		Out$
Signev$:
	MOVE.32		{A0}+OSemas,A1
	CALL		A16^_ISSIGNEV
Out$:
.if	false
	MOVE.8		#CioPortBComSt,AdCioControl
	WaitCio
	MOVE.8		#MCioClrIPIUS,AdCioControl
.endif	false
	RET
;
SwapTable:			; table de permutation Yb Ya Xb Xa --> Ya Yb Xa Xb
	.8	2'0000	; 0000
	.8	2'0010	; 0001
	.8	2'0001	; 0010
	.8	2'0011	; 0011
	.8	2'1000	; 0100
	.8	2'1010	; 0101
	.8	2'1001	; 0110
	.8	2'1011	; 0111
	.8	2'0100	; 1000
	.8	2'0110	; 1001
	.8	2'0101	; 1010
	.8	2'0111	; 1011
	.8	2'1100	; 1100
	.8	2'1110	; 1101
	.8	2'1101	; 1110
	.8	2'1111	; 1111
DplTable:
	.16.16	 0,  0		; 0000	00 00
	.16.16	 0, -1		; 0001	00 10
	.16.16	 0, +1		; 0010	00 01
	.16.16	 0,  0		; 0011	00 11
	.16.16	-1,  0		; 0100	10 00
	.16.16	-1, -1		; 0101	10 10
	.16.16	-1, +1		; 0110	10 01
	.16.16	-1,  0		; 0111	10 11
	.16.16	+1,  0		; 1000	01 00
	.16.16	+1, -1		; 1001	01 10
	.16.16	+1, +1		; 1010	01 01
	.16.16	+1,  0		; 1011	01 11
	.16.16	 0,  0		; 1100	11 00
	.16.16	 0, -1		; 1101	11 10
	.16.16	 0, +1		; 1110	11 01
	.16.16	 0,  0		; 1111	11 11

.ENDIF	SM130

.if	sm300

;-----------\\
; IntMouseXY >
;===========/
;
; 
;
; in	
; out	
; mod
;
IntMouseXY:
	MOVE.8		AdCioPortB, D0
	SR.8		#2, D0
	MOVE.8		D0, D1
	SR.8		#2, D1
	AND.8		#2'00000011, D0
	AND.8		#2'00001100, D1
	OR.8		D1, D0			; Yb Ya Xa Xb --> D0.4
;	AND.16		#16'F, D0		; ne garde que les bits significatifs
	MOVE.16		{A0}+OLDPOS, D1		; lit l'tat prcdent
	MOVE.16		D0, {A0}+OLDPOS		; met  jour l'tat "prcdent"

	MOVE.32		#R16^SwapTable, A1
	MOVE.8		{A1}+A16^{D0}, D0	; Ya Yb Xa Xb --> D0.4
	XOR.8		D1, D0
	MOVE.32		#R16^DplTable, A1	; table des dplacments
	SL.16		#2, D0
	MOVE.32		{A1}+A16^{D0}, D0	; incrments --> D0.32
	ADD.16		D0, {A0}+OMODLT+2	; met  jour delta X
	SWAP.32		D0
	ADD.16		D0, {A0}+OMODLT+0	; met  jour delta Y
	TEST.8		{A0}+OFlags:#BAttend	;
	JUMP,BS		Signev$
	TSET.8		{A0}+OFlags:#BBouge
	JUMP		Out$
Signev$:
	MOVE.32		{A0}+OSemas, A1
	CALL		A16^_ISSIGNEV
Out$:
	MOVE.8		#CioPortBComSt, AdCioControl
	WaitCio
	MOVE.8		#MCioClrIPIUS, AdCioControl
	RET
;
SwapTable:			; table de permutation Yb Ya Xb Xa --> Ya Ab Xa Xb
	.8	2'0000
	.8	2'0010
	.8	2'0001
	.8	2'0011
	.8	2'1000
	.8	2'1010
	.8	2'1001
	.8	2'1011
	.8	2'0100
	.8	2'0110
	.8	2'0101
	.8	2'0111
	.8	2'1100
	.8	2'1110
	.8	2'1101
	.8	2'1111
DplTable:
	.16.16	 0,  0		; 0000	00 00
	.16.16	 0, -1		; 0001	00 10
	.16.16	 0, +1		; 0010	00 01
	.16.16	 0,  0		; 0011	00 11
	.16.16	-1,  0		; 0100	10 00
	.16.16	-1, -1		; 0101	10 10
	.16.16	-1, +1		; 0110	10 01
	.16.16	-1,  0		; 0111	10 11
	.16.16	+1,  0		; 1000	01 00
	.16.16	+1, -1		; 1001	01 10
	.16.16	+1, +1		; 1010	01 01
	.16.16	+1,  0		; 1011	01 11
	.16.16	 0,  0		; 1100	11 00
	.16.16	 0, -1		; 1101	11 10
	.16.16	 0, +1		; 1110	11 01
	.16.16	 0,  0		; 1111	11 11
.ENDIF	SM300

;------------\\
; DISABLEINT  >
;============/

; dsactive l'interruption souris

; in	-
; out	int. dsactive
; mod	D0,D1,A0,A1,F

DISABLEINT:
	.IF	SM100
	MOVE.32	#0,A1
	MOVE.32	_INDSHI,A0		; disable vecteur + "int." 50 Hz
	CALL	{A0}+_INIMOUSEINT	; et les variables d'interruption
	MOVE.8	#2**BVIMOX.OR.2**BVIMOY,VIA0+OVIER; set mouse interrupt enable
				 	; et plus de ^routine 50 Hz  $KEY
	.ENDIF 	SM100

	.IF	SM8
	MOVE.16	#IRMOU,D1
	CALL	A16^_ISEIMR		; set interrupt mask
	.ENDIF 	SM8

	.IF	SM324
	MOVE.32	#0,A1
	MOVE.32	32^_INDSHI,A0
	MOVE.16	#PPIMOUSE,D0
	CALL	{A0}+_INIRCVPPI		; disable int. souris
	.ENDIF	SM324

	.IF	COS21
	AND.8	#-1-H1ION,PIT2_PACR	; dsactive les interruptions X et Y
	AND.8	#-1-H3ION,PIT2_PACR
	.ENDIF	COS21

	RET

.IF	SM196

;-------------\\
; IntMouse50Hz >
;=============/
;
; Pseudo routine d'interruption appele par le clavier
; pour venir lire l'tat des boutons de la souris
;
; in	
; out	
; mod
;
IntMouse50Hz:
	SUB.32		A1,A1
	MOVE.8		AdCioPortC,D0
	MOVE.8		{A0}+OMOIKY,D1
;TSET.32	D0:#BSODROI
	AND.8		#2**BSOGAUC+2**BSODROI+2**BSOCENT, D0 ; masque les bons bits
	MOVE.8		D0,{A0}+OMOIKY		; met jour l'tat des boutons
	XOR.8		D0,D1			; changement par rapport  l'tat prcdent ?
	JUMP,EQ		OUT$			; non => Out$
						; oui =>
	TEST.8		{A0}+OFlags:#BATTEND
	JUMP,BS		Signev$
	CLR.16		D1
	TSET.8		{A0}+OFlags:#BBOUGE	; signale souris bouge
	JUMP		Out$
Signev$:
	MOVE.32		{A0}+OSEMAS,A1
	MOVE.32		#1,D1
Out$:	RET

;
.IF	Nouveau
;-----------\\
; IntMouseXY >
;===========/
;
; 
;
; in	
; out	
; mod
;
IntMouseXY:

;	MOVE.8		CioPortB, D0		; Yb Ya Xb Xa --> D0.4
	AND.16		#16'F, D0		; ne garde que les bits significatifs
	MOVE.16		{A0}+OLDPOS, D1		; lit l'tat prcdent
	MOVE.16		D0, {A0}+OLDPOS		; met  jour l'tat "prcdent"

	MOVE.32		#R16^SwapTable, A1
	MOVE.8		{A1}+A16^{D0}, D0	; Ya Yb Xa Xb --> D0.4
	XOR.8		D1, D0
	MOVE.32		#R16^DplTable, A1	; table des dplacments
	SL.16		#2, D0
	MOVE.32		{A1}+A16^{D0}, D0	; incrments --> D0.32
	ADD.16		D0, {A0}+OMODLT+2	; met  jour delta X
	SWAP.32		D0
	ADD.16		D0, {A0}+OMODLT+0	; met  jour delta Y
	TEST.8		{A0}+OFlags:#BAttend	;
	JUMP,BS		Signev$
	TSET.8		{A0}+OFlags:#BBouge
	JUMP		Out$
Signev$:
	MOVE.32		{A0}+OSemas, A1
	CALL		A16^_ISSIGNEV
Out$:
;	Wrcio		#MCioClrIPIUS, PortBComSt
	RET
;
SwapTable:			; table de permutation Yb Ya Xb Xa --> Ya Ab Xa Xb
	.8	2'0000
	.8	2'0010
	.8	2'0001
	.8	2'0011
	.8	2'1000
	.8	2'1010
	.8	2'1001
	.8	2'1011
	.8	2'0100
	.8	2'0110
	.8	2'0101
	.8	2'0111
	.8	2'1100
	.8	2'1110
	.8	2'1101
	.8	2'1111
DplTable:
	.16.16	 0,  0		; 0000	00 00
	.16.16	 0, +1		; 0001	00 10
	.16.16	 0, -1		; 0010	00 01
	.16.16	 0,  0		; 0011	00 11
	.16.16	-1,  0		; 0100	10 00
	.16.16	-1, +1		; 0101	10 10
	.16.16	-1, -1		; 0110	10 01
	.16.16	-1,  0		; 0111	10 11
	.16.16	+1,  0		; 1000	01 00
	.16.16	+1, +1		; 1001	01 10
	.16.16	+1, -1		; 1010	01 01
	.16.16	+1,  0		; 1011	01 11
	.16.16	 0,  0		; 1100	11 00
	.16.16	 0, +1		; 1101	11 10
	.16.16	 0, -1		; 1110	11 01
	.16.16	 0,  0		; 1111	11 11
.else
;----------\\
; IntMouseX >
;==========/
;
; Routine d'interruption souris pour un dplacement en X
; Cette interruption est appele chaque fois que le bit 0 passe de 0  1
; si le bit no 1 vaut 1 on dplace la souris  gauche 
;
; in	A0.32	^variables
; out	
; mod
;
IntMouseX:
	MOVE.8		CioPortB, D0
;mon	?aftim
;.ascize	"X"

	TEST.32		D0:#1			; dplacement  gauche ?
	JUMP,Bc		Gauche$			; oui => Gauche$
						; non =>
;MON	?AFTIM
;.ASCIZE	"+"
	INC.16		{A0}+OMODLT+2
	JUMP		Signal$
Gauche$:
;mon	?aftim
;.ascize	"-"
	DEC.16		{A0}+OMODLT+2
Signal$:
	TEST.8		{A0}+OFlags:#BATTEND
	JUMP,BS		Signev$
	TSET.8		{A0}+OFlags:#BBOUGE	; signale souris bouge
	JUMP		Out$
Signev$:
	MOVE.32		{A0}+OSEMAS, A1
	CALL		A16^_ISSIGNEV
Out$:
	OR.16		#SFIOF, SF
	WrCio		#MCioClrIPIUS, PortBComST	; clear l'interrupt du port B
	RET
;
;----------\\
; IntMouseY >
;==========/
;
; Routine d'interruption souris pour un dplacement en Y
; Cette interruption est appele chaque fois que le bit 2 passe de 0  1
; si le bit no 3 vaut 1 on dplace la souris vers le bas
;
; in	A0.32	^varIables
; out	
; mod
;
IntMouseY:
	MOVE.8		CioPortB, D0
;mon	?aftim
;.ascize	"Y"
	TEST.32		D0:#3			; dplacement vers le bas ?
	JUMP,Bc		Bas$			; oui => Bas$
						; non =>
;mon	?aftim
;.ascize	"-"
	DEC.16		{A0}+OMODLT+0
	JUMP		Signal$
Bas$:
	inc.16		{A0}+OMODLT+0
;mon	?aftim
;.ascize	"+"
Signal$:
	TEST.8		{A0}+OFlags:#BATTEND
	JUMP,BS		Signev$
	TSET.8		{A0}+OFlags:#BBOUGE	; signale souris bouge
	JUMP		Out$
Signev$:
	MOVE.32		{A0}+OSEMAS, A1
	CALL		A16^_ISSIGNEV
Out$:
	OR.16		#SFIOF, SF
	WrCio		#MCioClrIPIUS, PortBComSt; clear l'interrupt du port B
	RET
;
.ENDIF	Mouveau
.ENDIF	SM196

;--------\\
; MINTER  >
;========/

; Routine d'interruption pour la souris.
	.IF	SM100.or.COS21
; Routine de traitement 50 Hz
	.ENDIF	SM100.or.COS21

; In	A0	^variables
; Out	A1.L	^smaphore o faire INSIGNAL
;	D1.W	Limite de la variable E
; Mod	D0,D1,A0,A1

	.IF	SM100
MINTER:
;;;	PUSHM.32 D0|D1|A0|A1		; Sauvetage par le SHI (ou $KEY)
	PUSH.32	D7
	MOVE.8	VIA0+OVIFR,D0		; D0 <-- flags interrupt souris
	MOVE.8	VIA0+OVPB,D1		; D1 <-- status souris

	TEST.32	D0:#BVIMOX		; interrupt coordonne en X ?
	JUMP,BC	L30$			; non => 30$

	TEST.32	D1:#BMPBX		; +/- ?
	JUMP,BS	L25$			; dcrmente => 25$

	INC.16	{A0}+OMODLT+2
	JUMP	L30$
L25$:
	DEC.16	{A0}+OMODLT+2

L30$:
	TEST.32	D0:#BVIMOY		; interrupt coordonne en Y ?
	JUMP,BC	L40$			; non => 40$

	TEST.32	D1:#BMPBY		; +/- ?
	JUMP,BC	L35$			; dcrmente => 35$

	INC.16	{A0}+OMODLT+0
	JUMP	L40$
L35$:
	DEC.16	{A0}+OMODLT+0

L40$:
	MOVE.8	{A0}+OMOIKY,D7		; reprend l'ancien tat
	AND.8	#2**BSOGAUC+2**BSODROI+2**BSOCENT,D1 ; masque les bons bits
	MOVE.8	D1,{A0}+OMOIKY		; mmorise boutons souris
	XOR.8	D1,D7			; changement d'tat des boutons ?
	JUMP,NE	L45$			; oui => regarde pour signaler
	AND.8	#2**BVIMOX+2**BVIMOY,D0	; interrupt coordonne en X actif ?
	JUMP,EQ	L90$			; non => ne signale pas de changement
L45$:
	TEST.8	{A0}+OFLAGS:#BATTEND	; processus read attend ?
	JUMP,BS	L50$			; oui => 50$
					; non =>
	TSET.8	{A0}+OFLAGS:#BBOUGE	; signal souris bouge
	MOVE.32	#0,A1			; met flag "pas de signal"
	JUMP	L90$

L50$:
	MOVE.32	{A0}+OSEMAS,A1		; A1 <-- ^smaphore
	MOVE.16	#1,D1			; D1 <-- pour faire ISSIGNAL
L90$:
	POP.32	D7
;;;	POPM.32	D0|D1|A0|A1		; sauvetage et ISSIGNAL par SHI
	RET				; retour au SHI

	.ENDIF 	SM100
	.IF	COS21
MINTER:
;;;	PUSHM.32 D0|D1|A0|A1		; Sauvetage par le SHI (ou $KEY)
	PUSH.32	D7

	MOVE.8	PIT2_PSR,D0		; D0 <-- flags interrupt souris
	MOVE.8	PIT2_PBAR,D1		; D1 <-- status souris

	TEST.32	D0:#BMISX		; interrupt coordonne en X ?
	JUMP,BC	L30$			; non => 30$
	MOVE.8	#2**BMISX,PIT2_PSR	; clear l'entre d'int. level-sensible

	TEST.32	D1:#BMSX		; +/- ?
	JUMP,BC	L25$			; dcrmente => 25$

	INC.16	{A0}+OMODLT+2
	JUMP	L30$
L25$:
	DEC.16	{A0}+OMODLT+2

L30$:
	TEST.32	D0:#BMISY		; interrupt coordonne en Y ?
	JUMP,BC	L40$			; non => 40$
	MOVE.8	#2**BMISY,PIT2_PSR	; clear l'entre d'int. level-sensible


	TEST.32	D1:#BMSY		; +/- ?
	JUMP,BS	L35$			; dcrmente => 35$

	INC.16	{A0}+OMODLT+0
	JUMP	L40$
L35$:
	DEC.16	{A0}+OMODLT+0

L40$:
	MOVE.8	{A0}+OMOIKY,D7		; reprend l'ancien tat
	AND.8	#2**BSOGAUC+2**BSODROI+2**BSOCENT,D1 ; masque les bons bits
	MOVE.8	D1,{A0}+OMOIKY		; mmorise boutons souris
	XOR.8	D1,D7			; changement d'tat des boutons ?
	JUMP,NE	L45$			; oui => regarde pour signaler
	AND.8	#2**BMISX+2**BMISY,D0	; interrupt coordonne en X actif ?
	JUMP,EQ	L90$			; non => ne signale pas de changement
L45$:
	TEST.8	{A0}+OFLAGS:#BATTEND	; processus read attend ?
	JUMP,BS	L50$			; oui => 50$
					; non =>
	TSET.8	{A0}+OFLAGS:#BBOUGE	; signal souris bouge
	JUMP	L90$

L50$:
	MOVE.32	{A0}+OSEMAS,A1		; A1 <-- ^smaphore
	CALL	A16^_ISSIGNEV
L90$:
	POP.32	D7
;;;	POPM.32	D0|D1|A0|A1		; sauvetage par SHI
	RET				; retour au SHI
	.ENDIF	COS21
	.IF	SM8
MINTER:
	MOVE.16	SOURIS,D1		; D1 <-- status souris
	MOVE.8	D1,{A0}+OMOIKY		; mm boutons souris
	AND.16	#MSOSENS,D1		; prend seulement les diodes

	MOVE.32	#R16^SWPTBL,A1		; permutte les deux bits
	CLR.16	D0
	MOVE.8	{A1}+A16^{D1},D0

	PUSH.16	D2
	MOVE.16	{A0}+OLDPOS,D2		; make mixing
	XOR.16	D2,D0
	MOVE.16	D1,{A0}+OLDPOS		; update new "old status"
	POP.16	D2

	SL.16	#2,D0			; .WW dans la table
	MOVE.32	#R16^DSPTBL,A1		; A1 <-- ^table dplacements
	MOVE.32	{A0}+OMODLT,D1		; D1 <-- delta (Y	;X) actuel
	ADD.16	{A1}+A16^{D0}+2,D1	; ajoute dplacement en X
	SWAP.32	D1
	ADD.16	{A1}+A16^{D0}+0,D1	; ajoute dplacement en Y
	SWAP.32	D1
	MOVE.32	D1,{A0}+OMODLT		; met  jour nouveau delta

	TEST.8	{A0}+OFLAGS:#BATTEND	; processus read attend ?
	JUMP,BS	R8^L50$			; oui => 50$
					; non =>
	TSET.8	{A0}+OFLAGS:#BBOUGE	; signal souris bouge
	JUMP	R8^L90$

L50$:
	MOVE.32	{A0}+OSEMAS,A1		; A1 <-- ^smaphore
	CALL	A16^_ISSIGNEV		; dbloque processus read
L90$:
	RET

SWPTBL:
	.8	2'0000
	.8	2'0100
	.8	2'1000
	.8	2'1100
	.8	2'0001
	.8	2'0101
	.8	2'1001
	.8	2'1101
	.8	2'0010
	.8	2'0110
	.8	2'1010
	.8	2'1110
	.8	2'0011
	.8	2'0111
	.8	2'1011
	.8	2'1111
	.EVEN

DSPTBL:
	.16.16	0,0		; 0000	00 00
	.16.16	-1,0		; 0001	00 01
	.16.16	0,+1		; 0010	01 00
	.16.16	-1,+1		; 0011	01 01
	.16.16	+1,0		; 0100	00 10
	.16.16	0,0		; 0101	00 11
	.16.16	+1,+1		; 0110	01 10
	.16.16	0,+1		; 0111	01 11
	.16.16	0,-1		; 1000	10 00
	.16.16	-1,-1		; 1001	10 01
	.16.16	0,0		; 1010	11 00
	.16.16	-1,0		; 1011	11 01
	.16.16	+1,-1		; 1100	10 10
	.16.16	0,-1		; 1101	10 11
	.16.16	+1,0		; 1110	11 10
	.16.16	0,0		; 1111	11 11
	.ENDIF 	SM8

	.IF	SM324
MINTER:
;;;	PUSHM.32 D0..D3|A0|A1		; Sauvetage par le SHI

; in D0.32:	<no souris><delX><delY><boutons>

	MOVE.8	D0,{A0}+OMOIKY		; mmorise boutons souris

	SR.32	#8,D0			; D0.8 <-- delY
	MOVE.8	D0,D1
	CONV.A8.16 D1
	SUB.16	D1,{A0}+OMODLT+0

	SR.16	#8,D0			; D0.8 <-- delX
	CONV.A8.16 D0
	ADD.16	D0,{A0}+OMODLT+2

	TEST.8	{A0}+OFLAGS:#BATTEND	; processus read attend ?
	JUMP,BS	L50$			; oui => 50$
					; non =>
	TSET.8	{A0}+OFLAGS:#BBOUGE	; signal souris bouge
	JUMP	L90$

L50$:
	MOVE.32	{A0}+OSEMAS,A1		; A1 <-- ^smaphore
	CALL	A16^_ISSIGNEV		; dbloque processus read
L90$:
;;;	POPM.32	D0..D3|A0|A1		; sauvetage par SHI
	RET				; retour au SHI

	.ENDIF 	SM324


NAKEY0:	.ASCIZ	"KEY_0"			; $ pour souris simule par le clavier
	.EVEN



	.END

