\define g_Fond:\nef11;
\define g_ev:\n(bf)09;
\define g_titre:\m(f)17;
\define g_it:\n(if)07;
\define g_comment:\n(f)06;
\define g_Lynx:\kip15;
; $sma; $flg:05010002 $erh:POST

	.TITLE		\g_titre;POST.ASD\g_Fond;
; pilote pour l'imprimante laser POST
	.PROC		M68000
	.REF		SMAKY
	.REF		MODULES		; utilise STRETCH et GRA
	.REF		BIOSDRIV
	.REF		BIOS
\g_it;;	.REF		RIC324
\g_Fond;	.REF		PAGEPS		; utilise librairie PagePS de P.A.
	.REF		Mon

MajRev		= 	6		; rvision majeur (minimum pour PRINTA)
MinRev		= 	17		; rvision mineure

; Rv   Date      Qui	Commentaires
; -------------------------------------------------------------------------------------
; 6.17	16/09/99  PA	Correction ?
; 6.16	25/08/99  PA	Ajout le support pour la squence PrPrinter (pour %%Routing).
; 6.15	05/08/97  PA	Ne s'auto-modifie plus (BackPost).
; 6.14	26/06/97  PA	Petites modifications.
; 6.13	12/03/97  PA	Ne modifie plus A2  l'installation. Petites modifications.
;			Excute SMA_PSTALK depuis le processus fils "IMPRIME".
;			Gre mieux la terminaison du fils (vite bombes si problmes 
;			l'installation).
; 6.12	22/01/97  PA	Supprim PPS_CACHE/UNCACHE pour librer automatiquement la
;			mmoire utilise par les jobs d'impression PostScript (PSDRIV).
; 6.11	25/10/96  PA	Ajout indication de fin de mot pour DRGLYPH.
; 6.10	..	  DD	PostScript avec fontes internes ok.
; -------------------------------------------------------------------------------------


Resol	=	10'300				; points par pouces
YetX	=	16'00010001

Xmm	=	10'50				; unit PAGE 1/50mm
Ymm	=	Xmm*16'10000			; idem pour Y

;;DimPage=	296*Ymm+210*Xmm			; dimension feuille A4 standard
;;GPoint=	(Xmm*254/10+Resol/4)/Resol	; dimension d'un point graph.
	;	50 up/mm 254/10 mm/pouce 1/300 pouce/pg



	.IDENT		"Pilote pour imprimantes PostScript. D.Dumoulin 1993"

	.LAYOUT		LENGTH 0

PcCode		=	0
PcDef		=	1

No_Pilote	= 	16'AE		; no bios pour le pilote
DefZoom		=	3


	.REV	MajRev, MinRev

BOA		= 	"\"
ImageEpsi	= 	16'81		; 1er caractre d'une image "normale"
ImageLami	= 	16'02		; 1er caractre d'une image avec entte binaire
ImageColor	=	16'82		; 1er caractre d'une image couleur Smaky

WordX		= 	2		; offset pour coordonne <y,x> en mmoire
WordY		= 	0

; Orientation possible pour le texte
DirGaucheDroite	= 	0		; normal, de gauche  droite
DirHautBas	= 	4		; couch, du haut vers le bas
DirDroiteGauche	= 	8		;  l'envers, de droite  gauche
DirBasHaut	= 	12		; couch, du bas vers le haut

LongPile	=	10'800

	.INS		PSVAR.ASI			; dfinition des variables

\g_ev;; Entte du pilote : 
;===================\g_Fond;

	.APC		PCCODE
	.LOC		0
BasePilote:
	.16		0,D0BASE			; Add fin entte pilote 0
	.16		2**7				; pas d'autre pilote

D0ID:							; Offset routine :
	.16		D0OPEN-D0BASE			; Open
	.16		D0COMMAND-D0BASE		; Command
	.16		D0RSTATUS-D0BASE		; Read status
	.16		-1				; Read
	.16		D0WRITE-D0BASE			; Write
	.16		D0CLOSE-D0BASE			; Close
	.16		D0STOPTR-D0BASE			; Stop
	.16		D0STARTR-D0BASE			; Start
	.16		D0AVOTR-D0BASE			; Avort
	.16		-1 ; D0INFO-D0BASE		; Auxiliaire 1 = Informations
	.16		-1				; Auxiliaire 2
	.16		D0RESET-D0BASE			; Reset
	.16		D0KILL-D0BASE			; Kill
	.16		-1				; 
	.16		-1				; 
	.16		-1				; 
D0NAB:
	.ASCII	 	"POST_0"			; Nom driver
D0NAF:	.FILL.8		LGDNAM-(D0NAF-D0NAB),0		; Rempli le reste avec des 0
	.8		NO_PILOTE			; Numro driver
	.8		TYPPRI				; Type : imprimante
	.8		MAJREV,MINREV			; Rvision - version
	.8		0				; Priorit dans driver
	.8		0				; no bios high

	.8		0				; Attribut 1
;	.8		2**BDWROK.OR.2**BDNORT		; Attribut 0
	.8		2**BDWROK			; Attribut 0

	.FILL.8		LGDDESC-(APC-D0ID),0		; Le reste avec des 0
D0BASE:


; Routines interfaces
; ===================

\g_titre;;-------\
; Reset  >
;=======/
\g_Fond;; Initialisation du pilote
;
; in	A2.32	^paramtres
; out	(A6.32	^variables locales)
;	D7.16	erreur
; mod	A6.32, D7.16
;
D0\g_ev;RESET\g_Fond;:
	PUSHM.32	A2..A5|D2..D6

	MOVE.32		#0,D6				; pas de fils en cours...
	MOVE.32		#R16^BasePilote,A4		; ^base du pilote
	MOVE.32		#LgVarPilote,D4			; long. variables voulues
	FOS		?GetComMem			; demande au FOS la mmoire
	JUMP,NE		ERR$

	GESMEM		?CLEARMEM			; profite de tout effacer...

	MOVE.32		A4,A6				; ^variables locales permanent

	CALL		InitParDis			; initialise paramtre cran
	JUMP,NE		Err$
	CALL		LoadStretch			; charge le module Stretch
	JUMP,NE		Err$
	CALL		InitStatusGra			; mmorise le ^bitmap et dimensions
	JUMP,NE		Err$

	MOVE.32		#{A6}+oPileData,A4
	MOVE.32		A4,{A6}+oPtPile
;	CLR.16		{A6}+oNiveauData

	PUSH.32		A2				; conserve le paramtre...

	MOVE.32		#0,D4
	NTREL		?CRESEM				; cre smaphore attente
	JUMP,NE		POP$

	MOVE.32		A5,{A6}+oSemaWaitJob		; attente pour travail

;	MOVE.32		#0,D4
	NTREL		?CRESEM				; cre smaphore attente
	JUMP,NE		POP$

	MOVE.32		A5,{A6}+oSemaWaitFini		; attente pour fin de travail

;	MOVE.32		#0,D4
	NTREL		?CRESEM				; cre smaphore attente
	JUMP,NE		POP$
	MOVE.32		A5,{A6}+oSemaKill		; attente pour fin de travail

	MOVE.32		#R16^NomLibPagePs$,A3
	MOVE.16		#PPS_FIRST,D3
	LIB_		OPEN				; installe la librairie
	JUMP,NE		POP$

	MOVE.16		D1,{A6}+oChLibPagePs

	CALL		StartFilsImprime		; dmarre le fils
	JUMP,NE		R8^POP$

Done$:	CALL		WaitFini

Pop$:	POP.32		A4				; ^paramtre installation
	JUMP,NE		R8^ERR$				; erreur => pas de commande
	TEST.8		{A4}				; commande existe ?
	JUMP,EQ		R8^ERR$				; non => termine ainsi

	CALL		D0\g_ev;Command\g_Fond;

ERR$:	TEST.16		D7				; y a-t-il eu une erreur ?
	JUMP,EQ		R8^OK$				; non => termine simplement

	CALL		KillFilsImprime			; tue le fils (si besoin)

OK$:	POPM.32		A2..A5|D2..D6
	RET


NomLibPagePs$:	.ASCIZ	"PAGEPS"			; librairie PPS_
		.EVEN


\g_titre;;------\
; Kill  >
;======/
\g_Fond;
; Dinstallation du pilote

; in	(A6.32	^variables locales)
; out	D7.16	erreur
; mod	D7.16

D0\g_ev;KILL\g_Fond;:
	pushm.32	A5|D4|A1|D1|D0

	move.32		#-1,D4
	Ntrel		?MODTIM

	CALL		KillFilsImprime
	CALL		GetErreurFatale
	push.16		d7

	tclr.8		{A6}+oFlgGeneral:#bgRunPagePs
	jump,bc		r8^nc$

;;PA	MOVE.16		#PPS_UNCACHE, D0
;;PA	PPS_		CONTROL				; libre le programme SMA_PSDRIV.CODE

nc$:
	move.16		{A6}+oChLibPagePs, D1
	LIB_		CLOSE				; libre la librairie

	move.32		#r16^D0Base, A1
	move.32		#MtypBD, D1
	move.32		{A6}+oPtStatusGra, A4
	Gesmem		?GivMem

	call		UnLoadStretch			; ferme le module stretch
\g_it;
\g_Fond;	Ntrel		?SETTIM				; remet le timeout user
	pop.16		d7				; le FOS rend tout seul la mmoire
Ret$:
	popm.32		A5|D4|A1|D1|D0
	Ret

\g_titre;;------\
; Open  >
;======/
\g_Fond;
; Ouverture du pilote pour imprimer/s'informer

; in	(A6.32	^variables locales)
; out	D7.16	erreur
; mod	D7.16

D0\g_ev;OPEN\g_Fond;:
	INC.16		{A6}+oCptUse		; une ouverture de plus
	JUMP		StartFilsImprime	; dmarre le fils (si ncessaire)



\g_titre;;-------\
; Close  >
;=======/
\g_Fond;
; Fermeture du pilote aprs impression

; in	(A6.32	^variables locales)
; out	D7.16	erreur
; mod	D7.16

D0\g_ev;CLOSE\g_Fond;:
	PUSH.32 	A5

	dec.16		{A6}+oCptUse			; une ouverture de moins
	jump,ne		r8^Ret$

	test.8		{A6}+oFecriture			; quelque chose d'crit ?
	jump,F		r8^Ret$

	clr.8		{A6}+oFecriture
	tset.8		{A6}+oFlgEtat:#bEtatAvorte	; idem stoppe impression
	tset.8		{A6}+oFlgEtat:#bEtatClose	; mais par fin normale

	move.32		{A6}+oSemaWaitJob, A5
	Ntrel		?SignEv				; signale le travail  finir
	call		WaitFini			; attend la fin du job

	tclr.8		{A6}+oFlgEtat:#bEtatClose
	call		GetErreurFatale
	comp.16		#erPSTO, d7
	jump,ne		r8^Ret$
	clr.16		d7

RET$:	POP.32		A5
	RET

\g_titre;;---------\
; Command  >
;=========/
\g_Fond;
; Demande d'une opration particulire au pilote

; in	(A6.32	^variables locales)
;	A4.32	^ligne de commande
; out	D7.16	erreur
; mod	D7.16

D0\g_ev;COMMAND\g_Fond;:
	pushm.32	A2..A5|D2..D6
	move.32		A4, A3
	dec.32		a3
Cherche$:
	comp.8		#"*", {A3}+1
	jump,eq		r8^Avance$
	move.32		#r16^tCommande, A0
	call		\g_ev;ChercheDansTableASCIZE
	\g_Fond;jump,eq		r8^Avance$
	move.16		#ErPCUK, D7
	jump		r8^Ret$
Avance$:
\g_ev;	\g_Fond;inc.32		A3
	move.8		{A3}, d3
	comp.8		#",", d3
	jump,eq		cherche$
	test.8		d3
	jump,ne		Avance$
	clr.16		d7
Ret$:
	popm.32		A2..A5|D2..D6
;	test.16		d7
	Ret

tCommande:
	.ascize		"b"				; version boa
	.16		RoutNop-APC			; toujours 1
	.ascize		"f"				; introducteur
	.16		RoutNop-APC			; toujours avec
	.ascize		"h"				; hauteur de la page
	.16		RoutHaut-APC			; comme \\haut;
	.ascize		"X"
	.16		x$-APC				; debug
	.ascize		"DZ"
	.16		dz$-APC				; dfaut zoom
	.ascize		"P"
	.16		p$-APC				; patch gnrateurs
	.ascize		"o"
	.16		RoutOrient-APC			; orientation
	.ascize		"FILS"
	.16		fils$-APC
	.16		0

x$:
	call		GetNum
	move.8		D4, {A6}+oFdebug
	clr.16		d7
	Ret
dz$:
	call		GetNum
	move.16		D4, {A6}+oDefZoom		; change le zoom par dfaut !
	move.16		D4, {A6}+oStatus+OPRDEFZ	; valeur par dfaut facteur de zoom
	Ret
p$:
	call		GetNum
	and.8		#1, d4
	xor.8		#1, d4
	move.8		D4, {A6}+oFnoPatch
	clr.16		d7
	Ret

fils$:
	JUMP		KillFilsImprime



; Demande la peau du processus d'impression.

; in	-
; out	-
; mod	-

KillFilsImprime:
	TCLR.8		{A6}+oDebug:#0			; y a-t-il un fils actif ?
	JUMP,F		R8^RET$				; non => pas besoin de le tuer

	PUSHM.32	D4|D7|A5

	MOVE.32		#-1,D4
	NTREL		?MODTIM

	TSET.8		{A6}+oFlgEtat:#bEtatKill	; tue le fils s.v.p.
	MOVE.32		{A6}+oSemaWaitJob,A5
	NTREL		?SIGNEV				; signale job  faire
	MOVE.32		{A6}+oSemaKill,A5
	NTREL		?WAITEV				; attend la mort du Fils
call	trappe
	NTREL		?SETTIM

	POPM.32		D4|D7|A5
RET$:	RET



; in	-
; out	D7.16
; mod	D7.16

StartFilsImprime:
	CLR.16		D7
	TSET.8		{A6}+oDebug:#0			; le fils tourne-t-il ?
	JUMP,T		R8^RET$				; oui => c'est tout

	PUSHM.32	D4|D5|A2|A3|A4|A5

	MOVE.32		{A6}+oSemaKill,A2		; ^smaphore  signaler  l'abort
	MOVE.32		#R16^ProcFilsImpr,A5		; ^processus fils d'impression
	MOVE.32		#R16^NomProcFils,A3		; ^nom du processus d'impression
	MOVE.32		#LongPile,D5			; taille de la pile du fils
	MOVE.32		#2**BTSIAB+2**BTNCHD+2**BTPROG+10'17,D4 ; faible priorit, pas un fils
	NTREL		?CRETASK			; excute le processus fils
	JUMP,EQ		R8^OK$

	CLR.8		{A6}+oDebug			; pas dmarr !

OK$:	POPM.32		D4|D5|A2|A3|A4|A5
RET$:	TEST.16		D7
	RET



\g_titre;;---------\
; Rstatus  >
;=========/
\g_Fond;; Demande d'information gnrale (compatible avec anciens pilotes)
;
; in	(A6.32	^variables locales)
;	A4.32	^buffer utilisateur
;	D4.32	longeur  remplir
; out	D4.32	longeur prise en compte
;	{A4}++	information retourne
;	D7.16	erreur
; mod	(A0.32), (D0.32), D4.32, D7.16
;
D0\g_ev;RSTATUS\g_Fond;:
	PUSH.32 	A4
	MOVE.32		#R16^L00$,A0			; ^longueurs possibles
	CALL		32^_CNVLGS			; contrle la longueur demande
	JUMP,NE		r8^Err$				; Longueur read status correcte	?  non => Err$
	CLR.16		D7

	Gesmem		?ClearMem			; vide le tampon utilisateur
	move.32		D4, D0

	move.32		#{A6}+oStatus, A0		; ^status courants
	dec.16		d0
copy$:
	move.8		{A0+}, {A4+}			; copie les status courants
	dj.16,nmo	d0, copy$

Err$:
	POP.32		A4
	RET

L00$:
	.16		LGPRI0
	.16		LGPRI1
	.16		LGPRI2
	.16		0



\g_titre;;------\
; Info  >
;======/
\g_Fond;
; Demande d'informations spcifiques

; in	(A6.32	^variables locales)
;	A3.32	^ligne de demande
;	A4.32	^buffer pour la rponse
;	D4.32	longueur de ce buffer
; out	D4.32	longueur utilise
;	{A4}++	information retourne
;	D7.16	erreur
; mod	D4.32, D7.16

;?D0\g_ev;INFO\g_Fond;:
;?	PUSH.32 	A3
;?	move.32		#r16^TableDemande, A0	; ^table des demandes possibles
;?	call		CallTable		; fait la routine correspondante
;?	POP.32		A3
;?	RET

TableDemande:
;?	.ASCIZE		"Chasse"		; demande la table de chasse d'un gencar
;?	.16		DonneChasse-APC
;?	.ASCIZE		"Liste"			; demande la liste des caractres
;?	.16		DonneListe-APC
;?	.8		0
;?	.EVEN


\g_ev;
\g_titre;;-------\
; Write  >
;=======/
\g_Fond;; Ecriture des donnes  imprimer
;
; in	(A6.32	^variables locales)
;	A4.32	^buffer  imprimer
;	(D5.32	longueur de ce buffer) <- fos D4.32
; out	(D5.32	longueur donnes crite) -> fos D4.32
;	D7.16	erreur
; mod	D7.16
;
D0\g_ev;WRITE\g_Fond;:
	pushm.32	A5|A3
	test.32		D5			; quelque chose  imprimer ?
	jump,eq		r8^Nop$			; Non -> quitte

	test.8		{A6}+oFecriture
	jump,T		r8^Cont$
	Fos		?GDIR			; dans quel dossier ?
	move.32		A3, {A6}+oRefDossier	; communique le nom au programme fils
	tclr.8		{A6}+oFlgEtat:#bEtatClose
Cont$:
	set.8		{A6}+oFecriture
	move.32		A4, {A6}+oPtData	; ^donnes  lire
	move.32		D5, {A6}+oLgData	; longueur  lire

	move.32		{A6}+oSemaWaitJob, A5
	Ntrel		?SignEv			; signale Job  Faire

	call		\g_ev;WaitFini\g_Fond;
	sub.32		{A6}+oLgData, D5	; total - reste = nombre imprim
	call		GetErreurFatale
Nop$:
	popm.32		A5|A3
	Ret

\g_titre;;--------\
; StopTr  >
;========/
\g_Fond;; Suspend l'impression jusqu' nouvel ordre
;
; in	(A6.32	^variables locales)
; out	D7.16	erreur
; mod	D7.16
;
D0\g_ev;STOPTR\g_Fond;:
	tset.8		{A6}+oFlgEtat:#bEtatSuspendu
	clr.16		d7
	Ret

\g_titre;;--------\
; StarTr  >
;========/
\g_Fond;; Reprend l'impression suspendue
;
; in	(A6.32	^variables locales)
; out	D7.16	erreur
; mod	D7.16
;
D0\g_ev;STARTR\g_Fond;:
	tclr.8		{A6}+oFlgEtat:#bEtatSuspendu
	clr.16		d7
	Ret

\g_titre;;--------\
; AvorTr  >
;========/
\g_Fond;; Coupe l'impression en cour
;
; in	(A6.32	^variables locales)
; out	D7.16	erreur
; mod	D7.16
;
D0\g_ev;AVOTR\g_Fond;:
	tset.8		{A6}+oFlgEtat:#bEtatAvorte
	tset.8		{A6}+oFlgEtat:#bEtatArret
	clr.16		d7
	Ret


\g_ev;GetErreurFatale\g_Fond;:
	tclr.8		{A6}+oFlgEtat:#bEtatErreur
	jump,bc		r8^Ret$
	move.16		{A6}+oErreurFatale, D7
Ret$:
	Ret


	.INS		PSUTILE.ASI
	.INS		PSIMPRIM.ASI
	.INS		PSGENCAR.ASI
	.INS		PSGESMEM.ASI
	.INS		PSBOA.ASI
	.INS		PSPARAM.ASI

\g_ev;WaitFini\g_Fond;:
	PUSHM.32	D4|A5
	MOVE.32		#-1,D4
	NTREL		?MODTIM				; attend longtemps
	MOVE.32		{A6}+oSemaWaitFini,A5
	NTREL		?WAITEV				; attend Fils prt
	PUSH.16		D7
	NTREL		?SETTIM				; remet le timeout
	POP.16		D7
	POPM.32		D4|A5
	RET


	.END

