\define g_Fond:\nef11;
\define g_titre:\m(f)17;
\define g_ev:\n(bf)12;
\define g_it:\n(if)07;
\define g_comment:\n(f)06;
\define g_Lynx:\kip15;
; $sma; $flg: 25410002 $erh:dprint

	.TITLE 		\g_titre;PRINT.ASD\g_Fond;

newNTREL	=	true

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; version		description
;;
;; 6.9	DD 30.09.98	accepte que PRINTA_ OPPRINT modifie D5 (nombre de copie mis  1)
;;

;****************************************************************************************
;*											*
;*	D R I V E R   D ' I M P R E S S I O N  S U R  B O I T E  A  L E T T R E S	*
;*											*
;****************************************************************************************
;
; Description de l'"install" :
;------------------------------
; Nlog  : Nom logique
; Nphys : Nom physique
;
; Install Nlog_print Nphys_Pilote
;
; Nlog_print	Nom logique pour l'impression
;
; Nphys_Pilote	Nom physique de ce Pilote
;

; NOUVELLE VERSION, utilise le module PRINTA_
;
; En gnral la commande d'installation est :
;   Install #PRINTER $PRINT
;

	.PROC		M68000			; CALM
	.REF		SMAKY			; Table de symboles...
	.REF		BIOSDRIV
	.REF		modules			; utilise le module PRINTA
	.ref		Mon

PRINTAX_?	= .high16.PRINTAX_AFIMP

.if	NewNtrel
MAJREV		= 	6			; Revision majeur
MINREV		= 	9			; Revision mineur

	.REV		MAJREV,MINREV		; Met revision dans entte binaire
	.IDENT		"Pilote d'impression ROM via module PRINTA. D.Dumoulin 88"
.else
MAJREV		= 	5			; Revision majeur
MINREV		= 	10			; Revision mineur

	.REV		MAJREV,MINREV		; Met revision dans entte binaire
	.IDENT		"Pilote d'impression via module PRINTA. D.Dumoulin 88"
.endif


\g_ev;; Assignation des PC : 
;----------------------
\g_Fond;PCCODE		= 0
PCVAR		= 1
PCOFFSET	= 2


; Initialisation des PC : 
;-------------------------
.APC		PCCODE
.LOC		0
.APC		PCVAR
.LOC		0
.APC		PCOFFSET
.LOC		0

.APC	PCVAR
OchPRINT:	.blk.32		1		; canal module PRINTA
OchLIBPRINT:	.blk.16		1		; canal de librairie "
ObuPRES:	.blk.8		lgNAME		; nom de la prsentation
OadPRINTAX:	.blk.32		1		; ^routine PRINTAX_
Oflags:		.blk.8		1
 BOPEN		=	0			; OPEN vient d'tre fait
	.EVEN
lgVAR0:


\g_titre;; Entte du pilote : 
;--------------------
\g_Fond;.APC	PCCODE
BASE:
	.16		0,D0BASE		; Add fin entte Pilote
	.16		2**7

\g_titre;;********************************************************
;	      P i l o t e      P R I N T _ 0
;********************************************************
\g_Fond;
D0ID:						; Offset routine :
	.16		D0OPEN-D0BASE		; Open
	.16		D0COMMAND-D0BASE	; Command
	.16		D0RSTATUS-D0BASE	; Read status
	.16		-1			; Read
	.16		D0WRITE-D0BASE		; Write
	.16		D0CLOSE-D0BASE		; Close
	.16		D0STOPTR-D0BASE		; Stop
	.16		D0STARTR-D0BASE		; Start
	.16		D0AVOTR-D0BASE		; Avort
	.16		-1			; Auxiliaire 1
	.16		-1			; Auxiliaire 2
	.16		D0RESET-D0BASE		; Reset
	.16		D0KILL-D0BASE		; Kill
	.16		-1			; 
	.16		-1			; 
	.16		-1			; 
D0NAB:
	.ASCII		"PRINT_0"		; Nom Pilote
D0NAF:	.FILL.8 	LGDNAM-(D0NAF-D0NAB), 0	; Renpli le reste avec des 0
	.8		16'AF			; Numro Pilote
	.8		TYPPRI			; Type : imprimante
	.8		MAJREV,MINREV		; Rvision - version
	.8		8			; Priorit dans Pilote
	.8		0			; Numro pilote Hight
	.8		0			; Attribut 1
	.8		2**BDWROK.or.2**BDNORT	; Attribut 0
	.FILL.8		LGDDESC-(APC-D0ID), 0	; Le reste avec des 0
D0BASE:



;*************************************************************************
;	C o d e   d  u   D r i v e r      P R I N T
;*************************************************************************

; dfinition constantes :
;-------------------------

; ERREUR
;-------

ERBFULL		=	16'0509				; Erreur buffer full



;========================================================================================
;=				   C O D E   D R I V E R				=
;========================================================================================
.APC	PCCODE

; Appels Pilote PRINT_0
;**********************

.if	false
test:
	pushm.32	a3|a4
trap	#1
	move.32		#5, D4
	move.32		#16'41424344, {A4+}
	clr.8		{A4+}
c$:
	inc.32		D4
	move.8		{A3+}, {A4+}
	jump,ne		c$
	popm.32		a3|a4
	ret
.endif

\g_titre;;------------\
;     RESET	>
;------------/
\g_Fond;
; 	IN	A2.32 : ^paramtres ligne de commande
; 	OUT	D7.16 : Erreur
; 	MOD	D0.32 , D1.32 , D7.16 , A0.32 , A1.32

D0RESET:
.if	newNTREL
	pushm.32	A3|D3|A2|A4|D4
.else
  	pushm.32	A3|D3|A2|A4|D4|A6
.endif
	move.32		#r16^BASE, A4
	move.32		#lgVAR0, D4
	FOS		?GETcomMEM
	jump,ne		ERR$
	move.32		A4, A6

	move.32		#r16^nPRINT$, A3
	move.32		#PRINTA_FIRST, D3
	LIB_		OPEN				; ouvre le module PRINTA
	jump,ne		r8^RET$
	move.16		D1, {A6}+OchLIBPRINT
	Move.32		#0, D3

	move.16		#PRINTAX_?, D3			; point d'entre PRINTAX_...
	LIB_		GETAD				; ^routine
	JUMP,NE		RET$
	move.32		A3, {A6}+OadPRINTAX
ERR$:
RET$:
.if	newNTREL
	popm.32		A3|D3|A2|A4|D4
.else
	popm.32		A3|D3|A2|A4|D4|A6
.endif
	RET
nPRINT$:
	.ascize		"PRINTA"


\g_titre;;------------\
;     KILL	>
;------------/
\g_Fond;
; 	IN
; 	OUT	D7.16 : Erreur
; 	MOD	D0.32 , D1.32 , D7.16 , A0.32 , A1.32

D0KILL:
.if	newNTREL
	pushm.32	A2|D1|A4|D4
.else
	pushm.32	A2|D1|A4|D4|A6
	move.32		#r16^BASE, A4
	move.32		#lgVAR0, D4
	FOS		?GETcomMEM
	jump,ne		ERR$
	move.32		A4, A6
.endif
	Move.16		{A6}+OchLIBPRINT, D1
	LIB_		CLOSE
	clr.16		D7
ERR$:
.if	newNTREL
	popm.32		A2|D1|A4|D4
.else
	popm.32		A2|D1|A4|D4|A6
.endif
	RET


\g_titre;;------------\
;     OPEN	>
;------------/
\g_Fond;
; 	IN
; 	OUT	D7.16 : Erreur
; 	MOD	D0.32 , D1.32 , D7.16 , A0.32 , A1.32

D0OPEN:
.if	newNTREL
	pushm.32	A4|D4|A3
.else
	pushm.32	A4|D4|A6|A3
	move.32		#r16^BASE, A4
	move.32		#lgVAR0, D4
	FOS		?GETcomMEM
	jump,ne		ERR$
	move.32		A4, A6
.endif

	TSET.8		{A6}+OFLAGS:#BOPEN		; OPEN vient d'tre fait!
	clr.16		D7
ERR$:
RET$:
.if	newNTREL
	popm.32		A4|D4|A3
.else
	popm.32		A4|D4|A6|A3
.endif
	RET


\g_titre;;------------\
;    RSTATUS	>
;------------/
\g_Fond;
; 	IN	A4.32 : ^buffer
;		D4.32 : Nombre de bytes  lire
; 	Out	D4.32 : Longueur lue effectivement
;		D7.16 : Erreur
; 	MOD	D0.32 , D1.32 , D4.32 , D7.16 , A0.32 , A1.32

D0RSTATUS:
.if	newNTREL
	PUSHM.32	A2|A4|D4|D3
.else
	PUSHM.32	A2|A4|D4|A6|D3
	pushm.32	A4|D4
	move.32		#r16^BASE, A4
	move.32		#lgVAR0, D4
	FOS		?GETcomMEM
	move.32		A4, A6
	popm.32		A4|D4
	jump,ne		ERR$
.endif
	move.32		#2**BprLOCAL, D3
	call		OpenPrintA
	jump,ne		r8^Ret$

	PRINTA_		RSTATUS				; demande les status  PRINTA
	comp.16		#erKSTO, D7
	jump,ne		r8^RET$
	move.16		#erNSERV, D7			; station non serveur !
RET$:
ERR$:
.if	newNTREL
	POPM.32		A2|A4|D4|D3
.else
	POPM.32		A2|A4|D4|A6|D3
.endif
	RET


\g_titre;;------------\
;   COMMAND	>
;------------/
\g_Fond;
; La commande est envoye au Pilote LOCAL pour ne pas avoir de blocage sur les rseaux
; elle ne modifiera PAS le status de l'imprimante relle


; 	IN	A4.32 : ^table des commandes termine par <0>
; 	OUT	D7.16 : Erreur
; 	MOD	D0.32 , D1.32 , D7.16 , A0.32 , A1.32

D0COMMAND:
.if	newNTREL
	PUSHM.32	A2|A3|A4|D4|D3
.else
	PUSHM.32	A2|A3|A4|D4|A6|D3
	ex.32		A4,A6
	move.32		#r16^BASE, A4
	move.32		#lgVAR0, D4
	FOS		?GETcomMEM
	ex.32		A4,A6
	jump,ne		ERR$
.endif
	move.32		#0, D3	
	call		OpenPrintA
	jump,ne		r8^Ret$

	move.32		A4, A3

.if	false
L$:
	test.8		{A3+}
	jump,eq		r8^B$
	comp.8		#"_", {A3}-1			; soulign dans le nom ?
	jump,ne		L$
	move.8		#SPACE, {A3}-1			; rtabli les espaces
	jump		L$
B$:
	move.32		A4, A3
.endif

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; routine remplace
;;;;	PRINTAX_	PUTPRES				; slectionne cette prsentation
;;;;	PRINTAX_ ne fonctionne pas en mode superviseur !!!
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	move.32		{A6}+OadPRINTAX, A0		; ^routine PRINTAX_
	call		{A0}				; fait l'appel  la routine
	.16		PRINTAX_PUTPRES.and.16'FFFF	; identifie PRINTAX_ PUTPRES
	jump,eq		r8^RET$
	MOVE.16		#erPCUK, D7			; commande inconnue
RET$:
ERR$:
.if	newNTREL
	POPM.32		A2|A3|A4|D4|D3
.else
	POPM.32		A2|A3|A4|D4|A6|D3
.endif
	RET



\g_titre;;------------\
;    WRITE	>
;------------/
\g_Fond;
; 	IN	A4.32 : ^ la zone mmoire
;		D5.32 : Lg  crire
; 	OUT	D5.32 : Lg effectivement crite
;		D7.16 : Erreur
; 	MOD	D0.32 , D1.32 , D7.16 , A0.32 , A1.32

D0WRITE:
.if	newNTREL
	PUSHM.32	D4|A2|A4|D3
.else
	PUSHM.32	D4|A2|A4|A6|D3

	ex.32		A6, A4
	move.32		#r16^BASE, A4
	move.32		#lgVAR0, D4
	FOS		?GETcomMEM
	ex.32		A6, A4
	jump,ne		ERR$
.endif

	TCLR.8		{A6}+OFLAGS:#BOPEN		; OPEN vient d'tre fait?
	jump,bc		r8^WR$				; non -> crit encore

	move.32		#2**BprLOCAL, D3	
	call		OpenPrintA
	jump,ne		Err$

	pushm.32	D2|D3|A3..A5|D5
	NTREL		?GTPNAM				; nom du processus -> A3
	move.32		A3, A5
	move.32		#2**BprIMPRIME+2**BprSILENCE+2**BprSIMULTANE, D3
	move.32		#r16^nDOC$, A3
	move.32		#{A6}+ObuPRES, A4
	clr.8		{A4}				; prsentation courante
	clr.32		D2
	PRINTA_		OPPRINT				; dbut d'impression PRINT

	popm.32		D2|D3|A3..A5|D5
	jump,ne		r8^ERR$
WR$:
	move.32		{A6}+OchPRINT, A2
	MOVE.32		D5,D4				; Lg donnes	-> D4

	PRINTA_		WRPRINT				; fait l'impression
ERR$:
.if	newNTREL
	POPM.32		D4|A2|A4|D3
.else
	POPM.32		D4|A2|A4|A6|D3
.endif
	RET

nDOC$:	.ascize		"#PRINTER"


\g_titre;;------------\
;     CLOSE	>
;------------/
\g_Fond;;   Envoie l'entte lancant l'impression si on a crit dans le Pilote

; 	IN	A0.32	^variables
; 	OUT	D7.16 : Erreur
; 	MOD	D0.32 , D1.32 , D7.16 , A0.32 , A1.32

D0CLOSE:
	clr.16		D7
.if	newNTREL
	PUSHM.32	A2|A4|D4
.else
	PUSHM.32	A2|A4|D4|A6

	move.32		#r16^BASE, A4
	move.32		#lgVAR0, D4
	FOS		?GETcomMEM
	jump,ne		ERR$
	move.32		A4, A6
.endif
	move.32		{A6}+OchPRINT, A2
	TCLR.8		{A6}+OFLAGS:#BOPEN		; OPEN vient d'tre fait?
	JUMP,BS		r8^Clo$
	PRINTA_		CLPRINT				; termine l'impression
Clo$:
	test.32		{A6}+oChPRINT
	jump,eq		r8^Ret$

	PRINTA_		CLOSE				; referme la librairie PRINTA
	clr.32		{A6}+OchPRINT
RET$:
ERR$:
.if	newNTREL
	POPM.32		A2|A4|D4
.else
	POPM.32		A2|A4|D4|A6
.endif
	RET



\g_titre;;------------\
;     AVOTR	>
;------------/
\g_Fond;;    

; 	IN	A0.32	^variables
; 	OUT	D7.16 : Erreur
; 	MOD	D0.32 , D1.32 , D7.16 , A0.32 , A1.32

D0AVOTR:
	pushm.32	A3|D3|D6|A4
	move.32		#r16^Print_out, A3
	move.32		#2**bOpExtend+2**bOpRstatus, d3
	Fos		?ARGSOPEN
	jump,ne		r8^Ret$
	Fos		?AVORT, ?CLOSE

	move.32		#r16^PS_ABORT, A3
	move.32		#r16^Nil, A4
	clr.16		D3
	FOS		?ASSIGN			; tue l'impression postscripte !
Ret$:
	popm.32		A3|D3|D6|A4
	clr.16		D7
	RET

Print_out:
	.ascii		"#Print_Out"
nil:	.8		0
PS_ABORT:
	.ascize		"#PSTALK_ABORT"


\g_titre;;------------\
;    STOPTR	>
;------------/
\g_Fond;;

; 	IN	A0.32	^variables
; 	OUT	D7 : Erreur
;	MOD	D0.32 , D1.32 , D7.16 , A0.32 , A1.32

D0STOPTR:
	RET



\g_titre;;------------\
;    STARTR	>
;------------/
\g_Fond;;   

; 	IN	A0.32	^variables
; 	OUT	D7.16 : Erreur
; 	MOD	D0.32 , D1.32 , D7.16 , A0.32 , A1.32

D0STARTR:
	RET


OpenPrintA:
	clr.16		d7
	test.32		{A6}+oChPrint
	jump,ne		r8^Ret$

	PRINTA_		OPEN				; l'initialise
	jump,ne		r8^RET$
	move.32		A2, {A6}+OchPRINT
Ret$:
	move.32		{A6}+OchPRINT, A2
	test.16		D7
	Ret


.END
